/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.data.imagery;

import edu.wisc.ssec.mcidas.AREAnav;
import edu.wisc.ssec.mcidas.AreaDirectory;
import edu.wisc.ssec.mcidas.AreaFile;
import java.awt.geom.Rectangle2D;
import java.io.RandomAccessFile;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.swing.JOptionPane;
import ucar.unidata.data.DataCategory;
import ucar.unidata.data.DataChoice;
import ucar.unidata.data.DataSelection;
import ucar.unidata.data.DataSourceDescriptor;
import ucar.unidata.data.DataUtil;
import ucar.unidata.data.DerivedDataChoice;
import ucar.unidata.data.GeoLocationInfo;
import ucar.unidata.data.GeoSelection;
import ucar.unidata.data.imagery.AddeImageDataSelection;
import ucar.unidata.data.imagery.AddeImageDescriptor;
import ucar.unidata.data.imagery.AddeImageInfo;
import ucar.unidata.data.imagery.BandInfo;
import ucar.unidata.data.imagery.ImageDataSelectionInfo;
import ucar.unidata.data.imagery.ImageDataSource;
import ucar.unidata.data.imagery.ImageDataset;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.idv.IdvPersistenceManager;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import visad.Data;
import visad.VisADException;
import visad.data.mcidas.AREACoordinateSystem;
import visad.data.mcidas.AreaAdapter;

public class AddeImageDataSource
extends ImageDataSource {
    private String source;
    AddeImageDescriptor descriptor;
    protected List<DataChoice> stashedChoices = null;
    private String choiceName;
    AREAnav baseAnav = null;
    AreaAdapter areaAdapter = null;
    int eMag;
    int lMag;
    int eleMag = 0;
    int lineMag = 0;
    int elFactor = 1;
    public static final String SPACING_BRIT = "1";
    public static final String SPACING_NON_BRIT = "4";
    private Boolean showPreview = Boolean.FALSE;
    private AREACoordinateSystem acs;
    BandInfo bandId;
    Hashtable allBandDirs;
    protected AddeImageDataSelection addeImageDataSelection;

    public AddeImageDataSource() {
    }

    public AddeImageDataSource(DataSourceDescriptor descriptor, String image, Hashtable properties) throws VisADException {
        super(descriptor, new String[]{image}, properties);
    }

    public AddeImageDataSource(DataSourceDescriptor descriptor, String[] images, Hashtable properties) throws VisADException {
        super(descriptor, images, properties);
    }

    public AddeImageDataSource(DataSourceDescriptor descriptor, List images, Hashtable properties) throws VisADException {
        super(descriptor, images, properties);
    }

    public AddeImageDataSource(DataSourceDescriptor descriptor, ImageDataset ids, Hashtable properties) throws VisADException {
        super(descriptor, ids, properties);
        List descs = ids.getImageDescriptors();
        AddeImageDescriptor aid = (AddeImageDescriptor)descs.get(0);
        this.source = this.getPreviewSource(aid.getSource(), aid.getDirectory());
        this.allBandDirs = (Hashtable)properties.get("allBands");
        this.descriptor = aid;
        ArrayList oj = (ArrayList)properties.get("bandinfo");
        if (oj != null) {
            this.bandId = (BandInfo)oj.get(0);
        }
    }

    @Override
    public void initAfterUnpersistence() {
        super.initAfterUnpersistence();
        if (this.getTmpPaths() != null) {
            return;
        }
        if (this.source == null && this.imageList != null && this.imageList.size() > 0) {
            List descriptors = super.getDescriptors(super.findDataChoice(this.choiceName), null);
            AddeImageDescriptor desc1 = (AddeImageDescriptor)descriptors.get(0);
            this.source = desc1.getSource();
            this.allBandDirs = (Hashtable)this.getProperties().get("allBands");
            ArrayList oj = (ArrayList)this.getProperties().get("bandinfo");
            if (oj != null) {
                this.bandId = (BandInfo)oj.get(0);
            }
            AreaDirectory thisDir = desc1.getDirectory();
            this.source = this.getPreviewSource(this.source, thisDir);
            if (oj != null) {
                this.source = AddeImageDataSource.replaceKey(this.source, "BAND", Integer.toString(this.bandId.getBandNumber()));
            }
            this.descriptor = new AddeImageDescriptor(thisDir, null);
        }
    }

    @Override
    protected Data getDataInner(DataChoice dataChoice, DataCategory category, DataSelection dataSelection, Hashtable requestProperties) throws VisADException, RemoteException {
        this.choiceName = dataChoice.getName();
        if (this.choiceName != null) {
            // empty if block
        }
        return super.getDataInner(dataChoice, category, dataSelection, requestProperties);
    }

    protected String getUnitString(String description) {
        if (description.contains("Brightness")) {
            return "BRIT";
        }
        if (description.contains("Raw")) {
            return "RAW";
        }
        if (description.contains("Albedo")) {
            return "ALB";
        }
        if (description.contains("Temperature")) {
            return "TEMP";
        }
        if (description.contains("Prod")) {
            return "PROD";
        }
        if (description.contains("Radiance")) {
            return "RAD";
        }
        if (description.contains("Vip level")) {
            return "VIP";
        }
        if (description.contains("Vertical h2o")) {
            return "H2O";
        }
        if (description.contains("Echo")) {
            return "TOPS";
        }
        if (description.contains("Hydrometeor")) {
            return "CLAS";
        }
        if (description.contains("Rsp1")) {
            return "RSP1";
        }
        if (description.contains("Precipitation")) {
            return "RAIN";
        }
        return null;
    }

    @Override
    protected List getDescriptors(DataChoice dataChoice, DataSelection subset) {
        List descriptors = super.getDescriptors(dataChoice, subset);
        GeoSelection geoSelection = subset.getGeoSelection();
        boolean isProgressiveResolution = true;
        boolean fromBundle = this.getIdv().getStateManager().getProperty("idv.loadingxml", false);
        String t1 = subset.getProperty("Region_Selection_Option", "Use_Default_Area");
        String navType = subset.getProperty("navType", "X");
        String unitStr = this.getUnitString(dataChoice.getDescription());
        if (fromBundle) {
            String ver = IdvPersistenceManager.getBundleIdvVersion();
            if (ver == null || Character.getNumericValue(ver.charAt(0)) < 5) {
                this.source = ((AddeImageDescriptor)descriptors.get(0)).getSource();
                this.initOldBundle(dataChoice, descriptors, this.source);
            } else {
                String zpath1;
                AddeImageDescriptor desc1 = (AddeImageDescriptor)descriptors.get(0);
                this.source = desc1.getSource();
                this.allBandDirs = (Hashtable)this.getProperties().get("allBands");
                ArrayList oj = (ArrayList)this.getProperties().get("bandinfo");
                if (oj != null) {
                    this.bandId = (BandInfo)oj.get(0);
                }
                if ((zpath1 = (String)this.getIdv().getStateManager().getProperty("idv.zidvpath")) != null && zpath1.length() > 0) {
                    return descriptors;
                }
                AreaDirectory thisDir = desc1.getDirectory();
                this.source = this.getPreviewSource(this.source, thisDir);
                if (oj != null) {
                    this.source = AddeImageDataSource.replaceKey(this.source, "BAND", Integer.toString(this.bandId.getBandNumber()));
                }
                this.descriptor = new AddeImageDescriptor(thisDir, null);
                ArrayList dataSelectionComponents = new ArrayList();
                this.initDataSelectionComponents((List)dataSelectionComponents, super.findDataChoice(this.choiceName));
            }
            if (this.baseAnav == null) {
                try {
                    this.areaAdapter = new AreaAdapter(this.source, false);
                    AreaFile areaFile = this.areaAdapter.getAreaFile();
                    this.baseAnav = areaFile.getNavigation();
                    this.acs = new AREACoordinateSystem(areaFile);
                    ArrayList dataSelectionComponents = new ArrayList();
                    this.initDataSelectionComponents((List)dataSelectionComponents, super.findDataChoice(this.choiceName));
                }
                catch (Exception e) {
                    LogUtil.userErrorMessage("Error in getDescriptors  e=" + e);
                }
            }
            if (ver == null || Character.getNumericValue(ver.charAt(0)) < 5) {
                return descriptors;
            }
        }
        int dlMag = 0;
        int deMag = 0;
        isProgressiveResolution = subset.getProperty("Use_Progressive_Resolution", true);
        if (this.addeImageDataSelection != null) {
            if (fromBundle && !isProgressiveResolution) {
                dlMag = this.getLineMag();
                deMag = this.getEleMag();
                this.addeImageDataSelection.getAdvancedPanel().setLineMagSlider(dlMag);
                this.addeImageDataSelection.getAdvancedPanel().setElementMagSlider(deMag);
            } else if (!isProgressiveResolution) {
                dlMag = this.addeImageDataSelection.getAdvancedPanel().getLineMagValue();
                deMag = this.addeImageDataSelection.getAdvancedPanel().getElementMagValue();
            }
        }
        if (geoSelection != null) {
            Rectangle2D rect = geoSelection.getScreenBound();
            ImageDataSelectionInfo adSource = (ImageDataSelectionInfo)subset.getProperty("advancedURL");
            if (geoSelection.getBoundingBox() == null && adSource != null) {
                int lines = adSource.getLines() * Math.abs(adSource.getLineMag());
                int elems = adSource.getElements() * Math.abs(adSource.getElementMag());
                String locationKey = adSource.getLocateKey();
                String locationValue = adSource.getLocateValue();
                String place = adSource.getPlaceValue();
                if (isProgressiveResolution) {
                    this.lineMag = this.calculateMagFactor(lines, (int)rect.getHeight());
                    if (isProgressiveResolution && navType.equals("LALO")) {
                        this.lineMag = this.lineMag >= 2 ? this.lineMag / 2 : 1;
                    }
                    this.eleMag = this.lineMag * this.elFactor;
                } else {
                    this.eleMag = Math.abs(deMag);
                    this.lineMag = Math.abs(dlMag);
                }
                int newLines = this.lineMag == 1 ? lines : (int)Math.floor((double)(lines / this.lineMag) + 0.5);
                int newelems = this.eleMag == 1 ? elems : (int)Math.floor((double)(elems / this.eleMag) + 0.5);
                try {
                    descriptors = AddeImageDataSource.reSetImageDataDescriptor(descriptors, locationKey, locationValue, place, newLines, newelems, this.lineMag, this.eleMag, unitStr, navType);
                }
                catch (Exception exception) {}
            } else if (t1.equals("Match_Display_Area") || geoSelection.getBoundingBox() != null || geoSelection.getUseViewBounds()) {
                double maxLat = geoSelection.getBoundingBox().getMaxLat();
                double minLat = geoSelection.getBoundingBox().getMinLat();
                double maxLon = geoSelection.getBoundingBox().getMaxLon();
                double minLon = geoSelection.getBoundingBox().getMinLon();
                maxLat = maxLat > 90.0 ? 90.0 : maxLat;
                minLat = minLat < -90.0 ? -90.0 : minLat;
                maxLon = maxLon >= 180.0 ? 180.0 : maxLon;
                minLon = minLon < -180.0 ? -180.0 : minLon;
                GeoLocationInfo mapInfo = new GeoLocationInfo(maxLat, minLon, minLat, maxLon);
                LatLonPointImpl llp = (LatLonPointImpl)subset.getProperty("centerPosition");
                if (llp != null) {
                    BandInfo id = (BandInfo)dataChoice.getId();
                    int[] dir = null;
                    AreaDirectory thisDir = null;
                    thisDir = this.allBandDirs != null ? (AreaDirectory)this.allBandDirs.get(id.getBandNumber()) : this.descriptor.getDirectory();
                    dir = thisDir.getDirectoryBlock();
                    GeoLocationInfo ginfo = this.getImageBoundingBox(this.eMag, this.lMag, dir[8], dir[9]);
                    if (ginfo.getLatLonRect().containedIn(mapInfo.getLatLonRect())) {
                        int lines = dir[8];
                        int elems = dir[9];
                        int cline = lines / 2;
                        int celem = elems / 2;
                        String locateValue = cline + " " + celem;
                        if (isProgressiveResolution && navType.equals("LALO")) {
                            this.lineMag = this.calculateMagFactor(lines, (int)rect.getHeight());
                            this.lineMag = this.lineMag >= 2 ? this.lineMag / 2 : 1;
                            this.eleMag = this.lineMag * this.elFactor;
                        } else if (isProgressiveResolution) {
                            this.eleMag = this.calculateMagFactor(elems, (int)rect.getWidth());
                            this.lineMag = this.eleMag / this.elFactor;
                        } else {
                            this.eleMag = Math.abs(deMag);
                            this.lineMag = Math.abs(dlMag);
                        }
                        int newLines = this.lineMag == 1 ? lines : (int)Math.floor((double)(lines / this.lineMag) + 0.5);
                        int newelems = this.eleMag == 1 ? elems : (int)Math.floor((double)(elems / this.eleMag) + 0.5);
                        try {
                            descriptors = AddeImageDataSource.reSetImageDataDescriptor(descriptors, "LINELE", locateValue, "CENTER", newLines, newelems, this.lineMag, this.eleMag, unitStr, navType);
                        }
                        catch (Exception exception) {}
                    } else {
                        LatLonRect bbox = mapInfo.getLatLonRect().intersect(ginfo.getLatLonRect());
                        if (mapInfo.getLatLonRect().containedIn(ginfo.getLatLonRect())) {
                            bbox = mapInfo.getLatLonRect();
                        }
                        if (bbox == null) {
                            bbox = mapInfo.getLatLonRect();
                        } else {
                            boolean con = ginfo.getLatLonRect().contains(llp);
                            if (!con) {
                                llp = new LatLonPointImpl(thisDir.getCenterLatitude(), thisDir.getCenterLongitude());
                            }
                        }
                        maxLat = bbox.getLatMax();
                        minLat = bbox.getLatMin();
                        maxLon = bbox.getLonMax();
                        minLon = bbox.getLonMin();
                        if (mapInfo.getMinLon() > 0.0 && mapInfo.getMaxLon() < 0.0 && maxLon > 0.0) {
                            maxLon = mapInfo.getMaxLon();
                        }
                        descriptors = this.geoSpaceSubsetD(geoSelection.getScreenBound(), unitStr, this.eMag, this.lMag, this.baseAnav, descriptors, maxLat, minLat, maxLon, minLon, this.elFactor, dlMag, deMag, "CENTER", isProgressiveResolution, llp, navType);
                    }
                }
            }
        }
        String magValue = "";
        if (this.eleMag >= 1 || this.lineMag >= 1) {
            magValue = DataUtil.makeSamplingLabel(this.eleMag, this.lineMag, "pixel");
        }
        dataChoice.setProperty("MAG", magValue);
        if (fromBundle) {
            return descriptors;
        }
        Hashtable<String, List> dp = new Hashtable<String, List>();
        dp.put("descriptorsToSave", descriptors);
        dataChoice.setProperties(dp);
        return descriptors;
    }

    public GeoLocationInfo getImageBoundingBox(int eMag, int lMag, int lines, int elems) {
        double maxLat = 0.0;
        double minLat = 0.0;
        double maxLon = 0.0;
        double minLon = 0.0;
        double[][] el = new double[2][1];
        int eSize = elems / eMag;
        int lSize = lines / lMag;
        try {
            int i = 0;
            int j = 0;
            el[0][0] = i;
            el[1][0] = j;
            double[][] ll = this.baseAnav.toLatLon(el);
            while (ll[0][0] != ll[0][0] && i < eSize && j < lSize) {
                el[0][0] = ++i;
                el[1][0] = ++j;
                ll = this.baseAnav.toLatLon(el);
            }
            minLon = ll[0][0] != ll[0][0] ? -180.0 : ll[1][0];
            i = eSize;
            j = lSize;
            el[0][0] = i;
            el[1][0] = j;
            ll = this.baseAnav.toLatLon(el);
            while (ll[0][0] != ll[0][0] && i > 0 && j > 0) {
                el[0][0] = --i;
                el[1][0] = --j;
                ll = this.baseAnav.toLatLon(el);
            }
            maxLon = ll[0][0] != ll[0][0] ? 180.0 : ll[1][0];
            i = eSize / 2;
            j = 0;
            el[0][0] = i;
            el[1][0] = j;
            ll = this.baseAnav.toLatLon(el);
            while (ll[0][0] != ll[0][0] && j < lSize) {
                el[0][0] = i;
                el[1][0] = ++j;
                ll = this.baseAnav.toLatLon(el);
            }
            maxLat = ll[0][0] != ll[0][0] ? 90.0 : ll[0][0];
            i = eSize / 2;
            j = lSize;
            el[0][0] = i;
            el[1][0] = j;
            ll = this.baseAnav.toLatLon(el);
            while (ll[0][0] != ll[0][0] && j > 0) {
                el[0][0] = i;
                el[1][0] = --j;
                ll = this.baseAnav.toLatLon(el);
            }
            minLat = ll[0][0] != ll[0][0] ? -90.0 : ll[0][0];
        }
        catch (Exception e) {
            System.out.println("convertToLatLon e=" + e);
        }
        return new GeoLocationInfo(maxLat, minLon, minLat, maxLon);
    }

    public int getEleMag() {
        return this.eleMag;
    }

    public int getLineMag() {
        return this.lineMag;
    }

    public void setEleMag(int mag) {
        this.eleMag = mag;
    }

    public void setLineMag(int mag) {
        this.lineMag = mag;
    }

    public String getPreviewSource(String inSource, AreaDirectory aDir) {
        String outSource = inSource;
        int[] dir = aDir.getDirectoryBlock();
        int inLine = dir[8];
        int inElem = dir[9];
        int inLineMag = 1;
        int inElemMag = 1;
        if (aDir.getCenterLatitudeResolution() == aDir.getCenterLatitudeResolution()) {
            this.elFactor = (int)Math.ceil(aDir.getCenterLatitudeResolution() / aDir.getCenterLongitudeResolution() - 0.5);
        }
        String navType = AddeImageDataSource.getKey(inSource, "NAV");
        int lineFactor = 1;
        int elemFactor = 1;
        int outElem = inElem;
        int outLine = inLine;
        if (navType.equals("LALO")) {
            while (outLine > 450) {
                outLine = inLine / ++lineFactor;
            }
            inElemMag = (inLineMag *= lineFactor) / this.elFactor;
            if (inElemMag == 0) {
                inElemMag = 1;
            }
            outElem = inElem / inElemMag;
        } else {
            while (outElem > 450) {
                outElem = inElem / ++elemFactor;
            }
            inLineMag = (inElemMag *= elemFactor) / this.elFactor;
            if (inLineMag == 0) {
                inLineMag = 1;
            }
            outLine = inLine / inLineMag;
        }
        int cline = inLine / 2;
        int celem = inElem / 2;
        this.eMag = inElemMag;
        this.lMag = inLineMag;
        String locateValue = cline + " " + celem;
        String magStr1 = "-" + String.valueOf(inLineMag) + " " + "-" + String.valueOf(inElemMag);
        String sizeStr1 = String.valueOf(outLine) + " " + String.valueOf(outElem);
        outSource = AddeImageDataSource.replaceKey(outSource, "UNIT", "BRIT");
        outSource = AddeImageDataSource.replaceKey(outSource, "MAG", magStr1);
        outSource = AddeImageDataSource.replaceKey(outSource, "SIZE", sizeStr1);
        outSource = AddeImageDataSource.replaceKey(outSource, "PLACE", "CENTER");
        String key0 = AddeImageDataSource.getKey(outSource, "LATLON");
        outSource = key0 != null && key0.length() > 2 ? AddeImageDataSource.replaceKey(outSource, "LATLON", "LINELE", locateValue) : AddeImageDataSource.replaceKey(outSource, "LINELE", locateValue);
        return outSource;
    }

    @Override
    public String getImageDataSourceName() {
        return "Adde Image Data Source";
    }

    @Override
    public String getDataName() {
        String dataName = this.getProperty("data name", null);
        if (dataName == null) {
            dataName = this.getProperty("dataname", null);
        }
        if (dataName == null || dataName.trim().equals("")) {
            dataName = super.getDataName();
        }
        return dataName;
    }

    @Override
    protected List saveDataToLocalDisk(String prefix, Object loadId, boolean changeLinks) throws Exception {
        List newFiles = super.saveDataToLocalDisk(prefix, loadId, changeLinks);
        if (newFiles == null) {
            return newFiles;
        }
        for (int i = 0; i < newFiles.size(); ++i) {
            try {
                RandomAccessFile to = new RandomAccessFile((String)newFiles.get(i), "rw");
                to.seek(0L);
                to.writeInt(0);
                to.close();
                continue;
            }
            catch (Exception e) {
                System.out.println("unable to set first word to 0");
            }
        }
        return newFiles;
    }

    @Override
    protected void addDataChoice(DataChoice choice) {
        super.addDataChoice(choice);
        if (this.stashedChoices == null) {
            this.stashedChoices = new ArrayList<DataChoice>();
        }
        this.stashedChoices.add(choice);
    }

    public String getChoiceName() {
        return this.choiceName;
    }

    public void setChoiceName(String choiceName) {
        this.choiceName = choiceName;
    }

    private static String makeBandParam(BandInfo bi) {
        return bi.getSensor() + "_Band" + bi.getBandNumber() + '_' + bi.getPreferredUnit();
    }

    @Override
    public void reloadData() {
        if (this.addeImageDataSelection != null && this.addeImageDataSelection.leMagPanel != null) {
            this.addeImageDataSelection.advancedPanel.updateMagPanel();
            this.addeImageDataSelection.advancedPanel.setLineMagSlider(this.lineMag);
            this.addeImageDataSelection.advancedPanel.setElementMagSlider(this.eleMag);
        }
        super.reloadData();
    }

    public static List reSetImageDataDescriptor(List despList, String locateKey, String locateValue, String PlaceValue, int lines, int elems, int lineMag, int eleMag, String unit, String nav) throws RemoteException, VisADException {
        ArrayList<AddeImageDescriptor> descriptorList = new ArrayList<AddeImageDescriptor>();
        for (int i = 0; i < despList.size(); ++i) {
            AddeImageDescriptor imageDescriptor = (AddeImageDescriptor)despList.get(i);
            AddeImageInfo info = imageDescriptor.getImageInfo();
            info.setElementMag(-1 * eleMag);
            info.setLineMag(-1 * lineMag);
            if (locateKey != null) {
                info.setLocateKey(locateKey);
                info.setLocateValue(locateValue);
                info.setPlaceValue(PlaceValue);
            } else {
                info.setLocateValue(locateValue);
            }
            info.setLines(lines);
            info.setElements(elems);
            String sizeValue = Integer.toString(lines) + " " + Integer.toString(elems);
            String magValue = "-" + Integer.toString(lineMag) + " " + "-" + Integer.toString(eleMag);
            String source = imageDescriptor.getSource();
            source = AddeImageDataSource.getKey(source, locateKey) != null && AddeImageDataSource.getKey(source, locateKey).length() > 0 ? AddeImageDataSource.replaceKey(source, locateKey, locateValue) : (locateKey.equals("LATLON") ? AddeImageDataSource.replaceKey(source, "LINELE", "LATLON", locateValue) : AddeImageDataSource.replaceKey(source, "LATLON", "LINELE", locateValue));
            source = AddeImageDataSource.replaceKey(source, "PLACE", PlaceValue);
            source = AddeImageDataSource.replaceKey(source, "SIZE", sizeValue);
            source = AddeImageDataSource.replaceKey(source, "MAG", magValue);
            if (unit != null) {
                source = AddeImageDataSource.replaceKey(source, "UNIT", unit);
            }
            if (nav != null) {
                source = AddeImageDataSource.replaceKey(source, "NAV", nav);
            }
            imageDescriptor.setSource(source);
            descriptorList.add(imageDescriptor);
        }
        return descriptorList;
    }

    public double[] getLatLonPoints(LatLonPoint[] latLonPoints) {
        double maxLat = latLonPoints[0].getLatitude();
        double minLat = latLonPoints[0].getLatitude();
        double minLon = latLonPoints[0].getLongitude();
        double maxLon = latLonPoints[0].getLongitude();
        try {
            for (int i = 1; i < latLonPoints.length; ++i) {
                LatLonPoint llp = latLonPoints[i];
                if (llp.getLatitude() > maxLat) {
                    maxLat = llp.getLatitude();
                }
                if (llp.getLatitude() < minLat) {
                    minLat = llp.getLatitude();
                }
                if (llp.getLongitude() > maxLon) {
                    maxLon = llp.getLongitude();
                }
                if (!(llp.getLongitude() < minLon)) continue;
                minLon = llp.getLongitude();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new double[]{maxLat, minLat, maxLon, minLon};
    }

    public List geoSpaceSubsetD(Rectangle2D rect, String unit, int eMag, int lMag, AREAnav baseAnav, List despList, double maxLat, double minLat, double maxLon, double minLon, int factor, int dlMag, int deMag, String placeValue, boolean isProgressiveResolution, LatLonPointImpl centerLLP, String nav) {
        try {
            AddeImageDescriptor dsep = (AddeImageDescriptor)despList.get(0);
            int lines = 0;
            int elems = 0;
            float[][] latlon = new float[2][1];
            latlon[1][0] = (float)centerLLP.getLongitude();
            latlon[0][0] = (float)maxLat;
            float[][] ulLinEle = baseAnav.toLinEle(latlon);
            if (ulLinEle[1][0] < 0.0f || ulLinEle[1][0] != ulLinEle[1][0]) {
                ulLinEle[1][0] = 0.0f;
            }
            latlon[1][0] = (float)centerLLP.getLongitude();
            latlon[0][0] = (float)minLat;
            float[][] lrLinEle = baseAnav.toLinEle(latlon);
            if (lrLinEle[1][0] < 0.0f || lrLinEle[1][0] != lrLinEle[1][0]) {
                int ln = dsep.getDirectory().getDirectoryBlock()[8];
                lrLinEle[1][0] = ln / Math.abs(lMag);
            }
            lines = (int)(lrLinEle[1][0] - ulLinEle[1][0]) * Math.abs(lMag);
            latlon[1][0] = (float)minLon;
            latlon[0][0] = (float)maxLat;
            ulLinEle = this.acs.fromReference(latlon);
            if (ulLinEle[0][0] < 0.0f || ulLinEle[0][0] != ulLinEle[0][0]) {
                ulLinEle[0][0] = 0.0f;
            }
            latlon[1][0] = (float)maxLon;
            latlon[0][0] = (float)minLat;
            lrLinEle = this.acs.fromReference(latlon);
            if (lrLinEle[0][0] < 0.0f || lrLinEle[0][0] != lrLinEle[0][0]) {
                int en = dsep.getDirectory().getDirectoryBlock()[9];
                lrLinEle[0][0] = en / Math.abs(eMag);
            }
            elems = (int)Math.abs(lrLinEle[0][0] - ulLinEle[0][0]) * Math.abs(eMag);
            if (lines > dsep.getDirectory().getDirectoryBlock()[8]) {
                lines = dsep.getDirectory().getDirectoryBlock()[8];
            }
            if (elems > dsep.getDirectory().getDirectoryBlock()[9]) {
                elems = dsep.getDirectory().getDirectoryBlock()[9];
            }
            if (isProgressiveResolution && nav.equals("LALO")) {
                this.lineMag = this.calculateMagFactor(lines, (int)rect.getHeight());
                this.lineMag = this.lineMag >= 2 ? this.lineMag / 2 : 1;
                this.eleMag = this.lineMag * factor;
            } else if (isProgressiveResolution) {
                this.eleMag = this.calculateMagFactor(elems, (int)rect.getWidth());
                this.lineMag = this.eleMag / factor;
                this.lineMag = this.lineMag > 0 ? this.lineMag : 1;
            } else {
                this.eleMag = Math.abs(deMag);
                this.lineMag = Math.abs(dlMag);
            }
            int newLines = this.lineMag == 1 ? (int)((double)lines * 1.0) : (int)(Math.floor((double)(lines / this.lineMag) + 0.5) * 1.0);
            int newelems = this.eleMag == 1 ? (int)((double)elems * 1.0) : (int)(Math.floor((double)(elems / this.eleMag) + 0.5) * 1.0);
            String locateValue = null;
            if (placeValue.equals("ULEFT")) {
                locateValue = Misc.format(maxLat) + " " + Misc.format(minLon);
            } else {
                double cLat = centerLLP.getLatitude();
                double cLon = centerLLP.getLongitude();
                locateValue = Misc.format(cLat) + " " + Misc.format(cLon);
            }
            return AddeImageDataSource.reSetImageDataDescriptor(despList, "LATLON", locateValue, placeValue, newLines, newelems, this.lineMag, this.eleMag, unit, nav);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public int calculateMagFactor(int dataPoints, int displayPoints) {
        if (dataPoints <= displayPoints) {
            return 1;
        }
        int factor = (int)Math.floor(1.0 * (double)dataPoints / (1.0 * (double)displayPoints) + 0.8);
        return factor;
    }

    public String getBaseSource(String source) {
        String bandStr;
        String addeCmdBuff = source;
        if (addeCmdBuff.contains("BAND=") && (bandStr = AddeImageDataSource.getKey(addeCmdBuff, "BAND")).length() == 0) {
            addeCmdBuff = AddeImageDataSource.replaceKey(addeCmdBuff, "BAND", SPACING_BRIT);
        }
        if (addeCmdBuff.contains("MAG=")) {
            String[] segs = addeCmdBuff.split("MAG=");
            String seg0 = segs[0];
            String seg1 = segs[1];
            int indx = seg1.indexOf("&");
            seg1 = seg1.substring(indx);
            String magString = "-2 -2";
            addeCmdBuff = seg0 + "MAG=" + magString + seg1;
        }
        return addeCmdBuff;
    }

    public static String replaceKey(String src, String key, Object val) {
        String returnString = src;
        if (key == null || val == null) {
            return returnString;
        }
        if (returnString.contains(key = key.toUpperCase() + '=')) {
            String[] segs = returnString.split(key);
            String seg0 = segs[0];
            String seg1 = segs[1];
            int indx = seg1.indexOf("&");
            if (indx < 0) {
                seg1 = "";
            } else if (indx > 0) {
                seg1 = seg1.substring(indx);
            }
            returnString = seg0 + key + val + seg1;
        } else {
            returnString = returnString + '&' + key + val;
        }
        if (key.equals("UNIT=") && "BRIT".equals(val)) {
            returnString = AddeImageDataSource.replaceKey(returnString, "SPAC", "SPAC", SPACING_BRIT);
        }
        return returnString;
    }

    public static String replaceKey(String src, String oldKey, String newKey, Object val) {
        String returnString = src;
        oldKey = oldKey.toUpperCase() + '=';
        newKey = newKey.toUpperCase() + '=';
        if (returnString.contains(oldKey)) {
            String[] segs = returnString.split(oldKey);
            String seg0 = segs[0];
            String seg1 = segs[1];
            int indx = seg1.indexOf("&");
            if (indx < 0) {
                seg1 = "";
            } else if (indx > 0) {
                seg1 = seg1.substring(indx);
            }
            returnString = seg0 + newKey + val + seg1;
        } else {
            returnString = returnString + '&' + newKey + val;
        }
        return returnString;
    }

    public static String getKey(String src, String key) {
        String returnString = "";
        if (src.contains(key = key.toUpperCase() + '=')) {
            String[] segs = src.split(key);
            segs = segs[1].split("&");
            returnString = segs[0];
        }
        return returnString;
    }

    public static String removeKey(String src, String key) {
        String returnString = src;
        if (returnString.contains(key = key.toUpperCase() + '=')) {
            String[] segs = returnString.split(key);
            String seg0 = segs[0];
            String seg1 = segs[1];
            int indx = seg1.indexOf("&");
            if (indx >= 0) {
                seg1 = seg1.substring(indx + 1);
            }
            returnString = seg0 + seg1;
        }
        return returnString;
    }

    protected void initOldBundle(DataChoice dataChoice, List<AddeImageDescriptor> descriptors, String sourceStr) {
        this.allBandDirs = new Hashtable(1);
        AreaDirectory dir0 = descriptors.get(0).getDirectory();
        BandInfo binfo = (BandInfo)dataChoice.getId();
        int bindex = binfo.getBandNumber();
        this.allBandDirs.put(bindex, dir0);
        String magVal = AddeImageDataSource.getKey(sourceStr, "MAG");
        if (magVal.length() == 0) {
            return;
        }
        String[] magVals = magVal.split(" ");
        this.eMag = new Integer(magVals[1]);
        this.lMag = new Integer(magVals[0]);
    }

    protected void handlePreviewImageError(int flag, Exception excp) {
        this.getDataContext().getIdv().showNormalCursor();
        LogUtil.userErrorMessage("Error in makePreviewImage  e=" + flag + " " + excp);
    }

    public AddeImageDataSelection getAddeImageDataSelection() {
        return this.addeImageDataSelection;
    }

    protected void initDataSelectionComponents(List components, DataChoice dataChoice) {
        try {
            BandInfo id = null;
            if (dataChoice.getId() instanceof BandInfo && this.allBandDirs != null) {
                id = (BandInfo)dataChoice.getId();
            } else if (dataChoice instanceof DerivedDataChoice) {
                Hashtable cdc = ((DerivedDataChoice)dataChoice).getUserSelectedChoices();
                DataChoice dataChoice1 = (DataChoice)cdc.get("D1");
                id = (BandInfo)dataChoice1.getId();
            } else {
                return;
            }
            if (id != null && !id.equals(this.bandId)) {
                AreaDirectory thisDir = (AreaDirectory)this.allBandDirs.get(id.getBandNumber());
                this.source = this.getPreviewSource(this.source, thisDir);
                this.source = AddeImageDataSource.replaceKey(this.source, "BAND", Integer.toString(id.getBandNumber()));
                this.descriptor = new AddeImageDescriptor(thisDir, null);
            }
            if (this.baseAnav == null || !id.equals(this.bandId)) {
                try {
                    this.areaAdapter = new AreaAdapter(this.source, false);
                    AreaFile areaFile = this.areaAdapter.getAreaFile();
                    this.baseAnav = areaFile.getNavigation();
                    this.acs = new AREACoordinateSystem(areaFile);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.bandId = id;
            }
            if (this.areaAdapter != null) {
                this.addeImageDataSelection = new AddeImageDataSelection(this, dataChoice, this.source, this.baseAnav, this.descriptor, this.acs, this.areaAdapter);
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(LogUtil.getCurrentWindow(), ex.getMessage(), "Error in initDataSelectionComponents 2", 0);
            this.getDataContext().getIdv().showNormalCursor();
            return;
        }
        if (this.areaAdapter != null) {
            components.add(this.addeImageDataSelection.getRegionPanel());
            components.add(this.addeImageDataSelection.getAdvancedPanel());
        }
    }

    public int getEMag() {
        return this.eMag;
    }

    public int getLMag() {
        return this.lMag;
    }
}

