/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.data.imagery;

import edu.wisc.ssec.mcidas.AREAnav;
import edu.wisc.ssec.mcidas.AreaDirectory;
import edu.wisc.ssec.mcidas.Calibrator;
import edu.wisc.ssec.mcidas.adde.AddeTextReader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import ucar.unidata.data.DataChoice;
import ucar.unidata.data.DataSelection;
import ucar.unidata.data.DataSelectionComponent;
import ucar.unidata.data.GeoLocationInfo;
import ucar.unidata.data.GeoSelection;
import ucar.unidata.data.imagery.AddeImageDataSource;
import ucar.unidata.data.imagery.AddeImageDescriptor;
import ucar.unidata.data.imagery.AddeImageInfo;
import ucar.unidata.data.imagery.AddeImagePreview;
import ucar.unidata.data.imagery.ImageDataSelectionInfo;
import ucar.unidata.data.imagery.ImageDataSource;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.ProjectionPoint;
import ucar.unidata.geoloc.ProjectionRect;
import ucar.unidata.idv.MapViewManager;
import ucar.unidata.idv.NavigatedViewManager;
import ucar.unidata.idv.ViewManager;
import ucar.unidata.ui.LatLonWidget;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.Misc;
import ucar.unidata.util.StringUtil;
import ucar.unidata.util.TwoFacedObject;
import ucar.unidata.view.geoloc.NavigatedDisplay;
import ucar.unidata.view.geoloc.NavigatedMapPanel;
import ucar.unidata.view.geoloc.NavigatedPanel;
import visad.VisADException;
import visad.data.mcidas.AREACoordinateSystem;
import visad.data.mcidas.AreaAdapter;
import visad.georef.EarthLocation;
import visad.georef.MapProjection;

public class AddeImageDataSelection {
    public ImageDataSource dataSource;
    public String source;
    public AddeImageDescriptor descriptor;
    public AREAnav baseAnav;
    public DataChoice dataChoice;
    public MapProjection sampleProjection;
    public AddeImageAdvancedPanel advancedPanel;
    public AddeImagePreviewPanel regionPanel;
    public AreaAdapter aAdapter;
    public JPanel leMagPanel;
    AddeImageInfo addeImageInfo;
    private Calibrator cali;
    int band;

    public AddeImageDataSelection(ImageDataSource dataSource, DataChoice dc, String source, AREAnav baseAnav, AddeImageDescriptor descriptor, MapProjection sample, AreaAdapter aAdapter) {
        this.dataSource = dataSource;
        this.source = source;
        this.descriptor = descriptor;
        this.baseAnav = baseAnav;
        this.dataChoice = dc;
        this.sampleProjection = sample;
        this.aAdapter = aAdapter;
        this.cali = null;
        this.band = 0;
        this.addeImageInfo = null;
        try {
            if (this.aAdapter == null && this.source != null) {
                this.aAdapter = new AreaAdapter(this.source, false);
            }
            this.regionPanel = new AddeImagePreviewPanel(this);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.advancedPanel = new AddeImageAdvancedPanel(this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public AddeImageDataSelection(ImageDataSource dataSource, DataChoice dc, String source, AREAnav baseAnav, AddeImageInfo addeImageInfo, MapProjection sample, AreaAdapter aAdapter, Calibrator cali, int band) {
        this.dataSource = dataSource;
        this.source = source;
        this.addeImageInfo = addeImageInfo;
        this.baseAnav = baseAnav;
        this.dataChoice = dc;
        this.sampleProjection = sample;
        this.aAdapter = aAdapter;
        this.descriptor = null;
        this.cali = cali;
        this.band = band;
        try {
            if (this.aAdapter == null && this.source != null) {
                this.aAdapter = new AreaAdapter(this.source, false);
            }
            this.regionPanel = new AddeImagePreviewPanel(this);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.advancedPanel = new AddeImageAdvancedPanel(this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean getIsProgressiveResolution() {
        boolean usePR = false;
        if (this.dataSource.getIdv().getViewManager() instanceof MapViewManager) {
            MapViewManager mvm = (MapViewManager)this.dataSource.getIdv().getViewManager();
            usePR = mvm.getUseProgressiveResolution();
        }
        return usePR;
    }

    public AddeImageAdvancedPanel getAdvancedPanel() {
        return this.advancedPanel;
    }

    public AddeImagePreviewPanel getRegionPanel() {
        return this.regionPanel;
    }

    public void setDataChoice(DataChoice choice) {
        this.dataChoice = choice;
    }

    public DataChoice getDataChoice() {
        return this.dataChoice;
    }

    public class AddeImagePreviewPanel
    extends DataSelectionComponent {
        protected NavigatedMapPanel display;
        private AddeImagePreview imagePreview;
        GeoSelection geoSelection;
        private JPanel MasterPanel;
        private JCheckBox chkUseFull;
        public String USE_DEFAULTREGION;
        public String USE_SELECTEDREGION;
        public String USE_DISPLAYREGION;
        private String[] regionSubsetOptionLabels;
        private TwoFacedObject[] regionSubsetOptions;
        private JComponent regionsListInfo;
        private String regionOption;
        JComboBox regionOptionLabelBox;
        int eMag;
        int lMag;
        int eMag0;
        int lMag0;
        AddeImageDataSelection addeImageDataSelection;

        public AddeImagePreviewPanel(AddeImageDataSelection addeImageDataSelection) throws IOException, ParseException, VisADException {
            super("Region");
            this.USE_DEFAULTREGION = "Use_Default_Area";
            this.USE_SELECTEDREGION = "Use_Selected_Area";
            this.USE_DISPLAYREGION = "Match_Display_Area";
            this.regionSubsetOptionLabels = new String[]{this.USE_DEFAULTREGION, this.USE_SELECTEDREGION, this.USE_DISPLAYREGION};
            this.regionSubsetOptions = new TwoFacedObject[]{new TwoFacedObject((Object)"Use Default Region", "Use_Default_Area"), new TwoFacedObject((Object)"Select A Region", "Use_Selected_Area"), new TwoFacedObject((Object)"Match Display Region", "Match_Display_Area")};
            this.regionOption = this.USE_DEFAULTREGION;
            this.addeImageDataSelection = addeImageDataSelection;
            this.imagePreview = this.createImagePreview(AddeImageDataSelection.this.source);
            this.display = new NavigatedMapPanel(null, true, false, this.imagePreview.getPreviewImage(), AddeImageDataSelection.this.aAdapter.getAreaFile());
            if (AddeImageDataSelection.this.dataSource instanceof AddeImageDataSource) {
                this.eMag = ((AddeImageDataSource)AddeImageDataSelection.this.dataSource).getEMag();
                this.lMag = ((AddeImageDataSource)AddeImageDataSelection.this.dataSource).getLMag();
                this.eMag0 = ((AddeImageDataSource)AddeImageDataSelection.this.dataSource).getEMag();
                this.lMag0 = ((AddeImageDataSource)AddeImageDataSelection.this.dataSource).getLMag();
            } else {
                this.eMag = AddeImageDataSelection.this.addeImageInfo.getElementMag();
                this.lMag = AddeImageDataSelection.this.addeImageInfo.getLineMag();
                this.eMag0 = 1;
                this.lMag0 = 1;
            }
            this.chkUseFull = new JCheckBox("Use_Default_Area");
            this.chkUseFull.setSelected(true);
            this.getRegionsList();
            JScrollPane jsp = new JScrollPane();
            jsp.getViewport().setView(this.display);
            JPanel labelsPanel = null;
            labelsPanel = new JPanel();
            labelsPanel.setLayout(new BoxLayout(labelsPanel, 2));
            labelsPanel.add(this.getRegionsList());
            this.MasterPanel = new JPanel(new BorderLayout());
            this.MasterPanel.add((Component)labelsPanel, "North");
            this.MasterPanel.add((Component)jsp, "Center");
            this.display.getNavigatedPanel().addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent focusEvent) {
                }

                @Override
                public void focusLost(FocusEvent focusEvent) {
                    AddeImagePreviewPanel.this.update();
                }
            });
        }

        public JComponent getRegionsList() {
            return this.getRegionsList(this.USE_DEFAULTREGION);
        }

        public NavigatedMapPanel getNavigatedMapPanel() {
            return this.display;
        }

        public JComponent getRegionsList(String cbxLabel) {
            if (this.regionsListInfo == null) {
                this.regionsListInfo = this.makeRegionsListAndPanel(cbxLabel, null);
            }
            return this.regionsListInfo;
        }

        private JComponent makeRegionsListAndPanel(String cbxLabel, JComponent extra) {
            this.regionOptionLabelBox = new JComboBox();
            this.regionOptionLabelBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    String selectedObj = (String)((TwoFacedObject)AddeImagePreviewPanel.this.regionOptionLabelBox.getSelectedItem()).getId();
                    AddeImagePreviewPanel.this.setRegionOptions(selectedObj);
                    AddeImagePreviewPanel.this.setAdvancedPanel(selectedObj);
                    if (selectedObj.equals("Use_Default_Area") && AddeImageDataSelection.this.advancedPanel != null) {
                        AddeImageDataSelection.this.advancedPanel.reset();
                    }
                }
            });
            GuiUtils.enableTree(this.regionOptionLabelBox, true);
            List regionOptionNames = Misc.toList(this.regionSubsetOptions);
            GuiUtils.setListData(this.regionOptionLabelBox, regionOptionNames);
            JPanel top = extra != null ? GuiUtils.leftRight(extra, this.regionOptionLabelBox) : GuiUtils.right(this.regionOptionLabelBox);
            return top;
        }

        public String getRegionOptions() {
            return (String)((TwoFacedObject)this.regionOptionLabelBox.getSelectedItem()).getId();
        }

        public void setRegionOptions(String selectedObject) {
            this.regionOption = selectedObject.toString();
            if (selectedObject.equals(this.USE_DEFAULTREGION)) {
                this.display.getNavigatedPanel().setSelectedRegion((LatLonRect)null);
                GeoSelection gs = AddeImageDataSelection.this.dataSource.getDataSelection().getGeoSelection();
                if (gs != null) {
                    gs.setBoundingBox(null);
                }
                this.display.getNavigatedPanel().setSelectRegionMode(false);
                this.display.getNavigatedPanel().repaint();
            } else if (selectedObject.equals(this.USE_SELECTEDREGION)) {
                this.display.getNavigatedPanel().setSelectRegionMode(true);
            } else if (selectedObject.equals(this.USE_DISPLAYREGION)) {
                this.display.getNavigatedPanel().setSelectedRegion((LatLonRect)null);
                this.display.getNavigatedPanel().setSelectRegionMode(false);
                this.display.getNavigatedPanel().repaint();
            }
        }

        public void setAdvancedPanel(String selectedObject) {
            if (AddeImageDataSelection.this.advancedPanel == null) {
                return;
            }
            this.regionOption = selectedObject.toString();
            if (selectedObject.equals(this.USE_SELECTEDREGION)) {
                AddeImageDataSelection.this.advancedPanel.enablePanelAll(true);
            } else {
                AddeImageDataSelection.this.advancedPanel.enablePanelAll(false);
            }
            GuiUtils.enablePanel(AddeImageDataSelection.this.leMagPanel, !AddeImageDataSelection.this.getIsProgressiveResolution());
        }

        public String getRegionOption() {
            return this.regionOption;
        }

        public void setRegionOption(String option) {
            this.regionOption = option;
        }

        public void setDataChoice(DataChoice dataChoice) {
        }

        private AddeImagePreview createImagePreview(String source) throws IOException {
            int selIndex = -1;
            AddeImageDataSelection.this.dataSource.getIdv().showWaitCursor();
            AddeImagePreview image = AddeImageDataSelection.this.cali != null ? new AddeImagePreview(AddeImageDataSelection.this.aAdapter, AddeImageDataSelection.this.descriptor, AddeImageDataSelection.this.cali, AddeImageDataSelection.this.band) : new AddeImagePreview(AddeImageDataSelection.this.aAdapter, AddeImageDataSelection.this.descriptor);
            AddeImageDataSelection.this.dataSource.getDataContext().getIdv().showNormalCursor();
            return image;
        }

        public String getFileName() {
            return AddeImageDataSelection.this.source;
        }

        public AddeImagePreview getAddeImagePreview() {
            return this.imagePreview;
        }

        @Override
        protected JComponent doMakeContents() {
            return this.MasterPanel;
        }

        public void setElemMag(int value) {
            this.eMag = Math.abs(value);
        }

        public void setLineMag(int value) {
            this.lMag = Math.abs(value);
        }

        @Override
        public void applyToDataSelection(DataSelection dataSelection) {
            boolean isFull = false;
            this.regionOption = this.getRegionOption();
            GeoLocationInfo gInfo = null;
            this.geoSelection = new GeoSelection(gInfo);
            if (isFull) {
                this.geoSelection.setUseFullBounds(true);
            }
            dataSelection.putProperty("Region_Selection_Option", this.regionOption);
            dataSelection.setGeoSelection(this.geoSelection);
        }

        public void update() {
            ProjectionRect rect = this.display.getNavigatedPanel().getSelectedRegion();
            boolean hasCorner = false;
            boolean isFull = false;
            if (rect != null) {
                int elems;
                int lines;
                GeoLocationInfo gInfo;
                ProjectionImpl projectionImpl = this.display.getProjectionImpl();
                LatLonRect latLonRect = projectionImpl.projToLatLonBB(rect);
                if (latLonRect.getHeight() != latLonRect.getHeight()) {
                    LatLonPoint cImpl = projectionImpl.projToLatLon(rect.getX() + rect.getWidth() / 2.0, rect.getY() + rect.getHeight() / 2.0);
                    LatLonPoint urImpl = projectionImpl.projToLatLon(rect.getX() + rect.getWidth(), rect.getY() + rect.getHeight());
                    LatLonPoint ulImpl = projectionImpl.projToLatLon(rect.getX(), rect.getY() + rect.getHeight());
                    LatLonPoint lrImpl = projectionImpl.projToLatLon(rect.getX() + rect.getWidth(), rect.getY());
                    LatLonPoint llImpl = projectionImpl.projToLatLon(rect.getX(), rect.getY());
                    double maxLat = Double.NaN;
                    double minLat = Double.NaN;
                    double maxLon = Double.NaN;
                    double minLon = Double.NaN;
                    if (cImpl.getLatitude() == cImpl.getLatitude()) {
                        if (ulImpl.getLatitude() != ulImpl.getLatitude() && urImpl.getLatitude() != urImpl.getLatitude() && llImpl.getLatitude() != llImpl.getLatitude() && lrImpl.getLatitude() != lrImpl.getLatitude()) {
                            isFull = true;
                        } else if (ulImpl.getLatitude() != ulImpl.getLatitude()) {
                            maxLat = cImpl.getLatitude() + (cImpl.getLatitude() - lrImpl.getLatitude());
                            minLat = lrImpl.getLatitude();
                            maxLon = lrImpl.getLongitude();
                            minLon = cImpl.getLongitude() - (lrImpl.getLongitude() - cImpl.getLongitude());
                        } else if (urImpl.getLatitude() != urImpl.getLatitude()) {
                            maxLat = cImpl.getLatitude() + (cImpl.getLatitude() - llImpl.getLatitude());
                            minLat = llImpl.getLatitude();
                            maxLon = cImpl.getLongitude() + (cImpl.getLongitude() - lrImpl.getLongitude());
                            minLon = lrImpl.getLongitude();
                        } else if (llImpl.getLatitude() != llImpl.getLatitude()) {
                            maxLat = urImpl.getLatitude();
                            minLat = cImpl.getLatitude() - (urImpl.getLatitude() - cImpl.getLatitude());
                            maxLon = urImpl.getLongitude();
                            minLon = cImpl.getLongitude() - (urImpl.getLongitude() - cImpl.getLongitude());
                        } else if (lrImpl.getLatitude() != lrImpl.getLatitude()) {
                            maxLat = ulImpl.getLatitude();
                            minLat = cImpl.getLatitude() - (ulImpl.getLatitude() - cImpl.getLatitude());
                            maxLon = cImpl.getLongitude() + (cImpl.getLongitude() - ulImpl.getLongitude());
                            minLon = ulImpl.getLongitude();
                        }
                    }
                    hasCorner = true;
                    gInfo = new GeoLocationInfo(maxLat, LatLonPointImpl.lonNormal(minLon), minLat, LatLonPointImpl.lonNormal(maxLon));
                } else {
                    gInfo = new GeoLocationInfo(latLonRect);
                }
                this.geoSelection = new GeoSelection(gInfo);
                float[][] latlon = new float[2][1];
                latlon[1][0] = (float)gInfo.getMinLon();
                latlon[0][0] = (float)gInfo.getMaxLat();
                float[][] ulLinEle = AddeImageDataSelection.this.baseAnav.toLinEle(latlon);
                latlon[1][0] = (float)gInfo.getMaxLon();
                latlon[0][0] = (float)gInfo.getMinLat();
                float[][] lrLinEle = AddeImageDataSelection.this.baseAnav.toLinEle(latlon);
                if (ulLinEle[0][0] == ulLinEle[0][0] && lrLinEle[0][0] == lrLinEle[0][0]) {
                    lines = (int)(lrLinEle[1][0] - ulLinEle[1][0]) * Math.abs(this.lMag0) / Math.abs(this.lMag);
                    elems = (int)(lrLinEle[0][0] - ulLinEle[0][0]) * Math.abs(this.eMag0) / Math.abs(this.eMag);
                } else if (ulLinEle[0][0] == ulLinEle[0][0]) {
                    lines = (AddeImageDataSelection.this.advancedPanel.maxLines - (int)ulLinEle[1][0] * Math.abs(this.lMag0)) / Math.abs(this.lMag);
                    elems = (AddeImageDataSelection.this.advancedPanel.maxEles - (int)ulLinEle[0][0] * Math.abs(this.eMag0)) / Math.abs(this.eMag);
                } else if (lrLinEle[0][0] == lrLinEle[0][0]) {
                    lines = (int)lrLinEle[1][0] * Math.abs(this.lMag0) / Math.abs(this.lMag);
                    elems = (int)lrLinEle[0][0] * Math.abs(this.eMag0) / Math.abs(this.eMag);
                } else {
                    lines = AddeImageDataSelection.this.advancedPanel.maxLines;
                    elems = AddeImageDataSelection.this.advancedPanel.maxEles;
                }
                lines = Math.abs(lines);
                elems = Math.abs(elems);
                AddeImageDataSelection.this.advancedPanel.setIsFromRegionUpdate(true);
                if (isFull) {
                    AddeImageDataSelection.this.advancedPanel.setToFullResolution(new Boolean(false));
                } else if (!hasCorner) {
                    AddeImageDataSelection.this.advancedPanel.setLatitude(gInfo.getMaxLat());
                    AddeImageDataSelection.this.advancedPanel.setLongitude(gInfo.getMinLon());
                    AddeImageDataSelection.this.advancedPanel.convertToLineEle();
                    AddeImageDataSelection.this.advancedPanel.setPlace("ULEFT");
                } else {
                    double centerLat = (gInfo.getMaxLat() + gInfo.getMinLat()) / 2.0;
                    double centerLon = (gInfo.getMaxLon() + gInfo.getMinLon()) / 2.0;
                    AddeImageDataSelection.this.advancedPanel.setLatitude(centerLat);
                    AddeImageDataSelection.this.advancedPanel.setLongitude(centerLon);
                    AddeImageDataSelection.this.advancedPanel.convertToLineEle();
                    AddeImageDataSelection.this.advancedPanel.setPlace("CENTER");
                }
                if (AddeImageDataSelection.this.baseAnav.toString().equals("LALO")) {
                    AddeImageDataSelection.this.advancedPanel.coordinateTypeComboBox.setSelectedIndex(1);
                } else {
                    AddeImageDataSelection.this.advancedPanel.coordinateTypeComboBox.setSelectedIndex(0);
                }
                if (!isFull) {
                    AddeImageDataSelection.this.advancedPanel.setNumLines(lines);
                    AddeImageDataSelection.this.advancedPanel.setNumEles(elems);
                    AddeImageDataSelection.this.advancedPanel.setIsFromRegionUpdate(false);
                    AddeImageDataSelection.this.advancedPanel.setBaseNumElements(elems * Math.abs(this.eMag));
                    AddeImageDataSelection.this.advancedPanel.setBaseNumLines(lines * Math.abs(this.lMag));
                }
            }
        }
    }

    public class AddeImageAdvancedPanel
    extends DataSelectionComponent {
        public JPanel advance;
        private JPanel MasterPanel;
        private JCheckBox chkUseFull;
        private Hashtable propToComps;
        protected int GRID_SPACING;
        protected Insets GRID_INSETS;
        protected JSlider lineMagSlider;
        protected JSlider elementMagSlider;
        JLabel lineMagLbl;
        private static final int SLIDER_MAX = 29;
        boolean amSettingProperties;
        private int lineMag1;
        private int elementMag1;
        private String kmLbl;
        JLabel elementMagLbl;
        protected static final String TYPE_LATLON = "Latitude/Longitude";
        protected static final String TYPE_AREA = "Area Coordinates";
        String[] coordinateTypes;
        String[] locations;
        JComboBox coordinateTypeComboBox;
        JComboBox locationComboBox;
        protected LatLonWidget latLonWidget;
        JTextField numElementsFld;
        JTextField numLinesFld;
        JTextField centerLineFld;
        JTextField centerElementFld;
        private int defaultNumLines;
        private int defaultNumEles;
        private int numLines;
        private int numEles;
        private double latitude1;
        private double defaultLat;
        private double longitude1;
        private double defaultLon;
        private int imageLine;
        private int areaLine1;
        private int areaElement1;
        private int imageElement;
        private String defaultType;
        private JPanel lockPanel;
        private JPanel latLonPanel;
        private JPanel lineElementPanel;
        private JLabel centerLatLbl;
        private JLabel centerLonLbl;
        private JLabel centerLineLbl;
        private JLabel centerElementLbl;
        protected GuiUtils.CardLayoutPanel locationPanel;
        private boolean isLineEle;
        JPanel sizePanel;
        boolean isFromRegionUpdate;
        private double linesToElements;
        private double baseNumLines;
        private double baseNumElements;
        protected boolean amUpdating;
        private String place1;
        private int maxLines;
        private int maxEles;
        private AreaDirectory previewDir;
        protected static final String PLACE_CENTER = "CENTER";
        protected static final String PLACE_ULEFT = "ULEFT";
        private String defaultPlace;
        JLabel sizeLbl;
        private JToggleButton linkBtn;
        private JButton fullResBtn;
        JLabel rawSizeLbl;
        AddeImageDataSelection addeImageDataSelection;
        String previousPlace;
        ImageDataSelectionInfo urlInfo;
        String coordinateType;
        String navType;
        protected JComboBox navComboBox;
        AddeImageInfo imageInfo;

        public AddeImageAdvancedPanel(AddeImageDataSelection addeImageDataSelection) throws IOException, ParseException, VisADException {
            super("Advanced");
            this.propToComps = new Hashtable();
            this.GRID_SPACING = 3;
            this.GRID_INSETS = new Insets(this.GRID_SPACING, this.GRID_SPACING, this.GRID_SPACING, this.GRID_SPACING);
            this.lineMagLbl = new JLabel();
            this.amSettingProperties = false;
            this.kmLbl = " km";
            this.elementMagLbl = new JLabel();
            this.coordinateTypes = new String[]{TYPE_LATLON, TYPE_AREA};
            this.locations = new String[]{"Center", "Upper Left"};
            this.latLonWidget = new LatLonWidget();
            this.numElementsFld = new JTextField();
            this.numLinesFld = new JTextField();
            this.centerLineFld = new JTextField();
            this.centerElementFld = new JTextField();
            this.defaultNumLines = 1000;
            this.defaultNumEles = 1000;
            this.numLines = this.defaultNumLines;
            this.numEles = this.defaultNumEles;
            this.defaultLat = Double.NaN;
            this.defaultLon = Double.NaN;
            this.defaultType = TYPE_LATLON;
            this.centerLatLbl = new JLabel();
            this.centerLonLbl = new JLabel();
            this.centerLineLbl = new JLabel();
            this.centerElementLbl = new JLabel();
            this.isLineEle = false;
            this.isFromRegionUpdate = false;
            this.linesToElements = 1.0;
            this.baseNumLines = 0.0;
            this.baseNumElements = 0.0;
            this.amUpdating = false;
            this.maxLines = 0;
            this.maxEles = 0;
            this.defaultPlace = PLACE_CENTER;
            this.rawSizeLbl = new JLabel();
            this.addeImageDataSelection = addeImageDataSelection;
            if (addeImageDataSelection.addeImageInfo == null) {
                this.urlInfo = new ImageDataSelectionInfo(AddeImageDataSelection.this.source);
            } else {
                this.urlInfo = new ImageDataSelectionInfo();
                this.imageInfo = addeImageDataSelection.addeImageInfo;
                this.urlInfo.setNavType(this.imageInfo.getNavType());
                this.urlInfo.setPlaceValue(this.imageInfo.getPlaceValue());
                this.urlInfo.setLocateKey(this.imageInfo.getLocateKey());
                this.urlInfo.setLocateValue(this.imageInfo.getLocateValue());
                this.urlInfo.setLocate(this.imageInfo.getLocateValue());
                this.urlInfo.setLineMag(this.imageInfo.getLineMag() * -1);
                this.urlInfo.setElementMag(this.imageInfo.getElementMag() * -1);
                this.urlInfo.setLine(this.imageInfo.getLines());
                this.urlInfo.setElement(this.imageInfo.getElements());
            }
            AreaDirectory aDir = null;
            aDir = AddeImageDataSelection.this.descriptor != null ? AddeImageDataSelection.this.descriptor.getDirectory() : addeImageDataSelection.aAdapter.getAreaDirectory();
            this.isLineEle = true;
            this.coordinateType = this.urlInfo.getLocateKey();
            this.navType = this.urlInfo.getNavType();
            if (this.navType.equals("LALO")) {
                this.coordinateType = "LINELE";
                this.centerLineFld.setText(Integer.toString(0));
                this.centerElementFld.setText(Integer.toString(0));
                this.setLine(0);
                this.setElement(0);
                this.urlInfo.setPlaceValue(PLACE_ULEFT);
                this.urlInfo.setLocationLine(0);
                this.urlInfo.setLocationElem(0);
                this.convertToLatLon();
                this.urlInfo.setLocationLat(this.getLatitude());
                this.urlInfo.setLocationLon(this.getLongitude());
            } else if (this.coordinateType.equals("LATLON")) {
                this.latLonWidget.setLat(this.urlInfo.getLocationLat());
                this.latLonWidget.setLon(this.urlInfo.getLocationLon());
                this.convertToLineEle();
                this.urlInfo.setLocationElem(this.getElement());
                this.urlInfo.setLocationLine(this.getLine());
            } else {
                this.centerLineFld.setText(Integer.toString(this.urlInfo.getLocationLine()));
                this.centerElementFld.setText(Integer.toString(this.urlInfo.getLocationElem()));
                this.convertToLatLon();
                this.urlInfo.setLocationLat(this.getLatitude());
                this.urlInfo.setLocationLon(this.getLongitude());
            }
            this.previewDir = aDir;
            this.baseNumLines = aDir.getLines();
            this.baseNumElements = aDir.getElements();
        }

        public void reset() {
            if (AddeImageDataSelection.this.descriptor != null) {
                this.urlInfo = new ImageDataSelectionInfo(AddeImageDataSelection.this.source);
            } else {
                this.urlInfo = new ImageDataSelectionInfo();
                this.imageInfo = this.addeImageDataSelection.addeImageInfo;
                this.urlInfo.setNavType(this.imageInfo.getNavType());
                this.urlInfo.setPlaceValue(this.imageInfo.getPlaceValue());
                this.urlInfo.setLocateKey(this.imageInfo.getLocateKey());
                this.urlInfo.setLocateValue(this.imageInfo.getLocateValue());
                this.urlInfo.setLocate(this.imageInfo.getLocateValue());
                this.urlInfo.setLineMag(this.imageInfo.getLineMag() * -1);
                this.urlInfo.setElementMag(this.imageInfo.getElementMag() * -1);
            }
            this.setLineMagSlider(this.urlInfo.getLineMag());
            this.setElementMagSlider(this.urlInfo.getElementMag());
            AreaDirectory aDir = AddeImageDataSelection.this.descriptor != null ? AddeImageDataSelection.this.descriptor.getDirectory() : this.addeImageDataSelection.aAdapter.getAreaDirectory();
            this.coordinateType = this.urlInfo.getLocateKey();
            this.navType = this.urlInfo.getNavType();
            if (this.coordinateType.equals("LATLON")) {
                this.latLonWidget.setLat(this.urlInfo.getLocationLat());
                this.latLonWidget.setLon(this.urlInfo.getLocationLon());
                this.convertToLineEle();
                this.urlInfo.setLocationElem(this.getElement());
                this.urlInfo.setLocationLine(this.getLine());
            } else {
                this.centerLineFld.setText(Integer.toString(this.urlInfo.getLocationLine()));
                this.centerElementFld.setText(Integer.toString(this.urlInfo.getLocationElem()));
                this.convertToLatLon();
                this.urlInfo.setLocationLat(this.getLatitude());
                this.urlInfo.setLocationLon(this.getLongitude());
            }
            this.previewDir = aDir;
            this.baseNumLines = aDir.getLines();
            this.baseNumElements = aDir.getElements();
            int lines = (int)(this.baseNumLines / (double)Math.abs(this.urlInfo.getLineMag()));
            this.setNumLines(lines);
            int elems = (int)(this.baseNumElements / (double)Math.abs(this.urlInfo.getElementMag()));
            this.setNumEles(elems);
            this.setPlace(this.urlInfo.getPlaceValue());
        }

        public void setBaseNumLines(int lines) {
            this.baseNumLines = lines;
        }

        public void setBaseNumElements(int eles) {
            this.baseNumElements = eles;
        }

        public boolean getIsFromRegionUpdate() {
            return this.isFromRegionUpdate;
        }

        public void setIsFromRegionUpdate(boolean isRegion) {
            this.isFromRegionUpdate = isRegion;
        }

        public void updatePlace() {
            Object llr = null;
            String newPlace = this.getPlace();
            NavigatedPanel navigatedPanel = AddeImageDataSelection.this.regionPanel.display.getNavigatedPanel();
            ProjectionRect rect = navigatedPanel.getSelectedRegion();
            if (rect == null) {
                return;
            }
            ProjectionImpl projectionImpl = AddeImageDataSelection.this.regionPanel.display.getProjectionImpl();
            ProjectionRect newRect = new ProjectionRect();
            newRect.setHeight(rect.getHeight());
            newRect.setWidth(rect.getWidth());
            LatLonRect latLonRectOld = projectionImpl.projToLatLonBB(rect);
            if (newPlace.equals(PLACE_CENTER)) {
                double lat = this.getLatitude();
                double lon = this.getLongitude();
                LatLonPointImpl ll0 = new LatLonPointImpl(lat, lon);
                ProjectionPoint pp0 = projectionImpl.latLonToProj(ll0);
                double x = pp0.getX() - rect.getWidth() / 2.0;
                double y = pp0.getY() - rect.getHeight() / 2.0;
                newRect.setX(x);
                newRect.setY(y);
            } else {
                double lat = this.getLatitude();
                double lon = this.getLongitude();
                LatLonPointImpl ll0 = new LatLonPointImpl(lat, lon);
                ProjectionPoint pp0 = projectionImpl.latLonToProj(ll0);
                double x = pp0.getX();
                double y = pp0.getY() - rect.getHeight();
                newRect.setX(x);
                newRect.setY(y);
            }
            navigatedPanel.setSelectedRegion(newRect);
        }

        public void updateImageWidthSize() {
            NavigatedPanel navigatedPanel = AddeImageDataSelection.this.regionPanel.display.getNavigatedPanel();
            ProjectionRect rect = navigatedPanel.getSelectedRegion();
            if (rect == null) {
                return;
            }
            ProjectionRect newRect = new ProjectionRect();
            newRect.setX(rect.getX());
            newRect.setY(rect.getY());
            newRect.setHeight(rect.getHeight());
            int newNumEles = this.getNumEles();
            int mag0 = this.getElementMagValue();
            double newWidth = rect.getWidth() * ((double)(newNumEles *= Math.abs(mag0)) * 1.0 / this.baseNumElements);
            newRect.setWidth(newWidth);
            navigatedPanel.setSelectedRegion(newRect);
            this.updatePlace();
        }

        public void updateImageHeightSize() {
            NavigatedPanel navigatedPanel = AddeImageDataSelection.this.regionPanel.display.getNavigatedPanel();
            ProjectionRect rect = navigatedPanel.getSelectedRegion();
            if (rect == null) {
                return;
            }
            ProjectionRect newRect = new ProjectionRect();
            newRect.setX(rect.getX());
            newRect.setY(rect.getY());
            newRect.setWidth(rect.getWidth());
            int newNumLines = this.getNumLines();
            int mag0 = this.getLineMagValue();
            double newHeight = rect.getHeight() * ((double)(newNumLines *= Math.abs(mag0)) * 1.0 / this.baseNumLines);
            newRect.setHeight(newHeight);
            navigatedPanel.setSelectedRegion(newRect);
            this.baseNumLines = newNumLines;
            this.updatePlace();
        }

        public void enablePanelAll(boolean enable) {
            if (this.coordinateTypeComboBox == null) {
                return;
            }
            this.coordinateTypeComboBox.setEnabled(enable);
            this.locationComboBox.setEnabled(enable);
            GuiUtils.enablePanel(this.locationPanel, enable);
            GuiUtils.enablePanel(this.lockPanel, enable);
            GuiUtils.enablePanel(AddeImageDataSelection.this.leMagPanel, enable);
            GuiUtils.enablePanel(this.sizePanel, enable);
        }

        protected String getUrl() {
            String str = AddeImageDataSelection.this.source;
            str = str.replaceFirst("imagedata", "text");
            int indx = str.indexOf("VERSION");
            str = str.substring(0, indx);
            str = str.concat("file=SATBAND");
            return str;
        }

        protected List readTextLines(String url) {
            AddeTextReader reader = new AddeTextReader(url);
            Vector lines = null;
            if ("OK".equals(reader.getStatus())) {
                lines = reader.getLinesOfText();
            }
            return lines;
        }

        private float[] getLineEleResolution(AreaDirectory ad) {
            float[] res = new float[]{1.0f, 1.0f};
            int sensor = ad.getSensorID();
            List lines = null;
            try {
                String buff = this.getUrl();
                lines = this.readTextLines(buff);
                if (lines == null) {
                    return res;
                }
                int gotit = -1;
                String[] cards = StringUtil.listToStringArray(lines);
                for (int i = 0; i < cards.length; ++i) {
                    if (!cards[i].startsWith("Sat ")) continue;
                    StringTokenizer st = new StringTokenizer(cards[i], " ");
                    String temp = st.nextToken();
                    int m = st.countTokens();
                    for (int k = 0; k < m; ++k) {
                        int ss = Integer.parseInt(st.nextToken().trim());
                        if (ss != sensor) continue;
                        gotit = i;
                        break;
                    }
                    if (gotit != -1) break;
                }
                if (gotit == -1) {
                    return res;
                }
                int gotSrc = -1;
                for (int i = gotit; i < cards.length; ++i) {
                    if (cards[i].startsWith("EndSat")) {
                        return res;
                    }
                    if (!cards[i].startsWith("B")) continue;
                    StringTokenizer tok = new StringTokenizer(cards[i]);
                    String str = tok.nextToken();
                    str = tok.nextToken();
                    Float flt = new Float(str);
                    res[0] = flt.floatValue();
                    str = tok.nextToken();
                    flt = new Float(str);
                    res[1] = flt.floatValue();
                    return res;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return res;
        }

        protected JComponent addPropComp(String propId, JComponent comp) {
            Object oldComp = this.propToComps.get(propId);
            if (oldComp != null) {
                throw new IllegalStateException("Already have a component defined:" + propId);
            }
            this.propToComps.put(propId, comp);
            return comp;
        }

        protected void elementMagSliderChanged(boolean autoSetSize) {
            int value = this.getElementMagValue();
            if (Math.abs(value) < 29) {
                int lineMag = this.getLineMagValue();
                this.linesToElements = lineMag > value ? Math.abs((double)lineMag / (double)value) : Math.abs((double)value / (double)lineMag);
            }
            this.elementMagLbl.setText(StringUtil.padLeft("" + value, 3));
            if (autoSetSize) {
                if (value > 0) {
                    this.numElementsFld.setText("" + (int)(this.baseNumElements * (double)value));
                } else {
                    this.numElementsFld.setText("" + (int)(this.baseNumElements / (double)(-value)));
                }
            }
            int elems = this.getNumEles();
            this.urlInfo.setElements(elems);
            AddeImageDataSelection.this.regionPanel.setElemMag(value);
        }

        protected void lineMagSliderChanged(boolean autoSetSize) {
            try {
                int value = this.getLineMagValue();
                this.urlInfo.setLineMag(value);
                this.lineMagLbl.setText(StringUtil.padLeft("" + value, 3));
                if (autoSetSize) {
                    if (value > 0) {
                        this.numLinesFld.setText("" + (int)(this.baseNumLines * (double)value));
                    } else {
                        this.numLinesFld.setText("" + (int)(this.baseNumLines / (double)(-value)));
                    }
                }
                int lines = this.getNumLines();
                this.urlInfo.setLines(lines);
                AddeImageDataSelection.this.regionPanel.setLineMag(value);
                value = value == 1 ? (this.linesToElements < 1.0 ? (int)((double)(-value) / this.linesToElements) : (int)((double)value * this.linesToElements)) : (value > 1 ? (int)((double)value * this.linesToElements) : (int)((double)value / this.linesToElements));
                value = value > 0 ? value - 1 : value + 1;
                this.amSettingProperties = true;
                this.elementMagSlider.setValue(value);
                this.urlInfo.setElementMag(this.getElementMagValue());
                this.amSettingProperties = false;
                this.elementMagSliderChanged(autoSetSize);
            }
            catch (Exception exc) {
                System.out.println("Setting line magnification" + exc);
            }
        }

        public void setElementMagSlider(int value) {
            if (this.elementMagSlider == null && this.urlInfo != null) {
                this.urlInfo.setElementMag(value);
                return;
            }
            this.elementMagSlider.setValue(value);
            this.elementMagLbl.setText(StringUtil.padLeft("" + value, 3));
            this.urlInfo.setElementMag(this.getElementMagValue());
        }

        public void setLineMagSlider(int value) {
            if (this.lineMagSlider == null && this.urlInfo != null) {
                this.urlInfo.setLineMag(value);
                return;
            }
            this.lineMagSlider.setValue(value);
            this.lineMagLbl.setText(StringUtil.padLeft("" + value, 3));
            this.urlInfo.setLineMag(this.getLineMagValue());
        }

        protected int getLineMagValue() {
            if (this.lineMagSlider == null) {
                return this.urlInfo.getLineMag();
            }
            return this.getMagValue(this.lineMagSlider);
        }

        protected int getElementMagValue() {
            if (this.elementMagSlider == null) {
                return this.urlInfo.getElementMag();
            }
            return this.getMagValue(this.elementMagSlider);
        }

        private int getMagValue(JSlider slider) {
            int value = slider.getValue();
            if (value >= 0) {
                return value + 1;
            }
            return value - 1;
        }

        public void updateMagPanel() {
            GuiUtils.enablePanel(AddeImageDataSelection.this.leMagPanel, !AddeImageDataSelection.this.getIsProgressiveResolution());
        }

        public String getFileName() {
            return AddeImageDataSelection.this.source;
        }

        @Override
        protected JComponent doMakeContents() {
            ArrayList allComps0 = new ArrayList();
            ArrayList<JComponent> allComps1 = new ArrayList<JComponent>();
            ArrayList<JComponent> allComps2 = new ArrayList<JComponent>();
            ArrayList<JComponent> allComps3 = new ArrayList<JComponent>();
            Insets dfltGridSpacing = new Insets(4, 0, 4, 0);
            String dfltLblSpacing = " ";
            JPanel propComp = null;
            this.coordinateTypeComboBox = new JComboBox<String>(this.coordinateTypes);
            this.coordinateTypeComboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    int selectedIndex = AddeImageAdvancedPanel.this.coordinateTypeComboBox.getSelectedIndex();
                    AddeImageAdvancedPanel.this.flipLocationPanel(selectedIndex);
                    if (selectedIndex == 0) {
                        AddeImageAdvancedPanel.this.urlInfo.setLocateKey("LATLON");
                    } else {
                        AddeImageAdvancedPanel.this.urlInfo.setLocateKey("LINELE");
                    }
                }
            });
            allComps1.add(GuiUtils.rLabel(" Coordinates: "));
            allComps1.add(GuiUtils.left(this.coordinateTypeComboBox));
            allComps1.add(new JLabel(" "));
            allComps1.add(new JLabel(" "));
            ActionListener placeChange = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    if (AddeImageAdvancedPanel.this.previousPlace == null) {
                        AddeImageAdvancedPanel.this.previousPlace = AddeImageAdvancedPanel.this.getPlace();
                        return;
                    }
                    if (!AddeImageAdvancedPanel.this.previousPlace.contains(AddeImageAdvancedPanel.this.getPlace())) {
                        AddeImageAdvancedPanel.this.previousPlace = AddeImageAdvancedPanel.this.getPlace();
                        AddeImageAdvancedPanel.this.updatePlace();
                    }
                }
            };
            this.locationComboBox = new JComboBox<String>(this.locations);
            this.locationComboBox.addActionListener(placeChange);
            this.setPlace(this.urlInfo.getPlaceValue());
            allComps1.add(GuiUtils.rLabel(" Location: "));
            allComps1.add(GuiUtils.left(this.locationComboBox));
            ActionListener latLonChange = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    String type = AddeImageAdvancedPanel.this.getCoordinateType();
                    if (type.equals(AddeImageAdvancedPanel.TYPE_LATLON)) {
                        AddeImageAdvancedPanel.this.setLatitude();
                        AddeImageAdvancedPanel.this.setLongitude();
                        AddeImageAdvancedPanel.this.convertToLineEle();
                        AddeImageAdvancedPanel.this.updatePlace();
                    } else {
                        AddeImageAdvancedPanel.this.setLineElement();
                        AddeImageAdvancedPanel.this.convertToLatLon();
                        AddeImageAdvancedPanel.this.updatePlace();
                    }
                }
            };
            FocusListener linEleFocusChange = new FocusListener(){

                @Override
                public void focusGained(FocusEvent fe) {
                }

                @Override
                public void focusLost(FocusEvent fe) {
                    AddeImageAdvancedPanel.this.setLineElement();
                    AddeImageAdvancedPanel.this.convertToLatLon();
                    AddeImageAdvancedPanel.this.updatePlace();
                }
            };
            if (this.latLonWidget == null) {
                this.latLonWidget = new LatLonWidget(latLonChange);
            }
            FocusListener latLonFocusChange = new FocusListener(){

                @Override
                public void focusGained(FocusEvent fe) {
                    JTextField latFld = AddeImageAdvancedPanel.this.latLonWidget.getLatField();
                    latFld.setCaretPosition(latFld.getText().length());
                    JTextField lonFld = AddeImageAdvancedPanel.this.latLonWidget.getLonField();
                    lonFld.setCaretPosition(lonFld.getText().length());
                }

                @Override
                public void focusLost(FocusEvent fe) {
                    AddeImageAdvancedPanel.this.setLatitude();
                    AddeImageAdvancedPanel.this.setLongitude();
                    AddeImageAdvancedPanel.this.convertToLineEle();
                    AddeImageAdvancedPanel.this.updatePlace();
                }
            };
            if (!this.isLineEle) {
                this.latLonWidget.setLatLon(this.urlInfo.getLocationLat(), this.urlInfo.getLocationLon());
            }
            String lineStr = "";
            String eleStr = "";
            this.centerLineFld = new JTextField(lineStr, 3);
            this.centerLineFld.addActionListener(latLonChange);
            this.centerLineFld.addFocusListener(linEleFocusChange);
            this.centerElementFld = new JTextField(eleStr, 3);
            this.centerElementFld.addActionListener(latLonChange);
            this.centerElementFld.addFocusListener(linEleFocusChange);
            final JButton centerPopupBtn = GuiUtils.getImageButton("/auxdata/ui/icons/MapIcon16.png", this.getClass());
            centerPopupBtn.setToolTipText("Center on current displays");
            centerPopupBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    AddeImageDataSelection.this.dataSource.getDataContext().getIdv().getIdvUIManager().popupCenterMenu(centerPopupBtn, AddeImageAdvancedPanel.this.latLonWidget);
                }
            });
            JPanel centerPopup = GuiUtils.inset((Component)centerPopupBtn, new Insets(0, 0, 0, 4));
            JTextField latFld = this.latLonWidget.getLatField();
            JTextField lonFld = this.latLonWidget.getLonField();
            latFld.addFocusListener(latLonFocusChange);
            lonFld.addFocusListener(latLonFocusChange);
            Component[] componentArray = new Component[6];
            this.centerLatLbl = GuiUtils.rLabel(" Lat:" + dfltLblSpacing);
            componentArray[0] = this.centerLatLbl;
            componentArray[1] = latFld;
            this.centerLonLbl = GuiUtils.rLabel(" Lon:" + dfltLblSpacing);
            componentArray[2] = this.centerLonLbl;
            componentArray[3] = lonFld;
            componentArray[4] = new JLabel(" ");
            componentArray[5] = centerPopup;
            this.latLonPanel = GuiUtils.hbox(componentArray);
            Component[] componentArray2 = new Component[4];
            this.centerLineLbl = GuiUtils.rLabel(" Line:" + dfltLblSpacing);
            componentArray2[0] = this.centerLineLbl;
            componentArray2[1] = this.centerLineFld;
            this.centerElementLbl = GuiUtils.rLabel(" Element:" + dfltLblSpacing);
            componentArray2[2] = this.centerElementLbl;
            componentArray2[3] = this.centerElementFld;
            this.lineElementPanel = GuiUtils.hbox(componentArray2);
            this.locationPanel = new GuiUtils.CardLayoutPanel();
            this.locationPanel.addCard(this.latLonPanel);
            this.locationPanel.addCard(this.lineElementPanel);
            allComps1.add(GuiUtils.rLabel("  "));
            allComps1.add(GuiUtils.left(this.locationPanel));
            allComps1.add(new JLabel(" "));
            allComps1.add(new JLabel(" "));
            this.lockPanel = GuiUtils.left(GuiUtils.doLayout(new Component[]{new JLabel(" "), this.getLinkButton()}, 2, GuiUtils.WT_N, GuiUtils.WT_N));
            allComps2.add(GuiUtils.rLabel("Link Image Size And Magnification:"));
            allComps2.add(GuiUtils.left(this.lockPanel));
            allComps3.add(new JLabel(" "));
            allComps3.add(new JLabel(" "));
            ActionListener lSizeChange = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    int lines = AddeImageAdvancedPanel.this.getNumLines() * Math.abs(AddeImageAdvancedPanel.this.getLineMagValue());
                    if (lines > AddeImageAdvancedPanel.this.maxLines) {
                        lines = AddeImageAdvancedPanel.this.maxLines;
                    }
                    AddeImageAdvancedPanel.this.updateImageHeightSize();
                }
            };
            ActionListener eSizeChange = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    int eles = AddeImageAdvancedPanel.this.getNumEles() * Math.abs(AddeImageAdvancedPanel.this.getElementMagValue());
                    if (eles > AddeImageAdvancedPanel.this.maxEles) {
                        eles = AddeImageAdvancedPanel.this.maxEles;
                    }
                    AddeImageAdvancedPanel.this.updateImageWidthSize();
                }
            };
            FocusListener lSizeFocusChange = new FocusListener(){

                @Override
                public void focusGained(FocusEvent fe) {
                }

                @Override
                public void focusLost(FocusEvent fe) {
                    int lines = AddeImageAdvancedPanel.this.getNumLines() * Math.abs(AddeImageAdvancedPanel.this.getLineMagValue());
                    if (lines > AddeImageAdvancedPanel.this.maxLines) {
                        lines = AddeImageAdvancedPanel.this.maxLines;
                    }
                    AddeImageAdvancedPanel.this.updateImageHeightSize();
                }
            };
            FocusListener eSizeFocusChange = new FocusListener(){

                @Override
                public void focusGained(FocusEvent fe) {
                }

                @Override
                public void focusLost(FocusEvent fe) {
                    int eles = AddeImageAdvancedPanel.this.getNumEles() * Math.abs(AddeImageAdvancedPanel.this.getElementMagValue());
                    if (eles > AddeImageAdvancedPanel.this.maxEles) {
                        eles = AddeImageAdvancedPanel.this.maxEles;
                    }
                    AddeImageAdvancedPanel.this.updateImageWidthSize();
                }
            };
            this.maxLines = this.previewDir.getLines();
            this.maxEles = this.previewDir.getElements();
            int lmag = this.getLineMagValue();
            int emag = this.getElementMagValue();
            if (lmag < 0) {
                this.numLines = this.maxLines / Math.abs(lmag);
            }
            if (emag < 0) {
                this.numEles = this.maxEles / Math.abs(emag);
            }
            this.setNumLines(this.numLines);
            this.numLinesFld = new JTextField(Integer.toString(this.numLines), 4);
            this.numLinesFld.addActionListener(lSizeChange);
            this.numLinesFld.addFocusListener(lSizeFocusChange);
            this.setNumEles(this.numEles);
            this.numElementsFld = new JTextField(Integer.toString(this.numEles), 4);
            this.numElementsFld.addActionListener(eSizeChange);
            this.numElementsFld.addFocusListener(eSizeFocusChange);
            this.numLinesFld.setToolTipText("Number of lines");
            this.numElementsFld.setToolTipText("Number of elements");
            GuiUtils.tmpInsets = dfltGridSpacing;
            this.sizeLbl = GuiUtils.lLabel("");
            this.fullResBtn = GuiUtils.makeImageButton("/auxdata/ui/icons/arrow_out.png", this, "setToFullResolution", new Boolean(true));
            this.fullResBtn.setContentAreaFilled(false);
            this.fullResBtn.setToolTipText("Set fields to retrieve full image");
            this.rawSizeLbl = new JLabel(" Raw size: " + this.maxLines + " X " + this.maxEles);
            this.sizePanel = GuiUtils.left(GuiUtils.doLayout(new Component[]{this.numLinesFld, new JLabel(" X "), this.numElementsFld, this.sizeLbl, new JLabel(" "), this.fullResBtn, new JLabel("  "), this.rawSizeLbl}, 8, GuiUtils.WT_N, GuiUtils.WT_N));
            allComps3.add(GuiUtils.rLabel("Image Size:"));
            allComps3.add(GuiUtils.left(this.sizePanel));
            allComps3.add(new JLabel(" "));
            allComps3.add(new JLabel(" "));
            boolean oldAmSettingProperties = this.amSettingProperties;
            this.amSettingProperties = true;
            ChangeListener lineListener = new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent evt) {
                    if (AddeImageAdvancedPanel.this.amSettingProperties) {
                        return;
                    }
                    AddeImageAdvancedPanel.this.lineMagSliderChanged(AddeImageAdvancedPanel.this.getLinkButton().isSelected());
                }
            };
            ChangeListener elementListener = new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent evt) {
                    if (AddeImageAdvancedPanel.this.amSettingProperties) {
                        return;
                    }
                    AddeImageAdvancedPanel.this.elementMagSliderChanged(AddeImageAdvancedPanel.this.getLinkButton().isSelected());
                }
            };
            JComponent[] lineMagComps = GuiUtils.makeSliderPopup(-29, 1, 0, lineListener);
            this.lineMagSlider = (JSlider)lineMagComps[1];
            this.lineMagSlider.setMajorTickSpacing(1);
            this.lineMagSlider.setSnapToTicks(true);
            this.lineMagSlider.setExtent(1);
            if (lmag > 0) {
                this.lineMagSlider.setValue(lmag - 1);
            } else {
                this.lineMagSlider.setValue(lmag + 1);
            }
            lineMagComps[0].setToolTipText("Change the line magnification");
            JComponent[] elementMagComps = GuiUtils.makeSliderPopup(-29, 1, 0, elementListener);
            this.elementMagSlider = (JSlider)elementMagComps[1];
            this.elementMagSlider.setExtent(1);
            this.elementMagSlider.setMajorTickSpacing(1);
            this.elementMagSlider.setSnapToTicks(true);
            if (emag > 0) {
                this.elementMagSlider.setValue(emag - 1);
            } else {
                this.elementMagSlider.setValue(emag + 1);
            }
            elementMagComps[0].setToolTipText("Change the element magnification");
            this.lineMagSlider.setToolTipText("Slide to set line magnification factor");
            this.lineMagLbl = GuiUtils.getFixedWidthLabel(StringUtil.padLeft(String.valueOf(lmag), 3));
            this.elementMagSlider.setToolTipText("Slide to set element magnification factor");
            this.elementMagLbl = GuiUtils.getFixedWidthLabel(StringUtil.padLeft(String.valueOf(emag), 3));
            this.amSettingProperties = oldAmSettingProperties;
            GuiUtils.tmpInsets = new Insets(0, 0, 0, 0);
            AddeImageDataSelection.this.leMagPanel = GuiUtils.left(GuiUtils.doLayout(new Component[]{this.lineMagLbl, GuiUtils.inset((Component)lineMagComps[0], new Insets(0, 4, 0, 0)), new JLabel("    X"), this.elementMagLbl, GuiUtils.inset((Component)elementMagComps[0], new Insets(0, 4, 0, 0))}, 6, GuiUtils.WT_N, GuiUtils.WT_N));
            propComp = GuiUtils.hbox(new Component[]{AddeImageDataSelection.this.leMagPanel}, 1);
            allComps3.add(GuiUtils.rLabel("Magnification:"));
            allComps3.add(GuiUtils.left(propComp));
            JPanel imagePanel = GuiUtils.vbox(new Component[]{GuiUtils.doLayout(allComps0, 2, GuiUtils.WT_NY, GuiUtils.WT_N), GuiUtils.doLayout(allComps1, 2, GuiUtils.WT_NY, GuiUtils.WT_N), GuiUtils.doLayout(allComps2, 2, GuiUtils.WT_NY, GuiUtils.WT_N), GuiUtils.doLayout(allComps3, 2, GuiUtils.WT_NY, GuiUtils.WT_N)});
            this.advance = GuiUtils.top(imagePanel);
            boolean showMagSection = !AddeImageDataSelection.this.getIsProgressiveResolution();
            GuiUtils.enablePanel(AddeImageDataSelection.this.leMagPanel, showMagSection);
            GuiUtils.enablePanel(this.sizePanel, showMagSection);
            if (AddeImageDataSelection.this.descriptor != null) {
                String s0 = AddeImageDataSource.getKey(AddeImageDataSelection.this.source, "LINELE");
                if (s0 != null && s0.length() > 1) {
                    this.coordinateTypeComboBox.setSelectedIndex(1);
                }
            } else {
                this.coordinateTypeComboBox.setSelectedIndex(1);
            }
            this.chkUseFull = new JCheckBox("Use Default");
            this.chkUseFull.setSelected(true);
            JScrollPane jsp = new JScrollPane();
            jsp.getViewport().setView(this.advance);
            JPanel labelsPanel = null;
            labelsPanel = new JPanel();
            labelsPanel.setLayout(new BoxLayout(labelsPanel, 1));
            this.MasterPanel = new JPanel(new BorderLayout());
            this.MasterPanel.add((Component)labelsPanel, "North");
            this.MasterPanel.add((Component)jsp, "Center");
            if (AddeImageDataSelection.this.regionPanel != null) {
                String opStr = AddeImageDataSelection.this.regionPanel.getRegionOptions();
                if (opStr.equals("Use Selected")) {
                    this.enablePanelAll(true);
                } else {
                    this.enablePanelAll(false);
                }
                GuiUtils.enablePanel(AddeImageDataSelection.this.leMagPanel, !AddeImageDataSelection.this.getIsProgressiveResolution());
            }
            return this.MasterPanel;
        }

        private JToggleButton getLinkButton() {
            if (this.linkBtn == null) {
                this.linkBtn = GuiUtils.getToggleImageButton("/auxdata/ui/icons/link_break.png", "/auxdata/ui/icons/link.png", 0, 0, true);
                this.linkBtn.setContentAreaFilled(false);
                this.linkBtn.setSelected(true);
                this.linkBtn.setToolTipText("Link changing image size with magnification factors");
            }
            return this.linkBtn;
        }

        protected void flipLocationPanel(int locPanel) {
            int nowPlaying = this.locationPanel.getVisibleIndex();
            if (locPanel > 0) {
                if (nowPlaying == 0) {
                    this.locationPanel.flip();
                }
                this.setIsLineEle(true);
                String type = this.getCoordinateType();
                int ele = this.imageElement;
                int lin = this.imageLine;
                if (type.equals(TYPE_AREA)) {
                    ele = this.urlInfo.getLocationElem();
                    lin = this.urlInfo.getLocationLine();
                }
                this.setElement(ele);
                this.setLine(lin);
            } else {
                if (nowPlaying > 0) {
                    this.locationPanel.flip();
                }
                this.setIsLineEle(false);
            }
        }

        public void setIsLineEle(boolean val) {
            this.isLineEle = val;
        }

        public double getLatitude() {
            double val = this.latLonWidget.getLat();
            if (Double.isNaN(val)) {
                val = this.defaultLat;
            }
            if (val < -90.0 || val > 90.0) {
                val = this.defaultLat;
            }
            this.setLatitude(val);
            return val;
        }

        private void setLatitude() {
            this.urlInfo.setLocationLat(this.latLonWidget.getLat());
        }

        public void setLatitude(double val) {
            if (val < -90.0 || val > 90.0) {
                val = this.defaultLat;
            }
            this.latLonWidget.setLat(val);
            this.urlInfo.setLocationLat(val);
        }

        private void setLongitude() {
            this.urlInfo.setLocationLon(this.latLonWidget.getLon());
        }

        public double getLongitude() {
            double val = this.latLonWidget.getLon();
            if (Double.isNaN(val)) {
                val = this.defaultLon;
            }
            if (val < -180.0 || val > 180.0) {
                val = this.defaultLon;
            }
            this.setLongitude(val);
            return val;
        }

        public void setLongitude(double val) {
            if (val < -180.0 || val > 180.0) {
                val = this.defaultLon;
            }
            this.latLonWidget.setLon(val);
            this.urlInfo.setLocationLon(val);
        }

        protected void convertToLineEle() {
            double[][] ll = new double[2][1];
            ll[0][0] = this.getLatitude();
            ll[1][0] = this.getLongitude();
            AREACoordinateSystem macs = (AREACoordinateSystem)AddeImageDataSelection.this.sampleProjection;
            double[][] el = AddeImageDataSelection.this.baseAnav.toLinEle(ll);
            try {
                double[][] dArray = macs.fromReference(ll);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.addeImageDataSelection.descriptor == null) {
                int elem = (int)Math.floor(el[0][0] + 0.5);
                int line = (int)Math.floor(el[1][0] + 0.5);
                this.urlInfo.setLocationLine(line);
                this.urlInfo.setLocationElem(elem);
            } else {
                int elem = (int)Math.floor(el[0][0] + 0.5) * Math.abs(this.getElementMagValue());
                int line = (int)Math.floor(el[1][0] + 0.5) * Math.abs(this.getLineMagValue());
                this.urlInfo.setLocationLine(line);
                this.urlInfo.setLocationElem(elem);
            }
            el = AddeImageDataSelection.this.baseAnav.areaCoordToImageCoord(el);
            this.imageElement = (int)Math.floor(el[0][0] + 0.5);
            this.imageLine = (int)Math.floor(el[1][0] + 0.5);
        }

        protected void convertToLatLon() {
            double[][] el1 = this.getLineElement();
            double[][] ll = new double[2][1];
            double[][] el = new double[2][1];
            el[0][0] = el1[0][0] / (double)Math.abs(this.getElementMagValue()) + 0.5;
            el[1][0] = el1[1][0] / (double)Math.abs(this.getLineMagValue()) + 0.5;
            if (AddeImageDataSelection.this.baseAnav == null) {
                return;
            }
            try {
                ll = AddeImageDataSelection.this.baseAnav.toLatLon(el);
                this.setLatitude(ll[0][0]);
                this.setLongitude(ll[1][0]);
            }
            catch (Exception e) {
                System.out.println("convertToLatLon e=" + e);
            }
        }

        public String getCoordinateType() {
            String ret = this.defaultType;
            try {
                ret = (String)this.coordinateTypeComboBox.getSelectedItem();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return ret;
        }

        public int getNumLines() {
            int val = -1;
            try {
                val = Integer.parseInt(this.numLinesFld.getText().trim());
            }
            catch (Exception e) {
                System.out.println("=====> exception in getNumLines: e=" + e);
            }
            this.setNumLines(val);
            return this.numLines;
        }

        public void setNumLines(int val) {
            this.numLines = val;
            if (val >= 0) {
                this.numLinesFld.setText(Integer.toString(val));
            }
            this.urlInfo.setLines(val);
        }

        public int getNumEles() {
            int val = -1;
            try {
                val = Integer.parseInt(this.numElementsFld.getText().trim());
            }
            catch (Exception e) {
                System.out.println("=====> exception in getNumEles: e=" + e);
            }
            this.setNumEles(val);
            return this.numEles;
        }

        public void setNumEles(int val) {
            this.numEles = val = (int)((double)val / 4.0 + 0.5) * 4;
            if (val >= 0) {
                this.numElementsFld.setText(Integer.toString(val));
            }
            this.urlInfo.setElements(val);
        }

        protected void setLineElement() {
            double[][] el = this.getLineElement();
            int elem = (int)Math.floor(el[0][0] + 0.5);
            int line = (int)Math.floor(el[1][0] + 0.5);
            this.urlInfo.setLocationElem(elem);
            this.urlInfo.setLocationLine(line);
            double[][] vals = AddeImageDataSelection.this.baseAnav.areaCoordToImageCoord(el);
            this.imageElement = (int)Math.floor(vals[0][0] + 0.5);
            this.imageLine = (int)Math.floor(vals[1][0] + 0.5);
        }

        public void setLine(int val) {
            if (val < 0) {
                this.centerLineFld.setText("missing");
            } else {
                this.centerLineFld.setText(Integer.toString(val));
            }
        }

        public void setElement(int val) {
            if (val < 0) {
                this.centerElementFld.setText("missing");
            } else {
                this.centerElementFld.setText(Integer.toString(val));
            }
        }

        @Override
        public void applyToDataSelection(DataSelection dataSelection) {
            String regionOption;
            GeoSelection geoSelection = dataSelection.getGeoSelection();
            dataSelection.putProperty("Use_Progressive_Resolution", AddeImageDataSelection.this.getIsProgressiveResolution());
            if (geoSelection != null && !AddeImageDataSelection.this.getIsProgressiveResolution()) {
                geoSelection.setXStride(Math.abs(this.elementMagSlider.getValue()));
                geoSelection.setYStride(Math.abs(this.lineMagSlider.getValue()));
            }
            if ((regionOption = dataSelection.getProperty("Region_Selection_Option", "Use_Default_Area")).equals("Use_Selected_Area") || regionOption.equals("Use_Default_Area")) {
                dataSelection.putProperty("advancedURL", this.urlInfo.cloneMe());
            } else if (regionOption.equals("Match_Display_Area")) {
                ViewManager vm = AddeImageDataSelection.this.dataSource.getIdv().getViewManager();
                NavigatedDisplay navDisplay = ((NavigatedViewManager)vm).getNavigatedDisplay();
                Rectangle sbox = navDisplay.getScreenBounds();
                AddeImageDataSelection.this.dataSource.getIdv().getViewManager().setProjectionFromData(false);
                try {
                    Rectangle2D.Double bbox = navDisplay.getLatLonBox();
                    geoSelection.setLatLonRect(bbox);
                    dataSelection.setGeoSelection(geoSelection);
                    EarthLocation el = navDisplay.screenToEarthLocation((int)(((RectangularShape)sbox).getWidth() / 2.0), (int)(((RectangularShape)sbox).getHeight() / 2.0));
                    LatLonPointImpl llpi = new LatLonPointImpl(el.getLatitude().getValue(), el.getLongitude().getValue());
                    dataSelection.putProperty("centerPosition", llpi);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            dataSelection.putProperty("navType", this.urlInfo.getNavType());
        }

        public String getPlace() {
            String pl = null;
            try {
                pl = this.translatePlace((String)this.locationComboBox.getSelectedItem());
            }
            catch (Exception e) {
                pl = this.defaultPlace;
            }
            this.urlInfo.setPlaceValue(pl);
            return pl;
        }

        protected String translatePlace(String thisPlace) {
            if (thisPlace.equals("Upper Left")) {
                return PLACE_ULEFT;
            }
            if (thisPlace.equals("Center")) {
                return PLACE_CENTER;
            }
            return thisPlace;
        }

        public int getElement() {
            int val = -1;
            try {
                val = Integer.parseInt(this.centerElementFld.getText().trim());
            }
            catch (Exception exception) {
                // empty catch block
            }
            return val;
        }

        public int getLine() {
            int val = -1;
            try {
                if (!this.centerLineFld.getText().equals("missing")) {
                    val = Integer.parseInt(this.centerLineFld.getText().trim());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return val;
        }

        private double[][] getLineElement() {
            double[][] el = new double[2][1];
            el[0][0] = this.getElement();
            el[1][0] = this.getLine();
            return el;
        }

        public void setToFullResolution(Boolean update) {
            this.setPlace(PLACE_CENTER);
            this.setLatitude(this.previewDir.getCenterLatitude());
            this.setLongitude(this.previewDir.getCenterLongitude());
            this.convertToLinEle();
            if (update.booleanValue()) {
                this.setMagSliders(1, 1);
                this.setNumLines(this.maxLines);
                this.updateImageHeightSize();
                this.setNumEles(this.maxEles);
                this.updateImageWidthSize();
            } else {
                this.setNumLines(this.maxLines / Math.abs(this.getLineMagValue()));
                this.setNumEles(this.maxEles / Math.abs(this.getElementMagValue()));
            }
            this.amUpdating = true;
            this.lineMagSliderChanged(false);
            this.elementMagSliderChanged(false);
            this.amUpdating = false;
        }

        private void setMagSliders(int lineValue, int elementValue) {
            if (this.lineMagSlider != null) {
                if (lineValue > 0) {
                    --lineValue;
                } else if (lineValue < 0) {
                    ++lineValue;
                }
                if (elementValue > 0) {
                    --elementValue;
                } else if (elementValue < 0) {
                    ++elementValue;
                }
                this.lineMagSlider.setValue(lineValue);
                this.urlInfo.setLineMag(this.getLineMagValue());
                this.elementMagSlider.setValue(elementValue);
                this.urlInfo.setElementMag(this.getElementMagValue());
                this.lineMagLbl.setText(StringUtil.padLeft("" + this.getLineMagValue(), 3));
                this.elementMagLbl.setText(StringUtil.padLeft("" + this.getElementMagValue(), 3));
                this.linesToElements = Math.abs((double)lineValue / (double)elementValue);
                if (Double.isNaN(this.linesToElements)) {
                    this.linesToElements = 1.0;
                }
            }
        }

        public void setPlace(String str) {
            if (str.equals("")) {
                str = this.defaultPlace;
            }
            this.urlInfo.setPlaceValue(str);
            if (str.equals(PLACE_CENTER)) {
                this.locationComboBox.setSelectedItem("Center");
            } else {
                this.locationComboBox.setSelectedItem("Upper Left");
            }
        }

        protected void convertToLinEle() {
            try {
                double[][] el = new double[2][1];
                double[][] ll = new double[2][1];
                AREACoordinateSystem macs = (AREACoordinateSystem)AddeImageDataSelection.this.sampleProjection;
                ll[0][0] = this.getLatitude();
                ll[1][0] = this.getLongitude();
                String coordType = this.getCoordinateType();
                el = AddeImageDataSelection.this.baseAnav.toLinEle(ll);
                this.setLine((int)el[1][0]);
                this.setElement((int)el[0][0]);
            }
            catch (Exception e) {
                System.out.println("convertToLinEle e=" + e);
            }
        }
    }
}

