/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.data.imagery;

import edu.wisc.ssec.mcidas.AREAnav;
import edu.wisc.ssec.mcidas.AreaDirectory;
import edu.wisc.ssec.mcidas.adde.AddeTextReader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import ucar.unidata.data.DataChoice;
import ucar.unidata.data.DataSelection;
import ucar.unidata.data.DataSelectionComponent;
import ucar.unidata.data.GeoSelection;
import ucar.unidata.data.imagery.AddeImageDataSource;
import ucar.unidata.data.imagery.AddeImageDescriptor;
import ucar.unidata.data.imagery.AddeImagePreviewPanel;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.ProjectionPoint;
import ucar.unidata.geoloc.ProjectionRect;
import ucar.unidata.ui.LatLonWidget;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.Misc;
import ucar.unidata.util.StringUtil;
import ucar.unidata.view.geoloc.NavigatedPanel;
import visad.VisADException;
import visad.data.mcidas.AREACoordinateSystem;
import visad.georef.MapProjection;

public class AddeImageAdvancedPanel
extends DataSelectionComponent {
    public JPanel advance;
    private Rectangle2D.Float new_bb;
    private JPanel MasterPanel;
    private String source;
    AddeImageDescriptor descriptor;
    private JCheckBox chkUseFull;
    private Hashtable propToComps = new Hashtable();
    protected int GRID_SPACING = 3;
    protected Insets GRID_INSETS = new Insets(this.GRID_SPACING, this.GRID_SPACING, this.GRID_SPACING, this.GRID_SPACING);
    protected JSlider lineMagSlider;
    protected JSlider elementMagSlider;
    JLabel lineMagLbl = new JLabel();
    private JPanel leMagPanel;
    private static final int SLIDER_MAX = 29;
    private static final int SLIDER_WIDTH = 150;
    private static final int SLIDER_HEIGHT = 16;
    boolean amSettingProperties = false;
    private int lineMag;
    private int elementMag;
    private String kmLbl = " km";
    JLabel elementMagLbl = new JLabel();
    JCheckBox prograssiveCbx;
    protected static final String TYPE_LATLON = "Latitude/Longitude";
    protected static final String TYPE_AREA = "Area Coordinates";
    String[] coordinateTypes = new String[]{"Latitude/Longitude", "Area Coordinates"};
    String[] locations = new String[]{"Center", "Upper Left"};
    JComboBox coordinateTypeComboBox;
    JComboBox locationComboBox;
    protected LatLonWidget latLonWidget = new LatLonWidget();
    JTextField numElementsFld = new JTextField();
    JTextField numLinesFld = new JTextField();
    JTextField centerLineFld = new JTextField();
    JTextField centerElementFld = new JTextField();
    private int defaultNumLines = 1000;
    private int defaultNumEles = 1000;
    private int numLines = this.defaultNumLines;
    private int numEles = this.defaultNumEles;
    private double latitude;
    private double defaultLat = Double.NaN;
    private double longitude;
    private double defaultLon = Double.NaN;
    private int imageLine;
    private int areaLine;
    private int areaElement;
    private int imageElement;
    private String defaultType = "Latitude/Longitude";
    private JPanel lockPanel;
    private JPanel latLonPanel;
    private JPanel lineElementPanel;
    private JLabel centerLatLbl = new JLabel();
    private JLabel centerLonLbl = new JLabel();
    private JLabel centerLineLbl = new JLabel();
    private JLabel centerElementLbl = new JLabel();
    protected GuiUtils.CardLayoutPanel locationPanel;
    private AddeImageDataSource dataSource;
    private boolean isLineEle = false;
    AREAnav baseAnav;
    JPanel sizePanel;
    AddeImagePreviewPanel region;
    boolean isFromRegionUpdate = false;
    private double linesToElements = 1.0;
    private double baseNumLines = 0.0;
    private double baseNumElements = 0.0;
    protected boolean amUpdating = false;
    private String place;
    MapProjection sampleProjection;
    private int maxLines = 0;
    private int maxEles = 0;
    private AREAnav previewNav;
    private AreaDirectory previewDir;
    protected static final String PLACE_CENTER = "CENTER";
    protected static final String PLACE_ULEFT = "ULEFT";
    private String defaultPlace = "CENTER";
    JLabel sizeLbl;
    private JToggleButton linkBtn;
    private JButton fullResBtn;
    JLabel rawSizeLbl = new JLabel();
    DataChoice dataChoice;

    public AddeImageAdvancedPanel(AddeImageDataSource dataSource, DataChoice dc, String source, AREAnav baseAnav, AddeImageDescriptor descriptor, MapProjection sample, AddeImagePreviewPanel region) throws IOException, ParseException, VisADException {
        super("Advanced");
        this.dataSource = dataSource;
        this.source = source;
        this.descriptor = descriptor;
        this.baseAnav = baseAnav;
        this.previewNav = baseAnav;
        this.dataChoice = dc;
        this.sampleProjection = sample;
        this.region = region;
        String magVal = AddeImageDataSource.getKey(source, "MAG");
        String[] magVals = magVal.split(" ");
        this.elementMag = new Integer(magVals[1]);
        this.lineMag = new Integer(magVals[0]);
        AreaDirectory aDir = descriptor.getDirectory();
        this.isLineEle = true;
        double cLat = aDir.getCenterLatitude();
        double cLon = aDir.getCenterLongitude();
        this.setLatitude(cLat);
        this.setLongitude(cLon);
        this.convertToLineEle();
        this.previewDir = aDir;
        this.baseNumLines = aDir.getLines();
        this.baseNumElements = aDir.getElements();
        this.sampleProjection = sample;
        this.place = AddeImageDataSource.getKey(source, "PLACE");
    }

    public void setBaseNumLines(int lines) {
        this.baseNumLines = lines;
    }

    public void setBaseNumElements(int eles) {
        this.baseNumElements = eles;
    }

    public boolean getIsFromRegionUpdate() {
        return this.isFromRegionUpdate;
    }

    public void setIsFromRegionUpdate(boolean isRegion) {
        this.isFromRegionUpdate = isRegion;
    }

    public void updatePlace() {
        Object llr = null;
        String newPlace = this.getPlace();
        NavigatedPanel navigatedPanel = this.dataSource.addeImageDataSelection.getRegionPanel().display.getNavigatedPanel();
        ProjectionRect rect = navigatedPanel.getSelectedRegion();
        if (rect == null) {
            return;
        }
        ProjectionImpl projectionImpl = this.dataSource.addeImageDataSelection.getRegionPanel().display.getProjectionImpl();
        ProjectionRect newRect = new ProjectionRect();
        newRect.setHeight(rect.getHeight());
        newRect.setWidth(rect.getWidth());
        LatLonRect latLonRectOld = projectionImpl.projToLatLonBB(rect);
        if (newPlace.equals(PLACE_CENTER)) {
            double lat = this.getLatitude();
            double lon = this.getLongitude();
            LatLonPointImpl ll0 = new LatLonPointImpl(lat, lon);
            ProjectionPoint pp0 = projectionImpl.latLonToProj(ll0);
            double x = pp0.getX() - rect.getWidth() / 2.0;
            double y = pp0.getY() - rect.getHeight() / 2.0;
            newRect.setX(x);
            newRect.setY(y);
        } else {
            double lat = this.getLatitude();
            double lon = this.getLongitude();
            LatLonPointImpl ll0 = new LatLonPointImpl(lat, lon);
            ProjectionPoint pp0 = projectionImpl.latLonToProj(ll0);
            double x = pp0.getX();
            double y = pp0.getY() - rect.getHeight();
            newRect.setX(x);
            newRect.setY(y);
        }
        navigatedPanel.setSelectedRegion(newRect);
    }

    public void updateImageWidthSize() {
        NavigatedPanel navigatedPanel = this.dataSource.addeImageDataSelection.getRegionPanel().display.getNavigatedPanel();
        ProjectionRect rect = navigatedPanel.getSelectedRegion();
        if (rect == null) {
            return;
        }
        ProjectionRect newRect = new ProjectionRect();
        newRect.setX(rect.getX());
        newRect.setY(rect.getY());
        newRect.setHeight(rect.getHeight());
        int newNumEles = this.getNumEles();
        int mag0 = this.getElementMagValue();
        double newWidth = rect.getWidth() * ((double)(newNumEles *= Math.abs(mag0)) * 1.0 / this.baseNumElements);
        newRect.setWidth(newWidth);
        navigatedPanel.setSelectedRegion(newRect);
        this.updatePlace();
    }

    public void updateImageHeightSize() {
        NavigatedPanel navigatedPanel = this.dataSource.addeImageDataSelection.getRegionPanel().display.getNavigatedPanel();
        ProjectionRect rect = navigatedPanel.getSelectedRegion();
        if (rect == null) {
            return;
        }
        ProjectionRect newRect = new ProjectionRect();
        newRect.setX(rect.getX());
        newRect.setY(rect.getY());
        newRect.setWidth(rect.getWidth());
        int newNumLines = this.getNumLines();
        int mag0 = this.getLineMagValue();
        double newHeight = rect.getHeight() * ((double)(newNumLines *= Math.abs(mag0)) * 1.0 / this.baseNumLines);
        newRect.setHeight(newHeight);
        navigatedPanel.setSelectedRegion(newRect);
        this.baseNumLines = newNumLines;
        this.updatePlace();
    }

    public void enablePanel(JPanel panel, boolean enable) {
        ArrayList<Component> cList = new ArrayList<Component>();
        Component[] ac = panel.getComponents();
        for (int i = 0; i < ac.length; ++i) {
            Component a = ac[i];
            cList.add(a);
        }
        GuiUtils.enableComponents(cList, enable);
    }

    public void enablePanelAll(boolean enable) {
        this.coordinateTypeComboBox.setEnabled(enable);
        this.locationComboBox.setEnabled(enable);
        this.enablePanel(this.locationPanel, enable);
        this.enablePanel(this.lockPanel, enable);
        this.enablePanel(this.leMagPanel, enable);
        this.enablePanel(this.sizePanel, enable);
    }

    protected String getUrl() {
        String str = this.source;
        str = str.replaceFirst("imagedata", "text");
        int indx = str.indexOf("VERSION");
        str = str.substring(0, indx);
        str = str.concat("file=SATBAND");
        return str;
    }

    protected List readTextLines(String url) {
        AddeTextReader reader = new AddeTextReader(url);
        Vector lines = null;
        if ("OK".equals(reader.getStatus())) {
            lines = reader.getLinesOfText();
        }
        return lines;
    }

    private float[] getLineEleResolution(AreaDirectory ad) {
        float[] res = new float[]{1.0f, 1.0f};
        int sensor = ad.getSensorID();
        List lines = null;
        try {
            String buff = this.getUrl();
            lines = this.readTextLines(buff);
            if (lines == null) {
                return res;
            }
            int gotit = -1;
            String[] cards = StringUtil.listToStringArray(lines);
            for (int i = 0; i < cards.length; ++i) {
                if (!cards[i].startsWith("Sat ")) continue;
                StringTokenizer st = new StringTokenizer(cards[i], " ");
                String temp = st.nextToken();
                int m = st.countTokens();
                for (int k = 0; k < m; ++k) {
                    int ss = Integer.parseInt(st.nextToken().trim());
                    if (ss != sensor) continue;
                    gotit = i;
                    break;
                }
                if (gotit != -1) break;
            }
            if (gotit == -1) {
                return res;
            }
            int gotSrc = -1;
            for (int i = gotit; i < cards.length; ++i) {
                if (cards[i].startsWith("EndSat")) {
                    return res;
                }
                if (!cards[i].startsWith("B")) continue;
                StringTokenizer tok = new StringTokenizer(cards[i]);
                String str = tok.nextToken();
                str = tok.nextToken();
                Float flt = new Float(str);
                res[0] = flt.floatValue();
                str = tok.nextToken();
                flt = new Float(str);
                res[1] = flt.floatValue();
                return res;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return res;
    }

    protected JComponent addPropComp(String propId, JComponent comp) {
        Object oldComp = this.propToComps.get(propId);
        if (oldComp != null) {
            throw new IllegalStateException("Already have a component defined:" + propId);
        }
        this.propToComps.put(propId, comp);
        return comp;
    }

    protected void elementMagSliderChanged(boolean autoSetSize) {
        int value = this.getElementMagValue();
        if (Math.abs(value) < 29) {
            int lineMag = this.getLineMagValue();
            this.linesToElements = lineMag > value ? Math.abs((double)lineMag / (double)value) : Math.abs((double)value / (double)lineMag);
        }
        this.elementMagLbl.setText(StringUtil.padLeft("" + value, 3));
        if (autoSetSize) {
            if (value > 0) {
                this.numElementsFld.setText("" + (int)(this.baseNumElements * (double)value));
            } else {
                this.numElementsFld.setText("" + (int)(this.baseNumElements / (double)(-value)));
            }
        }
    }

    protected void lineMagSliderChanged(boolean autoSetSize) {
        try {
            int value = this.getLineMagValue();
            this.lineMagLbl.setText(StringUtil.padLeft("" + value, 3));
            if (autoSetSize) {
                if (value > 0) {
                    this.numLinesFld.setText("" + (int)(this.baseNumLines * (double)value));
                } else {
                    this.numLinesFld.setText("" + (int)(this.baseNumLines / (double)(-value)));
                }
            }
            value = value == 1 ? (this.linesToElements < 1.0 ? (int)((double)(-value) / this.linesToElements) : (int)((double)value * this.linesToElements)) : (value > 1 ? (int)((double)value * this.linesToElements) : (int)((double)value / this.linesToElements));
            value = value > 0 ? value - 1 : value + 1;
            this.amSettingProperties = true;
            this.elementMagSlider.setValue(value);
            this.amSettingProperties = false;
            this.elementMagSliderChanged(autoSetSize);
        }
        catch (Exception exc) {
            System.out.println("Setting line magnification" + exc);
        }
    }

    public void setElementMagSlider(int value) {
        this.elementMagSlider.setValue(value);
        this.elementMagLbl.setText(StringUtil.padLeft("" + value, 3));
    }

    public void setLineMagSlider(int value) {
        this.lineMagSlider.setValue(value);
        this.lineMagLbl.setText(StringUtil.padLeft("" + value, 3));
    }

    protected int getLineMagValue() {
        if (this.lineMagSlider == null) {
            return this.lineMag;
        }
        return this.getMagValue(this.lineMagSlider);
    }

    protected int getElementMagValue() {
        if (this.elementMagSlider == null) {
            return this.elementMag;
        }
        int val = this.getMagValue(this.elementMagSlider);
        return val;
    }

    private int getMagValue(JSlider slider) {
        int value = slider.getValue();
        if (value >= 0) {
            return value + 1;
        }
        return value;
    }

    public String getFileName() {
        return this.source;
    }

    @Override
    protected JComponent doMakeContents() {
        ArrayList<JComponent> allComps0 = new ArrayList<JComponent>();
        ArrayList<JComponent> allComps1 = new ArrayList<JComponent>();
        ArrayList<JComponent> allComps2 = new ArrayList<JComponent>();
        ArrayList<JComponent> allComps3 = new ArrayList<JComponent>();
        Insets dfltGridSpacing = new Insets(4, 0, 4, 0);
        String dfltLblSpacing = " ";
        JPanel propComp = null;
        this.prograssiveCbx = new JCheckBox("", true);
        this.prograssiveCbx.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean showMagSection = !((JCheckBox)e.getSource()).isSelected();
                AddeImageAdvancedPanel.this.enablePanel(AddeImageAdvancedPanel.this.leMagPanel, showMagSection);
            }
        });
        allComps0.add(GuiUtils.rLabel("Progressive Resolution:"));
        allComps0.add(GuiUtils.left(this.prograssiveCbx));
        allComps1.add(new JLabel(" "));
        allComps1.add(new JLabel(" "));
        this.coordinateTypeComboBox = new JComboBox<String>(this.coordinateTypes);
        this.coordinateTypeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                int selectedIndex = AddeImageAdvancedPanel.this.coordinateTypeComboBox.getSelectedIndex();
                AddeImageAdvancedPanel.this.flipLocationPanel(selectedIndex);
            }
        });
        allComps1.add(GuiUtils.rLabel(" Coordinates: "));
        allComps1.add(GuiUtils.left(this.coordinateTypeComboBox));
        allComps1.add(new JLabel(" "));
        allComps1.add(new JLabel(" "));
        this.locationComboBox = new JComboBox<String>(this.locations);
        this.setPlace(this.place);
        allComps1.add(GuiUtils.rLabel(" Location: "));
        allComps1.add(GuiUtils.left(this.locationComboBox));
        ActionListener latLonChange = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                String type = AddeImageAdvancedPanel.this.getCoordinateType();
                if (type.equals(AddeImageAdvancedPanel.TYPE_LATLON)) {
                    AddeImageAdvancedPanel.this.setLatitude();
                    AddeImageAdvancedPanel.this.setLongitude();
                    AddeImageAdvancedPanel.this.convertToLineEle();
                    AddeImageAdvancedPanel.this.updatePlace();
                } else {
                    AddeImageAdvancedPanel.this.setLineElement();
                    AddeImageAdvancedPanel.this.convertToLatLon();
                    AddeImageAdvancedPanel.this.updatePlace();
                }
            }
        };
        FocusListener linEleFocusChange = new FocusListener(){

            @Override
            public void focusGained(FocusEvent fe) {
            }

            @Override
            public void focusLost(FocusEvent fe) {
                AddeImageAdvancedPanel.this.setLineElement();
                AddeImageAdvancedPanel.this.convertToLatLon();
                AddeImageAdvancedPanel.this.updatePlace();
            }
        };
        if (this.latLonWidget == null) {
            this.latLonWidget = new LatLonWidget(latLonChange);
        }
        FocusListener latLonFocusChange = new FocusListener(){

            @Override
            public void focusGained(FocusEvent fe) {
                JTextField latFld = AddeImageAdvancedPanel.this.latLonWidget.getLatField();
                latFld.setCaretPosition(latFld.getText().length());
                JTextField lonFld = AddeImageAdvancedPanel.this.latLonWidget.getLonField();
                lonFld.setCaretPosition(lonFld.getText().length());
            }

            @Override
            public void focusLost(FocusEvent fe) {
                AddeImageAdvancedPanel.this.setLatitude();
                AddeImageAdvancedPanel.this.setLongitude();
                AddeImageAdvancedPanel.this.convertToLineEle();
                AddeImageAdvancedPanel.this.updatePlace();
            }
        };
        if (!this.isLineEle) {
            this.latLonWidget.setLatLon(this.latitude, this.longitude);
        }
        String lineStr = "";
        String eleStr = "";
        this.centerLineFld = new JTextField(lineStr, 3);
        this.centerLineFld.addActionListener(latLonChange);
        this.centerLineFld.addFocusListener(linEleFocusChange);
        this.centerElementFld = new JTextField(eleStr, 3);
        this.centerElementFld.addActionListener(latLonChange);
        this.centerElementFld.addFocusListener(linEleFocusChange);
        final JButton centerPopupBtn = GuiUtils.getImageButton("/auxdata/ui/icons/MapIcon16.png", this.getClass());
        centerPopupBtn.setToolTipText("Center on current displays");
        centerPopupBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                AddeImageAdvancedPanel.this.dataSource.getDataContext().getIdv().getIdvUIManager().popupCenterMenu(centerPopupBtn, AddeImageAdvancedPanel.this.latLonWidget);
            }
        });
        JPanel centerPopup = GuiUtils.inset((Component)centerPopupBtn, new Insets(0, 0, 0, 4));
        JTextField latFld = this.latLonWidget.getLatField();
        JTextField lonFld = this.latLonWidget.getLonField();
        latFld.addFocusListener(latLonFocusChange);
        lonFld.addFocusListener(latLonFocusChange);
        Component[] componentArray = new Component[6];
        this.centerLatLbl = GuiUtils.rLabel(" Lat:" + dfltLblSpacing);
        componentArray[0] = this.centerLatLbl;
        componentArray[1] = latFld;
        this.centerLonLbl = GuiUtils.rLabel(" Lon:" + dfltLblSpacing);
        componentArray[2] = this.centerLonLbl;
        componentArray[3] = lonFld;
        componentArray[4] = new JLabel(" ");
        componentArray[5] = centerPopup;
        this.latLonPanel = GuiUtils.hbox(componentArray);
        Component[] componentArray2 = new Component[4];
        this.centerLineLbl = GuiUtils.rLabel(" Line:" + dfltLblSpacing);
        componentArray2[0] = this.centerLineLbl;
        componentArray2[1] = this.centerLineFld;
        this.centerElementLbl = GuiUtils.rLabel(" Element:" + dfltLblSpacing);
        componentArray2[2] = this.centerElementLbl;
        componentArray2[3] = this.centerElementFld;
        this.lineElementPanel = GuiUtils.hbox(componentArray2);
        this.locationPanel = new GuiUtils.CardLayoutPanel();
        this.locationPanel.addCard(this.latLonPanel);
        this.locationPanel.addCard(this.lineElementPanel);
        allComps1.add(GuiUtils.rLabel("  "));
        allComps1.add(GuiUtils.left(this.locationPanel));
        allComps1.add(new JLabel(" "));
        allComps1.add(new JLabel(" "));
        this.lockPanel = GuiUtils.left(GuiUtils.doLayout(new Component[]{new JLabel(" "), this.getLinkButton()}, 2, GuiUtils.WT_N, GuiUtils.WT_N));
        allComps2.add(GuiUtils.rLabel("Link Image Size And Magnification:"));
        allComps2.add(GuiUtils.left(this.lockPanel));
        allComps3.add(new JLabel(" "));
        allComps3.add(new JLabel(" "));
        ActionListener lSizeChange = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                int lines = AddeImageAdvancedPanel.this.getNumLines() * Math.abs(AddeImageAdvancedPanel.this.getLineMagValue());
                if (lines > AddeImageAdvancedPanel.this.maxLines) {
                    lines = AddeImageAdvancedPanel.this.maxLines;
                }
                AddeImageAdvancedPanel.this.updateImageHeightSize();
            }
        };
        ActionListener eSizeChange = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                int eles = AddeImageAdvancedPanel.this.getNumEles() * Math.abs(AddeImageAdvancedPanel.this.getElementMagValue());
                if (eles > AddeImageAdvancedPanel.this.maxEles) {
                    eles = AddeImageAdvancedPanel.this.maxEles;
                }
                AddeImageAdvancedPanel.this.updateImageWidthSize();
            }
        };
        FocusListener lSizeFocusChange = new FocusListener(){

            @Override
            public void focusGained(FocusEvent fe) {
            }

            @Override
            public void focusLost(FocusEvent fe) {
                int lines = AddeImageAdvancedPanel.this.getNumLines() * Math.abs(AddeImageAdvancedPanel.this.getLineMagValue());
                if (lines > AddeImageAdvancedPanel.this.maxLines) {
                    lines = AddeImageAdvancedPanel.this.maxLines;
                }
                AddeImageAdvancedPanel.this.updateImageHeightSize();
            }
        };
        FocusListener eSizeFocusChange = new FocusListener(){

            @Override
            public void focusGained(FocusEvent fe) {
            }

            @Override
            public void focusLost(FocusEvent fe) {
                int eles = AddeImageAdvancedPanel.this.getNumEles() * Math.abs(AddeImageAdvancedPanel.this.getElementMagValue());
                if (eles > AddeImageAdvancedPanel.this.maxEles) {
                    eles = AddeImageAdvancedPanel.this.maxEles;
                }
                AddeImageAdvancedPanel.this.updateImageWidthSize();
            }
        };
        this.maxLines = this.previewDir.getLines();
        this.maxEles = this.previewDir.getElements();
        int lmag = this.getLineMagValue();
        int emag = this.getElementMagValue();
        if (lmag < 0) {
            this.numLines = this.maxLines / Math.abs(lmag);
        }
        if (emag < 0) {
            this.numEles = this.maxEles / Math.abs(emag);
        }
        this.setNumLines(this.numLines);
        this.numLinesFld = new JTextField(Integer.toString(this.numLines), 4);
        this.numLinesFld.addActionListener(lSizeChange);
        this.numLinesFld.addFocusListener(lSizeFocusChange);
        this.setNumEles(this.numEles);
        this.numElementsFld = new JTextField(Integer.toString(this.numEles), 4);
        this.numElementsFld.addActionListener(eSizeChange);
        this.numElementsFld.addFocusListener(eSizeFocusChange);
        this.numLinesFld.setToolTipText("Number of lines");
        this.numElementsFld.setToolTipText("Number of elements");
        GuiUtils.tmpInsets = dfltGridSpacing;
        this.sizeLbl = GuiUtils.lLabel("");
        this.fullResBtn = GuiUtils.makeImageButton("/auxdata/ui/icons/arrow_out.png", this, "setToFullResolution", new Boolean(true));
        this.fullResBtn.setContentAreaFilled(false);
        this.fullResBtn.setToolTipText("Set fields to retrieve full image");
        this.rawSizeLbl = new JLabel(" Raw size: " + this.maxLines + " X " + this.maxEles);
        this.sizePanel = GuiUtils.left(GuiUtils.doLayout(new Component[]{this.numLinesFld, new JLabel(" X "), this.numElementsFld, this.sizeLbl, new JLabel(" "), this.fullResBtn, new JLabel("  "), this.rawSizeLbl}, 8, GuiUtils.WT_N, GuiUtils.WT_N));
        allComps3.add(GuiUtils.rLabel("Image Size:"));
        allComps3.add(GuiUtils.left(this.sizePanel));
        allComps3.add(new JLabel(" "));
        allComps3.add(new JLabel(" "));
        boolean oldAmSettingProperties = this.amSettingProperties;
        this.amSettingProperties = true;
        ChangeListener lineListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                if (AddeImageAdvancedPanel.this.amSettingProperties) {
                    return;
                }
                AddeImageAdvancedPanel.this.lineMagSliderChanged(AddeImageAdvancedPanel.this.getLinkButton().isSelected());
            }
        };
        ChangeListener elementListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                if (AddeImageAdvancedPanel.this.amSettingProperties) {
                    return;
                }
                AddeImageAdvancedPanel.this.elementMagSliderChanged(AddeImageAdvancedPanel.this.getLinkButton().isSelected());
            }
        };
        JComponent[] lineMagComps = GuiUtils.makeSliderPopup(-29, 1, 0, lineListener);
        this.lineMagSlider = (JSlider)lineMagComps[1];
        this.lineMagSlider.setMajorTickSpacing(1);
        this.lineMagSlider.setSnapToTicks(true);
        this.lineMagSlider.setExtent(1);
        this.lineMagSlider.getModel().setValue(lmag);
        lineMagComps[0].setToolTipText("Change the line magnification");
        JComponent[] elementMagComps = GuiUtils.makeSliderPopup(-29, 1, 0, elementListener);
        this.elementMagSlider = (JSlider)elementMagComps[1];
        this.elementMagSlider.setExtent(1);
        this.elementMagSlider.setMajorTickSpacing(1);
        this.elementMagSlider.setSnapToTicks(true);
        this.elementMagSlider.setValue(emag);
        elementMagComps[0].setToolTipText("Change the element magnification");
        this.lineMagSlider.setToolTipText("Slide to set line magnification factor");
        this.lineMagLbl = GuiUtils.getFixedWidthLabel(StringUtil.padLeft(String.valueOf(lmag), 3));
        this.elementMagSlider.setToolTipText("Slide to set element magnification factor");
        this.elementMagLbl = GuiUtils.getFixedWidthLabel(StringUtil.padLeft(String.valueOf(emag), 3));
        this.amSettingProperties = oldAmSettingProperties;
        GuiUtils.tmpInsets = new Insets(0, 0, 0, 0);
        this.leMagPanel = GuiUtils.left(GuiUtils.doLayout(new Component[]{this.lineMagLbl, GuiUtils.inset((Component)lineMagComps[0], new Insets(0, 4, 0, 0)), new JLabel("    X"), this.elementMagLbl, GuiUtils.inset((Component)elementMagComps[0], new Insets(0, 4, 0, 0))}, 6, GuiUtils.WT_N, GuiUtils.WT_N));
        propComp = GuiUtils.hbox(new Component[]{this.leMagPanel}, 1);
        allComps3.add(GuiUtils.rLabel("Magnification:"));
        allComps3.add(GuiUtils.left(propComp));
        JPanel imagePanel = GuiUtils.vbox(GuiUtils.doLayout(allComps0, 2, GuiUtils.WT_NY, GuiUtils.WT_N), GuiUtils.doLayout(allComps1, 2, GuiUtils.WT_NY, GuiUtils.WT_N), GuiUtils.doLayout(allComps2, 2, GuiUtils.WT_NY, GuiUtils.WT_N), GuiUtils.doLayout(allComps3, 2, GuiUtils.WT_NY, GuiUtils.WT_N));
        this.advance = GuiUtils.top(imagePanel);
        boolean showMagSection = !this.prograssiveCbx.isSelected();
        this.enablePanel(this.leMagPanel, showMagSection);
        this.enablePanel(this.sizePanel, showMagSection);
        String s0 = AddeImageDataSource.getKey(this.source, "LINELE");
        if (s0 != null && s0.length() > 1) {
            this.coordinateTypeComboBox.setSelectedIndex(1);
        }
        this.chkUseFull = new JCheckBox("Use Default");
        this.chkUseFull.setSelected(true);
        JScrollPane jsp = new JScrollPane();
        jsp.getViewport().setView(this.advance);
        JPanel labelsPanel = null;
        labelsPanel = new JPanel();
        labelsPanel.setLayout(new BoxLayout(labelsPanel, 1));
        this.MasterPanel = new JPanel(new BorderLayout());
        this.MasterPanel.add((Component)labelsPanel, "North");
        this.MasterPanel.add((Component)jsp, "Center");
        if (this.dataSource.addeImageDataSelection.getRegionPanel() != null) {
            String opStr = this.dataSource.addeImageDataSelection.getRegionPanel().getRegionOptions();
            if (opStr.equals("Use Selected")) {
                this.enablePanelAll(true);
            } else {
                this.enablePanelAll(false);
            }
        }
        return this.MasterPanel;
    }

    private JToggleButton getLinkButton() {
        if (this.linkBtn == null) {
            this.linkBtn = GuiUtils.getToggleImageButton("/auxdata/ui/icons/link_break.png", "/auxdata/ui/icons/link.png", 0, 0, true);
            this.linkBtn.setContentAreaFilled(false);
            this.linkBtn.setSelected(true);
            this.linkBtn.setToolTipText("Link changing image size with magnification factors");
        }
        return this.linkBtn;
    }

    protected void flipLocationPanel(int locPanel) {
        int nowPlaying = this.locationPanel.getVisibleIndex();
        if (locPanel > 0) {
            if (nowPlaying == 0) {
                this.locationPanel.flip();
            }
            this.setIsLineEle(true);
            String type = this.getCoordinateType();
            int ele = this.imageElement;
            int lin = this.imageLine;
            if (type.equals(TYPE_AREA)) {
                ele = this.areaElement;
                lin = this.areaLine;
            }
            this.setElement(ele);
            this.setLine(lin);
        } else {
            if (nowPlaying > 0) {
                this.locationPanel.flip();
            }
            this.setIsLineEle(false);
        }
    }

    public void setIsLineEle(boolean val) {
        this.isLineEle = val;
    }

    public boolean getIsProgressiveResolution() {
        return this.prograssiveCbx.isSelected();
    }

    public double getLatitude() {
        double val = this.latLonWidget.getLat();
        if (Double.isNaN(val)) {
            val = this.defaultLat;
        }
        if (val < -90.0 || val > 90.0) {
            val = this.defaultLat;
        }
        this.setLatitude(val);
        return this.latitude;
    }

    private void setLatitude() {
        this.latitude = this.latLonWidget.getLat();
    }

    public void setLatitude(double val) {
        if (val < -90.0 || val > 90.0) {
            val = this.defaultLat;
        }
        this.latLonWidget.setLat(val);
        this.latitude = val;
    }

    private void setLongitude() {
        this.longitude = this.latLonWidget.getLon();
    }

    public double getLongitude() {
        double val = this.latLonWidget.getLon();
        if (Double.isNaN(val)) {
            val = this.defaultLon;
        }
        if (val < -180.0 || val > 180.0) {
            val = this.defaultLon;
        }
        this.setLongitude(val);
        return this.longitude;
    }

    public void setLongitude(double val) {
        if (val < -180.0 || val > 180.0) {
            val = this.defaultLon;
        }
        this.latLonWidget.setLon(val);
        this.longitude = val;
    }

    protected void convertToLineEle() {
        double[][] ll = new double[2][1];
        ll[0][0] = this.getLatitude();
        ll[1][0] = this.getLongitude();
        AREACoordinateSystem macs = (AREACoordinateSystem)this.sampleProjection;
        double[][] el = this.baseAnav.toLinEle(ll);
        try {
            double[][] dArray = macs.fromReference(ll);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.areaElement = (int)Math.floor(el[0][0] + 0.5) * Math.abs(this.getElementMagValue());
        this.areaLine = (int)Math.floor(el[1][0] + 0.5) * Math.abs(this.getLineMagValue());
        el = this.baseAnav.areaCoordToImageCoord(el);
        this.imageElement = (int)Math.floor(el[0][0] + 0.5);
        this.imageLine = (int)Math.floor(el[1][0] + 0.5);
    }

    protected void convertToLatLon() {
        double[][] el1 = this.getLineElement();
        double[][] ll = new double[2][1];
        double[][] el = new double[2][1];
        el[0][0] = el1[0][0] / (double)Math.abs(this.getElementMagValue()) + 0.5;
        el[1][0] = el1[1][0] / (double)Math.abs(this.getLineMagValue()) + 0.5;
        try {
            ll = this.baseAnav.toLatLon(el);
            this.setLatitude(ll[0][0]);
            this.setLongitude(ll[1][0]);
        }
        catch (Exception e) {
            System.out.println("convertToLatLon e=" + e);
        }
    }

    public String getCoordinateType() {
        String ret = this.defaultType;
        try {
            ret = (String)this.coordinateTypeComboBox.getSelectedItem();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    public int getNumLines() {
        int val = -1;
        try {
            val = Integer.parseInt(this.numLinesFld.getText().trim());
        }
        catch (Exception e) {
            System.out.println("=====> exception in getNumLines: e=" + e);
        }
        this.setNumLines(val);
        return this.numLines;
    }

    private void setNumberOfLines(int val) {
        this.numLinesFld.setText(Integer.toString(val));
    }

    public void setNumLines(int val) {
        this.numLines = val;
        if (val >= 0) {
            this.setNumberOfLines(val);
        }
    }

    public int getNumEles() {
        int val = -1;
        try {
            val = Integer.parseInt(this.numElementsFld.getText().trim());
        }
        catch (Exception e) {
            System.out.println("=====> exception in getNumEles: e=" + e);
        }
        this.setNumEles(val);
        return this.numEles;
    }

    public void setNumEles(int val) {
        this.numEles = val = (int)((double)val / 4.0 + 0.5) * 4;
        if (val >= 0) {
            this.setNumberOfElements(val);
        }
    }

    private void setNumberOfElements(int val) {
        this.numElementsFld.setText(Integer.toString(val));
    }

    protected void setLineElement() {
        double[][] el = this.getLineElement();
        this.areaElement = (int)Math.floor(el[0][0] + 0.5);
        this.areaLine = (int)Math.floor(el[1][0] + 0.5);
        double[][] vals = this.baseAnav.areaCoordToImageCoord(el);
        this.imageElement = (int)Math.floor(vals[0][0] + 0.5);
        this.imageLine = (int)Math.floor(vals[1][0] + 0.5);
    }

    public void setLine(int val) {
        if (val < 0) {
            this.centerLineFld.setText("missing");
        } else {
            this.centerLineFld.setText(Integer.toString(val));
        }
    }

    public void setElement(int val) {
        if (val < 0) {
            this.centerElementFld.setText("missing");
        } else {
            this.centerElementFld.setText(Integer.toString(val));
        }
    }

    @Override
    public void applyToDataSelection(DataSelection dataSelection) {
        String regionOption;
        GeoSelection geoSelection = dataSelection.getGeoSelection();
        dataSelection.putProperty("Use_Progressive_Resolution", this.getIsProgressiveResolution());
        if (geoSelection != null && !this.getIsProgressiveResolution()) {
            geoSelection.setXStride(Math.abs(this.elementMagSlider.getValue()));
            geoSelection.setYStride(Math.abs(this.lineMagSlider.getValue()));
        }
        if (geoSelection == null && (regionOption = dataSelection.getProperty("Region_Selection_Option", "Use_Default_Area")).equals("Use_Selected_Area")) {
            String locateValue;
            String source = this.descriptor.getSource();
            if (this.getCoordinateType() == TYPE_LATLON) {
                locateValue = Misc.format(this.getLatitude()) + " " + Misc.format(this.getLongitude());
                source = AddeImageDataSource.replaceKey(source, "LATLON", "LATLON", locateValue);
            } else {
                locateValue = this.getLine() + " " + this.getElement();
                source = AddeImageDataSource.replaceKey(source, "LINELE", locateValue);
            }
            source = this.getPlace() == PLACE_CENTER ? AddeImageDataSource.replaceKey(source, "PLACE", PLACE_CENTER) : AddeImageDataSource.replaceKey(source, "PLACE", PLACE_ULEFT);
            String sizeValue = this.getNumLines() + " " + this.getNumEles();
            source = AddeImageDataSource.replaceKey(source, "SIZE", sizeValue);
            String magValue = String.valueOf(this.getLineMagValue()) + " " + String.valueOf(this.getElementMagValue());
            source = AddeImageDataSource.replaceKey(source, "MAG", magValue);
            source = AddeImageDataSource.replaceKey(source, "SPAC", 1);
            dataSelection.putProperty("advancedURL", source);
        }
    }

    public void setDataChoice(DataChoice choice) {
        this.dataChoice = choice;
    }

    public DataChoice getDataChoice() {
        return this.dataChoice;
    }

    public String getPlace() {
        try {
            this.place = this.translatePlace((String)this.locationComboBox.getSelectedItem());
        }
        catch (Exception e) {
            this.place = this.defaultPlace;
        }
        return this.place;
    }

    protected String translatePlace(String thisPlace) {
        if (thisPlace.equals("Upper Left")) {
            return PLACE_ULEFT;
        }
        if (thisPlace.equals("Center")) {
            return PLACE_CENTER;
        }
        return thisPlace;
    }

    public int getElement() {
        int val = -1;
        try {
            val = Integer.parseInt(this.centerElementFld.getText().trim());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return val;
    }

    public int getLine() {
        int val = -1;
        try {
            if (!this.centerLineFld.getText().equals("missing")) {
                val = Integer.parseInt(this.centerLineFld.getText().trim());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return val;
    }

    private double[][] getLineElement() {
        double[][] el = new double[2][1];
        el[0][0] = this.getElement();
        el[1][0] = this.getLine();
        return el;
    }

    public void setToFullResolution(Boolean update) {
        this.setPlace(PLACE_CENTER);
        this.setLatitude(this.previewDir.getCenterLatitude());
        this.setLongitude(this.previewDir.getCenterLongitude());
        this.convertToLinEle();
        if (update.booleanValue()) {
            this.setMagSliders(1, 1);
            this.setNumLines(this.maxLines);
            this.updateImageHeightSize();
            this.setNumEles(this.maxEles);
            this.updateImageWidthSize();
        } else {
            this.setNumLines(this.maxLines / Math.abs(this.getLineMagValue()));
            this.setNumEles(this.maxEles / Math.abs(this.getElementMagValue()));
        }
        this.amUpdating = true;
        this.lineMagSliderChanged(false);
        this.elementMagSliderChanged(false);
        this.amUpdating = false;
    }

    private void setMagSliders(int lineValue, int elementValue) {
        if (this.lineMagSlider != null) {
            if (lineValue > 0) {
                --lineValue;
            } else if (lineValue < 0) {
                ++lineValue;
            }
            if (elementValue > 0) {
                --elementValue;
            } else if (elementValue < 0) {
                ++elementValue;
            }
            this.lineMagSlider.setValue(lineValue);
            this.elementMagSlider.setValue(elementValue);
            this.lineMagLbl.setText(StringUtil.padLeft("" + this.getLineMagValue(), 3));
            this.elementMagLbl.setText(StringUtil.padLeft("" + this.getElementMagValue(), 3));
            this.linesToElements = Math.abs((double)lineValue / (double)elementValue);
            if (Double.isNaN(this.linesToElements)) {
                this.linesToElements = 1.0;
            }
        }
    }

    public void setPlace(String str) {
        if (str.equals("")) {
            str = this.defaultPlace;
        }
        this.place = str;
        if (str.equals(PLACE_CENTER)) {
            this.locationComboBox.setSelectedItem("Center");
        } else {
            this.locationComboBox.setSelectedItem("Upper Left");
        }
    }

    protected void convertToLinEle() {
        try {
            double[][] el = new double[2][1];
            double[][] ll = new double[2][1];
            AREACoordinateSystem macs = (AREACoordinateSystem)this.sampleProjection;
            ll[0][0] = this.getLatitude();
            ll[1][0] = this.getLongitude();
            String coordType = this.getCoordinateType();
            el = this.previewNav.toLinEle(ll);
            this.setLine((int)el[1][0]);
            this.setElement((int)el[0][0]);
        }
        catch (Exception e) {
            System.out.println("convertToLinEle e=" + e);
        }
    }
}

