/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.data.grid;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import ucar.nc2.time.Calendar;
import ucar.unidata.data.DataUtil;
import ucar.unidata.data.grid.GridUtil;
import ucar.unidata.data.point.PointOb;
import ucar.unidata.data.point.PointObTuple;
import ucar.unidata.geoloc.Bearing;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.util.Range;
import ucar.visad.Util;
import ucar.visad.data.CalendarDateTime;
import ucar.visad.data.CalendarDateTimeSet;
import visad.CommonUnit;
import visad.Data;
import visad.DateTime;
import visad.FieldImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.GriddedSet;
import visad.Integer1DSet;
import visad.MathType;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.SampledSet;
import visad.SetType;
import visad.TupleType;
import visad.Unit;
import visad.VisADException;
import visad.data.CachedFlatField;
import visad.georef.EarthLocation;
import visad.georef.EarthLocationLite;

public class WrfUtil
extends GridUtil {
    public static FieldImpl getGridMinMaxAsPointObs(FieldImpl grid, double min, double max) throws VisADException {
        if (grid == null) {
            return null;
        }
        RealType index = RealType.getRealType("index");
        FieldImpl retField = null;
        try {
            if (WrfUtil.isTimeSequence(grid)) {
                SampledSet timeSet = (SampledSet)WrfUtil.getTimeSet(grid);
                FunctionType retFieldType = null;
                double[][] times = timeSet.getDoubles(false);
                Unit timeUnit = timeSet.getSetUnits()[0];
                if (!timeUnit.equals(CommonUnit.secondsSinceTheEpoch)) {
                    Unit.convertTuple(times, timeSet.getSetUnits(), new Unit[]{CommonUnit.secondsSinceTheEpoch}, true);
                }
                Calendar cal = null;
                if (timeSet instanceof CalendarDateTimeSet) {
                    cal = ((CalendarDateTimeSet)timeSet).getCalendar();
                }
                for (int i = 0; i < timeSet.getLength(); ++i) {
                    CalendarDateTime dt = new CalendarDateTime(times[0][i], cal);
                    FieldImpl ff = WrfUtil.makePointObs((FlatField)grid.getSample(i), dt, min, max);
                    if (ff == null) continue;
                    if (retFieldType == null) {
                        retFieldType = new FunctionType(((SetType)timeSet.getType()).getDomain(), ff.getType());
                        retField = new FieldImpl(retFieldType, timeSet);
                    }
                    retField.setSample(i, (Data)ff, false);
                }
            } else {
                retField = WrfUtil.makePointObs((FlatField)grid, new DateTime(Double.NaN), min, max);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return retField;
    }

    public static FieldImpl getSpeedAreaNRadiusAsPointObs(FieldImpl grid0, int level, float value) throws VisADException {
        if (grid0 == null) {
            return null;
        }
        FieldImpl grid = null;
        if (WrfUtil.canSliceAtLevel(grid0, new Real(level))) {
            grid = WrfUtil.sliceAtLevel(grid0, new Real(level));
            grid = WrfUtil.make2DGridFromSlice(grid, false);
        } else {
            grid = WrfUtil.make2DGridFromSlice(grid0, false);
        }
        Unit kmUnit = Util.parseUnit("km");
        FieldImpl retField = null;
        TupleType rangeType0 = new TupleType(new MathType[]{RealTupleType.LatitudeLongitudeAltitude, RealType.Time, RealType.getRealType("distance", kmUnit)});
        ArrayList<PointOb> pointObsList = new ArrayList<PointOb>();
        try {
            if (WrfUtil.isTimeSequence(grid)) {
                SampledSet timeSet = (SampledSet)WrfUtil.getTimeSet(grid);
                Object retFieldType = null;
                double[][] times = timeSet.getDoubles(false);
                Unit timeUnit = timeSet.getSetUnits()[0];
                if (!timeUnit.equals(CommonUnit.secondsSinceTheEpoch)) {
                    Unit.convertTuple(times, timeSet.getSetUnits(), new Unit[]{CommonUnit.secondsSinceTheEpoch}, true);
                }
                Calendar cal = null;
                if (timeSet instanceof CalendarDateTimeSet) {
                    cal = ((CalendarDateTimeSet)timeSet).getCalendar();
                }
                for (int i = 0; i < timeSet.getLength(); ++i) {
                    CalendarDateTime dt = new CalendarDateTime(times[0][i], cal);
                    PointOb[] pointObs = WrfUtil.makePointObsForAreaRadius((FlatField)grid.getSample(i), dt, value, "max");
                    if (pointObs == null || pointObs.length <= 1) continue;
                    for (PointOb pob : pointObs) {
                        pointObsList.add(pob);
                    }
                }
                int ssize = pointObsList.size();
                Data[] finalPointOb = new PointOb[ssize];
                for (int i = 0; i < ssize; ++i) {
                    finalPointOb[i] = (PointOb)pointObsList.get(i);
                }
                Integer1DSet points = new Integer1DSet((MathType)RealType.getRealType("index"), ssize);
                FieldImpl ff = new FieldImpl(new FunctionType(((SetType)points.getType()).getDomain(), rangeType0), points);
                ff.setSamples(finalPointOb, false, false);
                return ff;
            }
            retField = WrfUtil.makePointObs((FlatField)grid, new DateTime(Double.NaN));
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return retField;
    }

    public static FieldImpl getSpeedAreaNRadiusAsPointObs(FieldImpl grid1, FieldImpl grid0, int level, float value) throws VisADException {
        if (grid0 == null) {
            return null;
        }
        FieldImpl grid = null;
        if (WrfUtil.canSliceAtLevel(grid0, new Real(level))) {
            grid = WrfUtil.sliceAtLevel(grid0, new Real(level));
            grid = WrfUtil.make2DGridFromSlice(grid, false);
        } else {
            grid = WrfUtil.make2DGridFromSlice(grid0, false);
        }
        FieldImpl gridh = null;
        if (WrfUtil.canSliceAtLevel(grid1, new Real(level))) {
            gridh = WrfUtil.sliceAtLevel(grid1, new Real(level));
            gridh = WrfUtil.make2DGridFromSlice(gridh, false);
        } else {
            gridh = WrfUtil.make2DGridFromSlice(grid1, false);
        }
        Unit kmUnit = Util.parseUnit("km");
        FieldImpl retField = null;
        TupleType rangeType0 = new TupleType(new MathType[]{RealTupleType.LatitudeLongitudeAltitude, RealType.Time, RealType.getRealType("distance", kmUnit)});
        ArrayList<PointOb> pointObsList = new ArrayList<PointOb>();
        try {
            if (WrfUtil.isTimeSequence(grid)) {
                SampledSet timeSet = (SampledSet)WrfUtil.getTimeSet(grid);
                Object retFieldType = null;
                double[][] times = timeSet.getDoubles(false);
                Unit timeUnit = timeSet.getSetUnits()[0];
                if (!timeUnit.equals(CommonUnit.secondsSinceTheEpoch)) {
                    Unit.convertTuple(times, timeSet.getSetUnits(), new Unit[]{CommonUnit.secondsSinceTheEpoch}, true);
                }
                Calendar cal = null;
                if (timeSet instanceof CalendarDateTimeSet) {
                    cal = ((CalendarDateTimeSet)timeSet).getCalendar();
                }
                for (int i = 0; i < timeSet.getLength(); ++i) {
                    CalendarDateTime dt = new CalendarDateTime(times[0][i], cal);
                    PointOb[] pointObs = WrfUtil.makePointObsForAreaRadius((FlatField)gridh.getSample(i), (FlatField)grid.getSample(i), dt, value, "max");
                    if (pointObs == null || pointObs.length <= 1) continue;
                    for (PointOb pob : pointObs) {
                        pointObsList.add(pob);
                    }
                }
                int ssize = pointObsList.size();
                Data[] finalPointOb = new PointOb[ssize];
                for (int i = 0; i < ssize; ++i) {
                    finalPointOb[i] = (PointOb)pointObsList.get(i);
                }
                Integer1DSet points = new Integer1DSet((MathType)RealType.getRealType("index"), ssize);
                FieldImpl ff = new FieldImpl(new FunctionType(((SetType)points.getType()).getDomain(), rangeType0), points);
                ff.setSamples(finalPointOb, false, false);
                return ff;
            }
            retField = WrfUtil.makePointObs((FlatField)grid, new DateTime(Double.NaN));
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return retField;
    }

    public static PointOb[] makePointObsForAreaRadius(FlatField timeSteph, FlatField timeStep, DateTime dt, float val, String function) throws VisADException, RemoteException {
        boolean doMax = function.equals("max");
        boolean doMin = function.equals("min");
        if (timeStep == null) {
            return null;
        }
        SampledSet domain = WrfUtil.getSpatialDomain(timeStep);
        int numPoints = domain.getLength();
        PointOb[] obs = new PointOb[5];
        TupleType tt = WrfUtil.getParamType(timeStep);
        TupleType rangeType = new TupleType(new MathType[]{RealTupleType.LatitudeLongitudeAltitude, RealType.Time, tt});
        Unit kmUnit = Util.parseUnit("km");
        TupleType rangeType0 = new TupleType(new MathType[]{RealTupleType.LatitudeLongitudeAltitude, RealType.Time, RealType.getRealType("distance", kmUnit)});
        RealTupleType rtt = new RealTupleType(DataUtil.makeRealType("distance", RealType.getRealType("distance", kmUnit).getDefaultUnit()));
        float[][] geoVals = WrfUtil.getEarthLocationPoints((GriddedSet)domain);
        boolean isLatLon = WrfUtil.isLatLonOrder(domain);
        int latIndex = isLatLon ? 0 : 1;
        int lonIndex = isLatLon ? 1 : 0;
        boolean haveAlt = geoVals.length > 2;
        float pMin = Float.POSITIVE_INFINITY;
        float pMax = Float.NEGATIVE_INFINITY;
        int index = 0;
        for (int i = 0; i < numPoints; ++i) {
            float lat = geoVals[latIndex][i];
            float lon = geoVals[lonIndex][i];
            if (lat != lat || lon != lon || !((float)timeSteph.getValues(i)[0] < pMin)) continue;
            pMin = (float)timeSteph.getValues(i)[0];
            index = i;
        }
        float lat0 = geoVals[latIndex][index];
        float lon0 = geoVals[lonIndex][index];
        float alt0 = haveAlt ? geoVals[2][index] : 0.0f;
        EarthLocationLite el0 = new EarthLocationLite(lat0, lon0, alt0);
        float deltaLatLon = 0.01f;
        float preVal = (float)timeStep.getValues(index)[0];
        double areaTotal = 0.0;
        float[] lln = WrfUtil.findPointDisFromMaxCenter(timeStep, val, preVal, lat0, lon0, alt0, deltaLatLon, 0.0f);
        Bearing result1 = Bearing.calculateBearing(new LatLonPointImpl(lln[0], lln[1]), new LatLonPointImpl(lat0, lon0));
        lln = WrfUtil.findPointDisFromMaxCenter(timeStep, val, preVal, lat0, lon0, alt0, deltaLatLon, 15.0f);
        Bearing result3 = Bearing.calculateBearing(new LatLonPointImpl(lln[0], lln[1]), new LatLonPointImpl(lat0, lon0));
        lln = WrfUtil.findPointDisFromMaxCenter(timeStep, val, preVal, lat0, lon0, alt0, deltaLatLon, 75.0f);
        Bearing result4 = Bearing.calculateBearing(new LatLonPointImpl(lln[0], lln[1]), new LatLonPointImpl(lat0, lon0));
        lln = WrfUtil.findPointDisFromMaxCenter(timeStep, val, preVal, lat0, lon0, alt0, deltaLatLon, 90.0f);
        Bearing result5 = Bearing.calculateBearing(new LatLonPointImpl(lln[0], lln[1]), new LatLonPointImpl(lat0, lon0));
        lln = WrfUtil.findPointDisFromMaxCenter(timeStep, val, preVal, lat0, lon0, alt0, deltaLatLon, 45.0f);
        Bearing result2 = Bearing.calculateBearing(new LatLonPointImpl(lln[0], lln[1]), new LatLonPointImpl(lat0, lon0));
        float dis1 = (float)(result1.getDistance() + result2.getDistance() + result3.getDistance() + result4.getDistance() + result5.getDistance()) / 5.0f;
        obs[1] = WrfUtil.getPointObValTuple(lln, dis1, alt0, rtt, rangeType0, dt);
        lln = WrfUtil.findPointDisFromMaxCenter(timeStep, val, preVal, lat0, lon0, alt0, deltaLatLon, 105.0f);
        Bearing result7 = Bearing.calculateBearing(new LatLonPointImpl(lln[0], lln[1]), new LatLonPointImpl(lat0, lon0));
        lln = WrfUtil.findPointDisFromMaxCenter(timeStep, val, preVal, lat0, lon0, alt0, deltaLatLon, 165.0f);
        Bearing result8 = Bearing.calculateBearing(new LatLonPointImpl(lln[0], lln[1]), new LatLonPointImpl(lat0, lon0));
        lln = WrfUtil.findPointDisFromMaxCenter(timeStep, val, preVal, lat0, lon0, alt0, deltaLatLon, 180.0f);
        Bearing result9 = Bearing.calculateBearing(new LatLonPointImpl(lln[0], lln[1]), new LatLonPointImpl(lat0, lon0));
        lln = WrfUtil.findPointDisFromMaxCenter(timeStep, val, preVal, lat0, lon0, alt0, deltaLatLon, 135.0f);
        Bearing result6 = Bearing.calculateBearing(new LatLonPointImpl(lln[0], lln[1]), new LatLonPointImpl(lat0, lon0));
        float dis2 = (float)(result5.getDistance() + result6.getDistance() + result7.getDistance() + result8.getDistance() + result9.getDistance()) / 5.0f;
        obs[2] = WrfUtil.getPointObValTuple(lln, dis2, alt0, rtt, rangeType0, dt);
        lln = WrfUtil.findPointDisFromMaxCenter(timeStep, val, preVal, lat0, lon0, alt0, deltaLatLon, 195.0f);
        Bearing result11 = Bearing.calculateBearing(new LatLonPointImpl(lln[0], lln[1]), new LatLonPointImpl(lat0, lon0));
        lln = WrfUtil.findPointDisFromMaxCenter(timeStep, val, preVal, lat0, lon0, alt0, deltaLatLon, 255.0f);
        Bearing result12 = Bearing.calculateBearing(new LatLonPointImpl(lln[0], lln[1]), new LatLonPointImpl(lat0, lon0));
        lln = WrfUtil.findPointDisFromMaxCenter(timeStep, val, preVal, lat0, lon0, alt0, deltaLatLon, 270.0f);
        Bearing result13 = Bearing.calculateBearing(new LatLonPointImpl(lln[0], lln[1]), new LatLonPointImpl(lat0, lon0));
        lln = WrfUtil.findPointDisFromMaxCenter(timeStep, val, preVal, lat0, lon0, alt0, deltaLatLon, 225.0f);
        Bearing result10 = Bearing.calculateBearing(new LatLonPointImpl(lln[0], lln[1]), new LatLonPointImpl(lat0, lon0));
        float dis3 = (float)(result9.getDistance() + result10.getDistance() + result11.getDistance() + result12.getDistance() + result13.getDistance()) / 5.0f;
        obs[3] = WrfUtil.getPointObValTuple(lln, dis3, alt0, rtt, rangeType0, dt);
        lln = WrfUtil.findPointDisFromMaxCenter(timeStep, val, preVal, lat0, lon0, alt0, deltaLatLon, 285.0f);
        Bearing result15 = Bearing.calculateBearing(new LatLonPointImpl(lln[0], lln[1]), new LatLonPointImpl(lat0, lon0));
        lln = WrfUtil.findPointDisFromMaxCenter(timeStep, val, preVal, lat0, lon0, alt0, deltaLatLon, 345.0f);
        Bearing result16 = Bearing.calculateBearing(new LatLonPointImpl(lln[0], lln[1]), new LatLonPointImpl(lat0, lon0));
        lln = WrfUtil.findPointDisFromMaxCenter(timeStep, val, preVal, lat0, lon0, alt0, deltaLatLon, 315.0f);
        Bearing result14 = Bearing.calculateBearing(new LatLonPointImpl(lln[0], lln[1]), new LatLonPointImpl(lat0, lon0));
        float dis4 = (float)(result13.getDistance() + result14.getDistance() + result15.getDistance() + result16.getDistance() + result1.getDistance()) / 5.0f;
        obs[4] = WrfUtil.getPointObValTuple(lln, dis4, alt0, rtt, rangeType0, dt);
        areaTotal = 0.785 * (double)(dis1 * dis1 + dis2 * dis2 + dis3 * dis3 + dis4 * dis4);
        double[] distance = new double[]{areaTotal};
        RealTuple sample = new RealTuple(rtt, distance);
        PointObTuple pot = new PointObTuple(el0, dt, sample, rangeType0);
        obs[0] = pot;
        return obs;
    }

    private static FieldImpl makePointObs(FlatField timeStep, DateTime dt) throws VisADException, RemoteException {
        if (timeStep == null) {
            return null;
        }
        SampledSet domain = WrfUtil.getSpatialDomain(timeStep);
        int numPoints = domain.getLength();
        Integer1DSet points = new Integer1DSet((MathType)RealType.getRealType("index"), numPoints);
        TupleType tt = WrfUtil.getParamType(timeStep);
        TupleType rangeType = new TupleType(new MathType[]{RealTupleType.LatitudeLongitudeAltitude, RealType.Time, tt});
        FieldImpl ff = new FieldImpl(new FunctionType(((SetType)points.getType()).getDomain(), rangeType), points);
        float[][] samples = timeStep.getFloats(false);
        float[][] geoVals = WrfUtil.getEarthLocationPoints((GriddedSet)domain);
        boolean isLatLon = WrfUtil.isLatLonOrder(domain);
        int latIndex = isLatLon ? 0 : 1;
        int lonIndex = isLatLon ? 1 : 0;
        boolean haveAlt = geoVals.length > 2;
        for (int i = 0; i < numPoints; ++i) {
            float alt;
            float lat = geoVals[latIndex][i];
            float lon = geoVals[lonIndex][i];
            float f = alt = haveAlt ? geoVals[2][i] : 0.0f;
            if (lat != lat || lon != lon) continue;
            if (alt != alt) {
                alt = 0.0f;
            }
            EarthLocationLite el = new EarthLocationLite(lat, lon, alt);
            PointObTuple pot = new PointObTuple(el, dt, timeStep.getSample(i), rangeType);
            ff.setSample(i, pot, false, false);
        }
        return ff;
    }

    private static FieldImpl makePointObs(FlatField timeStep, DateTime dt, String function) throws VisADException, RemoteException {
        boolean doMax = function.equals("max");
        boolean doMin = function.equals("min");
        if (timeStep == null) {
            return null;
        }
        SampledSet domain = WrfUtil.getSpatialDomain(timeStep);
        int numPoints = domain.getLength();
        Integer1DSet points = new Integer1DSet((MathType)RealType.getRealType("index"), numPoints);
        TupleType tt = WrfUtil.getParamType(timeStep);
        TupleType rangeType = new TupleType(new MathType[]{RealTupleType.LatitudeLongitudeAltitude, RealType.Time, tt});
        FieldImpl ff = new FieldImpl(new FunctionType(((SetType)points.getType()).getDomain(), rangeType), points);
        float[][] samples = timeStep.getFloats(false);
        float[][] geoVals = WrfUtil.getEarthLocationPoints((GriddedSet)domain);
        boolean isLatLon = WrfUtil.isLatLonOrder(domain);
        int latIndex = isLatLon ? 0 : 1;
        int lonIndex = isLatLon ? 1 : 0;
        boolean haveAlt = geoVals.length > 2;
        float pMin = Float.POSITIVE_INFINITY;
        float pMax = Float.NEGATIVE_INFINITY;
        int index = 0;
        for (int i = 0; i < numPoints; ++i) {
            float alt;
            float lat = geoVals[latIndex][i];
            float lon = geoVals[lonIndex][i];
            float f = alt = haveAlt ? geoVals[2][i] : 0.0f;
            if (lat != lat || lon != lon) continue;
            if (alt != alt) {
                alt = 0.0f;
            }
            if (doMax && (float)timeStep.getValues(i)[0] >= pMax) {
                pMax = (float)timeStep.getValues(i)[0];
                index = i;
                continue;
            }
            if (!doMin || !((float)timeStep.getValues(i)[0] < pMin)) continue;
            pMin = (float)timeStep.getValues(i)[0];
            index = i;
        }
        float alt0 = haveAlt ? geoVals[2][index] : 0.0f;
        EarthLocationLite el0 = new EarthLocationLite(geoVals[latIndex][index], geoVals[lonIndex][index], alt0);
        PointObTuple pot = new PointObTuple(el0, dt, timeStep.getSample(index), rangeType);
        ff.setSample(0, pot, false, false);
        return ff;
    }

    public static PointOb[] makePointObsForAreaRadius(FlatField timeStep, DateTime dt, float val, String function) throws VisADException, RemoteException {
        boolean doMax = function.equals("max");
        boolean doMin = function.equals("min");
        if (timeStep == null) {
            return null;
        }
        SampledSet domain = WrfUtil.getSpatialDomain(timeStep);
        int numPoints = domain.getLength();
        PointOb[] obs = new PointOb[5];
        TupleType tt = WrfUtil.getParamType(timeStep);
        TupleType rangeType = new TupleType(new MathType[]{RealTupleType.LatitudeLongitudeAltitude, RealType.Time, tt});
        Unit kmUnit = Util.parseUnit("km");
        TupleType rangeType0 = new TupleType(new MathType[]{RealTupleType.LatitudeLongitudeAltitude, RealType.Time, RealType.getRealType("distance", kmUnit)});
        RealTupleType rtt = new RealTupleType(DataUtil.makeRealType("distance", RealType.getRealType("distance", kmUnit).getDefaultUnit()));
        float[][] geoVals = WrfUtil.getEarthLocationPoints((GriddedSet)domain);
        boolean isLatLon = WrfUtil.isLatLonOrder(domain);
        int latIndex = isLatLon ? 0 : 1;
        int lonIndex = isLatLon ? 1 : 0;
        boolean haveAlt = geoVals.length > 2;
        float pMin = Float.POSITIVE_INFINITY;
        float pMax = Float.NEGATIVE_INFINITY;
        int index = 0;
        for (int i = 0; i < numPoints; ++i) {
            float alt;
            float lat = geoVals[latIndex][i];
            float lon = geoVals[lonIndex][i];
            float f = alt = haveAlt ? geoVals[2][i] : 0.0f;
            if (lat != lat || lon != lon) continue;
            if (alt != alt) {
                alt = 0.0f;
            }
            if (doMax && (float)timeStep.getValues(i)[0] >= pMax) {
                pMax = (float)timeStep.getValues(i)[0];
                index = i;
                continue;
            }
            if (!doMin || !((float)timeStep.getValues(i)[0] < pMin)) continue;
            pMin = (float)timeStep.getValues(i)[0];
            index = i;
        }
        float lat0 = geoVals[latIndex][index];
        float lon0 = geoVals[lonIndex][index];
        float alt0 = haveAlt ? geoVals[2][index] : 0.0f;
        EarthLocationLite el0 = new EarthLocationLite(lat0, lon0, alt0);
        float deltaLatLon = 0.01f;
        float preVal = (float)timeStep.getValues(index)[0];
        double areaTotal = 0.0;
        float[] lln = WrfUtil.findPointDisFromMaxCenter(timeStep, val, preVal, lat0, lon0, alt0, deltaLatLon, 0.0f);
        Bearing result1 = Bearing.calculateBearing(new LatLonPointImpl(lln[0], lln[1]), new LatLonPointImpl(lat0, lon0));
        lln = WrfUtil.findPointDisFromMaxCenter(timeStep, val, preVal, lat0, lon0, alt0, deltaLatLon, 15.0f);
        Bearing result3 = Bearing.calculateBearing(new LatLonPointImpl(lln[0], lln[1]), new LatLonPointImpl(lat0, lon0));
        lln = WrfUtil.findPointDisFromMaxCenter(timeStep, val, preVal, lat0, lon0, alt0, deltaLatLon, 75.0f);
        Bearing result4 = Bearing.calculateBearing(new LatLonPointImpl(lln[0], lln[1]), new LatLonPointImpl(lat0, lon0));
        lln = WrfUtil.findPointDisFromMaxCenter(timeStep, val, preVal, lat0, lon0, alt0, deltaLatLon, 90.0f);
        Bearing result5 = Bearing.calculateBearing(new LatLonPointImpl(lln[0], lln[1]), new LatLonPointImpl(lat0, lon0));
        lln = WrfUtil.findPointDisFromMaxCenter(timeStep, val, preVal, lat0, lon0, alt0, deltaLatLon, 45.0f);
        Bearing result2 = Bearing.calculateBearing(new LatLonPointImpl(lln[0], lln[1]), new LatLonPointImpl(lat0, lon0));
        float dis1 = (float)(result1.getDistance() + result2.getDistance() + result3.getDistance() + result4.getDistance() + result5.getDistance()) / 5.0f;
        obs[1] = WrfUtil.getPointObValTuple(lln, dis1, alt0, rtt, rangeType0, dt);
        lln = WrfUtil.findPointDisFromMaxCenter(timeStep, val, preVal, lat0, lon0, alt0, deltaLatLon, 105.0f);
        Bearing result7 = Bearing.calculateBearing(new LatLonPointImpl(lln[0], lln[1]), new LatLonPointImpl(lat0, lon0));
        lln = WrfUtil.findPointDisFromMaxCenter(timeStep, val, preVal, lat0, lon0, alt0, deltaLatLon, 165.0f);
        Bearing result8 = Bearing.calculateBearing(new LatLonPointImpl(lln[0], lln[1]), new LatLonPointImpl(lat0, lon0));
        lln = WrfUtil.findPointDisFromMaxCenter(timeStep, val, preVal, lat0, lon0, alt0, deltaLatLon, 180.0f);
        Bearing result9 = Bearing.calculateBearing(new LatLonPointImpl(lln[0], lln[1]), new LatLonPointImpl(lat0, lon0));
        lln = WrfUtil.findPointDisFromMaxCenter(timeStep, val, preVal, lat0, lon0, alt0, deltaLatLon, 135.0f);
        Bearing result6 = Bearing.calculateBearing(new LatLonPointImpl(lln[0], lln[1]), new LatLonPointImpl(lat0, lon0));
        float dis2 = (float)(result5.getDistance() + result6.getDistance() + result7.getDistance() + result8.getDistance() + result9.getDistance()) / 5.0f;
        obs[2] = WrfUtil.getPointObValTuple(lln, dis2, alt0, rtt, rangeType0, dt);
        lln = WrfUtil.findPointDisFromMaxCenter(timeStep, val, preVal, lat0, lon0, alt0, deltaLatLon, 195.0f);
        Bearing result11 = Bearing.calculateBearing(new LatLonPointImpl(lln[0], lln[1]), new LatLonPointImpl(lat0, lon0));
        lln = WrfUtil.findPointDisFromMaxCenter(timeStep, val, preVal, lat0, lon0, alt0, deltaLatLon, 255.0f);
        Bearing result12 = Bearing.calculateBearing(new LatLonPointImpl(lln[0], lln[1]), new LatLonPointImpl(lat0, lon0));
        lln = WrfUtil.findPointDisFromMaxCenter(timeStep, val, preVal, lat0, lon0, alt0, deltaLatLon, 270.0f);
        Bearing result13 = Bearing.calculateBearing(new LatLonPointImpl(lln[0], lln[1]), new LatLonPointImpl(lat0, lon0));
        lln = WrfUtil.findPointDisFromMaxCenter(timeStep, val, preVal, lat0, lon0, alt0, deltaLatLon, 225.0f);
        Bearing result10 = Bearing.calculateBearing(new LatLonPointImpl(lln[0], lln[1]), new LatLonPointImpl(lat0, lon0));
        float dis3 = (float)(result9.getDistance() + result10.getDistance() + result11.getDistance() + result12.getDistance() + result13.getDistance()) / 5.0f;
        obs[3] = WrfUtil.getPointObValTuple(lln, dis3, alt0, rtt, rangeType0, dt);
        lln = WrfUtil.findPointDisFromMaxCenter(timeStep, val, preVal, lat0, lon0, alt0, deltaLatLon, 285.0f);
        Bearing result15 = Bearing.calculateBearing(new LatLonPointImpl(lln[0], lln[1]), new LatLonPointImpl(lat0, lon0));
        lln = WrfUtil.findPointDisFromMaxCenter(timeStep, val, preVal, lat0, lon0, alt0, deltaLatLon, 345.0f);
        Bearing result16 = Bearing.calculateBearing(new LatLonPointImpl(lln[0], lln[1]), new LatLonPointImpl(lat0, lon0));
        lln = WrfUtil.findPointDisFromMaxCenter(timeStep, val, preVal, lat0, lon0, alt0, deltaLatLon, 315.0f);
        Bearing result14 = Bearing.calculateBearing(new LatLonPointImpl(lln[0], lln[1]), new LatLonPointImpl(lat0, lon0));
        float dis4 = (float)(result13.getDistance() + result14.getDistance() + result15.getDistance() + result16.getDistance() + result1.getDistance()) / 5.0f;
        obs[4] = WrfUtil.getPointObValTuple(lln, dis4, alt0, rtt, rangeType0, dt);
        areaTotal = 0.785 * (double)(dis1 * dis1 + dis2 * dis2 + dis3 * dis3 + dis4 * dis4);
        double[] distance = new double[]{areaTotal};
        RealTuple sample = new RealTuple(rtt, distance);
        PointObTuple pot = new PointObTuple(el0, dt, sample, rangeType0);
        obs[0] = pot;
        return obs;
    }

    public static PointObTuple getPointObValTuple(float[] lln, float value, float alt0, RealTupleType rtt, TupleType rangeType0, DateTime dt) throws VisADException, RemoteException {
        EarthLocationLite el1 = new EarthLocationLite(lln[0], lln[1], alt0);
        double[] distance1 = new double[]{value};
        RealTuple sample1 = new RealTuple(rtt, distance1);
        PointObTuple pot11 = new PointObTuple(el1, dt, sample1, rangeType0);
        return pot11;
    }

    public static float[] findPointDisFromMaxCenter(FieldImpl timeStep, float val, float preVal, float lat0, float lon0, float alt0, float deltaLatLon, float angle) throws VisADException, RemoteException {
        float[] point = new float[2];
        float degreesToRadians = (float)Math.PI / 180;
        for (int i = 1; i < 1000; ++i) {
            float lon;
            float lat = lat0 + deltaLatLon * (float)i * (float)Math.sin(angle * degreesToRadians);
            EarthLocationLite el = new EarthLocationLite(lat, lon = lon0 + deltaLatLon * (float)i * (float)Math.cos(angle * degreesToRadians), alt0);
            FieldImpl f1 = WrfUtil.sample(timeStep, el.getLatLonPoint(), 101, 202);
            if (f1.getFloats()[0][0] <= val && preVal >= val) {
                point[0] = lat;
                point[1] = lon;
                break;
            }
            preVal = f1.getFloats()[0][0];
        }
        return point;
    }

    public static Range[] fieldMinMax(FlatField field, String function) throws VisADException, RemoteException {
        if (field instanceof CachedFlatField) {
            return WrfUtil.makeRanges(((CachedFlatField)field).getRanges());
        }
        float[][] allValues = field.getFloats(false);
        Range[] result = new Range[allValues.length];
        for (int rangeIdx = 0; rangeIdx < allValues.length; ++rangeIdx) {
            float pMin = Float.POSITIVE_INFINITY;
            float pMax = Float.NEGATIVE_INFINITY;
            for (float value : allValues[rangeIdx]) {
                if (pMax < value) {
                    pMax = value;
                }
                if (!(pMin > value)) continue;
                pMin = value;
            }
            result[rangeIdx] = new Range(pMin, pMax);
        }
        return result;
    }

    private static FieldImpl makePointObs(FlatField timeStep, DateTime dt, double min, double max) throws VisADException, RemoteException {
        if (timeStep == null) {
            return null;
        }
        SampledSet domain = WrfUtil.getSpatialDomain(timeStep);
        int numPoints = domain.getLength();
        Integer1DSet points = new Integer1DSet((MathType)RealType.getRealType("index"), numPoints);
        TupleType tt = WrfUtil.getParamType(timeStep);
        TupleType rangeType = new TupleType(new MathType[]{RealTupleType.LatitudeLongitudeAltitude, RealType.Time, tt});
        FieldImpl ff = new FieldImpl(new FunctionType(((SetType)points.getType()).getDomain(), rangeType), points);
        float[][] samples = timeStep.getFloats(false);
        float[][] geoVals = WrfUtil.getEarthLocationPoints((GriddedSet)domain);
        boolean isLatLon = WrfUtil.isLatLonOrder(domain);
        int latIndex = isLatLon ? 0 : 1;
        int lonIndex = isLatLon ? 1 : 0;
        boolean haveAlt = geoVals.length > 2;
        for (int i = 0; i < numPoints; ++i) {
            float alt;
            float lat = geoVals[latIndex][i];
            float lon = geoVals[lonIndex][i];
            float f = alt = haveAlt ? geoVals[2][i] : 0.0f;
            if (lat != lat || lon != lon) continue;
            if (alt != alt) {
                alt = 0.0f;
            }
            if (!(timeStep.getValues(i)[0] >= min) || !(timeStep.getValues(i)[0] < max)) continue;
            EarthLocationLite el = new EarthLocationLite(lat, lon, alt);
            PointObTuple pot = new PointObTuple(el, dt, timeStep.getSample(i), rangeType);
            ff.setSample(i, pot, false, false);
        }
        return ff;
    }

    public static FieldImpl getIsoSurfaceTopBottomAsPointObs(FieldImpl grid, float value) throws VisADException {
        if (grid == null) {
            return null;
        }
        Unit kmUnit = Util.parseUnit("km");
        FieldImpl retField = null;
        TupleType rangeType0 = new TupleType(new MathType[]{RealTupleType.LatitudeLongitudeAltitude, RealType.Time, RealType.getRealType("distance", kmUnit)});
        ArrayList<PointOb> pointObsList = new ArrayList<PointOb>();
        try {
            if (WrfUtil.isTimeSequence(grid)) {
                SampledSet timeSet = (SampledSet)WrfUtil.getTimeSet(grid);
                double[][] times = timeSet.getDoubles(false);
                Unit timeUnit = timeSet.getSetUnits()[0];
                if (!timeUnit.equals(CommonUnit.secondsSinceTheEpoch)) {
                    Unit.convertTuple(times, timeSet.getSetUnits(), new Unit[]{CommonUnit.secondsSinceTheEpoch}, true);
                }
                Calendar cal = null;
                if (timeSet instanceof CalendarDateTimeSet) {
                    cal = ((CalendarDateTimeSet)timeSet).getCalendar();
                }
                for (int i = 0; i < timeSet.getLength(); ++i) {
                    CalendarDateTime dt = new CalendarDateTime(times[0][i], cal);
                    PointOb[] pointObs = WrfUtil.makePointObsForTopBottom((FlatField)grid.getSample(i), dt, value, "max");
                    if (pointObs == null || pointObs.length <= 1) continue;
                    for (PointOb pob : pointObs) {
                        pointObsList.add(pob);
                    }
                }
                int ssize = pointObsList.size();
                Data[] finalPointOb = new PointOb[ssize];
                for (int i = 0; i < ssize; ++i) {
                    finalPointOb[i] = (PointOb)pointObsList.get(i);
                }
                Integer1DSet points = new Integer1DSet((MathType)RealType.getRealType("index"), ssize);
                FieldImpl ff = new FieldImpl(new FunctionType(((SetType)points.getType()).getDomain(), rangeType0), points);
                ff.setSamples(finalPointOb, false, false);
                return ff;
            }
            retField = WrfUtil.makePointObs((FlatField)grid, new DateTime(Double.NaN));
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return retField;
    }

    public static PointOb[] makePointObsForTopBottom(FlatField timeStep, DateTime dt, float val, String function) throws VisADException, RemoteException {
        boolean doMax = function.equals("max");
        boolean doMin = function.equals("min");
        if (timeStep == null) {
            return null;
        }
        SampledSet domain = WrfUtil.getSpatialDomain(timeStep);
        int numPoints = domain.getLength();
        PointOb[] obs = new PointOb[3];
        TupleType tt = WrfUtil.getParamType(timeStep);
        Unit kmUnit = Util.parseUnit("km");
        TupleType rangeType0 = new TupleType(new MathType[]{RealTupleType.LatitudeLongitudeAltitude, RealType.Time, RealType.getRealType("distance", kmUnit)});
        RealTupleType rtt = new RealTupleType(DataUtil.makeRealType("distance", RealType.getRealType("distance", kmUnit).getDefaultUnit()));
        float[][] geoVals = WrfUtil.getEarthLocationPoints((GriddedSet)domain);
        boolean isLatLon = WrfUtil.isLatLonOrder(domain);
        int latIndex = isLatLon ? 0 : 1;
        int lonIndex = isLatLon ? 1 : 0;
        boolean haveAlt = geoVals.length > 2;
        float pMin = Float.POSITIVE_INFINITY;
        float pMax = Float.NEGATIVE_INFINITY;
        int index = 0;
        for (int i = 0; i < numPoints; ++i) {
            float alt;
            float lat = geoVals[latIndex][i];
            float lon = geoVals[lonIndex][i];
            float f = alt = haveAlt ? geoVals[2][i] : 0.0f;
            if (lat != lat || lon != lon) continue;
            if (alt != alt) {
                alt = 0.0f;
            }
            if (doMax && (float)timeStep.getValues(i)[0] >= pMax) {
                pMax = (float)timeStep.getValues(i)[0];
                index = i;
                continue;
            }
            if (!doMin || !((float)timeStep.getValues(i)[0] < pMin)) continue;
            pMin = (float)timeStep.getValues(i)[0];
            index = i;
        }
        float lat0 = geoVals[latIndex][index];
        float lon0 = geoVals[lonIndex][index];
        float alt0 = haveAlt ? geoVals[2][index] : 0.0f;
        EarthLocationLite el0 = new EarthLocationLite(lat0, lon0, alt0);
        float deltaAlt = 100.0f;
        float preVal = (float)timeStep.getValues(index)[0];
        float[] lln = WrfUtil.findPointDisFromMaxCenter(timeStep, val, preVal, lat0, lon0, alt0, deltaAlt);
        EarthLocationLite el1 = new EarthLocationLite(lat0, lon0, lln[0]);
        double[] distance1 = new double[]{lln[0]};
        RealTuple sample1 = new RealTuple(rtt, distance1);
        obs[1] = new PointObTuple(el1, dt, sample1, rangeType0);
        EarthLocationLite el2 = new EarthLocationLite(lat0, lon0, lln[1]);
        double[] distance2 = new double[]{lln[1]};
        RealTuple sample2 = new RealTuple(rtt, distance2);
        obs[2] = new PointObTuple(el2, dt, sample2, rangeType0);
        double[] distance = new double[]{pMax};
        RealTuple sample = new RealTuple(rtt, distance);
        PointObTuple pot = new PointObTuple(el0, dt, sample, rangeType0);
        obs[0] = pot;
        return obs;
    }

    public static float[] findPointDisFromMaxCenter(FieldImpl timeStep, float val, float preVal, float lat0, float lon0, float alt0, float deltaAlt) throws VisADException, RemoteException {
        FieldImpl f1;
        EarthLocationLite el;
        float alt;
        int i;
        float[] point = new float[2];
        for (i = 1; i < 1000; ++i) {
            alt = alt0 - deltaAlt * (float)i;
            el = new EarthLocationLite(lat0, lon0, alt);
            f1 = WrfUtil.sample(timeStep, el, 101, 202);
            if (f1.getFloats()[0][0] <= val && preVal >= val) {
                point[0] = alt;
                break;
            }
            preVal = f1.getFloats()[0][0];
        }
        for (i = 1; i < 1000; ++i) {
            alt = alt0 + deltaAlt * (float)i;
            el = new EarthLocationLite(lat0, lon0, alt);
            f1 = WrfUtil.sample(timeStep, el, 101, 202);
            if (f1.getFloats()[0][0] <= val && preVal >= val) {
                point[1] = alt;
                break;
            }
            preVal = f1.getFloats()[0][0];
        }
        return point;
    }

    public double getArea(List points, int IDX_LAT, int IDX_LON) throws Exception {
        double area = 0.0;
        float[][] pts = this.getLatLons(points, IDX_LAT, IDX_LON);
        double minLat = Double.POSITIVE_INFINITY;
        double minLon = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < pts[0].length; ++i) {
            if (i == 0) {
                minLat = pts[IDX_LAT][i];
                minLon = pts[IDX_LON][i];
                continue;
            }
            minLat = Math.min(minLat, (double)pts[IDX_LAT][i]);
            minLon = Math.min(minLon, (double)pts[IDX_LON][i]);
        }
        int len = pts[0].length;
        for (int i = 0; i < len; ++i) {
            double x1 = this.distance(minLat, minLon, minLat, pts[IDX_LON][i]);
            double y1 = this.distance(minLat, minLon, pts[IDX_LAT][i], minLon);
            double x2 = this.distance(minLat, minLon, minLat, i < len - 1 ? pts[IDX_LON][i + 1] : pts[IDX_LON][0]);
            double y2 = this.distance(minLat, minLon, i < len - 1 ? pts[IDX_LAT][i + 1] : pts[IDX_LAT][0], minLon);
            area += x1 * y2 - x2 * y1;
        }
        area = 0.5 * area;
        return Math.abs(area);
    }

    public double distance(double lat1, double lon1, double lat2, double lon2) throws Exception {
        Bearing result = Bearing.calculateBearing(new LatLonPointImpl(lat1, lon1), new LatLonPointImpl(lat2, lon2));
        double distance = result.getDistance();
        Unit kmUnit = Util.parseUnit("km");
        Unit feetUnit = Util.parseUnit("feet");
        Real kmDistance = new Real(RealType.getRealType("distance", kmUnit), distance, kmUnit);
        return kmDistance.getValue(feetUnit);
    }

    protected float[][] getLatLons(List points, int IDX_LAT, int IDX_LON) throws VisADException, RemoteException {
        float[][] pts = new float[2][points.size()];
        for (int i = 0; i < points.size(); ++i) {
            EarthLocation el = (EarthLocation)points.get(i);
            pts[IDX_LAT][i] = (float)el.getLatLonPoint().getLatitude().getValue();
            pts[IDX_LON][i] = (float)el.getLatLonPoint().getLongitude().getValue();
        }
        return pts;
    }

    public static FieldImpl getIsoSurfaceTopBottomAsPointObs(FieldImpl gridh, FieldImpl grid, int level, float value) throws VisADException {
        if (grid == null) {
            return null;
        }
        FieldImpl grid0 = null;
        if (WrfUtil.canSliceAtLevel(gridh, new Real(level))) {
            grid0 = WrfUtil.sliceAtLevel(gridh, new Real(level));
            grid0 = WrfUtil.make2DGridFromSlice(grid0, false);
        } else {
            grid0 = WrfUtil.make2DGridFromSlice(gridh, false);
        }
        Unit kmUnit = Util.parseUnit("km");
        FieldImpl retField = null;
        TupleType rangeType0 = new TupleType(new MathType[]{RealTupleType.LatitudeLongitudeAltitude, RealType.Time, RealType.getRealType("distance", kmUnit)});
        ArrayList<PointOb> pointObsList = new ArrayList<PointOb>();
        try {
            if (WrfUtil.isTimeSequence(grid)) {
                SampledSet timeSet = (SampledSet)WrfUtil.getTimeSet(grid);
                double[][] times = timeSet.getDoubles(false);
                Unit timeUnit = timeSet.getSetUnits()[0];
                if (!timeUnit.equals(CommonUnit.secondsSinceTheEpoch)) {
                    Unit.convertTuple(times, timeSet.getSetUnits(), new Unit[]{CommonUnit.secondsSinceTheEpoch}, true);
                }
                Calendar cal = null;
                if (timeSet instanceof CalendarDateTimeSet) {
                    cal = ((CalendarDateTimeSet)timeSet).getCalendar();
                }
                for (int i = 0; i < timeSet.getLength(); ++i) {
                    CalendarDateTime dt = new CalendarDateTime(times[0][i], cal);
                    PointOb[] pointObs = WrfUtil.makePointObsForTopBottom((FlatField)grid0.getSample(i), (FlatField)grid.getSample(i), dt, value, "min");
                    if (pointObs == null || pointObs.length <= 1) continue;
                    for (PointOb pob : pointObs) {
                        pointObsList.add(pob);
                    }
                }
                int ssize = pointObsList.size();
                Data[] finalPointOb = new PointOb[ssize];
                for (int i = 0; i < ssize; ++i) {
                    finalPointOb[i] = (PointOb)pointObsList.get(i);
                }
                Integer1DSet points = new Integer1DSet((MathType)RealType.getRealType("index"), ssize);
                FieldImpl ff = new FieldImpl(new FunctionType(((SetType)points.getType()).getDomain(), rangeType0), points);
                ff.setSamples(finalPointOb, false, false);
                return ff;
            }
            retField = WrfUtil.makePointObs((FlatField)grid, new DateTime(Double.NaN));
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return retField;
    }

    public static PointOb[] makePointObsForTopBottom(FlatField timehStep, FlatField timeStep, DateTime dt, float val, String function) throws VisADException, RemoteException {
        boolean doMax = function.equals("max");
        boolean doMin = function.equals("min");
        if (timeStep == null) {
            return null;
        }
        Unit kmUnit = Util.parseUnit("km");
        SampledSet domain = WrfUtil.getSpatialDomain(timeStep);
        SampledSet domain0 = WrfUtil.getSpatialDomain(timehStep);
        int numPoints0 = domain0.getLength();
        PointOb[] obs = new PointOb[3];
        TupleType tt = WrfUtil.getParamType(timeStep);
        TupleType rangeType0 = new TupleType(new MathType[]{RealTupleType.LatitudeLongitudeAltitude, RealType.Time, RealType.getRealType("distance", kmUnit)});
        RealTupleType rtt = new RealTupleType(DataUtil.makeRealType("distance", RealType.getRealType("distance", kmUnit).getDefaultUnit()));
        float[][] geoVals = WrfUtil.getEarthLocationPoints((GriddedSet)domain0);
        boolean isLatLon = WrfUtil.isLatLonOrder(domain);
        int latIndex = isLatLon ? 0 : 1;
        int lonIndex = isLatLon ? 1 : 0;
        boolean haveAlt = geoVals.length > 2;
        float pMin = Float.POSITIVE_INFINITY;
        float pMax = Float.NEGATIVE_INFINITY;
        int index = 0;
        for (int i = 0; i < numPoints0; ++i) {
            float lat = geoVals[latIndex][i];
            float lon = geoVals[lonIndex][i];
            if (lat != lat || lon != lon) continue;
            if (doMax && (float)timehStep.getValues(i)[0] >= pMax) {
                pMax = (float)timehStep.getValues(i)[0];
                index = i;
                continue;
            }
            if (!doMin || !((float)timehStep.getValues(i)[0] < pMin)) continue;
            pMin = (float)timehStep.getValues(i)[0];
            index = i;
        }
        float lat0 = geoVals[latIndex][index];
        float lon0 = geoVals[lonIndex][index];
        float alt0 = 0.0f;
        float deltaAlt = 100.0f;
        float preVal = (float)timeStep.getValues(index)[0];
        float[] lln = WrfUtil.findPointDisFromSFC(timeStep, val, preVal, lat0, lon0, deltaAlt);
        EarthLocationLite el1 = new EarthLocationLite(lat0, lon0, lln[2]);
        double[] distance1 = new double[]{lln[2]};
        RealTuple sample1 = new RealTuple(rtt, distance1);
        obs[1] = new PointObTuple(el1, dt, sample1, rangeType0);
        EarthLocationLite el2 = new EarthLocationLite(lat0, lon0, lln[3]);
        double[] distance2 = new double[]{lln[3]};
        RealTuple sample2 = new RealTuple(rtt, distance2);
        obs[2] = new PointObTuple(el2, dt, sample2, rangeType0);
        double[] distance = new double[]{lln[0]};
        EarthLocationLite el0 = new EarthLocationLite(lat0, lon0, lln[1]);
        RealTuple sample = new RealTuple(rtt, distance);
        PointObTuple pot = new PointObTuple(el0, dt, sample, rangeType0);
        obs[0] = pot;
        return obs;
    }

    public static float[] findPointDisFromSFC(FieldImpl timeStep, float val, float preVal, float lat0, float lon0, float deltaAlt) throws VisADException, RemoteException {
        FieldImpl f1;
        EarthLocationLite el;
        float alt;
        int i;
        float[] point = new float[4];
        float pMax = Float.NEGATIVE_INFINITY;
        float alt0 = 0.0f;
        for (i = 1; i < 1000; ++i) {
            alt = alt0 + deltaAlt * (float)i;
            el = new EarthLocationLite(lat0, lon0, alt);
            f1 = WrfUtil.sample(timeStep, el, 101, 202);
            if (!(f1.getFloats()[0][0] >= pMax) || !(alt < 16000.0f)) continue;
            pMax = f1.getFloats()[0][0];
            alt0 = alt;
        }
        point[0] = pMax;
        point[1] = alt0;
        for (i = 1; i < 1000; ++i) {
            alt = alt0 - deltaAlt * (float)i;
            el = new EarthLocationLite(lat0, lon0, alt);
            f1 = WrfUtil.sample(timeStep, el, 101, 202);
            if (f1.getFloats()[0][0] <= val && preVal >= val) {
                point[2] = alt;
                break;
            }
            preVal = f1.getFloats()[0][0];
        }
        for (i = 1; i < 1000; ++i) {
            alt = alt0 + deltaAlt * (float)i;
            el = new EarthLocationLite(lat0, lon0, alt);
            f1 = WrfUtil.sample(timeStep, el, 101, 202);
            if (f1.getFloats()[0][0] <= val && preVal >= val) {
                point[3] = alt;
                break;
            }
            preVal = f1.getFloats()[0][0];
        }
        return point;
    }
}

