/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.data.grid;

import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import ucar.unidata.data.BadDataException;
import ucar.unidata.data.DataCategory;
import ucar.unidata.data.DataChoice;
import ucar.unidata.data.DataSelection;
import ucar.unidata.data.DataSourceDescriptor;
import ucar.unidata.data.DirectDataChoice;
import ucar.unidata.data.GeoSelection;
import ucar.unidata.data.grid.GridDataSource;
import ucar.unidata.data.grid.GridUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.Trace;
import ucar.visad.data.CalendarDateTime;
import visad.Data;
import visad.DateTime;
import visad.FieldImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.Gridded1DSet;
import visad.MathType;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.SampledSet;
import visad.ScalarType;
import visad.SingletonSet;
import visad.TupleType;
import visad.VisADException;
import visad.data.vis5d.Vis5DFamily;

public class Vis5DDataSource
extends GridDataSource {
    private Data v5DData;
    private ArrayList vars2D = new ArrayList();
    private ArrayList vars3D = new ArrayList();
    private Hashtable typeNameToType = new Hashtable();
    private boolean forceSubset = false;

    public Vis5DDataSource() {
    }

    public Vis5DDataSource(DataSourceDescriptor descriptor, String source, Hashtable properties) throws VisADException {
        super(descriptor, source, "", properties);
        this.initVis5dDataSource();
    }

    @Override
    protected void sourcesChanged() {
        this.vars2D = new ArrayList();
        this.vars3D = new ArrayList();
        this.v5DData = null;
        super.sourcesChanged();
    }

    private void initVis5dDataSource() {
        try {
            if (this.sources == null || this.sources.isEmpty()) {
                return;
            }
            Vis5DFamily v5dForm = new Vis5DFamily("vis5d");
            String source = (String)this.sources.get(0);
            this.v5DData = source.startsWith("http:") ? v5dForm.open(new URL(source)) : v5dForm.open(source);
            this.parseMathType(this.v5DData.getType(), 0);
        }
        catch (Exception e) {
            this.setInError(true);
            this.logException("Initializing Vis5D data source", e);
        }
    }

    private FieldImpl getV5DData() {
        if (this.v5DData == null) {
            this.initVis5dDataSource();
        }
        return (FieldImpl)this.v5DData;
    }

    @Override
    protected void doMakeDataChoices() {
        String name;
        RealType type;
        int nn;
        FieldImpl grid = this.getV5DData();
        if (grid == null) {
            return;
        }
        boolean hasTimes = false;
        try {
            hasTimes = GridUtil.isTimeSequence(grid);
        }
        catch (VisADException visADException) {
            // empty catch block
        }
        for (nn = 0; nn < this.vars3D.size(); ++nn) {
            type = (RealType)this.vars3D.get(nn);
            name = type.getName();
            this.typeNameToType.put(type.toString(), type);
            this.addDataChoice(new DirectDataChoice(this, (Object)type.toString(), name, name, hasTimes ? this.getThreeDTimeSeriesCategories() : this.getThreeDCategories()));
        }
        for (nn = 0; nn < this.vars2D.size(); ++nn) {
            type = (RealType)this.vars2D.get(nn);
            name = type.getName();
            this.typeNameToType.put(type.toString(), type);
            this.addDataChoice(new DirectDataChoice(this, (Object)type.toString(), name, name, hasTimes ? this.getTwoDTimeSeriesCategories() : this.getTwoDCategories()));
        }
    }

    @Override
    protected Data getDataInner(DataChoice dataChoice, DataCategory category, DataSelection dataSelection, Hashtable requestProperties) throws VisADException, RemoteException {
        return this.getField(dataChoice, dataSelection);
    }

    @Override
    protected List doMakeDateTimes() {
        List timeList = null;
        FieldImpl grid = this.getV5DData();
        try {
            if (GridUtil.isTimeSequence(grid)) {
                Object[] times = CalendarDateTime.timeSetToArray((Gridded1DSet)GridUtil.getTimeSet(grid));
                timeList = Misc.toList(times);
            }
        }
        catch (Exception excp) {
            excp.printStackTrace();
        }
        return timeList;
    }

    public FieldImpl getField(DataChoice dc, DataSelection dataSelection) throws VisADException, RemoteException {
        GeoSelection geoSelection;
        Trace.call1("getField");
        Object id = dc.getId();
        RealType rt = null;
        rt = id instanceof RealType ? (RealType)id : (RealType)this.typeNameToType.get(id.toString());
        GeoSelection geoSelection2 = geoSelection = dataSelection != null ? dataSelection.getGeoSelection() : null;
        if (this.forceSubset) {
            geoSelection = new GeoSelection(null, 2, 2, 2);
        }
        List times = this.getTimesFromDataSelection(dataSelection, dc);
        List cacheKey = Misc.newList(rt, times);
        if (geoSelection != null) {
            cacheKey.add(geoSelection);
        }
        FieldImpl fi = null;
        FieldImpl grid = this.getV5DData();
        if (grid == null) {
            return null;
        }
        FieldImpl retField = (FieldImpl)this.getCache(cacheKey);
        if (retField != null) {
            return retField;
        }
        if (grid instanceof FieldImpl) {
            int index = this.findIndex((FunctionType)this.v5DData.getType(), rt);
            if (index != -1) {
                fi = (FieldImpl)((FieldImpl)this.v5DData).extract(index);
            } else if (MathType.findScalarType(this.v5DData.getType(), rt)) {
                fi = (FieldImpl)this.v5DData;
            }
            if (fi == null) {
                throw new BadDataException("Unable to find data: " + rt + " \nin Vis5D file: " + this.sources);
            }
            Trace.call1("timeSubset");
            if (times != null && !times.isEmpty() && fi != null && !times.equals(this.getAllDateTimes())) {
                FieldImpl newFI;
                SampledSet samplingSet = null;
                DateTime[] dateTimes = times.toArray(new DateTime[times.size()]);
                samplingSet = dateTimes.length == 1 ? new SingletonSet(new RealTuple(new Real[]{dateTimes[0]})) : CalendarDateTime.makeTimeSet(dateTimes);
                fi = newFI = (FieldImpl)fi.resample(samplingSet, 100, 202);
            }
            Trace.call2("timeSubset");
            if (!(fi instanceof FlatField && rt.equals(RealType.Altitude) && ((FunctionType)((FlatField)fi).getType()).getRange() instanceof RealType)) {
                Trace.call1("extract " + rt);
                fi = GridUtil.extractParam(fi, rt);
                Trace.call2("extract " + rt);
            }
            if (geoSelection != null && geoSelection.getHasValidState()) {
                fi = this.geoSubset(fi, geoSelection);
            }
            this.putCache(cacheKey, fi);
        }
        Trace.call2("getField");
        return fi;
    }

    private FieldImpl geoSubset(FieldImpl fi, GeoSelection geoSelection) throws VisADException {
        Trace.call1("geoSubset");
        FieldImpl subSet = GridUtil.is3D(fi) ? GridUtil.subset(fi, geoSelection.getXStrideToUse(), geoSelection.getYStrideToUse()) : GridUtil.subset(fi, geoSelection.getXStrideToUse(), geoSelection.getYStrideToUse(), geoSelection.getZStrideToUse());
        Trace.call2("geoSubset");
        return subSet;
    }

    private int findIndex(FunctionType type, RealType rt) throws VisADException {
        int index = -1;
        MathType rangeType = type.getRange();
        if (rangeType instanceof TupleType) {
            int n_comps = ((TupleType)rangeType).getDimension();
            for (int i = 0; i < n_comps; ++i) {
                MathType test_comp = ((TupleType)rangeType).getComponent(i);
                if (!test_comp.equals(rt) && !MathType.findScalarType(test_comp, rt)) continue;
                index = i;
                break;
            }
        }
        return index;
    }

    private void parseMathType(MathType mathType, int dimension) throws VisADException {
        if (mathType instanceof FunctionType) {
            this.parseFunction((FunctionType)mathType, dimension);
        } else if (mathType instanceof TupleType) {
            this.parseTuple((TupleType)mathType, dimension);
        } else {
            this.parseScalar((ScalarType)mathType, dimension);
        }
    }

    private void parseFunction(FunctionType mathType, int dimension) throws VisADException {
        RealTupleType domain = mathType.getDomain();
        int dim = domain.getDimension();
        MathType range = mathType.getRange();
        this.parseMathType(range, dim);
    }

    private void parseTuple(TupleType mathType, int dimension) throws VisADException {
        for (int j = 0; j < mathType.getDimension(); ++j) {
            MathType cType = mathType.getComponent(j);
            if (cType == null) continue;
            this.parseMathType(cType, dimension);
        }
    }

    private void parseScalar(ScalarType mathType, int dimension) {
        if (mathType instanceof RealType) {
            if (dimension == 2) {
                this.vars2D.add(mathType);
            } else if (dimension == 3) {
                this.vars3D.add(mathType);
            }
        }
    }

    @Override
    public boolean canDoGeoSelection() {
        return true;
    }

    @Override
    protected boolean canDoGeoSelectionMap() {
        return false;
    }

    @Override
    public void setSource(String value) {
        this.oldSourceFromBundles = value;
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            System.out.println("Must supply a file name");
            System.exit(1);
        }
        Vis5DDataSource v5d = new Vis5DDataSource(null, args[0], null);
        Iterator iter = v5d.getAllDateTimes().iterator();
        while (iter.hasNext()) {
            System.out.println(iter.next());
        }
    }
}

