/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.data.grid;

import java.awt.geom.Rectangle2D;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.NetcdfFileWriteable;
import ucar.nc2.Variable;
import ucar.nc2.iosp.mcidas.McIDASAreaProjection;
import ucar.nc2.time.Calendar;
import ucar.unidata.data.DataUtil;
import ucar.unidata.data.gis.MapMaker;
import ucar.unidata.data.grid.FieldStats;
import ucar.unidata.data.grid.GridMath;
import ucar.unidata.data.point.PointObTuple;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.projection.LambertConformal;
import ucar.unidata.geoloc.projection.Mercator;
import ucar.unidata.geoloc.projection.Stereographic;
import ucar.unidata.geoloc.projection.VerticalPerspectiveView;
import ucar.unidata.idv.control.drawing.DrawingGlyph;
import ucar.unidata.idv.control.drawing.PolyGlyph;
import ucar.unidata.util.FileManager;
import ucar.unidata.util.JobManager;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.Parameter;
import ucar.unidata.util.Range;
import ucar.unidata.util.Trace;
import ucar.unidata.xml.XmlUtil;
import ucar.visad.GeoUtils;
import ucar.visad.ProjectionCoordinateSystem;
import ucar.visad.RadarMapProjection;
import ucar.visad.data.CalendarDateTime;
import ucar.visad.data.CalendarDateTimeSet;
import ucar.visad.quantities.AirPressure;
import ucar.visad.quantities.CommonUnits;
import visad.CachingCoordinateSystem;
import visad.CartesianProductCoordinateSystem;
import visad.CommonUnit;
import visad.CoordinateSystem;
import visad.Data;
import visad.DateTime;
import visad.EarthVectorType;
import visad.EmpiricalCoordinateSystem;
import visad.ErrorEstimate;
import visad.FieldImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.Gridded1DSet;
import visad.Gridded2DSet;
import visad.Gridded3DSet;
import visad.GriddedSet;
import visad.IdentityCoordinateSystem;
import visad.Integer1DSet;
import visad.Linear1DSet;
import visad.Linear2DSet;
import visad.Linear3DSet;
import visad.LinearLatLonSet;
import visad.LinearSet;
import visad.MathType;
import visad.QuickSort;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.RealVectorType;
import visad.SampledSet;
import visad.ScalarType;
import visad.Set;
import visad.SetException;
import visad.SetType;
import visad.SimpleSet;
import visad.SingletonSet;
import visad.Tuple;
import visad.TupleType;
import visad.UnionSet;
import visad.Unit;
import visad.VisADException;
import visad.bom.Radar2DCoordinateSystem;
import visad.bom.Radar3DCoordinateSystem;
import visad.data.CachedFlatField;
import visad.data.DataRange;
import visad.data.mcidas.AREACoordinateSystem;
import visad.georef.EarthLocation;
import visad.georef.EarthLocationLite;
import visad.georef.EarthLocationTuple;
import visad.georef.LatLonPoint;
import visad.georef.LatLonTuple;
import visad.georef.MapProjection;
import visad.georef.NavigatedCoordinateSystem;
import visad.georef.TrivialMapProjection;
import visad.util.DataUtility;
import visad.util.Util;

public class GridUtil {
    public static final int WEIGHTED_AVERAGE = 101;
    public static final int NEAREST_NEIGHBOR = 100;
    public static final int NO_ERRORS = 202;
    public static final int DEPENDENT_ERRORS = 201;
    public static final int INDEPENDENT_ERRORS = 200;
    public static final int DEFAULT_SAMPLING_MODE = 101;
    public static final int DEFAULT_ERROR_MODE = 202;
    public static final String FUNC_AVERAGE = "average";
    public static final String FUNC_SUM = "sum";
    public static final String FUNC_MAX = "max";
    public static final String FUNC_MIN = "min";
    public static final String FUNC_DIFFERENCE = "difference";
    public static final String SMOOTH_5POINT = "SM5S";
    public static final String SMOOTH_9POINT = "SM9S";
    public static final String SMOOTH_GAUSSIAN = "GWFS";
    public static final String SMOOTH_CRESSMAN = "CRES";
    public static final String SMOOTH_CIRCULAR = "CIRC";
    public static final String SMOOTH_RECTANGULAR = "RECT";
    public static final RealType ENSEMBLE_TYPE = RealType.getRealType("Ensemble");
    private static final int MAXWTS = 100;
    private static final float GDIFFD = 1.0E-6f;

    public static boolean isGrid(FieldImpl field) {
        boolean isGrid = false;
        try {
            SampledSet ss = GridUtil.getSpatialDomain(field);
            isGrid = ss.getDimension() == 3 || ss.getDimension() == 2;
        }
        catch (Exception excp) {
            isGrid = false;
        }
        return isGrid;
    }

    public static boolean isConstantSpatialDomain(FieldImpl grid) throws VisADException {
        SampledSet ss = GridUtil.getSpatialDomain(grid, 0);
        Set timeSet = GridUtil.getTimeSet(grid);
        if (timeSet != null) {
            for (int i = 1; i < timeSet.getLength(); ++i) {
                if (ss == GridUtil.getSpatialDomain(grid, i)) continue;
                return false;
            }
        }
        return true;
    }

    public static SampledSet getSpatialDomain(FieldImpl grid) throws VisADException {
        if (GridUtil.isTimeSequence(grid)) {
            try {
                Set timeDomain = ucar.visad.Util.getDomainSet(grid);
                for (int i = 0; i < timeDomain.getLength(); ++i) {
                    FieldImpl sample = (FieldImpl)grid.getSample(i);
                    if (sample.isMissing()) continue;
                    return GridUtil.getSpatialDomain(grid, i);
                }
            }
            catch (RemoteException excp) {
                throw new VisADException("RemoteException");
            }
        }
        return GridUtil.getSpatialDomain(grid, 0);
    }

    public static SampledSet getWholeSpatialDomain(FieldImpl grid) throws VisADException {
        if (GridUtil.isTimeSequence(grid)) {
            try {
                Set timeDomain = ucar.visad.Util.getDomainSet(grid);
                SampledSet ss0 = null;
                int slength = 0;
                for (int i = 0; i < timeDomain.getLength(); ++i) {
                    SampledSet ss;
                    int ll;
                    FieldImpl sample = (FieldImpl)grid.getSample(i);
                    if (sample.isMissing() || (ll = (ss = GridUtil.getSpatialDomain(grid, i)).getLength()) <= slength) continue;
                    slength = ll;
                    ss0 = (SampledSet)ss.clone();
                }
                return ss0;
            }
            catch (RemoteException excp) {
                throw new VisADException("RemoteException");
            }
        }
        return GridUtil.getSpatialDomain(grid, 0);
    }

    public static SampledSet getSpatialDomain(FieldImpl grid, int timeIndex) throws VisADException {
        SampledSet spatialDomain;
        FieldImpl field = null;
        try {
            FlatField fi = GridUtil.isSequence(grid) ? (FieldImpl)grid.getSample(timeIndex) : (FlatField)grid;
            FieldImpl fieldImpl = field = GridUtil.isSequence(fi) ? (FlatField)((FieldImpl)fi).getSample(0) : fi;
            if (field == null) {
                return null;
            }
            spatialDomain = (SampledSet)ucar.visad.Util.getDomainSet(field);
        }
        catch (ClassCastException cce) {
            throw new IllegalArgumentException("not a known grid type " + field.getDomainSet().getClass());
        }
        catch (RemoteException re) {
            throw new VisADException("RemoteException");
        }
        return spatialDomain;
    }

    public static FieldImpl setSpatialDomain(FieldImpl grid, SampledSet newDomain) throws VisADException {
        return GridUtil.setSpatialDomain(grid, newDomain, false);
    }

    public static FieldImpl setSpatialDomain(FieldImpl grid, SampledSet newDomain, boolean copy) throws VisADException {
        if (GridUtil.getSpatialDomain(grid).getLength() != newDomain.getLength()) {
            throw new VisADException("new domain is not the right length");
        }
        TupleType paramType = GridUtil.getParamType(grid);
        FunctionType rangeFT = new FunctionType(((SetType)newDomain.getType()).getDomain(), paramType);
        FieldImpl newFieldImpl = null;
        boolean isSequence = GridUtil.isSequence(grid);
        if (isSequence) {
            try {
                FunctionType newFieldType;
                Set sequenceSet = ucar.visad.Util.getDomainSet(grid);
                int numSteps = sequenceSet.getLength();
                RealTupleType sequenceType = ((SetType)sequenceSet.getType()).getDomain();
                FieldImpl firstSample = (FieldImpl)grid.getSample(0, false);
                boolean hasInnerSteps = GridUtil.isSequence(firstSample);
                FunctionType innerFieldType = null;
                if (!GridUtil.isSequence(firstSample)) {
                    newFieldType = new FunctionType(sequenceType, rangeFT);
                } else {
                    hasInnerSteps = true;
                    innerFieldType = new FunctionType(((FunctionType)firstSample.getType()).getDomain(), rangeFT);
                    newFieldType = new FunctionType(sequenceType, innerFieldType);
                }
                newFieldImpl = new FieldImpl(newFieldType, sequenceSet);
                for (int i = 0; i < numSteps; ++i) {
                    FieldImpl fi;
                    FieldImpl data = (FieldImpl)grid.getSample(i, false);
                    if (data.isMissing()) {
                        fi = data;
                    } else if (hasInnerSteps) {
                        Set innerSet = ucar.visad.Util.getDomainSet(data);
                        fi = new FieldImpl(innerFieldType, innerSet);
                        for (int j = 0; j < innerSet.getLength(); ++j) {
                            FlatField dataFF = (FlatField)data.getSample(j, false);
                            FlatField ff = null;
                            if (dataFF.isMissing()) {
                                ff = dataFF;
                            } else {
                                ff = new FlatField(rangeFT, newDomain);
                                ff.setSamples(dataFF.getFloats(copy), false);
                            }
                            fi.setSample(j, (Data)ff);
                        }
                    } else {
                        fi = new FlatField(rangeFT, newDomain);
                        ((FlatField)fi).setSamples(((FlatField)data).getFloats(copy), false);
                    }
                    newFieldImpl.setSample(i, (Data)fi);
                }
            }
            catch (RemoteException remoteException) {}
        } else if (!grid.isMissing()) {
            newFieldImpl = new FlatField(rangeFT, newDomain);
            try {
                ((FlatField)newFieldImpl).setSamples(grid.getFloats(copy), false);
            }
            catch (RemoteException remoteException) {}
        } else {
            newFieldImpl = grid;
        }
        return newFieldImpl;
    }

    public static boolean isSinglePointDomain(FieldImpl grid) throws VisADException {
        return GridUtil.isSinglePointDomain(GridUtil.getSpatialDomain(grid));
    }

    public static boolean isSinglePointDomain(SampledSet ss) throws VisADException {
        if (ss instanceof SingletonSet) {
            return true;
        }
        if (!(ss instanceof GriddedSet)) {
            return false;
        }
        GriddedSet gs = (GriddedSet)ss;
        int[] lengths = gs.getLengths();
        return lengths[0] == 1 && lengths[1] == 1;
    }

    public static boolean isSequence(FieldImpl grid) {
        return grid != null && !(grid instanceof FlatField) && ucar.visad.Util.getDomainSet(grid).getDimension() == 1;
    }

    public static boolean hasEnsemble(FieldImpl grid) throws VisADException {
        if (GridUtil.isSequence(grid)) {
            if (GridUtil.getSequenceType(grid).equals(ENSEMBLE_TYPE)) {
                return true;
            }
            try {
                Data inner = grid.getSample(0);
                return inner instanceof FieldImpl && GridUtil.isSequence((FieldImpl)inner) && GridUtil.getSequenceType((FieldImpl)inner).equals(ENSEMBLE_TYPE);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        return false;
    }

    public static RealType getEnsembleType(FieldImpl grid) throws VisADException {
        if (!GridUtil.hasEnsemble(grid)) {
            throw new IllegalArgumentException("grid is not an ensemble");
        }
        return ENSEMBLE_TYPE;
    }

    public static Gridded1DSet getEnsembleSet(FieldImpl ensGrid) throws VisADException {
        block5: {
            if (GridUtil.hasEnsemble(ensGrid)) {
                try {
                    if (GridUtil.isTimeSequence(ensGrid)) {
                        FieldImpl innerGrid = (FieldImpl)ensGrid.getSample(0);
                        if (GridUtil.hasEnsemble(innerGrid)) {
                            return (Gridded1DSet)innerGrid.getDomainSet();
                        }
                        break block5;
                    }
                    return (Gridded1DSet)ensGrid.getDomainSet();
                }
                catch (RemoteException re) {
                    return null;
                }
            }
        }
        return null;
    }

    public static boolean isTimeSequence(FieldImpl grid) throws VisADException {
        return GridUtil.isSequence(grid) && GridUtil.getSequenceType(grid).equals(RealType.Time);
    }

    public static Set getTimeSet(FieldImpl grid) throws VisADException {
        if (!GridUtil.isTimeSequence(grid)) {
            return null;
        }
        return ucar.visad.Util.getDomainSet(grid);
    }

    public static List<DateTime> getDateTimeList(FieldImpl grid) throws VisADException {
        SampledSet timeSet = (SampledSet)GridUtil.getTimeSet(grid);
        if (timeSet == null) {
            return null;
        }
        return CalendarDateTime.getDateTimeList(timeSet);
    }

    public static boolean isNavigated(FieldImpl grid) throws VisADException {
        return GridUtil.isNavigated(GridUtil.getSpatialDomain(grid));
    }

    public static boolean isNavigated(SampledSet spatialSet) throws VisADException {
        RealTupleType spatialType = ((SetType)spatialSet.getType()).getDomain();
        RealTupleType spatialReferenceType = spatialSet.getCoordinateSystem() != null ? spatialSet.getCoordinateSystem().getReference() : null;
        return spatialType.getIndex(RealType.Latitude) != -1 && spatialType.getIndex(RealType.Longitude) != -1 || spatialReferenceType != null && spatialReferenceType.getIndex(RealType.Latitude) != -1 && spatialReferenceType.getIndex(RealType.Longitude) != -1;
    }

    public static MapProjection getNavigation(FieldImpl grid) throws VisADException {
        return GridUtil.getNavigation(GridUtil.getSpatialDomain(grid));
    }

    public static MapProjection getNavigation(SampledSet spatialSet) throws VisADException {
        if (!GridUtil.isNavigated(spatialSet)) {
            throw new VisADException("Spatial domain has no navigation");
        }
        CoordinateSystem cs = spatialSet.getCoordinateSystem();
        if (cs != null) {
            if (cs instanceof CachingCoordinateSystem) {
                cs = ((CachingCoordinateSystem)cs).getCachedCoordinateSystem();
            }
            if (cs instanceof IdentityCoordinateSystem) {
                cs = null;
            } else if (cs.getDimension() == 3) {
                if (cs instanceof CartesianProductCoordinateSystem) {
                    CoordinateSystem[] csArray = ((CartesianProductCoordinateSystem)cs).getCoordinateSystems();
                    for (int i = 0; i < csArray.length; ++i) {
                        if (csArray[i].getDimension() != 2) continue;
                        cs = csArray[i];
                        break;
                    }
                } else if (cs instanceof Radar3DCoordinateSystem) {
                    cs = GridUtil.makeRadarMapProjection(cs);
                } else if (cs instanceof EmpiricalCoordinateSystem) {
                    spatialSet = ((EmpiricalCoordinateSystem)cs).getReferenceSet();
                    cs = null;
                } else if (cs instanceof NavigatedCoordinateSystem) {
                    cs = null;
                } else {
                    throw new VisADException("Unable to create MapProjection from " + cs.getClass());
                }
                if (cs instanceof CachingCoordinateSystem) {
                    cs = ((CachingCoordinateSystem)cs).getCachedCoordinateSystem();
                }
                if (cs instanceof IdentityCoordinateSystem) {
                    cs = null;
                }
            }
        }
        if (cs == null) {
            cs = GridUtil.makeMapProjection(spatialSet);
        }
        if (cs instanceof Radar2DCoordinateSystem) {
            cs = GridUtil.makeRadarMapProjection(cs);
        }
        if (!(cs instanceof MapProjection)) {
            throw new VisADException("Unable to create MapProjection from " + cs.getClass());
        }
        return (MapProjection)cs;
    }

    public static boolean isLatLonOrder(FieldImpl grid) throws VisADException {
        return GridUtil.isLatLonOrder(GridUtil.getSpatialDomain(grid));
    }

    public static boolean isLatLonOrder(SampledSet spatialSet) throws VisADException {
        RealTupleType spatialType = ((SetType)spatialSet.getType()).getDomain();
        RealTupleType spatialReferenceType = spatialSet.getCoordinateSystem() != null ? spatialSet.getCoordinateSystem().getReference() : null;
        return spatialType.equals(RealTupleType.LatitudeLongitudeTuple) || spatialType.equals(RealTupleType.LatitudeLongitudeAltitude) || spatialReferenceType != null && (spatialReferenceType.equals(RealTupleType.LatitudeLongitudeTuple) || spatialReferenceType.equals(RealTupleType.LatitudeLongitudeAltitude));
    }

    public static RealType getSequenceType(FieldImpl grid) throws VisADException {
        if (!GridUtil.isSequence(grid)) {
            throw new IllegalArgumentException("grid is not a sequence");
        }
        return (RealType)((SetType)ucar.visad.Util.getDomainSet(grid).getType()).getDomain().getComponent(0);
    }

    public static boolean is3D(FieldImpl grid) throws VisADException {
        return GridUtil.is3D(GridUtil.getSpatialDomain(grid));
    }

    public static boolean isVolume(FieldImpl grid) throws VisADException {
        SampledSet domainSet = GridUtil.getSpatialDomain(grid);
        return GridUtil.is3D(domainSet) && domainSet.getManifoldDimension() == 3;
    }

    public static RealTuple sampleToRealTuple(FieldImpl grid, EarthLocation el, Real animationValue, int samplingMode) throws VisADException, RemoteException {
        return GridUtil.sampleToRealTuple(grid, el, animationValue, samplingMode, 202);
    }

    public static RealTuple sampleToRealTuple(FieldImpl grid, EarthLocation el, Real animationValue, int samplingMode, int errorMode) throws VisADException, RemoteException {
        Data data;
        if (GridUtil.is3D(grid) && !GridUtil.isVolume(grid)) {
            grid = GridUtil.make2DGridFromSlice(grid, false);
        }
        FieldImpl sampleAtLocation = GridUtil.is3D(grid) ? GridUtil.sample(grid, el, samplingMode, errorMode) : GridUtil.sample(grid, el.getLatLonPoint(), samplingMode, errorMode);
        Data data2 = data = animationValue == null ? sampleAtLocation : sampleAtLocation.evaluate(animationValue, samplingMode, errorMode);
        while (data != null && !(data instanceof RealTuple)) {
            if (data instanceof FieldImpl) {
                data = data.getSample(0);
                continue;
            }
            if (data instanceof Tuple) {
                data = ((Tuple)data).getComponent(0);
                continue;
            }
            if (data instanceof Real) {
                data = new RealTuple(new Real[]{(Real)data});
                continue;
            }
            if (data instanceof RealTuple) continue;
            data = null;
        }
        return (RealTuple)data;
    }

    public static Real sampleToReal(FieldImpl grid, EarthLocation el, Real animationValue) throws VisADException, RemoteException {
        return GridUtil.sampleToReal(grid, el, animationValue, 100);
    }

    public static Real sampleToReal(FieldImpl grid, EarthLocation el, Real animationValue, int samplingMode) throws VisADException, RemoteException {
        return GridUtil.sampleToReal(grid, el, animationValue, samplingMode, 202);
    }

    public static Real sampleToReal(FieldImpl grid, EarthLocation el, Real animationValue, int samplingMode, int errorMode) throws VisADException, RemoteException {
        RealTuple sample = GridUtil.sampleToRealTuple(grid, el, animationValue, samplingMode, errorMode);
        return sample == null ? (Real)null : sample.getRealComponents()[0];
    }

    public static boolean is3D(SampledSet domainSet) throws VisADException {
        return domainSet.getDimension() == 3;
    }

    public static boolean is2D(FieldImpl grid) throws VisADException {
        return GridUtil.is2D(GridUtil.getSpatialDomain(grid));
    }

    public static boolean is2D(SampledSet domainSet) throws VisADException {
        return domainSet.getDimension() == 2;
    }

    public static FieldImpl subset(FieldImpl grid, int skip) throws VisADException {
        return GridUtil.subset(grid, skip, skip);
    }

    public static FieldImpl subset(FieldImpl grid, int skipx, int skipy) throws VisADException {
        return GridUtil.subset(grid, skipx, skipy, 1);
    }

    public static FieldImpl subset(FieldImpl grid, int skipx, int skipy, int skipz) throws VisADException {
        FieldImpl fi = grid;
        if (GridUtil.getTimeSet(grid) == null || GridUtil.isConstantSpatialDomain(grid)) {
            fi = GridUtil.subsetGrid(grid, skipx, skipy, skipz);
        } else {
            try {
                Set timeSet = GridUtil.getTimeSet(grid);
                fi = new FieldImpl((FunctionType)grid.getType(), timeSet);
                for (int i = 0; i < timeSet.getLength(); ++i) {
                    FieldImpl ff = (FieldImpl)grid.getSample(i);
                    FieldImpl slice = null;
                    slice = ff.isMissing() ? ff : GridUtil.subsetGrid(ff, skipx, skipy, skipz);
                    fi.setSample(i, (Data)slice, false);
                }
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        return fi;
    }

    private static FieldImpl subsetGrid(FieldImpl grid, int skipx, int skipy) throws VisADException {
        return GridUtil.subsetGrid(grid, skipx, skipy, 1);
    }

    private static FieldImpl subsetGrid(FieldImpl grid, int skipx, int skipy, int skipz) throws VisADException {
        Object subGrid = null;
        if (skipx == 1 && skipy == 1 && skipz == 1) {
            return grid;
        }
        GriddedSet domainSet = (GriddedSet)GridUtil.getSpatialDomain(grid);
        Set subDomain = null;
        if (skipz > 1 && domainSet.getManifoldDimension() < 3) {
            throw new VisADException("Unable to subset in Z for a 2D manifold");
        }
        if (domainSet instanceof LinearSet) {
            Linear1DSet newY;
            Linear1DSet xSet = ((LinearSet)((Object)domainSet)).getLinear1DComponent(0);
            Linear1DSet ySet = ((LinearSet)((Object)domainSet)).getLinear1DComponent(1);
            int numSteps = 1 + (xSet.getLength() - 1) / skipx;
            Linear1DSet newX = skipx == 1 ? xSet : new Linear1DSet(xSet.getType(), xSet.getFirst(), xSet.getFirst() + (double)(numSteps - 1) * xSet.getStep() * (double)skipx, numSteps);
            numSteps = 1 + (ySet.getLength() - 1) / skipy;
            Linear1DSet linear1DSet = newY = skipy == 1 ? ySet : new Linear1DSet(ySet.getType(), ySet.getFirst(), ySet.getFirst() + (double)(numSteps - 1) * ySet.getStep() * (double)skipy, numSteps);
            if (domainSet instanceof LinearLatLonSet) {
                subDomain = new LinearLatLonSet(domainSet.getType(), new Linear1DSet[]{newX, newY}, domainSet.getCoordinateSystem(), domainSet.getSetUnits(), domainSet.getSetErrors());
            } else if (domainSet instanceof Linear2DSet) {
                subDomain = new Linear2DSet(domainSet.getType(), new Linear1DSet[]{newX, newY}, domainSet.getCoordinateSystem(), domainSet.getSetUnits(), domainSet.getSetErrors());
            } else if (domainSet instanceof Linear3DSet) {
                Linear1DSet zSet = ((LinearSet)((Object)domainSet)).getLinear1DComponent(2);
                if (zSet.getLength() > 1) {
                    numSteps = 1 + (zSet.getLength() - 1) / skipz;
                    Linear1DSet newZ = skipz == 1 ? zSet : new Linear1DSet(zSet.getType(), zSet.getFirst(), zSet.getFirst() + (double)(numSteps - 1) * zSet.getStep() * (double)skipz, numSteps);
                    subDomain = new Linear3DSet(domainSet.getType(), new Linear1DSet[]{newX, newY, newZ}, domainSet.getCoordinateSystem(), domainSet.getSetUnits(), domainSet.getSetErrors());
                } else {
                    float[][] samples = domainSet.getSamples(false);
                    int sizeX = domainSet.getLength(0);
                    int sizeY = domainSet.getLength(1);
                    int sizeZ = 1;
                    int newSizeX = 1 + (sizeX - 1) / skipx;
                    int newSizeY = 1 + (sizeY - 1) / skipy;
                    float[][] subSamples = new float[domainSet.getDimension()][newSizeX * newSizeY * sizeZ];
                    int l = 0;
                    for (int k = 0; k < sizeZ; ++k) {
                        for (int j = 0; j < sizeY; j += skipy) {
                            for (int i = 0; i < sizeX; i += skipx) {
                                int elem = i + (j + k * sizeY) * sizeX;
                                subSamples[0][l] = samples[0][elem];
                                subSamples[1][l] = samples[1][elem];
                                subSamples[2][l] = samples[2][elem];
                                ++l;
                            }
                        }
                    }
                    subDomain = new Gridded3DSet(domainSet.getType(), subSamples, newSizeX, newSizeY, domainSet.getCoordinateSystem(), domainSet.getSetUnits(), domainSet.getSetErrors(), false);
                }
            }
        } else {
            int[] nArray;
            float[][] samples = domainSet.getSamples(false);
            int sizeX = domainSet.getLength(0);
            int sizeY = domainSet.getLength(1);
            int sizeZ = domainSet.getManifoldDimension() == 3 ? domainSet.getLength(2) : 1;
            int newSizeX = 1 + (sizeX - 1) / skipx;
            int newSizeY = 1 + (sizeY - 1) / skipy;
            int newSizeZ = 1 + (sizeZ - 1) / skipz;
            float[][] subSamples = new float[domainSet.getDimension()][newSizeX * newSizeY * newSizeZ];
            int l = 0;
            for (int k = 0; k < sizeZ; k += skipz) {
                for (int j = 0; j < sizeY; j += skipy) {
                    for (int i = 0; i < sizeX; i += skipx) {
                        int elem = i + (j + k * sizeY) * sizeX;
                        subSamples[0][l] = samples[0][elem];
                        subSamples[1][l] = samples[1][elem];
                        if (domainSet.getDimension() == 3) {
                            subSamples[2][l] = samples[2][elem];
                        }
                        ++l;
                    }
                }
            }
            if (domainSet.getManifoldDimension() == 3) {
                int[] nArray2 = new int[3];
                nArray2[0] = newSizeX;
                nArray2[1] = newSizeY;
                nArray = nArray2;
                nArray2[2] = newSizeZ;
            } else {
                int[] nArray3 = new int[2];
                nArray3[0] = newSizeX;
                nArray = nArray3;
                nArray3[1] = newSizeY;
            }
            int[] newSizes = nArray;
            try {
                subDomain = GriddedSet.create(domainSet.getType(), subSamples, newSizes, domainSet.getCoordinateSystem(), domainSet.getSetUnits(), domainSet.getSetErrors(), false, true);
            }
            catch (SetException se) {
                String msg = se.getMessage();
                if (msg.indexOf("form a valid grid") >= 0 || msg.indexOf("may not be missing") >= 0) {
                    subDomain = GriddedSet.create(domainSet.getType(), subSamples, newSizes, domainSet.getCoordinateSystem(), domainSet.getSetUnits(), domainSet.getSetErrors(), false, false);
                }
                throw new VisADException(se);
            }
        }
        return subDomain.getDimension() == 3 && ((SimpleSet)subDomain).getManifoldDimension() == 2 ? GridUtil.resample2DManifold(grid, (SampledSet)subDomain, skipx, skipy) : GridUtil.resampleGrid(grid, (SampledSet)subDomain, 100);
    }

    public static GriddedSet subsetDomain(GriddedSet domainSet, int skipx, int skipy, int skipz) throws VisADException {
        if (skipx == 1 && skipy == 1 && skipz == 1) {
            return domainSet;
        }
        GriddedSet subDomain = null;
        if (skipz > 1 && domainSet.getManifoldDimension() < 3) {
            throw new VisADException("Unable to subset in Z for a 2D manifold");
        }
        if (domainSet instanceof LinearSet) {
            Linear1DSet newY;
            Linear1DSet xSet = ((LinearSet)((Object)domainSet)).getLinear1DComponent(0);
            Linear1DSet ySet = ((LinearSet)((Object)domainSet)).getLinear1DComponent(1);
            int numSteps = 1 + (xSet.getLength() - 1) / skipx;
            Linear1DSet newX = skipx == 1 ? xSet : new Linear1DSet(xSet.getType(), xSet.getFirst(), xSet.getFirst() + (double)(numSteps - 1) * xSet.getStep() * (double)skipx, numSteps);
            numSteps = 1 + (ySet.getLength() - 1) / skipy;
            Linear1DSet linear1DSet = newY = skipy == 1 ? ySet : new Linear1DSet(ySet.getType(), ySet.getFirst(), ySet.getFirst() + (double)(numSteps - 1) * ySet.getStep() * (double)skipy, numSteps);
            if (domainSet instanceof LinearLatLonSet) {
                subDomain = new LinearLatLonSet(domainSet.getType(), new Linear1DSet[]{newX, newY}, domainSet.getCoordinateSystem(), domainSet.getSetUnits(), domainSet.getSetErrors());
            } else if (domainSet instanceof Linear2DSet) {
                subDomain = new Linear2DSet(domainSet.getType(), new Linear1DSet[]{newX, newY}, domainSet.getCoordinateSystem(), domainSet.getSetUnits(), domainSet.getSetErrors());
            } else if (domainSet instanceof Linear3DSet) {
                Linear1DSet zSet = ((LinearSet)((Object)domainSet)).getLinear1DComponent(2);
                if (zSet.getLength() > 1) {
                    numSteps = 1 + (zSet.getLength() - 1) / skipz;
                    Linear1DSet newZ = skipz == 1 ? zSet : new Linear1DSet(zSet.getType(), zSet.getFirst(), zSet.getFirst() + (double)(numSteps - 1) * zSet.getStep() * (double)skipz, numSteps);
                    subDomain = new Linear3DSet(domainSet.getType(), new Linear1DSet[]{newX, newY, newZ}, domainSet.getCoordinateSystem(), domainSet.getSetUnits(), domainSet.getSetErrors());
                } else {
                    float[][] samples = domainSet.getSamples(false);
                    int sizeX = domainSet.getLength(0);
                    int sizeY = domainSet.getLength(1);
                    int sizeZ = 1;
                    int newSizeX = 1 + (sizeX - 1) / skipx;
                    int newSizeY = 1 + (sizeY - 1) / skipy;
                    float[][] subSamples = new float[domainSet.getDimension()][newSizeX * newSizeY * sizeZ];
                    int l = 0;
                    for (int k = 0; k < sizeZ; ++k) {
                        for (int j = 0; j < sizeY; j += skipy) {
                            for (int i = 0; i < sizeX; i += skipx) {
                                int elem = i + (j + k * sizeY) * sizeX;
                                subSamples[0][l] = samples[0][elem];
                                subSamples[1][l] = samples[1][elem];
                                subSamples[2][l] = samples[2][elem];
                                ++l;
                            }
                        }
                    }
                    subDomain = new Gridded3DSet(domainSet.getType(), subSamples, newSizeX, newSizeY, domainSet.getCoordinateSystem(), domainSet.getSetUnits(), domainSet.getSetErrors(), false);
                }
            }
        } else {
            int[] nArray;
            float[][] samples = domainSet.getSamples(false);
            int sizeX = domainSet.getLength(0);
            int sizeY = domainSet.getLength(1);
            int sizeZ = domainSet.getManifoldDimension() == 3 ? domainSet.getLength(2) : 1;
            int newSizeX = 1 + (sizeX - 1) / skipx;
            int newSizeY = 1 + (sizeY - 1) / skipy;
            int newSizeZ = 1 + (sizeZ - 1) / skipz;
            float[][] subSamples = new float[domainSet.getDimension()][newSizeX * newSizeY * newSizeZ];
            int l = 0;
            for (int k = 0; k < sizeZ; k += skipz) {
                for (int j = 0; j < sizeY; j += skipy) {
                    for (int i = 0; i < sizeX; i += skipx) {
                        int elem = i + (j + k * sizeY) * sizeX;
                        subSamples[0][l] = samples[0][elem];
                        subSamples[1][l] = samples[1][elem];
                        if (domainSet.getDimension() == 3) {
                            subSamples[2][l] = samples[2][elem];
                        }
                        ++l;
                    }
                }
            }
            if (domainSet.getManifoldDimension() == 3) {
                int[] nArray2 = new int[3];
                nArray2[0] = newSizeX;
                nArray2[1] = newSizeY;
                nArray = nArray2;
                nArray2[2] = newSizeZ;
            } else {
                int[] nArray3 = new int[2];
                nArray3[0] = newSizeX;
                nArray = nArray3;
                nArray3[1] = newSizeY;
            }
            int[] newSizes = nArray;
            try {
                subDomain = GriddedSet.create(domainSet.getType(), subSamples, newSizes, domainSet.getCoordinateSystem(), domainSet.getSetUnits(), domainSet.getSetErrors(), false, true);
            }
            catch (SetException se) {
                String msg = se.getMessage();
                if (msg.indexOf("form a valid grid") >= 0 || msg.indexOf("may not be missing") >= 0) {
                    subDomain = GriddedSet.create(domainSet.getType(), subSamples, newSizes, domainSet.getCoordinateSystem(), domainSet.getSetUnits(), domainSet.getSetErrors(), false, false);
                }
                throw new VisADException(se);
            }
        }
        return subDomain;
    }

    public static FieldImpl sliceAtLevel(FieldImpl grid, Real level) throws VisADException {
        return GridUtil.sliceAtLevel(grid, level, 101);
    }

    public static FieldImpl sliceAtLevel(FieldImpl grid, Real level, int samplingMode) throws VisADException {
        return GridUtil.sliceAtLevel(grid, level, samplingMode, 202);
    }

    public static FieldImpl sliceAtLevel(FieldImpl grid, Real level, int samplingMode, int errorMode) throws VisADException {
        FieldImpl fi = grid;
        if (GridUtil.getTimeSet(grid) == null || GridUtil.isConstantSpatialDomain(grid)) {
            fi = GridUtil.slice(grid, GridUtil.makeSliceFromLevel((GriddedSet)GridUtil.getSpatialDomain(grid), level), samplingMode, errorMode);
        } else {
            try {
                Set timeSet = GridUtil.getTimeSet(grid);
                for (int i = 0; i < timeSet.getLength(); ++i) {
                    FieldImpl ff = (FieldImpl)grid.getSample(i);
                    FieldImpl slice = null;
                    slice = ff.isMissing() ? ff : GridUtil.slice(ff, GridUtil.makeSliceFromLevel((GriddedSet)GridUtil.getSpatialDomain(grid, i), level), samplingMode, errorMode);
                    if (i == 0) {
                        fi = new FieldImpl(new FunctionType(((SetType)timeSet.getType()).getDomain(), (FunctionType)slice.getType()), timeSet);
                    }
                    fi.setSample(i, (Data)slice, false);
                }
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        return fi;
    }

    public static boolean isAllMissing(FieldImpl field) throws VisADException {
        return GridUtil.isAllMissing(field, false);
    }

    public static boolean isAllMissing(FieldImpl grid, boolean popupErrorMessage) throws VisADException {
        try {
            float[][] values = grid.getFloats(false);
            if (values == null) {
                return true;
            }
            if (Misc.isNaN(values)) {
                if (popupErrorMessage) {
                    String msg = new String("All " + values.length * values[0].length + " data values missing");
                    LogUtil.userErrorMessage(msg);
                }
                return true;
            }
        }
        catch (RemoteException re) {
            throw new VisADException("RemoteException checking missing data");
        }
        return false;
    }

    public static boolean isAnyMissing(FieldImpl grid) throws VisADException {
        try {
            float[][] values = grid.getFloats(false);
            if (values == null) {
                return true;
            }
            for (int i = 0; i < values.length; ++i) {
                for (int j = 0; j < values[i].length; ++j) {
                    float value = values[i][j];
                    if (value == value) continue;
                    return true;
                }
            }
        }
        catch (RemoteException re) {
            throw new VisADException("RemoteException checking missing data");
        }
        return false;
    }

    public static FieldImpl averageOverTime(FieldImpl grid, boolean makeTimes) throws VisADException {
        return GridMath.applyFunctionOverTime(grid, FUNC_AVERAGE, makeTimes);
    }

    public static FieldImpl timeStepDifference(FieldImpl grid, int offset) throws VisADException {
        return GridMath.timeStepFunc(grid, offset, FUNC_DIFFERENCE);
    }

    public static FieldImpl timeStepSum(FieldImpl grid, int offset) throws VisADException {
        return GridMath.timeStepFunc(grid, offset, FUNC_SUM);
    }

    public static FieldImpl differenceFromBaseTime(FieldImpl grid) throws VisADException {
        return GridMath.timeStepFunc(grid, 0, FUNC_DIFFERENCE);
    }

    public static FieldImpl sumFromBaseTime(FieldImpl grid) throws VisADException {
        return GridMath.timeStepFunc(grid, 0, FUNC_SUM);
    }

    public static FieldImpl timeStepFunc(FieldImpl grid, int offset, String func) throws VisADException {
        return GridMath.timeStepFunc(grid, offset, func);
    }

    public static FieldImpl sumOverTime(FieldImpl grid, boolean makeTimes) throws VisADException {
        return GridMath.applyFunctionOverTime(grid, FUNC_SUM, makeTimes);
    }

    public static FieldImpl minOverTime(FieldImpl grid, boolean makeTimes) throws VisADException {
        return GridMath.applyFunctionOverTime(grid, FUNC_MIN, makeTimes);
    }

    public static FieldImpl maxOverTime(FieldImpl grid, boolean makeTimes) throws VisADException {
        return GridMath.applyFunctionOverTime(grid, FUNC_MAX, makeTimes);
    }

    public static FieldImpl applyFunctionOverTime(FieldImpl grid, String function, boolean makeTimes) throws VisADException {
        return GridMath.applyFunctionOverTime(grid, function, makeTimes);
    }

    public static Gridded2DSet makeDomain2D(GriddedSet domainSet) throws VisADException {
        if (domainSet.getManifoldDimension() < 2) {
            throw new VisADException("grid needs to be at least a 2D manifold");
        }
        if (domainSet instanceof Gridded2DSet) {
            return (Gridded2DSet)domainSet;
        }
        Gridded2DSet newDomainSet = null;
        RealTupleType domainType = ((SetType)domainSet.getType()).getDomain();
        RealTupleType newType = null;
        CoordinateSystem cs = domainSet.getCoordinateSystem();
        if (cs != null) {
            if (cs instanceof EmpiricalCoordinateSystem) {
                domainSet = ((EmpiricalCoordinateSystem)cs).getReferenceSet();
                domainType = ((SetType)domainSet.getType()).getDomain();
                newType = new RealTupleType((RealType)domainType.getComponent(0), (RealType)domainType.getComponent(1));
            } else {
                MapProjection mp = GridUtil.getNavigation(domainSet);
                newType = new RealTupleType((RealType)domainType.getComponent(0), (RealType)domainType.getComponent(1), mp, null);
            }
        } else {
            newType = new RealTupleType((RealType)domainType.getComponent(0), (RealType)domainType.getComponent(1));
        }
        if (domainSet instanceof Linear3DSet) {
            Linear3DSet linearSet = (Linear3DSet)domainSet;
            newDomainSet = new Linear2DSet((MathType)newType, new Linear1DSet[]{linearSet.getX(), linearSet.getY()});
            return newDomainSet;
        }
        float[][] samples = domainSet.getSamples(false);
        int[] lengths = domainSet.getLengths();
        Unit[] setUnits = domainSet.getSetUnits();
        int sizeX = lengths[0];
        int sizeY = lengths[1];
        Object newSamples = null;
        if (domainSet.getManifoldDimension() == 2) {
            newSamples = new float[][]{samples[0], samples[1]};
        } else {
            newSamples = new float[2][sizeX * sizeY];
            for (int j = 0; j < sizeY; ++j) {
                for (int i = 0; i < sizeX; ++i) {
                    int index = j * sizeX + i;
                    newSamples[0][index] = samples[0][index];
                    newSamples[1][index] = samples[1][index];
                }
            }
        }
        newDomainSet = new Gridded2DSet(newType, (float[][])newSamples, sizeX, sizeY, null, new Unit[]{setUnits[0], setUnits[1]}, null, true);
        return newDomainSet;
    }

    private static GriddedSet addLevelTo2DDomain(Gridded2DSet domainSet, double levelValue, String levelUnit) throws VisADException {
        if (domainSet.getManifoldDimension() != 2) {
            throw new VisADException("Input domain needs to be a 2D set on a 2D manifold");
        }
        GriddedSet newDomain = null;
        RealTupleType domainType = ((SetType)domainSet.getType()).getDomain();
        RealType xType = (RealType)domainType.getComponent(0);
        RealType yType = (RealType)domainType.getComponent(1);
        Unit zUnit = ucar.visad.Util.parseUnit(levelUnit);
        CoordinateSystem cs = domainType.getCoordinateSystem();
        if (domainSet instanceof Gridded2DSet) {
            float[][] samples = domainSet.getSamples();
            int sizeX = domainSet.getLength(0);
            int sizeY = domainSet.getLength(1);
            Unit[] setUnits = domainSet.getSetUnits();
            CoordinateSystem zCS = null;
            RealType zType = null;
            if (zUnit.isConvertible(CommonUnits.HECTOPASCAL)) {
                zType = AirPressure.getRealType();
                zCS = AirPressure.getStandardAtmosphereCS();
            } else if (zUnit.isConvertible(CommonUnit.meter)) {
                zType = RealType.getRealType("alti", zUnit);
                zCS = new IdentityCoordinateSystem(new RealTupleType(RealType.Altitude));
            } else {
                throw new VisADException("Unknown vertical Unit");
            }
            CartesianProductCoordinateSystem compCS = new CartesianProductCoordinateSystem(cs, zCS);
            float[][] newSamples = new float[3][];
            newSamples[0] = samples[0];
            newSamples[1] = samples[1];
            float[] zSamples = new float[newSamples[0].length];
            Arrays.fill(zSamples, (float)levelValue);
            newSamples[2] = zSamples;
            RealTupleType newDomainType = new RealTupleType(xType, yType, zType, compCS, null);
            Unit[] newUnits = new Unit[]{setUnits[0], setUnits[1], zUnit};
            newDomain = GriddedSet.create(newDomainType, newSamples, domainSet.getLengths(), null, newUnits, null, false, true);
        } else {
            System.out.println("not a gridded2D set: " + domainSet.getClass().getName());
        }
        return newDomain;
    }

    public static FieldImpl addLevelToGrid(FieldImpl grid, double levelValue, String levelUnit) throws VisADException {
        SampledSet domainSet = GridUtil.getSpatialDomain(grid);
        if (!(domainSet instanceof Gridded2DSet)) {
            throw new VisADException("Domain must be a Gridded2DSet");
        }
        return GridUtil.setSpatialDomain(grid, GridUtil.addLevelTo2DDomain((Gridded2DSet)domainSet, levelValue, levelUnit));
    }

    public static TupleType makeNewParamType(TupleType oldParamType, String newSuffix) throws VisADException {
        RealType[] rts = oldParamType.getRealComponents();
        RealType[] newRTs = new RealType[rts.length];
        for (int i = 0; i < rts.length; ++i) {
            String extra;
            int finalBracket;
            String oldName = rts[i].getName();
            String baseName = ucar.visad.Util.cleanTypeName(oldName);
            Unit defaultUnit = rts[i].getDefaultUnit();
            newRTs[i] = ucar.visad.Util.makeRealType(baseName + newSuffix, defaultUnit);
            int unitBracket = oldName.indexOf("[unit:");
            if (unitBracket < 0 || (finalBracket = oldName.lastIndexOf("]")) <= unitBracket || (extra = oldName.substring(finalBracket + 1)).isEmpty()) continue;
            newRTs[i] = RealType.getRealType(newRTs[i].getName() + extra, defaultUnit);
            if (newRTs[i] != null) continue;
            newRTs[i] = ucar.visad.Util.makeRealType(baseName + newSuffix + extra, defaultUnit);
        }
        if (rts.length == oldParamType.getDimension()) {
            if (oldParamType instanceof RealVectorType) {
                return new EarthVectorType(newRTs);
            }
            return new RealTupleType(newRTs);
        }
        MathType[] types = oldParamType.getComponents();
        MathType[] newTypes = new MathType[types.length];
        int usedRealTypes = 0;
        for (int i = 0; i < types.length; ++i) {
            MathType mt = types[i];
            if (mt instanceof RealTupleType) {
                RealType[] subTypes = new RealType[((RealTupleType)mt).getDimension()];
                for (int j = 0; j < subTypes.length; ++j) {
                    subTypes[j] = newRTs[usedRealTypes++];
                }
                if (mt instanceof RealVectorType) {
                    newTypes[i] = new EarthVectorType(subTypes);
                    continue;
                }
                newTypes[i] = new RealTupleType(subTypes);
                continue;
            }
            if (mt instanceof RealType) {
                newTypes[i] = newRTs[usedRealTypes++];
                continue;
            }
            throw new VisADException("Unable to create new MathType for old param type: " + oldParamType);
        }
        return new TupleType(newTypes);
    }

    public static Grid2D makeGrid2D(FieldImpl grid) throws VisADException, RemoteException {
        SampledSet domain = GridUtil.getSpatialDomain(grid);
        if (!(domain instanceof GriddedSet)) {
            throw new IllegalArgumentException("Spatial domain is not a griddedset:" + domain.getClass().getName());
        }
        GriddedSet griddedSet = (GriddedSet)domain;
        int[] lengths = griddedSet.getLengths();
        if (lengths.length != 2) {
            throw new IllegalArgumentException("Spatial domain is not 2D:" + lengths.length);
        }
        int latIndex = GridUtil.isLatLonOrder(domain) ? 0 : 1;
        int lonIndex = GridUtil.isLatLonOrder(domain) ? 1 : 0;
        int xCnt = lengths[0];
        int yCnt = lengths[1];
        float[][] latLons = GridUtil.getEarthLocationPoints(griddedSet);
        float[] lats = latLons[latIndex];
        float[] lons = latLons[lonIndex];
        float[][] values = grid.getFloats(false);
        float[][] lat2D = new float[xCnt][yCnt];
        float[][] lon2D = new float[xCnt][yCnt];
        int rangeCnt = values.length;
        float[][][] value2D = new float[rangeCnt][xCnt][yCnt];
        for (int i = 0; i < lats.length; ++i) {
            int xIdx = i % xCnt;
            int yIdx = i / xCnt;
            lat2D[xIdx][yIdx] = lats[i];
            lon2D[xIdx][yIdx] = lons[i];
            for (int rangeIdx = 0; rangeIdx < rangeCnt; ++rangeIdx) {
                value2D[rangeIdx][xIdx][yIdx] = values[rangeIdx][i];
            }
        }
        return new Grid2D(lat2D, lon2D, value2D);
    }

    public static void testIt(FieldImpl grid) throws VisADException, RemoteException {
        if (!GridUtil.isTimeSequence(grid)) {
            Grid2D grid2D = GridUtil.makeGrid2D(grid);
            return;
        }
        float[][] values = null;
        Set timeDomain = ucar.visad.Util.getDomainSet(grid);
        int numTimeSteps = timeDomain.getLength();
        for (int timeStepIdx = 0; timeStepIdx < timeDomain.getLength(); ++timeStepIdx) {
            FieldImpl timeStep = (FieldImpl)grid.getSample(timeStepIdx);
            if (timeStepIdx != 0) continue;
            Grid2D grid2D = GridUtil.makeGrid2D(timeStep);
        }
    }

    public static FieldImpl sliceAtLevel(FieldImpl grid, double levelValue) throws VisADException {
        return GridUtil.sliceAtLevel(grid, new Real(levelValue));
    }

    public static FieldImpl getProfileAtLatLonPoint(FieldImpl grid, LatLonPoint point) throws VisADException {
        return GridUtil.getProfileAtLatLonPoint(grid, point, 101);
    }

    public static FieldImpl getProfileAtLatLonPoint(FieldImpl grid, LatLonPoint point, int samplingMode) throws VisADException {
        return GridUtil.getProfileAtLatLonPoint(grid, point, samplingMode, 202);
    }

    public static FieldImpl getProfileAtLatLonPoint(FieldImpl grid, LatLonPoint point, int samplingMode, int errorMode) throws VisADException {
        return GridUtil.sliceAlongLatLonLine(grid, point, point, samplingMode, errorMode);
    }

    public static FieldImpl sliceAlongLatLonLine(FieldImpl grid, LatLonPoint start, LatLonPoint end) throws VisADException {
        return GridUtil.sliceAlongLatLonLine(grid, start, end, 101);
    }

    public static FieldImpl sliceAlongLatLonLine(FieldImpl grid, LatLonPoint start, LatLonPoint end, int samplingMode) throws VisADException {
        return GridUtil.sliceAlongLatLonLine(grid, start, end, samplingMode, 202);
    }

    public static FieldImpl sliceAlongLatLonLine(FieldImpl grid, List<LatLonPoint> points, int samplingMode) throws VisADException {
        return GridUtil.sliceAlongLatLonLine(grid, points, samplingMode, 202);
    }

    public static FieldImpl sliceAlongLatLonLine(FieldImpl grid, List<LatLonPoint> points, int samplingMode, int errorMode) throws VisADException {
        FieldImpl fi = grid;
        if (GridUtil.isSinglePointDomain(grid) || grid == null) {
            return grid;
        }
        if (GridUtil.is3D(grid) && !GridUtil.isVolume(grid)) {
            grid = GridUtil.make2DGridFromSlice(grid, false);
        }
        if (GridUtil.getTimeSet(grid) == null || GridUtil.isConstantSpatialDomain(grid)) {
            fi = GridUtil.slice(grid, GridUtil.makeSliceFromLatLonPoints((GriddedSet)GridUtil.getSpatialDomain(grid), points), samplingMode, errorMode);
        } else {
            try {
                Set timeSet = GridUtil.getTimeSet(grid);
                for (int i = 0; i < timeSet.getLength(); ++i) {
                    FieldImpl ff = (FieldImpl)grid.getSample(i);
                    FieldImpl slice = null;
                    slice = ff.isMissing() ? ff : GridUtil.slice(ff, GridUtil.makeSliceFromLatLonPoints((GriddedSet)GridUtil.getSpatialDomain(grid, i), points), samplingMode, errorMode);
                    if (i == 0) {
                        fi = new FieldImpl(new FunctionType(((SetType)timeSet.getType()).getDomain(), (FunctionType)slice.getType()), timeSet);
                    }
                    fi.setSample(i, (Data)slice, false);
                }
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        return fi;
    }

    public static FieldImpl sliceAlongLatLonLine(FieldImpl grid, LatLonPoint start, LatLonPoint end, int samplingMode, int errorMode) throws VisADException {
        ArrayList<LatLonPoint> points = new ArrayList<LatLonPoint>();
        points.add(start);
        points.add(end);
        return GridUtil.sliceAlongLatLonLine(grid, points, samplingMode, errorMode);
    }

    public static FieldImpl sample(FieldImpl grid, EarthLocation location) throws VisADException {
        return GridUtil.sample(grid, location, 101);
    }

    public static FieldImpl sample(FieldImpl grid, EarthLocation location, int samplingMode) throws VisADException {
        return GridUtil.sample(grid, location, samplingMode, 202);
    }

    public static FieldImpl sample(FieldImpl grid, EarthLocation location, int samplingMode, int errorMode) throws VisADException {
        SampledSet spatialSet = GridUtil.getSpatialDomain(grid);
        if (!GridUtil.isNavigated(spatialSet)) {
            throw new IllegalArgumentException("Domain is not georeferenced");
        }
        if (spatialSet.getManifoldDimension() != 3) {
            throw new IllegalArgumentException("Grid must be 3D");
        }
        RealTuple point = null;
        Real longitude = GridUtil.normalizeLongitude(spatialSet, location.getLongitude());
        try {
            point = GridUtil.isLatLonOrder(grid) ? new RealTuple(new Real[]{location.getLatitude(), longitude, location.getAltitude()}) : new RealTuple(new Real[]{longitude, location.getLatitude(), location.getAltitude()});
        }
        catch (RemoteException re) {
            throw new VisADException("Can't get position from point");
        }
        return GridUtil.sampleAtPoint(grid, point, samplingMode, errorMode);
    }

    public static FieldImpl sample(FieldImpl grid, LatLonPoint point) throws VisADException {
        return GridUtil.sample(grid, point, 101);
    }

    public static FieldImpl sample(FieldImpl grid, LatLonPoint point, int samplingMode) throws VisADException {
        return GridUtil.sample(grid, point, samplingMode, 202);
    }

    public static FieldImpl sample(FieldImpl grid, LatLonPoint point, int samplingMode, int errorMode) throws VisADException {
        SampledSet spatialSet = GridUtil.getSpatialDomain(grid);
        if (!GridUtil.isNavigated(spatialSet)) {
            throw new IllegalArgumentException("Domain is not georeferenced");
        }
        if (spatialSet.getManifoldDimension() != 2) {
            throw new IllegalArgumentException("Can't sample a 3-D grid on Lat/Lon only");
        }
        RealTuple location = null;
        Real longitude = GridUtil.normalizeLongitude(spatialSet, point.getLongitude());
        try {
            location = GridUtil.isLatLonOrder(grid) ? new RealTuple(new Real[]{point.getLatitude(), longitude}) : new RealTuple(new Real[]{longitude, point.getLatitude()});
        }
        catch (RemoteException re) {
            throw new VisADException("Can't get position from point");
        }
        return GridUtil.sampleAtPoint(grid, location, samplingMode, errorMode);
    }

    public static FieldImpl slice(FieldImpl grid, SampledSet slice) throws VisADException {
        return GridUtil.slice(grid, slice, 101);
    }

    public static FieldImpl slice(FieldImpl grid, SampledSet slice, int samplingMode) throws VisADException {
        return GridUtil.slice(grid, slice, samplingMode, 202);
    }

    public static FieldImpl slice(FieldImpl grid, SampledSet slice, int samplingMode, int errorMode) throws VisADException {
        return GridUtil.resampleGrid(grid, slice, samplingMode, errorMode);
    }

    public static FieldImpl make2DGridFromSlice(FieldImpl slice) throws VisADException {
        return GridUtil.make2DGridFromSlice(slice, true);
    }

    public static FieldImpl make2DGridFromSlice(FieldImpl slice, boolean copy) throws VisADException {
        GriddedSet domainSet = (GriddedSet)GridUtil.getSpatialDomain(slice);
        if (domainSet.getDimension() != 3 && domainSet.getManifoldDimension() != 2) {
            throw new VisADException("slice is not 3D with 2D manifold");
        }
        Gridded2DSet new2DDomainSet = GridUtil.makeDomain2D(domainSet);
        if (GridUtil.isConstantSpatialDomain(slice)) {
            return GridUtil.setSpatialDomain(slice, new2DDomainSet, copy);
        }
        if (GridUtil.isTimeSequence(slice)) {
            Set timeSet = GridUtil.getTimeSet(slice);
            GriddedSet lastDomainSet = domainSet;
            Gridded2DSet last2DDomainSet = new2DDomainSet;
            try {
                FieldImpl newSlice = GridUtil.setSpatialDomain((FieldImpl)slice.getSample(0), last2DDomainSet, copy);
                FieldImpl retField = new FieldImpl(new FunctionType(((SetType)timeSet.getType()).getDomain(), newSlice.getType()), timeSet);
                retField.setSample(0, (Data)newSlice, copy);
                for (int t = 1; t < timeSet.getLength(); ++t) {
                    FieldImpl timeStep = (FieldImpl)slice.getSample(t, false);
                    GriddedSet domain = (GriddedSet)GridUtil.getSpatialDomain(timeStep);
                    if (!domain.equals(lastDomainSet)) {
                        lastDomainSet = domain;
                        last2DDomainSet = GridUtil.makeDomain2D(domain);
                    }
                    newSlice = GridUtil.setSpatialDomain((FieldImpl)slice.getSample(t), last2DDomainSet, copy);
                    retField.setSample(t, (Data)newSlice, copy);
                }
                return retField;
            }
            catch (RemoteException re) {
                throw new VisADException("Got unexpected RemoteException: " + re.getMessage());
            }
        }
        throw new VisADException("Unable to handle time series with different spatial domains");
    }

    public static Unit[] getParamUnits(FieldImpl grid) throws VisADException {
        Unit[] units = null;
        try {
            if (grid instanceof FlatField) {
                units = DataUtility.getRangeUnits((FlatField)grid);
            } else if (GridUtil.isTimeSequence(grid)) {
                Data d = grid.getSample(0);
                if (d instanceof FlatField) {
                    units = DataUtility.getRangeUnits((FlatField)d);
                } else if (d instanceof FieldImpl) {
                    if (GridUtil.isSequence((FieldImpl)d)) {
                        if ((d = ((FieldImpl)d).getSample(0)) instanceof Real) {
                            units = new Unit[]{((Real)d).getUnit()};
                        } else if (d instanceof Tuple) {
                            Real[] reals = ((Tuple)d).getRealComponents();
                            units = new Unit[reals.length];
                            for (int i = 0; i < reals.length; ++i) {
                                units[i] = reals[i].getUnit();
                            }
                        } else if (d instanceof FlatField) {
                            units = DataUtility.getRangeUnits((FlatField)d);
                        }
                    } else {
                        units = DataUtility.getRangeUnits((FlatField)d);
                    }
                }
            } else if (GridUtil.isSequence(grid)) {
                Data d = grid.getSample(0);
                if (d instanceof FlatField) {
                    units = DataUtility.getRangeUnits((FlatField)d);
                } else if (d instanceof Real) {
                    units = new Unit[]{((Real)d).getUnit()};
                } else if (d instanceof Tuple) {
                    Real[] reals = ((Tuple)d).getRealComponents();
                    units = new Unit[reals.length];
                    for (int i = 0; i < reals.length; ++i) {
                        units[i] = reals[i].getUnit();
                    }
                }
            }
        }
        catch (RemoteException re) {
            throw new VisADException("problem getting param units " + re);
        }
        return units;
    }

    public static String printit(FieldImpl field) throws VisADException, RemoteException {
        Data d = field.getSample(0);
        return "sample:" + d.getClass().getName();
    }

    public static TupleType getParamType(FieldImpl grid) throws VisADException {
        TupleType tt = null;
        try {
            if (grid instanceof FlatField) {
                tt = DataUtility.getRangeTupleType(grid);
            } else if (GridUtil.isTimeSequence(grid)) {
                Data d = grid.getSample(0);
                if (d instanceof FlatField) {
                    tt = DataUtility.getRangeTupleType((FlatField)d);
                } else if (d instanceof FieldImpl) {
                    if (GridUtil.isSequence((FieldImpl)d)) {
                        if ((d = ((FieldImpl)d).getSample(0)) instanceof Real) {
                            tt = new RealTupleType((RealType)((Real)d).getType());
                        } else if (d instanceof Tuple) {
                            tt = (TupleType)d.getType();
                        } else if (d instanceof FlatField) {
                            tt = DataUtility.getRangeTupleType((FlatField)d);
                        }
                    } else {
                        tt = DataUtility.getRangeTupleType((FieldImpl)d);
                    }
                }
            } else if (GridUtil.isSequence(grid)) {
                Data d = grid.getSample(0);
                if (d instanceof FlatField) {
                    tt = DataUtility.getRangeTupleType((FlatField)d);
                } else if (d instanceof Real) {
                    tt = new RealTupleType((RealType)((Real)d).getType());
                } else if (d instanceof Tuple) {
                    tt = (TupleType)d.getType();
                }
            }
            if (tt == null) {
                throw new VisADException("Can't handle data of type " + grid.getType());
            }
        }
        catch (RemoteException re) {
            throw new VisADException("problem getting param type " + re);
        }
        return tt;
    }

    public static FieldImpl getParam(FieldImpl grid, int index) throws VisADException {
        return GridUtil.getParam(grid, index, true);
    }

    public static FieldImpl getParam(FieldImpl grid, int index, boolean copy) throws VisADException {
        FieldImpl newField;
        block12: {
            newField = null;
            if (grid == null) {
                return newField;
            }
            TupleType tt = GridUtil.getParamType(grid);
            if (index > tt.getDimension()) {
                return null;
            }
            MathType newParam = tt.getComponent(index);
            try {
                Data step1 = null;
                FunctionType newType = null;
                if (GridUtil.isSequence(grid)) {
                    try {
                        step1 = grid.getSample(0);
                    }
                    catch (RemoteException re) {
                        throw new VisADException("problem setting param type " + re);
                    }
                    if (!GridUtil.isSequence((FieldImpl)step1)) {
                        Trace.call1("GridUtil.setParam:sequence");
                        RealTupleType domRT = ((FunctionType)grid.getType()).getDomain();
                        FunctionType ffRT = (FunctionType)((FunctionType)grid.getType()).getRange();
                        RealTupleType ffdomRT = ffRT.getDomain();
                        newType = new FunctionType(domRT, new FunctionType(ffdomRT, newParam));
                        Set timeDomain = ucar.visad.Util.getDomainSet(grid);
                        newField = new FieldImpl(newType, timeDomain);
                        for (int i = 0; i < timeDomain.getLength(); ++i) {
                            newField.setSample(i, (Data)((FlatField)grid.getSample(i, false)).extract(index, copy), false);
                        }
                        Trace.call2("GridUtil.setParam:sequence");
                    } else {
                        Trace.call1("GridUtil.setParam:indexsequence");
                        RealTupleType timedomRT = ((FunctionType)grid.getType()).getDomain();
                        RealTupleType indexdomRT = ((FunctionType)step1.getType()).getDomain();
                        FunctionType ffRT = (FunctionType)((FunctionType)step1.getType()).getRange();
                        RealTupleType ffdomRT = ffRT.getDomain();
                        FunctionType paramRange = new FunctionType(ffdomRT, newParam);
                        FunctionType indexRange = new FunctionType(indexdomRT, paramRange);
                        newType = new FunctionType(timedomRT, indexRange);
                        Set timeDomain = ucar.visad.Util.getDomainSet(grid);
                        newField = new FieldImpl(newType, timeDomain);
                        for (int i = 0; i < timeDomain.getLength(); ++i) {
                            FieldImpl indexField = (FieldImpl)grid.getSample(i, false);
                            Set indexSet = ucar.visad.Util.getDomainSet(indexField);
                            FieldImpl newIndexField = new FieldImpl(indexRange, indexSet);
                            for (int j = 0; j < indexSet.getLength(); ++j) {
                                newIndexField.setSample(j, (Data)((FlatField)indexField.getSample(j, false)).extract(index, copy), false);
                            }
                            newField.setSample(i, (Data)newIndexField);
                        }
                        Trace.call2("GridUtil.setParam:indexsequence");
                    }
                    break block12;
                }
                newField = (FieldImpl)((FlatField)grid).extract(index, copy);
            }
            catch (RemoteException re) {
                throw new VisADException("problem setting param type " + re);
            }
        }
        return newField;
    }

    public static FieldImpl setParamType(FieldImpl grid, String newName) throws VisADException {
        return GridUtil.setParamType(grid, newName, true);
    }

    public static FieldImpl setParamType(FieldImpl grid, String newName, boolean copy) throws VisADException {
        return GridUtil.setParamType(grid, new String[]{newName}, copy);
    }

    public static FieldImpl setParamType(FieldImpl grid, String[] newNames, boolean copy) throws VisADException {
        TupleType tt = GridUtil.getParamType(grid);
        RealType[] rts = tt.getRealComponents();
        if (rts.length != newNames.length) {
            throw new VisADException("number of names must match number of components");
        }
        RealType[] newTypes = new RealType[newNames.length];
        for (int i = 0; i < newNames.length; ++i) {
            newTypes[i] = DataUtil.makeRealType(newNames[i], rts[i].getDefaultUnit());
        }
        RealTupleType newParam = new RealTupleType(newTypes);
        return GridUtil.setParamType(grid, newParam, copy);
    }

    public static FieldImpl setParamType(FieldImpl grid, RealType newParam) throws VisADException {
        return GridUtil.setParamType(grid, newParam, true);
    }

    public static FieldImpl setParamType(FieldImpl grid, RealType newParam, boolean copy) throws VisADException {
        return GridUtil.setParamType(grid, new RealTupleType(newParam), copy);
    }

    public static FieldImpl setParamType(FieldImpl grid, TupleType newParam) throws VisADException {
        return GridUtil.setParamType(grid, newParam, true);
    }

    public static FieldImpl setParamType(FieldImpl grid, TupleType newParam, boolean copy) throws VisADException {
        FieldImpl newField;
        block11: {
            newField = null;
            if (grid == null) {
                return newField;
            }
            try {
                Data step1 = null;
                FunctionType newType = null;
                if (GridUtil.isSequence(grid)) {
                    try {
                        step1 = grid.getSample(0);
                    }
                    catch (RemoteException re) {
                        throw new VisADException("problem setting param type " + re);
                    }
                    if (!GridUtil.isSequence((FieldImpl)step1)) {
                        Trace.call1("GridUtil.setParamType:sequence");
                        RealTupleType domRT = ((FunctionType)grid.getType()).getDomain();
                        FunctionType ffRT = (FunctionType)((FunctionType)grid.getType()).getRange();
                        RealTupleType ffdomRT = ffRT.getDomain();
                        newType = new FunctionType(domRT, new FunctionType(ffdomRT, newParam));
                        Set timeDomain = ucar.visad.Util.getDomainSet(grid);
                        newField = new FieldImpl(newType, timeDomain);
                        for (int i = 0; i < timeDomain.getLength(); ++i) {
                            newField.setSample(i, (Data)((FieldImpl)ucar.visad.Util.clone(grid.getSample(i, false), newParam, true, copy, false)), false);
                        }
                        Trace.call2("GridUtil.setParamType:sequence");
                    } else {
                        Trace.call1("GridUtil.setParamType:indexsequence");
                        RealTupleType timedomRT = ((FunctionType)grid.getType()).getDomain();
                        RealTupleType indexdomRT = ((FunctionType)step1.getType()).getDomain();
                        FunctionType ffRT = (FunctionType)((FunctionType)step1.getType()).getRange();
                        RealTupleType ffdomRT = ffRT.getDomain();
                        FunctionType paramRange = new FunctionType(ffdomRT, newParam);
                        FunctionType indexRange = new FunctionType(indexdomRT, paramRange);
                        newType = new FunctionType(timedomRT, indexRange);
                        Set timeDomain = ucar.visad.Util.getDomainSet(grid);
                        newField = new FieldImpl(newType, timeDomain);
                        for (int i = 0; i < timeDomain.getLength(); ++i) {
                            FieldImpl indexField = (FieldImpl)grid.getSample(i, false);
                            Set indexSet = ucar.visad.Util.getDomainSet(indexField);
                            FieldImpl newIndexField = new FieldImpl(indexRange, indexSet);
                            for (int j = 0; j < indexSet.getLength(); ++j) {
                                newIndexField.setSample(j, (Data)((FieldImpl)ucar.visad.Util.clone(indexField.getSample(j, false), paramRange, true, copy, false)), false);
                            }
                            newField.setSample(i, (Data)newIndexField);
                        }
                        Trace.call2("GridUtil.setParamType:indexsequence");
                    }
                    break block11;
                }
                newField = (FieldImpl)ucar.visad.Util.clone(grid, newParam, true, copy, false);
            }
            catch (RemoteException re) {
                throw new VisADException("problem setting param type " + re);
            }
        }
        return newField;
    }

    public static FieldImpl extractParam(FieldImpl grid, ScalarType param) throws VisADException {
        try {
            FieldImpl newGrid = null;
            if (!MathType.findScalarType(grid.getType(), param)) {
                newGrid = GridUtil.setParamType(grid, param instanceof RealType ? new RealTupleType((RealType)param) : new TupleType(new MathType[]{param}));
            } else if (GridUtil.isSequence(grid)) {
                SampledSet s = (SampledSet)ucar.visad.Util.getDomainSet(grid);
                FunctionType newType = null;
                Data step1 = null;
                step1 = grid.getSample(0);
                if (!GridUtil.isSequence((FieldImpl)step1)) {
                    RealTupleType domRT = ((FunctionType)grid.getType()).getDomain();
                    FunctionType ffRT = (FunctionType)((FunctionType)grid.getType()).getRange();
                    MathType ffRange = ffRT.getRange();
                    if (ffRange instanceof RealType || ((TupleType)ffRange).getDimension() == 1) {
                        return grid;
                    }
                    TupleType ffrangeRT = (TupleType)ffRange;
                    int paramIndex = ffrangeRT.getIndex(param);
                    RealTupleType ffdomRT = ffRT.getDomain();
                    newType = new FunctionType(domRT, new FunctionType(ffdomRT, param));
                    newGrid = new FieldImpl(newType, s);
                    for (int i = 0; i < s.getLength(); ++i) {
                        newGrid.setSample(i, (Data)((FieldImpl)grid.getSample(i, false)).extract(paramIndex), false);
                    }
                } else {
                    RealTupleType timedomRT = ((FunctionType)grid.getType()).getDomain();
                    RealTupleType indexdomRT = ((FunctionType)step1.getType()).getDomain();
                    FunctionType ffRT = (FunctionType)((FunctionType)step1.getType()).getRange();
                    TupleType ffrangeRT = (TupleType)ffRT.getRange();
                    if (ffrangeRT.getDimension() == 1) {
                        return grid;
                    }
                    int paramIndex = ffrangeRT.getIndex(param);
                    RealTupleType ffdomRT = ffRT.getDomain();
                    FunctionType indexFIType = new FunctionType(indexdomRT, new FunctionType(ffdomRT, param));
                    newType = new FunctionType(timedomRT, indexFIType);
                    newGrid = new FieldImpl(newType, s);
                    for (int i = 0; i < s.getLength(); ++i) {
                        FieldImpl indexFI = (FieldImpl)grid.getSample(i, false);
                        SampledSet domSet = (SampledSet)ucar.visad.Util.getDomainSet(indexFI);
                        FieldImpl tempFI = new FieldImpl(indexFIType, domSet);
                        for (int j = 0; j < domSet.getLength(); ++j) {
                            tempFI.setSample(j, (Data)((FieldImpl)indexFI.getSample(j, false)).extract(paramIndex), false);
                        }
                        newGrid.setSample(i, (Data)tempFI, false);
                    }
                }
            } else {
                newGrid = (FieldImpl)grid.extract(param);
            }
            return newGrid;
        }
        catch (RemoteException re) {
            throw new VisADException("problem setting param type " + re);
        }
    }

    public FieldImpl extractParam(FieldImpl grid, MathType paramType) throws VisADException {
        FieldImpl extractedFI = null;
        try {
            if (!GridUtil.isSequence(grid)) {
                extractedFI = (FlatField)grid.extract(paramType);
            } else {
                Set sequenceDomain = ucar.visad.Util.getDomainSet(grid);
                for (int i = 0; i < sequenceDomain.getLength(); ++i) {
                    FlatField sample = (FlatField)grid.extract(paramType);
                    if (i == 0) {
                        FunctionType sampledType = new FunctionType(((SetType)sequenceDomain.getType()).getDomain(), sample.getType());
                        extractedFI = new FieldImpl(sampledType, sequenceDomain);
                    }
                    ((FieldImpl)extractedFI).setSample(i, (Data)sample, false);
                }
            }
        }
        catch (RemoteException re) {
            throw new VisADException("problem slicing remote field " + re);
        }
        return extractedFI;
    }

    private static SampledSet makeSliceFromLevel(GriddedSet spatialSet, Real level) throws VisADException {
        float gridLevel;
        boolean isRefType;
        Trace.call1("GridUtil.makeSliceFromLevel", " " + level.toValueString());
        if (spatialSet.getManifoldDimension() != 3) {
            throw new IllegalArgumentException("Can't slice a 2-D grid");
        }
        RealType type = (RealType)level.getType();
        RealTupleType spatialType = ((SetType)spatialSet.getType()).getDomain();
        RealTupleType spatialReferenceType = spatialSet.getCoordinateSystem() != null ? spatialSet.getCoordinateSystem().getReference() : null;
        RealType zType = GridUtil.getVerticalType(spatialSet);
        Unit zUnit = GridUtil.getVerticalUnit(spatialSet);
        if (type.equals(RealType.Generic)) {
            type = zType;
            level = new Real(zType, level.getValue(), zUnit);
        }
        RealType zRefType = spatialReferenceType != null ? (RealType)spatialReferenceType.getComponent(2) : null;
        boolean bl = isRefType = !type.equals(zType) && type.equalsExceptNameButUnits(zRefType);
        if (!type.equalsExceptNameButUnits(zType) && !isRefType) {
            throw new IllegalArgumentException("level is incompatible with vertical component of spatial domain");
        }
        Gridded3DSet samplingSet = null;
        if (!isRefType) {
            gridLevel = (float)level.getValue(spatialSet.getSetUnits()[2]);
        } else {
            CoordinateSystem cs = spatialSet.getCoordinateSystem();
            if (cs instanceof EmpiricalCoordinateSystem) {
                spatialSet = ((EmpiricalCoordinateSystem)cs).getReferenceSet();
                gridLevel = (float)level.getValue(zRefType.getDefaultUnit());
                isRefType = false;
            } else {
                float levVal = (float)level.getValue(zRefType.getDefaultUnit());
                float[][] gridSamples = spatialSet.getSamples(false);
                Object zeroCoords = new float[][]{{gridSamples[0][0]}, {gridSamples[1][0]}, {gridSamples[2][0]}};
                zeroCoords = spatialSet.getCoordinateSystem().toReference((float[][])zeroCoords);
                zeroCoords = spatialSet.getCoordinateSystem().fromReference(new float[][]{{zeroCoords[0][0]}, {zeroCoords[1][0]}, {levVal}});
                gridLevel = zeroCoords[2][0];
            }
            if (Float.isNaN(gridLevel)) {
                try {
                    spatialSet = (GriddedSet)ucar.visad.Util.convertDomain(spatialSet, spatialReferenceType, null);
                    isRefType = false;
                }
                catch (RemoteException re) {
                    throw new VisADException("Couldn't convert domain");
                }
            }
        }
        Trace.call1("GridUtil making indices", " Class=" + spatialSet.getClass().getName());
        int[] sizes = spatialSet.getLengths();
        int sizeX = sizes[0];
        int sizeY = sizes[1];
        int[] indices = new int[sizeX * sizeY];
        for (int j = 0; j < sizeY; ++j) {
            for (int i = 0; i < sizeX; ++i) {
                int elem;
                indices[elem] = elem = i + j * sizeX;
            }
        }
        Trace.call2("GridUtil making indices");
        float[][] coords2D = spatialSet.indexToValue(indices);
        Arrays.fill(coords2D[2], gridLevel);
        samplingSet = new Gridded3DSet(spatialSet.getType(), coords2D, sizeX, sizeY, spatialSet.getCoordinateSystem(), isRefType ? spatialSet.getCoordinateSystem().getCoordinateSystemUnits() : spatialSet.getSetUnits(), spatialSet.getSetErrors(), false);
        Trace.call2("GridUtil.makeSliceFromLevel");
        return samplingSet;
    }

    private static SampledSet makeSliceFromLatLonPoints(GriddedSet spatialSet, LatLonPoint start, LatLonPoint end) throws VisADException {
        ArrayList<LatLonPoint> points = new ArrayList<LatLonPoint>();
        points.add(start);
        points.add(end);
        return GridUtil.makeSliceFromLatLonPoints(spatialSet, points);
    }

    private static SampledSet makeSliceFromLatLonPoints(GriddedSet spatialSet, List<LatLonPoint> points) throws VisADException {
        float[][] allCoords;
        int lonIndex;
        int latIndex;
        boolean isLatLonDomain;
        boolean is3D = GridUtil.is3D(spatialSet);
        if (is3D && spatialSet.getManifoldDimension() != 3) {
            throw new IllegalArgumentException(" Domain must have same manifold size as dimension");
        }
        if (!GridUtil.isNavigated(spatialSet)) {
            throw new IllegalArgumentException("Domain is not georeferenced");
        }
        RealTupleType spatialType = ((SetType)spatialSet.getType()).getDomain();
        RealTupleType spatialReferenceType = spatialSet.getCoordinateSystem() != null ? spatialSet.getCoordinateSystem().getReference() : null;
        boolean bl = isLatLonDomain = spatialReferenceType == null || spatialType.getIndex(RealType.Latitude) != -1 && spatialType.getIndex(RealType.Longitude) != -1;
        if (isLatLonDomain) {
            latIndex = spatialType.getIndex(RealType.Latitude);
            lonIndex = spatialType.getIndex(RealType.Longitude);
        } else {
            latIndex = spatialReferenceType.getIndex(RealType.Latitude);
            lonIndex = spatialReferenceType.getIndex(RealType.Longitude);
        }
        int otherIndex = 3 - (latIndex + lonIndex);
        int numPoints = points.size();
        float[][] endpoints = new float[is3D ? 3 : 2][numPoints];
        float[][] domainCoords = spatialSet.getSamples(false);
        int pi = 0;
        for (LatLonPoint llp : points) {
            endpoints[latIndex][pi] = (float)llp.getLatitude().getValue(CommonUnit.degree);
            endpoints[lonIndex][pi] = (float)GridUtil.normalizeLongitude((SampledSet)spatialSet, llp.getLongitude().getValue(CommonUnit.degree));
            if (is3D) {
                endpoints[otherIndex][pi] = domainCoords[otherIndex][0];
            }
            ++pi;
        }
        float[][] savedEndpoints = Misc.cloneArray(endpoints);
        boolean compatibleUnits = false;
        Unit[] setUnits = spatialSet.getSetUnits();
        Unit[] refUnits = Unit.copyUnitsArray(setUnits);
        if (!isLatLonDomain) {
            CoordinateSystem cs = spatialSet.getCoordinateSystem();
            endpoints = cs.fromReference(endpoints);
            refUnits = cs.getReferenceUnits();
            compatibleUnits = Unit.canConvertArray(new Unit[]{setUnits[latIndex], setUnits[lonIndex]}, new Unit[]{refUnits[latIndex], refUnits[lonIndex]});
        } else {
            endpoints = Unit.convertTuple(endpoints, new Unit[]{CommonUnit.degree, CommonUnit.degree, CommonUnit.meter}, setUnits, false);
        }
        ArrayList<float[][]> coords = new ArrayList<float[][]>(numPoints - 1);
        int totalLocs = 0;
        int sizeX = spatialSet.getLengths()[lonIndex];
        int sizeY = spatialSet.getLengths()[latIndex];
        int sizeZ = is3D ? spatialSet.getLengths()[otherIndex] : 1;
        for (int p = 0; p < numPoints - 1; ++p) {
            int numLocs;
            LatLonPoint start = points.get(p);
            LatLonPoint end = points.get(p + 1);
            float firstx = endpoints[lonIndex][p];
            float lastx = endpoints[lonIndex][p + 1];
            float firsty = endpoints[latIndex][p];
            float lasty = endpoints[latIndex][p + 1];
            if (Float.isNaN(firstx) || Float.isNaN(lastx) || Float.isNaN(firsty) || Float.isNaN(lasty)) {
                if (!compatibleUnits) {
                    CoordinateSystem cs = spatialSet.getCoordinateSystem();
                    if (cs != null) {
                        if (cs instanceof EmpiricalCoordinateSystem) {
                            spatialSet = ((EmpiricalCoordinateSystem)cs).getReferenceSet();
                            spatialType = ((SetType)spatialSet.getType()).getDomain();
                            setUnits = spatialSet.getSetUnits();
                        } else {
                            try {
                                spatialSet = (GriddedSet)ucar.visad.Util.convertDomain(spatialSet, spatialReferenceType, null);
                                spatialType = ((SetType)spatialSet.getType()).getDomain();
                                setUnits = spatialSet.getSetUnits();
                            }
                            catch (RemoteException re) {
                                throw new VisADException("Couldn't convert domain");
                            }
                        }
                        isLatLonDomain = true;
                        domainCoords = spatialSet.getSamples(false);
                    } else {
                        throw new VisADException("unable to make slice");
                    }
                }
                savedEndpoints = Unit.convertTuple(savedEndpoints, new Unit[]{CommonUnit.degree, CommonUnit.degree, CommonUnit.meter}, refUnits, false);
                firstx = savedEndpoints[lonIndex][p];
                lastx = savedEndpoints[lonIndex][p + 1];
                firsty = savedEndpoints[latIndex][p];
                lasty = savedEndpoints[latIndex][p + 1];
            }
            if (!start.equals(end)) {
                float[] highs = spatialSet.getHi();
                float[] lows = spatialSet.getLow();
                float numPerX = (highs[lonIndex] - lows[lonIndex]) / (float)sizeX;
                float numPerY = (highs[latIndex] - lows[latIndex]) / (float)sizeY;
                int numXPoints = Math.round(Math.abs(firstx - lastx) / numPerX);
                int numYPoints = Math.round(Math.abs(firsty - lasty) / numPerY);
                numLocs = Math.max(1, Math.min(Math.max(numXPoints, numYPoints), sizeX));
            } else {
                numLocs = 1;
            }
            float[][] coords2D = new float[is3D ? 3 : 2][numLocs * sizeZ];
            for (int k = 0; k < sizeZ; ++k) {
                int zindex = k * sizeY * sizeX;
                float height = is3D ? domainCoords[otherIndex][zindex] : 0.0f;
                for (int i = 0; i < numLocs; ++i) {
                    float yval;
                    int newi = i + k * numLocs;
                    float frac = numLocs == 1 ? 1.0f : (float)i / (float)(numLocs - 1);
                    float xval = firstx + (lastx - firstx) * frac;
                    coords2D[lonIndex][newi] = xval = (float)GridUtil.normalizeLongitude((SampledSet)spatialSet, xval);
                    coords2D[latIndex][newi] = yval = firsty + (lasty - firsty) * frac;
                    if (!is3D) continue;
                    coords2D[otherIndex][newi] = height;
                }
            }
            coords.add(coords2D);
            totalLocs += numLocs;
        }
        Unit[] units = null;
        if (isLatLonDomain) {
            units = setUnits;
        } else {
            Unit[] unitArray;
            Unit[] csUnits = spatialSet.getCoordinateSystem().getCoordinateSystemUnits();
            if (is3D) {
                Unit[] unitArray2 = new Unit[3];
                unitArray2[0] = csUnits[0];
                unitArray2[1] = csUnits[1];
                unitArray = unitArray2;
                unitArray2[2] = setUnits[2];
            } else {
                Unit[] unitArray3 = new Unit[2];
                unitArray3[0] = csUnits[0];
                unitArray = unitArray3;
                unitArray3[1] = csUnits[1];
            }
            units = unitArray;
        }
        if (numPoints > 2) {
            allCoords = new float[is3D ? 3 : 2][(totalLocs -= numPoints - 2) * sizeZ];
            int pIndex = 0;
            for (int k = 0; k < sizeZ; ++k) {
                for (int c = 0; c < coords.size(); ++c) {
                    float[][] sectionCoords = (float[][])coords.get(c);
                    int numSectionPoints = sectionCoords[0].length / sizeZ;
                    for (int l = 0; l < numSectionPoints; ++l) {
                        if (l == 0 && c > 0) continue;
                        allCoords[0][pIndex] = sectionCoords[0][l + k * numSectionPoints];
                        allCoords[1][pIndex] = sectionCoords[1][l + k * numSectionPoints];
                        if (is3D) {
                            allCoords[2][pIndex] = sectionCoords[2][l + k * numSectionPoints];
                        }
                        ++pIndex;
                    }
                }
            }
        } else {
            allCoords = (float[][])coords.get(0);
        }
        GriddedSet samplingSet = !is3D ? new Gridded2DSet((MathType)spatialType, allCoords, totalLocs, spatialSet.getCoordinateSystem(), units, spatialSet.getSetErrors(), false) : (totalLocs > 1 ? new Gridded3DSet((MathType)spatialType, allCoords, totalLocs, sizeZ, spatialSet.getCoordinateSystem(), units, spatialSet.getSetErrors(), false) : new Gridded3DSet((MathType)spatialType, allCoords, sizeZ, spatialSet.getCoordinateSystem(), units, spatialSet.getSetErrors(), false));
        return samplingSet;
    }

    private static FieldImpl sampleAtPoint(FieldImpl grid, RealTuple point) throws VisADException {
        return GridUtil.sampleAtPoint(grid, point, 101);
    }

    private static FieldImpl sampleAtPoint(FieldImpl grid, RealTuple point, int samplingMode) throws VisADException {
        return GridUtil.sampleAtPoint(grid, point, samplingMode, 202);
    }

    private static FieldImpl sampleAtPoint(FieldImpl grid, RealTuple point, int samplingMode, int errorMode) throws VisADException {
        FieldImpl sampledFI = null;
        try {
            if (!GridUtil.isSequence(grid)) {
                Data value = grid.evaluate(point, samplingMode, errorMode);
                RealType index = RealType.getRealType("index");
                SingletonSet ss = new SingletonSet(new RealTuple(new Real[]{new Real(index, 0.0)}));
                sampledFI = new FieldImpl(new FunctionType(index, value.getType()), ss);
                sampledFI.setSample(0, value, false);
            } else {
                Set sequenceDomain = ucar.visad.Util.getDomainSet(grid);
                for (int i = 0; i < sequenceDomain.getLength(); ++i) {
                    Data sample = ((FlatField)grid.getSample(i)).evaluate(point, samplingMode, errorMode);
                    if (i == 0) {
                        FunctionType sampledType = new FunctionType(((SetType)sequenceDomain.getType()).getDomain(), sample.getType());
                        sampledFI = new FieldImpl(sampledType, sequenceDomain);
                    }
                    sampledFI.setSample(i, sample, false);
                }
            }
        }
        catch (RemoteException re) {
            throw new VisADException("problem sampling remote field " + re);
        }
        return sampledFI;
    }

    public static Real normalizeLongitude(SampledSet domain, Real lon) throws VisADException {
        double lonValue = GridUtil.normalizeLongitude(domain, lon.getValue(), lon.getUnit());
        return lon.cloneButValue(lonValue);
    }

    public static double normalizeLongitude(SampledSet domain, double lon) throws VisADException {
        return GridUtil.normalizeLongitude(domain, lon, null);
    }

    public static double normalizeLongitude(SampledSet domain, double lon, Unit lonUnit) throws VisADException {
        int lonindex = GridUtil.isLatLonOrder(domain) ? 1 : 0;
        int latindex = lonindex == 0 ? 1 : 0;
        RealType lonType = (RealType)((SetType)domain.getType()).getDomain().getComponent(lonindex);
        RealType latType = (RealType)((SetType)domain.getType()).getDomain().getComponent(latindex);
        if (!lonType.equalsExceptNameButUnits(RealType.Longitude) || !latType.equalsExceptNameButUnits(RealType.Latitude)) {
            return lon;
        }
        if (lonUnit == null) {
            lonUnit = domain.getSetUnits()[lonindex];
        }
        lon = (float)CommonUnit.degree.toThis(lon, lonUnit);
        float low = domain.getLow()[lonindex];
        low = (float)CommonUnit.degree.toThis(low, lonUnit);
        float hi = domain.getHi()[lonindex];
        hi = (float)CommonUnit.degree.toThis(hi, lonUnit);
        while ((float)lon < low && (float)lon < hi) {
            lon += 360.0;
        }
        while ((float)lon > hi && (float)lon > low) {
            lon -= 360.0;
        }
        return (float)lonUnit.toThis(lon, CommonUnit.degree);
    }

    private static MapProjection makeMapProjection(SampledSet domainSet) throws VisADException {
        boolean isLatLon = GridUtil.isLatLonOrder(domainSet);
        float[] lows = domainSet.getLow();
        float[] highs = domainSet.getHi();
        int latIndex = isLatLon ? 0 : 1;
        int lonIndex = 1 - latIndex;
        float x = lows[lonIndex];
        float y = lows[latIndex];
        float width = highs[lonIndex] - x;
        float height = highs[latIndex] - y;
        if (width == 0.0f && height == 0.0f) {
            x -= 0.5f;
            width = 1.0f;
            y -= 0.5f;
            height = 1.0f;
        }
        Unit[] setUnits = domainSet.getSetUnits();
        Object xy = new float[][]{{x, width}, {y, height}};
        xy = Unit.convertTuple(xy, new Unit[]{setUnits[lonIndex], setUnits[latIndex]}, new Unit[]{CommonUnit.degree, CommonUnit.degree}, false);
        return new TrivialMapProjection(RealTupleType.SpatialEarth2DTuple, new Rectangle2D.Float(xy[0][0], xy[1][0], xy[0][1], xy[1][1]));
    }

    public static MapProjection makeRadarMapProjection(CoordinateSystem radarCS) throws VisADException {
        if (!(radarCS instanceof Radar2DCoordinateSystem) && !(radarCS instanceof Radar3DCoordinateSystem)) {
            throw new RuntimeException("not a radar cs");
        }
        float[] lla = radarCS instanceof Radar2DCoordinateSystem ? ((Radar2DCoordinateSystem)radarCS).getCenterPoint() : ((Radar3DCoordinateSystem)radarCS).getCenterPoint();
        return new RadarMapProjection(lla[0], lla[1]);
    }

    public static FieldImpl resampleGrid(FieldImpl grid, SampledSet subDomain) throws VisADException {
        return GridUtil.resampleGrid(grid, subDomain, 101, 202);
    }

    public static FieldImpl resampleGrid(FieldImpl grid, SampledSet subDomain, int samplingMode) throws VisADException {
        return GridUtil.resampleGrid(grid, subDomain, samplingMode, 202);
    }

    public static RealTuple getCenterPoint(FieldImpl grid) throws VisADException {
        return GridUtil.getCenterPoint(GridUtil.getSpatialDomain(grid));
    }

    public static RealTuple getCenterPoint(SampledSet spatialDomain) throws VisADException {
        float[] highs = spatialDomain.getHi();
        float[] lows = spatialDomain.getLow();
        float[][] values = new float[highs.length][1];
        for (int i = 0; i < highs.length; ++i) {
            values[i][0] = lows[i] + (highs[i] - lows[i]) / 2.0f;
        }
        int index = 0;
        if (GridUtil.isSinglePointDomain(spatialDomain)) {
            index = spatialDomain.getLength() / 2;
        } else {
            int[] indices = spatialDomain.valueToIndex(values);
            index = indices[0];
        }
        RealTuple point = null;
        try {
            point = DataUtility.getSample(spatialDomain, index);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return point;
    }

    public static LatLonPoint getCenterLatLonPoint(FieldImpl grid) throws VisADException {
        return GridUtil.getCenterLatLonPoint(GridUtil.getSpatialDomain(grid));
    }

    public static LatLonPoint getCenterLatLonPoint(SampledSet spatialDomain) throws VisADException {
        RealTuple nativeCoords = GridUtil.getCenterPoint(spatialDomain);
        LatLonTuple latlon = null;
        try {
            SingletonSet ss = new SingletonSet(nativeCoords);
            if (GridUtil.isNavigated(ss)) {
                int latIndex = GridUtil.isLatLonOrder(ss) ? 0 : 1;
                int lonIndex = 1 - latIndex;
                RealTuple latLonCoords = nativeCoords;
                if (ss.getCoordinateSystem() != null) {
                    SampledSet latLonSet = ucar.visad.Util.convertDomain(ss, ss.getCoordinateSystem().getReference(), null);
                    latLonCoords = DataUtility.getSample(latLonSet, 0);
                }
                latlon = new LatLonTuple((Real)latLonCoords.getComponent(latIndex), (Real)latLonCoords.getComponent(lonIndex));
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return latlon;
    }

    public static FieldImpl resampleGrid(FieldImpl grid, SampledSet subDomain, int samplingMode, int errorMode) throws VisADException {
        long t1 = System.currentTimeMillis();
        FieldImpl result = GridUtil.resampleGridInner(grid, subDomain, samplingMode, errorMode);
        long t2 = System.currentTimeMillis();
        return result;
    }

    private static FieldImpl resampleGridInner(FieldImpl grid, SampledSet subDomain, int samplingMode, int errorMode) throws VisADException {
        Trace.call1("GridUtil.resampleGrid");
        SampledSet spatialDomain = GridUtil.getSpatialDomain(grid);
        if (spatialDomain.getDimension() != subDomain.getDimension() && spatialDomain.getManifoldDimension() != subDomain.getManifoldDimension()) {
            throw new IllegalArgumentException("resampleGrid: subDomain and grid dimensions are incompatible");
        }
        FieldImpl sampledFI = null;
        try {
            if (GridUtil.isSinglePointDomain(grid)) {
                SampledSet set = GridUtil.getSpatialDomain(grid);
                if (set instanceof SingletonSet) {
                    return grid;
                }
                float[][] domainVals = set.getSamples(true);
                float[][] sliceVals = subDomain.getSamples(true);
                if (subDomain.getCoordinateSystem() != null) {
                    CoordinateSystem cs = subDomain.getCoordinateSystem();
                    sliceVals = cs.fromReference(sliceVals);
                }
                float[] verticalLevels = sliceVals[2];
                int index = 0;
                if (verticalLevels.length != 1) {
                    return grid;
                }
                int[] indices = QuickSort.sort(domainVals[2]);
                index = Math.abs(Arrays.binarySearch(domainVals[2], verticalLevels[0]));
                if (index >= domainVals[2].length) {
                    index = domainVals[2].length - 1;
                }
                index = indices[index];
                if (GridUtil.getTimeSet(grid) == null) {
                    FunctionType ffType = (FunctionType)grid.getType();
                    sampledFI = new FlatField(ffType, subDomain);
                    sampledFI.setSample(0, grid.getSample(index), false);
                } else {
                    Set timeSet = GridUtil.getTimeSet(grid);
                    sampledFI = new FieldImpl((FunctionType)grid.getType(), timeSet);
                    FunctionType subType = (FunctionType)grid.getSample(0).getType();
                    for (int i = 0; i < timeSet.getLength(); ++i) {
                        FlatField subField = (FlatField)grid.getSample(i);
                        if (i == 0) {
                            subType = (FunctionType)subField.getType();
                        }
                        FlatField ff = new FlatField(subType, subDomain);
                        ff.setSample(0, subField.getSample(index));
                        sampledFI.setSample(i, (Data)ff, false);
                    }
                }
                return sampledFI;
            }
            if (!GridUtil.isSequence(grid)) {
                sampledFI = (FlatField)grid.resample(subDomain, samplingMode, errorMode);
            } else {
                Set sequenceDomain = ucar.visad.Util.getDomainSet(grid);
                Trace.call1("GridUtil.sampleLoop", " Length: " + sequenceDomain.getLength());
                for (int i = 0; i < sequenceDomain.getLength(); ++i) {
                    Trace.call1("GridUtil getSample");
                    FieldImpl subField = (FieldImpl)grid.getSample(i, false);
                    Trace.call2("GridUtil getSample");
                    FieldImpl sampledField = null;
                    if (!GridUtil.isSequence(subField)) {
                        Trace.call1("GridUtil resample", " Length=" + subField.getLength());
                        sampledField = (FieldImpl)subField.resample(subDomain, samplingMode, errorMode);
                        Trace.call2("GridUtil resample");
                    } else {
                        Set innerSequenceDomain = subField.getDomainSet();
                        Trace.call1("GridUtil resample inner sequence", " Length= " + innerSequenceDomain.getLength());
                        for (int j = 0; j < innerSequenceDomain.getLength(); ++j) {
                            FlatField innerSampledField;
                            FlatField innerSubField = (FlatField)subField.getSample(j, false);
                            if (innerSubField == null || (innerSampledField = (FlatField)innerSubField.resample(subDomain, samplingMode, errorMode)) == null) continue;
                            if (sampledField == null) {
                                FunctionType innerType = new FunctionType(DataUtility.getDomainType(innerSequenceDomain), innerSampledField.getType());
                                sampledField = new FieldImpl(innerType, innerSequenceDomain);
                            }
                            sampledField.setSample(j, (Data)innerSampledField, false);
                        }
                        Trace.call2("GridUtil resample inner sequence");
                    }
                    if (sampledField != null && sampledFI == null) {
                        FunctionType sampledType = new FunctionType(DataUtility.getDomainType(sequenceDomain), sampledField.getType());
                        sampledFI = new FieldImpl(sampledType, sequenceDomain);
                    }
                    Trace.call1("GridUtil setSample");
                    if (sampledField != null) {
                        sampledFI.setSample(i, (Data)sampledField, false);
                    }
                    Trace.call2("GridUtil setSample");
                }
                Trace.call2("GridUtil.sampleLoop");
            }
        }
        catch (RemoteException re) {
            throw new VisADException("problem resampling remote field " + re);
        }
        Trace.call2("GridUtil.resampleGrid");
        return sampledFI;
    }

    private static FieldImpl resample2DManifold(FieldImpl grid, SampledSet subDomain, int skipx, int skipy) throws VisADException {
        SampledSet spatialDomain = GridUtil.getSpatialDomain(grid);
        if (spatialDomain.getDimension() != subDomain.getDimension() && spatialDomain.getManifoldDimension() != subDomain.getManifoldDimension()) {
            throw new IllegalArgumentException("resampleGrid: subDomain and grid dimensions are incompatible");
        }
        FieldImpl sampledFI = null;
        try {
            if (!GridUtil.isSequence(grid)) {
                sampledFI = new FlatField((FunctionType)grid.getType(), subDomain);
                ((FieldImpl)sampledFI).setSamples(GridUtil.getSubValues(GridUtil.getSpatialDomain(grid), grid.getFloats(), skipx, skipy));
            } else {
                Set sequenceDomain = ucar.visad.Util.getDomainSet(grid);
                SampledSet ss = GridUtil.getSpatialDomain(grid);
                FieldImpl sampledField = null;
                for (int i = 0; i < sequenceDomain.getLength(); ++i) {
                    FieldImpl sample = (FieldImpl)grid.getSample(i);
                    if (sample == null) continue;
                    if (!GridUtil.isSequence(sample)) {
                        sampledField = new FlatField((FunctionType)sample.getType(), subDomain);
                        sampledField.setSamples(GridUtil.getSubValues(ss, sample.getFloats(), skipx, skipy));
                    } else {
                        Set ensDomain = sample.getDomainSet();
                        sampledField = new FieldImpl((FunctionType)sample.getType(), ensDomain);
                        for (int j = 0; j < ensDomain.getLength(); ++j) {
                            FlatField innerField = (FlatField)sample.getSample(j, false);
                            if (innerField == null) continue;
                            FlatField sampledFF = new FlatField((FunctionType)innerField.getType(), subDomain);
                            sampledFF.setSamples(GridUtil.getSubValues(ss, innerField.getFloats(), skipx, skipy));
                            sampledField.setSample(j, (Data)sampledFF);
                        }
                    }
                    if (sampledField != null && sampledFI == null) {
                        FunctionType sampledType = new FunctionType(((SetType)sequenceDomain.getType()).getDomain(), sampledField.getType());
                        sampledFI = new FieldImpl(sampledType, sequenceDomain);
                    }
                    if (sampledField == null) continue;
                    ((FieldImpl)sampledFI).setSample(i, (Data)sampledField, false);
                }
            }
        }
        catch (RemoteException re) {
            throw new VisADException("problem resampling remote field " + re);
        }
        return sampledFI;
    }

    private static float[][] getSubValues(SampledSet domainSet, float[][] values, int skipx, int skipy) throws VisADException {
        int sizeX = ((GriddedSet)domainSet).getLength(0);
        int sizeY = ((GriddedSet)domainSet).getLength(1);
        float[][] subSamples = new float[values.length][(1 + (sizeX - 1) / skipx) * (1 + (sizeY - 1) / skipy)];
        for (int m = 0; m < values.length; ++m) {
            int l = 0;
            for (int j = 0; j < sizeY; j += skipy) {
                for (int i = 0; i < sizeX; i += skipx) {
                    int elem = i + j * sizeX;
                    subSamples[m][l] = values[m][elem];
                    ++l;
                }
            }
        }
        return subSamples;
    }

    public static Real getLevel(FieldImpl grid, Real altitude) throws VisADException {
        if (altitude == null || grid == null) {
            throw new IllegalArgumentException("GridUtil.getLevel(): grid and level must not be null");
        }
        if (!GridUtil.is3D(grid)) {
            throw new IllegalArgumentException("GridUtil.getLevel(): Grid must be 3D");
        }
        if (!Unit.canConvert(altitude.getUnit(), CommonUnit.meter)) {
            throw new IllegalArgumentException("GridUtil.getLevel(): alitude units must be convertible with meters");
        }
        double levVal = Double.NaN;
        SampledSet domainSet = GridUtil.getSpatialDomain(grid);
        RealType zType = GridUtil.getVerticalType(domainSet);
        Unit zUnit = GridUtil.getVerticalUnit(domainSet);
        if (Unit.canConvert(zUnit, altitude.getUnit())) {
            levVal = altitude.getValue(zUnit);
        } else {
            CoordinateSystem cs = domainSet.getCoordinateSystem();
            if (cs != null) {
                float[][] xyz = cs.fromReference(new float[][]{{Float.NaN}, {Float.NaN}, {(float)altitude.getValue(CommonUnit.meter)}});
                levVal = zUnit.toThis(xyz[2][0], cs.getCoordinateSystemUnits()[2]);
            } else {
                throw new VisADException("Can't convert to a level");
            }
        }
        return new Real(zType, levVal, zUnit);
    }

    public static Real getAltitude(FieldImpl grid, Real level) throws VisADException {
        if (level == null || grid == null) {
            throw new IllegalArgumentException("GridUtil.getAltitude(): grid and level must not be null");
        }
        if (!GridUtil.is3D(grid)) {
            throw new IllegalArgumentException("GridUtil.getAltitude(): Grid must be 3D");
        }
        double altVal = Double.NaN;
        if (Unit.canConvert(level.getUnit(), CommonUnit.meter)) {
            altVal = level.getValue(CommonUnit.meter);
        } else {
            SampledSet domainSet = GridUtil.getSpatialDomain(grid);
            Unit zUnit = GridUtil.getVerticalUnit(domainSet);
            if (!Unit.canConvert(zUnit, level.getUnit())) {
                throw new VisADException("level units not compatible with grid units");
            }
            CoordinateSystem domainCS = domainSet.getCoordinateSystem();
            if (domainCS != null) {
                float[][] samples = domainSet.getSamples(false);
                Unit[] csUnits = domainCS.getCoordinateSystemUnits();
                float[][] latlonalt = domainCS.toReference(new float[][]{{samples[0][0]}, {samples[1][0]}, {(float)level.getValue(csUnits[2])}});
                altVal = latlonalt[2][0];
            }
        }
        return new Real(RealType.Altitude, altVal);
    }

    public static Real getAltitude(SampledSet domainSet, Real level) throws VisADException {
        if (level == null || domainSet == null) {
            throw new IllegalArgumentException("GridUtil.getAltitude(): domainSet and level must not be null");
        }
        if (!GridUtil.is3D(domainSet)) {
            throw new IllegalArgumentException("GridUtil.getAltitude(): Grid must be 3D");
        }
        double altVal = Double.NaN;
        if (Unit.canConvert(level.getUnit(), CommonUnit.meter)) {
            altVal = level.getValue(CommonUnit.meter);
        } else {
            Unit zUnit = GridUtil.getVerticalUnit(domainSet);
            if (!Unit.canConvert(zUnit, level.getUnit())) {
                throw new VisADException("level units not compatible with grid units");
            }
            CoordinateSystem domainCS = domainSet.getCoordinateSystem();
            if (domainCS != null) {
                float[][] samples = domainSet.getSamples(false);
                Unit[] csUnits = domainCS.getCoordinateSystemUnits();
                float[][] latlonalt = domainCS.toReference(new float[][]{{samples[0][0]}, {samples[1][0]}, {(float)level.getValue(csUnits[2])}});
                altVal = latlonalt[2][0];
            }
        }
        return new Real(RealType.Altitude, altVal);
    }

    public static RealType getVerticalType(FieldImpl grid) throws VisADException {
        return GridUtil.getVerticalType(GridUtil.getSpatialDomain(grid));
    }

    public static RealType getVerticalType(SampledSet domainSet) throws VisADException {
        if (!GridUtil.is3D(domainSet)) {
            throw new IllegalArgumentException("GridUtil.getVerticalType(): Not a 3D domain");
        }
        return (RealType)((SetType)domainSet.getType()).getDomain().getComponent(2);
    }

    public static Unit getVerticalUnit(FieldImpl grid) throws VisADException {
        return GridUtil.getVerticalUnit(GridUtil.getSpatialDomain(grid));
    }

    public static Unit getVerticalUnit(SampledSet domainSet) throws VisADException {
        if (!GridUtil.is3D(domainSet)) {
            throw new IllegalArgumentException("GridUtil.getVerticalUnit(): Not a 3D grid");
        }
        return domainSet.getSetUnits()[2];
    }

    public static boolean canSliceAtLevel(FieldImpl grid, Real level) throws VisADException {
        return GridUtil.canSliceAtLevel(GridUtil.getSpatialDomain(grid), level);
    }

    public static boolean canSliceAtLevel(SampledSet spatialSet, Real level) throws VisADException {
        Trace.call1("GridUtil.canSliceAtLevel");
        if (spatialSet == null || level == null) {
            return false;
        }
        if (spatialSet.getManifoldDimension() != 3) {
            return false;
        }
        RealType type = (RealType)level.getType();
        if (type.equals(RealType.Generic)) {
            return true;
        }
        RealTupleType spatialType = ((SetType)spatialSet.getType()).getDomain();
        RealTupleType spatialReferenceType = spatialSet.getCoordinateSystem() != null ? spatialSet.getCoordinateSystem().getReference() : null;
        RealType zType = GridUtil.getVerticalType(spatialSet);
        Unit zUnit = GridUtil.getVerticalUnit(spatialSet);
        RealType zRefType = spatialReferenceType != null ? (RealType)spatialReferenceType.getComponent(2) : null;
        boolean isRefType = type.equalsExceptNameButUnits(zRefType);
        return type.equalsExceptNameButUnits(zType) || isRefType;
    }

    public static Range[] fieldMinMax(FlatField field) throws VisADException, RemoteException {
        if (field instanceof CachedFlatField) {
            return GridUtil.makeRanges(((CachedFlatField)field).getRanges());
        }
        float[][] allValues = field.getFloats(false);
        Range[] result = new Range[allValues.length];
        for (int rangeIdx = 0; rangeIdx < allValues.length; ++rangeIdx) {
            float pMin = Float.POSITIVE_INFINITY;
            float pMax = Float.NEGATIVE_INFINITY;
            for (float value : allValues[rangeIdx]) {
                if (pMax < value) {
                    pMax = value;
                }
                if (!(pMin > value)) continue;
                pMin = value;
            }
            result[rangeIdx] = new Range(pMin, pMax);
        }
        return result;
    }

    public static Range makeRange(DataRange range) {
        if (range == null) {
            return null;
        }
        return new Range(range.getMin(), range.getMax());
    }

    public static Range[] makeRanges(DataRange[] range) {
        if (range == null) {
            return null;
        }
        Range[] r = new Range[range.length];
        for (int i = 0; i < range.length; ++i) {
            r[i] = GridUtil.makeRange(range[i]);
        }
        return r;
    }

    public static DataRange makeDataRange(Range range) {
        if (range == null) {
            return null;
        }
        return new DataRange(range.getMin(), range.getMax());
    }

    public static DataRange[] makeDataRanges(Range[] range) {
        if (range == null) {
            return null;
        }
        DataRange[] r = new DataRange[range.length];
        for (int i = 0; i < range.length; ++i) {
            r[i] = GridUtil.makeDataRange(range[i]);
        }
        return r;
    }

    public static Range[] getMinMax(FieldImpl fieldImpl) throws VisADException, RemoteException {
        Range[] result = null;
        if (fieldImpl instanceof FlatField) {
            int i;
            Range[] tmp = GridUtil.fieldMinMax((FlatField)fieldImpl);
            if (result == null) {
                result = new Range[tmp.length];
                for (i = 0; i < result.length; ++i) {
                    result[i] = new Range(Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY);
                }
            }
            for (i = 0; i < result.length; ++i) {
                result[i].min = Math.min(result[i].min, tmp[i].min);
                result[i].max = Math.max(result[i].max, tmp[i].max);
            }
        } else {
            int numTimes = ucar.visad.Util.getDomainSet(fieldImpl).getLength();
            for (int nn = 0; nn < numTimes; ++nn) {
                int i;
                FlatField field = null;
                Data data = null;
                if (fieldImpl.getDomainDimension() == 1) {
                    data = fieldImpl.getSample(nn);
                    if (data instanceof FlatField) {
                        field = (FlatField)data;
                    } else if (data instanceof FieldImpl) {
                        field = (FlatField)((FieldImpl)data).getSample(0);
                    }
                }
                if (field == null) continue;
                Range[] tmp = GridUtil.fieldMinMax(field);
                if (result == null) {
                    result = new Range[tmp.length];
                    for (i = 0; i < result.length; ++i) {
                        result[i] = new Range(Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY);
                    }
                }
                for (i = 0; i < result.length; ++i) {
                    result[i].min = Math.min(result[i].min, tmp[i].min);
                    result[i].max = Math.max(result[i].max, tmp[i].max);
                }
            }
        }
        return result;
    }

    public static String printModes(int samplingMode, int errorMode) {
        StringBuffer buf = new StringBuffer("sampling: ");
        switch (samplingMode) {
            case 100: {
                buf.append("Nearest Neighbor");
                break;
            }
            case 101: {
                buf.append("Weighted Average");
                break;
            }
        }
        buf.append(" error: ");
        switch (errorMode) {
            case 200: {
                buf.append("Independent");
                break;
            }
            case 201: {
                buf.append("Dependent");
                break;
            }
            case 202: {
                buf.append("No Errors");
                break;
            }
        }
        return buf.toString();
    }

    public static FieldImpl getGridAsPointObs(FieldImpl grid) throws VisADException {
        if (grid == null) {
            return null;
        }
        RealType index = RealType.getRealType("index");
        FieldImpl retField = null;
        try {
            if (GridUtil.isTimeSequence(grid)) {
                SampledSet timeSet = (SampledSet)GridUtil.getTimeSet(grid);
                FunctionType retFieldType = null;
                double[][] times = timeSet.getDoubles(false);
                Unit timeUnit = timeSet.getSetUnits()[0];
                if (!timeUnit.equals(CommonUnit.secondsSinceTheEpoch)) {
                    Unit.convertTuple(times, timeSet.getSetUnits(), new Unit[]{CommonUnit.secondsSinceTheEpoch}, true);
                }
                Calendar cal = null;
                if (timeSet instanceof CalendarDateTimeSet) {
                    cal = ((CalendarDateTimeSet)timeSet).getCalendar();
                }
                for (int i = 0; i < timeSet.getLength(); ++i) {
                    CalendarDateTime dt = new CalendarDateTime(times[0][i], cal);
                    FieldImpl ff = GridUtil.makePointObs((FlatField)grid.getSample(i), dt);
                    if (ff == null) continue;
                    if (retFieldType == null) {
                        retFieldType = new FunctionType(((SetType)timeSet.getType()).getDomain(), ff.getType());
                        retField = new FieldImpl(retFieldType, timeSet);
                    }
                    retField.setSample(i, (Data)ff, false);
                }
            } else {
                retField = GridUtil.makePointObs((FlatField)grid, new DateTime(Double.NaN));
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return retField;
    }

    private static FieldImpl makePointObs(FlatField timeStep, DateTime dt) throws VisADException, RemoteException {
        if (timeStep == null) {
            return null;
        }
        SampledSet domain = GridUtil.getSpatialDomain(timeStep);
        int numPoints = domain.getLength();
        Integer1DSet points = new Integer1DSet((MathType)RealType.getRealType("index"), numPoints);
        TupleType tt = GridUtil.getParamType(timeStep);
        TupleType rangeType = new TupleType(new MathType[]{RealTupleType.LatitudeLongitudeAltitude, RealType.Time, tt});
        FieldImpl ff = new FieldImpl(new FunctionType(((SetType)points.getType()).getDomain(), rangeType), points);
        float[][] samples = timeStep.getFloats(false);
        float[][] geoVals = GridUtil.getEarthLocationPoints((GriddedSet)domain);
        boolean isLatLon = GridUtil.isLatLonOrder(domain);
        int latIndex = isLatLon ? 0 : 1;
        int lonIndex = isLatLon ? 1 : 0;
        boolean haveAlt = geoVals.length > 2;
        for (int i = 0; i < numPoints; ++i) {
            float alt;
            float lat = geoVals[latIndex][i];
            float lon = geoVals[lonIndex][i];
            float f = alt = haveAlt ? geoVals[2][i] : 0.0f;
            if (lat != lat || lon != lon) continue;
            if (alt != alt) {
                alt = 0.0f;
            }
            EarthLocationLite el = new EarthLocationLite(lat, lon, alt);
            PointObTuple pot = new PointObTuple(el, dt, timeStep.getSample(i), rangeType);
            ff.setSample(i, pot, false, false);
        }
        return ff;
    }

    public static float[][] getEarthLocationPoints(GriddedSet domain) throws VisADException {
        CoordinateSystem cs = domain.getCoordinateSystem();
        if (cs == null) {
            return domain.getSamples();
        }
        RealTupleType refType = cs.getReference();
        Unit[] refUnits = cs.getReferenceUnits();
        float[][] points = CoordinateSystem.transformCoordinates(refType, null, refUnits, null, ((SetType)domain.getType()).getDomain(), cs, domain.getSetUnits(), domain.getSetErrors(), domain.getSamples(), false);
        return points;
    }

    public static int[][] findContainedIndices(GriddedSet domain, UnionSet map) throws VisADException {
        return GridUtil.findContainedIndices(GridUtil.getLatLon(domain), map);
    }

    public static int[][] findContainedIndices(float[][] latlon, UnionSet map) throws VisADException {
        long t1 = System.currentTimeMillis();
        int[][] indices = GridUtil.findContainedIndices(latlon, map, true);
        long t2 = System.currentTimeMillis();
        return indices;
    }

    public static int[][] findNotContainedIndices(GriddedSet domain, UnionSet map) throws VisADException {
        return GridUtil.findNotContainedIndices(GridUtil.getLatLon(domain), map);
    }

    public static int[][] findNotContainedIndices(float[][] latlon, UnionSet map) throws VisADException {
        long t1 = System.currentTimeMillis();
        int[][] indices = GridUtil.findContainedIndices(latlon, map, false);
        long t2 = System.currentTimeMillis();
        return indices;
    }

    public static float[][][] getLatLons(GriddedSet domain, int[][] indices) throws VisADException {
        return GridUtil.getLatLons(GridUtil.getLatLon(domain), indices);
    }

    public static float[][][] getLatLons(float[][] latlons, int[][] indices) throws VisADException {
        float[][][] result = new float[indices.length][2][];
        for (int polygonIdx = 0; polygonIdx < indices.length; ++polygonIdx) {
            result[polygonIdx][0] = new float[indices[polygonIdx].length];
            result[polygonIdx][1] = new float[indices[polygonIdx].length];
            for (int j = 0; j < indices[polygonIdx].length; ++j) {
                result[polygonIdx][0][j] = latlons[0][indices[polygonIdx][j]];
                result[polygonIdx][1][j] = latlons[1][indices[polygonIdx][j]];
            }
        }
        return result;
    }

    public static float[][][] findContainedLatLons(GriddedSet domain, UnionSet maps) throws VisADException {
        return GridUtil.findContainedLatLons(GridUtil.getLatLon(domain), maps);
    }

    public static float[][][] findContainedLatLons(float[][] latlons, UnionSet maps) throws VisADException {
        int[][] indices = GridUtil.findContainedIndices(latlons, maps);
        return GridUtil.getLatLons(latlons, indices);
    }

    private static void collectGriddedSets(UnionSet map, List<Gridded2DSet> allSets) throws VisADException {
        SampledSet[] sets = map.getSets();
        for (int j = 0; j < sets.length; ++j) {
            if (sets[j] instanceof UnionSet) {
                GridUtil.collectGriddedSets((UnionSet)sets[j], allSets);
                continue;
            }
            if (!(sets[j] instanceof Gridded2DSet)) continue;
            allSets.add((Gridded2DSet)sets[j]);
        }
    }

    private static int[][] findContainedIndices(float[][] latlon, UnionSet map, boolean inside) throws VisADException {
        int numPoints = latlon[0].length;
        if (map == null) {
            int[][] indices = new int[1][numPoints];
            for (int i = 0; i < numPoints; ++i) {
                indices[0][i] = i;
            }
            return indices;
        }
        ArrayList<Gridded2DSet> allSets = new ArrayList<Gridded2DSet>();
        GridUtil.collectGriddedSets(map, allSets);
        long t1 = System.currentTimeMillis();
        int numPolygons = allSets.size();
        ArrayList<float[][]> pts = new ArrayList<float[][]>();
        List[] indexLists = new List[numPolygons];
        float[] lonLow = new float[numPolygons];
        float[] lonHi = new float[numPolygons];
        float[] latLow = new float[numPolygons];
        float[] latHi = new float[numPolygons];
        boolean latLonOrder = GridUtil.isLatLonOrder(map);
        for (int polygonIdx = 0; polygonIdx < numPolygons; ++polygonIdx) {
            Gridded2DSet g = (Gridded2DSet)allSets.get(polygonIdx);
            float[] low = g.getLow();
            float[] hi = g.getHi();
            lonLow[polygonIdx] = (float)GeoUtils.normalizeLongitude(latLonOrder ? low[1] : low[0]);
            latLow[polygonIdx] = latLonOrder ? low[0] : low[1];
            lonHi[polygonIdx] = (float)GeoUtils.normalizeLongitude(latLonOrder ? hi[1] : hi[0]);
            latHi[polygonIdx] = latLonOrder ? hi[0] : hi[1];
            float[][] sample = g.getSamples(false);
            pts.add(sample);
        }
        int ptCnt = 0;
        block2: for (int i = 0; i < numPoints; ++i) {
            float lat = latlon[0][i];
            float lon = latlon[1][i];
            if (lon != lon || lat != lat) continue;
            for (int mapIdx = 0; mapIdx < numPolygons; ++mapIdx) {
                boolean ok;
                boolean pointInside2;
                if (inside ? lon < lonLow[mapIdx] || lon > lonHi[mapIdx] || lat < latLow[mapIdx] || lat > latHi[mapIdx] : lon >= lonLow[mapIdx] && lon <= lonHi[mapIdx] && lat >= latLow[mapIdx] && lat <= latHi[mapIdx]) continue;
                ++ptCnt;
                boolean pointInside = pointInside2 = DataUtil.pointInside((float[][])pts.get(mapIdx), latLonOrder ? lat : lon, latLonOrder ? lon : lat);
                boolean bl = inside ? pointInside : (ok = !pointInside);
                if (!ok) continue;
                if (indexLists[mapIdx] == null) {
                    indexLists[mapIdx] = new ArrayList();
                }
                indexLists[mapIdx].add(new Integer(i));
                continue block2;
            }
        }
        int[][] indices = new int[numPolygons][];
        for (int mapIdx = 0; mapIdx < indexLists.length; ++mapIdx) {
            if (indexLists[mapIdx] == null) {
                indices[mapIdx] = new int[0];
                continue;
            }
            indices[mapIdx] = new int[indexLists[mapIdx].size()];
            for (int ptIdx = 0; ptIdx < indexLists[mapIdx].size(); ++ptIdx) {
                indices[mapIdx][ptIdx] = (Integer)indexLists[mapIdx].get(ptIdx);
            }
        }
        long t2 = System.currentTimeMillis();
        return indices;
    }

    public static int[][] findIndicesInsideRange(float[][] values, float min, float max) throws VisADException {
        return GridUtil.findIndicesInRange(values, min, max, true);
    }

    public static int[][] findIndicesOutsideRange(float[][] values, float min, float max) throws VisADException {
        return GridUtil.findIndicesInRange(values, min, max, false);
    }

    private static int[][] findIndicesInRange(float[][] values, float min, float max, boolean inside) throws VisADException {
        int numPoints = values[0].length;
        int cnt = 0;
        int[] indices = new int[1000];
        for (int i = 0; i < numPoints; ++i) {
            boolean ok;
            float value = values[0][i];
            boolean bl = inside ? value >= min && value <= max : (ok = value < min || value > max);
            if (!ok) continue;
            if (++cnt >= indices.length) {
                int[] tmp = indices;
                indices = new int[tmp.length * 2];
                System.arraycopy(tmp, 0, indices, 0, cnt);
            }
            indices[cnt] = i;
        }
        int[] tmp = indices;
        indices = new int[cnt];
        System.arraycopy(tmp, 0, indices, 0, cnt);
        return new int[][]{indices};
    }

    public static float[][] getLatLon(GriddedSet domain) throws VisADException {
        boolean isLatLon = GridUtil.isLatLonOrder(domain);
        float[][] values = GridUtil.getEarthLocationPoints(domain);
        if (!isLatLon) {
            float[] tmp = values[0];
            values[0] = values[1];
            values[1] = tmp;
        }
        values[1] = GeoUtils.normalizeLongitude(values[1]);
        return values;
    }

    public static LatLonRect getLatLonRect(GriddedSet domain) throws VisADException {
        boolean isLatLon = GridUtil.isLatLonOrder(domain);
        float[][] values = GridUtil.getEarthLocationPoints(domain);
        if (!isLatLon) {
            float[] tmp = values[0];
            values[0] = values[1];
            values[1] = tmp;
        }
        values[1] = GeoUtils.normalizeLongitude(values[1]);
        float maxlon = GridUtil.max(values[1]);
        float minlon = GridUtil.min(values[1]);
        float maxlat = GridUtil.max(values[0]);
        float minlat = GridUtil.min(values[0]);
        LatLonPointImpl ul = new LatLonPointImpl(maxlat, minlon);
        LatLonPointImpl lr = new LatLonPointImpl(minlat, maxlon);
        LatLonRect latLonRect = new LatLonRect(ul, lr);
        return latLonRect;
    }

    public static float max(float[] array) {
        if (array == null) {
            throw new IllegalArgumentException("The Array must not be null");
        }
        if (array.length == 0) {
            throw new IllegalArgumentException("Array cannot be empty.");
        }
        float max = array[0];
        int jj = 0;
        while (Float.isNaN(max)) {
            max = array[++jj];
        }
        for (int j = jj; j < array.length; ++j) {
            if (Float.isNaN(array[j]) || !(array[j] > max)) continue;
            max = array[j];
        }
        return max;
    }

    public static float min(float[] array) {
        if (array == null) {
            throw new IllegalArgumentException("The Array must not be null");
        }
        if (array.length == 0) {
            throw new IllegalArgumentException("Array cannot be empty.");
        }
        float min = array[0];
        int jj = 0;
        while (Float.isNaN(min)) {
            min = array[++jj];
        }
        for (int j = jj; j < array.length; ++j) {
            if (Float.isNaN(array[j]) || !(array[j] < min)) continue;
            min = array[j];
        }
        return min;
    }

    public static void main(String[] args) throws Exception {
        for (int size = 1; size <= 10; ++size) {
            float[] test = new float[size * 1000000];
            long t1 = System.currentTimeMillis();
            FileOutputStream ostream = new FileOutputStream("test.ser");
            ObjectOutputStream p = new ObjectOutputStream(ostream);
            p.writeObject(test);
            p.flush();
            ((OutputStream)ostream).close();
            long t2 = System.currentTimeMillis();
            FileInputStream istream = new FileInputStream("test.ser");
            ObjectInputStream ois = new ObjectInputStream(istream);
            float[] tmp = (float[])ois.readObject();
            long t3 = System.currentTimeMillis();
            System.err.println("Length:" + tmp.length + " write: " + (t2 - t1) + " read:" + (t3 - t2));
        }
    }

    public static void writeGridToXls(FieldImpl grid) throws Exception {
        String filename = FileManager.getWriteFile(FileManager.FILTER_XLS, null);
        if (filename == null) {
            return;
        }
        GridUtil.writeGridToXls(grid, filename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeGridToXls(FieldImpl grid, String filename) throws Exception {
        Object loadId = JobManager.getManager().startLoad("Writing grid to xls", true);
        try {
            HSSFWorkbook wb = new HSSFWorkbook();
            int sheetIdx = -1;
            ArrayList<HSSFSheet> sheets = new ArrayList<HSSFSheet>();
            BufferedOutputStream fileOut = new BufferedOutputStream(new FileOutputStream(filename), 1000000);
            int MAXROWS = 65000;
            ArrayList<CalendarDateTime> times = new ArrayList<CalendarDateTime>();
            ArrayList<FlatField> fields = new ArrayList<FlatField>();
            float[][] domainVals = null;
            int colOffset = 2;
            HSSFSheet sheet = null;
            if (GridUtil.isTimeSequence(grid)) {
                FlatField ff;
                SampledSet timeSet = (SampledSet)GridUtil.getTimeSet(grid);
                double[][] timeValues = timeSet.getDoubles(false);
                Unit timeUnit = timeSet.getSetUnits()[0];
                int numTimes = timeSet.getLength();
                CalendarDateTimeSet cdt = null;
                if (numTimes > 1) {
                    cdt = (CalendarDateTimeSet)timeSet;
                    for (int timeIdx = 0; timeIdx < numTimes; ++timeIdx) {
                        CalendarDateTime cdti = new CalendarDateTime(timeValues[0][timeIdx], cdt.getCalendar());
                        JobManager.getManager().setDialogLabel1(loadId, "Writing grid time:" + (timeIdx + 1) + "/" + numTimes);
                        ff = (FlatField)grid.getSample(timeIdx);
                        if (ff == null) continue;
                        times.add(cdti);
                        fields.add(ff);
                    }
                } else {
                    RealTuple ss = ((SingletonSet)timeSet).getData();
                    if (ss != null) {
                        Data[] vdata = ss.getComponents();
                        JobManager.getManager().setDialogLabel1(loadId, "Writing grid time:1/" + numTimes);
                        ff = (FlatField)grid.getSample(0);
                        if (ff != null) {
                            times.add((CalendarDateTime)vdata[0]);
                            fields.add(ff);
                        }
                    }
                }
            } else if (grid instanceof FlatField) {
                fields.add((FlatField)grid);
            } else {
                System.err.println("Could not find any grid fields to write");
            }
            for (int fieldIdx = 0; fieldIdx < fields.size(); ++fieldIdx) {
                HSSFRow row;
                int rowCnt;
                int timeIdx = fieldIdx;
                DateTime dt = times.size() > 0 ? (DateTime)times.get(fieldIdx) : null;
                FlatField ff = (FlatField)fields.get(fieldIdx);
                if (sheets.size() == 0) {
                    SampledSet ss = GridUtil.getSpatialDomain(ff);
                    SampledSet latLonSet = null;
                    latLonSet = ss.getCoordinateSystem() != null ? ucar.visad.Util.convertDomain(ss, ss.getCoordinateSystem().getReference(), null) : ss;
                    domainVals = latLonSet.getSamples(false);
                    boolean latFirst = GridUtil.isLatLonOrder(latLonSet);
                    int numRows = domainVals[0].length;
                    rowCnt = -1;
                    for (int rowIdx = 0; rowIdx < numRows; ++rowIdx) {
                        if (rowCnt >= MAXROWS || rowCnt == -1) {
                            sheet = wb.createSheet();
                            sheets.add(sheet);
                            row = sheet.createRow(0);
                            row.createCell((short)0).setCellValue(latFirst ? "Latitude" : "Longitude");
                            row.createCell((short)1).setCellValue(latFirst ? "Longitude" : "Latitude");
                            if (domainVals.length > 2) {
                                row.createCell((short)2).setCellValue("Altitude");
                                colOffset = 3;
                            }
                            rowCnt = 0;
                        }
                        row = sheet.createRow(rowCnt + 1);
                        row.createCell((short)0).setCellValue((double)domainVals[0][rowIdx]);
                        row.createCell((short)1).setCellValue((double)domainVals[1][rowIdx]);
                        if (domainVals.length > 2) {
                            row.createCell((short)2).setCellValue((double)domainVals[2][rowIdx]);
                        }
                        ++rowCnt;
                    }
                }
                float[][] rangeVals = ff.getFloats(false);
                rowCnt = -1;
                int sheetCnt = -1;
                sheet = null;
                for (int rowIdx = 0; rowIdx < domainVals[0].length; ++rowIdx) {
                    if (rowCnt == -1 || rowCnt >= MAXROWS) {
                        rowCnt = 0;
                        sheet = (HSSFSheet)sheets.get(++sheetCnt);
                        row = sheet.getRow(0);
                        if (dt != null) {
                            row.createCell((short)(colOffset + timeIdx)).setCellValue(dt.toString());
                        }
                    }
                    row = sheet.getRow(rowCnt + 1);
                    row.createCell((short)(colOffset + timeIdx)).setCellValue((double)rangeVals[0][rowIdx]);
                    ++rowCnt;
                }
            }
            JobManager.getManager().setDialogLabel1(loadId, "Writing spreadsheet");
            wb.write((OutputStream)fileOut);
            ((OutputStream)fileOut).close();
        }
        catch (Exception exc) {
            LogUtil.logException("Writing grid to xls file: " + filename, exc);
        }
        finally {
            JobManager.getManager().stopLoad(loadId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeGridAtPolygonToXls(FieldImpl grid, String filename, String fxgrfName) throws Exception {
        List<DrawingGlyph> glyphList = GridUtil.read(fxgrfName);
        PolyGlyph polyGlyph = (PolyGlyph)glyphList.get(0);
        List points = polyGlyph.getPoints();
        Object loadId = JobManager.getManager().startLoad("Writing grid to xls", true);
        try {
            HSSFWorkbook wb = new HSSFWorkbook();
            int sheetIdx = -1;
            ArrayList<HSSFSheet> sheets = new ArrayList<HSSFSheet>();
            BufferedOutputStream fileOut = new BufferedOutputStream(new FileOutputStream(filename), 1000000);
            int MAXROWS = 65000;
            ArrayList<CalendarDateTime> times = new ArrayList<CalendarDateTime>();
            ArrayList<Real> fields = new ArrayList<Real>();
            float[][] domainVals = null;
            int colOffset = 2;
            int rowCnt = -1;
            int sheetCnt = -1;
            HSSFSheet sheet = null;
            if (GridUtil.isTimeSequence(grid)) {
                SampledSet timeSet = (SampledSet)GridUtil.getTimeSet(grid);
                double[][] timeValues = timeSet.getDoubles(false);
                Unit timeUnit = timeSet.getSetUnits()[0];
                int numTimes = timeSet.getLength();
                CalendarDateTimeSet cdt = null;
                for (int j = 0; j < points.size(); ++j) {
                    Real ff;
                    EarthLocationTuple el = (EarthLocationTuple)points.get(j);
                    FieldImpl gridf = GridUtil.sample(grid, el);
                    if (numTimes > 1) {
                        cdt = (CalendarDateTimeSet)timeSet;
                        for (int timeIdx = 0; timeIdx < numTimes; ++timeIdx) {
                            HSSFRow row;
                            CalendarDateTime cdti = new CalendarDateTime(timeValues[0][timeIdx], cdt.getCalendar());
                            JobManager.getManager().setDialogLabel1(loadId, "Writing grid time:" + (timeIdx + 1) + "/" + numTimes);
                            ff = (Real)gridf.getSample(timeIdx);
                            if (ff == null) continue;
                            if (sheets.size() == 0) {
                                boolean latFirst = true;
                                int numRows = points.size();
                                rowCnt = -1;
                                for (int rowIdx = 0; rowIdx < numRows; ++rowIdx) {
                                    EarthLocationTuple ell = (EarthLocationTuple)points.get(rowIdx);
                                    if (rowCnt >= MAXROWS || rowCnt == -1) {
                                        sheet = wb.createSheet();
                                        sheets.add(sheet);
                                        row = sheet.createRow(0);
                                        row.createCell((short)0).setCellValue(latFirst ? "Latitude" : "Longitude");
                                        row.createCell((short)1).setCellValue(latFirst ? "Longitude" : "Latitude");
                                        row.createCell((short)2).setCellValue("Altitude");
                                        colOffset = 3;
                                        rowCnt = 0;
                                    }
                                    row = sheet.createRow(rowCnt + 1);
                                    row.createCell((short)0).setCellValue(ell.getLatitude().getValue());
                                    row.createCell((short)1).setCellValue(ell.getLongitude().getValue());
                                    row.createCell((short)2).setCellValue(ell.getAltitude().getValue());
                                    ++rowCnt;
                                }
                                rowCnt = -1;
                                sheetCnt = -1;
                                sheet = null;
                            }
                            if (rowCnt == -1 || rowCnt >= MAXROWS) {
                                rowCnt = 0;
                                sheet = (HSSFSheet)sheets.get(++sheetCnt);
                                row = sheet.getRow(0);
                                if (cdti != null) {
                                    row.createCell((short)(colOffset + timeIdx)).setCellValue(cdti.toString());
                                }
                            }
                            row = sheet.getRow(1 + j);
                            row.createCell((short)(colOffset + timeIdx)).setCellValue(ff.getValue());
                            ++rowCnt;
                            sheetCnt = -1;
                            rowCnt = -1;
                        }
                        continue;
                    }
                    RealTuple ss = ((SingletonSet)timeSet).getData();
                    if (ss == null) continue;
                    Data[] vdata = ss.getComponents();
                    JobManager.getManager().setDialogLabel1(loadId, "Writing grid time:1/" + numTimes);
                    ff = (Real)gridf.getSample(0);
                    if (ff == null) continue;
                    times.add((CalendarDateTime)vdata[0]);
                    fields.add(ff);
                }
            } else {
                System.err.println("Could not find any grid fields to write");
            }
            JobManager.getManager().setDialogLabel1(loadId, "Writing spreadsheet");
            wb.write((OutputStream)fileOut);
            ((OutputStream)fileOut).close();
        }
        catch (Exception exc) {
            LogUtil.logException("Writing grid to xls file: " + filename, exc);
        }
        finally {
            JobManager.getManager().stopLoad(loadId);
        }
    }

    public static void exportGridToNetcdf(FieldImpl grid) throws Exception {
        String filename = FileManager.getWriteFile(FileManager.FILTER_NETCDF, null);
        if (filename == null) {
            return;
        }
        GridUtil.exportGridToNetcdf(grid, filename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exportGridToNetcdf(FieldImpl grid, String filename) throws Exception {
        Object loadId = JobManager.getManager().startLoad("Writing grid to CF", true);
        try {
            NetcdfFileWriteable ncfile = NetcdfFileWriteable.createNew(filename, false);
            boolean isTimeSequence = GridUtil.isTimeSequence(grid);
            ArrayList<Dimension> dims = new ArrayList<Dimension>();
            Set timeSet = null;
            int numTimes = 0;
            if (isTimeSequence) {
                timeSet = GridUtil.getTimeSet(grid);
                Unit[] units = timeSet.getSetUnits();
                numTimes = timeSet.getLength();
                Dimension timeDim = new Dimension("time", numTimes, true);
                dims.add(timeDim);
                ncfile.addDimension(null, timeDim);
                Variable timeVar = new Variable((NetcdfFile)ncfile, null, null, "time", DataType.DOUBLE, "time");
                timeVar.addAttribute(new Attribute("units", units[0].toString()));
                ncfile.addVariable(null, timeVar);
            }
            GriddedSet domainSet = (GriddedSet)GridUtil.getSpatialDomain(grid);
            CoordinateSystem cs = domainSet.getCoordinateSystem();
            boolean haveEmpirical = cs instanceof EmpiricalCoordinateSystem;
            HashMap<Variable, Array> varData = GridUtil.addSpatialVars(ncfile, domainSet, dims);
            Variable projVar = null;
            java.util.Set<Variable> keys = varData.keySet();
            if (!haveEmpirical) {
                for (Variable v : keys) {
                    if (v.findAttribute("grid_mapping_name") == null) continue;
                    projVar = v;
                    break;
                }
            }
            TupleType tType = GridUtil.getParamType(grid);
            RealType[] rTypes = tType.getRealComponents();
            for (int i = 0; i < rTypes.length; ++i) {
                RealType rt = rTypes[i];
                Variable v = new Variable(ncfile, null, null, GridUtil.getVarName(rt));
                Unit u = rt.getDefaultUnit();
                if (u != null) {
                    v.addAttribute(new Attribute("units", rt.getDefaultUnit().toString()));
                }
                if (projVar != null) {
                    v.addAttribute(new Attribute("grid_mapping", projVar.getName()));
                }
                if (haveEmpirical) {
                    v.addAttribute(new Attribute("coordinates", "latitude longitude"));
                }
                v.setDataType(DataType.FLOAT);
                v.setDimensions(dims);
                ncfile.addVariable(null, v);
            }
            ncfile.addGlobalAttribute(new Attribute("Conventions", "CF-1.X"));
            ncfile.addGlobalAttribute(new Attribute("History", "Translated from VisAD grid to CF-1.X Conventions by IDV\nOriginal Dataset = " + grid.getType() + "\nTranslation Date = " + new Date()));
            ncfile.create();
            if (isTimeSequence) {
                Variable timeVar = ncfile.findVariable("time");
                double[][] timeVals = timeSet.getDoubles(false);
                Array varArray = Array.factory(DataType.DOUBLE, new int[]{numTimes}, (Object)timeVals[0]);
                ncfile.write(timeVar.getName(), varArray);
            }
            for (Variable v : keys) {
                if (v.getName().equals("ImageLine")) {
                    Array af = varData.get(v);
                    int i = 0;
                    while ((long)i < af.getSize()) {
                        float t = af.getFloat(i) + 1.0f;
                        af.setFloat(i, t);
                        ++i;
                    }
                    varData.put(v, af);
                }
                ncfile.write(v.getName(), varData.get(v));
            }
            int numDims = dims.size();
            int[] sizes = new int[numDims];
            int index = 0;
            for (Dimension dim : dims) {
                sizes[index++] = dim.getLength();
            }
            Array arr = null;
            if (isTimeSequence) {
                sizes[0] = 1;
                int[] origin = new int[sizes.length];
                for (int k = 1; k < sizes.length; ++k) {
                    origin[k] = 0;
                }
                for (int i = 0; i < timeSet.getLength(); ++i) {
                    origin[0] = i;
                    FlatField sample = (FlatField)grid.getSample(i, false);
                    float[][] samples = sample.getFloats(false);
                    for (int j = 0; j < rTypes.length; ++j) {
                        Variable v = ncfile.findVariable(GridUtil.getVarName(rTypes[j]));
                        arr = Array.factory(DataType.FLOAT, sizes, (Object)samples[j]);
                        ncfile.write(v.getName(), origin, arr);
                    }
                }
            } else {
                float[][] samples = ((FlatField)grid).getFloats();
                for (int j = 0; j < rTypes.length; ++j) {
                    Variable v = ncfile.findVariable(GridUtil.getVarName(rTypes[j]));
                    arr = Array.factory(DataType.FLOAT, sizes, (Object)samples[j]);
                    ncfile.write(v.getName(), arr);
                }
            }
            ncfile.close();
        }
        catch (Exception exc) {
            LogUtil.logException("Writing grid to netCDF file: " + filename, exc);
        }
        finally {
            JobManager.getManager().stopLoad(loadId);
        }
    }

    private static String getVarName(RealType r) {
        return ucar.visad.Util.cleanTypeName(r.getName());
    }

    private static HashMap<Variable, Array> addSpatialVars(NetcdfFile ncfile, SampledSet domainSet, List<Dimension> dims) throws VisADException, RemoteException {
        Array varArray;
        HashMap<Variable, Array> varToArray = new HashMap<Variable, Array>();
        int dim = domainSet.getDimension();
        int mdim = domainSet.getManifoldDimension();
        CoordinateSystem cs = domainSet.getCoordinateSystem();
        boolean haveEmpirical = cs instanceof EmpiricalCoordinateSystem;
        Unit[] units = domainSet.getSetUnits();
        int[] lens = ((GriddedSet)domainSet).getLengths();
        float[][] spatialVals = domainSet.getSamples(false);
        boolean is3D = dim > 2;
        int sizeX = lens[0];
        int sizeY = lens[1];
        int sizeZ = 1;
        if (is3D && mdim > 2) {
            sizeZ = lens[2];
        }
        float[] xVals = new float[sizeX];
        float[] yVals = new float[sizeY];
        float[] zVals = new float[sizeZ];
        if (is3D) {
            for (int z = 0; z < sizeZ; ++z) {
                zVals[z] = spatialVals[2][sizeX * sizeY * z];
            }
        }
        for (int y = 0; y < sizeY; ++y) {
            yVals[y] = spatialVals[1][sizeX * y];
        }
        for (int x = 0; x < sizeX; ++x) {
            xVals[x] = spatialVals[0][x];
        }
        RealType[] types = ((SetType)domainSet.getType()).getDomain().getRealComponents();
        String xName = haveEmpirical ? "xc" : GridUtil.getVarName(types[0]);
        Dimension xDim = new Dimension(xName, sizeX, true);
        ncfile.addDimension(null, xDim);
        String yName = haveEmpirical ? "yc" : GridUtil.getVarName(types[1]);
        Dimension yDim = new Dimension(yName, sizeY, true);
        ncfile.addDimension(null, yDim);
        String zName = null;
        if (dim == 3) {
            zName = GridUtil.getVarName(types[2]);
            Dimension zDim = new Dimension(zName, sizeZ, true);
            ncfile.addDimension(null, zDim);
            dims.add(zDim);
        }
        Variable xVar = null;
        Variable yVar = null;
        MapProjection mp = GridUtil.getNavigation(domainSet);
        if (mp instanceof TrivialMapProjection && !haveEmpirical) {
            xVar = GridUtil.makeCoordinateVariable(ncfile, xName, units[0], "longitude coordinate", "longitude", xName);
            yVar = GridUtil.makeCoordinateVariable(ncfile, yName, units[1], "latitude coordinate", "latitude", yName);
        } else if (!haveEmpirical) {
            xVar = GridUtil.makeCoordinateVariable(ncfile, xName, units[0], "x coordinate of projection", "projection_x_coordinate", xName);
            yVar = GridUtil.makeCoordinateVariable(ncfile, yName, units[1], "y coordinate of projection", "projection_y_coordinate", yName);
            Variable projVar = GridUtil.makeProjectionVar(ncfile, mp);
            if (projVar != null) {
                char[] data = new char[]{'d'};
                Array dataArray = Array.factory(DataType.CHAR, new int[0], (Object)data);
                varToArray.put(projVar, dataArray);
            }
        } else {
            xVar = GridUtil.makeCoordinateVariable(ncfile, xName, (String)null, "x coordinate", "x_coordinate", xName);
            yVar = GridUtil.makeCoordinateVariable(ncfile, yName, (String)null, "y coordinate", "y_coordinate", yName);
            float[] latVals = new float[sizeX * sizeY];
            float[] lonVals = new float[sizeX * sizeY];
            int index = 0;
            for (int y = 0; y < sizeY; ++y) {
                yVals[y] = y;
                for (int x = 0; x < sizeX; ++x) {
                    if (index < sizeX) {
                        xVals[x] = x;
                    }
                    lonVals[index] = spatialVals[0][x + sizeX * y];
                    latVals[index++] = spatialVals[1][x + sizeX * y];
                }
            }
            Variable latVar = new Variable(ncfile, null, null, "latitude", DataType.FLOAT, "yc xc");
            latVar.addAttribute(new Attribute("units", "degrees_north"));
            latVar.addAttribute(new Attribute("long_name", "latitude of points"));
            ncfile.addVariable(null, latVar);
            varArray = Array.factory(DataType.FLOAT, new int[]{sizeY, sizeX}, (Object)latVals);
            varToArray.put(latVar, varArray);
            Variable lonVar = new Variable(ncfile, null, null, "longitude", DataType.FLOAT, "yc xc");
            lonVar.addAttribute(new Attribute("units", "degrees_east"));
            lonVar.addAttribute(new Attribute("long_name", "longitude of points"));
            ncfile.addVariable(null, lonVar);
            varArray = Array.factory(DataType.FLOAT, new int[]{sizeY, sizeX}, (Object)lonVals);
            varToArray.put(lonVar, varArray);
        }
        dims.add(yDim);
        dims.add(xDim);
        if (dim == 3) {
            Variable zVar = new Variable(ncfile, null, null, zName, DataType.FLOAT, zName);
            Unit zUnit = units[2];
            if (zUnit != null) {
                zVar.addAttribute(new Attribute("units", zUnit.toString()));
            }
            String upOrDown = "up";
            if (Unit.canConvert(units[2], CommonUnits.MILLIBAR)) {
                upOrDown = "down";
            }
            zVar.addAttribute(new Attribute("positive", upOrDown));
            if (cs == null) {
                zVar.addAttribute(new Attribute("long_name", "altitude (MSL"));
                zVar.addAttribute(new Attribute("standard_name", "altitude"));
            }
            varArray = Array.factory(DataType.FLOAT, new int[]{sizeZ}, (Object)zVals);
            varToArray.put(zVar, varArray);
            ncfile.addVariable(null, zVar);
            if (haveEmpirical) {
                String dimString = zName + " yc xc";
                String altName = "height";
                Variable altVar = new Variable(ncfile, null, null, altName, DataType.FLOAT, dimString);
                EmpiricalCoordinateSystem ecs = (EmpiricalCoordinateSystem)cs;
                GriddedSet refSet = ecs.getReferenceSet();
                int[] refSizes = refSet.getLengths();
                Unit[] refUnits = refSet.getSetUnits();
                Unit altUnit = refUnits[2];
                if (altUnit != null) {
                    altVar.addAttribute(new Attribute("units", altUnit.toString()));
                }
                altVar.addAttribute(new Attribute("long_name", "height/depth of " + zName));
                altVar.addAttribute(new Attribute("standard_name", "altitude"));
                altVar.addAttribute(new Attribute("coordinates", "latitude longitude"));
                float[] altVals = refSet.getSamples(false)[2];
                varArray = Array.factory(DataType.FLOAT, new int[]{refSizes[2], refSizes[1], refSizes[0]}, (Object)altVals);
                varToArray.put(altVar, varArray);
                ncfile.addVariable(null, altVar);
            }
        }
        varArray = Array.factory(DataType.FLOAT, new int[]{sizeX}, (Object)xVals);
        varToArray.put(xVar, varArray);
        varArray = Array.factory(DataType.FLOAT, new int[]{sizeY}, (Object)yVals);
        varToArray.put(yVar, varArray);
        return varToArray;
    }

    private static Variable makeCoordinateVariable(NetcdfFile ncfile, String name, Unit unit, String desc, String standard_name, String dimName) {
        return GridUtil.makeCoordinateVariable(ncfile, name, unit != null ? unit.toString() : (String)null, desc, standard_name, dimName);
    }

    private static Variable makeCoordinateVariable(NetcdfFile ncfile, String name, String unitName, String desc, String standard_name, String dimName) {
        Variable v = new Variable(ncfile, null, null, name);
        v.setDataType(DataType.FLOAT);
        v.setDimensions(dimName);
        if (unitName != null) {
            v.addAttribute(new Attribute("units", unitName));
        }
        v.addAttribute(new Attribute("long_name", desc));
        v.addAttribute(new Attribute("standard_name", standard_name));
        ncfile.addVariable(null, v);
        return v;
    }

    private static Variable makeProjectionVar(NetcdfFile ncfile, MapProjection mp) {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        Variable projVar = null;
        if (mp instanceof ProjectionCoordinateSystem || mp instanceof AREACoordinateSystem) {
            Object nav;
            ProjectionImpl proj = null;
            if (mp instanceof AREACoordinateSystem) {
                AREACoordinateSystem acs = (AREACoordinateSystem)mp;
                int[] dir = acs.getDirBlock();
                nav = acs.getNavBlock();
                int[] aux = acs.getAuxBlock();
                proj = new McIDASAreaProjection(dir, (int[])nav, aux);
            } else {
                proj = ((ProjectionCoordinateSystem)mp).getProjection();
            }
            List<Parameter> params = proj.getProjectionParameters();
            String grid_name = "not_yet_supported";
            if (proj instanceof LambertConformal) {
                grid_name = "lambert_conformal_conic";
            } else if (proj instanceof Mercator) {
                grid_name = "mercator";
            } else if (proj instanceof Stereographic) {
                grid_name = "polar_stereographic";
            } else if (proj instanceof VerticalPerspectiveView) {
                grid_name = "vertical_perspective";
            } else if (proj instanceof McIDASAreaProjection) {
                grid_name = McIDASAreaProjection.GRID_MAPPING_NAME;
            }
            attributes.add(new Attribute("grid_mapping_name", grid_name));
            nav = params.iterator();
            while (nav.hasNext()) {
                Parameter param = (Parameter)nav.next();
                if (param.isString()) {
                    attributes.add(new Attribute(param.getName(), param.getStringValue()));
                    continue;
                }
                if (param.getLength() == 1) {
                    attributes.add(new Attribute(param.getName(), new Double(param.getNumericValue())));
                    continue;
                }
                double[] data = param.getNumericValues();
                attributes.add(new Attribute(param.getName(), Array.factory(DataType.DOUBLE, new int[]{param.getLength()}, (Object)data)));
            }
            projVar = new Variable(ncfile, null, null, grid_name);
            projVar.setDataType(DataType.CHAR);
            projVar.setDimensions(new ArrayList<Dimension>());
            for (int i = 0; i < attributes.size(); ++i) {
                Attribute att = (Attribute)attributes.get(i);
                projVar.addAttribute(att);
            }
            ncfile.addVariable(null, projVar);
        } else if (mp instanceof AREACoordinateSystem) {
            AREACoordinateSystem acs = (AREACoordinateSystem)mp;
            int[] dir = acs.getDirBlock();
            int[] nav = acs.getNavBlock();
            int[] nArray = acs.getAuxBlock();
        }
        return projVar;
    }

    public static FieldImpl setPressureValues(FieldImpl grid, float[] pressValues) throws VisADException {
        return GridUtil.setVerticalValues(grid, pressValues, AirPressure.getRealType(), CommonUnits.MILLIBAR);
    }

    public static FieldImpl setAltitudeValues(FieldImpl grid, float[] altValues) throws VisADException {
        return GridUtil.setVerticalValues(grid, altValues, RealType.Altitude, CommonUnit.meter);
    }

    public static FieldImpl setVerticalValues(FieldImpl grid, float[] newValues, RealType vertType, Unit vertUnit) throws VisADException {
        FieldImpl newField = null;
        SampledSet domainSet = GridUtil.getSpatialDomain(grid);
        if (!(domainSet instanceof Gridded3DSet)) {
            throw new VisADException("Not a 3D set");
        }
        newField = GridUtil.setSpatialDomain(grid, GridUtil.newVerticalDomain((Gridded3DSet)domainSet, newValues, vertType, vertUnit), false);
        return newField;
    }

    private static Gridded3DSet newVerticalDomain(Gridded3DSet domainSet, float[] newValues, RealType vertType, Unit vertUnit) throws VisADException {
        EmpiricalCoordinateSystem ecs;
        Gridded3DSet newDSet = null;
        int[] lengths = domainSet.getLengths();
        int setLength = domainSet.getLength();
        if (lengths[2] != newValues.length && setLength != newValues.length) {
            throw new VisADException("newValues size not equal to domain vertical dimension size");
        }
        float[] vertVals = null;
        if (newValues.length == setLength) {
            vertVals = newValues;
        } else {
            vertVals = new float[setLength];
            int l = 0;
            for (int k = 0; k < lengths[2]; ++k) {
                for (int j = 0; j < lengths[1]; ++j) {
                    for (int i = 0; i < lengths[0]; ++i) {
                        vertVals[l++] = newValues[k];
                    }
                }
            }
        }
        float[][] setVals = domainSet.getSamples(true);
        Object refVals = null;
        RealTupleType setType = ((SetType)domainSet.getType()).getDomain();
        CoordinateSystem cs = domainSet.getCoordinateSystem();
        RealTupleType refType = cs != null ? cs.getReference() : setType;
        ErrorEstimate[] oldErrors = domainSet.getSetErrors();
        ErrorEstimate[] newErrors = new ErrorEstimate[oldErrors.length];
        if (cs != null) {
            Trace.call1("GridUtil.transformCoordinates");
            refVals = CoordinateSystem.transformCoordinates(refType, refType.getCoordinateSystem(), refType.getDefaultUnits(), newErrors, setType, cs, domainSet.getSetUnits(), oldErrors, setVals, false);
            Trace.call2("GeoGridAdapter.transformCoordinates");
        } else {
            refVals = new float[3][];
            refVals[0] = setVals[0];
            refVals[1] = setVals[1];
        }
        refVals[2] = vertVals;
        Unit vtu = vertUnit;
        RealType[] types = refType.getRealComponents();
        boolean isPressure = false;
        if (!Unit.canConvert(vtu, CommonUnit.meter)) {
            if (Unit.canConvert(vtu, CommonUnits.MILLIBAR)) {
                isPressure = true;
            } else {
                throw new VisADException("unknown vertical coordinate");
            }
        }
        RealTupleType newDomainType = new RealTupleType(types[0], types[1], RealType.Altitude);
        if (isPressure) {
            CoordinateSystem vcs = DataUtil.getPressureToHeightCS("ucar.visad.quantities.AirPressure$StandardAtmosphereCoordinateSystem");
            refVals[2] = vcs.toReference(new float[][]{refVals[2]}, new Unit[]{vtu})[0];
            vtu = vcs.getReferenceUnits()[0];
        }
        Unit[] newDomainUnits = newDomainType.getDefaultUnits();
        newDomainUnits[2] = vtu;
        Gridded3DSet newDomain = (Gridded3DSet)GriddedSet.create(newDomainType, refVals, lengths, null, newDomainUnits, newErrors, false, false);
        EmpiricalCoordinateSystem gcs = ecs = new EmpiricalCoordinateSystem(domainSet, newDomain);
        RealTupleType newSetType = new RealTupleType(setType.getRealComponents(), (CoordinateSystem)gcs, null);
        Trace.call1("GeoGridAdapter final GriddedSet");
        newDSet = (Gridded3DSet)GriddedSet.create(newSetType, domainSet.getSamples(false), lengths, null, domainSet.getSetUnits(), oldErrors, false, false);
        return newDSet;
    }

    public static List<FieldStats> findMinMaxAverage(FieldImpl field, UnionSet mapSets) throws VisADException, RemoteException {
        ArrayList<FieldStats> stats = new ArrayList<FieldStats>();
        if (GridUtil.isTimeSequence(field)) {
            int numTimes = ucar.visad.Util.getDomainSet(field).getLength();
            float[][] result = new float[numTimes][];
            for (int timeStep = 0; timeStep < numTimes; ++timeStep) {
                stats.add(GridUtil.findMinMaxAverageFromRange((FlatField)field.getSample(timeStep), mapSets));
            }
        } else {
            stats.add(GridUtil.findMinMaxAverageFromRange((FlatField)field, mapSets));
        }
        return stats;
    }

    public static FieldStats findMinMaxAverageFromRange(FlatField field, UnionSet mapSets) throws VisADException, RemoteException {
        int[][] indices = mapSets == null ? (int[][])null : GridUtil.findContainedIndices((GriddedSet)ucar.visad.Util.getDomainSet(field), mapSets);
        float[] mma = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
        float[][] values = field.getFloats(false);
        if (indices == null) {
            int len = values[0].length;
            indices = new int[1][len];
            for (int i = 0; i < len; ++i) {
                indices[0][i] = i;
            }
        }
        int cnt = 0;
        for (int mapIdx = 0; mapIdx < indices.length; ++mapIdx) {
            int[] indexArray = indices[mapIdx];
            for (int j = 0; j < indexArray.length; ++j) {
                int index = indexArray[j];
                if (cnt == 0) {
                    mma[1] = mma[0] = values[0][index];
                    mma[2] = mma[0];
                } else {
                    mma[0] = Math.min(values[0][index], mma[0]);
                    mma[1] = Math.max(values[0][index], mma[1]);
                    mma[2] = mma[2] + values[0][index];
                }
                ++cnt;
            }
        }
        if (cnt > 0) {
            mma[2] = mma[2] / (float)cnt;
        }
        mma[3] = cnt;
        return new FieldStats(mma);
    }

    public static boolean canSwapLatLon(FieldImpl grid) throws VisADException {
        SampledSet domain = GridUtil.getSpatialDomain(grid);
        RealTupleType domainRef = ((SetType)domain.getType()).getDomain();
        if (domainRef.getDimension() > 2) {
            return false;
        }
        return domainRef.equals(RealTupleType.SpatialEarth2DTuple) || domainRef.equals(RealTupleType.LatitudeLongitudeTuple);
    }

    public static FieldImpl swapLatLon(FieldImpl grid) throws VisADException {
        if (!GridUtil.canSwapLatLon(grid)) {
            throw new VisADException("can't swap lat/lon for this type of grid");
        }
        FieldImpl retField = null;
        try {
            if (GridUtil.isTimeSequence(grid)) {
                SampledSet timeSet = (SampledSet)GridUtil.getTimeSet(grid);
                FunctionType retFieldType = null;
                for (int i = 0; i < timeSet.getLength(); ++i) {
                    FlatField ff = GridUtil.swapLatLonFF((FlatField)grid.getSample(i));
                    if (ff == null) continue;
                    if (retFieldType == null) {
                        retFieldType = new FunctionType(((SetType)timeSet.getType()).getDomain(), ff.getType());
                        retField = new FieldImpl(retFieldType, timeSet);
                    }
                    ((FieldImpl)retField).setSample(i, (Data)ff, false);
                }
            } else {
                retField = GridUtil.swapLatLonFF((FlatField)grid);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return retField;
    }

    private static FlatField swapLatLonFF(FlatField grid) throws VisADException, RemoteException {
        FlatField llGrid = null;
        SampledSet llDomain = GridUtil.getSpatialDomain(grid);
        RealTupleType llRef = ((SetType)llDomain.getType()).getDomain();
        if (!llRef.equals(RealTupleType.SpatialEarth2DTuple) && !llRef.equals(RealTupleType.LatitudeLongitudeTuple)) {
            throw new VisADException("can't swap lat/lon for this type of grid");
        }
        RealTupleType newRef = null;
        Unit[] setUnits = llDomain.getSetUnits();
        newRef = llRef.equals(RealTupleType.SpatialEarth2DTuple) ? RealTupleType.LatitudeLongitudeTuple : RealTupleType.SpatialEarth2DTuple;
        Gridded2DSet newSet = null;
        float[][] newSamples = null;
        if (llDomain instanceof Linear2DSet) {
            newSet = llDomain instanceof LinearLatLonSet ? new LinearLatLonSet((MathType)newRef, new Linear1DSet[]{((Linear2DSet)llDomain).getY(), ((Linear2DSet)llDomain).getX()}, (CoordinateSystem)null, new Unit[]{setUnits[1], setUnits[0]}, (ErrorEstimate[])null) : new Linear2DSet((MathType)newRef, new Linear1DSet[]{((Linear2DSet)llDomain).getY(), ((Linear2DSet)llDomain).getX()}, (CoordinateSystem)null, new Unit[]{setUnits[1], setUnits[0]}, (ErrorEstimate[])null);
            float[][] samples = grid.getFloats(false);
            newSamples = new float[samples.length][samples[0].length];
            int[] lengths = newSet.getLengths();
            int sizeX = lengths[0];
            int sizeY = lengths[1];
            for (int i = 0; i < samples.length; ++i) {
                int l = 0;
                for (int j = 0; j < sizeY; ++j) {
                    for (int k = 0; k < sizeX; ++k) {
                        int oldelem = j + k * sizeY;
                        newSamples[i][l++] = samples[i][oldelem];
                    }
                }
            }
        } else if (llDomain instanceof Gridded2DSet) {
            int[] lengths = ((GriddedSet)llDomain).getLengths();
            ErrorEstimate[] errors = ((GriddedSet)llDomain).getSetErrors();
            float[][] llVals = ((Set)llDomain).getSamples(true);
            newSet = new Gridded2DSet((MathType)newRef, (float[][])new float[][]{llVals[1], llVals[0]}, lengths[1], lengths[0], (CoordinateSystem)null, new Unit[]{setUnits[1], setUnits[0]}, new ErrorEstimate[]{errors[1], errors[0]});
            newSamples = grid.getFloats(false);
        } else {
            throw new VisADException("can't swap lat/lon for " + llDomain.getClass().getName());
        }
        if (newSet != null && newSamples != null) {
            FunctionType newType = new FunctionType(((SetType)newSet.getType()).getDomain(), GridUtil.getParamType(grid));
            llGrid = new FlatField(newType, newSet);
            llGrid.setSamples(newSamples, false);
        }
        return llGrid;
    }

    public static FieldImpl smooth(FieldImpl slice, String type) throws VisADException {
        return GridUtil.smooth(slice, type, type.equals(SMOOTH_GAUSSIAN) ? 6 : 0);
    }

    private static boolean isValidSmoother(String type) {
        return type != null && (type.equals(SMOOTH_5POINT) || type.equals(SMOOTH_9POINT) || type.equals(SMOOTH_GAUSSIAN) || type.equals(SMOOTH_CRESSMAN) || type.equals(SMOOTH_CIRCULAR) || type.equals(SMOOTH_RECTANGULAR));
    }

    public static FieldImpl smooth(FieldImpl slice, String type, int filterLevel) throws VisADException {
        if (!GridUtil.isValidSmoother(type)) {
            return slice;
        }
        FieldImpl smoothedFI = null;
        TupleType smoothedRangeType = null;
        try {
            if (GridUtil.isTimeSequence(slice)) {
                Set timeSet = slice.getDomainSet();
                for (int i = 0; i < timeSet.getLength(); ++i) {
                    FieldImpl smoothedFF = null;
                    FieldImpl sample = (FieldImpl)slice.getSample(i, false);
                    if (sample == null) continue;
                    if (!GridUtil.isSequence(sample)) {
                        smoothedFF = type.equals(SMOOTH_5POINT) ? GridUtil.smooth5Point((FlatField)sample, smoothedRangeType) : (type.equals(SMOOTH_9POINT) ? GridUtil.smooth9Point((FlatField)sample, smoothedRangeType) : (type.equals(SMOOTH_GAUSSIAN) ? GridUtil.smoothGaussian((FlatField)sample, filterLevel, smoothedRangeType) : GridUtil.smoothWeighted((FlatField)sample, filterLevel, type, smoothedRangeType)));
                        if (smoothedFF == null) continue;
                        if (smoothedRangeType == null) {
                            smoothedRangeType = GridUtil.getParamType(smoothedFF);
                        }
                    } else {
                        Trace.call1("GridUtil smooth inner sequence");
                        Set ensDomain = sample.getDomainSet();
                        for (int j = 0; j < ensDomain.getLength(); ++j) {
                            FlatField innerField = (FlatField)sample.getSample(j, false);
                            if (innerField == null) continue;
                            FlatField innerSmoothedField = null;
                            innerSmoothedField = type.equals(SMOOTH_5POINT) ? GridUtil.smooth5Point(innerField, smoothedRangeType) : (type.equals(SMOOTH_9POINT) ? GridUtil.smooth9Point(innerField, smoothedRangeType) : (type.equals(SMOOTH_GAUSSIAN) ? GridUtil.smoothGaussian(innerField, filterLevel, smoothedRangeType) : GridUtil.smoothWeighted(innerField, filterLevel, type, smoothedRangeType)));
                            if (innerSmoothedField == null) continue;
                            if (smoothedRangeType == null) {
                                smoothedRangeType = GridUtil.getParamType(innerSmoothedField);
                            }
                            if (smoothedFF == null) {
                                FunctionType innerType = new FunctionType(DataUtility.getDomainType(ensDomain), innerSmoothedField.getType());
                                smoothedFF = new FieldImpl(innerType, ensDomain);
                            }
                            ((FieldImpl)smoothedFF).setSample(j, (Data)innerSmoothedField, false);
                        }
                        Trace.call2("GridUtil smooth inner sequence");
                    }
                    if (smoothedFI == null && smoothedFF != null) {
                        FunctionType smoothedFFType = (FunctionType)smoothedFF.getType();
                        FunctionType smoothedFT = new FunctionType(((SetType)timeSet.getType()).getDomain(), smoothedFFType);
                        smoothedFI = new FieldImpl(smoothedFT, timeSet);
                    }
                    if (smoothedFF == null) continue;
                    smoothedFI.setSample(i, smoothedFF, false, false);
                }
            } else {
                smoothedFI = type.equals(SMOOTH_5POINT) ? GridUtil.smooth5Point((FlatField)slice, smoothedRangeType) : (type.equals(SMOOTH_9POINT) ? GridUtil.smooth9Point((FlatField)slice, smoothedRangeType) : (type.equals(SMOOTH_GAUSSIAN) ? GridUtil.smoothGaussian((FlatField)slice, filterLevel, smoothedRangeType) : GridUtil.smoothWeighted((FlatField)slice, filterLevel, type, smoothedRangeType)));
            }
        }
        catch (RemoteException re) {
            throw new VisADException("RemoteException: " + re.getMessage());
        }
        return smoothedFI;
    }

    private static float[] getLevelSlice(float[] values, int sizeX, int sizeY, int levelIndex) {
        float[] levelValues = new float[sizeX * sizeY];
        int k = 0;
        for (int i = 0; i < sizeY; ++i) {
            for (int j = 0; j < sizeX; ++j) {
                int offset = levelIndex * sizeX * sizeY + i * sizeX + j;
                levelValues[k] = values[offset];
                ++k;
            }
        }
        return levelValues;
    }

    private static void setLevelSlice(float[] values, float[] levelValues, int sizeX, int sizeY, int levelIndex) {
        int k = 0;
        for (int i = 0; i < sizeY; ++i) {
            for (int j = 0; j < sizeX; ++j) {
                int offset = levelIndex * sizeX * sizeY + i * sizeX + j;
                values[offset] = levelValues[k];
                ++k;
            }
        }
    }

    private static FlatField smooth5Point(FlatField slice, TupleType rangeType) throws VisADException, RemoteException {
        int jgxmax;
        float wt = 0.125f;
        float wt4 = 4.0f * wt;
        if (rangeType == null) {
            rangeType = GridUtil.makeNewParamType(GridUtil.getParamType(slice), "_SM5S");
        }
        FlatField newField = (FlatField)GridUtil.setParamType((FieldImpl)slice, rangeType, true);
        float[][] samples = slice.getFloats(false);
        GriddedSet domain = null;
        if (!(GridUtil.getSpatialDomain(slice) instanceof GriddedSet)) {
            return null;
        }
        domain = (GriddedSet)GridUtil.getSpatialDomain(slice);
        int[] lengths = domain.getLengths();
        int jgxmin = 1;
        int kxd = jgxmax = lengths[0];
        int jgymin = 1;
        int jgymax = lengths[1];
        int sizeX = jgxmax;
        int sizeY = jgymax;
        int sizeZ = 1;
        if (lengths.length > 2) {
            sizeZ = lengths[2];
        }
        int kyd = jgymax;
        int numParams = samples.length;
        float[] highs = domain.getHi();
        float[] lows = domain.getLow();
        boolean isCyclic = lows[0] == highs[0] % 360.0f;
        float[][] newVals = newField.getFloats(false);
        int nr = 5;
        for (int np = 0; np < numParams; ++np) {
            for (int z = 0; z < sizeZ; ++z) {
                float[] gno;
                float[] gni;
                float[] gnii = GridUtil.getLevelSlice(samples[np], sizeX, sizeY, z);
                float[] gnoi = GridUtil.getLevelSlice(newVals[np], sizeX, sizeY, z);
                jgxmax = sizeX;
                if (isCyclic) {
                    gni = GridUtil.extendGrid(gnii, nr, jgxmax, jgymax);
                    gno = new float[gni.length];
                    kxd = jgxmax += 2 * nr;
                } else {
                    gni = gnii;
                    gno = gnoi;
                }
                for (int j = jgymin; j <= jgymax; ++j) {
                    for (int i = jgxmin; i <= jgxmax; ++i) {
                        int ii = (j - 1) * kxd + i;
                        if (Float.isNaN(gni[ii - 1])) {
                            gno[ii - 1] = Float.NaN;
                            continue;
                        }
                        int ip1 = ii + 1;
                        float dip1 = i + 1 > jgxmax ? Float.NaN : gni[ip1 - 1];
                        int im1 = ii - 1;
                        float dim1 = i - 1 < jgxmin ? Float.NaN : gni[im1 - 1];
                        int jp1 = ii + kxd;
                        float djp1 = j + 1 > jgymax ? Float.NaN : gni[jp1 - 1];
                        int jm1 = ii - kxd;
                        float djm1 = j - 1 < jgymin ? Float.NaN : gni[jm1 - 1];
                        float dsum = gni[ii - 1] * wt4;
                        float wsum = wt4;
                        if (!Float.isNaN(dip1)) {
                            dsum += dip1 * wt;
                            wsum += wt;
                        }
                        if (!Float.isNaN(dim1)) {
                            dsum += dim1 * wt;
                            wsum += wt;
                        }
                        if (!Float.isNaN(djp1)) {
                            dsum += djp1 * wt;
                            wsum += wt;
                        }
                        if (!Float.isNaN(djm1)) {
                            dsum += djm1 * wt;
                            wsum += wt;
                        }
                        gno[ii - 1] = dsum / wsum;
                    }
                }
                if (isCyclic) {
                    int kxdi = kxd - 2 * nr;
                    int m = 0;
                    for (int i = 0; i < kyd; ++i) {
                        for (int j = 0; j < kxdi; ++j) {
                            int index = nr + j + i * kxd;
                            gnoi[m++] = gno[index];
                        }
                    }
                }
                GridUtil.setLevelSlice(newVals[np], gnoi, sizeX, sizeY, z);
            }
        }
        newField.setSamples(newVals, false);
        return newField;
    }

    private static FlatField smooth9Point(FlatField slice, TupleType rangeType) throws VisADException, RemoteException {
        int jgymax;
        int jgxmax;
        float wt = 2.0f;
        float wtc = 1.0f;
        float wt4 = 4.0f;
        if (rangeType == null) {
            rangeType = GridUtil.makeNewParamType(GridUtil.getParamType(slice), "_SM9S");
        }
        FlatField newField = (FlatField)GridUtil.setParamType((FieldImpl)slice, rangeType, true);
        float[][] samples = slice.getFloats(false);
        GriddedSet domain = null;
        if (!(GridUtil.getSpatialDomain(slice) instanceof GriddedSet)) {
            return null;
        }
        domain = (GriddedSet)GridUtil.getSpatialDomain(slice);
        int[] lengths = domain.getLengths();
        int jgxmin = 1;
        int kxd = jgxmax = lengths[0];
        int jgymin = 1;
        int kyd = jgymax = lengths[1];
        int sizeX = jgxmax;
        int sizeY = jgymax;
        int sizeZ = 1;
        if (lengths.length > 2) {
            sizeZ = lengths[2];
        }
        int numParams = samples.length;
        float[] highs = domain.getHi();
        float[] lows = domain.getLow();
        boolean isCyclic = lows[0] == highs[0] % 360.0f;
        float[][] newVals = newField.getFloats(false);
        int nr = 9;
        for (int np = 0; np < numParams; ++np) {
            for (int z = 0; z < sizeZ; ++z) {
                int i;
                int j;
                float[] gno;
                float[] gni;
                float[] gnii = GridUtil.getLevelSlice(samples[np], sizeX, sizeY, z);
                float[] gnoi = GridUtil.getLevelSlice(newVals[np], sizeX, sizeY, z);
                jgxmax = sizeX;
                if (isCyclic) {
                    gni = GridUtil.extendGrid(gnii, nr, jgxmax, jgymax);
                    gno = new float[gni.length];
                    kxd = jgxmax += 2 * nr;
                } else {
                    gni = gnii;
                    gno = gnoi;
                }
                for (j = jgymin; j <= jgymax; ++j) {
                    for (i = jgxmin; i <= jgxmax; ++i) {
                        int ii = (j - 1) * kxd + i;
                        if (Float.isNaN(gni[ii - 1])) {
                            gno[ii - 1] = Float.NaN;
                            continue;
                        }
                        int ip1 = ii + 1;
                        float dip1 = i + 1 > jgxmax ? Float.NaN : gni[ip1 - 1];
                        int im1 = ii - 1;
                        float dim1 = i - 1 < jgxmin ? Float.NaN : gni[im1 - 1];
                        int jp1 = ii + kxd;
                        float djp1 = j + 1 > jgymax ? Float.NaN : gni[jp1 - 1];
                        int jm1 = ii - kxd;
                        float djm1 = j - 1 < jgymin ? Float.NaN : gni[jm1 - 1];
                        int imjm = jm1 - 1;
                        float dimjm = j - 1 < jgymin || i - 1 < jgxmin ? Float.NaN : gni[imjm - 1];
                        int ipjm = jm1 + 1;
                        float dipjm = j - 1 < jgymin || i + 1 > jgxmax ? Float.NaN : gni[ipjm - 1];
                        int imjp = jp1 - 1;
                        float dimjp = j + 1 > jgymax || i - 1 < jgxmin ? Float.NaN : gni[imjp - 1];
                        int ipjp = jp1 + 1;
                        float dipjp = j + 1 > jgymax || i + 1 > jgxmax ? Float.NaN : gni[ipjp - 1];
                        float dsum = gni[ii - 1] * wt4;
                        float wsum = wt4;
                        if (!Float.isNaN(dip1)) {
                            dsum += dip1 * wt;
                            wsum += wt;
                        } else {
                            dsum += gni[ii - 1] * wt;
                            wsum += wt;
                        }
                        if (!Float.isNaN(dim1)) {
                            dsum += dim1 * wt;
                            wsum += wt;
                        } else {
                            dsum += gni[ii - 1] * wt;
                            wsum += wt;
                        }
                        if (!Float.isNaN(djp1)) {
                            dsum += djp1 * wt;
                            wsum += wt;
                        } else {
                            dsum += gni[ii - 1] * wt;
                            wsum += wt;
                        }
                        if (!Float.isNaN(djm1)) {
                            dsum += djm1 * wt;
                            wsum += wt;
                        } else {
                            dsum += gni[ii - 1] * wt;
                            wsum += wt;
                        }
                        if (!Float.isNaN(dimjm)) {
                            dsum += dimjm * wtc;
                            wsum += wtc;
                        } else {
                            dsum += gni[ii - 1] * wtc;
                            wsum += wtc;
                        }
                        if (!Float.isNaN(dipjm)) {
                            dsum += dipjm * wtc;
                            wsum += wtc;
                        } else {
                            dsum += gni[ii - 1] * wtc;
                            wsum += wtc;
                        }
                        if (!Float.isNaN(dimjp)) {
                            dsum += dimjp * wtc;
                            wsum += wtc;
                        } else {
                            dsum += gni[ii - 1] * wtc;
                            wsum += wtc;
                        }
                        if (!Float.isNaN(dipjp)) {
                            dsum += dipjp * wtc;
                            wsum += wtc;
                        } else {
                            dsum += gni[ii - 1] * wtc;
                            wsum += wtc;
                        }
                        gno[ii - 1] = dsum / wsum;
                    }
                }
                if (isCyclic) {
                    int kxdi = kxd - 2 * nr;
                    int m = 0;
                    for (i = 0; i < kyd; ++i) {
                        for (j = 0; j < kxdi; ++j) {
                            int index = nr + j + i * kxd;
                            gnoi[m++] = gno[index];
                        }
                    }
                }
                GridUtil.setLevelSlice(newVals[np], gnoi, sizeX, sizeY, z);
            }
        }
        newField.setSamples(newVals, false);
        return newField;
    }

    private static FlatField smoothGaussian(FlatField slice, int filterLevel, TupleType rangeType) throws VisADException, RemoteException {
        float sgma;
        int nr;
        float[][] w = new float[100][100];
        int nwl = filterLevel;
        if (nwl <= 1) {
            nwl = 2;
        }
        if ((nr = (int)(2.0 * (double)(sgma = (float)((double)nwl / (Math.PI * Math.sqrt(2.0)))))) < 1) {
            nr = 1;
        }
        if (nr >= 100) {
            nr = 99;
        }
        if (rangeType == null) {
            rangeType = GridUtil.makeNewParamType(GridUtil.getParamType(slice), "_GWFS");
        }
        FlatField newField = (FlatField)GridUtil.setParamType((FieldImpl)slice, rangeType, true);
        float[][] samples = slice.getFloats(false);
        GriddedSet domain = null;
        if (!(GridUtil.getSpatialDomain(slice) instanceof GriddedSet)) {
            return null;
        }
        domain = (GriddedSet)GridUtil.getSpatialDomain(slice);
        int[] lengths = domain.getLengths();
        int kxd = lengths[0];
        int kyd = lengths[1];
        int sizeX = kxd;
        int sizeY = kyd;
        int sizeZ = 1;
        if (lengths.length > 2) {
            sizeZ = lengths[2];
        }
        float[] highs = domain.getHi();
        float[] lows = domain.getLow();
        boolean isCyclic = lows[0] == highs[0] % 360.0f;
        int numParams = samples.length;
        float[][] newVals = newField.getFloats(false);
        for (int np = 0; np < numParams; ++np) {
            for (int z = 0; z < sizeZ; ++z) {
                int i;
                int j;
                int iw;
                int is;
                int jw;
                float[] gnost;
                float[] gnist;
                float[] gnisti = GridUtil.getLevelSlice(samples[np], sizeX, sizeY, z);
                float[] gnosti = GridUtil.getLevelSlice(newVals[np], sizeX, sizeY, z);
                kxd = sizeX;
                if (isCyclic) {
                    gnist = GridUtil.extendGrid(gnisti, nr, kxd, kyd);
                    gnost = new float[gnist.length];
                    kxd += 2 * nr;
                } else {
                    gnist = gnisti;
                    gnost = gnosti;
                }
                float sumw = 0.0f;
                float sig2 = sgma * sgma;
                float aa = (float)(1.0 / ((double)sig2 * Math.PI));
                for (jw = 1; jw <= nr + 1; ++jw) {
                    is = jw == 1 ? 2 : jw;
                    for (iw = is; iw <= nr + 1; ++iw) {
                        float x = iw - 1;
                        float y = jw - 1;
                        w[iw - 1][jw - 1] = (float)((double)aa * Math.exp(-(x * x + y * y) / sig2));
                        w[jw - 1][iw - 1] = w[iw - 1][jw - 1];
                        if (jw == 1 || jw == iw) {
                            sumw += w[iw - 1][jw - 1];
                            continue;
                        }
                        sumw = (float)((double)sumw + 2.0 * (double)w[iw - 1][jw - 1]);
                    }
                }
                w[0][0] = 1.0f - (sumw *= 4.0f);
                for (int jj = 1; jj <= kyd; ++jj) {
                    for (int ii = 1; ii <= kxd; ++ii) {
                        int indx;
                        is = ii - nr;
                        int ie = ii + nr;
                        int js = jj - nr;
                        int je = jj + nr;
                        sumw = 0.0f;
                        float sumf = 0.0f;
                        for (j = js; j <= je; ++j) {
                            if (j < 1 || j > kyd) continue;
                            for (i = is; i <= ie; ++i) {
                                if (i < 1 || i > kxd) continue;
                                iw = Math.abs(i - ii) + 1;
                                jw = Math.abs(j - jj) + 1;
                                indx = (j - 1) * kxd + i;
                                if (Float.isNaN(gnist[indx - 1])) continue;
                                sumw += w[iw - 1][jw - 1];
                                sumf += gnist[indx - 1] * w[iw - 1][jw - 1];
                            }
                        }
                        indx = (jj - 1) * kxd + ii;
                        gnost[indx - 1] = !GridUtil.G_DIFFT(sumw, 0.0f, 1.0E-6f) && !Float.isNaN(gnist[indx - 1]) ? sumf / sumw : Float.NaN;
                    }
                }
                if (isCyclic) {
                    int kxdi = kxd - 2 * nr;
                    int m = 0;
                    for (i = 0; i < kyd; ++i) {
                        for (j = 0; j < kxdi; ++j) {
                            int index = nr + j + i * kxd;
                            gnosti[m++] = gnost[index];
                        }
                    }
                }
                GridUtil.setLevelSlice(newVals[np], gnosti, sizeX, sizeY, z);
            }
        }
        newField.setSamples(newVals, false);
        return newField;
    }

    private static FlatField smoothWeighted(FlatField slice, int radius, String type, TupleType rangeType) throws VisADException, RemoteException {
        float beszero = 3.8317f;
        int idist = radius;
        if (idist == 0) {
            return slice;
        }
        int nfp = Math.min(100, 2 * idist);
        float[][] fprint = new float[nfp][nfp];
        int npsq = idist * idist;
        if (rangeType == null) {
            rangeType = GridUtil.makeNewParamType(GridUtil.getParamType(slice), "_" + type);
        }
        FlatField newField = (FlatField)GridUtil.setParamType((FieldImpl)slice, rangeType, true);
        float[][] samples = slice.getFloats(false);
        GriddedSet domain = null;
        if (!(GridUtil.getSpatialDomain(slice) instanceof GriddedSet)) {
            return null;
        }
        domain = (GriddedSet)GridUtil.getSpatialDomain(slice);
        int[] lengths = domain.getLengths();
        int njx = lengths[0];
        int niy = lengths[1];
        int sizeX = njx;
        int sizeY = niy;
        int sizeZ = 1;
        if (lengths.length > 2) {
            sizeZ = lengths[2];
        }
        float[] highs = domain.getHi();
        float[] lows = domain.getLow();
        boolean isCyclic = lows[0] == highs[0] % 360.0f;
        int numParams = samples.length;
        float[][] newValues = newField.getFloats(false);
        for (int np = 0; np < numParams; ++np) {
            for (int z = 0; z < sizeZ; ++z) {
                int index;
                float[] work;
                float[] pslab;
                int j;
                int i;
                float[] pslabi = GridUtil.getLevelSlice(samples[np], sizeX, sizeY, z);
                float[] worki = GridUtil.getLevelSlice(newValues[np], sizeX, sizeY, z);
                if (type.equals(SMOOTH_CRESSMAN)) {
                    for (i = 0; i < nfp; ++i) {
                        for (j = 0; j < nfp; ++j) {
                            float distsq = (float)(Math.pow(i - idist, 2.0) + Math.pow(j - idist, 2.0));
                            fprint[j][i] = Math.max(((float)npsq - distsq) / ((float)npsq + distsq), 0.0f);
                        }
                    }
                } else if (type.equals(SMOOTH_CIRCULAR)) {
                    for (i = 0; i < nfp; ++i) {
                        for (j = 0; j < nfp; ++j) {
                            float dist = (float)((double)(beszero / (float)idist) * Math.sqrt(Math.pow(i - idist, 2.0) + Math.pow(j - idist, 2.0)));
                            fprint[j][i] = i == idist && j == idist ? 0.5f : (float)Math.max(0.0, (double)(GridUtil.bes(dist) / dist));
                        }
                    }
                } else if (type.equals(SMOOTH_RECTANGULAR)) {
                    for (i = 0; i < nfp; ++i) {
                        for (j = 0; j < nfp; ++j) {
                            float yfac;
                            float xfac;
                            if (j == idist) {
                                xfac = 1.0f;
                            } else {
                                float xdist = (float)Math.PI / (float)idist * (float)(j - idist);
                                xfac = (float)Math.sin(xdist) / xdist;
                            }
                            if (i == idist) {
                                yfac = 1.0f;
                            } else {
                                float ydist = (float)Math.PI / (float)idist * (float)(i - idist);
                                yfac = (float)Math.sin(ydist) / ydist;
                            }
                            fprint[j][i] = xfac * yfac;
                        }
                    }
                }
                njx = sizeX;
                if (isCyclic) {
                    pslab = GridUtil.extendGrid(pslabi, idist, njx, niy);
                    work = new float[pslab.length];
                    njx += 2 * idist;
                } else {
                    pslab = pslabi;
                    work = worki;
                }
                for (i = 0; i < niy; ++i) {
                    for (j = 0; j < njx; ++j) {
                        index = j + i * njx;
                        if (!Float.isNaN(pslab[index])) {
                            float tot = 0.0f;
                            float totwt = 0.0f;
                            int is = Math.max(0, i - idist);
                            int ie = Math.min(niy - 1, i + idist);
                            int js = Math.max(0, j - idist);
                            int je = Math.min(njx - 1, j + idist);
                            for (int ireg = is; ireg < ie; ++ireg) {
                                int ifp = ireg - i + idist;
                                for (int jreg = js; jreg < je; ++jreg) {
                                    int jfp = jreg - j + idist;
                                    int psindex = ireg * njx + jreg;
                                    if (Float.isNaN(pslab[psindex])) continue;
                                    totwt += fprint[jfp][ifp];
                                    tot += fprint[jfp][ifp] * pslab[psindex];
                                }
                            }
                            work[index] = tot / totwt;
                            continue;
                        }
                        work[index] = Float.NaN;
                    }
                }
                if (isCyclic) {
                    int njxi = njx - 2 * idist;
                    int m = 0;
                    for (int i2 = 0; i2 < niy; ++i2) {
                        for (int j2 = 0; j2 < njxi; ++j2) {
                            index = idist + j2 + i2 * njx;
                            worki[m++] = work[index];
                        }
                    }
                }
                GridUtil.setLevelSlice(newValues[np], worki, sizeX, sizeY, z);
            }
        }
        newField.setSamples(newValues, false);
        return newField;
    }

    private static float[] extendGrid(float[] data, int ncols, int nx, int ny) {
        float[] newData = new float[data.length + ny * ncols * 2];
        int index = 0;
        int l = 0;
        for (int i = 0; i < ny; ++i) {
            int j;
            for (j = ncols; j > 0; --j) {
                index = nx - j - 1 + i * nx;
                newData[l++] = data[index];
            }
            for (j = 0; j < nx; ++j) {
                index = j + i * nx;
                newData[l++] = data[index];
            }
            for (j = 0; j < ncols; ++j) {
                index = j + 1 + i * nx;
                newData[l++] = data[index];
            }
        }
        return newData;
    }

    private static float bes(float x) {
        float rint = 0.0f;
        for (int i = 0; i < 1000; ++i) {
            float u = (float)i * 0.001f - 5.0E-4f;
            rint += (float)(Math.sqrt(1.0 - (double)(u * u)) * Math.cos(x * u) * 0.001);
        }
        return (float)((double)(2.0f * x * rint) / (4.0 * Math.atan(1.0)));
    }

    private static boolean G_DIFFT(float x, float y, float val) {
        return Math.abs(x - y) < val;
    }

    private static boolean isZDescending(FieldImpl grid) throws VisADException {
        Gridded3DSet domain = (Gridded3DSet)GridUtil.getSpatialDomain(grid);
        float first = 0.0f;
        float last = 0.0f;
        boolean notLinear = true;
        if (domain instanceof Linear3DSet) {
            Linear1DSet zSet = ((Linear3DSet)domain).getZ();
            first = (float)zSet.getFirst();
            last = (float)zSet.getLast();
            notLinear = false;
        } else {
            int[] lens = domain.getLengths();
            float[][] samples = domain.getSamples(false);
            first = samples[2][0];
            last = samples[2][lens[0] * lens[1] + 1];
        }
        System.out.println("not linear = " + notLinear);
        return notLinear;
    }

    public static float[][] makeGrid(float[][] grid2D, int numCols, int numRows, float missingValue) {
        return GridUtil.makeGrid(new float[][][]{grid2D}, numCols, numRows, missingValue);
    }

    public static float[][] makeGrid(float[][][] grid2D, int numCols, int numRows, float missingValue) {
        int numFields = grid2D.length;
        float[][] gridValues = new float[numFields][numCols * numRows];
        int m = 0;
        for (int fieldIdx = 0; fieldIdx < numFields; ++fieldIdx) {
            for (int j = 0; j < numRows; ++j) {
                for (int i = 0; i < numCols; ++i) {
                    float value = grid2D[fieldIdx][j][i];
                    if (value == missingValue) {
                        value = Float.NaN;
                    }
                    gridValues[fieldIdx][m] = value;
                    ++m;
                }
            }
        }
        return gridValues;
    }

    public static void fillMissing(float[][] grid2D, float missingValue) {
        int numCols = grid2D[0].length;
        int numRows = grid2D.length;
        for (int x = 0; x < numCols; ++x) {
            for (int y = 0; y < numRows; ++y) {
                if (grid2D[y][x] == grid2D[y][x]) continue;
                int delta = numCols / 100;
                boolean foundNonMissingNearby = false;
                for (int dx = -delta; dx < delta; ++dx) {
                    for (int dy = -delta; dy < delta; ++dy) {
                        int nx = x + dx;
                        int ny = y + dy;
                        if (nx < 0 || nx >= grid2D[0].length || ny < 0 || ny >= grid2D.length || grid2D[ny][nx] != grid2D[ny][nx] || grid2D[ny][nx] == missingValue) continue;
                        foundNonMissingNearby = true;
                    }
                }
                if (foundNonMissingNearby) continue;
                grid2D[y][x] = missingValue;
            }
        }
        for (int pass = 0; pass < 1; ++pass) {
            int x;
            int y;
            int y2;
            int x2;
            boolean anyMissing = false;
            for (x2 = 0; x2 < numCols; ++x2) {
                for (y2 = 0; y2 < numRows; ++y2) {
                    if (!GridUtil.fillMissingFromNeighbors(grid2D, x2, y2, missingValue)) continue;
                    anyMissing = true;
                }
            }
            if (anyMissing) {
                for (y = 0; y < numRows; ++y) {
                    for (x = 0; x < numCols; ++x) {
                        if (!GridUtil.fillMissingFromNeighbors(grid2D, x, y, missingValue)) continue;
                        anyMissing = true;
                    }
                }
            }
            if (anyMissing) {
                for (y = numRows - 1; y >= 0; --y) {
                    for (x = numCols - 1; x >= 0; --x) {
                        if (!GridUtil.fillMissingFromNeighbors(grid2D, x, y, missingValue)) continue;
                        anyMissing = true;
                    }
                }
            }
            if (anyMissing) {
                for (x2 = numCols - 1; x2 >= 0; --x2) {
                    for (y2 = numRows - 1; y2 >= 0; --y2) {
                        if (!GridUtil.fillMissingFromNeighbors(grid2D, x2, y2, missingValue)) continue;
                        anyMissing = true;
                    }
                }
            }
            if (!anyMissing) break;
        }
    }

    private static boolean fillMissingFromNeighbors(float[][] grid, int x, int y, float missingValue) {
        if (grid[y][x] == grid[y][x]) {
            return false;
        }
        if (grid[y][x] == missingValue) {
            return false;
        }
        float sum = 0.0f;
        int cnt = 0;
        for (int dx = -1; dx < 2; ++dx) {
            for (int dy = -1; dy < 2; ++dy) {
                int nx = x + dx;
                int ny = y + dy;
                if (nx < 0 || nx >= grid[0].length || ny < 0 || ny >= grid.length || grid[ny][nx] != grid[ny][nx] || grid[ny][nx] == missingValue) continue;
                sum += grid[ny][nx];
                ++cnt;
            }
        }
        if (cnt > 0) {
            grid[y][x] = sum / (float)cnt;
        }
        return true;
    }

    public static FieldImpl lonFlip(FieldImpl grid) throws VisADException, RemoteException {
        FieldImpl flipped = grid;
        if (GridUtil.isSequence(grid)) {
            Set timeDomain = grid.getDomainSet();
            flipped = new FieldImpl((FunctionType)grid.getType(), timeDomain);
            FieldImpl flippedField = null;
            for (int timeStepIdx = 0; timeStepIdx < timeDomain.getLength(); ++timeStepIdx) {
                FieldImpl sample = (FieldImpl)grid.getSample(timeStepIdx, false);
                if (sample == null) continue;
                if (!GridUtil.isSequence(sample)) {
                    flippedField = GridUtil.lonFlipFF((FlatField)sample);
                } else {
                    Set ensDomain = sample.getDomainSet();
                    flippedField = new FieldImpl((FunctionType)sample.getType(), ensDomain);
                    for (int j = 0; j < ensDomain.getLength(); ++j) {
                        FlatField innerField = (FlatField)sample.getSample(j, false);
                        if (innerField == null) continue;
                        FlatField flippedFF = GridUtil.lonFlipFF(innerField);
                        flippedField.setSample(j, flippedFF, false, false);
                    }
                }
                flipped.setSample(timeStepIdx, flippedField, false, false);
            }
        } else {
            flipped = GridUtil.lonFlipFF((FlatField)grid);
        }
        return flipped;
    }

    private static FlatField lonFlipFF(FlatField grid) throws VisADException, RemoteException {
        FlatField flipped = grid;
        GriddedSet domainSet = (GriddedSet)grid.getDomainSet();
        RealTupleType domainType = ((SetType)domainSet.getType()).getDomain();
        CoordinateSystem refCS = domainSet.getCoordinateSystem();
        RealTupleType refType = null;
        float[] highs = domainSet.getHi();
        float[] lows = domainSet.getLow();
        int[] lengths = domainSet.getLengths();
        int sizeX = lengths[0];
        int sizeY = lengths[1];
        boolean hasZ = domainSet.getDimension() == 3;
        int sizeZ = 1;
        if (hasZ && domainSet.getManifoldDimension() == 3) {
            sizeZ = lengths[2];
        }
        if (refCS != null) {
            refType = refCS.getReference();
        }
        int halfX = sizeX / 2;
        boolean is360 = highs[0] > 300.0f;
        boolean isCyclic = GridUtil.isLonCyclic(lows[0], highs[0]);
        if (!isCyclic) {
            if (domainSet instanceof LinearSet) {
                double last;
                double newLast;
                Linear1DSet xSet = ((LinearSet)((Object)domainSet)).getLinear1DComponent(0);
                double step = xSet.getStep();
                double first = xSet.getFirst();
                if (!GridUtil.isLonCyclic(first, newLast = (last = xSet.getLast()) + step)) {
                    throw new VisADException("not a cyclic grid");
                }
            } else {
                double first = lows[0];
                double last = highs[0];
                double step = Math.abs(last - first + (double)(1 / sizeX));
                double newLast = last + step;
                if (!GridUtil.isLonCyclic(first, newLast)) {
                    throw new VisADException("not a cyclic grid");
                }
            }
        }
        float[][] values = grid.getFloats(false);
        float[][] newValues = new float[values.length][values[0].length];
        if (domainSet instanceof LinearSet) {
            // empty if block
        }
        float[][] samples = domainSet.getSamples(false);
        float[][] newSamples = new float[samples.length][samples[0].length];
        for (int k = 0; k < sizeZ; ++k) {
            for (int j = 0; j < sizeY; ++j) {
                for (int i = 0; i < sizeX; ++i) {
                    float oldX;
                    int oldIndex = k * sizeX * sizeY + j * sizeX + i;
                    int newIndex = (i < halfX ? i + halfX : i - halfX) + j * sizeX + k * sizeX * sizeY;
                    if (isCyclic && i == sizeX - 1) {
                        oldIndex -= halfX;
                        newIndex += halfX;
                    }
                    float newX = oldX = samples[0][oldIndex];
                    if (is360) {
                        if (oldX >= 180.0f) {
                            newX -= 360.0f;
                        }
                    } else if (oldX < 0.0f) {
                        newX += 360.0f;
                    }
                    if (isCyclic && i == sizeX - 1) {
                        newX = newSamples[0][newIndex - (sizeX - 1)] + 360.0f;
                    }
                    newSamples[0][newIndex] = newX;
                    newSamples[1][newIndex] = samples[1][oldIndex];
                    if (hasZ) {
                        newSamples[2][newIndex] = samples[2][oldIndex];
                    }
                    for (int l = 0; l < newValues.length; ++l) {
                        newValues[l][newIndex] = values[l][oldIndex];
                    }
                }
            }
        }
        GriddedSet newDomain = GriddedSet.create(domainType, newSamples, lengths, domainSet.getCoordinateSystem(), domainSet.getSetUnits(), domainSet.getSetErrors());
        flipped = new FlatField((FunctionType)grid.getType(), (Set)newDomain, grid.getRangeCoordinateSystem()[0], grid.getRangeSets(), ucar.visad.Util.getRangeUnits(grid));
        flipped.setSamples(newValues, false);
        return flipped;
    }

    public static boolean isLonCyclic(double first, double last) {
        return GridUtil.isLonCyclic(first, last, 5.0E-4);
    }

    public static boolean isLonCyclic(double first, double last, double epsilon) {
        return Util.isApproximatelyEqual(first + 360.0, last, epsilon);
    }

    public static List<DrawingGlyph> read(String filename) {
        List lglyph = null;
        try {
            Element root = XmlUtil.getRoot(filename, Class.class);
            lglyph = GridUtil.parseXml(root, false);
        }
        catch (Exception exc) {
            LogUtil.logException("Importing drawing", exc);
        }
        return lglyph;
    }

    public static List parseXml(Element root, boolean initialXml) throws VisADException, RemoteException {
        ArrayList<PolyGlyph> glyphList = new ArrayList<PolyGlyph>();
        NodeList elements = XmlUtil.getElements(root);
        for (int i = 0; i < elements.getLength(); ++i) {
            Element child = (Element)elements.item(i);
            PolyGlyph glyph = null;
            if (child.getTagName().equals("polygon")) {
                glyph = new PolyGlyph();
            } else {
                System.err.println("Unknown shape tag:" + child.getTagName());
            }
            if (glyph == null) continue;
            ((DrawingGlyph)glyph).initFromXml(null, child);
            glyphList.add(glyph);
        }
        return glyphList;
    }

    public static UnionSet glyphsToMap(GriddedSet domainSet, List glyphs) throws Exception {
        MapMaker mapMaker = new MapMaker();
        Gridded2DSet domain2D = GridUtil.makeDomain2D(domainSet);
        boolean isLatLon = GridUtil.isLatLonOrder(domainSet);
        int lonIndex = isLatLon ? 1 : 0;
        Unit[] du = domain2D.getSetUnits();
        for (DrawingGlyph glyph : glyphs) {
            int i;
            float[][] lls = glyph.getLatLons();
            if (du[lonIndex] != null) {
                if (du[lonIndex].isConvertible(CommonUnit.radian)) {
                    lls[1] = GeoUtils.normalizeLongitude(lls[1]);
                } else if (du[lonIndex].isConvertible(CommonUnits.KILOMETER)) {
                    for (i = 0; i < lls[1].length; ++i) {
                        lls[1][i] = (float)LatLonPointImpl.lonNormal(lls[1][i]);
                    }
                }
            } else {
                for (i = 0; i < lls[1].length; ++i) {
                    lls[1][i] = (float)LatLonPointImpl.lonNormal(lls[1][i]);
                }
            }
            mapMaker.addMap(lls);
        }
        return mapMaker.getMaps();
    }

    public static class Grid2D {
        float[][] lats;
        float[][] lons;
        float[][][] values;

        public Grid2D(float[][] lats, float[][] lons, float[][][] values) {
            this.lats = lats;
            this.lons = lons;
            this.values = values;
        }

        public float[][] getlons() {
            return this.lons;
        }

        public float[][] getlats() {
            return this.lats;
        }

        public float[][][] getvalues() {
            return this.values;
        }
    }
}

