/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.data.grid;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import ucar.unidata.data.DataUtil;
import ucar.unidata.data.grid.DerivedGridFactory;
import ucar.unidata.data.grid.GridUtil;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.util.LogUtil;
import ucar.visad.quantities.CommonUnits;
import visad.CoordinateSystem;
import visad.Data;
import visad.DateTime;
import visad.DoubleSet;
import visad.FieldImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.Gridded3DSet;
import visad.GriddedSet;
import visad.MathType;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.SampledSet;
import visad.Set;
import visad.SetType;
import visad.SingletonSet;
import visad.Unit;
import visad.VisADException;
import visad.georef.EarthLocationLite;
import visad.georef.LatLonPoint;

public class GridTrajectory {
    public static List<FieldImpl> combineGridsArray(FieldImpl grid1, FieldImpl grid2, FieldImpl grid3, FieldImpl grid4) throws VisADException, RemoteException, Exception {
        ExecutorService executor = Executors.newFixedThreadPool(4);
        VarNClone pt = new VarNClone(grid1);
        Future<Object> future1 = executor.submit(pt);
        VarNClone pt1 = new VarNClone(grid2);
        Future<Object> future2 = executor.submit(pt1);
        VarNClone pt2 = new VarNClone(grid3);
        Future<Object> future3 = executor.submit(pt2);
        VarNClone pt3 = new VarNClone(grid4);
        Future<Object> future4 = executor.submit(pt3);
        FieldImpl u = (FieldImpl)future1.get();
        FieldImpl v = (FieldImpl)future2.get();
        FieldImpl pw = (FieldImpl)future3.get();
        FieldImpl s = (FieldImpl)future4.get();
        ArrayList<FieldImpl> flist = new ArrayList<FieldImpl>();
        flist.add(u);
        flist.add(v);
        flist.add(pw);
        flist.add(s);
        return flist;
    }

    public static List<FieldImpl> combineGridsArray(FieldImpl grid1, FieldImpl grid2, FieldImpl grid3) throws VisADException, RemoteException, Exception {
        ExecutorService executor = Executors.newFixedThreadPool(4);
        VarNClone pt = new VarNClone(grid1);
        Future<Object> future1 = executor.submit(pt);
        VarNClone pt1 = new VarNClone(grid2);
        Future<Object> future2 = executor.submit(pt1);
        VarNClone pt2 = new VarNClone(grid3);
        Future<Object> future3 = executor.submit(pt2);
        FieldImpl u = (FieldImpl)future1.get();
        FieldImpl v = (FieldImpl)future2.get();
        FieldImpl s = (FieldImpl)future3.get();
        ArrayList<FieldImpl> flist = new ArrayList<FieldImpl>();
        flist.add(u);
        flist.add(v);
        flist.add(s);
        return flist;
    }

    public static List<FieldImpl> combineGridsArray(FieldImpl grid1, FieldImpl grid2) throws VisADException, RemoteException, Exception {
        ExecutorService executor = Executors.newFixedThreadPool(4);
        VarNClone pt = new VarNClone(grid1);
        Future<Object> future1 = executor.submit(pt);
        VarNClone pt1 = new VarNClone(grid2);
        Future<Object> future2 = executor.submit(pt1);
        FieldImpl u = (FieldImpl)future1.get();
        FieldImpl v = (FieldImpl)future2.get();
        ArrayList<FieldImpl> flist = new ArrayList<FieldImpl>();
        flist.add(u);
        flist.add(v);
        return flist;
    }

    public static FieldImpl createTrajectoryGrid(FieldImpl uFI0, FieldImpl vFI0, FieldImpl sFI0, FieldImpl s0FI) throws VisADException, RemoteException, Exception {
        if (GridUtil.isVolume(uFI0) || GridUtil.isVolume(vFI0) || GridUtil.isVolume(sFI0)) {
            throw new IllegalArgumentException("Grids U, V W and S can not be 3D volume");
        }
        long start = System.currentTimeMillis();
        ExecutorService executor = Executors.newFixedThreadPool(4);
        Varbar pt = new Varbar(uFI0);
        Future<Object> future = executor.submit(pt);
        Varbar pt1 = new Varbar(vFI0);
        Future<Object> future1 = executor.submit(pt1);
        Varbar pt3 = new Varbar(sFI0);
        Future<Object> future3 = executor.submit(pt3);
        FieldImpl uFI = (FieldImpl)future.get();
        FieldImpl vFI = (FieldImpl)future1.get();
        FieldImpl sFI = (FieldImpl)future3.get();
        try {
            if (GridUtil.is3D(sFI0)) {
                sFI = GridUtil.make2DGridFromSlice(sFI, false);
            }
            if (GridUtil.is3D(uFI0)) {
                uFI = GridUtil.make2DGridFromSlice(uFI, false);
            }
            if (GridUtil.is3D(vFI0)) {
                vFI = GridUtil.make2DGridFromSlice(vFI, false);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        start = System.currentTimeMillis();
        Set timeSet = sFI.getDomainSet();
        int numTimes = timeSet.getLength();
        Unit timeUnit = timeSet.getSetUnits()[0];
        Unit paramUnit = ((FlatField)sFI.getSample(0)).getRangeUnits()[0][0];
        FunctionType rt = (FunctionType)((FlatField)sFI.getSample(0)).getType();
        String paramName = rt.getFlatRange().getRealComponents()[0].getName();
        double[] timeVals = timeSet.getDoubles()[0];
        SampledSet domain0 = GridUtil.getSpatialDomain(s0FI);
        int numPoints = domain0.getLength();
        float[][] geoVals = GridUtil.getEarthLocationPoints((GriddedSet)domain0);
        double[] ttts = timeSet.getDoubles()[0];
        boolean isLatLon = GridUtil.isLatLonOrder(domain0);
        int latIndex = isLatLon ? 0 : 1;
        int lonIndex = isLatLon ? 1 : 0;
        boolean haveAlt = geoVals.length > 2;
        boolean normalizeLon = true;
        List<TrajInfo> tj = GridTrajectory.calculateTrackPoints(uFI, vFI, null, sFI, ttts, geoVals, numPoints, numTimes, latIndex, lonIndex, haveAlt, normalizeLon, null, false);
        int numParcels = numPoints;
        FunctionType ft = new FunctionType(RealType.Generic, new FunctionType(RealTupleType.SpatialEarth3DTuple, RealType.getRealType(paramName)));
        List<FlatField> tracks = GridTrajectory.createTracks(paramName, tj, timeSet, ft, paramUnit, numParcels);
        FlatField mergedTracks = DerivedGridFactory.mergeTracks(tracks);
        FunctionType fiType = new FunctionType(RealType.Time, mergedTracks.getType());
        DateTime endTime = new DateTime(timeVals[numTimes - 1], timeUnit);
        FieldImpl fi = new FieldImpl(fiType, new SingletonSet(new RealTuple(new Real[]{endTime})));
        fi.setSample(0, (Data)mergedTracks, false);
        return fi;
    }

    public static FieldImpl createTrajectoryGrid(FieldImpl uFI0, FieldImpl vFI0, FieldImpl pwFI0, FieldImpl sFI0, FieldImpl s0FI) throws VisADException, RemoteException, Exception {
        FieldImpl wFI;
        long start = System.currentTimeMillis();
        ExecutorService executor = Executors.newFixedThreadPool(4);
        Varbar pt = new Varbar(uFI0);
        Future<Object> future = executor.submit(pt);
        Varbar pt1 = new Varbar(vFI0);
        Future<Object> future1 = executor.submit(pt1);
        Varbar pt2 = new Varbar(pwFI0);
        Future<Object> future2 = executor.submit(pt2);
        Varbar pt3 = new Varbar(sFI0);
        Future<Object> future3 = executor.submit(pt3);
        FieldImpl uFI = (FieldImpl)future.get();
        FieldImpl vFI = (FieldImpl)future1.get();
        FieldImpl pwFI = (FieldImpl)future2.get();
        FieldImpl sFI = (FieldImpl)future3.get();
        start = System.currentTimeMillis();
        Set timeSet = sFI.getDomainSet();
        int numTimes = timeSet.getLength();
        Unit timeUnit = timeSet.getSetUnits()[0];
        Unit paramUnit = ((FlatField)sFI.getSample(0)).getRangeUnits()[0][0];
        FunctionType rt = (FunctionType)((FlatField)sFI.getSample(0)).getType();
        String paramName = rt.getFlatRange().getRealComponents()[0].getName();
        double[] timeVals = timeSet.getDoubles()[0];
        SampledSet domain0 = GridUtil.getSpatialDomain(s0FI);
        Unit rgUnit = ((FlatField)pwFI.getSample(0)).getRangeUnits()[0][0];
        if (Unit.canConvert(rgUnit, CommonUnits.METERS_PER_SECOND)) {
            wFI = pwFI;
        } else {
            FlatField pFI = DerivedGridFactory.createPressureGridFromDomain((FlatField)pwFI.getSample(0));
            FieldImpl hPI = DerivedGridFactory.convertPressureToHeight(pFI);
            wFI = DerivedGridFactory.convertPressureVelocityToHeightVelocity(pwFI, hPI, null);
        }
        int numPoints = domain0.getLength();
        float[][] geoVals = GridUtil.getEarthLocationPoints((GriddedSet)domain0);
        double[] ttts = timeSet.getDoubles()[0];
        boolean isLatLon = GridUtil.isLatLonOrder(domain0);
        int latIndex = isLatLon ? 0 : 1;
        int lonIndex = isLatLon ? 1 : 0;
        boolean haveAlt = geoVals.length > 2;
        boolean normalizeLon = true;
        List<TrajInfo> tj = GridTrajectory.calculateTrackPoints(uFI, vFI, wFI, sFI, ttts, geoVals, numPoints, numTimes, latIndex, lonIndex, haveAlt, normalizeLon, null, false);
        int numParcels = numPoints;
        FunctionType ft = new FunctionType(RealType.Generic, new FunctionType(RealTupleType.SpatialEarth3DTuple, RealType.getRealType(paramName)));
        List<FlatField> tracks = GridTrajectory.createTracks(paramName, tj, timeSet, ft, paramUnit, numParcels);
        FlatField mergedTracks = DerivedGridFactory.mergeTracks(tracks);
        FunctionType fiType = new FunctionType(RealType.Time, mergedTracks.getType());
        DateTime endTime = new DateTime(timeVals[numTimes - 1], timeUnit);
        FieldImpl fi = new FieldImpl(fiType, new SingletonSet(new RealTuple(new Real[]{endTime})));
        fi.setSample(0, (Data)mergedTracks, false);
        return fi;
    }

    public static FlatField createSingleTraj(String paramName, float[] lats, float[] lons, float[] alts, double[] param) throws Exception {
        float[][] trajCoords = new float[][]{lons, lats, alts};
        Gridded3DSet domain = new Gridded3DSet((MathType)RealTupleType.SpatialEarth3DTuple, (float[][])trajCoords, trajCoords[0].length);
        FunctionType fncType = new FunctionType(RealTupleType.SpatialEarth3DTuple, RealType.getRealType(paramName));
        FlatField traj = new FlatField(fncType, domain);
        traj.setSamples(new double[][]{param}, false);
        return traj;
    }

    public static List<TrajInfo> calculateTrackPoints(FieldImpl uFI0, FieldImpl vFI0, FieldImpl wFI0, FieldImpl sFI0, double[] ttts, float[][] geoVals, int numPoints, int numTimes, int latIndex, int lonIndex, boolean haveAlt, boolean normalizeLon, Real clevel, boolean backward) throws Exception {
        ExecutorService executor = Executors.newFixedThreadPool(8);
        Varbar pt0 = new Varbar(uFI0);
        Future<Object> future0 = executor.submit(pt0);
        Varbar pt1 = new Varbar(vFI0);
        Future<Object> future1 = executor.submit(pt1);
        Future<Object> future2 = null;
        if (wFI0 != null) {
            Varbar pt2 = new Varbar(wFI0);
            future2 = executor.submit(pt2);
        }
        Varbar pt3 = new Varbar(sFI0);
        Future<Object> future3 = executor.submit(pt3);
        FieldImpl uFI = (FieldImpl)future0.get();
        FieldImpl vFI = (FieldImpl)future1.get();
        FieldImpl wFI = null;
        if (wFI0 != null) {
            wFI = (FieldImpl)future2.get();
        }
        FieldImpl sFI = (FieldImpl)future3.get();
        FieldImpl uvFI = DerivedGridFactory.createTrueFlowVectors(uFI, vFI);
        uFI = DerivedGridFactory.getUComponent(uvFI);
        vFI = DerivedGridFactory.getVComponent(uvFI);
        if (wFI0 == null && clevel != null && haveAlt) {
            uFI = GridUtil.make2DGridFromSlice(GridUtil.sliceAtLevel(uFI, clevel));
            vFI = GridUtil.make2DGridFromSlice(GridUtil.sliceAtLevel(vFI, clevel));
            SampledSet domain0 = GridUtil.getSpatialDomain(sFI);
            sFI = domain0.getManifoldDimension() == 3 ? GridUtil.make2DGridFromSlice(GridUtil.sliceAtLevel(sFI, clevel)) : GridUtil.make2DGridFromSlice(sFI, false);
        } else if (!haveAlt) {
            uFI = GridUtil.make2DGridFromSlice(uFI, false);
            vFI = GridUtil.make2DGridFromSlice(vFI, false);
            sFI = GridUtil.make2DGridFromSlice(sFI, false);
        }
        LogUtil.message("Calculating grid trajectories...");
        ArrayList<TrajInfo> result = new ArrayList<TrajInfo>();
        ArrayList<Future<TrajInfo>> pthreads = new ArrayList<Future<TrajInfo>>();
        for (int i = 0; i < numPoints; ++i) {
            float f = geoVals[latIndex][i];
            float lon = geoVals[lonIndex][i];
            if (normalizeLon) {
                lon = (float)LatLonPointImpl.lonNormal(lon);
            }
            float alt = haveAlt ? geoVals[2][i] : 0.0f;
            pointsThredds pt = new pointsThredds(uFI, vFI, wFI, sFI, ttts, f, lon, alt, numTimes, backward);
            Future<TrajInfo> future = executor.submit(pt);
            pthreads.add(future);
        }
        for (Future future : pthreads) {
            try {
                result.add((TrajInfo)future.get());
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public static TrajInfo calculateSingleTrackPoints(FieldImpl uFI, FieldImpl vFI, FieldImpl sFI, double[] ttts, float lat0, float lon0, float alt0, int numTimes) {
        float radius = 6371000.0f;
        float f = 57.295784f;
        TrajInfo trajInfo = new TrajInfo(numTimes);
        try {
            float[] u = new float[numTimes];
            float[] v = new float[numTimes];
            for (int timeStepIdx = 0; timeStepIdx < numTimes; ++timeStepIdx) {
                if (timeStepIdx == 0) {
                    trajInfo.lats[timeStepIdx] = lat0;
                    trajInfo.lons[timeStepIdx] = lon0;
                    trajInfo.alts[timeStepIdx] = alt0;
                    EarthLocationLite el = new EarthLocationLite(lat0, lon0, alt0);
                    LatLonPoint llp = el.getLatLonPoint();
                    FieldImpl ssample = GridUtil.sample(sFI, llp, 100);
                    Data srt = ssample.getSample(0);
                    Real sreal = srt instanceof RealTuple ? (Real)((RealTuple)srt).getComponent(0) : (Real)srt;
                    trajInfo.parcels[timeStepIdx] = (float)sreal.getValue();
                    FieldImpl usample = GridUtil.sample(uFI, llp, 100);
                    Data urt = usample.getSample(0);
                    Real ureal = urt instanceof RealTuple ? (Real)((RealTuple)urt).getComponent(0) : (Real)urt;
                    u[timeStepIdx] = (float)ureal.getValue();
                    FieldImpl vsample = GridUtil.sample(vFI, llp, 100);
                    Data vrt = vsample.getSample(0);
                    Real vreal = vrt instanceof RealTuple ? (Real)((RealTuple)vrt).getComponent(0) : (Real)vrt;
                    v[timeStepIdx] = (float)vreal.getValue();
                    continue;
                }
                double delt = ttts[timeStepIdx] - ttts[timeStepIdx - 1];
                float lat = trajInfo.lats[timeStepIdx - 1];
                float lon = trajInfo.lons[timeStepIdx - 1];
                float alt = trajInfo.alts[timeStepIdx - 1];
                float lat1 = (float)((double)lat + 57.29578399658203 * ((double)v[timeStepIdx - 1] * delt) / (double)(6371000.0f + alt));
                float lon1 = (float)((double)lon + 57.29578399658203 * ((double)u[timeStepIdx - 1] * delt) / (double)(6371000.0f + alt));
                float alt1 = alt;
                EarthLocationLite el = new EarthLocationLite(lat1, lon1, alt1);
                LatLonPoint llp = el.getLatLonPoint();
                FieldImpl usample = GridUtil.sample(uFI, llp, 100);
                FieldImpl vsample = GridUtil.sample(vFI, llp, 100);
                FieldImpl ssample = GridUtil.sample(sFI, llp, 100);
                if (usample == null && vsample == null && ssample == null) {
                    trajInfo.lats[timeStepIdx] = trajInfo.lats[timeStepIdx - 1];
                    trajInfo.lons[timeStepIdx] = trajInfo.lons[timeStepIdx - 1];
                    trajInfo.alts[timeStepIdx] = trajInfo.alts[timeStepIdx - 1];
                    trajInfo.parcels[timeStepIdx] = trajInfo.parcels[timeStepIdx - 1];
                    continue;
                }
                trajInfo.lats[timeStepIdx] = lat1;
                trajInfo.lons[timeStepIdx] = lon1;
                trajInfo.alts[timeStepIdx] = alt1;
                Data urt = usample.getSample(timeStepIdx);
                Real ureal = urt instanceof RealTuple ? (Real)((RealTuple)urt).getComponent(0) : (Real)urt;
                u[timeStepIdx] = (float)ureal.getValue();
                Data vrt = vsample.getSample(timeStepIdx);
                Real vreal = vrt instanceof RealTuple ? (Real)((RealTuple)vrt).getComponent(0) : (Real)vrt;
                v[timeStepIdx] = (float)vreal.getValue();
                Data srt = ssample.getSample(timeStepIdx);
                Real sreal = srt instanceof RealTuple ? (Real)((RealTuple)srt).getComponent(0) : (Real)srt;
                trajInfo.parcels[timeStepIdx] = (float)sreal.getValue();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return trajInfo;
    }

    public static TrajInfo calculateSingleTrackPointsB(FieldImpl uFI, FieldImpl vFI, FieldImpl sFI, double[] ttts, float lat0, float lon0, float alt0, int numTimes) {
        float radius = 6371000.0f;
        float f = 57.295784f;
        TrajInfo trajInfo = new TrajInfo(numTimes);
        try {
            float[] u = new float[numTimes];
            float[] v = new float[numTimes];
            for (int timeStepIdx = numTimes - 1; timeStepIdx > -1; --timeStepIdx) {
                if (timeStepIdx == numTimes - 1) {
                    trajInfo.lats[timeStepIdx] = lat0;
                    trajInfo.lons[timeStepIdx] = lon0;
                    trajInfo.alts[timeStepIdx] = alt0;
                    EarthLocationLite el = new EarthLocationLite(lat0, lon0, alt0);
                    LatLonPoint llp = el.getLatLonPoint();
                    FieldImpl ssample = GridUtil.sample(sFI, llp, 100);
                    Data srt = ssample.getSample(timeStepIdx);
                    Real sreal = srt instanceof RealTuple ? (Real)((RealTuple)srt).getComponent(0) : (Real)srt;
                    trajInfo.parcels[timeStepIdx] = (float)sreal.getValue();
                    FieldImpl usample = GridUtil.sample(uFI, llp, 100);
                    Data urt = usample.getSample(timeStepIdx);
                    Real ureal = urt instanceof RealTuple ? (Real)((RealTuple)urt).getComponent(0) : (Real)urt;
                    u[timeStepIdx] = (float)ureal.getValue();
                    FieldImpl vsample = GridUtil.sample(vFI, llp, 100);
                    Data vrt = vsample.getSample(timeStepIdx);
                    Real vreal = vrt instanceof RealTuple ? (Real)((RealTuple)vrt).getComponent(0) : (Real)vrt;
                    v[timeStepIdx] = (float)vreal.getValue();
                    continue;
                }
                double delt = ttts[timeStepIdx] - ttts[timeStepIdx + 1];
                float lat = trajInfo.lats[timeStepIdx + 1];
                float lon = trajInfo.lons[timeStepIdx + 1];
                float alt = trajInfo.alts[timeStepIdx + 1];
                float lat1 = (float)((double)lat + 57.29578399658203 * ((double)v[timeStepIdx + 1] * delt) / (double)(6371000.0f + alt));
                float lon1 = (float)((double)lon + 57.29578399658203 * ((double)u[timeStepIdx + 1] * delt) / (double)(6371000.0f + alt));
                float alt1 = alt;
                EarthLocationLite el = new EarthLocationLite(lat1, lon1, alt1);
                LatLonPoint llp = el.getLatLonPoint();
                FieldImpl usample = GridUtil.sample(uFI, llp, 100);
                FieldImpl vsample = GridUtil.sample(vFI, llp, 100);
                FieldImpl ssample = GridUtil.sample(sFI, llp, 100);
                if (usample == null && vsample == null && ssample == null) {
                    trajInfo.lats[timeStepIdx] = trajInfo.lats[timeStepIdx + 1];
                    trajInfo.lons[timeStepIdx] = trajInfo.lons[timeStepIdx + 1];
                    trajInfo.alts[timeStepIdx] = trajInfo.alts[timeStepIdx + 1];
                    trajInfo.parcels[timeStepIdx] = trajInfo.parcels[timeStepIdx + 1];
                    continue;
                }
                trajInfo.lats[timeStepIdx] = lat1;
                trajInfo.lons[timeStepIdx] = lon1;
                trajInfo.alts[timeStepIdx] = alt1;
                Data urt = usample.getSample(timeStepIdx);
                Real ureal = urt instanceof RealTuple ? (Real)((RealTuple)urt).getComponent(0) : (Real)urt;
                u[timeStepIdx] = (float)ureal.getValue();
                Data vrt = vsample.getSample(timeStepIdx);
                Real vreal = vrt instanceof RealTuple ? (Real)((RealTuple)vrt).getComponent(0) : (Real)vrt;
                v[timeStepIdx] = (float)vreal.getValue();
                Data srt = ssample.getSample(timeStepIdx);
                Real sreal = srt instanceof RealTuple ? (Real)((RealTuple)srt).getComponent(0) : (Real)srt;
                trajInfo.parcels[timeStepIdx] = (float)sreal.getValue();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return trajInfo;
    }

    public static TrajInfo calculateSingleTrackPoints(FieldImpl uFI, FieldImpl vFI, FieldImpl wFI, FieldImpl sFI, double[] ttts, float lat0, float lon0, float alt0, int numTimes) {
        float radius = 6371000.0f;
        float f = 57.295784f;
        TrajInfo trajInfo = new TrajInfo(numTimes);
        try {
            float[] u = new float[numTimes];
            float[] v = new float[numTimes];
            float[] w = new float[numTimes];
            for (int timeStepIdx = 0; timeStepIdx < numTimes; ++timeStepIdx) {
                if (timeStepIdx == 0) {
                    Real wreal;
                    trajInfo.lats[timeStepIdx] = lat0;
                    trajInfo.lons[timeStepIdx] = lon0;
                    trajInfo.alts[timeStepIdx] = alt0;
                    EarthLocationLite el = new EarthLocationLite(lat0, lon0, alt0);
                    FieldImpl ssample = GridUtil.sample(sFI, el);
                    Data srt = ssample.getSample(0);
                    Real sreal = srt instanceof RealTuple ? (Real)((RealTuple)srt).getComponent(0) : (Real)srt;
                    trajInfo.parcels[timeStepIdx] = (float)sreal.getValue();
                    FieldImpl usample = GridUtil.sample(uFI, el);
                    Data urt = usample.getSample(0);
                    Real ureal = urt instanceof RealTuple ? (Real)((RealTuple)urt).getComponent(0) : (Real)urt;
                    u[timeStepIdx] = (float)ureal.getValue();
                    FieldImpl vsample = GridUtil.sample(vFI, el);
                    Data vrt = vsample.getSample(0);
                    Real vreal = vrt instanceof RealTuple ? (Real)((RealTuple)vrt).getComponent(0) : (Real)vrt;
                    v[timeStepIdx] = (float)vreal.getValue();
                    FieldImpl wsample = GridUtil.sample(wFI, el);
                    Data wrt = wsample.getSample(0);
                    Real real = wreal = wrt instanceof RealTuple ? (Real)((RealTuple)wrt).getComponent(0) : (Real)wrt;
                    if (wreal.isMissing()) {
                        w[timeStepIdx] = 0.0f;
                        continue;
                    }
                    w[timeStepIdx] = (float)wreal.getValue();
                    continue;
                }
                double delt = ttts[timeStepIdx] - ttts[timeStepIdx - 1];
                float lat = trajInfo.lats[timeStepIdx - 1];
                float lon = trajInfo.lons[timeStepIdx - 1];
                float alt = trajInfo.alts[timeStepIdx - 1];
                float lat1 = (float)((double)lat + 57.29578399658203 * ((double)v[timeStepIdx - 1] * delt) / (double)(6371000.0f + alt));
                float lon1 = (float)((double)lon + 57.29578399658203 * ((double)u[timeStepIdx - 1] * delt) / (double)(6371000.0f + alt));
                float alt1 = (float)((double)alt + (double)w[timeStepIdx - 1] * delt);
                if (alt1 < 0.0f) {
                    alt1 = 0.0f;
                }
                EarthLocationLite el = new EarthLocationLite(lat1, lon1, alt1);
                FieldImpl usample = GridUtil.sample(uFI, el);
                FieldImpl vsample = GridUtil.sample(vFI, el);
                FieldImpl wsample = GridUtil.sample(wFI, el);
                FieldImpl ssample = GridUtil.sample(sFI, el);
                if (usample == null && vsample == null && wsample == null && ssample == null) {
                    trajInfo.lats[timeStepIdx] = trajInfo.lats[timeStepIdx - 1];
                    trajInfo.lons[timeStepIdx] = trajInfo.lons[timeStepIdx - 1];
                    trajInfo.alts[timeStepIdx] = trajInfo.alts[timeStepIdx - 1];
                    trajInfo.parcels[timeStepIdx] = trajInfo.parcels[timeStepIdx - 1];
                    continue;
                }
                trajInfo.lats[timeStepIdx] = lat1;
                trajInfo.lons[timeStepIdx] = lon1;
                trajInfo.alts[timeStepIdx] = alt1;
                Data urt = usample.getSample(timeStepIdx);
                Real ureal = urt instanceof RealTuple ? (Real)((RealTuple)urt).getComponent(0) : (Real)urt;
                u[timeStepIdx] = (float)ureal.getValue();
                Data vrt = vsample.getSample(timeStepIdx);
                Real vreal = vrt instanceof RealTuple ? (Real)((RealTuple)vrt).getComponent(0) : (Real)vrt;
                v[timeStepIdx] = (float)vreal.getValue();
                Data wrt = wsample.getSample(timeStepIdx);
                Real wreal = wrt instanceof RealTuple ? (Real)((RealTuple)wrt).getComponent(0) : (Real)wrt;
                w[timeStepIdx] = wreal.isMissing() ? 0.0f : (float)wreal.getValue();
                Data srt = ssample.getSample(timeStepIdx);
                Real sreal = srt instanceof RealTuple ? (Real)((RealTuple)srt).getComponent(0) : (Real)srt;
                trajInfo.parcels[timeStepIdx] = (float)sreal.getValue();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return trajInfo;
    }

    public static TrajInfo calculateSingleTrackPointsB(FieldImpl uFI, FieldImpl vFI, FieldImpl wFI, FieldImpl sFI, double[] ttts, float lat0, float lon0, float alt0, int numTimes) {
        float radius = 6371000.0f;
        float f = 57.295784f;
        TrajInfo trajInfo = new TrajInfo(numTimes);
        try {
            float[] u = new float[numTimes];
            float[] v = new float[numTimes];
            float[] w = new float[numTimes];
            for (int timeStepIdx = numTimes - 1; timeStepIdx > -1; --timeStepIdx) {
                if (timeStepIdx == numTimes - 1) {
                    Real wreal;
                    trajInfo.lats[timeStepIdx] = lat0;
                    trajInfo.lons[timeStepIdx] = lon0;
                    trajInfo.alts[timeStepIdx] = alt0;
                    EarthLocationLite el = new EarthLocationLite(lat0, lon0, alt0);
                    FieldImpl ssample = GridUtil.sample(sFI, el);
                    Data srt = ssample.getSample(timeStepIdx);
                    Real sreal = srt instanceof RealTuple ? (Real)((RealTuple)srt).getComponent(0) : (Real)srt;
                    trajInfo.parcels[timeStepIdx] = (float)sreal.getValue();
                    FieldImpl usample = GridUtil.sample(uFI, el);
                    Data urt = usample.getSample(timeStepIdx);
                    Real ureal = urt instanceof RealTuple ? (Real)((RealTuple)urt).getComponent(0) : (Real)urt;
                    u[timeStepIdx] = (float)ureal.getValue();
                    FieldImpl vsample = GridUtil.sample(vFI, el);
                    Data vrt = vsample.getSample(timeStepIdx);
                    Real vreal = vrt instanceof RealTuple ? (Real)((RealTuple)vrt).getComponent(0) : (Real)vrt;
                    v[timeStepIdx] = (float)vreal.getValue();
                    FieldImpl wsample = GridUtil.sample(wFI, el);
                    Data wrt = wsample.getSample(timeStepIdx);
                    Real real = wreal = wrt instanceof RealTuple ? (Real)((RealTuple)wrt).getComponent(0) : (Real)wrt;
                    if (wreal.isMissing()) {
                        w[timeStepIdx] = 0.0f;
                        continue;
                    }
                    w[timeStepIdx] = (float)wreal.getValue();
                    continue;
                }
                double delt = ttts[timeStepIdx] - ttts[timeStepIdx + 1];
                float lat = trajInfo.lats[timeStepIdx + 1];
                float lon = trajInfo.lons[timeStepIdx + 1];
                float alt = trajInfo.alts[timeStepIdx + 1];
                float lat1 = (float)((double)lat + 57.29578399658203 * ((double)v[timeStepIdx + 1] * delt) / (double)(6371000.0f + alt));
                float lon1 = (float)((double)lon + 57.29578399658203 * ((double)u[timeStepIdx + 1] * delt) / (double)(6371000.0f + alt));
                float alt1 = (float)((double)alt + (double)w[timeStepIdx + 1] * delt);
                if (alt1 < 0.0f) {
                    alt1 = 0.0f;
                }
                EarthLocationLite el = new EarthLocationLite(lat1, lon1, alt1);
                FieldImpl usample = GridUtil.sample(uFI, el);
                FieldImpl vsample = GridUtil.sample(vFI, el);
                FieldImpl wsample = GridUtil.sample(wFI, el);
                FieldImpl ssample = GridUtil.sample(sFI, el);
                if (usample == null && vsample == null && wsample == null && ssample == null) {
                    trajInfo.lats[timeStepIdx] = trajInfo.lats[timeStepIdx + 1];
                    trajInfo.lons[timeStepIdx] = trajInfo.lons[timeStepIdx + 1];
                    trajInfo.alts[timeStepIdx] = trajInfo.alts[timeStepIdx + 1];
                    trajInfo.parcels[timeStepIdx] = trajInfo.parcels[timeStepIdx + 1];
                    continue;
                }
                trajInfo.lats[timeStepIdx] = lat1;
                trajInfo.lons[timeStepIdx] = lon1;
                trajInfo.alts[timeStepIdx] = alt1;
                Data urt = usample.getSample(timeStepIdx);
                Real ureal = urt instanceof RealTuple ? (Real)((RealTuple)urt).getComponent(0) : (Real)urt;
                u[timeStepIdx] = (float)ureal.getValue();
                Data vrt = vsample.getSample(timeStepIdx);
                Real vreal = vrt instanceof RealTuple ? (Real)((RealTuple)vrt).getComponent(0) : (Real)vrt;
                v[timeStepIdx] = (float)vreal.getValue();
                Data wrt = wsample.getSample(timeStepIdx);
                Real wreal = wrt instanceof RealTuple ? (Real)((RealTuple)wrt).getComponent(0) : (Real)wrt;
                w[timeStepIdx] = wreal.isMissing() ? 0.0f : (float)wreal.getValue();
                Data srt = ssample.getSample(timeStepIdx);
                Real sreal = srt instanceof RealTuple ? (Real)((RealTuple)srt).getComponent(0) : (Real)srt;
                trajInfo.parcels[timeStepIdx] = (float)sreal.getValue();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return trajInfo;
    }

    public static List<FlatField> createTracks(String variableName, List<TrajInfo> tj, Set timeSet, FunctionType ft, Unit varUnit, int num) throws Exception {
        ExecutorService executor = Executors.newFixedThreadPool(8);
        ArrayList<FlatField> result = new ArrayList<FlatField>();
        ArrayList<Future<FlatField>> pthreads = new ArrayList<Future<FlatField>>();
        for (int i = 0; i < num; ++i) {
            trackThredds trackThredds2 = new trackThredds(i, variableName, tj, timeSet, ft, varUnit);
            Future<FlatField> future = executor.submit(trackThredds2);
            pthreads.add(future);
        }
        for (Future future : pthreads) {
            try {
                result.add((FlatField)future.get());
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public static List<FlatField> createTracks1(final String variableName, final List<TrajInfo> tj, final Set timeSet, final FunctionType ft, final Unit varUnit, final int num) throws Exception {
        ExecutorService executor = Executors.newFixedThreadPool(4);
        Callable<List<FlatField>> task = new Callable<List<FlatField>>(){

            @Override
            public List<FlatField> call() {
                ArrayList<FlatField> result = new ArrayList<FlatField>();
                for (int i = 0; i < num; ++i) {
                    result.add(i, GridTrajectory.createSingleTrack(variableName, tj, timeSet, ft, varUnit, i));
                }
                return result;
            }
        };
        Future<List<FlatField>> future = executor.submit(task);
        List<FlatField> cList = future.get();
        return cList;
    }

    public static FlatField createSingleTrack(String variableName, List<TrajInfo> tj, Set timeSet, FunctionType ft, Unit varUnit, int i) {
        try {
            Gridded3DSet domain;
            Unit timeUnit = timeSet.getSetUnits()[0];
            int length = tj.size();
            double[][] newRangeVals = new double[2][length];
            double[] timeVals = timeSet.getDoubles()[0];
            newRangeVals[0] = tj.get((int)i).parcels;
            RealType timeType = RealType.getRealType(DataUtil.cleanName(variableName + "_" + timeUnit), timeUnit);
            RealType varType = RealType.getRealType(DataUtil.cleanName(variableName + "_" + varUnit), varUnit);
            RealTupleType rangeType = new RealTupleType(varType, timeType);
            newRangeVals[1] = timeVals;
            Set[] rangeSets = new Set[]{new DoubleSet(new SetType(rangeType.getComponent(0))), new DoubleSet(new SetType(rangeType.getComponent(1)))};
            float[][] trajCoords = new float[][]{tj.get((int)i).lons, tj.get((int)i).lats, tj.get((int)i).alts};
            Gridded3DSet llaSet = domain = new Gridded3DSet((MathType)RealTupleType.SpatialEarth3DTuple, (float[][])trajCoords, trajCoords[0].length);
            FunctionType newType = new FunctionType(((SetType)llaSet.getType()).getDomain(), rangeType);
            FlatField timeTrack = new FlatField(newType, (Set)llaSet, (CoordinateSystem)null, rangeSets, new Unit[]{varUnit, timeUnit});
            timeTrack.setSamples(newRangeVals, false);
            return timeTrack;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static FlatField createSingleTrack1(String variableName, float[] lats, float[] lons, float[] alts, double[] param, Set timeSet, FunctionType ft, Unit varUnit) throws Exception {
        Gridded3DSet domain;
        Unit timeUnit = timeSet.getSetUnits()[0];
        double[][] newRangeVals = new double[2][param.length];
        double[] timeVals = timeSet.getDoubles()[0];
        newRangeVals[0] = param;
        RealType timeType = RealType.getRealType(DataUtil.cleanName(variableName + "_" + timeUnit), timeUnit);
        RealType varType = RealType.getRealType(DataUtil.cleanName(variableName + "_" + varUnit), varUnit);
        RealTupleType rangeType = new RealTupleType(varType, timeType);
        newRangeVals[1] = timeVals;
        Set[] rangeSets = new Set[]{new DoubleSet(new SetType(rangeType.getComponent(0))), new DoubleSet(new SetType(rangeType.getComponent(1)))};
        float[][] trajCoords = new float[][]{lons, lats, alts};
        Gridded3DSet llaSet = domain = new Gridded3DSet((MathType)RealTupleType.SpatialEarth3DTuple, (float[][])trajCoords, trajCoords[0].length);
        FunctionType newType = new FunctionType(((SetType)llaSet.getType()).getDomain(), rangeType);
        FlatField timeTrack = new FlatField(newType, (Set)llaSet, (CoordinateSystem)null, rangeSets, new Unit[]{varUnit, timeUnit});
        timeTrack.setSamples(newRangeVals, false);
        return timeTrack;
    }

    static class trackThredds
    implements Callable<FlatField> {
        String variableName;
        List<TrajInfo> tj;
        Set timeSet;
        FunctionType ft;
        Unit varUnit;
        int i;

        private trackThredds(int i, String variableName, List<TrajInfo> tj, Set timeSet, FunctionType ft, Unit varUnit) {
            this.i = i;
            this.variableName = variableName;
            this.tj = tj;
            this.timeSet = timeSet;
            this.ft = ft;
            this.varUnit = varUnit;
        }

        @Override
        public FlatField call() {
            FlatField ff = GridTrajectory.createSingleTrack(this.variableName, this.tj, this.timeSet, this.ft, this.varUnit, this.i);
            return ff;
        }
    }

    static class pointsThredds
    implements Callable<TrajInfo> {
        FieldImpl uFI;
        FieldImpl vFI;
        FieldImpl wFI;
        FieldImpl sFI;
        double[] ttts;
        float lat;
        float lon;
        float alt;
        int numTimes;
        int latIndex;
        int lonIndex;
        boolean haveAlt;
        boolean normalizeLon;
        boolean backward;

        private pointsThredds(FieldImpl uFI, FieldImpl vFI, FieldImpl wFI, FieldImpl sFI, double[] ttts, float lat, float lon, float alt, int numTimes, boolean backward) {
            this.uFI = uFI;
            this.vFI = vFI;
            this.wFI = wFI;
            this.sFI = sFI;
            this.ttts = ttts;
            this.lat = lat;
            this.lon = lon;
            this.alt = alt;
            this.numTimes = numTimes;
            this.backward = backward;
        }

        @Override
        public TrajInfo call() {
            if (!this.backward) {
                if (this.wFI != null) {
                    return GridTrajectory.calculateSingleTrackPoints(this.uFI, this.vFI, this.wFI, this.sFI, this.ttts, this.lat, this.lon, this.alt, this.numTimes);
                }
                return GridTrajectory.calculateSingleTrackPoints(this.uFI, this.vFI, this.sFI, this.ttts, this.lat, this.lon, this.alt, this.numTimes);
            }
            if (this.wFI != null) {
                return GridTrajectory.calculateSingleTrackPointsB(this.uFI, this.vFI, this.wFI, this.sFI, this.ttts, this.lat, this.lon, this.alt, this.numTimes);
            }
            return GridTrajectory.calculateSingleTrackPointsB(this.uFI, this.vFI, this.sFI, this.ttts, this.lat, this.lon, this.alt, this.numTimes);
        }
    }

    public static class TrajInfo {
        float[] lats;
        float[] lons;
        float[] alts;
        double[] parcels;

        public TrajInfo(int numTimes) {
            this.lats = new float[numTimes];
            this.lons = new float[numTimes];
            this.alts = new float[numTimes];
            this.parcels = new double[numTimes];
        }
    }

    static class VarNClone
    implements Callable<Object> {
        private FieldImpl v;

        private VarNClone(FieldImpl v) {
            this.v = v;
        }

        @Override
        public FieldImpl call() throws CloneNotSupportedException {
            return this.v;
        }
    }

    static class Varbar
    implements Callable<Object> {
        private FieldImpl v;

        private Varbar(FieldImpl v) {
            this.v = v;
        }

        @Override
        public FieldImpl call() throws CloneNotSupportedException {
            return (FieldImpl)this.v.clone();
        }
    }
}

