/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.data.grid;

import java.rmi.RemoteException;
import java.util.ArrayList;
import ucar.unidata.data.DataUtil;
import ucar.unidata.data.grid.DerivedGridFactory;
import ucar.unidata.data.grid.GridUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.Range;
import ucar.unidata.util.Trace;
import ucar.visad.Util;
import visad.CommonUnit;
import visad.Data;
import visad.DataImpl;
import visad.DerivedUnit;
import visad.FieldImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.Gridded2DSet;
import visad.GriddedSet;
import visad.MathType;
import visad.QuickSort;
import visad.Real;
import visad.RealTupleType;
import visad.RealType;
import visad.SampledSet;
import visad.Set;
import visad.SetType;
import visad.TupleType;
import visad.Unit;
import visad.VisADException;
import visad.georef.MapProjection;
import visad.util.DataUtility;

public class GridMath {
    public static final String FUNC_AVERAGE = "average";
    public static final String FUNC_STDEV = "standardDeviation";
    public static final String FUNC_PRCNTL = "ensemblePercentile";
    public static final String FUNC_UPROB = "ensembleUProbability";
    public static final String FUNC_SUM = "sum";
    public static final String FUNC_MAX = "max";
    public static final String FUNC_MIN = "min";
    public static final String FUNC_RNG = "range";
    public static final String FUNC_MODE = "mode";
    public static final String FUNC_EXP = "exp";
    public static final String FUNC_DIFFERENCE = "difference";
    public static final int OPT_CYCLIC = -1;
    public static final int OPT_MISSING = 0;
    public static final int OPT_SYMMETRIC = 1;
    public static final String AXIS_X = "X";
    public static final String AXIS_Y = "Y";
    private static final Real KM_PER_DEGREE;
    public static final Real NEGATIVE_ONE;

    public static FieldImpl add(FieldImpl grid1, FieldImpl grid2) throws VisADException {
        return GridMath.add(grid1, grid2, false);
    }

    public static FieldImpl add(FieldImpl grid1, FieldImpl grid2, boolean useWA) throws VisADException {
        return GridMath.doMath(grid1, grid2, 1, useWA);
    }

    public static FieldImpl subtract(FieldImpl grid1, FieldImpl grid2) throws VisADException {
        return GridMath.subtract(grid1, grid2, false);
    }

    public static FieldImpl subtract(FieldImpl grid1, FieldImpl grid2, boolean useWA) throws VisADException {
        return GridMath.doMath(grid1, grid2, 2, useWA);
    }

    public static FieldImpl multiply(FieldImpl grid1, FieldImpl grid2) throws VisADException {
        return GridMath.multiply(grid1, grid2, false);
    }

    public static FieldImpl multiply(FieldImpl grid1, FieldImpl grid2, boolean useWA) throws VisADException {
        return GridMath.doMath(grid1, grid2, 4, useWA);
    }

    public static FieldImpl divide(FieldImpl grid1, FieldImpl grid2) throws VisADException {
        return GridMath.divide(grid1, grid2, false);
    }

    public static FieldImpl divide(FieldImpl grid1, FieldImpl grid2, boolean useWA) throws VisADException {
        return GridMath.doMath(grid1, grid2, 5, useWA);
    }

    public static FieldImpl atan2(FieldImpl grid1, FieldImpl grid2) throws VisADException {
        return GridMath.atan2(grid1, grid2, false);
    }

    public static FieldImpl atan2(FieldImpl grid1, FieldImpl grid2, boolean useWA) throws VisADException {
        return GridMath.doMath(grid1, grid2, 11, useWA);
    }

    private static FieldImpl doMath(FieldImpl grid1, FieldImpl grid2, int op) throws VisADException {
        return GridMath.doMath(grid1, grid2, op, false);
    }

    private static FieldImpl doMath(FieldImpl grid1, FieldImpl grid2, int op, boolean useWA) throws VisADException {
        boolean isLatLon2;
        boolean isSlice2;
        FieldImpl a = grid1;
        FieldImpl b = grid2;
        boolean is3D1 = GridUtil.is3D(grid1);
        boolean is3D2 = GridUtil.is3D(grid2);
        boolean isVolume1 = GridUtil.isVolume(grid1);
        boolean isVolume2 = GridUtil.isVolume(grid2);
        boolean isSlice1 = !isVolume1 && is3D1;
        boolean bl = isSlice2 = !isVolume2 && is3D2;
        if (isSlice1 && isSlice2) {
            if (!Misc.equals(GridUtil.getSpatialDomain(grid1), GridUtil.getSpatialDomain(grid2))) {
                a = GridUtil.make2DGridFromSlice(grid1, false);
                b = GridUtil.make2DGridFromSlice(grid2, false);
            }
        } else if (isSlice1 && !is3D2) {
            a = GridUtil.make2DGridFromSlice(grid1, false);
        } else if (!is3D1 && isSlice2) {
            b = GridUtil.make2DGridFromSlice(grid2, false);
        }
        int mode = useWA ? 101 : 100;
        boolean isLatLon1 = GridUtil.isLatLonOrder(a);
        if (isLatLon1 != (isLatLon2 = GridUtil.isLatLonOrder(b))) {
            if (GridUtil.canSwapLatLon(a)) {
                a = GridUtil.swapLatLon(a);
            } else if (GridUtil.canSwapLatLon(b)) {
                b = GridUtil.swapLatLon(b);
            } else {
                throw new VisADException("incompatible grid domains");
            }
        }
        return GridMath.binary(a, b, op, mode, 202);
    }

    private static FieldImpl binary(FieldImpl grid1, FieldImpl grid2, int op, int samplingMode, int errorMode) throws VisADException {
        try {
            return (FieldImpl)grid1.binary(grid2, op, samplingMode, errorMode);
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    public static FieldImpl averageOverTime(FieldImpl grid, boolean makeTimes) throws VisADException {
        return GridMath.applyFunctionOverTime(grid, FUNC_AVERAGE, makeTimes);
    }

    public static FieldImpl standardDeviationOverTime(FieldImpl grid, boolean makeTimes) throws VisADException {
        return GridMath.applyFunctionOverTime(grid, FUNC_STDEV, makeTimes);
    }

    public static FieldImpl averageOverMembers(FieldImpl grid) throws VisADException {
        return GridMath.applyFunctionOverMembers(grid, FUNC_AVERAGE);
    }

    public static FieldImpl ensembleStandardDeviation(FieldImpl grid) throws VisADException {
        return GridMath.applyFunctionOverMembers(grid, FUNC_STDEV);
    }

    public static FieldImpl ensembleLowestValues(FieldImpl grid) throws VisADException {
        return GridMath.applyFunctionOverMembers(grid, FUNC_MIN);
    }

    public static FieldImpl ensembleHighestValues(FieldImpl grid) throws VisADException {
        return GridMath.applyFunctionOverMembers(grid, FUNC_MAX);
    }

    public static FieldImpl ensembleRangeValues(FieldImpl grid) throws VisADException {
        return GridMath.applyFunctionOverMembers(grid, FUNC_RNG);
    }

    public static FieldImpl ensemblePercentileValues(FieldImpl grid, String percent) throws VisADException {
        return GridMath.applyFunctionOverMembers(grid, percent, "0", "0", FUNC_PRCNTL);
    }

    public static FieldImpl ensemblePercentileValues(FieldImpl grid, int percent) throws VisADException {
        return GridMath.applyFunctionOverMembers(grid, percent, 0.0f, 0.0f, FUNC_PRCNTL);
    }

    public static FieldImpl ensembleUProbabilityValues(FieldImpl grid, String logicalOp, float pValue, float exptdLoBound, float exptdUpBound) throws VisADException {
        grid = GridMath.applyFunctionOverMembers(grid, pValue, exptdLoBound, exptdUpBound, FUNC_UPROB);
        String probName = String.format("Ensemble Univariate Probability P(x %s %f)", logicalOp, Float.valueOf(pValue));
        RealType probType = RealType.getRealType(probName, CommonUnit.promiscuous);
        return GridUtil.setParamType(grid, probType, true);
    }

    public static FieldImpl ensembleUProbabilityValues(FieldImpl grid, String logicalOp, String pValue, String exptdLoBound, String exptdUpBound) throws VisADException {
        grid = GridMath.applyFunctionOverMembers(grid, pValue, exptdLoBound, exptdUpBound, FUNC_UPROB);
        String probName = String.format("Ensemble Univariate Probability P(x %s %s)", logicalOp, pValue);
        RealTupleType rtt = new RealTupleType(DataUtil.makeRealType(probName, CommonUnit.dimensionless));
        grid = GridUtil.setParamType(grid, rtt, false);
        return grid;
    }

    public static FieldImpl ensembleModeValues(FieldImpl grid) throws VisADException {
        return GridMath.applyFunctionOverMembers(grid, 0.0f, 0.0f, 0.0f, FUNC_MODE);
    }

    public static FieldImpl timeStepDifference(FieldImpl grid, int offset) throws VisADException {
        return GridMath.timeStepFunc(grid, offset, FUNC_DIFFERENCE);
    }

    public static FieldImpl timeStepSum(FieldImpl grid, int offset) throws VisADException {
        return GridMath.timeStepFunc(grid, offset, FUNC_SUM);
    }

    public static FieldImpl differenceFromBaseTime(FieldImpl grid) throws VisADException {
        return GridMath.timeStepFunc(grid, 0, FUNC_DIFFERENCE);
    }

    public static FieldImpl sumFromBaseTime(FieldImpl grid) throws VisADException {
        try {
            if (!GridUtil.isTimeSequence(grid)) {
                return grid;
            }
            FieldImpl newGrid = (FieldImpl)grid.clone();
            Set timeDomain = Util.getDomainSet(newGrid);
            int numTimeSteps = timeDomain.getLength();
            FlatField sample = (FlatField)newGrid.getSample(0);
            float[][] baseValue = Misc.cloneArray(sample.getFloats(false));
            for (int timeStepIdx = 1; timeStepIdx < numTimeSteps; ++timeStepIdx) {
                sample = (FlatField)newGrid.getSample(timeStepIdx);
                float[][] timeStepValues = sample.getFloats(false);
                float[][] value = Misc.addArray(baseValue, timeStepValues, null);
                baseValue = value;
                sample.setSamples(value, false);
            }
            return newGrid;
        }
        catch (CloneNotSupportedException cnse) {
            throw new VisADException("Cannot clone field");
        }
        catch (RemoteException re) {
            throw new VisADException("RemoteException in timeStepFunc");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FieldImpl timeStepFunc(FieldImpl grid, int offset, String func) throws VisADException {
        try {
            if (!GridUtil.isTimeSequence(grid)) {
                return grid;
            }
            ArrayList<float[][]> arrays = new ArrayList<float[][]>();
            FieldImpl newGrid = (FieldImpl)grid.clone();
            float[][] values = null;
            float[][] priorValues = null;
            Set timeDomain = Util.getDomainSet(newGrid);
            int numTimeSteps = timeDomain.getLength();
            for (int timeStepIdx = 0; timeStepIdx < timeDomain.getLength(); ++timeStepIdx) {
                FieldImpl sample = (FieldImpl)newGrid.getSample(timeStepIdx);
                float[][] timeStepValues = sample.getFloats(true);
                arrays.add(Misc.cloneArray(timeStepValues));
            }
            float[][] baseValue = null;
            if (offset == 0 && arrays.size() > 0) {
                baseValue = Misc.cloneArray((float[][])arrays.get(0));
            }
            for (int timeStepIdx = arrays.size() - 1; timeStepIdx >= 0; --timeStepIdx) {
                float[][] value = (float[][])arrays.get(timeStepIdx);
                if (baseValue == null && offset == 0) {
                    baseValue = Misc.cloneArray(value);
                }
                if (offset == 0 || timeStepIdx + offset >= 0 && timeStepIdx + offset < arrays.size()) {
                    float[][] oldValue;
                    float[][] fArray = oldValue = offset == 0 ? baseValue : (float[][])arrays.get(timeStepIdx + offset);
                    if (func.equals(FUNC_DIFFERENCE)) {
                        value = Misc.subtractArray(value, oldValue, value);
                    } else {
                        if (!func.equals(FUNC_SUM)) throw new IllegalArgumentException("Unknown function:" + func);
                        value = Misc.addArray(value, oldValue, value);
                    }
                } else {
                    Misc.fillArray(value, Float.NaN);
                }
                FlatField sample = (FlatField)newGrid.getSample(timeStepIdx);
                sample.setSamples(value, false);
            }
            return newGrid;
        }
        catch (CloneNotSupportedException cnse) {
            throw new VisADException("Cannot clone field");
        }
        catch (RemoteException re) {
            throw new VisADException("RemoteException in timeStepFunc");
        }
    }

    public static FieldImpl timeWeightedRunningAverage(FieldImpl grid, float[] wgts, int opt) throws VisADException {
        return GridMath.timeWeightedRunningAverage(grid, wgts, opt, true);
    }

    public static FieldImpl timeWeightedRunningAverage(FieldImpl grid, float[] wgts, int opt, boolean skipMissing) throws VisADException {
        return GridMath.runave(grid, wgts, -1, opt, skipMissing);
    }

    public static FieldImpl timeRunningAverage(FieldImpl grid, int nave, int opt) throws VisADException {
        return GridMath.timeRunningAverage(grid, nave, opt, true);
    }

    public static FieldImpl timeRunningAverage(FieldImpl grid, int nave, int opt, boolean skipMissing) throws VisADException {
        return GridMath.runave(grid, null, nave, opt, skipMissing);
    }

    private static FieldImpl runave(FieldImpl grid, float[] wgts, int nave, int opt, boolean skipMissing) throws VisADException {
        int i;
        float wsum = 0.0f;
        if (wgts != null) {
            nave = wgts.length;
            for (i = 0; i < nave; ++i) {
                wsum += wgts[i];
            }
        } else {
            wgts = new float[nave];
            for (i = 0; i < nave; ++i) {
                wgts[i] = 1.0f;
                wsum += 1.0f;
            }
        }
        if ((double)wsum > 1.0) {
            wsum = 1.0f / wsum;
        }
        try {
            int n;
            int numTimeSteps;
            if (!GridUtil.isTimeSequence(grid) || nave == 1) {
                return grid;
            }
            Set timeDomain = Util.getDomainSet(grid);
            int npts = numTimeSteps = timeDomain.getLength();
            if (nave > numTimeSteps) {
                throw new VisADException("Number of average steps is greater than number of times");
            }
            FieldImpl newGrid = (FieldImpl)grid.clone();
            int nav2 = nave / 2;
            int noe = nave % 2 == 0 ? 1 : 0;
            FlatField sample = (FlatField)newGrid.getSample(0);
            float[][] missingData = Misc.cloneArray(sample.getFloats(false));
            Misc.fillArray(missingData, Float.NaN);
            int lwork = numTimeSteps + 2 * nav2;
            float[][] values = null;
            float[][][] work = new float[lwork][][];
            float[][][] x = new float[npts][][];
            int[] timeIndices = new int[lwork];
            for (n = 0; n < lwork; ++n) {
                work[n] = missingData;
                timeIndices[n] = -1;
            }
            for (n = 0; n < npts; ++n) {
                sample = (FlatField)newGrid.getSample(n);
                float[][] timeStepValues = Misc.cloneArray(sample.getFloats(false));
                x[n] = timeStepValues;
                work[nav2 + n] = x[n];
                timeIndices[nav2 + n] = n;
            }
            int lpts = npts - 1;
            if (opt == 1) {
                for (int n2 = 0; n2 < nav2; ++n2) {
                    work[nav2 - (n2 + 1)] = x[n2 + 1];
                    timeIndices[nav2 - (n2 + 1)] = n2 + 1;
                    work[lpts + nav2 + (n2 + 1)] = x[lpts - (n2 + 1)];
                    timeIndices[lpts + nav2 + (n2 + 1)] = lpts - (n2 + 1);
                }
            } else if (opt == -1) {
                for (int n3 = 0; n3 < nav2; ++n3) {
                    work[nav2 - (n3 + 1)] = x[lpts - n3];
                    timeIndices[nav2 - (n3 + 1)] = lpts - n3;
                    work[lpts + nav2 + n3 + 1] = x[n3];
                    timeIndices[lpts + nav2 + n3 + 1] = n3;
                }
            }
            for (int n4 = 0; n4 < npts; ++n4) {
                int i2;
                int nmid = n4 + nav2 + noe;
                int mstart = nmid - nav2;
                int mlast = mstart + nave;
                float[][] sum = Misc.cloneArray(missingData);
                Misc.fillArray(sum, 0.0f);
                boolean haveMissing = false;
                boolean[] missData = new boolean[nave];
                int idx = 0;
                for (int m = mstart; m < mlast; ++m) {
                    values = work[m];
                    if (!Misc.isNaN(values)) {
                        for (int i3 = 0; i3 < values.length; ++i3) {
                            for (int j = 0; j < values[i3].length; ++j) {
                                float[] fArray = sum[i3];
                                int n5 = j;
                                fArray[n5] = fArray[n5] + values[i3][j] * wgts[m - mstart];
                            }
                        }
                    } else {
                        haveMissing = true;
                        missData[idx] = true;
                        continue;
                    }
                    ++idx;
                }
                if (haveMissing) {
                    for (i2 = 0; i2 < nave; ++i2) {
                        if (missData[i2]) continue;
                        wsum += wgts[i2];
                    }
                    if ((double)wsum > 1.0) {
                        wsum = 1.0f / wsum;
                    }
                }
                if (!haveMissing || skipMissing) {
                    for (i2 = 0; i2 < values.length; ++i2) {
                        int j = 0;
                        while (j < values[i2].length) {
                            float[] fArray = sum[i2];
                            int n6 = j++;
                            fArray[n6] = fArray[n6] * wsum;
                        }
                    }
                } else {
                    sum = missingData;
                }
                sample = (FlatField)newGrid.getSample(n4);
                sample.setSamples(sum, false);
            }
            return newGrid;
        }
        catch (CloneNotSupportedException cnse) {
            throw new VisADException("Cannot clone field");
        }
        catch (RemoteException re) {
            throw new VisADException("RemoteException in timeStepFunc");
        }
    }

    public static FieldImpl sumOverTime(FieldImpl grid, boolean makeTimes) throws VisADException {
        return GridMath.applyFunctionOverTime(grid, FUNC_SUM, makeTimes);
    }

    public static FieldImpl minOverTime(FieldImpl grid, boolean makeTimes) throws VisADException {
        return GridMath.applyFunctionOverTime(grid, FUNC_MIN, makeTimes);
    }

    public static FieldImpl maxOverTime(FieldImpl grid, boolean makeTimes) throws VisADException {
        return GridMath.applyFunctionOverTime(grid, FUNC_MAX, makeTimes);
    }

    public static FieldImpl applyFunctionOverTime(FieldImpl grid, String function, boolean makeTimes) throws VisADException {
        return GridMath.applyFunctionOverTime(grid, function, 0, 1, makeTimes);
    }

    public static FieldImpl applyFunctionOverTime(FieldImpl grid, String function, int startIdx, int idxStride, boolean makeTimes) throws VisADException {
        try {
            int i;
            FlatField newGrid = null;
            if (!GridUtil.isTimeSequence(grid)) {
                newGrid = (FlatField)grid.clone();
                newGrid.setSamples(grid.getFloats(false), true);
                return newGrid;
            }
            boolean doMax = function.equals(FUNC_MAX);
            boolean doMin = function.equals(FUNC_MIN);
            boolean doStd = function.equals(FUNC_STDEV);
            float[][] values = null;
            float[][] values2 = null;
            int[][] nums = null;
            Set timeDomain = Util.getDomainSet(grid);
            for (int timeStepIdx = startIdx; timeStepIdx < timeDomain.getLength(); timeStepIdx += idxStride) {
                float value;
                int j;
                int i2;
                FieldImpl sample = (FieldImpl)grid.getSample(timeStepIdx);
                float[][] timeStepValues = sample.getFloats(false);
                if (values == null) {
                    values = Misc.cloneArray(timeStepValues);
                    nums = new int[values.length][values[0].length];
                    if (doStd) {
                        values2 = new float[values.length][values[0].length];
                    }
                    for (i2 = 0; i2 < timeStepValues.length; ++i2) {
                        for (j = 0; j < timeStepValues[i2].length; ++j) {
                            value = timeStepValues[i2][j];
                            if (value != value) continue;
                            nums[i2][j] = 1;
                            if (!doStd) continue;
                            values2[i2][j] = value * value;
                        }
                    }
                    newGrid = (FlatField)sample.clone();
                    continue;
                }
                for (i2 = 0; i2 < timeStepValues.length; ++i2) {
                    for (j = 0; j < timeStepValues[i2].length; ++j) {
                        value = timeStepValues[i2][j];
                        if (value != value) continue;
                        if (doMax) {
                            values[i2][j] = Math.max(values[i2][j], value);
                        } else if (doMin) {
                            values[i2][j] = Math.min(values[i2][j], value);
                        } else if (doStd) {
                            float[] fArray = values[i2];
                            int n = j;
                            fArray[n] = fArray[n] + value;
                            float[] fArray2 = values2[i2];
                            int n2 = j;
                            fArray2[n2] = fArray2[n2] + value * value;
                        } else {
                            float[] fArray = values[i2];
                            int n = j;
                            fArray[n] = fArray[n] + value;
                        }
                        int[] nArray = nums[i2];
                        int n = j;
                        nArray[n] = nArray[n] + 1;
                    }
                }
            }
            if (function.equals(FUNC_AVERAGE)) {
                for (i = 0; i < values.length; ++i) {
                    for (int j = 0; j < values[i].length; ++j) {
                        int num = nums[i][j];
                        values[i][j] = num > 0 ? values[i][j] / (float)num : Float.NaN;
                    }
                }
            }
            if (function.equals(FUNC_STDEV)) {
                for (i = 0; i < values.length; ++i) {
                    for (int j = 0; j < values[i].length; ++j) {
                        int num = nums[i][j];
                        if (num > 0) {
                            float mean = values[i][j] / (float)num;
                            float var = values2[i][j] / (float)num - mean * mean;
                            values[i][j] = (float)Math.sqrt(var);
                            continue;
                        }
                        values[i][j] = Float.NaN;
                    }
                }
            }
            newGrid.setSamples(values, false);
            if (makeTimes) {
                return (FieldImpl)Util.makeTimeField(newGrid, GridUtil.getDateTimeList(grid));
            }
            return newGrid;
        }
        catch (CloneNotSupportedException cnse) {
            throw new VisADException("Cannot clone field");
        }
        catch (RemoteException re) {
            throw new VisADException("RemoteException in applyFunctionOverTime");
        }
    }

    public static FlatField applyFunctionOverGrids(FlatField[] grids, String function) throws VisADException {
        try {
            int i;
            int numGrids = grids.length;
            FlatField newGrid = null;
            if (numGrids == 1) {
                newGrid = (FlatField)grids[0].clone();
                newGrid.setSamples(grids[0].getFloats(false), true);
                return newGrid;
            }
            boolean doMax = function.equals(FUNC_MAX);
            boolean doMin = function.equals(FUNC_MIN);
            boolean doStd = function.equals(FUNC_STDEV);
            float[][] values = null;
            float[][] values2 = null;
            int[][] nums = null;
            for (int gridIdx = 0; gridIdx < numGrids; ++gridIdx) {
                float value;
                int j;
                int i2;
                FlatField sample = grids[gridIdx];
                float[][] gridValues = ((FieldImpl)sample).getFloats(false);
                if (Misc.isNaN(gridValues)) continue;
                if (values == null) {
                    values = Misc.cloneArray(gridValues);
                    nums = new int[values.length][values[0].length];
                    if (doStd) {
                        values2 = new float[values.length][values[0].length];
                    }
                    for (i2 = 0; i2 < gridValues.length; ++i2) {
                        for (j = 0; j < gridValues[i2].length; ++j) {
                            value = gridValues[i2][j];
                            if (value != value) continue;
                            nums[i2][j] = 1;
                            if (!doStd) continue;
                            values2[i2][j] = value * value;
                        }
                    }
                    newGrid = (FlatField)((FieldImpl)sample).clone();
                    continue;
                }
                for (i2 = 0; i2 < gridValues.length; ++i2) {
                    for (j = 0; j < gridValues[i2].length; ++j) {
                        value = gridValues[i2][j];
                        if (value != value) continue;
                        if (doMax) {
                            values[i2][j] = Math.max(values[i2][j], value);
                        } else if (doMin) {
                            values[i2][j] = Math.min(values[i2][j], value);
                        } else if (doStd) {
                            float[] fArray = values[i2];
                            int n = j;
                            fArray[n] = fArray[n] + value;
                            float[] fArray2 = values2[i2];
                            int n2 = j;
                            fArray2[n2] = fArray2[n2] + value * value;
                        } else {
                            float[] fArray = values[i2];
                            int n = j;
                            fArray[n] = fArray[n] + value;
                        }
                        int[] nArray = nums[i2];
                        int n = j;
                        nArray[n] = nArray[n] + 1;
                    }
                }
            }
            if (newGrid == null) {
                return null;
            }
            if (function.equals(FUNC_AVERAGE)) {
                for (i = 0; i < values.length; ++i) {
                    for (int j = 0; j < values[i].length; ++j) {
                        int num = nums[i][j];
                        values[i][j] = num > 0 ? values[i][j] / (float)num : Float.NaN;
                    }
                }
            }
            if (function.equals(FUNC_STDEV)) {
                for (i = 0; i < values.length; ++i) {
                    for (int j = 0; j < values[i].length; ++j) {
                        int num = nums[i][j];
                        if (num > 0) {
                            float mean = values[i][j] / (float)num;
                            float var = values2[i][j] / (float)num - mean * mean;
                            values[i][j] = (float)Math.sqrt(var);
                            continue;
                        }
                        values[i][j] = Float.NaN;
                    }
                }
            }
            newGrid.setSamples(values, false);
            return newGrid;
        }
        catch (CloneNotSupportedException cnse) {
            throw new VisADException("Cannot clone field");
        }
        catch (RemoteException re) {
            throw new VisADException("RemoteException in applyFunctionOverTime");
        }
    }

    public static FlatField applyFunctionOverGrids0(FlatField[] grids, String function) throws VisADException {
        try {
            int numGrids = grids.length;
            FlatField newGrid = null;
            if (numGrids == 0) {
                newGrid = (FlatField)grids[0].clone();
                newGrid.setSamples(grids[0].getFloats(false), true);
                return newGrid;
            }
            float[][] values = null;
            for (int gridIdx = 0; gridIdx < numGrids; ++gridIdx) {
                FlatField sample = grids[gridIdx];
                float[][] gridValues = ((FieldImpl)sample).getFloats(false);
                if (Misc.isNaN(gridValues) || values != null) continue;
                values = Misc.cloneArray(gridValues);
                newGrid = (FlatField)((FieldImpl)sample).clone();
            }
            if (newGrid == null) {
                return null;
            }
            if (function.equals(FUNC_EXP)) {
                for (int i = 0; i < values.length; ++i) {
                    for (int j = 0; j < values[i].length; ++j) {
                        if (Math.exp(values[i][j]) < 0.0) {
                            System.out.print(1);
                        }
                        values[i][j] = (float)Math.exp(values[i][j]);
                    }
                }
            }
            newGrid.setSamples(values, false);
            return newGrid;
        }
        catch (CloneNotSupportedException cnse) {
            throw new VisADException("Cannot clone field");
        }
        catch (RemoteException re) {
            throw new VisADException("RemoteException in applyFunctionOverTime");
        }
    }

    public static FieldImpl applyFunctionOverMembers(FieldImpl grid, String statThreshold, String exptdLoBoundIn, String exptdUpBoundIn, String function) throws VisADException {
        float defaultExtreme = 999999.0f;
        String empty = "";
        float exptdLoBound = exptdLoBoundIn.equals(empty) ? -defaultExtreme : (float)Misc.parseNumber(exptdLoBoundIn);
        float exptdUpBound = exptdUpBoundIn.equals(empty) ? defaultExtreme : (float)Misc.parseNumber(exptdUpBoundIn);
        return GridMath.applyFunctionOverMembers(grid, (float)Misc.parseNumber(statThreshold), exptdLoBound, exptdUpBound, function);
    }

    public static FieldImpl applyFunctionOverMembers(FieldImpl grid, float statThreshold, float exptdLoBound, float exptdUpBound, String function) throws VisADException {
        try {
            FieldImpl newGrid = null;
            if (!GridUtil.isTimeSequence(grid)) {
                newGrid = (FlatField)grid.clone();
                return newGrid;
            }
            Set timeDomain = Util.getDomainSet(grid);
            int numMembers = 0;
            Object rangeType = null;
            TupleType newRangeType = null;
            float[][][] valuesAll = null;
            for (int timeStepIdx = 0; timeStepIdx < timeDomain.getLength(); ++timeStepIdx) {
                int i;
                FieldImpl sample = (FieldImpl)grid.getSample(timeStepIdx);
                Set ensDomain = sample.getDomainSet();
                float[][] values = null;
                numMembers = ensDomain.getLength();
                GriddedSet newDomain = null;
                float[][] stdevs = null;
                for (int k = 0; k < numMembers; ++k) {
                    FlatField innerField = (FlatField)sample.getSample(k, false);
                    if (innerField == null) continue;
                    newDomain = (GriddedSet)GridUtil.getSpatialDomain(innerField);
                    if (newRangeType == null) {
                        newRangeType = GridUtil.makeNewParamType(GridUtil.getParamType(innerField), "_" + function);
                    }
                    float[][] ensStepValues = innerField.getFloats(false);
                    if (values == null) {
                        values = Misc.cloneArray(ensStepValues);
                        valuesAll = new float[values.length][values[0].length][numMembers];
                    }
                    for (int i2 = 0; i2 < ensStepValues.length; ++i2) {
                        for (int j = 0; j < ensStepValues[i2].length; ++j) {
                            float value = ensStepValues[i2][j];
                            if (value != value) continue;
                            valuesAll[i2][j][k] = value;
                        }
                    }
                }
                if (function.equals(FUNC_PRCNTL) && numMembers > 1) {
                    int percent = (int)statThreshold;
                    for (int i3 = 0; i3 < values.length; ++i3) {
                        for (int j = 0; j < values[i3].length; ++j) {
                            values[i3][j] = GridMath.evaluatePercentile(valuesAll[i3][j], 0, numMembers, percent);
                        }
                    }
                }
                if (function.equals(FUNC_MODE) && numMembers > 1) {
                    for (i = 0; i < values.length; ++i) {
                        for (int j = 0; j < values[i].length; ++j) {
                            values[i][j] = GridMath.evaluateMode(valuesAll[i][j]);
                        }
                    }
                }
                if (function.equals(FUNC_UPROB) && numMembers > 1) {
                    for (i = 0; i < values.length; ++i) {
                        for (int j = 0; j < values[i].length; ++j) {
                            int k;
                            int numValidMembers = numMembers;
                            float[] tmpValues = new float[numMembers];
                            for (k = 0; k < numMembers; ++k) {
                                tmpValues[k] = valuesAll[i][j][k];
                            }
                            for (k = 0; k < numMembers; ++k) {
                                if (!(tmpValues[k] < exptdLoBound | tmpValues[k] > exptdUpBound)) continue;
                                --numValidMembers;
                                for (int mm = k; mm < numValidMembers - 1; ++mm) {
                                    tmpValues[mm] = tmpValues[mm + 1];
                                }
                                --k;
                            }
                            float[] newValues = new float[numValidMembers];
                            for (int k2 = 0; k2 < numValidMembers; ++k2) {
                                newValues[k2] = tmpValues[k2];
                            }
                            values[i][j] = GridMath.evaluateUProbability(newValues, statThreshold, numMembers);
                        }
                    }
                }
                FunctionType newFT = new FunctionType(((SetType)newDomain.getType()).getDomain(), newRangeType);
                FlatField newField = new FlatField(newFT, newDomain);
                newField.setSamples(values, false);
                if (newGrid == null) {
                    FunctionType newFieldType = new FunctionType(((SetType)timeDomain.getType()).getDomain(), newField.getType());
                    newGrid = new FieldImpl(newFieldType, timeDomain);
                }
                ((FieldImpl)newGrid).setSample(timeStepIdx, (Data)newField, false);
            }
            return newGrid;
        }
        catch (CloneNotSupportedException cnse) {
            throw new VisADException("Cannot clone field");
        }
        catch (RemoteException re) {
            throw new VisADException("RemoteException in applyFunctionOverTime");
        }
    }

    public static FieldImpl applyFunctionOverMembers(FieldImpl grid, String function) throws VisADException {
        try {
            FieldImpl newGrid = null;
            if (!GridUtil.isTimeSequence(grid)) {
                newGrid = (FlatField)grid.clone();
                return newGrid;
            }
            boolean doMax = function.equals(FUNC_MAX);
            boolean doMin = function.equals(FUNC_MIN);
            boolean doRange = function.equals(FUNC_RNG);
            Set timeDomain = Util.getDomainSet(grid);
            int numMembers = 0;
            Object rangeType = null;
            TupleType newRangeType = null;
            for (int timeStepIdx = 0; timeStepIdx < timeDomain.getLength(); ++timeStepIdx) {
                int i;
                float value;
                int j;
                int i2;
                float[][] ensStepValues;
                int k;
                FieldImpl sample = (FieldImpl)grid.getSample(timeStepIdx);
                Set ensDomain = sample.getDomainSet();
                numMembers = ensDomain.getLength();
                GriddedSet newDomain = null;
                float[][] values = null;
                float[][] stdevs = null;
                float[][] rangev = null;
                for (k = 0; k < numMembers; ++k) {
                    FlatField innerField = (FlatField)sample.getSample(k, false);
                    if (innerField == null) continue;
                    newDomain = (GriddedSet)GridUtil.getSpatialDomain(innerField);
                    if (newRangeType == null) {
                        newRangeType = GridUtil.makeNewParamType(GridUtil.getParamType(innerField), "_" + function);
                    }
                    ensStepValues = innerField.getFloats(false);
                    if (values == null) {
                        values = Misc.cloneArray(ensStepValues);
                        rangev = Misc.cloneArray(ensStepValues);
                        continue;
                    }
                    for (i2 = 0; i2 < ensStepValues.length; ++i2) {
                        for (j = 0; j < ensStepValues[i2].length; ++j) {
                            value = ensStepValues[i2][j];
                            if (value != value) continue;
                            if (doMax) {
                                values[i2][j] = Math.max(values[i2][j], value);
                                continue;
                            }
                            if (doMin) {
                                values[i2][j] = Math.min(values[i2][j], value);
                                continue;
                            }
                            if (doRange) {
                                values[i2][j] = Math.max(values[i2][j], value);
                                rangev[i2][j] = Math.min(rangev[i2][j], value);
                                continue;
                            }
                            float[] fArray = values[i2];
                            int n = j;
                            fArray[n] = fArray[n] + value;
                        }
                    }
                }
                if (function.equals(FUNC_AVERAGE) && numMembers > 1) {
                    for (i = 0; i < values.length; ++i) {
                        for (int j2 = 0; j2 < values[i].length; ++j2) {
                            values[i][j2] = values[i][j2] / (float)numMembers;
                        }
                    }
                }
                if (function.equals(FUNC_RNG) && numMembers > 1) {
                    for (i = 0; i < values.length; ++i) {
                        for (int j3 = 0; j3 < values[i].length; ++j3) {
                            values[i][j3] = values[i][j3] - rangev[i][j3];
                        }
                    }
                }
                if (function.equals(FUNC_STDEV) && numMembers > 1) {
                    stdevs = new float[values.length][values[0].length];
                    for (i = 0; i < values.length; ++i) {
                        for (int j4 = 0; j4 < values[i].length; ++j4) {
                            values[i][j4] = values[i][j4] / (float)numMembers;
                        }
                    }
                    for (k = 0; k < numMembers; ++k) {
                        FlatField innerField = (FlatField)sample.getSample(k, false);
                        if (innerField == null) continue;
                        ensStepValues = innerField.getFloats(false);
                        for (i2 = 0; i2 < ensStepValues.length; ++i2) {
                            for (j = 0; j < ensStepValues[i2].length; ++j) {
                                value = ensStepValues[i2][j];
                                if (value != value) continue;
                                float[] fArray = stdevs[i2];
                                int n = j;
                                fArray[n] = fArray[n] + (values[i2][j] - value) * (values[i2][j] - value);
                            }
                        }
                    }
                    values = Misc.cloneArray(stdevs);
                    for (i = 0; i < values.length; ++i) {
                        for (int j5 = 0; j5 < values[i].length; ++j5) {
                            values[i][j5] = (float)Math.sqrt(values[i][j5] / (float)(numMembers - 1));
                        }
                    }
                }
                FunctionType newFT = new FunctionType(((SetType)newDomain.getType()).getDomain(), newRangeType);
                FlatField newField = new FlatField(newFT, newDomain);
                newField.setSamples(values, false);
                if (newGrid == null) {
                    FunctionType newFieldType = new FunctionType(((SetType)timeDomain.getType()).getDomain(), newField.getType());
                    newGrid = new FieldImpl(newFieldType, timeDomain);
                }
                ((FieldImpl)newGrid).setSample(timeStepIdx, (Data)newField, false);
            }
            return newGrid;
        }
        catch (CloneNotSupportedException cnse) {
            throw new VisADException("Cannot clone field");
        }
        catch (RemoteException re) {
            throw new VisADException("RemoteException in applyFunctionOverTime");
        }
    }

    public static FieldImpl applyFunctionOverLevels(FieldImpl grid, String function) throws VisADException {
        FieldImpl newField = null;
        try {
            if (GridUtil.isTimeSequence(grid)) {
                Set timeDomain = grid.getDomainSet();
                TupleType rangeType = null;
                Gridded2DSet newDomain = null;
                for (int timeStepIdx = 0; timeStepIdx < timeDomain.getLength(); ++timeStepIdx) {
                    FieldImpl sample = (FieldImpl)grid.getSample(timeStepIdx);
                    if (sample == null) continue;
                    FieldImpl funcFF = null;
                    if (!GridUtil.isSequence(sample)) {
                        funcFF = GridMath.applyFunctionOverLevelsFF((FlatField)sample, function, rangeType, newDomain);
                    } else {
                        Trace.call1("GridMath.applyFunctionOverLevels inner sequence");
                        Set ensDomain = sample.getDomainSet();
                        for (int j = 0; j < ensDomain.getLength(); ++j) {
                            FlatField innerFuncFF;
                            FlatField innerField = (FlatField)sample.getSample(j, false);
                            if (innerField == null || (innerFuncFF = GridMath.applyFunctionOverLevelsFF(innerField, function, rangeType, newDomain)) == null) continue;
                            if (rangeType == null) {
                                rangeType = GridUtil.getParamType(innerFuncFF);
                            }
                            if (newDomain == null) {
                                newDomain = (Gridded2DSet)GridUtil.getSpatialDomain(innerFuncFF);
                            }
                            if (funcFF == null) {
                                FunctionType innerType = new FunctionType(DataUtility.getDomainType(ensDomain), innerFuncFF.getType());
                                funcFF = new FieldImpl(innerType, ensDomain);
                            }
                            ((FieldImpl)funcFF).setSample(j, (Data)innerFuncFF, false);
                        }
                        Trace.call1("GridMath.applyFunctionOverLevels inner sequence");
                    }
                    if (funcFF == null) continue;
                    if (rangeType == null) {
                        rangeType = GridUtil.getParamType(funcFF);
                    }
                    if (newDomain == null) {
                        newDomain = (Gridded2DSet)GridUtil.getSpatialDomain(funcFF);
                    }
                    if (newField == null) {
                        FunctionType newFieldType = new FunctionType(((SetType)timeDomain.getType()).getDomain(), funcFF.getType());
                        newField = new FieldImpl(newFieldType, timeDomain);
                    }
                    ((FieldImpl)newField).setSample(timeStepIdx, (Data)funcFF, false);
                }
            } else {
                newField = GridMath.applyFunctionOverLevelsFF((FlatField)grid, function, null, null);
            }
            return newField;
        }
        catch (RemoteException re) {
            throw new VisADException("RemoteException in applyFunctionOverLevels");
        }
    }

    private static FlatField applyFunctionOverLevelsFF(FlatField grid, String function, TupleType newRangeType, Gridded2DSet newDomain) throws VisADException {
        boolean doMax = function.equals(FUNC_MAX);
        boolean doMin = function.equals(FUNC_MIN);
        if (newRangeType == null) {
            newRangeType = GridUtil.makeNewParamType(GridUtil.getParamType(grid), "_" + function);
        }
        FlatField newField = null;
        try {
            GriddedSet domainSet = (GriddedSet)GridUtil.getSpatialDomain(grid);
            int[] lengths = domainSet.getLengths();
            int sizeX = lengths[0];
            int sizeY = lengths[1];
            int sizeZ = lengths.length == 2 || domainSet.getManifoldDimension() == 2 ? 1 : lengths[2];
            float[][] samples = grid.getFloats(false);
            float[][] newValues = new float[samples.length][sizeX * sizeY];
            for (int np = 0; np < samples.length; ++np) {
                float[] paramVals = samples[np];
                float[] newVals = newValues[np];
                for (int j = 0; j < sizeY; ++j) {
                    for (int i = 0; i < sizeX; ++i) {
                        int numNonMissing = 0;
                        float result = Float.NaN;
                        for (int k = 0; k < sizeZ; ++k) {
                            int index = k * sizeX * sizeY + j * sizeX + i;
                            float value = paramVals[index];
                            if (value != value) continue;
                            if (result != result) {
                                result = value;
                                ++numNonMissing;
                                continue;
                            }
                            if (doMax) {
                                result = Math.max(result, value);
                                continue;
                            }
                            if (doMin) {
                                result = Math.min(result, value);
                                continue;
                            }
                            result += value;
                            ++numNonMissing;
                        }
                        if (function.equals(FUNC_AVERAGE) && numNonMissing != 0) {
                            result /= (float)numNonMissing;
                        }
                        int newindex = j * sizeX + i;
                        newVals[newindex] = result;
                    }
                }
            }
            if (newDomain == null) {
                newDomain = GridUtil.makeDomain2D(domainSet);
            }
            FunctionType newFT = new FunctionType(((SetType)newDomain.getType()).getDomain(), newRangeType);
            newField = new FlatField(newFT, newDomain);
            newField.setSamples(newValues, false);
        }
        catch (RemoteException re) {
            throw new VisADException("RemoteException checking missing data");
        }
        return newField;
    }

    public static FieldImpl applyFunctionToLevels(FieldImpl grid, String function) throws VisADException {
        FieldImpl newField = null;
        try {
            if (GridUtil.isTimeSequence(grid)) {
                Set timeDomain = grid.getDomainSet();
                TupleType rangeType = null;
                for (int timeStepIdx = 0; timeStepIdx < timeDomain.getLength(); ++timeStepIdx) {
                    FieldImpl sample = (FieldImpl)grid.getSample(timeStepIdx);
                    if (sample == null) continue;
                    FieldImpl funcFF = null;
                    if (!GridUtil.isSequence(sample)) {
                        funcFF = GridMath.applyFunctionToLevelsFF((FlatField)sample, function, rangeType);
                    } else {
                        Trace.call1("GridMath.applyFunctionOverLevels inner sequence");
                        Set ensDomain = sample.getDomainSet();
                        for (int j = 0; j < ensDomain.getLength(); ++j) {
                            FlatField innerFuncFF;
                            FlatField innerField = (FlatField)sample.getSample(j, false);
                            if (innerField == null || (innerFuncFF = GridMath.applyFunctionToLevelsFF(innerField, function, rangeType)) == null) continue;
                            if (rangeType == null) {
                                rangeType = GridUtil.getParamType(innerFuncFF);
                            }
                            if (funcFF == null) {
                                FunctionType innerType = new FunctionType(DataUtility.getDomainType(ensDomain), innerFuncFF.getType());
                                funcFF = new FieldImpl(innerType, ensDomain);
                            }
                            ((FieldImpl)funcFF).setSample(j, (Data)innerFuncFF, false);
                        }
                        Trace.call1("GridMath.applyFunctionOverLevels inner sequence");
                    }
                    if (funcFF == null) continue;
                    if (rangeType == null) {
                        rangeType = GridUtil.getParamType(funcFF);
                    }
                    if (newField == null) {
                        FunctionType newFieldType = new FunctionType(((SetType)timeDomain.getType()).getDomain(), funcFF.getType());
                        newField = new FieldImpl(newFieldType, timeDomain);
                    }
                    ((FieldImpl)newField).setSample(timeStepIdx, (Data)funcFF, false);
                }
            } else {
                newField = GridMath.applyFunctionToLevelsFF((FlatField)grid, function, null);
            }
            return newField;
        }
        catch (RemoteException re) {
            throw new VisADException("RemoteException checking missing data");
        }
    }

    private static FlatField applyFunctionToLevelsFF(FlatField grid, String function, TupleType newRangeType) throws VisADException {
        boolean doMax = function.equals(FUNC_MAX);
        boolean doMin = function.equals(FUNC_MIN);
        if (newRangeType == null) {
            newRangeType = GridUtil.makeNewParamType(GridUtil.getParamType(grid), "_" + function);
        }
        FlatField newField = (FlatField)GridUtil.setParamType((FieldImpl)grid, newRangeType, true);
        try {
            GriddedSet domainSet = (GriddedSet)GridUtil.getSpatialDomain(grid);
            int[] lengths = domainSet.getLengths();
            int sizeX = lengths[0];
            int sizeY = lengths[1];
            int sizeZ = lengths.length == 2 || domainSet.getManifoldDimension() == 2 ? 1 : lengths[2];
            float[][] samples = grid.getFloats(false);
            float[][] newValues = newField.getFloats(false);
            for (int np = 0; np < samples.length; ++np) {
                float[] paramVals = newValues[np];
                for (int k = 0; k < sizeZ; ++k) {
                    int index;
                    int i;
                    int j;
                    int numNonMissing = 0;
                    float result = Float.NaN;
                    for (j = 0; j < sizeY; ++j) {
                        for (i = 0; i < sizeX; ++i) {
                            index = k * sizeX * sizeY + j * sizeX + i;
                            float value = paramVals[index];
                            if (value != value) continue;
                            if (result != result) {
                                result = value;
                                ++numNonMissing;
                                continue;
                            }
                            if (doMax) {
                                result = Math.max(result, value);
                                continue;
                            }
                            if (doMin) {
                                result = Math.min(result, value);
                                continue;
                            }
                            result += value;
                            ++numNonMissing;
                        }
                    }
                    if (function.equals(FUNC_AVERAGE) && numNonMissing != 0) {
                        result /= (float)numNonMissing;
                    }
                    for (j = 0; j < sizeY; ++j) {
                        for (i = 0; i < sizeX; ++i) {
                            index = k * sizeX * sizeY + j * sizeX + i;
                            if (paramVals[index] != paramVals[index]) continue;
                            paramVals[index] = result;
                        }
                    }
                }
            }
            newField.setSamples(newValues, false);
        }
        catch (RemoteException re) {
            throw new VisADException("RemoteException checking missing data");
        }
        return newField;
    }

    public static FieldImpl applyFunctionToAxis(FieldImpl grid, String function, String axis) throws VisADException {
        FieldImpl newField = null;
        try {
            if (GridUtil.isTimeSequence(grid)) {
                Set timeDomain = grid.getDomainSet();
                TupleType rangeType = null;
                for (int timeStepIdx = 0; timeStepIdx < timeDomain.getLength(); ++timeStepIdx) {
                    FieldImpl sample = (FieldImpl)grid.getSample(timeStepIdx);
                    if (sample == null) continue;
                    FieldImpl funcFF = null;
                    if (!GridUtil.isSequence(sample)) {
                        funcFF = GridMath.applyFunctionToAxisFF((FlatField)sample, function, axis, rangeType);
                    } else {
                        Trace.call1("GridMath.applyFunctionToAxis inner sequence");
                        Set ensDomain = sample.getDomainSet();
                        for (int j = 0; j < ensDomain.getLength(); ++j) {
                            FlatField innerFuncFF;
                            FlatField innerField = (FlatField)sample.getSample(j, false);
                            if (innerField == null || (innerFuncFF = GridMath.applyFunctionToAxisFF(innerField, function, axis, rangeType)) == null) continue;
                            if (rangeType == null) {
                                rangeType = GridUtil.getParamType(innerFuncFF);
                            }
                            if (funcFF == null) {
                                FunctionType innerType = new FunctionType(DataUtility.getDomainType(ensDomain), innerFuncFF.getType());
                                funcFF = new FieldImpl(innerType, ensDomain);
                            }
                            ((FieldImpl)funcFF).setSample(j, (Data)innerFuncFF, false);
                        }
                        Trace.call1("GridMath.applyFunctionToAxis inner sequence");
                    }
                    if (funcFF == null) continue;
                    if (rangeType == null) {
                        rangeType = GridUtil.getParamType(funcFF);
                    }
                    if (newField == null) {
                        FunctionType newFieldType = new FunctionType(((SetType)timeDomain.getType()).getDomain(), funcFF.getType());
                        newField = new FieldImpl(newFieldType, timeDomain);
                    }
                    ((FieldImpl)newField).setSample(timeStepIdx, (Data)funcFF, false);
                }
            } else {
                newField = GridMath.applyFunctionToAxisFF((FlatField)grid, function, axis, null);
            }
            return newField;
        }
        catch (RemoteException re) {
            throw new VisADException("RemoteException checking missing data");
        }
    }

    private static FlatField applyFunctionToAxisFF(FlatField grid, String function, String axis, TupleType newRangeType) throws VisADException {
        boolean doMax = function.equals(FUNC_MAX);
        boolean doMin = function.equals(FUNC_MIN);
        if (newRangeType == null) {
            newRangeType = GridUtil.makeNewParamType(GridUtil.getParamType(grid), "_" + axis + function);
        }
        FlatField newField = (FlatField)GridUtil.setParamType((FieldImpl)grid, newRangeType, true);
        try {
            GriddedSet domainSet = (GriddedSet)GridUtil.getSpatialDomain(grid);
            int[] lengths = domainSet.getLengths();
            int sizeX = lengths[0];
            int sizeY = lengths[1];
            int sizeZ = lengths.length == 2 || domainSet.getManifoldDimension() == 2 ? 1 : lengths[2];
            float[][] samples = grid.getFloats(false);
            float[][] newValues = newField.getFloats(false);
            int outer = axis.equals(AXIS_X) ? sizeY : sizeX;
            int inner = axis.equals(AXIS_X) ? sizeX : sizeY;
            for (int np = 0; np < samples.length; ++np) {
                float[] paramVals = newValues[np];
                for (int k = 0; k < sizeZ; ++k) {
                    for (int j = 0; j < outer; ++j) {
                        int index;
                        int i;
                        int numNonMissing = 0;
                        float result = Float.NaN;
                        for (i = 0; i < inner; ++i) {
                            index = axis.equals(AXIS_X) ? k * inner * outer + j * inner + i : k * inner * outer + i * outer + j;
                            float value = paramVals[index];
                            if (value != value) continue;
                            if (result != result) {
                                result = value;
                                ++numNonMissing;
                                continue;
                            }
                            if (doMax) {
                                result = Math.max(result, value);
                                continue;
                            }
                            if (doMin) {
                                result = Math.min(result, value);
                                continue;
                            }
                            result += value;
                            ++numNonMissing;
                        }
                        if (function.equals(FUNC_AVERAGE) && numNonMissing != 0) {
                            result /= (float)numNonMissing;
                        }
                        for (i = 0; i < inner; ++i) {
                            int n = index = axis.equals(AXIS_X) ? k * inner * outer + j * inner + i : k * inner * outer + i * outer + j;
                            if (paramVals[index] != paramVals[index]) continue;
                            paramVals[index] = result;
                        }
                    }
                }
            }
            newField.setSamples(newValues, false);
        }
        catch (RemoteException re) {
            throw new VisADException("RemoteException checking missing data");
        }
        return newField;
    }

    public static FieldImpl ddx(FieldImpl grid) throws VisADException, RemoteException {
        return GridMath.partial(grid, GridMath.getIndex(grid, AXIS_X));
    }

    public static FieldImpl ddy(FieldImpl grid) throws VisADException, RemoteException {
        return GridMath.partial(grid, GridMath.getIndex(grid, AXIS_Y));
    }

    private static int getIndex(FieldImpl grid, String xOry) throws VisADException, RemoteException {
        int index = xOry.equalsIgnoreCase(AXIS_X) ? 0 : 1;
        MapProjection mp = GridUtil.getNavigation(grid);
        if (!mp.isXYOrder()) {
            index = 1 - index;
        }
        return index;
    }

    public static FieldImpl partial(FieldImpl grid, int domainIndex) throws VisADException, RemoteException {
        SampledSet ss = GridUtil.getSpatialDomain(grid);
        RealType rt = (RealType)((SetType)ss.getType()).getDomain().getComponent(domainIndex);
        return GridMath.partial(grid, rt);
    }

    private static FieldImpl partial(FieldImpl grid, RealType var) throws VisADException, RemoteException {
        boolean isSequence = GridUtil.isTimeSequence(grid);
        FieldImpl retField = null;
        if (isSequence) {
            Set s = GridUtil.getTimeSet(grid);
            Boolean ensble = GridUtil.hasEnsemble(grid);
            TupleType rangeType = null;
            FunctionType innerType = null;
            for (int i = 0; i < s.getLength(); ++i) {
                DataImpl funcFF = null;
                if (ensble.booleanValue()) {
                    FieldImpl sample = (FieldImpl)grid.getSample(i);
                    Set ensDomain = sample.getDomainSet();
                    for (int j = 0; j < ensDomain.getLength(); ++j) {
                        FlatField innerField = (FlatField)sample.getSample(j, false);
                        if (innerField == null) continue;
                        FlatField innerFuncFF = GridMath.partial(innerField, var);
                        if (rangeType == null) {
                            rangeType = GridUtil.getParamType(innerFuncFF);
                            innerType = new FunctionType(DataUtility.getDomainType(ensDomain), innerFuncFF.getType());
                        }
                        if (funcFF == null) {
                            funcFF = new FieldImpl(innerType, ensDomain);
                        }
                        ((FieldImpl)funcFF).setSample(j, innerFuncFF, false);
                    }
                    if (i == 0) {
                        FunctionType newFieldType = new FunctionType(((SetType)s.getType()).getDomain(), funcFF.getType());
                        retField = new FieldImpl(newFieldType, s);
                    }
                    ((FieldImpl)retField).setSample(i, funcFF, false);
                    continue;
                }
                FlatField f = GridMath.partial((FlatField)grid.getSample(i), var);
                if (i == 0) {
                    FunctionType ftype = new FunctionType(((SetType)s.getType()).getDomain(), f.getType());
                    retField = new FieldImpl(ftype, s);
                }
                ((FieldImpl)retField).setSample(i, (Data)f, false);
            }
        } else {
            retField = GridMath.partial((FlatField)grid, var);
        }
        return retField;
    }

    private static FlatField partial(FlatField f, RealType var) throws VisADException, RemoteException {
        FlatField fToUse = f;
        SampledSet domain = GridUtil.getSpatialDomain(f);
        boolean twoDManifold = false;
        if (domain.getDimension() != domain.getManifoldDimension()) {
            twoDManifold = true;
            if (!MathType.findScalarType((fToUse = (FlatField)GridUtil.make2DGridFromSlice(fToUse, false)).getType(), var)) {
                throw new VisADException("Multiple levels needed for partial with respect to vertical dimension");
            }
        }
        FlatField retField = (FlatField)fToUse.derivative(var, 202);
        if (twoDManifold) {
            retField = (FlatField)GridUtil.setSpatialDomain(retField, domain);
        }
        if (var.equals(RealType.Longitude) || var.getName().toLowerCase().startsWith("lon")) {
            FlatField latGrid = (FlatField)DerivedGridFactory.createLatitudeGrid(retField);
            FlatField latCosGrid = (FlatField)latGrid.cosDegrees();
            latCosGrid = (FlatField)latCosGrid.max(new Real(Math.cos(Math.toRadians(89.0))));
            FlatField factor = (FlatField)latCosGrid.multiply(KM_PER_DEGREE);
            retField = (FlatField)retField.divide(factor);
        } else if (var.equals(RealType.Latitude) || var.getName().toLowerCase().startsWith("lat")) {
            retField = (FlatField)retField.divide(KM_PER_DEGREE);
        }
        return retField;
    }

    public static float evaluatePercentile(float[] values, int begin, int length, double p) throws VisADException {
        if (p > 100.0 || p <= 0.0) {
            throw new VisADException("out of bounds percentile value:  must be in (0, 100)");
        }
        if (length == 0) {
            return Float.NaN;
        }
        if (length == 1) {
            return values[begin];
        }
        double n = length;
        double pos = p * (n + 1.0) / 100.0;
        double fpos = Math.floor(pos);
        int intPos = (int)fpos;
        float dif = (float)(pos - fpos);
        float[] sorted = new float[length];
        System.arraycopy(values, begin, sorted, 0, length);
        QuickSort.sort(sorted);
        if (pos < 1.0) {
            return sorted[0];
        }
        if (pos >= n) {
            return sorted[length - 1];
        }
        float lower = sorted[intPos - 1];
        float upper = sorted[intPos];
        return lower + dif * (upper - lower);
    }

    public static float evaluateMode(float[] data) {
        int size = data.length;
        float oldmd = 0.0f;
        int oldcount = 0;
        for (int t = 0; t < size; ++t) {
            float md = data[t];
            int count = 1;
            for (int w = t + 1; w < size; ++w) {
                if (md != data[w]) continue;
                ++count;
            }
            if (count <= oldcount) continue;
            oldmd = md;
            oldcount = count;
        }
        return oldmd;
    }

    public static float evaluateUProbability(float[] values, float pValue, int length) throws VisADException {
        int kk;
        int kk2;
        double floatDiffTol = 1.0E-6;
        double[] weights = new double[values.length];
        for (int ii = 0; ii < values.length; ++ii) {
            weights[ii] = 1.0 / (double)values.length;
        }
        boolean iswflg = true;
        for (int istop = values.length - 1; iswflg && istop > 0; --istop) {
            iswflg = false;
            for (int kk3 = 0; kk3 < istop; ++kk3) {
                if (!(values[kk3] > values[kk3 + 1])) continue;
                iswflg = true;
                float swpbuf = values[kk3];
                double wtbuf = weights[kk3];
                values[kk3] = values[kk3 + 1];
                weights[kk3] = weights[kk3 + 1];
                values[kk3 + 1] = swpbuf;
                weights[kk3 + 1] = wtbuf;
            }
        }
        int mm = values.length;
        double[] zfreq = new double[values.length];
        for (int kk4 = 0; kk4 < mm; ++kk4) {
            zfreq[kk4] = 1.0;
        }
        double tol = 0.001 * (double)(values[mm - 1] - values[0]) / (double)mm;
        for (int kk5 = 0; kk5 < mm - 1; ++kk5) {
            if (!((double)Math.abs(values[kk5] - values[kk5 + 1]) <= tol)) continue;
            int n = kk5;
            weights[n] = weights[n] + weights[kk5 + 1];
            zfreq[kk5] = zfreq[kk5] + 1.0;
            --mm;
            for (int jj = kk5; jj < mm - 1; ++jj) {
                values[jj] = values[jj + 1];
                weights[jj] = weights[jj + 1];
            }
            --kk5;
        }
        if (mm == 1) {
            if (Math.abs((double)values[0] - 0.0) < floatDiffTol) {
                values[0] = -1.0E-5f;
                values[1] = 1.0E-5f;
            } else {
                float delta = 1.0E-5f * Math.abs(values[0]);
                values[1] = values[0] + delta;
                values[0] = values[0] - delta;
            }
            weights[0] = 0.5;
            weights[1] = 0.5;
            mm = 2;
            zfreq[0] = 1.0;
            zfreq[1] = 1.0;
        }
        double[] zwts = new double[mm];
        zwts[0] = zfreq[0] / (double)(values[1] - values[0]);
        double zsum = zwts[0];
        for (int kk6 = 1; kk6 < mm - 1; ++kk6) {
            zwts[kk6] = zfreq[kk6] * 2.0 / (double)(values[kk6 + 1] - values[kk6 - 1]);
            zsum += zwts[kk6];
        }
        zwts[mm - 1] = zfreq[mm - 1] / (double)(values[mm - 1] - values[mm - 2]);
        zsum += zwts[mm - 1];
        double psum = 0.0;
        for (kk2 = 0; kk2 < mm; ++kk2) {
            weights[kk2] = zwts[kk2] / zsum * weights[kk2];
            psum += weights[kk2];
        }
        for (kk2 = 0; kk2 < mm; ++kk2) {
            weights[kk2] = weights[kk2] / psum;
        }
        double vn = 0.0;
        for (kk = 1; kk < mm; ++kk) {
            vn += 0.5 * (weights[kk] + weights[kk - 1]) * (double)(values[kk] - values[kk - 1]);
        }
        vn /= 1.0 - 2.0 / ((double)length + 1.0);
        for (kk = 0; kk < mm; ++kk) {
            weights[kk] = weights[kk] / vn;
        }
        double qlt = (double)values[0] - 2.0 / (weights[0] * ((double)length + 1.0));
        double qrt = (double)values[mm - 1] + 2.0 / (weights[mm - 1] * ((double)length + 1.0));
        double[] newWeights = new double[mm + 2];
        double[] newValues = new double[mm + 2];
        newWeights[0] = 0.0;
        newWeights[mm + 1] = 0.0;
        newValues[0] = qlt;
        newValues[mm + 1] = qrt;
        for (int ii = 1; ii < mm + 1; ++ii) {
            newWeights[ii] = weights[ii - 1];
            newValues[ii] = values[ii - 1];
        }
        float prob = 0.0f;
        if ((double)pValue < newValues[0]) {
            prob = 0.0f;
        } else if ((double)pValue > newValues[mm + 1]) {
            prob = 1.0f;
        } else {
            psum = 0.0;
            for (int kk7 = 1; kk7 < mm + 2; ++kk7) {
                if (Math.abs((double)pValue - newValues[kk7 - 1]) < floatDiffTol) {
                    prob = (float)psum;
                    break;
                }
                if ((double)pValue >= newValues[kk7]) {
                    psum += 0.5 * (newWeights[kk7] + newWeights[kk7 - 1]) * (newValues[kk7] - newValues[kk7 - 1]);
                    continue;
                }
                if (!((double)pValue > newValues[kk7 - 1])) continue;
                double ww = newWeights[kk7 - 1] + (newWeights[kk7] - newWeights[kk7 - 1]) * ((double)pValue - newValues[kk7 - 1]) / (newValues[kk7] - newValues[kk7 - 1]);
                double fta = 0.5 * (ww + newWeights[kk7 - 1]) * ((double)pValue - newValues[kk7 - 1]);
                prob = (float)psum + (float)fta;
                break;
            }
        }
        return prob;
    }

    public static FieldImpl applyFunctionOverGridsExt(FieldImpl field, String function) throws VisADException {
        FieldImpl fi = field;
        boolean doExp = function.equals(FUNC_EXP);
        if (!doExp) {
            return null;
        }
        try {
            Set timeSet = GridUtil.getTimeSet(field);
            fi = new FieldImpl((FunctionType)field.getType(), timeSet);
            for (int i = 0; i < timeSet.getLength(); ++i) {
                FlatField data = (FlatField)field.getSample(i, false);
                FlatField data1 = GridMath.applyFunctionOverGrids0(new FlatField[]{data}, FUNC_EXP);
                fi.setSample(i, (Data)data1, false);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return fi;
    }

    public static FieldImpl calculateHelicity(FieldImpl gridu, FieldImpl gridv, float bottom, float top, float ux, float vy) throws VisADException {
        FieldImpl newField = null;
        try {
            if (GridUtil.isTimeSequence(gridu)) {
                Set timeDomain = gridu.getDomainSet();
                TupleType rangeType = null;
                Gridded2DSet newDomain = null;
                for (int timeStepIdx = 0; timeStepIdx < timeDomain.getLength(); ++timeStepIdx) {
                    FieldImpl sample = (FieldImpl)gridu.getSample(timeStepIdx);
                    FieldImpl sample1 = (FieldImpl)gridv.getSample(timeStepIdx);
                    if (sample == null) continue;
                    FieldImpl funcFF = null;
                    float pinc = 250.0f;
                    if (ux == 0.0f && vy == 0.0f) {
                        double usum = 0.0;
                        double vsum = 0.0;
                        double psum = 0.0;
                        FieldImpl agridu = GridMath.applyFunctionToLevels(gridu, FUNC_AVERAGE);
                        FieldImpl agridv = GridMath.applyFunctionToLevels(gridv, FUNC_AVERAGE);
                        FlatField pFI = DerivedGridFactory.createPressureGridFromDomain((FlatField)gridu.getSample(0));
                        int n = (int)((top - bottom) / pinc);
                        for (int i = 0; i < n; ++i) {
                            float plevel = bottom + pinc * (float)i;
                            Unit unit = Util.parseUnit("meter");
                            Real altt = new Real(RealType.Altitude, plevel, unit);
                            FieldImpl agridu0 = GridUtil.sliceAtLevel(agridu, altt);
                            FieldImpl agridv0 = GridUtil.sliceAtLevel(agridv, altt);
                            FieldImpl pFI0 = GridUtil.sliceAtLevel((FieldImpl)pFI, altt);
                            Range[] ur = GridUtil.fieldMinMax((FlatField)agridu0.getSample(0));
                            Range[] vr = GridUtil.fieldMinMax((FlatField)agridv0.getSample(0));
                            Range[] pr = GridUtil.fieldMinMax((FlatField)pFI0);
                            if (!(ur[0].max < 100.0) || !(vr[0].max < 100.0)) continue;
                            usum += ur[0].max * (double)plevel;
                            vsum += vr[0].max * (double)plevel;
                            psum += pr[0].max;
                        }
                        ux = (float)(usum / psum);
                        vy = (float)(vsum / psum);
                    }
                    if (!GridUtil.isSequence(sample)) {
                        sample = (FlatField)sample.subtract(new Real(ux));
                        sample1 = (FlatField)sample1.subtract(new Real(vy));
                        funcFF = GridMath.calculateHelicityFF((FlatField)sample, (FlatField)sample1, rangeType, newDomain);
                    } else {
                        Trace.call1("GridMath.applyFunctionOverLevels inner sequence");
                        Set ensDomain = sample.getDomainSet();
                        for (int j = 0; j < ensDomain.getLength(); ++j) {
                            FlatField innerFuncFF;
                            FlatField innerField = (FlatField)sample.getSample(j, false);
                            FlatField innerField1 = (FlatField)sample1.getSample(j, false);
                            if (innerField == null || (innerFuncFF = GridMath.calculateHelicityFF(innerField = (FlatField)innerField.subtract(new Real(ux)), innerField1 = (FlatField)innerField1.subtract(new Real(vy)), rangeType, newDomain)) == null) continue;
                            if (rangeType == null) {
                                rangeType = GridUtil.getParamType(innerFuncFF);
                            }
                            if (newDomain == null) {
                                newDomain = (Gridded2DSet)GridUtil.getSpatialDomain(innerFuncFF);
                            }
                            if (funcFF == null) {
                                FunctionType innerType = new FunctionType(DataUtility.getDomainType(ensDomain), innerFuncFF.getType());
                                funcFF = new FieldImpl(innerType, ensDomain);
                            }
                            ((FieldImpl)funcFF).setSample(j, (Data)innerFuncFF, false);
                        }
                        Trace.call1("GridMath.applyFunctionOverLevels inner sequence");
                    }
                    if (funcFF == null) continue;
                    if (rangeType == null) {
                        rangeType = GridUtil.getParamType(funcFF);
                    }
                    if (newDomain == null) {
                        newDomain = (Gridded2DSet)GridUtil.getSpatialDomain(funcFF);
                    }
                    if (newField == null) {
                        FunctionType newFieldType = new FunctionType(((SetType)timeDomain.getType()).getDomain(), funcFF.getType());
                        newField = new FieldImpl(newFieldType, timeDomain);
                    }
                    ((FieldImpl)newField).setSample(timeStepIdx, (Data)funcFF, false);
                }
            } else {
                gridu = (FlatField)gridu.subtract(new Real(ux));
                gridv = (FlatField)gridv.subtract(new Real(vy));
                newField = GridMath.calculateHelicityFF((FlatField)gridu, (FlatField)gridv, null, null);
            }
            return newField;
        }
        catch (RemoteException re) {
            throw new VisADException("RemoteException in applyFunctionOverLevels");
        }
    }

    private static FlatField calculateHelicityFF(FlatField gridu, FlatField gridv, TupleType newRangeType, Gridded2DSet newDomain) throws VisADException {
        if (newRangeType == null) {
            Unit[][] uu = gridu.getRangeUnits();
            Unit[][] vu = gridu.getRangeUnits();
            DerivedUnit dunit = (DerivedUnit)uu[0][0];
            DerivedUnit dunit1 = (DerivedUnit)vu[0][0];
            newRangeType = new RealTupleType(DataUtil.makeRealType("helicity", dunit.multiply(dunit1)));
        }
        FlatField newField = null;
        try {
            GriddedSet domainSet = (GriddedSet)GridUtil.getSpatialDomain(gridu);
            int[] lengths = domainSet.getLengths();
            int sizeX = lengths[0];
            int sizeY = lengths[1];
            int sizeZ = lengths.length == 2 || domainSet.getManifoldDimension() == 2 ? 1 : lengths[2];
            float[][] samples = gridu.getFloats(false);
            float[][] samples1 = gridv.getFloats(false);
            float[][] newValues = new float[samples.length][sizeX * sizeY];
            for (int np = 0; np < samples.length; ++np) {
                float[] paramVals = samples[np];
                float[] paramVals1 = samples1[np];
                float[] newVals = newValues[np];
                for (int j = 0; j < sizeY; ++j) {
                    for (int i = 0; i < sizeX; ++i) {
                        int numNonMissing = 0;
                        float result = Float.NaN;
                        for (int k = 0; k < sizeZ - 1; ++k) {
                            int index1 = (k + 1) * sizeX * sizeY + j * sizeX + i;
                            int index = k * sizeX * sizeY + j * sizeX + i;
                            float value = paramVals[index1] * paramVals1[index] - paramVals[index] * paramVals1[index1];
                            if (value != value) continue;
                            if (result != result && value > 0.0f) {
                                result = value;
                                ++numNonMissing;
                                continue;
                            }
                            if (!(value > 0.0f)) continue;
                            result += value;
                            ++numNonMissing;
                        }
                        int newindex = j * sizeX + i;
                        newVals[newindex] = result;
                    }
                }
            }
            if (newDomain == null) {
                newDomain = GridUtil.makeDomain2D(domainSet);
            }
            FunctionType newFT = new FunctionType(((SetType)newDomain.getType()).getDomain(), newRangeType);
            newField = new FlatField(newFT, newDomain);
            newField.setSamples(newValues, false);
        }
        catch (RemoteException re) {
            throw new VisADException("RemoteException checking missing data");
        }
        return newField;
    }

    static {
        try {
            Unit kmPerDegree = DataUtil.parseUnit("km/degree");
            KM_PER_DEGREE = new Real(DataUtil.makeRealType("kmPerDegree", kmPerDegree), 111.0, kmPerDegree);
            NEGATIVE_ONE = new Real(-1.0);
        }
        catch (Exception ex) {
            throw new ExceptionInInitializerError(ex.toString());
        }
    }
}

