/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.data.grid;

import java.util.Hashtable;
import java.util.List;
import ucar.unidata.data.DataCategory;
import ucar.unidata.data.DataSourceDescriptor;
import ucar.unidata.data.FilesDataSource;
import ucar.unidata.util.Misc;

public abstract class GridDataSource
extends FilesDataSource {
    public static final String ATTR_NORTH = "north";
    public static final String ATTR_SOUTH = "south";
    public static final String ATTR_EAST = "east";
    public static final String ATTR_WEST = "west";
    public static final String ATTR_X = "x";
    public static final String ATTR_Y = "y";
    public static final String ATTR_Z = "z";
    private List twoDCategories;
    private List threeDCategories;
    private List twoDTimeSeriesCategories;
    private List twoDEnsTimeSeriesCategories;
    private List threeDTimeSeriesCategories;
    private List threeDEnsTimeSeriesCategories;
    private DataCategory ensDCategory;
    public static final String PROP_ENSEMBLEMEMBERS = "prop.gridmembers";

    public GridDataSource() {
        this.initCategories();
    }

    public GridDataSource(DataSourceDescriptor descriptor) {
        super(descriptor);
        this.initCategories();
    }

    public GridDataSource(DataSourceDescriptor descriptor, String source, String name, Hashtable properties) {
        super(descriptor, Misc.newList(source), source, name, properties);
        this.initCategories();
    }

    public GridDataSource(DataSourceDescriptor descriptor, List sources, String name, Hashtable properties) {
        super(descriptor, sources, name, properties);
        this.initCategories();
    }

    public void initCategories() {
        if (this.twoDTimeSeriesCategories == null) {
            this.twoDTimeSeriesCategories = DataCategory.parseCategories("2D grid;GRID-2D-TIME;");
            this.twoDEnsTimeSeriesCategories = DataCategory.parseCategories("2D grid;GRID-2D-TIME;ENSEMBLE;");
            this.twoDCategories = DataCategory.parseCategories("2D grid;GRID-2D;");
            this.threeDTimeSeriesCategories = DataCategory.parseCategories("3D grid;GRID-3D-TIME;");
            this.threeDEnsTimeSeriesCategories = DataCategory.parseCategories("3D grid;GRID-3D-TIME;ENSEMBLE;");
            this.threeDCategories = DataCategory.parseCategories("3D grid;GRID-3D;");
            this.ensDCategory = DataCategory.parseCategory("ENSEMBLE", true);
        }
    }

    public DataCategory getEnsDCategory() {
        return this.ensDCategory;
    }

    public List getTwoDCategories() {
        return this.twoDCategories;
    }

    public List getThreeDCategories() {
        return this.threeDCategories;
    }

    public List getTwoDTimeSeriesCategories() {
        return this.twoDTimeSeriesCategories;
    }

    public List getTwoDEnsTimeSeriesCategories() {
        return this.twoDEnsTimeSeriesCategories;
    }

    public List getThreeDTimeSeriesCategories() {
        return this.threeDTimeSeriesCategories;
    }

    public List getThreeDEnsTimeSeriesCategories() {
        return this.threeDEnsTimeSeriesCategories;
    }

    public void setEnsembleSelection(List<Integer> ensMembers) {
        if (ensMembers != null) {
            this.getProperties().put(PROP_ENSEMBLEMEMBERS, ensMembers);
        }
    }

    public List<Integer> getEnsembleSelection() {
        return (List)this.getProperties().get(PROP_ENSEMBLEMEMBERS);
    }
}

