/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.data.grid;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import ucar.unidata.data.DataChoice;
import ucar.unidata.data.DataInstance;
import ucar.unidata.data.DataSelection;
import ucar.unidata.data.grid.GridUtil;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.ObjectArray;
import ucar.unidata.util.Range;
import ucar.unidata.util.ThreeDSize;
import ucar.unidata.util.Trace;
import ucar.visad.Util;
import ucar.visad.data.CalendarDateTime;
import visad.CoordinateSystem;
import visad.Data;
import visad.DateTime;
import visad.EarthVectorType;
import visad.FieldImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.GridVectorType;
import visad.Gridded1DSet;
import visad.Gridded3DSet;
import visad.MathType;
import visad.Real;
import visad.RealTupleType;
import visad.RealType;
import visad.RealVectorType;
import visad.SampledSet;
import visad.SetType;
import visad.TupleType;
import visad.Unit;
import visad.VisADException;
import visad.georef.LatLonPoint;
import visad.georef.MapProjection;

public class GridDataInstance
extends DataInstance {
    static LogUtil.LogCategory log_ = LogUtil.getLogInstance(GridDataInstance.class.getName());
    private FieldImpl gridData;
    private FieldImpl origData;
    private RealType[] realTypes;
    private Range[] ranges;
    private DateTime[] dateTimes = null;
    private boolean isTimeSequence = false;
    private boolean is3D = false;
    private boolean isEnsemble = false;
    private Gridded1DSet ensSet = null;
    private int numEns = 0;
    private Real[] levels;
    private float[][] coords3D;
    private Gridded3DSet domainSet3D;
    private SampledSet spatialSet;
    private ThreeDSize size;
    private Unit zUnit = null;
    private RealType zType;
    private TupleType rangeType;
    private boolean reInit = false;
    private boolean haveChangedType = false;

    public GridDataInstance(DataChoice dataChoice, DataSelection dataSelection, Hashtable requestProperties) throws VisADException, RemoteException {
        this(dataChoice, dataSelection, requestProperties, null);
    }

    public GridDataInstance(DataChoice dataChoice, DataSelection dataSelection, Hashtable requestProperties, Data theData) throws VisADException, RemoteException {
        super(dataChoice, dataSelection, requestProperties, theData);
        this.init();
    }

    @Override
    public synchronized void reInitialize() throws VisADException, RemoteException {
        this.levels = null;
        this.coords3D = null;
        this.reInit = true;
        this.gridData = null;
        this.origData = null;
        this.haveChangedType = false;
        super.reInitialize();
    }

    @Override
    protected void init() throws VisADException, RemoteException {
        RealTupleType spatialReferenceType;
        if (this.haveBeenInitialized) {
            return;
        }
        super.init();
        Trace.call1("GridDataInstance.init");
        Trace.call1("GridDataInstance.getData");
        this.origData = (FieldImpl)this.getData();
        if (this.origData == null) {
            this.inError = true;
            return;
        }
        this.gridData = this.origData;
        this.origData = null;
        Trace.call2("GridDataInstance.getData");
        boolean isSequence = GridUtil.isSequence(this.gridData);
        this.isTimeSequence = GridUtil.isTimeSequence(this.gridData);
        if (this.isTimeSequence) {
            SampledSet timeSet = (SampledSet)Util.getDomainSet(this.gridData);
            this.dateTimes = timeSet instanceof Gridded1DSet ? CalendarDateTime.timeSetToArray((Gridded1DSet)timeSet) : CalendarDateTime.timeSetToArray(CalendarDateTime.makeTimeSet(timeSet.getDoubles()[0]));
        }
        String paramName = this.dataChoice.getStringId();
        if (this.dataChoice.getId() instanceof ObjectArray) {
            paramName = this.dataChoice.getDescription();
        }
        FlatField field = null;
        Data data = null;
        if (isSequence) {
            data = this.gridData.getSample(0);
            if (data instanceof FlatField) {
                this.isEnsemble = GridUtil.hasEnsemble(this.gridData);
                field = (FlatField)data;
            } else if (data instanceof FieldImpl) {
                this.isEnsemble = GridUtil.hasEnsemble((FieldImpl)data);
                field = (FlatField)((FieldImpl)data).getSample(0);
            }
        } else {
            field = (FlatField)this.gridData;
        }
        if (this.isEnsemble) {
            this.ensSet = GridUtil.getEnsembleSet(this.gridData);
            this.numEns = this.ensSet == null ? 0 : this.ensSet.getLength();
        }
        this.is3D = Util.getDomainSet(field).getManifoldDimension() == 3;
        this.spatialSet = (SampledSet)Util.getDomainSet(field);
        RealTupleType spatialType = ((SetType)this.spatialSet.getType()).getDomain();
        RealTupleType realTupleType = spatialReferenceType = this.spatialSet.getCoordinateSystem() != null ? this.spatialSet.getCoordinateSystem().getReference() : null;
        if (this.is3D) {
            this.zType = (RealType)spatialType.getComponent(2);
            this.zUnit = this.spatialSet.getSetUnits()[2];
            this.domainSet3D = (Gridded3DSet)this.spatialSet;
            this.size = new ThreeDSize(this.domainSet3D.getLengths());
        }
        if (!this.reInit) {
            MathType rType = ((FunctionType)field.getType()).getRange();
            int newNum = GridDataInstance.getNextId();
            if (rType instanceof RealType) {
                this.rangeType = this.getNewType((RealType)rType, newNum);
            } else if (rType instanceof RealVectorType) {
                this.rangeType = this.getNewType((RealVectorType)rType, newNum);
            } else if (rType instanceof RealTupleType) {
                this.rangeType = this.getNewType((RealTupleType)rType, newNum);
            } else if (rType instanceof TupleType) {
                TupleType tt = (TupleType)rType;
                MathType[] mts = new MathType[tt.getDimension()];
                for (int i = 0; i < tt.getDimension(); ++i) {
                    MathType mt = tt.getComponent(i);
                    if (mt instanceof RealType) {
                        mts[i] = this.getNewType((RealType)mt, newNum);
                        continue;
                    }
                    if (mt instanceof RealVectorType) {
                        mts[i] = this.getNewType((RealVectorType)mt, newNum);
                        continue;
                    }
                    if (!(mt instanceof RealTupleType)) continue;
                    mts[i] = this.getNewType((RealTupleType)mt, newNum);
                }
                this.rangeType = new TupleType(mts);
            }
            this.realTypes = this.rangeType.getRealComponents();
        }
        Trace.call2("GridDataInstance.init");
    }

    private RealTupleType getNewType(RealType rt, int newNum) throws VisADException, RemoteException {
        RealType[] types = new RealType[]{this.getRealType(rt.getName() + "_" + newNum, rt.getDefaultUnit())};
        return new RealTupleType(types);
    }

    private RealTupleType getNewType(RealTupleType rtt, int newNum) throws VisADException, RemoteException {
        RealType[] types = new RealType[rtt.getDimension()];
        for (int i = 0; i < rtt.getDimension(); ++i) {
            RealType tempRT = (RealType)rtt.getComponent(i);
            types[i] = this.getRealType(tempRT.getName() + "_" + newNum, tempRT.getDefaultUnit());
        }
        return new RealTupleType(types, rtt.getCoordinateSystem(), null);
    }

    private RealVectorType getNewType(RealVectorType evt, int newNum) throws VisADException, RemoteException {
        RealType[] types = new RealType[evt.getDimension()];
        for (int i = 0; i < evt.getDimension(); ++i) {
            RealType tempRT = (RealType)evt.getComponent(i);
            types[i] = this.getRealType(tempRT.getName() + "_" + newNum, tempRT.getDefaultUnit());
        }
        return evt instanceof EarthVectorType ? new EarthVectorType(types, evt.getCoordinateSystem()) : new GridVectorType(types, evt.getCoordinateSystem());
    }

    private void setParamType(boolean copy) throws VisADException {
        Trace.call1("GridDataInstance.calling setParamType", " copy=" + copy);
        this.gridData = GridUtil.setParamType(this.gridData, this.rangeType, copy);
        super.setData(this.gridData);
        Trace.call2("GridDataInstance.calling setParamType");
        this.haveChangedType = true;
    }

    public MapProjection getNavigation() {
        MapProjection mp = null;
        try {
            mp = GridUtil.getNavigation(this.getOriginalGrid());
        }
        catch (VisADException visADException) {
            // empty catch block
        }
        return mp;
    }

    public boolean isTimeSequence() {
        this.checkInit();
        return this.isTimeSequence;
    }

    public boolean is3D() {
        this.checkInit();
        return this.is3D;
    }

    public SampledSet getSpatialDomain() {
        return this.spatialSet;
    }

    public static Unit getZUnit(FieldImpl field) throws VisADException, RemoteException {
        RealTupleType rTT = ((FunctionType)field.getType()).getDomain();
        RealType zRT = (RealType)rTT.getComponent(2);
        return zRT.getDefaultUnit();
    }

    public Range getRange(int idx) {
        Range[] ranges = this.getRanges();
        if (idx < ranges.length) {
            return ranges[idx];
        }
        return ranges[0];
    }

    public Range[] getRanges() {
        if (this.ranges == null) {
            try {
                if (this.gridData != null) {
                    boolean isSequence = GridUtil.isSequence(this.gridData);
                    this.ranges = isSequence ? GridUtil.getMinMax(this.getOriginalGrid()) : GridUtil.fieldMinMax((FlatField)this.getOriginalGrid());
                }
            }
            catch (Exception exc) {
                LogUtil.printException(log_, "getRange", exc);
            }
        }
        return this.ranges;
    }

    public RealType getRealType(int idx) {
        this.checkInit();
        if (idx < this.realTypes.length) {
            return this.realTypes[idx];
        }
        return this.realTypes[0];
    }

    public int getNumRealTypes() {
        this.checkInit();
        return this.realTypes.length;
    }

    public MathType getRangeType() {
        this.checkInit();
        return this.rangeType;
    }

    public String getRealTypeName(int idx) {
        return this.getRealType(idx).getName();
    }

    public FieldImpl getFieldImpl() {
        return this.getGrid();
    }

    public FieldImpl getGrid() {
        return this.getGrid(false);
    }

    public FieldImpl getGrid(boolean copy) {
        this.checkInit();
        if (this.inError) {
            return null;
        }
        if (!this.haveChangedType) {
            try {
                this.setParamType(copy);
            }
            catch (VisADException exc) {
                LogUtil.logException("Changing parameter type", exc);
            }
        }
        return this.gridData;
    }

    private FieldImpl getOriginalGrid() {
        this.checkInit();
        return this.gridData;
    }

    public Unit getRawUnit(int idx) {
        return this.getRealType(idx).getDefaultUnit();
    }

    public Gridded3DSet getDomainSet3D() {
        this.checkInit();
        return this.domainSet3D;
    }

    public float[][] getCoords3D() {
        this.checkInit();
        if (this.coords3D == null) {
            Trace.call1("GridDataInstance:spatialSet.getSamples");
            try {
                this.coords3D = this.spatialSet.getSamples(false);
            }
            catch (Exception exc) {
                LogUtil.logException("GridDataInstance.getCoords3D", exc);
            }
            Trace.call1("GridDataInstance:spatialSet.getSamples");
        }
        return this.coords3D;
    }

    public CoordinateSystem getThreeDCoordTrans() {
        return this.getDomainSet3D() == null ? null : this.getDomainSet3D().getCoordinateSystem();
    }

    public ThreeDSize getSize() {
        this.checkInit();
        return this.size;
    }

    public int getSizeX() {
        return this.getSize().sizeX;
    }

    public int getSizeY() {
        return this.getSize().sizeY;
    }

    public int getSizeZ() {
        return this.getSize().sizeZ;
    }

    public FlatField getFlatField() {
        block6: {
            this.checkInit();
            if (this.gridData == null) {
                return null;
            }
            try {
                if (GridUtil.isSequence(this.gridData)) {
                    Data data = this.gridData.getSample(0);
                    if (data instanceof FlatField) {
                        return (FlatField)data;
                    }
                    if (data instanceof FieldImpl) {
                        return (FlatField)((FieldImpl)data).getSample(0);
                    }
                    break block6;
                }
                return (FlatField)this.gridData;
            }
            catch (Exception exc) {
                throw new RuntimeException(exc);
            }
        }
        return null;
    }

    public Unit getZUnit() {
        this.checkInit();
        return this.zUnit;
    }

    public RealType getZType() {
        this.checkInit();
        return this.zType;
    }

    public String getZUnitName() {
        return this.getZUnit().getIdentifier();
    }

    private String show(String name, Object o) {
        return " " + name + " " + (o == null ? "NULL" : o.toString());
    }

    public String toString() {
        return "GridDataInstance: \n\n" + (this.gridData == null ? " NULL  FIELDIMPL" : "") + "\n" + this.show("dataChoice", this.dataChoice) + "\n" + this.show("realTypes", this.realTypes) + "\n" + this.show("ranges", this.ranges) + "\n" + this.show("unit", this.getRawUnit(0)) + "\n" + this.show("domainSet3D", this.domainSet3D) + "\n" + "";
    }

    public Real[] getLevels() {
        this.checkInit();
        if (this.levels == null && this.size != null) {
            try {
                this.levels = new Real[this.size.sizeZ];
                float[][] coords = this.getCoords3D();
                for (int i = 0; i < this.size.sizeZ; ++i) {
                    this.levels[i] = new Real(this.zType, coords[2][i * this.size.sizeX * this.size.sizeY], this.zUnit);
                }
            }
            catch (Exception exc) {
                LogUtil.logException("GridDataInstance.getLevels", exc);
            }
        }
        return this.levels;
    }

    public DateTime[] getDateTimes() {
        this.checkInit();
        return this.dateTimes;
    }

    public FieldImpl sliceAtLevel(Real level) throws VisADException {
        return GridUtil.sliceAtLevel(this.getGrid(), level);
    }

    public FieldImpl sliceAlongLatLonLine(LatLonPoint start, LatLonPoint end) throws VisADException {
        return this.sliceAlongLatLonLine(start, end, 101);
    }

    public FieldImpl sliceAlongLatLonLine(LatLonPoint start, LatLonPoint end, int samplingMode) throws VisADException {
        ArrayList<LatLonPoint> points = new ArrayList<LatLonPoint>(2);
        points.add(start);
        points.add(end);
        return this.sliceAlongLatLonLine(points, samplingMode);
    }

    public FieldImpl sliceAlongLatLonLine(List<LatLonPoint> points, int samplingMode) throws VisADException {
        return GridUtil.sliceAlongLatLonLine(this.getGrid(), points, samplingMode);
    }

    public FieldImpl slice(SampledSet slice) throws VisADException {
        return GridUtil.slice(this.getGrid(), slice);
    }

    private RealType getRealType(String name, Unit u) throws VisADException, RemoteException {
        RealType rt = RealType.getRealType(Util.cleanName(name), u);
        if (rt == null) {
            rt = Util.makeRealType(name, u);
        }
        return rt;
    }

    public boolean isEnsemble() {
        this.checkInit();
        return this.isEnsemble;
    }

    public Gridded1DSet getEnsembleSet() {
        this.checkInit();
        return this.ensSet;
    }

    public int getNumEnsembles() {
        return this.numEns;
    }
}

