/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.data.grid;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.StringWriter;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.UUID;
import javax.swing.AbstractAction;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.MAMath;
import ucar.ma2.Range;
import ucar.ma2.RangeIterator;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NCdumpW;
import ucar.nc2.NetcdfFileWriter;
import ucar.nc2.constants.AxisType;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dataset.CoordinateAxis1DTime;
import ucar.nc2.dataset.CoordinateAxis2D;
import ucar.nc2.dataset.CoordinateTransform;
import ucar.nc2.dods.DODSNetcdfFile;
import ucar.nc2.ft2.coverage.Coverage;
import ucar.nc2.ft2.coverage.CoverageCollection;
import ucar.nc2.ft2.coverage.CoverageCoordAxis;
import ucar.nc2.ft2.coverage.CoverageCoordAxis1D;
import ucar.nc2.ft2.coverage.FeatureDatasetCoverage;
import ucar.nc2.ft2.coverage.SubsetParams;
import ucar.nc2.ft2.coverage.adapter.DtCoverage;
import ucar.nc2.ft2.coverage.adapter.DtCoverageAdapter;
import ucar.nc2.ft2.coverage.adapter.DtCoverageCS;
import ucar.nc2.ft2.coverage.adapter.DtCoverageDataset;
import ucar.nc2.ft2.coverage.writer.CFGridCoverageWriter2;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateRange;
import ucar.nc2.util.NamedAnything;
import ucar.nc2.util.NamedObject;
import ucar.nc2.util.Optional;
import ucar.unidata.data.BadDataException;
import ucar.unidata.data.DataCategory;
import ucar.unidata.data.DataChoice;
import ucar.unidata.data.DataSelection;
import ucar.unidata.data.DataSourceDescriptor;
import ucar.unidata.data.DataUtil;
import ucar.unidata.data.DerivedDataChoice;
import ucar.unidata.data.DirectDataChoice;
import ucar.unidata.data.GeoLocationInfo;
import ucar.unidata.data.GeoSelection;
import ucar.unidata.data.grid.GeoGridAdapter;
import ucar.unidata.data.grid.GeoGridDataSource;
import ucar.unidata.data.grid.GridCoverageAdapter;
import ucar.unidata.data.grid.GridDataSource;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.projection.LatLonProjection;
import ucar.unidata.geoloc.projection.VerticalPerspectiveView;
import ucar.unidata.geoloc.projection.sat.Geostationary;
import ucar.unidata.geoloc.projection.sat.MSGnavigation;
import ucar.unidata.idv.DisplayControl;
import ucar.unidata.ui.TextSearcher;
import ucar.unidata.util.CatalogUtil;
import ucar.unidata.util.FileManager;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.IOUtil;
import ucar.unidata.util.JobManager;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.StringUtil;
import ucar.unidata.util.ThreeDSize;
import ucar.unidata.util.Trace;
import ucar.unidata.util.TwoFacedObject;
import ucar.unidata.util.WrapperException;
import ucar.unidata.xml.XmlUtil;
import ucar.visad.Util;
import ucar.visad.data.CalendarDateTime;
import visad.Data;
import visad.DateTime;
import visad.FieldImpl;
import visad.Real;
import visad.VisADException;
import visad.georef.EarthLocationTuple;

public class GridCoverageDataSource
extends GridDataSource {
    public static final String PREF_VERTICALCS = "Data.VerticalCS";
    public static final String PREF_LARGE_REMOTE_DATA_WARN = "idv.largeremoterequest.warn";
    public static final String PROP_GRIDSIZE = "prop.gridsize";
    public static final String PROP_TIMESIZE = "prop.timesize";
    public static final String PROP_TIMEVAR = "timeVariable";
    private static final int SIZE_THRESHOLD = 120;
    private static final String PREFIX_GRIDRELATIVE = "GridRelative_";
    public static boolean testMode = false;
    static LogUtil.LogCategory log_ = LogUtil.getLogInstance(GeoGridDataSource.class.getName());
    private static String[] categoryAttributes = new String[]{"GRIB_param_category", "Grib2_Parameter_Category"};
    private static boolean forceSubset = false;
    protected final Object DOMAIN_SET_MUTEX = new Object();
    protected final Object readLock = new Object();
    private DtCoverageDataset dataset;
    private List myTimes = new ArrayList();
    private List myLevels = new ArrayList();
    private Hashtable gcsVsTime = new Hashtable();
    private Hashtable timeMap = new Hashtable();
    private ProjectionImpl sampleProjection;
    private String dimensionsLabel;
    private String threeDDimensionsLabel = null;
    private String twoDDimensionsLabel = null;
    private int max3DX;
    private int max3DY;
    private int max3DZ;
    private int max3D;
    private boolean reverseTimes = false;
    private JCheckBox reverseTimesCheckbox;
    private CalendarDateRange dateRange;
    private String oldResolverUrl;

    public GridCoverageDataSource() {
    }

    public GridCoverageDataSource(DataSourceDescriptor descriptor, DtCoverageDataset gds, String name, String filename) {
        super(descriptor, filename, name, (Hashtable)null);
        this.dataset = gds;
    }

    public GridCoverageDataSource(DtCoverageDataset gds) {
        this.dataset = gds;
    }

    public GridCoverageDataSource(DataSourceDescriptor descriptor, File file, Hashtable properties) throws IOException {
        this(descriptor, file.getPath(), properties);
    }

    public GridCoverageDataSource(DataSourceDescriptor descriptor, String filename, Hashtable properties) throws IOException {
        super(descriptor, filename, "Geogrid data source", properties);
    }

    public GridCoverageDataSource(DataSourceDescriptor descriptor, List files, Hashtable properties) throws IOException {
        super(descriptor, files, "Geogrid data source", properties);
    }

    public static boolean isNumeric(String str) {
        try {
            double d = Double.parseDouble(str);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }

    public static void main(String[] args) throws Exception {
        String leadUrl = "dods://lead.unidata.ucar.edu:8080/thredds/dodsC/model/NCEP/NAM/CONUS_80km/NAM_CONUS_80km_20071002_1200.grib1";
        String mlodeUrl = "dods://motherlode.ucar.edu:8080/thredds/dodsC/model/NCEP/NAM/CONUS_80km/NAM_CONUS_80km_20071002_1200.grib1";
        String url = args.length == 0 ? leadUrl : mlodeUrl;
        String[] urls = new String[]{url};
        testMode = true;
        for (int i = 0; i < 10000; ++i) {
            for (int urlIdx = 0; urlIdx < urls.length; ++urlIdx) {
                System.err.println("Reading data:" + i + " " + urls[urlIdx]);
                GridCoverageDataSource ggds = new GridCoverageDataSource(null, urls[urlIdx], null);
                ggds.doMakeDataChoices();
                DataChoice dataChoice = ggds.findDataChoice("Temperature");
                if (dataChoice == null) {
                    dataChoice = ggds.findDataChoice("T");
                }
                ggds.makeFieldImpl(dataChoice, ggds.getDataSelection(), null);
            }
        }
    }

    private static String preText(String s) {
        s = StringUtil.replace(s, "<", "&lt;");
        s = StringUtil.replace(s, ">", "&gt;");
        s = StringUtil.replace(s, "\n", "<br>\n");
        s = StringUtil.replace(s, "\t", "    ");
        s = StringUtil.replace(s, " ", "&nbsp;");
        return "<div style=\"margin-left:20;border:solid 1px\">" + s + "</div>";
    }

    private static double getMinOrMaxLon(double lon1, double lon2, boolean wantMin) {
        double midpoint = (lon1 + lon2) / 2.0;
        lon1 = LatLonPointImpl.lonNormal(lon1, midpoint);
        lon2 = LatLonPointImpl.lonNormal(lon2, midpoint);
        return wantMin ? Math.min(lon1, lon2) : Math.max(lon1, lon2);
    }

    private static Coverage makeCoverage(DtCoverage dt, DtCoverageAdapter reader) {
        return new Coverage(dt.getName(), dt.getDataType(), dt.getAttributes(), dt.getCoordinateSystem().getName(), dt.getUnitsString(), dt.getDescription(), reader, dt);
    }

    public void setDefaultSelectionBounds(Rectangle2D.Float rect) {
        this.getDataSelection().getGeoSelection(true).setLatLonRect(rect);
    }

    @Override
    protected void applyFieldMask(Element root) {
        Element subset;
        Element stride;
        super.applyFieldMask(root);
        GeoSelection geoSubset = this.getDataSelection().getGeoSelection();
        if (geoSubset == null) {
            geoSubset = new GeoSelection();
            this.getDataSelection().setGeoSelection(geoSubset);
        }
        if ((stride = XmlUtil.getElement(root, "stride")) != null) {
            geoSubset.setXStride(XmlUtil.getAttribute((Node)stride, "x", geoSubset.getXStride()));
            geoSubset.setYStride(XmlUtil.getAttribute((Node)stride, "y", geoSubset.getYStride()));
            geoSubset.setZStride(XmlUtil.getAttribute((Node)stride, "z", geoSubset.getZStride()));
        }
        if ((subset = XmlUtil.getElement(root, "subset")) != null) {
            geoSubset.setBoundingBox(new GeoLocationInfo(XmlUtil.getAttribute((Node)subset, "north", 0.0), XmlUtil.getAttribute((Node)subset, "west", 0.0), XmlUtil.getAttribute((Node)subset, "south", 0.0), XmlUtil.getAttribute((Node)subset, "east", 0.0)));
        }
    }

    @Override
    protected boolean canDoFieldMask() {
        return true;
    }

    @Override
    protected void writeFieldMaskFile(Document doc, Element root) {
        GeoSelection geoSubset = this.getDataSelection().getGeoSelection();
        if (geoSubset != null) {
            GeoLocationInfo bbox;
            Element stride = doc.createElement("stride");
            root.appendChild(stride);
            if (geoSubset.getXStride() > 1) {
                stride.setAttribute("x", geoSubset.getXStride() + "");
            }
            if (geoSubset.getYStride() > 1) {
                stride.setAttribute("y", geoSubset.getYStride() + "");
            }
            if (geoSubset.getZStride() > 1) {
                stride.setAttribute("z", geoSubset.getZStride() + "");
            }
            if ((bbox = geoSubset.getBoundingBox()) != null) {
                Element subset = doc.createElement("subset");
                subset.setAttribute("north", bbox.getMaxLat() + "");
                subset.setAttribute("south", bbox.getMinLat() + "");
                subset.setAttribute("west", bbox.getMinLon() + "");
                subset.setAttribute("east", bbox.getMaxLon() + "");
                root.appendChild(subset);
            }
        }
    }

    @Override
    public void initAfterUnpersistence() {
        if (!this.haveSources() && this.oldSourceFromBundles == null && !this.hasPollingInfo()) {
            this.oldSourceFromBundles = this.getName();
        }
        super.initAfterUnpersistence();
        this.resolvePath();
        this.getDataset();
    }

    @Override
    protected JComponent doMakeGeoSubsetPropertiesComponent() {
        JComponent comp = super.doMakeGeoSubsetPropertiesComponent();
        if (this.dataset == null || this.dimensionsLabel == null) {
            return comp;
        }
        JLabel label = new JLabel(this.dimensionsLabel);
        return GuiUtils.topCenter(GuiUtils.left(GuiUtils.inset((Component)label, 5)), comp);
    }

    @Override
    protected JComponent getExtraGeoSelectionComponent() {
        if (this.dimensionsLabel == null) {
            return super.getExtraGeoSelectionComponent();
        }
        String tmp = this.dimensionsLabel;
        int idx = tmp.indexOf("#");
        if (idx > 0) {
            tmp = tmp.substring(0, idx);
        }
        return new JLabel(tmp);
    }

    @Override
    public void addPropertiesTabs(JTabbedPane tabbedPane) {
        super.addPropertiesTabs(tabbedPane);
        if (this.dataset == null) {
            return;
        }
        int height = 300;
        int width = 400;
        JTextArea dumpText = new JTextArea();
        TextSearcher searcher = new TextSearcher(dumpText);
        dumpText.setFont(Font.decode("monospaced"));
        StringWriter bos = new StringWriter();
        try {
            NCdumpW.print(this.dataset.getNetcdfFile(), "", bos, null);
        }
        catch (IOException ioe) {
            this.logException("Dumping netcdf file", ioe);
        }
        dumpText.setText(bos.toString());
        JScrollPane scroller = GuiUtils.makeScrollPane(dumpText, width, height);
        scroller.setPreferredSize(new java.awt.Dimension(width, height));
        scroller.setMinimumSize(new java.awt.Dimension(width, height));
        tabbedPane.add("Metadata", GuiUtils.inset((Component)GuiUtils.centerBottom(scroller, searcher), 5));
    }

    @Override
    public void initAfterCreation() {
        super.initAfterCreation();
        this.resolvePath();
        this.getDataset();
    }

    @Override
    public List getDataPaths() {
        String resolverUrl = (String)this.getProperty("RESOLVERURL");
        if (resolverUrl != null && resolverUrl.length() > 0) {
            return Misc.newList(resolverUrl);
        }
        return super.getDataPaths();
    }

    @Override
    public void updateState(Object newObject, Hashtable newProperties) {
        this.removeProperty("RESOLVERURL");
        super.updateState(newObject, newProperties);
    }

    @Override
    public void setTmpPaths(List paths) {
        String resolverUrl;
        this.oldResolverUrl = resolverUrl = (String)this.getProperty("RESOLVERURL");
        if (paths != null && paths.size() > 0 && resolverUrl != null && resolverUrl.length() > 0) {
            String firstone;
            Hashtable properties = this.getProperties();
            if (properties == null) {
                properties = new Hashtable();
            }
            if ((firstone = paths.get(0).toString()).indexOf("idv.zidvpath") >= 0) {
                this.getProperties().remove("RESOLVERURL");
            } else {
                String resolvedUrl = CatalogUtil.resolveUrl(firstone, properties);
                if (resolvedUrl != null) {
                    this.setProperty("RESOLVERURL", firstone);
                }
            }
        }
        super.setTmpPaths(paths);
    }

    protected void resolvePath() {
        String resolverUrl = (String)this.getProperty("RESOLVERURL");
        if (resolverUrl != null && resolverUrl.length() > 0) {
            String resolvedUrl;
            Hashtable properties = this.getProperties();
            if (properties == null) {
                properties = new Hashtable();
            }
            if ((resolvedUrl = CatalogUtil.resolveUrl(resolverUrl, properties)) == null) {
                this.setInError(true);
                return;
            }
            this.sources = Misc.newList(resolvedUrl);
        }
    }

    @Override
    protected void sourcesChanged() {
        this.dataset = null;
        this.gcsVsTime = new Hashtable();
        super.sourcesChanged();
    }

    @Override
    public void reloadData() {
        this.myTimes = null;
        this.dataset = null;
        this.gcsVsTime = new Hashtable();
        this.resolvePath();
        this.dataChoices = null;
        this.getDataChoices();
        super.reloadData();
    }

    @Override
    public void doRemove() {
        super.doRemove();
        try {
            if (this.dataset != null) {
                this.dataset.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.dataset = null;
        this.gcsVsTime = null;
    }

    @Override
    public boolean canSaveDataToLocalDisk() {
        if (this.isFileBased()) {
            // empty if block
        }
        return true;
    }

    @Override
    protected String getSaveDataFileLabel() {
        return this.isFileBased() ? "Writing grid file" : this.getSaveDataFileLabel();
    }

    @Override
    protected void makeSaveLocalActions(List actions) {
        String lbl = this.isFileBased() ? "Subset and Write Grid" : "Write Local Grid";
        AbstractAction a = new AbstractAction(lbl){

            @Override
            public void actionPerformed(ActionEvent ae) {
                Misc.run(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            GridCoverageDataSource.this.saveDataToLocalDisk();
                        }
                        catch (Exception exc) {
                            GridCoverageDataSource.this.logException("Writing data to local disk", exc);
                        }
                    }
                });
            }
        };
        actions.add(a);
    }

    @Override
    protected Object beginWritingDataToLocalDisk(String msg) {
        Object loadId = JobManager.getManager().startLoad(msg, false, false);
        return loadId;
    }

    @Override
    protected List saveDataToLocalDisk(String prefix, Object loadId, boolean changeLinks) throws Exception {
        int i;
        List choices = this.getDataChoices();
        final ArrayList<JCheckBox> checkboxes = new ArrayList<JCheckBox>();
        ArrayList<DataCategory> categories = new ArrayList<DataCategory>();
        Hashtable<DataCategory, ArrayList<JCheckBox>> catMap = new Hashtable<DataCategory, ArrayList<JCheckBox>>();
        Hashtable<String, String> currentDataChoices = new Hashtable<String, String>();
        List displays = this.getIdv().getDisplayControls();
        for (i = 0; i < displays.size(); ++i) {
            List dataChoices = ((DisplayControl)displays.get(i)).getDataChoices();
            if (dataChoices == null) continue;
            ArrayList finalOnes = new ArrayList();
            for (int j = 0; j < dataChoices.size(); ++j) {
                ((DataChoice)dataChoices.get(j)).getFinalDataChoices(finalOnes);
            }
            for (int dcIdx = 0; dcIdx < finalOnes.size(); ++dcIdx) {
                DirectDataChoice ddc;
                DataChoice dc = (DataChoice)finalOnes.get(dcIdx);
                if (!(dc instanceof DirectDataChoice) || (ddc = (DirectDataChoice)dc).getDataSource() != this) continue;
                currentDataChoices.put(ddc.getName(), "");
            }
        }
        if (this.getDefaultSave()) {
            ArrayList<String> varNames = new ArrayList<String>();
            for (int i2 = 0; i2 < this.dataChoices.size(); ++i2) {
                DataChoice dataChoice = (DataChoice)this.dataChoices.get(i2);
                if (!(dataChoice instanceof DirectDataChoice)) continue;
                String name = dataChoice.getName();
                if (name.startsWith(PREFIX_GRIDRELATIVE)) {
                    name = name.substring(PREFIX_GRIDRELATIVE.length());
                }
                if (currentDataChoices.get(name) == null) continue;
                varNames.add(name);
            }
            return currentDataChoices.size() > 0 ? this.writeNc(prefix, changeLinks, varNames) : null;
        }
        for (i = 0; i < this.dataChoices.size(); ++i) {
            DataChoice dataChoice = (DataChoice)this.dataChoices.get(i);
            if (!(dataChoice instanceof DirectDataChoice)) continue;
            String label = dataChoice.getDescription();
            JCheckBox cbx = new JCheckBox(label, currentDataChoices.get(dataChoice.getName()) != null);
            ThreeDSize size = (ThreeDSize)dataChoice.getProperty(PROP_GRIDSIZE);
            cbx.setToolTipText(dataChoice.getName());
            checkboxes.add(cbx);
            DataCategory dc = dataChoice.getDisplayCategory();
            ArrayList<JCheckBox> comps = (ArrayList<JCheckBox>)catMap.get(dc);
            if (comps == null) {
                comps = new ArrayList<JCheckBox>();
                catMap.put(dc, comps);
                categories.add(dc);
            }
            comps.add(cbx);
            comps.add((JCheckBox)GuiUtils.filler());
            if (size != null) {
                JLabel sizeLabel = GuiUtils.rLabel(size.getSize() + "  ");
                sizeLabel.setToolTipText(size.getLabel());
                comps.add((JCheckBox)((Object)sizeLabel));
                continue;
            }
            comps.add((JCheckBox)((Object)new JLabel("")));
        }
        final JCheckBox allCbx = new JCheckBox("Select All");
        allCbx.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                for (JCheckBox cbx : checkboxes) {
                    cbx.setSelected(allCbx.isSelected());
                }
            }
        });
        ArrayList catComps = new ArrayList();
        JTabbedPane tab = new JTabbedPane(2);
        for (int i3 = 0; i3 < categories.size(); ++i3) {
            List comps = (List)catMap.get(categories.get(i3));
            JPanel labelPanel = new JPanel(new BorderLayout());
            JPanel leftLabelPanel = new JPanel(new FlowLayout(0));
            leftLabelPanel.add(new JLabel("Field Name"));
            JPanel rightLabelPanel = new JPanel(new FlowLayout(2));
            rightLabelPanel.add(new JLabel("Grid Size (Points)"));
            labelPanel.add((Component)leftLabelPanel, "West");
            labelPanel.add((Component)rightLabelPanel, "East");
            JPanel innerPanel = GuiUtils.doLayout(comps, 3, GuiUtils.WT_NYN, GuiUtils.WT_N);
            JScrollPane sp = new JScrollPane(GuiUtils.top(innerPanel));
            sp.setPreferredSize(new java.awt.Dimension(500, 400));
            JPanel spAndLabels = new JPanel(new BorderLayout());
            spAndLabels.add((Component)labelPanel, "North");
            spAndLabels.add((Component)sp, "Center");
            JPanel inner = GuiUtils.inset((Component)GuiUtils.center(spAndLabels), 5);
            tab.addTab(categories.get(i3).toString(), inner);
        }
        JComponent contents = tab;
        contents = GuiUtils.topCenter(GuiUtils.inset((Component)GuiUtils.leftRight(new JLabel("Select the fields to download"), allCbx), 5), contents);
        JLabel label = new JLabel(GridCoverageDataSource.getNameForDataSource(this, 50, true));
        contents = GuiUtils.topCenter(label, contents);
        if (!GuiUtils.showOkCancelDialog(null, "", contents = GuiUtils.inset((Component)contents, 5), null)) {
            return null;
        }
        ArrayList<String> varNames = new ArrayList<String>();
        for (int i4 = 0; i4 < this.dataChoices.size(); ++i4) {
            JCheckBox cbx;
            DataChoice dataChoice = (DataChoice)this.dataChoices.get(i4);
            if (!(dataChoice instanceof DirectDataChoice) || !(cbx = (JCheckBox)checkboxes.get(i4)).isSelected()) continue;
            String name = dataChoice.getName();
            if (name.startsWith(PREFIX_GRIDRELATIVE)) {
                name = name.substring(PREFIX_GRIDRELATIVE.length());
            }
            varNames.add(name);
        }
        if (varNames.size() == 0) {
            return null;
        }
        return this.writeNc(prefix, changeLinks, varNames);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List writeNc(String prefix, boolean changeLinks, List varNames) {
        LatLonRect llr = null;
        int hStride = 1;
        int zStride = 1;
        int timeStride = 1;
        GeoSelection geoSubset = this.getDataSelection().getGeoSelection();
        boolean includeLatLon = false;
        if (geoSubset != null) {
            if (geoSubset.getBoundingBox() != null) {
                llr = geoSubset.getBoundingBox().getLatLonRect();
            }
            if (geoSubset.hasXStride()) {
                hStride = geoSubset.getXStride();
            }
            if (geoSubset.hasZStride()) {
                zStride = geoSubset.getZStride();
            }
        }
        if (this.getProperties().get("timestride") != null) {
            Object tstrike = this.getProperties().get("timestride");
            timeStride = (Integer)tstrike;
        }
        if (this.dateRange == null) {
            List times = this.getTimesFromDataSelection(this.getDataSelection(), (DataChoice)this.getDataChoices().get(0));
            try {
                if (this.getDataSelection() != null && !times.isEmpty()) {
                    CalendarDateTime t0 = new CalendarDateTime((DateTime)times.get(0));
                    CalendarDate dt0 = t0.getCalendarDate();
                    CalendarDateTime t1 = new CalendarDateTime((DateTime)times.get(times.size() - 1));
                    CalendarDate dt1 = t1.getCalendarDate();
                    this.dateRange = CalendarDateRange.of(dt0, dt1);
                }
            }
            catch (Exception t0) {
                // empty catch block
            }
        }
        String path = prefix;
        CFGridCoverageWriter2 writer = new CFGridCoverageWriter2();
        NetcdfFileWriter ncFileWriter = null;
        try {
            ncFileWriter = NetcdfFileWriter.createNew(NetcdfFileWriter.Version.netcdf3, path);
            ncFileWriter.setLargeFile(true);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Object loadId = JobManager.getManager().startLoad("Copying data", true, true);
        SubsetParams subsetParams = new SubsetParams();
        subsetParams.setLatLonBoundingBox(llr);
        try {
            FeatureDatasetCoverage cc = DtCoverageAdapter.factory(this.dataset, null);
            CFGridCoverageWriter2.write(cc.getSingleCoverageCollection(), varNames, subsetParams, false, ncFileWriter);
        }
        catch (Exception exc) {
            this.logException("Error writing local netcdf file.\nData:" + this.getFilePath() + "\nVariables:" + varNames, exc);
            List list = null;
            return list;
        }
        finally {
            JobManager.getManager().stopLoad(loadId);
        }
        if (geoSubset != null && changeLinks) {
            geoSubset.clearStride();
            geoSubset.setBoundingBox(null);
            if (this.geoSelectionPanel != null) {
                this.geoSelectionPanel.initWith(this.doMakeGeoSelectionPanel());
            }
        }
        List newFiles = Misc.newList(path);
        if (changeLinks) {
            this.getProperties().remove("RESOLVERURL");
            this.setNewFiles(newFiles);
        }
        return newFiles;
    }

    public boolean isLocalFile() {
        return new File(this.getFilePath()).exists();
    }

    @Override
    public void setNewFiles(List files) {
        this.getProperties().remove("RESOLVERURL");
        super.setNewFiles(files);
    }

    @Override
    protected String getLocalDirectory(String label, String prefix) {
        this.changeDataPathsCbx.setToolTipText("Should this data source also be changed");
        return FileManager.getWriteFile(FileManager.FILTER_NETCDF, null, (JComponent)GuiUtils.top(this.changeDataPathsCbx));
    }

    @Override
    public String getFullDescription() {
        String desc = super.getFullDescription();
        StringBuffer sb2d = null;
        StringBuffer sb3d = null;
        List dataChoices = this.getDataChoices();
        for (int i = 0; i < dataChoices.size(); ++i) {
            int times;
            DataChoice dataChoice = (DataChoice)dataChoices.get(i);
            if (!(dataChoice instanceof DirectDataChoice)) continue;
            ThreeDSize size = (ThreeDSize)dataChoice.getProperty(PROP_GRIDSIZE);
            Integer timeSize = (Integer)dataChoice.getProperty(PROP_TIMESIZE);
            if (size == null) continue;
            long total = size.getSizeY() * size.getSizeX();
            StringBuffer theSb = null;
            String sizeEntry = null;
            if (size.getSizeZ() > 1) {
                if (sb3d == null) {
                    sb3d = new StringBuffer();
                }
                total *= (long)size.getSizeZ();
                theSb = sb3d;
                sizeEntry = size.getSizeX() + "x" + size.getSizeY() + "x" + size.getSizeZ();
            } else {
                if (sb2d == null) {
                    sb2d = new StringBuffer();
                }
                theSb = sb2d;
                sizeEntry = size.getSizeX() + "x" + size.getSizeY();
            }
            theSb.append("<tr><td>" + dataChoice.getName() + "</td><td>" + dataChoice.getDescription() + "</td><td>" + sizeEntry + "</td><td>");
            if (timeSize != null && (times = timeSize.intValue()) > 0) {
                total *= (long)timeSize.intValue();
                theSb.append("" + timeSize);
            }
            theSb.append("</td>");
            theSb.append("<td>" + total + "</td></tr>");
        }
        StringBuffer sb = null;
        if (sb2d != null || sb3d != null) {
            sb = new StringBuffer(desc);
            String resolverUrl = (String)this.getProperty("RESOLVERURL");
            if (resolverUrl != null) {
                sb.append("<p>");
                sb.append("Resolver URL:" + resolverUrl);
            }
            sb.append("\n<p><table><tr><td><b>Field</b></td><td><b>Description</b></td><td><b>Dimensions</b></td><td><b>#Times</b></td><td><b>#Points</b></td></tr>\n");
        }
        if (sb2d != null) {
            sb.append(sb2d);
        }
        if (sb3d != null) {
            sb.append(sb3d);
        }
        if (sb != null) {
            sb.append("</table>\n");
        }
        if (sb != null && this.myLevels != null && this.myLevels.size() > 0) {
            sb.append("<h2>Levels</h2>");
            for (Object o : this.myLevels) {
                sb.append("" + o);
                sb.append("<br>");
            }
        }
        if (sb == null) {
            return desc;
        }
        return sb.toString();
    }

    @Override
    public void resetTmpState() {
        super.resetTmpState();
        if (this.oldResolverUrl != null) {
            this.setProperty("RESOLVERURL", this.oldResolverUrl);
        }
    }

    protected DtCoverageDataset doMakeDataSet() {
        this.checkForInitAfterUnPersistence();
        String file = this.getFilePath();
        if (file == null && this.haveBeenUnPersisted) {
            file = this.getName();
        }
        if (file == null) {
            return null;
        }
        if (this.sources == null) {
            this.sources = new ArrayList();
            this.sources.add(file);
        }
        if (this.sources.size() > 1) {
            String timeName = this.getProperty(PROP_TIMEVAR, "time");
            StringBuffer sb = new StringBuffer();
            sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            sb.append("<netcdf xmlns=\"https://www.unidata.ucar.edu/namespaces/netcdf/ncml-2.2\">\n");
            sb.append("<aggregation type=\"joinExisting\" dimName=\"" + timeName + "\" timeUnitsChange=\"true\">\n");
            for (int i = 0; i < this.sources.size(); ++i) {
                String s = this.sources.get(i).toString();
                try {
                    if (s.startsWith("http") && s.endsWith("entry.das")) {
                        s = DODSNetcdfFile.canonicalURL(s);
                        sb.append(XmlUtil.tag("netcdf", XmlUtil.attrs("location", s, "enhance", "true"), ""));
                        continue;
                    }
                    sb.append(XmlUtil.tag("netcdf", XmlUtil.attrs("location", IOUtil.getURL(s, this.getClass()).toString(), "enhance", "true"), ""));
                    continue;
                }
                catch (IOException ioe) {
                    this.setInError(true);
                    throw new WrapperException("Grid data source failed aggregating resource: " + s, ioe);
                }
            }
            sb.append("</aggregation>\n</netcdf>\n");
            file = this.getDataContext().getObjectStore().getUniqueTmpFile("multigrid_" + UUID.randomUUID().toString(), ".ncml");
            try {
                IOUtil.writeFile(file, sb.toString());
            }
            catch (IOException ioe) {
                this.logException("Unable to write file: " + file, ioe);
                return null;
            }
            log_.debug("" + sb);
        }
        try {
            file = this.convertSourceFile(file);
            Trace.msg("GeoGridDataSource: opening file " + file);
            if (file.startsWith("http") && file.endsWith("entry.das")) {
                file = DODSNetcdfFile.canonicalURL(file);
            } else if (file.startsWith("http") && file.contains("/dods/")) {
                file = DODSNetcdfFile.canonicalURL(file);
            } else if (file.startsWith("dods:") && file.endsWith("ncml")) {
                file = file.replace("dods:", "https:");
            }
            if (file.contains(":443")) {
                file = file.replace(":443", "");
            }
            DtCoverageDataset gds = DtCoverageDataset.open(file);
            return gds;
        }
        catch (FileNotFoundException fnfe) {
            this.setInError(true);
            LogUtil.consoleMessage("Original error:\n" + fnfe.toString() + "\n" + LogUtil.getStackTrace(fnfe));
            throw new BadDataException("Unable to open grid:\n" + file);
        }
        catch (Exception exc) {
            this.setInError(true);
            throw new WrapperException("Grid data source failed making data set: " + file, exc);
        }
    }

    public DtCoverageDataset getDataset() {
        if (this.dataset == null) {
            Trace.call1("GeoGridDataSource.getDataSet", " name = " + this.sources);
            this.dataset = this.doMakeDataSet();
            Trace.call2("GeoGridDataSource.getDataSet");
        }
        return this.dataset;
    }

    @Override
    protected ProjectionImpl getSampleDataProjection() {
        if (this.sampleProjection instanceof LatLonProjection) {
            LatLonProjection ll = (LatLonProjection)this.sampleProjection;
            ((LatLonProjection)this.sampleProjection).setCenterLon(0.0);
        }
        return this.sampleProjection;
    }

    @Override
    protected void doMakeDataChoices() {
        DtCoverageDataset myDataset = this.getDataset();
        if (myDataset == null) {
            return;
        }
        this.max3DX = -1;
        this.max3DY = -1;
        this.max3DZ = -1;
        this.max3D = -1;
        boolean gridRelativeWind = false;
        Iterator<DtCoverage> iter = myDataset.getGrids().iterator();
        SortedSet uniqueTimes = Collections.synchronizedSortedSet(new TreeSet());
        while (iter.hasNext()) {
            CoordinateAxis1DTime trAxis;
            DtCoverageCS gcs;
            CoordinateAxis1D zaxis;
            DtCoverage cfield = iter.next();
            if (this.sampleProjection == null) {
                this.sampleProjection = cfield.getCoordinateSystem().getProjection();
            }
            if ((zaxis = (gcs = cfield.getCoordinateSystem()).getVerticalAxis()) == null) continue;
            CoordinateAxis1DTime tAxis = (CoordinateAxis1DTime)gcs.getTimeAxis();
            if (tAxis == null && (trAxis = gcs.getRunTimeAxis()).getAxisType() == AxisType.RunTime) {
                tAxis = trAxis;
            }
            List geoTimes = this.getGeoGridTimes(tAxis);
            uniqueTimes.addAll(geoTimes);
        }
        this.myTimes = !uniqueTimes.isEmpty() ? new ArrayList(uniqueTimes) : new ArrayList();
        iter = myDataset.getGrids().iterator();
        Hashtable timeToIndex = new Hashtable();
        for (int i = 0; i < this.myTimes.size(); ++i) {
            timeToIndex.put(this.myTimes.get(i), new Integer(i));
        }
        int cnt = 0;
        while (iter.hasNext()) {
            DtCoverage cfield = iter.next();
            DataChoice choice = this.makeDataChoiceFromGeoGrid(cfield, this.myTimes, timeToIndex);
            if (choice == null) continue;
            ++cnt;
            if (gridRelativeWind && (choice.getDescription().indexOf("u-component") >= 0 || choice.getDescription().indexOf("v-component") >= 0)) {
                choice.setName(PREFIX_GRIDRELATIVE + choice.getName());
            }
            this.addDataChoice(choice);
        }
        if (cnt == 0) {
            if (LogUtil.getInteractiveMode() && GuiUtils.showOkCancelDialog(null, "No Gridded Data", GuiUtils.inset((Component)new JLabel("<html>No gridded data found for:<br><br>&nbsp;&nbsp;<i>" + this + "</i><br><br>Do you want to try to load this as another data type?</html>"), 5), null)) {
                this.getIdv().getDataManager().createDataSourceAndAskForType(this.getFilePath(), this.getProperties());
                this.setInError(true, false, "");
            } else {
                this.setInError(true, false, "");
            }
            return;
        }
        if (this.max3D > 0) {
            this.threeDDimensionsLabel = "Max grid size: x: " + this.max3DX + " y: " + this.max3DY + " z: " + this.max3DZ + "   #points: " + this.max3DX * this.max3DY * this.max3DZ;
        }
        this.dimensionsLabel = this.threeDDimensionsLabel != null ? this.threeDDimensionsLabel : this.twoDDimensionsLabel;
    }

    @Override
    protected Data getDataInner(DataChoice dataChoice, DataCategory category, DataSelection givenDataSelection, Hashtable requestProperties) throws VisADException, RemoteException {
        GeoLocationInfo gInfo;
        boolean isPR = givenDataSelection.getProperty("Use_Progressive_Resolution", false);
        boolean fromBundle = this.getIdv().getStateManager().getProperty("idv.loadingxml", false);
        if (isPR && fromBundle && (gInfo = givenDataSelection.getGeoSelection().getBoundingBox()) != null) {
            givenDataSelection.getGeoSelection().setBoundingBox(gInfo);
        }
        FieldImpl data = this.makeFieldImpl(dataChoice, givenDataSelection, requestProperties);
        return data;
    }

    public List<String> listParameters() {
        ArrayList<String> params = new ArrayList<String>();
        for (DataChoice dc : this.getDataChoices()) {
            params.add(dc.getName());
        }
        return params;
    }

    public Data getData(String parameter) throws VisADException, RemoteException {
        DataChoice dataChoice = this.findDataChoice(parameter);
        if (dataChoice == null) {
            return null;
        }
        DataSelection dataSelection = new DataSelection();
        FieldImpl data = this.makeFieldImpl(dataChoice, dataSelection, new Hashtable());
        return data;
    }

    @Override
    protected List doMakeDateTimes() {
        return this.myTimes;
    }

    @Override
    public List getAllLevels(DataChoice dataChoice, DataSelection dataSelection) {
        try {
            long t2;
            long t1;
            dataSelection = DataSelection.merge(dataSelection, this.getDataSelection());
            Object fromLevel = dataSelection.getFromLevel();
            Object toLevel = dataSelection.getToLevel();
            int fromLevelIndex = -1;
            int toLevelIndex = -1;
            if (fromLevel != null && toLevel != null) {
                t1 = System.currentTimeMillis();
                List allLevels = this.getAllLevels(dataChoice, new DataSelection(1));
                t2 = System.currentTimeMillis();
                fromLevelIndex = this.indexOf(fromLevel, allLevels);
                toLevelIndex = this.indexOf(toLevel, allLevels);
            }
            t1 = System.currentTimeMillis();
            GridCoverageAdapter geoGridAdapter = this.makeGeoGridAdapter(dataChoice, dataSelection, null, fromLevelIndex, toLevelIndex, true);
            t2 = System.currentTimeMillis();
            if (geoGridAdapter != null) {
                List tmpLevels;
                this.myLevels = tmpLevels = geoGridAdapter.getLevels();
                return tmpLevels;
            }
            return this.myLevels;
        }
        catch (VisADException vae) {
            throw new WrapperException(vae);
        }
        catch (HugeSizeException hse) {
            return null;
        }
    }

    @Override
    public boolean canDoGeoSelection() {
        return true;
    }

    @Override
    public boolean canCacheDataToDisk() {
        return true;
    }

    private GridCoverageAdapter makeGeoGridAdapter(DataChoice dataChoice, DataSelection givenDataSelection, Hashtable requestProperties, int fromLevelIndex, int toLevelIndex, boolean forMetaData) throws VisADException, HugeSizeException {
        boolean matchDisplayRegion;
        DtCoverageDataset myDataset;
        boolean readingFullGrid = !forMetaData;
        int numLevels = -1;
        if (fromLevelIndex >= 0 && toLevelIndex >= 0) {
            numLevels = Math.abs(toLevelIndex - fromLevelIndex) + 1;
        }
        if ((myDataset = this.getDataset()) == null) {
            return null;
        }
        Object extraCacheKey = null;
        DtCoverage geoGrid = this.findGridForDataChoice(myDataset, dataChoice);
        FeatureDatasetCoverage dddd = DtCoverageAdapter.factory(myDataset, null);
        CoverageCollection cc = dddd.getCoverageCollections().get(0);
        Coverage geoCoverage = cc.findCoverage(geoGrid.getName());
        SubsetParams geiGridSubsetParams = new SubsetParams();
        geiGridSubsetParams.setLatLonBoundingBox(geoGrid.getCoordinateSystem().getLatLonBoundingBox());
        String paramName = dataChoice.getStringId();
        if (geoGrid == null) {
            return null;
        }
        Dimension ensDim = geoGrid.getEnsembleDimension();
        GeoSelection geoSelection = givenDataSelection != null ? givenDataSelection.getGeoSelection() : null;
        List<CoordinateTransform> transf = geoGrid.getCoordinateSystem().getCoordTransforms();
        CoordinateAxis1D vertAxis = geoGrid.getCoordinateSystem().getVerticalAxis();
        boolean needVolume = transf.size() == 2 && transf.get(1) != null && requestProperties != null && requestProperties.get(DerivedDataChoice.PROP_FROMDERIVED) != null;
        StringBuffer filename = new StringBuffer("grid_" + paramName);
        String regionOption = null;
        regionOption = givenDataSelection.getProperty("Region_Selection_Option", "Use_Default_Area");
        boolean isProgressiveResolution = givenDataSelection.getProperty("Use_Progressive_Resolution", false);
        boolean bl = matchDisplayRegion = geoSelection != null ? geoSelection.getUseViewBounds() : false;
        if (!isProgressiveResolution && dataChoice.getDataSelection() != null) {
            isProgressiveResolution = dataChoice.getDataSelection().getProperty("Use_Progressive_Resolution", false);
        }
        try {
            int yStride;
            Range ensRange = this.makeRange(ensDim, null, 1);
            Object timeRange = null;
            Range levelRange = null;
            Range xRange = null;
            Range yRange = null;
            if (fromLevelIndex >= 0 && toLevelIndex >= 0 && !needVolume) {
                levelRange = new Range(fromLevelIndex, toLevelIndex);
                filename.append("_r_" + fromLevelIndex + "_" + toLevelIndex);
            }
            if (isProgressiveResolution && geoSelection != null && !geoSelection.hasStride()) {
                Rectangle2D rect;
                int xLength = geoGrid.getXDimension().getLength();
                int yLength = geoGrid.getYDimension().getLength();
                if (geoSelection.getLatLonRect() != null) {
                    LatLonRect bbox;
                    LatLonRect gsbox = geoSelection.getLatLonRect();
                    LatLonRect grbox = geoGrid.getCoordinateSystem().getLatLonBoundingBox();
                    if (!matchDisplayRegion) {
                        bbox = gsbox;
                    } else {
                        bbox = grbox.intersect(gsbox);
                        if (bbox == null) {
                            bbox = grbox;
                        }
                    }
                    List<Range> yx_ranges = this.getRangesFromLatLonRect(geoGrid.getCoordinateSystem(), bbox);
                    CoverageCoordAxis1D lonAxis = (CoverageCoordAxis1D)geoCoverage.getCoordSys().getXAxis();
                    double wantMin = LatLonPointImpl.lonNormalFrom(bbox.getLonMin(), lonAxis.getStartValue());
                    double wantMax = LatLonPointImpl.lonNormalFrom(bbox.getLonMax(), lonAxis.getStartValue());
                    double start = lonAxis.getStartValue();
                    double end = lonAxis.getEndValue();
                    List<MAMath.MinMax> lonIntvs = this.subsetLonIntervals(wantMin, wantMax, start, end);
                    yRange = this.makeRange(geoGrid.getYDimension(), yx_ranges.get(0), 1);
                    if (lonIntvs.size() == 1) {
                        xRange = this.makeRange(geoGrid.getXDimension(), yx_ranges.get(1), 1);
                        xLength = xRange.length();
                    } else {
                        List<Range> x1 = this.getRangesFromLonRange(geoGrid.getCoordinateSystem(), lonIntvs.get((int)0).min, lonIntvs.get((int)0).max);
                        List<Range> x2 = this.getRangesFromLonRange(geoGrid.getCoordinateSystem(), lonIntvs.get((int)1).min, lonIntvs.get((int)1).max);
                        Range xRange1 = this.makeRange(geoGrid.getXDimension(), x1.get(0), 1);
                        Range xRange2 = this.makeRange(geoGrid.getXDimension(), x2.get(0), 1);
                        xLength = xRange1.length() + xRange2.length();
                    }
                    yLength = yRange.length();
                    geiGridSubsetParams.setLatLonBoundingBox(bbox);
                }
                if ((rect = geoSelection.getScreenBound()) == null) {
                    rect = dataChoice.getDataSelection().getGeoSelection().getScreenBound();
                }
                int xstride = this.calculateStrideFactor(xLength, (int)rect.getWidth());
                int ystride = this.calculateStrideFactor(yLength, (int)rect.getHeight());
                if (xstride == 1) {
                    xstride = 0;
                }
                if (ystride == 1) {
                    ystride = 0;
                }
                geoSelection.setXStride(xstride);
                geoSelection.setYStride(ystride);
            }
            int xStride = geoSelection != null ? geoSelection.getXStride() : 1;
            int n = yStride = geoSelection != null ? geoSelection.getYStride() : 1;
            if (xStride < 1) {
                xStride = 1;
            }
            if (yStride < 1) {
                yStride = 1;
            }
            geiGridSubsetParams.setHorizStride(xStride);
            String magValue = DataUtil.makeSamplingLabel(xStride, yStride, "grid point");
            dataChoice.setProperty("MAG", magValue);
            if (geoSelection != null && (geoSelection.hasSpatialSubset() || geoSelection.getHasNonOneStride())) {
                extraCacheKey = geoSelection;
                if (levelRange != null) {
                    extraCacheKey = Misc.newList(extraCacheKey, levelRange);
                }
                filename.append("_x_" + geoSelection.getXStrideToUse());
                filename.append("_y_" + geoSelection.getYStrideToUse());
                filename.append("_z_" + geoSelection.getZStrideToUse());
                if (geoSelection.getLatLonRect() != null) {
                    LatLonRect bbox;
                    LatLonRect gsbox = geoSelection.getLatLonRect();
                    LatLonRect grbox = geoGrid.getCoordinateSystem().getLatLonBoundingBox();
                    if (!matchDisplayRegion) {
                        bbox = gsbox;
                    } else {
                        bbox = grbox.intersect(gsbox);
                        if (bbox == null) {
                            bbox = grbox;
                        }
                    }
                    geiGridSubsetParams.setLatLonBoundingBox(bbox);
                    filename.append("_rect_" + this.cleanBBoxName(bbox));
                    List<Range> yx_ranges = this.getRangesFromLatLonRect(geoGrid.getCoordinateSystem(), bbox);
                    yRange = this.makeRange(geoGrid.getYDimension(), yx_ranges.get(0), geoSelection.getYStrideToUse());
                    xRange = this.makeRange(geoGrid.getXDimension(), yx_ranges.get(1), geoSelection.getYStrideToUse());
                } else if (geoSelection.getHasNonOneStride()) {
                    geiGridSubsetParams.setLatLonBoundingBox(geoGrid.getCoordinateSystem().getLatLonBoundingBox());
                    geiGridSubsetParams.setHorizStride(geoSelection.getYStrideToUse());
                    yRange = this.makeRange(geoGrid.getYDimension(), yRange, geoSelection.getYStrideToUse());
                    xRange = this.makeRange(geoGrid.getXDimension(), xRange, geoSelection.getYStrideToUse());
                }
                if (levelRange != null && geoSelection.hasZStride() && geoSelection.getZStrideToUse() > 1) {
                    levelRange = new Range(fromLevelIndex, toLevelIndex, geoSelection.getZStrideToUse());
                }
                if (levelRange != null) {
                    double startL = vertAxis.getCoordValue(fromLevelIndex);
                    double endL = vertAxis.getCoordValue(toLevelIndex);
                    geiGridSubsetParams.setVertCoordIntv(new double[]{startL, endL});
                }
            } else if (levelRange != null) {
                extraCacheKey = levelRange;
                double startL = vertAxis.getCoordValue(fromLevelIndex);
                double endL = vertAxis.getCoordValue(toLevelIndex);
                geiGridSubsetParams.setVertCoordIntv(new double[]{startL, endL});
            }
        }
        catch (InvalidRangeException ire) {
            throw new IllegalArgumentException("Invalid range:" + ire);
        }
        boolean warn = this.getIdv().getStore().get(PREF_LARGE_REMOTE_DATA_WARN, false);
        boolean fromBundle = this.haveBeenUnPersisted;
        if (readingFullGrid && !fromBundle && warn && this.getIdv().getInteractiveMode() && !this.isLocalFile()) {
            long total = 1L;
            List<Dimension> dims = geoGrid.getDimensions();
            List<Integer> geoDims = Arrays.asList(geoGrid.getXDimensionIndex(), geoGrid.getYDimensionIndex(), geoGrid.getZDimensionIndex());
            for (int d = 0; d < geoDims.size(); ++d) {
                if (geoDims.get(d) == -1) continue;
                Dimension dim = dims.get(geoDims.get(d));
                total *= (long)dim.getLength();
            }
            if (geoGrid.getTimeDimension() != null) {
                try {
                    total *= (long)givenDataSelection.getTimes().size();
                }
                catch (NullPointerException npe) {
                    CoordinateAxis1DTime ca = (CoordinateAxis1DTime)geoGrid.getCoordinateSystem().getTimeAxis();
                    total *= (long)this.getTimes(ca.getCalendarDates()).size();
                }
            }
            double mb = total * (long)geoGrid.getDataType().getSize();
            if ((mb /= 1048576.0) > 120.0) {
                JCheckBox askCbx = new JCheckBox("Don't show this again", !warn);
                JPanel msgContents = GuiUtils.vbox((Component)GuiUtils.inset((Component)new JLabel("<html>You are about to load " + (int)mb + " MB of data.<br>Are you sure you want to do this?<p><hr>" + "<br>Consider subsetting for better performance!<p></html>"), 5), GuiUtils.inset((Component)askCbx, new Insets(5, 0, 0, 0)));
                if (askCbx.isSelected()) {
                    this.getIdv().getStore().put(PREF_LARGE_REMOTE_DATA_WARN, false);
                }
                if (!GuiUtils.askOkCancel("Large Remote Data Request Warning", msgContents)) {
                    throw new HugeSizeException();
                }
            }
        }
        GridCoverageAdapter adapter = new GridCoverageAdapter(this, geoCoverage, geiGridSubsetParams, dataChoice.getName(), this.dataset.getNetcdfDataset(), extraCacheKey);
        adapter.cacheFile = filename.toString();
        return adapter;
    }

    private List<MAMath.MinMax> subsetLonIntervals(double wantMin, double wantMax, double start, double end) {
        if (wantMin <= wantMax) {
            if (wantMin > end && wantMax > end) {
                return ImmutableList.of();
            }
            if (wantMin < end && wantMax < end) {
                return Lists.newArrayList(new MAMath.MinMax(wantMin, wantMax));
            }
            if (wantMin < end && wantMax > end) {
                return Lists.newArrayList(new MAMath.MinMax(wantMin, end));
            }
        } else {
            if (wantMin > end && wantMax > end) {
                return Lists.newArrayList(new MAMath.MinMax(start, end));
            }
            if (wantMin < end && wantMax < end) {
                return Lists.newArrayList(new MAMath.MinMax(wantMin, end), new MAMath.MinMax(start, wantMax));
            }
            if (wantMin < end && wantMax > end) {
                return Lists.newArrayList(new MAMath.MinMax(wantMin, end));
            }
        }
        return ImmutableList.of();
    }

    public Optional<RangeIterator> makeRange(DtCoverageCS dtCoverageCS, double minValue, double maxValue) {
        int count;
        CoordinateAxis1D xaxis = (CoordinateAxis1D)dtCoverageCS.getXHorizAxis();
        double lower = Math.min(minValue, maxValue);
        double upper = Math.max(minValue, maxValue);
        int minIndex = xaxis.findCoordElementBounded(lower);
        int maxIndex = xaxis.findCoordElementBounded(upper);
        if ((long)minIndex >= xaxis.getSize()) {
            return Optional.empty(String.format("no points in subset: lower %f > end %f", lower, xaxis.getMinValue()));
        }
        if (maxIndex < 0) {
            return Optional.empty(String.format("no points in subset: upper %f < start %f", upper, xaxis.getMaxValue()));
        }
        if (minIndex < 0) {
            minIndex = 0;
        }
        if ((long)maxIndex >= xaxis.getSize()) {
            maxIndex = (int)xaxis.getSize() - 1;
        }
        if ((count = maxIndex - minIndex + 1) <= 0) {
            return Optional.empty("no points in subset");
        }
        try {
            return Optional.of(new Range(minIndex, maxIndex));
        }
        catch (InvalidRangeException var14) {
            return Optional.empty(var14.getMessage());
        }
    }

    public int calculateStrideFactor(int dataPoints, int displayPoints) {
        if (dataPoints <= displayPoints) {
            return 0;
        }
        int factor = (int)Math.floor(1.0 * (double)dataPoints / (1.0 * (double)displayPoints) + 0.8);
        return factor;
    }

    private Range makeRange(Dimension dim, Range range, int stride) throws InvalidRangeException {
        if (dim == null) {
            return null;
        }
        range = range == null ? new Range(0, dim.getLength() - 1, stride) : new Range(range.first(), range.last(), stride);
        return range;
    }

    private String cleanBBoxName(LatLonRect bbox) {
        String name = Util.cleanName(bbox.toString());
        name = name.replaceAll(":", "_");
        name = name.replaceAll("\\+", "_");
        return name;
    }

    public int indexOf(Object o, List levels) throws VisADException {
        if (o instanceof TwoFacedObject) {
            o = ((TwoFacedObject)o).getId();
        }
        if (o instanceof Integer) {
            return (Integer)o;
        }
        if (o instanceof String) {
            try {
                o = Util.toReal(o.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (o instanceof String) {
            String s = (String)o;
            if (s.startsWith("#")) {
                int index = new Integer(s.substring(1).trim());
                return index;
            }
            o = new Real(new Double(s));
        }
        if (o instanceof Real && levels.size() > 0 && levels.get(0) instanceof Real) {
            Real r = (Real)o;
            for (int i = 0; i < levels.size(); ++i) {
                Real lr = (Real)levels.get(i);
                if (r.getValue(lr.getUnit()) != lr.getValue()) continue;
                return i;
            }
            return -1;
        }
        return levels.indexOf(o);
    }

    private FieldImpl makeFieldImpl(DataChoice dataChoice, DataSelection givenDataSelection, Hashtable requestProperties) throws VisADException, RemoteException {
        long millis = System.currentTimeMillis();
        List allLevels = this.getAllLevels(dataChoice, new DataSelection(1));
        Trace.call1("GeoGridDataSource.makeField");
        Object fromLevel = givenDataSelection.getFromLevel();
        Object toLevel = givenDataSelection.getToLevel();
        int fromLevelIndex = -1;
        int toLevelIndex = -1;
        if (fromLevel != null && toLevel != null) {
            fromLevelIndex = this.indexOf(fromLevel, allLevels);
            toLevelIndex = this.indexOf(toLevel, allLevels);
            if (toLevelIndex < 0 || fromLevelIndex < 0) {
                System.err.println("Did not find level indices:   fromLevel:" + fromLevel + " index:" + fromLevelIndex + " toLevel:" + toLevel + " index:" + toLevelIndex + "\nLevels:" + allLevels);
                if (allLevels != null && !allLevels.isEmpty()) {
                    System.err.println("fromLevel is a " + fromLevel.getClass().getName() + ", toLevel is a " + toLevel.getClass().getName());
                    System.err.println("levels are " + allLevels.get(0).getClass().getName());
                }
            }
        }
        long starttime = System.currentTimeMillis();
        FieldImpl fieldImpl = null;
        Trace.call1("GeoGridDataSource.make GeoGridAdapter");
        GridCoverageAdapter adapter = null;
        try {
            adapter = this.makeGeoGridAdapter(dataChoice, givenDataSelection, requestProperties, fromLevelIndex, toLevelIndex, false);
        }
        catch (HugeSizeException hse) {
            return null;
        }
        if (adapter == null) {
            throw new BadDataException("Could not find field:" + dataChoice.getStringId());
        }
        Trace.call2("GeoGridDataSource.make GeoGridAdapter");
        Coverage geoGrid = adapter.getGeoGrid();
        String paramName = dataChoice.getStringId();
        Trace.call1("GeoGridDataSource.make times");
        List times = this.getTimesFromDataSelection(givenDataSelection, dataChoice);
        List members = this.getEnsembleSelection();
        if (members == null) {
            members = (List)givenDataSelection.getProperty("prop.gridmembers");
        }
        int[] membersIndices = null;
        if (members != null) {
            int msize = members.size();
            membersIndices = new int[msize];
            for (int i = 0; i < msize; ++i) {
                membersIndices[i] = (Integer)members.get(i);
            }
        }
        int[] timeIndices = null;
        List allTimes = null;
        if (times != null) {
            timeIndices = new int[times.size()];
            allTimes = geoGrid.getCoordSys().getTimeAxis() == null && geoGrid.getCoordSys().getAxis(AxisType.RunTime) != null ? this.getGeoGridTimes((CoverageCoordAxis1D)geoGrid.getCoordSys().getAxis(AxisType.RunTime)) : this.getGeoGridTimes((CoverageCoordAxis1D)geoGrid.getCoordSys().getTimeAxis());
            int numTimes = allTimes.size();
            if (GridCoverageDataSource.holdsIndices(times)) {
                for (int i = 0; i < times.size(); ++i) {
                    int index = (Integer)times.get(i);
                    if (this.getReverseTimes()) {
                        index = numTimes - index - 1;
                    }
                    timeIndices[i] = index;
                }
            } else {
                CoverageCoordAxis1D cca = (CoverageCoordAxis1D)geoGrid.getCoordSys().getTimeAxis();
                for (int i = 0; i < times.size(); ++i) {
                    int index;
                    if (this.getReverseTimes()) {
                        index = allTimes.indexOf(times.get(i));
                        index = index < 0 ? numTimes - 1 : numTimes - index - 1;
                        DateTime dateTime = (DateTime)allTimes.get(index);
                        index = this.getTimeIndexWithBounds(dateTime, allTimes, cca);
                    } else {
                        index = this.getTimeIndexWithBounds((DateTime)times.get(i), allTimes, cca);
                    }
                    timeIndices[i] = index;
                }
            }
        }
        Trace.call2("GeoGridDataSource.make times");
        CoverageCoordAxis dd = geoGrid.getCoordSys().getAxis(AxisType.RunTime);
        CoverageCoordAxis dt = geoGrid.getCoordSys().getTimeAxis();
        StringBuilder buf = new StringBuilder();
        if (dd != null && dt != null) {
            for (int i = 0; i < timeIndices.length; ++i) {
                CalendarDate cd = null;
                int dsize = ((CoverageCoordAxis1D)dd).getCoordValueNames().size();
                cd = i < dsize ? dd.makeDate(timeIndices[i]) : dd.makeDate(timeIndices[dsize - 1]);
                CalendarDate ct = dt.makeDate(timeIndices[i]);
                long diff = ct.getDifferenceInMsecs(cd);
                float fh = (float)diff / 3600000.0f;
                buf.append(fh + ",");
            }
        } else if (dt != null) {
            CalendarDate ct0 = dt.makeDate(timeIndices[0]);
            if (allTimes.size() >= timeIndices.length) {
                for (int i = 0; i < timeIndices.length; ++i) {
                    CalendarDate ct = dt.makeDate(timeIndices[i]);
                    long diff = ct.getDifferenceInMsecs(ct0);
                    float fh = (float)diff / 3600000.0f;
                    buf.append(fh + ",");
                }
            }
        }
        if (buf.length() > 1) {
            buf.deleteCharAt(buf.length() - 1);
            dataChoice.setProperty("RUNTIME", buf.toString());
        }
        Trace.call1("GeoGridDataSource.getSequence");
        Object loadId = JobManager.getManager().startLoad("GeoGrid");
        if (adapter != null) {
            fieldImpl = membersIndices != null && membersIndices.length > 0 ? adapter.getSequence(timeIndices, membersIndices, loadId) : adapter.getSequence(timeIndices, loadId);
        }
        if (fieldImpl == null) {
            // empty if block
        }
        boolean useDriverTime = false;
        if (givenDataSelection != null) {
            useDriverTime = givenDataSelection.getProperty("Use_Display_Driver_Times", false);
        }
        if (givenDataSelection != null && !times.isEmpty()) {
            CalendarDateTime t0 = new CalendarDateTime((DateTime)times.get(0));
            CalendarDate dt0 = t0.getCalendarDate();
            CalendarDateTime t1 = new CalendarDateTime((DateTime)times.get(times.size() - 1));
            CalendarDate dt1 = t1.getCalendarDate();
            this.dateRange = CalendarDateRange.of(dt0, dt1);
        } else {
            this.dateRange = null;
        }
        Trace.call2("GeoGridDataSource.getSequence");
        if (fieldImpl == null) {
            if (!JobManager.getManager().canContinue(loadId)) {
                return null;
            }
            LogUtil.userMessage(log_, "Unable to load field: " + paramName + " from:" + this.getFilePath(), true);
            return null;
        }
        JobManager.getManager().stopLoad(loadId);
        Trace.call2("GeoGridDataSource.makeField");
        LogUtil.message("");
        log_.debug("Read grid in " + (System.currentTimeMillis() - millis));
        return fieldImpl;
    }

    public int getTimeIndexWithBounds(DateTime dateTime, List<DateTime> allTimes, CoverageCoordAxis1D cca) {
        int index = allTimes.indexOf(dateTime);
        if (index < 0) {
            return 0;
        }
        int lastindex = allTimes.lastIndexOf(dateTime);
        if (index == lastindex) {
            return index;
        }
        Object bbb = cca.getCoordObject(index);
        double[] bounds = null;
        if (bbb instanceof double[]) {
            bounds = (double[])bbb;
        }
        int finalIndex0 = index;
        if (bounds != null && bounds[1] != bounds[0]) {
            double min = bounds[1] - bounds[0];
            for (int ii = index + 1; ii <= lastindex; ++ii) {
                bounds = (double[])cca.getCoordObject(ii);
                double tmp = bounds[1] - bounds[0];
                if (!(tmp < min)) continue;
                finalIndex0 = ii;
            }
            index = finalIndex0;
        }
        return index;
    }

    public DtCoverage findGridForDataChoice(DtCoverageDataset ds, DataChoice dc) {
        if (ds == null) {
            return null;
        }
        String name = dc.getStringId();
        DtCoverage geoGrid = ds.findGridByName(name);
        return geoGrid;
    }

    protected boolean isZAxisOk(CoordinateAxis1D zaxis) {
        return GeoGridAdapter.isZAxisOk(zaxis);
    }

    @Override
    public List getAllDateTimes(DataChoice dataChoice) {
        return (List)this.timeMap.get(dataChoice.getId());
    }

    private DataChoice makeDataChoiceFromGeoGrid(DtCoverage cfield, List allTimes, Hashtable timeToIndex) {
        DtCoverageCS gcs = cfield.getCoordinateSystem();
        LatLonRect llr = gcs.getLatLonBoundingBox();
        LatLonPointImpl lleft = llr.getLowerLeftPoint();
        LatLonPointImpl uright = llr.getUpperRightPoint();
        double centerLat = lleft.getLatitude() + (uright.getLatitude() - lleft.getLatitude()) / 2.0;
        EarthLocationTuple elt = null;
        Hashtable<String, EarthLocationTuple> ht = new Hashtable<String, EarthLocationTuple>();
        try {
            elt = new EarthLocationTuple(centerLat, llr.getCenterLon(), 0.0);
            ht.put("INITIAL_PROBE_EARTHLOCATION", elt);
        }
        catch (Exception exception) {
            // empty catch block
        }
        CoordinateAxis xaxis = gcs.getXHorizAxis();
        CoordinateAxis yaxis = gcs.getYHorizAxis();
        CoordinateAxis1D zaxis = gcs.getVerticalAxis();
        long sizeZ = 0L;
        if (zaxis != null) {
            sizeZ = (int)zaxis.getSize();
        }
        Hashtable threeDProps = Misc.newHashtable("prop.icon", "/auxdata/ui/icons/3D.gif");
        Hashtable twoDProps = Misc.newHashtable("prop.icon", "/auxdata/ui/icons/2D.gif");
        if (ht != null) {
            threeDProps.putAll(ht);
            twoDProps.putAll(ht);
        }
        DirectDataChoice choice = null;
        if (sizeZ < 0L) {
            log_.error("    weird Geogrid -- it claims size Z<0; parm " + cfield.getName());
            return null;
        }
        if (this.isZAxisOk(zaxis)) {
            int yLength;
            int xLength;
            CoordinateAxis1DTime tAxis;
            String parmName;
            String pseudoName = parmName = cfield.getName();
            String description = cfield.getDescription();
            if (description == null || description.equals("")) {
                description = parmName;
            }
            if ((tAxis = (CoordinateAxis1DTime)gcs.getTimeAxis()) == null && gcs.getRunTimeAxis() != null) {
                tAxis = gcs.getRunTimeAxis();
            }
            List geoTimes = this.getGeoGridTimes(tAxis);
            this.timeMap.put(parmName, geoTimes);
            ArrayList<Integer> indexList = new ArrayList<Integer>();
            if (geoTimes != null && allTimes != null) {
                for (int i = 0; i < geoTimes.size(); ++i) {
                    Integer timeIndex = (Integer)timeToIndex.get(geoTimes.get(i));
                    indexList.add(timeIndex);
                }
            }
            DataSelection dataSelection = DataSelection.NULL;
            ArrayList<DataCategory> categories = null;
            Hashtable<String, Object> props = null;
            if (sizeZ == 0L || sizeZ == 1L) {
                xLength = cfield.getXDimension().getLength();
                yLength = cfield.getYDimension().getLength();
                if (this.twoDDimensionsLabel == null) {
                    this.twoDDimensionsLabel = "Total grid size:  x: " + xLength + "  y: " + yLength + "    #points: " + xLength * yLength;
                }
                props = new Hashtable<String, Object>(twoDProps);
                props.put(PROP_GRIDSIZE, new ThreeDSize(xLength, yLength));
                if (geoTimes != null) {
                    props.put(PROP_TIMESIZE, new Integer(geoTimes.size()));
                }
                categories = tAxis == null ? this.getTwoDCategories() : this.getTwoDTimeSeriesCategories();
            } else {
                int zLength;
                xLength = cfield.getXDimension().getLength();
                if (xLength * (yLength = cfield.getYDimension().getLength()) * (zLength = cfield.getZDimension().getLength()) > this.max3D) {
                    this.max3D = xLength * yLength * zLength;
                    this.max3DX = xLength;
                    this.max3DY = yLength;
                    this.max3DZ = zLength;
                }
                ThreeDSize size = new ThreeDSize(xLength, yLength, zLength);
                props = new Hashtable(threeDProps);
                props.put(PROP_GRIDSIZE, size);
                if (geoTimes != null) {
                    props.put(PROP_TIMESIZE, new Integer(geoTimes.size()));
                }
                categories = tAxis == null ? this.getThreeDCategories() : this.getThreeDTimeSeriesCategories();
            }
            Attribute attr = null;
            for (int i = 0; i < categoryAttributes.length && attr == null; ++i) {
                attr = cfield.findAttributeIgnoreCase(categoryAttributes[i]);
            }
            if (attr != null) {
                String append = attr.getStringValue();
                if (append != null) {
                    append = append.replaceAll("-", "_");
                }
                DataCategory cat = (DataCategory)categories.get(0);
                cat = cat.copyAndAppend(append);
                ArrayList<DataCategory> newCategories = new ArrayList<DataCategory>();
                newCategories.add(cat);
                for (int i = 1; i < categories.size(); ++i) {
                    newCategories.add((DataCategory)categories.get(i));
                }
                categories = newCategories;
            }
            Object group = null;
            choice = new DirectDataChoice(this, parmName, pseudoName, description, categories, dataSelection, props);
        }
        return choice;
    }

    private List getGeoGridTimes(CoverageCoordAxis1D timeAxis) {
        if (timeAxis == null || timeAxis.getNcoords() == 0) {
            return new ArrayList(0);
        }
        List<Object> times = (ArrayList)this.gcsVsTime.get(timeAxis);
        if (times != null) {
            return times;
        }
        try {
            times = new ArrayList();
            times = DataUtil.makeDateTimes(timeAxis);
            this.gcsVsTime.put(timeAxis, times);
        }
        catch (Exception e) {
            System.out.println("getGeoGridTimes() " + e);
        }
        return times;
    }

    private List getGeoGridTimes(CoordinateAxis1DTime timeAxis) {
        if (timeAxis == null || timeAxis.getSize() == 0L) {
            return new ArrayList(0);
        }
        List<CalendarDateTime> times = (List<CalendarDateTime>)this.gcsVsTime.get(timeAxis);
        if (times != null) {
            return times;
        }
        try {
            times = DataUtil.makeDateTimes(timeAxis);
            this.gcsVsTime.put(timeAxis, times);
        }
        catch (Exception e) {
            System.out.println("getGeoGridTimes() " + e);
        }
        return times;
    }

    public void setFileNameOrUrl(String value) {
        this.oldSourceFromBundles = value;
    }

    @Override
    public boolean applyProperties() {
        if (!super.applyProperties()) {
            return false;
        }
        if (this.reverseTimesCheckbox != null) {
            this.reverseTimes = this.reverseTimesCheckbox.isSelected();
        }
        return true;
    }

    @Override
    protected JComponent getExtraTimesComponent() {
        this.reverseTimesCheckbox = new JCheckBox("Reverse Times", this.reverseTimes);
        this.reverseTimesCheckbox.setToolTipText("If you have selected the first time then really use the last time");
        return GuiUtils.right(this.reverseTimesCheckbox);
    }

    public boolean getReverseTimes() {
        return this.reverseTimes;
    }

    public void setReverseTimes(boolean value) {
        this.reverseTimes = value;
    }

    public List<Range> getRangesFromLatLonRect(DtCoverageCS dtCoverageCS, LatLonRect rect) throws InvalidRangeException {
        ProjectionImpl proj = dtCoverageCS.getProjection();
        if (!(proj == null || proj instanceof VerticalPerspectiveView || proj instanceof MSGnavigation || proj instanceof Geostationary)) {
            LatLonRect bb = dtCoverageCS.getLatLonBoundingBox();
            LatLonRect rect2 = bb.intersect(rect);
            if (null == rect2) {
                throw new InvalidRangeException("Request Bounding box does not intersect Grid ");
            }
            rect = rect2;
        }
        CoordinateAxis xaxis = dtCoverageCS.getXHorizAxis();
        CoordinateAxis yaxis = dtCoverageCS.getYHorizAxis();
        LatLonPointImpl llpt = rect.getLowerLeftPoint();
        LatLonPointImpl urpt = rect.getUpperRightPoint();
        LatLonPointImpl lrpt = rect.getLowerRightPoint();
        LatLonPointImpl ulpt = rect.getUpperLeftPoint();
        double minx = GridCoverageDataSource.getMinOrMaxLon(llpt.getLongitude(), ulpt.getLongitude(), true);
        double miny = Math.min(llpt.getLatitude(), lrpt.getLatitude());
        double maxx = GridCoverageDataSource.getMinOrMaxLon(urpt.getLongitude(), lrpt.getLongitude(), false);
        double maxy = Math.min(ulpt.getLatitude(), urpt.getLatitude());
        double minLon = xaxis.getMinValue();
        minx = LatLonPointImpl.lonNormalFrom(minx, minLon);
        maxx = LatLonPointImpl.lonNormalFrom(maxx, minLon);
        if (xaxis instanceof CoordinateAxis1D && yaxis instanceof CoordinateAxis1D) {
            CoordinateAxis1D xaxis1 = (CoordinateAxis1D)xaxis;
            CoordinateAxis1D yaxis1 = (CoordinateAxis1D)yaxis;
            int minxIndex = xaxis1.findCoordElementBounded(minx);
            int minyIndex = yaxis1.findCoordElementBounded(miny);
            int maxxIndex = xaxis1.findCoordElementBounded(maxx);
            int maxyIndex = yaxis1.findCoordElementBounded(maxy);
            ArrayList<Range> list = new ArrayList<Range>();
            list.add(new Range(Math.min(minyIndex, maxyIndex), Math.max(minyIndex, maxyIndex)));
            list.add(new Range(Math.min(minxIndex, maxxIndex), Math.max(minxIndex, maxxIndex)));
            return list;
        }
        if (xaxis instanceof CoordinateAxis2D && yaxis instanceof CoordinateAxis2D) {
            CoordinateAxis2D lon_axis = (CoordinateAxis2D)xaxis;
            CoordinateAxis2D lat_axis = (CoordinateAxis2D)yaxis;
            int[] shape = lon_axis.getShape();
            int nj = shape[0];
            int ni = shape[1];
            int mini = Integer.MAX_VALUE;
            int minj = Integer.MAX_VALUE;
            int maxi = -1;
            int maxj = -1;
            for (int j = 0; j < nj; ++j) {
                for (int i = 0; i < ni; ++i) {
                    double lat = lat_axis.getCoordValue(j, i);
                    double lon = lon_axis.getCoordValue(j, i);
                    if (!(lat >= miny) || !(lat <= maxy) || !(lon >= minx) || !(lon <= maxx)) continue;
                    if (i > maxi) {
                        maxi = i;
                    }
                    if (i < mini) {
                        mini = i;
                    }
                    if (j > maxj) {
                        maxj = j;
                    }
                    if (j >= minj) continue;
                    minj = j;
                }
            }
            if (mini > maxi || minj > maxj) {
                mini = 0;
                minj = 0;
                maxi = -1;
                maxj = -1;
            }
            ArrayList<Range> list = new ArrayList<Range>();
            list.add(new Range(minj, maxj));
            list.add(new Range(mini, maxi));
            return list;
        }
        throw new IllegalArgumentException("must be 1D or 2D/LatLon ");
    }

    public List<Range> getRangesFromLonRange(DtCoverageCS dtCoverageCS, double lonMin, double lonMax) throws InvalidRangeException {
        CoordinateAxis xaxis = dtCoverageCS.getXHorizAxis();
        double minx = lonMin;
        double maxx = lonMax;
        double minLon = xaxis.getMinValue();
        minx = LatLonPointImpl.lonNormalFrom(minx, minLon);
        maxx = LatLonPointImpl.lonNormalFrom(maxx, minLon);
        if (xaxis instanceof CoordinateAxis1D) {
            CoordinateAxis1D xaxis1 = (CoordinateAxis1D)xaxis;
            int minxIndex = xaxis1.findCoordElementBounded(minx);
            int maxxIndex = xaxis1.findCoordElementBounded(maxx);
            ArrayList<Range> list = new ArrayList<Range>();
            list.add(new Range(Math.min(minxIndex, maxxIndex), Math.max(minxIndex, maxxIndex)));
            return list;
        }
        throw new IllegalArgumentException("must be 1D LatLon ");
    }

    public List<NamedObject> getTimes(List<CalendarDate> cdates) {
        ArrayList<NamedObject> times = new ArrayList<NamedObject>(cdates.size());
        for (CalendarDate cd : cdates) {
            times.add(new NamedAnything(cd.toString(), "calendar date"));
        }
        return times;
    }

    public static class HugeSizeException
    extends Exception {
    }
}

