/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.data.grid;

import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import java.util.stream.Collectors;
import ucar.ma2.Array;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.constants.AxisType;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.ft2.coverage.Coverage;
import ucar.nc2.ft2.coverage.CoverageCoordAxis;
import ucar.nc2.ft2.coverage.CoverageCoordAxis1D;
import ucar.nc2.ft2.coverage.CoverageCoordSys;
import ucar.nc2.ft2.coverage.GeoReferencedArray;
import ucar.nc2.ft2.coverage.SubsetParams;
import ucar.nc2.util.Optional;
import ucar.unidata.data.DataContext;
import ucar.unidata.data.DataUtil;
import ucar.unidata.data.grid.GeoGridAdapter;
import ucar.unidata.data.grid.GridCoverageDataSource;
import ucar.unidata.data.grid.GridUtil;
import ucar.unidata.geoloc.vertical.VerticalTransform;
import ucar.unidata.util.JobManager;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.ObjectPair;
import ucar.unidata.util.Range;
import ucar.unidata.util.Trace;
import ucar.unidata.util.TwoFacedObject;
import ucar.visad.RadarGridCoordinateSystem;
import ucar.visad.Util;
import ucar.visad.data.CalendarDateTime;
import ucar.visad.data.GridCoverageFlatField;
import ucar.visad.quantities.CommonUnits;
import ucar.visad.quantities.GeopotentialAltitude;
import ucar.visad.quantities.Gravity;
import visad.CachingCoordinateSystem;
import visad.CartesianProductCoordinateSystem;
import visad.CommonUnit;
import visad.CoordinateSystem;
import visad.Data;
import visad.DateTime;
import visad.EmpiricalCoordinateSystem;
import visad.ErrorEstimate;
import visad.FieldImpl;
import visad.FunctionType;
import visad.Gridded1DSet;
import visad.Gridded3DSet;
import visad.GriddedSet;
import visad.IdentityCoordinateSystem;
import visad.Linear1DSet;
import visad.Linear2DSet;
import visad.Linear3DSet;
import visad.LinearLatLonSet;
import visad.MathType;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.SampledSet;
import visad.Set;
import visad.SetException;
import visad.SetType;
import visad.SingletonSet;
import visad.Unit;
import visad.VisADException;
import visad.data.CachedFlatField;
import visad.data.in.ArithProg;
import visad.data.in.LonArithProg;
import visad.util.ThreadManager;

public class GridCoverageAdapter {
    static LogUtil.LogCategory log_ = LogUtil.getLogInstance(GeoGridAdapter.class.getName());
    static boolean makeGeoGridFlatField = true;
    private static int count = 0;
    public String cacheFile;
    RealType paramType;
    double[] vIntv;
    private GridCoverageDataSource dataSource;
    private Object extraCacheKey;
    private boolean lazyEvaluation = true;
    private Coverage geoGrid = null;
    private SubsetParams subsetParams;
    private double fhgLevel = -999.9;
    private NetcdfFile ncFile;
    private String paramName;
    private Object readLock;
    private String vertcs = "ucar.visad.quantities.AirPressure$StandardAtmosphereCoordinateSystem";

    public GridCoverageAdapter(GridCoverageDataSource dataSource, Coverage geoGrid, SubsetParams params) throws VisADException {
        this(dataSource, geoGrid, params, geoGrid.getName());
    }

    public GridCoverageAdapter(GridCoverageDataSource dataSource, Coverage geoGrid, SubsetParams params, String paramName) throws VisADException {
        this(dataSource, geoGrid, params, paramName, null);
    }

    public GridCoverageAdapter(GridCoverageDataSource dataSource, Coverage geoGrid, SubsetParams params, NetcdfFile ncFile) throws VisADException {
        this(dataSource, geoGrid, params, geoGrid.getName(), ncFile);
    }

    public GridCoverageAdapter(GridCoverageDataSource dataSource, Coverage geoGrid, SubsetParams params, String paramName, NetcdfFile ncFile) throws VisADException {
        this(dataSource, geoGrid, params, paramName, ncFile, null);
    }

    public GridCoverageAdapter(GridCoverageDataSource dataSource, Coverage geoGrid, SubsetParams params, String paramName, NetcdfFile ncFile, Object extraCacheKey) throws VisADException {
        String vcs;
        DataContext dataContext;
        this.dataSource = dataSource;
        if (dataSource != null && (dataContext = dataSource.getDataContext()) != null && (vcs = (String)dataContext.getPreference("Data.VerticalCS")) != null) {
            this.vertcs = vcs;
        }
        this.readLock = dataSource.readLock;
        if (geoGrid == null) {
            throw new IllegalArgumentException("GeoGridAdapter: geogrid cannot be null");
        }
        this.ncFile = ncFile;
        this.paramName = paramName;
        this.geoGrid = geoGrid;
        this.subsetParams = params;
        this.vIntv = params.getVertCoordIntv();
        this.paramType = this.makeRealType(paramName, this.getUnit(geoGrid.getUnitsString()));
        this.extraCacheKey = extraCacheKey;
    }

    public static boolean isZAxisOk(CoordinateAxis1D zaxis) {
        return true;
    }

    public static boolean isZUnitOk(Unit zUnit, VerticalTransform vt) {
        return vt != null || zUnit != null && (Unit.canConvert(zUnit, CommonUnits.MILLIBAR) || Unit.canConvert(zUnit, CommonUnit.meter));
    }

    protected List getLevels() throws VisADException {
        ArrayList<Real> levels = new ArrayList<Real>();
        CoverageCoordSys gcs = this.geoGrid.getCoordSys();
        CoverageCoordAxis zAxis = gcs.getZAxis();
        if (zAxis == null) {
            return levels;
        }
        int sizeZ = zAxis.getNcoords();
        if (sizeZ == 0) {
            return levels;
        }
        boolean isLinear = true;
        Unit zUnit = this.getUnit(zAxis.getUnits());
        boolean isLatLon = gcs.getProjection().isLatLon();
        RealType zType = null;
        boolean is2D = this.is2D(sizeZ, zUnit);
        if (is2D) {
            return levels;
        }
        if (Unit.canConvert(zUnit, CommonUnit.meter)) {
            zUnit = zUnit.scale(-1.0);
            zType = RealType.Altitude;
        } else {
            zType = this.makeRealType(zAxis.getName(), zUnit);
        }
        if (this.subsetParams != null && this.subsetParams.getVertCoordIntv() != null) {
            double[] vert = this.subsetParams.getVertCoordIntv();
            double[] allLevels = zAxis.getValues();
            for (int i = 0; i < allLevels.length; ++i) {
                if (!(allLevels[i] >= vert[0]) || !(allLevels[i] <= vert[1])) continue;
                levels.add(new Real(zType, allLevels[i], zUnit));
            }
        } else {
            for (int k = 0; k < sizeZ; ++k) {
                float kValue = (float)zAxis.getValues()[k];
                levels.add(new Real(zType, kValue, zUnit));
            }
        }
        return levels;
    }

    protected Coverage getGeoGrid() {
        return this.geoGrid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GriddedSet getSpatialDomainSet(Coverage geogrid, SubsetParams subsetParams, int timeIndex) throws VisADException {
        Object object = this.dataSource.DOMAIN_SET_MUTEX;
        synchronized (object) {
            return this.getSpatialDomainSetInner(geogrid, subsetParams, timeIndex);
        }
    }

    private GriddedSet getSpatialDomainSetInner(Coverage geogrid, SubsetParams subsetParams, int timeIndex) throws VisADException {
        CoordinateSystem cs;
        CoverageCoordSys gcs = geogrid.getCoordSys();
        Object vt = null;
        boolean isTimeDependent = true;
        Trace.msg("GeoGridAdapter isTimeDependent = " + isTimeDependent);
        Object timeStepKey = !isTimeDependent ? gcs : new ObjectPair(gcs, new Integer(timeIndex));
        timeStepKey = Misc.newList(timeStepKey, this.extraCacheKey);
        GriddedSet domainSet = (GriddedSet)this.dataSource.getCache(timeStepKey, true);
        if (domainSet != null) {
            return domainSet;
        }
        List domainSetKey = Misc.newList(gcs, this.extraCacheKey);
        float[][] refVals = null;
        Object[] cachedPair = (Object[])this.dataSource.getCache(domainSetKey, true);
        if (cachedPair != null) {
            domainSet = (GriddedSet)cachedPair[0];
            refVals = (float[][])cachedPair[1];
        } else {
            Trace.call1("GeoGridAdapter.getInitialSpatialDomain");
            domainSet = this.getInitialSpatialDomain(geogrid, subsetParams);
            Trace.call2("GeoGridAdapter.getInitialSpatialDomain");
            cs = domainSet.getCoordinateSystem();
            if (cs != null) {
                Trace.call1("GeoGridAdapter.transformCoordinates");
                RealTupleType setType = ((SetType)domainSet.getType()).getDomain();
                RealTupleType refType = cs.getReference();
                ErrorEstimate[] oldErrors = domainSet.getSetErrors();
                ErrorEstimate[] newErrors = new ErrorEstimate[oldErrors.length];
                float[][] setVals = domainSet.getSamples();
                refVals = CoordinateSystem.transformCoordinates(refType, refType.getCoordinateSystem(), refType.getDefaultUnits(), newErrors, setType, cs, domainSet.getSetUnits(), oldErrors, setVals, false);
                Trace.call2("GeoGridAdapter.transformCoordinates");
            }
            this.dataSource.putCache(domainSetKey, new Object[]{domainSet, refVals}, true);
        }
        cs = domainSet.getCoordinateSystem();
        if (vt != null && cs != null) {
            Trace.call1("GeoGridAdapter.spatial makeDomainWithVerticalTransform");
            domainSet = this.makeDomainWithVerticalTransform(gcs, domainSet, refVals, timeIndex);
            Trace.call2("GeoGridAdapter.spatial makeDomainWithVerticalTransform");
        }
        this.dataSource.putCache(timeStepKey, domainSet, true);
        log_.debug("DomainSet = " + domainSet);
        return domainSet;
    }

    private GriddedSet getInitialSpatialDomain(Coverage geogrid, SubsetParams subsetParams) throws VisADException {
        List domainTemplateKey;
        RealTupleType cachedDomainTemplate;
        int sizeZ;
        boolean yIsLinear;
        GriddedSet domainSet = null;
        CoverageCoordSys gcs = geogrid.getCoordSys();
        Object vt = null;
        Optional<CoverageCoordSys> opt = gcs.subset(subsetParams);
        CoverageCoordSys subsetCoordSys = opt.get();
        CoverageCoordAxis xAxis = subsetCoordSys.getXAxis();
        CoverageCoordAxis yAxis = subsetCoordSys.getYAxis();
        CoverageCoordAxis1D zAxis = (CoverageCoordAxis1D)gcs.getZAxis();
        double[] allLevels = null;
        if (zAxis != null) {
            Array lst = zAxis.getCoordsAsArray();
            int size = (int)lst.getSize();
            allLevels = new double[size];
            for (int k = 0; k < size; ++k) {
                float kValue = lst.getFloat(k);
                allLevels[k] = kValue;
            }
        }
        double[] vIntv = subsetParams.getVertCoordIntv();
        int numLevels = -1;
        int fromLevelIndex = -1;
        int toLevelIndex = -1;
        if (vIntv != null) {
            List levelList = Arrays.stream(allLevels).boxed().collect(Collectors.toList());
            fromLevelIndex = this.indexOf(vIntv[0], levelList);
            toLevelIndex = this.indexOf(vIntv[1], levelList);
        }
        if (fromLevelIndex >= 0 && toLevelIndex >= 0) {
            numLevels = Math.abs(toLevelIndex - fromLevelIndex) + 1;
        } else if (fromLevelIndex == -1 && toLevelIndex == -1 && zAxis != null) {
            numLevels = zAxis.getNcoords();
        }
        boolean xIsLinear = true;
        boolean isLinear = yIsLinear = true;
        int n = sizeZ = zAxis == null ? 0 : numLevels;
        if (zAxis == null) {
            sizeZ = 0;
        }
        boolean bl = isLinear = isLinear && sizeZ != 1;
        if (isLinear && sizeZ > 1) {
            isLinear = this.checkLinearity(zAxis, false);
        }
        Unit xUnit = this.getUnit(xAxis.getUnits());
        Unit yUnit = this.getUnit(yAxis.getUnits());
        Unit zUnit = null;
        if (zAxis != null) {
            zUnit = this.getUnit(zAxis.getUnits());
        }
        log_.debug("    x axis has units " + xAxis.getUnits() + " or " + xUnit);
        log_.debug("    y axis has units " + yAxis.getUnits() + " or " + yUnit);
        if (zAxis != null) {
            log_.debug("    z axis has units " + zAxis.getUnits() + " or " + zUnit);
        }
        log_.debug("  grid size: x = " + xAxis.getNcoords() + " y = " + yAxis.getNcoords() + " z = " + sizeZ);
        boolean isLatLon = true;
        Object domainCS = null;
        RealType xType = null;
        RealType yType = null;
        RealType zType = null;
        boolean needToWrapLon = false;
        if (isLatLon) {
            xIsLinear = this.checkLinearity(xAxis, false);
            if (xIsLinear) {
                needToWrapLon = this.checkNeedToWrapLon(xAxis);
            }
        } else {
            xIsLinear = true;
        }
        isLinear = isLinear && xIsLinear;
        RealTupleType domainTemplate = null;
        boolean is2D = this.is2D(sizeZ, zUnit);
        if (isLatLon) {
            log_.debug("is lat/lon");
            if (is2D) {
                xType = RealType.Longitude;
                yType = RealType.Latitude;
                domainTemplate = RealTupleType.SpatialEarth2DTuple;
                if (xAxis.getUnits().equals("")) {
                    xUnit = CommonUnit.degree;
                }
                if (yAxis.getUnits().equals("")) {
                    yUnit = CommonUnit.degree;
                }
            } else if (Unit.canConvert(zUnit, CommonUnit.meter)) {
                if (!((CoverageCoordAxis1D)subsetCoordSys.getZAxis()).isAscending()) {
                    zUnit = zUnit.scale(-1.0);
                }
                xType = RealType.Longitude;
                yType = RealType.Latitude;
                zType = RealType.Altitude;
                domainTemplate = RealTupleType.SpatialEarth3DTuple;
            } else {
                xType = this.makeRealType(xAxis.getName().equals("Longitude") ? "longi" : xAxis.getName(), xUnit);
                yType = this.makeRealType(yAxis.getName().equals("Latitude") ? "lati" : yAxis.getName(), yUnit);
                zType = this.makeRealType(zAxis.getName(), zUnit);
                CoordinateSystem compCS = null;
                if (vt != null) {
                    compCS = new CartesianProductCoordinateSystem(new IdentityCoordinateSystem(RealTupleType.SpatialEarth2DTuple), new IdentityCoordinateSystem(new RealTupleType(zType)));
                } else if (Unit.canConvert(zUnit, CommonUnits.MILLIBAR)) {
                    compCS = new CartesianProductCoordinateSystem(new IdentityCoordinateSystem(RealTupleType.SpatialEarth2DTuple), new CachingCoordinateSystem(DataUtil.getPressureToHeightCS(this.vertcs)));
                } else if (Unit.canConvert(zUnit, CommonUnit.degree) && !zUnit.getIdentifier().equals("")) {
                    zType = this.makeRealType("elev_angle", zUnit);
                    compCS = this.makeElevationCS();
                } else {
                    LogUtil.userMessage(log_, "Unknown vertical coordinate with Unit " + zUnit + ", using linear scale to Altitude", true);
                    compCS = new CartesianProductCoordinateSystem(new IdentityCoordinateSystem(RealTupleType.SpatialEarth2DTuple), new IdentityCoordinateSystem(new RealTupleType(RealType.Altitude), new Unit[]{zUnit}));
                }
                domainTemplate = new RealTupleType(xType, yType, zType, compCS, null);
            }
        }
        if ((cachedDomainTemplate = (RealTupleType)this.dataSource.getCache(domainTemplateKey = Misc.newList(subsetCoordSys, "DomainType", this.extraCacheKey), true)) != null) {
            Trace.msg("GeoGridAdapter:using cached domain template:" + cachedDomainTemplate);
            domainTemplate = cachedDomainTemplate;
        } else {
            Trace.msg("GeoGridAdapter:using new domain template:" + domainTemplate);
            this.dataSource.putCache(domainTemplateKey, domainTemplate, true);
        }
        if (isLinear) {
            Linear1DSet xSet = this.makeLinear1DSet((CoverageCoordAxis1D)xAxis, xType, xUnit, needToWrapLon);
            Linear1DSet ySet = this.makeLinear1DSet((CoverageCoordAxis1D)yAxis, yType, yUnit);
            if (is2D) {
                if (isLatLon) {
                    try {
                        domainSet = new LinearLatLonSet((MathType)domainTemplate, new Linear1DSet[]{xSet, ySet}, (CoordinateSystem)null, new Unit[]{xUnit, yUnit}, (ErrorEstimate[])null, true);
                    }
                    catch (SetException se) {
                        domainSet = new Linear2DSet((MathType)domainTemplate, new Linear1DSet[]{xSet, ySet}, (CoordinateSystem)null, new Unit[]{xUnit, yUnit}, (ErrorEstimate[])null, true);
                    }
                } else {
                    domainSet = new Linear2DSet((MathType)domainTemplate, new Linear1DSet[]{xSet, ySet}, (CoordinateSystem)null, new Unit[]{xUnit, yUnit}, (ErrorEstimate[])null, true);
                }
            } else {
                Linear1DSet zSet = this.makeLinear1DSet(zAxis, zType, zUnit);
                domainSet = new Linear3DSet((MathType)domainTemplate, new Linear1DSet[]{xSet, ySet, zSet}, (CoordinateSystem)null, new Unit[]{xUnit, yUnit, zUnit}, (ErrorEstimate[])null, true);
            }
        } else {
            Unit[] units;
            int idx;
            float[][] coordData;
            log_.debug("not linear set");
            int sizeX = xAxis.getNcoords();
            log_.debug("x has " + sizeX + " elements");
            int sizeY = yAxis.getNcoords();
            log_.debug("y has " + sizeY + " elements");
            boolean is1D = true;
            log_.debug("x has rank 1");
            int[] lengths = null;
            if (is2D) {
                if (needToWrapLon) {
                    ++sizeX;
                }
                log_.debug("sizeZ <= 1 (i.e., 2D)");
                coordData = new float[2][is1D ? sizeX * sizeY : sizeX];
                idx = 0;
                if (is1D) {
                    for (int j = 0; j < sizeY; ++j) {
                        for (int i = 0; i < sizeX; ++i) {
                            coordData[0][idx] = needToWrapLon && i == sizeX - 1 ? (float)((double)xAxis.getCoordsAsArray().getFloat(i - 1) + xAxis.getResolution()) : xAxis.getCoordsAsArray().getFloat(i);
                            coordData[1][idx] = yAxis.getCoordsAsArray().getFloat(j);
                            ++idx;
                        }
                    }
                    lengths = new int[]{sizeX, sizeY};
                }
                units = new Unit[]{xUnit, yUnit};
            } else {
                if (is1D && needToWrapLon) {
                    ++sizeX;
                }
                Trace.call1("GeoGridAdapter:making coordData array", " size:" + sizeX * sizeY * sizeZ);
                coordData = is1D ? new float[3][sizeX * sizeY * sizeZ] : new float[3][sizeX * sizeZ];
                Trace.call2("GeoGridAdapter:making coordData array");
                idx = 0;
                if (is1D) {
                    int[] nArray;
                    int i;
                    Trace.call1("GeoGridAdapter:getCoordValue");
                    float[] xValues = new float[sizeX];
                    float[] yValues = new float[sizeY];
                    for (i = 0; i < xValues.length; ++i) {
                        xValues[i] = needToWrapLon && i == sizeX - 1 ? (float)((double)xAxis.getCoordsAsArray().getFloat(i - 1) + xAxis.getResolution()) : xAxis.getCoordsAsArray().getFloat(i);
                    }
                    for (i = 0; i < yValues.length; ++i) {
                        yValues[i] = yAxis.getCoordsAsArray().getFloat(i);
                    }
                    if (fromLevelIndex == -1) {
                        fromLevelIndex = 0;
                    }
                    float[] coordData0 = coordData[0];
                    float[] coordData1 = coordData[1];
                    float[] coordData2 = coordData[2];
                    for (int k = 0; k < sizeZ; ++k) {
                        int kk = fromLevelIndex + k;
                        float kValue = (float)allLevels[kk];
                        for (int j = 0; j < sizeY; ++j) {
                            float yValue = yValues[j];
                            for (int i2 = 0; i2 < sizeX; ++i2) {
                                coordData0[idx] = xValues[i2];
                                coordData1[idx] = yValue;
                                coordData2[idx] = kValue;
                                ++idx;
                            }
                        }
                    }
                    Trace.call2("GeoGridAdapter:getCoordValue", " cnt=" + idx);
                    if (sizeZ > 1) {
                        int[] nArray2 = new int[3];
                        nArray2[0] = sizeX;
                        nArray2[1] = sizeY;
                        nArray = nArray2;
                        nArray2[2] = sizeZ;
                    } else {
                        int[] nArray3 = new int[2];
                        nArray3[0] = sizeX;
                        nArray = nArray3;
                        nArray3[1] = sizeY;
                    }
                    lengths = nArray;
                }
                units = new Unit[]{xUnit, yUnit, zUnit};
            }
            Trace.call1("GeoGridAdapter.spatial GriddedSet.create");
            try {
                domainSet = GriddedSet.create(domainTemplate, coordData, lengths, null, units, null, false, true);
            }
            catch (SetException se) {
                String msg = se.getMessage();
                if (msg.indexOf("form a valid grid") >= 0 || msg.indexOf("may not be missing") >= 0) {
                    domainSet = GriddedSet.create(domainTemplate, coordData, lengths, null, units, null, false, false);
                }
                throw new VisADException(se);
            }
            Trace.call2("GeoGridAdapter.spatial GriddedSet.create");
        }
        log_.debug("Domain set = " + domainSet);
        return domainSet;
    }

    private boolean checkNeedToWrapLon(CoverageCoordAxis axis) {
        double newLast;
        double last;
        double first;
        CoverageCoordAxis1D axis1D = (CoverageCoordAxis1D)axis;
        return axis1D.isRegular() && (first = axis1D.getCoordEdgeFirst()) + 360.0 != (last = axis1D.getCoordEdgeLast()) && GridUtil.isLonCyclic(first, newLast = last + axis1D.getResolution());
    }

    private GriddedSet makeDomainWithVerticalTransform(CoverageCoordSys vt, GriddedSet domainSet, float[][] refVals, int timeIndex) throws VisADException {
        Gridded3DSet newDSet = (Gridded3DSet)domainSet;
        try {
            CoordinateSystem cs = domainSet.getCoordinateSystem();
            if (cs == null) {
                return newDSet;
            }
            RealTupleType setType = ((SetType)domainSet.getType()).getDomain();
            RealTupleType refType = cs.getReference();
            ErrorEstimate[] oldErrors = domainSet.getSetErrors();
            ErrorEstimate[] newErrors = new ErrorEstimate[oldErrors.length];
            Unit vtu = this.getUnit(vt.getZAxis().getUnits());
            log_.debug("vtu = " + vtu);
            RealType[] types = refType.getRealComponents();
            boolean isPressure = false;
            boolean isGeopotentialAltitude = false;
            if (!Unit.canConvert(vtu, CommonUnit.meter)) {
                if (Unit.canConvert(vtu, CommonUnits.MILLIBAR)) {
                    isPressure = true;
                } else if (Unit.canConvert(vtu, GeopotentialAltitude.getGeopotentialMeter())) {
                    isGeopotentialAltitude = true;
                } else {
                    throw new VisADException("unknown vertical coordinate");
                }
            }
            RealTupleType newDomainType = new RealTupleType(types[0], types[1], RealType.Altitude);
            Trace.call1("GeoGridAdapter.getCoordinateArray", " vt:" + vt.getClass().getName());
            Array array = vt.getZAxis().getCoordsAsArray();
            Trace.call2("GeoGridAdapter.getCoordinateArray");
            Trace.call1("GeoGridAdapter.get1DValues");
            float[] vals = DataUtil.toFloatArray(array);
            if (vals.length != domainSet.getLength()) {
                int[] dl = domainSet.getLengths();
                float[] valsT = new float[domainSet.getLength()];
                int ii = 0;
                int jj = 0;
                int xl = dl[0] - 1;
                if (dl.length == 2) {
                    for (int j = 0; j < dl[1]; ++j) {
                        for (int i = 0; i < xl; ++i) {
                            ii = i + j * xl;
                            jj = i + j * (xl + 1);
                            valsT[jj] = vals[ii];
                        }
                        valsT[jj + 1] = valsT[j * xl];
                    }
                } else if (dl.length == 3) {
                    int yl = dl[1];
                    for (int k = 0; k < dl[2]; ++k) {
                        for (int j = 0; j < dl[1]; ++j) {
                            for (int i = 0; i < xl; ++i) {
                                ii = i + j * xl + k * xl * yl;
                                jj = i + j * (xl + 1) + k * (xl + 1) * yl;
                                valsT[jj] = vals[ii];
                            }
                            valsT[jj + 1] = valsT[j * (xl + 1) + k * (xl + 1) * yl];
                        }
                    }
                }
                refVals[2] = valsT;
            } else {
                refVals[2] = vals;
            }
            Trace.call2("GeoGridAdapter.get1DValues");
            if (isPressure) {
                CoordinateSystem vcs = DataUtil.getPressureToHeightCS(this.vertcs);
                refVals[2] = vcs.toReference(new float[][]{refVals[2]}, new Unit[]{vtu})[0];
                vtu = vcs.getReferenceUnits()[0];
            } else if (isGeopotentialAltitude) {
                refVals[2] = GeopotentialAltitude.toAltitude(refVals[2], vtu, Gravity.newReal(), refVals[2], CommonUnit.meter, false);
                vtu = CommonUnit.meter;
            }
            int[] lengths = domainSet.getLengths();
            Unit[] newDomainUnits = newDomainType.getDefaultUnits();
            newDomainUnits[2] = vtu;
            Trace.call1("GeoGridAdapter.new GriddedSet");
            Gridded3DSet newDomain = (Gridded3DSet)GriddedSet.create(newDomainType, refVals, lengths, null, newDomainUnits, newErrors, false, false);
            if (domainSet.getManifoldDimension() == 2) {
                return newDomain;
            }
            Trace.call2("GeoGridAdapter.new GriddedSet");
            Trace.call1("GeoGridAdapter.new EmpiricalCoordinateSystem");
            EmpiricalCoordinateSystem ecs = new EmpiricalCoordinateSystem(domainSet, newDomain, false, false);
            Trace.call2("GeoGridAdapter.new EmpiricalCoordinateSystem");
            EmpiricalCoordinateSystem gcs = ecs;
            RealTupleType newSetType = new RealTupleType(setType.getRealComponents(), (CoordinateSystem)gcs, null);
            Trace.call1("GeoGridAdapter final GriddedSet");
            newDSet = (Gridded3DSet)GriddedSet.create(newSetType, domainSet.getSamples(false), lengths, null, domainSet.getSetUnits(), oldErrors, false, false);
            Trace.call2("GeoGridAdapter final GriddedSet");
        }
        catch (VisADException ve) {
            throw ve;
        }
        catch (Exception re) {
            re.printStackTrace();
            throw new VisADException(re.getMessage());
        }
        return newDSet;
    }

    public FieldImpl getSequence() {
        return this.makeSequence(null);
    }

    public FieldImpl getSequence(int[] timeIndices) {
        return this.makeSequence(timeIndices);
    }

    public FieldImpl getSequence(int[] timeIndices, Object loadId) {
        return this.makeSequence(timeIndices, null, loadId);
    }

    public FieldImpl getSequence(int[] timeIndices, int[] memberIndices, Object loadId) {
        return this.makeSequence(timeIndices, memberIndices, loadId);
    }

    public FieldImpl getData() throws VisADException {
        return (CoverageCoordAxis1D)this.geoGrid.getCoordSys().getTimeAxis() != null ? this.getSequence() : (this.getBaseTime() == null ? this.getFlatField(0, "") : this.makeSequence(null));
    }

    private CachedFlatField getFlatField(int timeIndex, String readLabel) throws VisADException {
        return this.getFlatField(timeIndex, -1, readLabel);
    }

    private CachedFlatField getFlatField(int timeIndex, int ensIndex, String readLabel) throws VisADException {
        String baseCacheKey = "t_" + timeIndex;
        List cacheKey = Misc.newList(baseCacheKey);
        if (ensIndex >= 0) {
            String ensCacheKey = "e_" + ensIndex;
            cacheKey.add(ensCacheKey);
        } else {
            ensIndex = 0;
        }
        if (this.extraCacheKey != null) {
            cacheKey.add(this.extraCacheKey);
        }
        cacheKey.add(this.subsetParams);
        CachedFlatField retField = null;
        if (retField != null) {
            return retField;
        }
        Trace.call1("GeoGridAdapter.getFlatField:" + this.paramName + ":time=" + timeIndex);
        CoverageCoordSys gcs = this.geoGrid.getCoordSys();
        Trace.call1("GeoGridAdapter.getSpatialDomainSet");
        GriddedSet domainSet = this.getSpatialDomainSet(this.geoGrid, this.subsetParams, timeIndex);
        Trace.call2("GeoGridAdapter.getSpatialDomainSet");
        FunctionType ffType = new FunctionType(((SetType)domainSet.getType()).getDomain(), this.paramType);
        if (!makeGeoGridFlatField) {
            Array arr;
            block20: {
                System.err.println("making flat field");
                try {
                    LogUtil.message(readLabel);
                    Trace.call1("GeoGridAdapter.geogrid.readVolumeData");
                    System.err.println(System.currentTimeMillis() + " time:" + timeIndex + " start read");
                    GeoReferencedArray mySubset = this.geoGrid.readData(this.subsetParams);
                    arr = mySubset.getData();
                    System.err.println(System.currentTimeMillis() + " time:" + timeIndex + " end read");
                    Trace.call2("GeoGridAdapter.geogrid.readVolumeData");
                    if (arr.getRank() <= 2 || domainSet.getDimension() != 2) break block20;
                    int[] lengths = domainSet.getLengths();
                    int sizeX = lengths[0];
                    int sizeY = lengths[1];
                    int levelIndex = 0;
                    int[] shape = arr.getShape();
                    for (int i = 0; i <= arr.getRank(); ++i) {
                        if (shape[i] == sizeX || shape[i] == sizeY) continue;
                        arr = arr.slice(i, levelIndex);
                        break;
                    }
                }
                catch (RemoteException e) {
                    LogUtil.printException(log_, "getFlatField read got RemoteException", e);
                    return null;
                }
                catch (InvalidRangeException es) {
                    LogUtil.printException(log_, "getFlatField read got RemoteException", es);
                    return null;
                }
                catch (IOException e) {
                    LogUtil.printException(log_, "getFlatField read got IOException", e);
                    return null;
                }
            }
            float[][] fieldArray = new float[1][];
            float[] values = DataUtil.toFloatArray(arr);
            Class dataClass = arr.getElementType();
            if (values.length < domainSet.getLength()) {
                float[] newValues = new float[domainSet.getLength()];
                int[] lengths = domainSet.getLengths();
                int l = 0;
                int sizeX = lengths[0];
                int sizeY = lengths[1];
                if (lengths.length == 2) {
                    for (int j = 0; j < sizeY; ++j) {
                        for (int i = 0; i < sizeX; ++i) {
                            int xpos = i < sizeX - 1 ? i : 0;
                            newValues[l++] = values[j * (sizeX - 1) + xpos];
                        }
                    }
                } else {
                    for (int k = 0; k < lengths[2]; ++k) {
                        for (int j = 0; j < sizeY; ++j) {
                            for (int i = 0; i < sizeX; ++i) {
                                int xpos = i < sizeX - 1 ? i : 0;
                                newValues[l++] = values[k * sizeY * (sizeX - 1) + j * (sizeX - 1) + xpos];
                            }
                        }
                    }
                }
                fieldArray[0] = newValues;
            } else {
                fieldArray[0] = values;
            }
            retField = new CachedFlatField(ffType, (Set)domainSet, fieldArray);
        } else {
            Object readLockToUse = this.dataSource.isLocalFile() ? this.readLock : new Object();
            this.subsetParams.setVertCoordIntv(this.vIntv);
            GridCoverageFlatField ggff = new GridCoverageFlatField(this.geoGrid, this.subsetParams, readLockToUse, timeIndex, ensIndex, domainSet, ffType);
            ggff.setReadLabel(readLabel);
            retField = ggff;
        }
        this.dataSource.putCache(cacheKey, retField);
        Trace.call2("GeoGridAdapter.getFlatField:" + this.paramName + ":time=" + timeIndex);
        return retField;
    }

    private FieldImpl makeSequence(int[] timeIndices) {
        return this.makeSequence(timeIndices, null, null);
    }

    private FieldImpl makeSequence(int[] timeIndices, int[] memberIndices, Object loadId) {
        FieldImpl data = null;
        Trace.call1("GeoGridAdapter.makeSequence");
        try {
            int[] times;
            final TreeMap gridMap = new TreeMap();
            CoverageCoordSys geoSys = this.geoGrid.getCoordSys();
            CoverageCoordAxis1D timeAxis = (CoverageCoordAxis1D)geoSys.getTimeAxis();
            if (timeAxis == null && geoSys.getAxis(AxisType.RunTime) != null) {
                timeAxis = (CoverageCoordAxis1D)geoSys.getAxis(AxisType.RunTime);
            }
            List<CalendarDateTime> datetimes = null;
            if (timeAxis != null) {
                datetimes = DataUtil.makeDateTimes(timeAxis);
            }
            if (timeAxis == null) {
                times = new int[]{0};
            } else if (timeIndices == null) {
                int numTimes = timeAxis.getValues().length;
                times = new int[numTimes];
                for (int i = 0; i < numTimes; ++i) {
                    times[i] = i;
                }
            } else {
                times = timeIndices;
            }
            final Range[][] sampleRanges = new Range[][]{null};
            StringBuffer testModeBuffer = null;
            ThreadManager threadManager = new ThreadManager("GeoGrid data reading");
            for (int i = 0; i < times.length; ++i) {
                CalendarDateTime time;
                if (!JobManager.getManager().canContinue(loadId)) {
                    return null;
                }
                if (times[i] < 0) continue;
                if (timeAxis != null) {
                    time = datetimes.get(times[i]);
                } else {
                    time = this.getBaseTime();
                    if (time == null) {
                        if (timeAxis == null) {
                            return this.getFlatField(0, "");
                        }
                        time = new CalendarDateTime();
                    }
                }
                log_.debug("  ...grid " + i);
                log_.debug("    data time " + time);
                final String readLabel = "Time: " + (i + 1) + "/" + times.length + " " + this.paramName + " From: " + this.dataSource.toString();
                final int theTimeIndex = times[i];
                final CalendarDateTime theTime = time;
                final int[] theMemberIndices = memberIndices;
                threadManager.addRunnable(new ThreadManager.MyRunnable(){

                    @Override
                    public void run() throws Exception {
                        GridCoverageAdapter.this.readTimeStep(theTimeIndex, theTime, readLabel, gridMap, sampleRanges, GridCoverageAdapter.this.lazyEvaluation, theMemberIndices);
                    }
                });
            }
            if (this.dataSource.getIdv() == null || this.dataSource.isLocalFile()) {
                threadManager.runSequentially();
            } else {
                threadManager.runInParallel(this.dataSource.getDataContext().getIdv().getMaxDataThreadCount());
            }
            log_.debug("    found " + gridMap.size() + " times");
            java.util.Set keySet = gridMap.keySet();
            if (gridMap.size() > 0) {
                SampledSet domain = gridMap.size() == 1 ? new SingletonSet(new RealTuple(new Real[]{(CalendarDateTime)gridMap.firstKey()})) : CalendarDateTime.makeTimeSet(keySet.toArray(new CalendarDateTime[keySet.size()]));
                int i = 0;
                Iterator iter = keySet.iterator();
                while (iter.hasNext()) {
                    FieldImpl field = (FieldImpl)gridMap.get(iter.next());
                    if (i == 0) {
                        FunctionType fType = new FunctionType(RealType.Time, field.getType());
                        data = new FieldImpl(fType, domain);
                    }
                    data.setSample(i, (Data)field, false);
                    ++i;
                }
            } else if (testModeBuffer != null) {
                System.err.println(testModeBuffer.toString());
            }
        }
        catch (Exception e) {
            LogUtil.logException("Couldn't get data ", e);
        }
        Trace.call2("GeoGridAdapter.makeSequence");
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void readTimeStep(int timeIndex, CalendarDateTime time, String readLabel, TreeMap gridMap, Range[][] sampleRanges, boolean lazyEvaluation, int[] memberIndices) throws Exception {
        Dimension ensDim = null;
        Gridded1DSet ensSet = null;
        FieldImpl sample = null;
        int numEns = 1;
        if (memberIndices != null) {
            numEns = memberIndices.length;
            float[][] setVals = new float[1][numEns];
            for (int i = 0; i < numEns; ++i) {
                setVals[0][i] = memberIndices[i];
            }
            ensSet = new Gridded1DSet((MathType)GridUtil.ENSEMBLE_TYPE, setVals, numEns);
        }
        int i2 = 0;
        while (true) {
            CachedFlatField oneTime;
            block18: {
                block19: {
                    block17: {
                        if (i2 >= numEns) break block17;
                        int ii = i2;
                        if (memberIndices != null) {
                            ii = memberIndices[i2];
                        }
                        oneTime = this.getFlatField(timeIndex, ii, readLabel);
                        Range[][] rangeArray = sampleRanges;
                        // MONITORENTER : sampleRanges
                        if (sampleRanges[0] != null) break block18;
                        sampleRanges[0] = GridUtil.makeRanges(oneTime.getRanges(true));
                        if (sampleRanges[0] == null || sampleRanges[0].length <= 0) break block18;
                        break block19;
                    }
                    if (sample == null) return;
                    if (sample.isMissing()) return;
                    if (lazyEvaluation) {
                        TreeMap i2 = gridMap;
                        // MONITORENTER : i2
                        gridMap.put(time, sample);
                        // MONITOREXIT : i2
                        return;
                    }
                    Range range = GridUtil.getMinMax(sample)[0];
                    if (Double.isInfinite(range.getMin())) {
                        if (Double.isInfinite(range.getMax())) return;
                    }
                    TreeMap treeMap = gridMap;
                    // MONITORENTER : treeMap
                    gridMap.put(time, sample);
                    // MONITOREXIT : treeMap
                    return;
                }
                for (int rangeIdx = 0; rangeIdx < sampleRanges[0].length; ++rangeIdx) {
                    Range r = sampleRanges[0][rangeIdx];
                    if (r.getMin() != r.getMax() && !Double.isInfinite(r.getMin()) && !Double.isInfinite(r.getMax())) continue;
                    sampleRanges[0] = null;
                    break;
                }
            }
            // MONITOREXIT : rangeArray
            oneTime.setSampleRanges(GridUtil.makeDataRanges(sampleRanges[0]));
            if (numEns == 1) {
                sample = oneTime;
            } else {
                if (sample == null && oneTime != null) {
                    sample = new FieldImpl(new FunctionType(((SetType)ensSet.getType()).getDomain(), oneTime.getType()), ensSet);
                }
                if (oneTime != null) {
                    sample.setSample(i2, (Data)oneTime, false);
                }
            }
            ++i2;
        }
    }

    private RealType makeRealType(String name, Unit unit) throws VisADException {
        return DataUtil.makeRealType(name, unit);
    }

    private Unit getUnit(String uString) {
        Unit r = null;
        try {
            r = DataUtil.parseUnit(uString);
        }
        catch (Exception excp) {
            System.err.println("Unknown unit " + uString);
            r = null;
        }
        return r;
    }

    private Linear1DSet makeLinear1DSet(CoverageCoordAxis1D axis, RealType type) throws VisADException {
        return this.makeLinear1DSet(axis, type, null);
    }

    private Linear1DSet makeLinear1DSet(CoverageCoordAxis1D axis, RealType type, Unit u) throws VisADException {
        return this.makeLinear1DSet(axis, type, u, false);
    }

    private Linear1DSet makeLinear1DSet(CoverageCoordAxis1D axis, RealType type, Unit u, boolean extend) throws VisADException {
        Trace.call1("GeoGridAdapter.makeLinear1DSet");
        double start = axis.getCoordEdgeFirst();
        double end = axis.getCoordEdgeLast();
        if (extend) {
            end += axis.getCoordEdgeLast();
        }
        int numPoints = axis.getNcoords();
        if (extend) {
            ++numPoints;
        }
        Linear1DSet result = new Linear1DSet(type, start, end, numPoints, null, new Unit[]{u}, null, true);
        Trace.call2("GeoGridAdapter.makeLinear1DSet");
        return result;
    }

    private boolean checkLinearity(CoverageCoordAxis axis, boolean isLon) throws VisADException {
        if (!isLon && axis.isRegular()) {
            return true;
        }
        ArithProg progChecker = isLon ? new LonArithProg() : new ArithProg();
        boolean linear = true;
        for (int i = 0; i < axis.getValues().length && linear; ++i) {
            linear = progChecker.accumulate(axis.getValues()[i]);
        }
        return linear;
    }

    private CoordinateSystem makeElevationCS() throws VisADException {
        if (this.ncFile == null) {
            throw new VisADException("Unable to determine center point ");
        }
        Variable lat = this.ncFile.findVariable("sensor_latitude");
        Variable lon = this.ncFile.findVariable("sensor_longitude");
        Variable alt = this.ncFile.findVariable("sensor_altitude");
        if (lat == null || lon == null || alt == null) {
            throw new VisADException("Unable to find center point variables ");
        }
        Real latitude = this.makeReal(lat, RealType.Latitude);
        Real longitude = this.makeReal(lon, RealType.Longitude);
        Real altitude = this.makeReal(alt, RealType.Altitude);
        return new RadarGridCoordinateSystem(latitude.getValue(CommonUnit.degree), longitude.getValue(CommonUnit.degree), altitude.getValue(CommonUnit.meter));
    }

    private Real makeReal(Variable v, RealType rt) throws VisADException {
        double value;
        Unit unit;
        Attribute a = v.findAttribute("units");
        try {
            unit = a != null ? DataUtil.parseUnit(a.getStringValue()) : rt.getDefaultUnit();
            Array array = v.read();
            value = array.getDouble(array.getIndex());
        }
        catch (IOException ioe) {
            throw new VisADException("couldn't read varaible " + v);
        }
        catch (Exception pe) {
            throw new VisADException("couldn't parse unit " + a.getStringValue());
        }
        return new Real(rt, value, unit);
    }

    private CalendarDateTime getBaseTime() throws VisADException {
        Variable timeVar;
        CalendarDateTime time = null;
        if (this.ncFile != null && (timeVar = this.ncFile.findVariable("base_time")) != null) {
            try {
                time = new CalendarDateTime(new DateTime(this.makeReal(timeVar, RealType.Time)));
            }
            catch (VisADException visADException) {
                // empty catch block
            }
        }
        return time;
    }

    private boolean is2D(int sizeZ, Unit zUnit) {
        return sizeZ < 1 || sizeZ == 1 && !GridCoverageAdapter.isZUnitOk(zUnit, null);
    }

    public int indexOf(Object o, List levels) throws VisADException {
        if (o instanceof TwoFacedObject) {
            o = ((TwoFacedObject)o).getId();
        }
        if (o instanceof Integer) {
            return (Integer)o;
        }
        if (o instanceof String) {
            try {
                o = Util.toReal(o.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (o instanceof String) {
            String s = (String)o;
            if (s.startsWith("#")) {
                int index = new Integer(s.substring(1).trim());
                return index;
            }
            o = new Real(new Double(s));
        }
        if (o instanceof Real && levels.size() > 0 && levels.get(0) instanceof Real) {
            Real r = (Real)o;
            for (int i = 0; i < levels.size(); ++i) {
                Real lr = (Real)levels.get(i);
                if (r.getValue(lr.getUnit()) != lr.getValue()) continue;
                return i;
            }
            return -1;
        }
        return levels.indexOf(o);
    }
}

