/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.data.grid;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.StringWriter;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.UUID;
import javax.swing.AbstractAction;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ucar.ma2.Array;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.Group;
import ucar.nc2.NCdumpW;
import ucar.nc2.NetcdfFileWriter;
import ucar.nc2.Variable;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dataset.CoordinateAxis1DTime;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.dods.DODSNetcdfFile;
import ucar.nc2.dt.GridCoordSystem;
import ucar.nc2.dt.GridDatatype;
import ucar.nc2.dt.grid.CFGridWriter2;
import ucar.nc2.dt.grid.GeoGrid;
import ucar.nc2.dt.grid.GridDataset;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateRange;
import ucar.nc2.util.NamedAnything;
import ucar.nc2.util.NamedObject;
import ucar.unidata.data.BadDataException;
import ucar.unidata.data.DataCategory;
import ucar.unidata.data.DataChoice;
import ucar.unidata.data.DataManager;
import ucar.unidata.data.DataOperand;
import ucar.unidata.data.DataSelection;
import ucar.unidata.data.DataSourceDescriptor;
import ucar.unidata.data.DataUtil;
import ucar.unidata.data.DerivedDataChoice;
import ucar.unidata.data.DirectDataChoice;
import ucar.unidata.data.GeoLocationInfo;
import ucar.unidata.data.GeoSelection;
import ucar.unidata.data.grid.GeoGridAdapter;
import ucar.unidata.data.grid.GribVariableRenamer;
import ucar.unidata.data.grid.GridDataSource;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.idv.DisplayControl;
import ucar.unidata.idv.ui.DataTreeDialog;
import ucar.unidata.ui.TextSearcher;
import ucar.unidata.util.CatalogUtil;
import ucar.unidata.util.FileManager;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.IOUtil;
import ucar.unidata.util.JobManager;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.StringUtil;
import ucar.unidata.util.ThreeDSize;
import ucar.unidata.util.Trace;
import ucar.unidata.util.TwoFacedObject;
import ucar.unidata.util.WrapperException;
import ucar.unidata.xml.XmlUtil;
import ucar.visad.Util;
import ucar.visad.data.CalendarDateTime;
import visad.Data;
import visad.DateTime;
import visad.FieldImpl;
import visad.Real;
import visad.VisADException;
import visad.georef.EarthLocationTuple;

public class GeoGridDataSource
extends GridDataSource {
    protected final Object DOMAIN_SET_MUTEX = new Object();
    private static final int SIZE_THRESHOLD = 120;
    private static final String PREFIX_GRIDRELATIVE = "GridRelative_";
    public static final String PREF_VERTICALCS = "Data.VerticalCS";
    public static final String PREF_LARGE_REMOTE_DATA_WARN = "idv.largeremoterequest.warn";
    public static final String PROP_GRIDSIZE = "prop.gridsize";
    public static final String PROP_TIMESIZE = "prop.timesize";
    public static final String PROP_TIMEVAR = "timeVariable";
    protected final Object readLock = new Object();
    static LogUtil.LogCategory log_ = LogUtil.getLogInstance(GeoGridDataSource.class.getName());
    private GridDataset dataset;
    private List myTimes = new ArrayList();
    private List myLevels = new ArrayList();
    private Hashtable gcsVsTime = new Hashtable();
    private Hashtable timeMap = new Hashtable();
    private ProjectionImpl sampleProjection;
    private String dimensionsLabel;
    private String threeDDimensionsLabel = null;
    private String twoDDimensionsLabel = null;
    private int max3DX;
    private int max3DY;
    private int max3DZ;
    private int max3D;
    private static String[] categoryAttributes = new String[]{"GRIB_param_category", "Grib2_Parameter_Category"};
    private boolean reverseTimes = false;
    private JCheckBox reverseTimesCheckbox;
    private CalendarDateRange dateRange;
    private static GribVariableRenamer gribRenamer = new GribVariableRenamer();
    private String oldResolverUrl;
    private static boolean forceSubset = false;
    public static boolean testMode = false;

    public GeoGridDataSource() {
    }

    public GeoGridDataSource(DataSourceDescriptor descriptor, GridDataset gds, String name, String filename) {
        super(descriptor, filename, name, (Hashtable)null);
        this.dataset = gds;
    }

    public GeoGridDataSource(GridDataset gds) {
        this.dataset = gds;
    }

    public GeoGridDataSource(DataSourceDescriptor descriptor, File file, Hashtable properties) throws IOException {
        this(descriptor, file.getPath(), properties);
    }

    public GeoGridDataSource(DataSourceDescriptor descriptor, String filename, Hashtable properties) throws IOException {
        super(descriptor, filename, "Geogrid data source", properties);
    }

    public GeoGridDataSource(DataSourceDescriptor descriptor, List files, Hashtable properties) throws IOException {
        super(descriptor, files, "Geogrid data source", properties);
    }

    public void setDefaultSelectionBounds(Rectangle2D.Float rect) {
        this.getDataSelection().getGeoSelection(true).setLatLonRect(rect);
    }

    @Override
    protected void applyFieldMask(Element root) {
        Element subset;
        Element stride;
        super.applyFieldMask(root);
        GeoSelection geoSubset = this.getDataSelection().getGeoSelection();
        if (geoSubset == null) {
            geoSubset = new GeoSelection();
            this.getDataSelection().setGeoSelection(geoSubset);
        }
        if ((stride = XmlUtil.getElement(root, "stride")) != null) {
            geoSubset.setXStride(XmlUtil.getAttribute((Node)stride, "x", geoSubset.getXStride()));
            geoSubset.setYStride(XmlUtil.getAttribute((Node)stride, "y", geoSubset.getYStride()));
            geoSubset.setZStride(XmlUtil.getAttribute((Node)stride, "z", geoSubset.getZStride()));
        }
        if ((subset = XmlUtil.getElement(root, "subset")) != null) {
            geoSubset.setBoundingBox(new GeoLocationInfo(XmlUtil.getAttribute((Node)subset, "north", 0.0), XmlUtil.getAttribute((Node)subset, "west", 0.0), XmlUtil.getAttribute((Node)subset, "south", 0.0), XmlUtil.getAttribute((Node)subset, "east", 0.0)));
        }
    }

    @Override
    protected boolean canDoFieldMask() {
        return true;
    }

    @Override
    protected void writeFieldMaskFile(Document doc, Element root) {
        GeoSelection geoSubset = this.getDataSelection().getGeoSelection();
        if (geoSubset != null) {
            GeoLocationInfo bbox;
            Element stride = doc.createElement("stride");
            root.appendChild(stride);
            if (geoSubset.getXStride() > 1) {
                stride.setAttribute("x", geoSubset.getXStride() + "");
            }
            if (geoSubset.getYStride() > 1) {
                stride.setAttribute("y", geoSubset.getYStride() + "");
            }
            if (geoSubset.getZStride() > 1) {
                stride.setAttribute("z", geoSubset.getZStride() + "");
            }
            if ((bbox = geoSubset.getBoundingBox()) != null) {
                Element subset = doc.createElement("subset");
                subset.setAttribute("north", bbox.getMaxLat() + "");
                subset.setAttribute("south", bbox.getMinLat() + "");
                subset.setAttribute("west", bbox.getMinLon() + "");
                subset.setAttribute("east", bbox.getMaxLon() + "");
                root.appendChild(subset);
            }
        }
    }

    @Override
    public void initAfterUnpersistence() {
        if (!this.haveSources() && this.oldSourceFromBundles == null && !this.hasPollingInfo()) {
            this.oldSourceFromBundles = this.getName();
        }
        super.initAfterUnpersistence();
        this.resolvePath();
        this.getDataset();
    }

    @Override
    protected JComponent doMakeGeoSubsetPropertiesComponent() {
        JComponent comp = super.doMakeGeoSubsetPropertiesComponent();
        if (this.dataset == null || this.dimensionsLabel == null) {
            return comp;
        }
        JLabel label = new JLabel(this.dimensionsLabel);
        return GuiUtils.topCenter(GuiUtils.left(GuiUtils.inset((Component)label, 5)), comp);
    }

    @Override
    protected JComponent getExtraGeoSelectionComponent() {
        if (this.dimensionsLabel == null) {
            return super.getExtraGeoSelectionComponent();
        }
        String tmp = this.dimensionsLabel;
        int idx = tmp.indexOf("#");
        if (idx > 0) {
            tmp = tmp.substring(0, idx);
        }
        return new JLabel(tmp);
    }

    @Override
    public void addPropertiesTabs(JTabbedPane tabbedPane) {
        super.addPropertiesTabs(tabbedPane);
        if (this.dataset == null) {
            return;
        }
        int height = 300;
        int width = 400;
        JTextArea dumpText = new JTextArea();
        TextSearcher searcher = new TextSearcher(dumpText);
        dumpText.setFont(Font.decode("monospaced"));
        StringWriter bos = new StringWriter();
        try {
            NCdumpW.print(this.dataset.getNetcdfDataset(), "", bos, null);
        }
        catch (IOException ioe) {
            this.logException("Dumping netcdf file", ioe);
        }
        dumpText.setText(bos.toString());
        JScrollPane scroller = GuiUtils.makeScrollPane(dumpText, width, height);
        scroller.setPreferredSize(new java.awt.Dimension(width, height));
        scroller.setMinimumSize(new java.awt.Dimension(width, height));
        tabbedPane.add("Metadata", GuiUtils.inset((Component)GuiUtils.centerBottom(scroller, searcher), 5));
    }

    @Override
    public void initAfterCreation() {
        super.initAfterCreation();
        this.resolvePath();
        this.getDataset();
    }

    @Override
    public List getDataPaths() {
        String resolverUrl = (String)this.getProperty("RESOLVERURL");
        if (resolverUrl != null && resolverUrl.length() > 0) {
            return Misc.newList(resolverUrl);
        }
        return super.getDataPaths();
    }

    @Override
    public void updateState(Object newObject, Hashtable newProperties) {
        this.removeProperty("RESOLVERURL");
        super.updateState(newObject, newProperties);
    }

    @Override
    public void setTmpPaths(List paths) {
        String resolverUrl;
        this.oldResolverUrl = resolverUrl = (String)this.getProperty("RESOLVERURL");
        if (paths != null && paths.size() > 0 && resolverUrl != null && resolverUrl.length() > 0) {
            String firstone;
            Hashtable properties = this.getProperties();
            if (properties == null) {
                properties = new Hashtable();
            }
            if ((firstone = paths.get(0).toString()).indexOf("idv.zidvpath") >= 0) {
                this.getProperties().remove("RESOLVERURL");
            } else {
                String resolvedUrl = CatalogUtil.resolveUrl(firstone, properties);
                if (resolvedUrl != null) {
                    this.setProperty("RESOLVERURL", firstone);
                }
            }
        }
        super.setTmpPaths(paths);
    }

    protected void resolvePath() {
        String resolverUrl = (String)this.getProperty("RESOLVERURL");
        if (resolverUrl != null && resolverUrl.length() > 0) {
            String resolvedUrl;
            Hashtable properties = this.getProperties();
            if (properties == null) {
                properties = new Hashtable();
            }
            if ((resolvedUrl = CatalogUtil.resolveUrl(resolverUrl, properties)) == null) {
                this.setInError(true);
                return;
            }
            this.sources = Misc.newList(resolvedUrl);
        }
    }

    @Override
    protected void sourcesChanged() {
        this.dataset = null;
        this.gcsVsTime = new Hashtable();
        super.sourcesChanged();
    }

    @Override
    public void reloadData() {
        this.myTimes = null;
        this.dataset = null;
        this.gcsVsTime = new Hashtable();
        this.resolvePath();
        this.dataChoices = null;
        this.getDataChoices();
        super.reloadData();
    }

    @Override
    public void doRemove() {
        super.doRemove();
        try {
            if (this.dataset != null) {
                this.dataset.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.dataset = null;
        this.gcsVsTime = null;
    }

    @Override
    public boolean canSaveDataToLocalDisk() {
        if (this.isFileBased()) {
            // empty if block
        }
        return true;
    }

    @Override
    protected String getSaveDataFileLabel() {
        return this.isFileBased() ? "Writing grid file" : this.getSaveDataFileLabel();
    }

    @Override
    protected void makeSaveLocalActions(List actions) {
        String lbl = this.isFileBased() ? "Subset and Write Grid" : "Write Local Grid";
        AbstractAction a = new AbstractAction(lbl){

            @Override
            public void actionPerformed(ActionEvent ae) {
                Misc.run(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            GeoGridDataSource.this.saveDataToLocalDisk();
                        }
                        catch (Exception exc) {
                            GeoGridDataSource.this.logException("Writing data to local disk", exc);
                        }
                    }
                });
            }
        };
        actions.add(a);
    }

    @Override
    protected Object beginWritingDataToLocalDisk(String msg) {
        Object loadId = JobManager.getManager().startLoad(msg, false, false);
        return loadId;
    }

    @Override
    protected List saveDataToLocalDisk(String prefix, Object loadId, boolean changeLinks) throws Exception {
        int i;
        List choices = this.getDataChoices();
        final ArrayList<JCheckBox> checkboxes = new ArrayList<JCheckBox>();
        ArrayList<DataCategory> categories = new ArrayList<DataCategory>();
        Hashtable<DataCategory, ArrayList<JCheckBox>> catMap = new Hashtable<DataCategory, ArrayList<JCheckBox>>();
        Hashtable<String, String> currentDataChoices = new Hashtable<String, String>();
        List displays = this.getIdv().getDisplayControls();
        for (i = 0; i < displays.size(); ++i) {
            List dataChoices = ((DisplayControl)displays.get(i)).getDataChoices();
            if (dataChoices == null) continue;
            ArrayList finalOnes = new ArrayList();
            for (int j = 0; j < dataChoices.size(); ++j) {
                ((DataChoice)dataChoices.get(j)).getFinalDataChoices(finalOnes);
            }
            for (int dcIdx = 0; dcIdx < finalOnes.size(); ++dcIdx) {
                DirectDataChoice ddc;
                DataChoice dc = (DataChoice)finalOnes.get(dcIdx);
                if (!(dc instanceof DirectDataChoice) || (ddc = (DirectDataChoice)dc).getDataSource() != this) continue;
                currentDataChoices.put(ddc.getName(), "");
            }
        }
        if (this.getDefaultSave()) {
            ArrayList<String> varNames = new ArrayList<String>();
            for (int i2 = 0; i2 < this.dataChoices.size(); ++i2) {
                DataChoice dataChoice = (DataChoice)this.dataChoices.get(i2);
                if (!(dataChoice instanceof DirectDataChoice)) continue;
                String name = dataChoice.getName();
                if (name.startsWith(PREFIX_GRIDRELATIVE)) {
                    name = name.substring(PREFIX_GRIDRELATIVE.length());
                }
                if (currentDataChoices.get(name) == null) continue;
                varNames.add(name);
            }
            return currentDataChoices.size() > 0 ? this.writeNc(prefix, changeLinks, varNames) : null;
        }
        for (i = 0; i < this.dataChoices.size(); ++i) {
            DataChoice dataChoice = (DataChoice)this.dataChoices.get(i);
            if (!(dataChoice instanceof DirectDataChoice)) continue;
            String label = dataChoice.getDescription();
            JCheckBox cbx = new JCheckBox(label, currentDataChoices.get(dataChoice.getName()) != null);
            ThreeDSize size = (ThreeDSize)dataChoice.getProperty(PROP_GRIDSIZE);
            cbx.setToolTipText(dataChoice.getName());
            checkboxes.add(cbx);
            DataCategory dc = dataChoice.getDisplayCategory();
            ArrayList<JCheckBox> comps = (ArrayList<JCheckBox>)catMap.get(dc);
            if (comps == null) {
                comps = new ArrayList<JCheckBox>();
                catMap.put(dc, comps);
                categories.add(dc);
            }
            comps.add(cbx);
            comps.add((JCheckBox)GuiUtils.filler());
            if (size != null) {
                JLabel sizeLabel = GuiUtils.rLabel(size.getSize() + "  ");
                sizeLabel.setToolTipText(size.getLabel());
                comps.add((JCheckBox)((Object)sizeLabel));
                continue;
            }
            comps.add((JCheckBox)((Object)new JLabel("")));
        }
        final JCheckBox allCbx = new JCheckBox("Select All");
        allCbx.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                for (JCheckBox cbx : checkboxes) {
                    cbx.setSelected(allCbx.isSelected());
                }
            }
        });
        ArrayList catComps = new ArrayList();
        JTabbedPane tab = new JTabbedPane(2);
        for (int i3 = 0; i3 < categories.size(); ++i3) {
            List comps = (List)catMap.get(categories.get(i3));
            JPanel labelPanel = new JPanel(new BorderLayout());
            JPanel leftLabelPanel = new JPanel(new FlowLayout(0));
            leftLabelPanel.add(new JLabel("Field Name"));
            JPanel rightLabelPanel = new JPanel(new FlowLayout(2));
            rightLabelPanel.add(new JLabel("Grid Size (Points)"));
            labelPanel.add((Component)leftLabelPanel, "West");
            labelPanel.add((Component)rightLabelPanel, "East");
            JPanel innerPanel = GuiUtils.doLayout(comps, 3, GuiUtils.WT_NYN, GuiUtils.WT_N);
            JScrollPane sp = new JScrollPane(GuiUtils.top(innerPanel));
            sp.setPreferredSize(new java.awt.Dimension(500, 400));
            JPanel spAndLabels = new JPanel(new BorderLayout());
            spAndLabels.add((Component)labelPanel, "North");
            spAndLabels.add((Component)sp, "Center");
            JPanel inner = GuiUtils.inset((Component)GuiUtils.center(spAndLabels), 5);
            tab.addTab(categories.get(i3).toString(), inner);
        }
        JComponent contents = tab;
        contents = GuiUtils.topCenter(GuiUtils.inset((Component)GuiUtils.leftRight(new JLabel("Select the fields to download"), allCbx), 5), contents);
        JLabel label = new JLabel(GeoGridDataSource.getNameForDataSource(this, 50, true));
        contents = GuiUtils.topCenter(label, contents);
        if (!GuiUtils.showOkCancelDialog(null, "", contents = GuiUtils.inset((Component)contents, 5), null)) {
            return null;
        }
        ArrayList<String> varNames = new ArrayList<String>();
        for (int i4 = 0; i4 < this.dataChoices.size(); ++i4) {
            JCheckBox cbx;
            DataChoice dataChoice = (DataChoice)this.dataChoices.get(i4);
            if (!(dataChoice instanceof DirectDataChoice) || !(cbx = (JCheckBox)checkboxes.get(i4)).isSelected()) continue;
            String name = dataChoice.getName();
            if (name.startsWith(PREFIX_GRIDRELATIVE)) {
                name = name.substring(PREFIX_GRIDRELATIVE.length());
            }
            varNames.add(name);
        }
        if (varNames.size() == 0) {
            return null;
        }
        return this.writeNc(prefix, changeLinks, varNames);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List writeNc(String prefix, boolean changeLinks, List varNames) {
        LatLonRect llr = null;
        int hStride = 1;
        int zStride = 1;
        int timeStride = 1;
        GeoSelection geoSubset = this.getDataSelection().getGeoSelection();
        boolean includeLatLon = false;
        if (geoSubset != null) {
            if (geoSubset.getBoundingBox() != null) {
                llr = geoSubset.getBoundingBox().getLatLonRect();
            }
            if (geoSubset.hasXStride()) {
                hStride = geoSubset.getXStride();
            }
            if (geoSubset.hasZStride()) {
                zStride = geoSubset.getZStride();
            }
        }
        if (this.getProperties().get("timestride") != null) {
            Object tstrike = this.getProperties().get("timestride");
            timeStride = (Integer)tstrike;
        }
        if (this.dateRange == null) {
            List times = this.getTimesFromDataSelection(this.getDataSelection(), (DataChoice)this.getDataChoices().get(0));
            try {
                if (this.getDataSelection() != null && !times.isEmpty()) {
                    CalendarDateTime t0 = new CalendarDateTime((DateTime)times.get(0));
                    CalendarDate dt0 = t0.getCalendarDate();
                    CalendarDateTime t1 = new CalendarDateTime((DateTime)times.get(times.size() - 1));
                    CalendarDate dt1 = t1.getCalendarDate();
                    this.dateRange = CalendarDateRange.of(dt0, dt1);
                }
            }
            catch (Exception t0) {
                // empty catch block
            }
        }
        String path = prefix;
        CFGridWriter2 writer = new CFGridWriter2();
        NetcdfFileWriter ncFileWriter = null;
        try {
            ncFileWriter = NetcdfFileWriter.createNew(NetcdfFileWriter.Version.netcdf3, path);
            ncFileWriter.setLargeFile(true);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Object loadId = JobManager.getManager().startLoad("Copying data", true, true);
        try {
            CFGridWriter2.writeFile(this.dataset, varNames, llr, null, hStride, null, this.dateRange, timeStride, includeLatLon, ncFileWriter);
        }
        catch (Exception exc) {
            this.logException("Error writing local netcdf file.\nData:" + this.getFilePath() + "\nVariables:" + varNames, exc);
            List list = null;
            return list;
        }
        finally {
            JobManager.getManager().stopLoad(loadId);
        }
        if (geoSubset != null && changeLinks) {
            geoSubset.clearStride();
            geoSubset.setBoundingBox(null);
            if (this.geoSelectionPanel != null) {
                this.geoSelectionPanel.initWith(this.doMakeGeoSelectionPanel());
            }
        }
        List newFiles = Misc.newList(path);
        if (changeLinks) {
            this.getProperties().remove("RESOLVERURL");
            this.setNewFiles(newFiles);
        }
        return newFiles;
    }

    public boolean isLocalFile() {
        return new File(this.getFilePath()).exists();
    }

    @Override
    public void setNewFiles(List files) {
        this.getProperties().remove("RESOLVERURL");
        super.setNewFiles(files);
    }

    @Override
    protected String getLocalDirectory(String label, String prefix) {
        this.changeDataPathsCbx.setToolTipText("Should this data source also be changed");
        return FileManager.getWriteFile(FileManager.FILTER_NETCDF, null, (JComponent)GuiUtils.top(this.changeDataPathsCbx));
    }

    @Override
    public String getFullDescription() {
        String desc = super.getFullDescription();
        StringBuffer sb2d = null;
        StringBuffer sb3d = null;
        List dataChoices = this.getDataChoices();
        for (int i = 0; i < dataChoices.size(); ++i) {
            int times;
            DataChoice dataChoice = (DataChoice)dataChoices.get(i);
            if (!(dataChoice instanceof DirectDataChoice)) continue;
            ThreeDSize size = (ThreeDSize)dataChoice.getProperty(PROP_GRIDSIZE);
            Integer timeSize = (Integer)dataChoice.getProperty(PROP_TIMESIZE);
            if (size == null) continue;
            long total = size.getSizeY() * size.getSizeX();
            StringBuffer theSb = null;
            String sizeEntry = null;
            if (size.getSizeZ() > 1) {
                if (sb3d == null) {
                    sb3d = new StringBuffer();
                }
                total *= (long)size.getSizeZ();
                theSb = sb3d;
                sizeEntry = size.getSizeX() + "x" + size.getSizeY() + "x" + size.getSizeZ();
            } else {
                if (sb2d == null) {
                    sb2d = new StringBuffer();
                }
                theSb = sb2d;
                sizeEntry = size.getSizeX() + "x" + size.getSizeY();
            }
            theSb.append("<tr><td>" + dataChoice.getName() + "</td><td>" + dataChoice.getDescription() + "</td><td>" + sizeEntry + "</td><td>");
            if (timeSize != null && (times = timeSize.intValue()) > 0) {
                total *= (long)timeSize.intValue();
                theSb.append("" + timeSize);
            }
            theSb.append("</td>");
            theSb.append("<td>" + total + "</td></tr>");
        }
        StringBuffer sb = null;
        if (sb2d != null || sb3d != null) {
            sb = new StringBuffer(desc);
            String resolverUrl = (String)this.getProperty("RESOLVERURL");
            if (resolverUrl != null) {
                sb.append("<p>");
                sb.append("Resolver URL:" + resolverUrl);
            }
            sb.append("\n<p><table><tr><td><b>Field</b></td><td><b>Description</b></td><td><b>Dimensions</b></td><td><b>#Times</b></td><td><b>#Points</b></td></tr>\n");
        }
        if (sb2d != null) {
            sb.append(sb2d);
        }
        if (sb3d != null) {
            sb.append(sb3d);
        }
        if (sb != null) {
            sb.append("</table>\n");
        }
        if (sb != null && this.myLevels != null && this.myLevels.size() > 0) {
            sb.append("<h2>Levels</h2>");
            for (Object o : this.myLevels) {
                sb.append("" + o);
                sb.append("<br>");
            }
        }
        if (sb == null) {
            return desc;
        }
        return sb.toString();
    }

    @Override
    public void resetTmpState() {
        super.resetTmpState();
        if (this.oldResolverUrl != null) {
            this.setProperty("RESOLVERURL", this.oldResolverUrl);
        }
    }

    protected GridDataset doMakeDataSet() {
        this.checkForInitAfterUnPersistence();
        String file = this.getFilePath();
        if (file == null && this.haveBeenUnPersisted) {
            file = this.getName();
        }
        if (file == null) {
            return null;
        }
        if (this.sources == null) {
            this.sources = new ArrayList();
            this.sources.add(file);
        }
        if (this.sources.size() > 1) {
            String timeName = this.getProperty(PROP_TIMEVAR, "time");
            StringBuffer sb = new StringBuffer();
            sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            sb.append("<netcdf xmlns=\"https://www.unidata.ucar.edu/namespaces/netcdf/ncml-2.2\">\n");
            sb.append("<aggregation type=\"joinExisting\" dimName=\"" + timeName + "\" timeUnitsChange=\"true\">\n");
            for (int i = 0; i < this.sources.size(); ++i) {
                String s = this.sources.get(i).toString();
                try {
                    if (s.startsWith("http") && s.endsWith("entry.das")) {
                        s = DODSNetcdfFile.canonicalURL(s);
                        sb.append(XmlUtil.tag("netcdf", XmlUtil.attrs("location", s, "enhance", "true"), ""));
                        continue;
                    }
                    sb.append(XmlUtil.tag("netcdf", XmlUtil.attrs("location", IOUtil.getURL(s, this.getClass()).toString(), "enhance", "true"), ""));
                    continue;
                }
                catch (IOException ioe) {
                    this.setInError(true);
                    throw new WrapperException("Grid data source failed aggregating resource: " + s, ioe);
                }
            }
            sb.append("</aggregation>\n</netcdf>\n");
            file = this.getDataContext().getObjectStore().getUniqueTmpFile("multigrid_" + UUID.randomUUID().toString(), ".ncml");
            try {
                IOUtil.writeFile(file, sb.toString());
            }
            catch (IOException ioe) {
                this.logException("Unable to write file: " + file, ioe);
                return null;
            }
            log_.debug("" + sb);
        }
        try {
            file = this.convertSourceFile(file);
            Trace.msg("GeoGridDataSource: opening file " + file);
            if (file.startsWith("http") && file.endsWith("entry.das")) {
                file = DODSNetcdfFile.canonicalURL(file);
            } else if (file.startsWith("http") && file.contains("/dods/")) {
                file = DODSNetcdfFile.canonicalURL(file);
            } else if (file.startsWith("dods:") && file.endsWith("ncml")) {
                file = file.replace("dods:", "https:");
            }
            if (file.contains(":443")) {
                file = file.replace(":443", "");
            }
            GridDataset gds = GridDataset.open(file);
            return gds;
        }
        catch (FileNotFoundException fnfe) {
            this.setInError(true);
            LogUtil.consoleMessage("Original error:\n" + fnfe.toString() + "\n" + LogUtil.getStackTrace(fnfe));
            throw new BadDataException("Unable to open grid:\n" + file);
        }
        catch (Exception exc) {
            this.setInError(true);
            throw new WrapperException("Grid data source failed making data set: " + file, exc);
        }
    }

    public GridDataset getDataset() {
        if (this.dataset == null) {
            Trace.call1("GeoGridDataSource.getDataSet", " name = " + this.sources);
            this.dataset = this.doMakeDataSet();
            Trace.call2("GeoGridDataSource.getDataSet");
        }
        return this.dataset;
    }

    @Override
    protected ProjectionImpl getSampleDataProjection() {
        return this.sampleProjection;
    }

    @Override
    protected void doMakeDataChoices() {
        GridDataset myDataset = this.getDataset();
        if (myDataset == null) {
            return;
        }
        this.max3DX = -1;
        this.max3DY = -1;
        this.max3DZ = -1;
        this.max3D = -1;
        boolean gridRelativeWind = false;
        NetcdfDataset ncFile = myDataset.getNetcdfDataset();
        Variable windFlag = ncFile.findVariable("ResCompFlag");
        if (windFlag != null) {
            try {
                Array array = windFlag.read();
                gridRelativeWind = (array.getInt(array.getIndex()) & 8) != 0;
            }
            catch (IOException ioe) {
                LogUtil.printException(log_, "Couldn't read variable ", ioe);
            }
        }
        Iterator<GridDatatype> iter = myDataset.getGrids().iterator();
        SortedSet uniqueTimes = Collections.synchronizedSortedSet(new TreeSet());
        while (iter.hasNext()) {
            CoordinateAxis1DTime trAxis;
            GridCoordSystem gcs;
            CoordinateAxis1D zaxis;
            GeoGrid cfield = (GeoGrid)iter.next();
            if (this.sampleProjection == null) {
                this.sampleProjection = cfield.getProjection();
            }
            if (!this.isZAxisOk(zaxis = (gcs = cfield.getCoordinateSystem()).getVerticalAxis())) continue;
            CoordinateAxis1DTime tAxis = gcs.getTimeAxis1D();
            if (tAxis == null && (trAxis = gcs.getRunTimeAxis()) != null) {
                tAxis = trAxis;
            }
            List geoTimes = this.getGeoGridTimes(tAxis);
            uniqueTimes.addAll(geoTimes);
        }
        this.myTimes = !uniqueTimes.isEmpty() ? new ArrayList(uniqueTimes) : new ArrayList();
        iter = myDataset.getGrids().iterator();
        Hashtable timeToIndex = new Hashtable();
        for (int i = 0; i < this.myTimes.size(); ++i) {
            timeToIndex.put(this.myTimes.get(i), new Integer(i));
        }
        int cnt = 0;
        while (iter.hasNext()) {
            GeoGrid cfield = (GeoGrid)iter.next();
            DataChoice choice = this.makeDataChoiceFromGeoGrid(cfield, this.myTimes, timeToIndex);
            if (choice == null) continue;
            ++cnt;
            if (gridRelativeWind && (choice.getDescription().indexOf("u-component") >= 0 || choice.getDescription().indexOf("v-component") >= 0)) {
                choice.setName(PREFIX_GRIDRELATIVE + choice.getName());
            }
            this.addDataChoice(choice);
        }
        if (cnt == 0) {
            if (LogUtil.getInteractiveMode() && GuiUtils.showOkCancelDialog(null, "No Gridded Data", GuiUtils.inset((Component)new JLabel("<html>No gridded data found for:<br><br>&nbsp;&nbsp;<i>" + this + "</i><br><br>Do you want to try to load this as another data type?</html>"), 5), null)) {
                this.getIdv().getDataManager().createDataSourceAndAskForType(this.getFilePath(), this.getProperties());
                this.setInError(true, false, "");
            } else {
                this.setInError(true, false, "");
            }
            return;
        }
        if (this.max3D > 0) {
            this.threeDDimensionsLabel = "Max grid size: x: " + this.max3DX + " y: " + this.max3DY + " z: " + this.max3DZ + "   #points: " + this.max3DX * this.max3DY * this.max3DZ;
        }
        this.dimensionsLabel = this.threeDDimensionsLabel != null ? this.threeDDimensionsLabel : this.twoDDimensionsLabel;
    }

    @Override
    protected Data getDataInner(DataChoice dataChoice, DataCategory category, DataSelection givenDataSelection, Hashtable requestProperties) throws VisADException, RemoteException {
        GeoLocationInfo gInfo;
        boolean isPR = givenDataSelection.getProperty("Use_Progressive_Resolution", false);
        boolean fromBundle = this.getIdv().getStateManager().getProperty("idv.loadingxml", false);
        if (isPR && fromBundle && (gInfo = givenDataSelection.getGeoSelection().getBoundingBox()) != null) {
            givenDataSelection.getGeoSelection().setBoundingBox(gInfo);
        }
        FieldImpl data = this.makeFieldImpl(dataChoice, givenDataSelection, requestProperties);
        return data;
    }

    public List<String> listParameters() {
        ArrayList<String> params = new ArrayList<String>();
        for (DataChoice dc : this.getDataChoices()) {
            params.add(dc.getName());
        }
        return params;
    }

    public Data getData(String parameter) throws VisADException, RemoteException {
        DataChoice dataChoice = this.findDataChoice(parameter);
        if (dataChoice == null) {
            return null;
        }
        DataSelection dataSelection = new DataSelection();
        FieldImpl data = this.makeFieldImpl(dataChoice, dataSelection, new Hashtable());
        return data;
    }

    @Override
    protected List doMakeDateTimes() {
        return this.myTimes;
    }

    @Override
    public List getAllLevels(DataChoice dataChoice, DataSelection dataSelection) {
        try {
            long t2;
            long t1;
            dataSelection = DataSelection.merge(dataSelection, this.getDataSelection());
            Object fromLevel = dataSelection.getFromLevel();
            Object toLevel = dataSelection.getToLevel();
            int fromLevelIndex = -1;
            int toLevelIndex = -1;
            if (fromLevel != null && toLevel != null) {
                t1 = System.currentTimeMillis();
                List allLevels = this.getAllLevels(dataChoice, new DataSelection(1));
                t2 = System.currentTimeMillis();
                fromLevelIndex = this.indexOf(fromLevel, allLevels);
                toLevelIndex = this.indexOf(toLevel, allLevels);
            }
            t1 = System.currentTimeMillis();
            GeoGridAdapter geoGridAdapter = this.makeGeoGridAdapter(dataChoice, dataSelection, null, fromLevelIndex, toLevelIndex, true);
            t2 = System.currentTimeMillis();
            if (geoGridAdapter != null) {
                List tmpLevels;
                this.myLevels = tmpLevels = geoGridAdapter.getLevels();
                return tmpLevels;
            }
            return this.myLevels;
        }
        catch (VisADException vae) {
            throw new WrapperException(vae);
        }
        catch (HugeSizeException hse) {
            return null;
        }
    }

    @Override
    public boolean canDoGeoSelection() {
        return true;
    }

    @Override
    public boolean canCacheDataToDisk() {
        return true;
    }

    private GeoGridAdapter makeGeoGridAdapter(DataChoice dataChoice, DataSelection givenDataSelection, Hashtable requestProperties, int fromLevelIndex, int toLevelIndex, boolean forMetaData) throws VisADException, HugeSizeException {
        boolean matchDisplayRegion;
        GridDataset myDataset;
        boolean readingFullGrid = !forMetaData;
        int numLevels = -1;
        if (fromLevelIndex >= 0 && toLevelIndex >= 0) {
            numLevels = Math.abs(toLevelIndex - fromLevelIndex) + 1;
        }
        if ((myDataset = this.getDataset()) == null) {
            return null;
        }
        Object extraCacheKey = null;
        GeoGrid geoGrid = this.findGridForDataChoice(myDataset, dataChoice);
        String paramName = dataChoice.getStringId();
        if (geoGrid == null) {
            return null;
        }
        Dimension ensDim = geoGrid.getEnsembleDimension();
        GeoSelection geoSelection = givenDataSelection != null ? givenDataSelection.getGeoSelection() : null;
        boolean needVolume = geoGrid.getCoordinateSystem().getVerticalTransform() != null && requestProperties != null && requestProperties.get(DerivedDataChoice.PROP_FROMDERIVED) != null;
        StringBuffer filename = new StringBuffer("grid_" + paramName);
        String regionOption = null;
        regionOption = givenDataSelection.getProperty("Region_Selection_Option", "Use_Default_Area");
        boolean isProgressiveResolution = givenDataSelection.getProperty("Use_Progressive_Resolution", false);
        boolean bl = matchDisplayRegion = geoSelection != null ? geoSelection.getUseViewBounds() : false;
        if (!isProgressiveResolution && dataChoice.getDataSelection() != null) {
            isProgressiveResolution = dataChoice.getDataSelection().getProperty("Use_Progressive_Resolution", false);
        }
        try {
            int yStride;
            Range ensRange = this.makeRange(ensDim, null, 1);
            Object timeRange = null;
            Range levelRange = null;
            Range xRange = null;
            Range yRange = null;
            if (fromLevelIndex >= 0 && toLevelIndex >= 0 && !needVolume) {
                levelRange = new Range(fromLevelIndex, toLevelIndex);
                filename.append("_r_" + fromLevelIndex + "_" + toLevelIndex);
            }
            if (isProgressiveResolution && geoSelection != null && !geoSelection.hasStride()) {
                Rectangle2D rect;
                int xLength = geoGrid.getXDimension().getLength();
                int yLength = geoGrid.getYDimension().getLength();
                if (geoSelection.getLatLonRect() != null) {
                    LatLonRect bbox;
                    LatLonRect gsbox = geoSelection.getLatLonRect();
                    LatLonRect grbox = geoGrid.getCoordinateSystem().getLatLonBoundingBox();
                    if (!matchDisplayRegion) {
                        bbox = gsbox;
                    } else {
                        bbox = grbox.intersect(gsbox);
                        if (bbox == null) {
                            bbox = grbox;
                        }
                    }
                    List<Range> yx_ranges = geoGrid.getCoordinateSystem().getRangesFromLatLonRect(bbox);
                    yRange = this.makeRange(geoGrid.getYDimension(), yx_ranges.get(0), 1);
                    xRange = this.makeRange(geoGrid.getXDimension(), yx_ranges.get(1), 1);
                    yLength = yRange.length();
                    xLength = xRange.length();
                }
                if ((rect = geoSelection.getScreenBound()) == null) {
                    rect = dataChoice.getDataSelection().getGeoSelection().getScreenBound();
                }
                int xstride = this.calculateStrideFactor(xLength, (int)rect.getWidth());
                int ystride = this.calculateStrideFactor(yLength, (int)rect.getHeight());
                if (xstride == 1) {
                    xstride = 0;
                }
                if (ystride == 1) {
                    ystride = 0;
                }
                geoSelection.setXStride(xstride);
                geoSelection.setYStride(ystride);
            }
            int xStride = geoSelection != null ? geoSelection.getXStride() : 1;
            int n = yStride = geoSelection != null ? geoSelection.getYStride() : 1;
            if (xStride < 1) {
                xStride = 1;
            }
            if (yStride < 1) {
                yStride = 1;
            }
            String magValue = DataUtil.makeSamplingLabel(xStride, yStride, "grid point");
            dataChoice.setProperty("MAG", magValue);
            if (geoSelection != null && (geoSelection.hasSpatialSubset() || geoSelection.getHasNonOneStride())) {
                extraCacheKey = geoSelection;
                if (levelRange != null) {
                    extraCacheKey = Misc.newList(extraCacheKey, levelRange);
                }
                filename.append("_x_" + geoSelection.getXStrideToUse());
                filename.append("_y_" + geoSelection.getYStrideToUse());
                filename.append("_z_" + geoSelection.getZStrideToUse());
                if (geoSelection.getLatLonRect() != null) {
                    LatLonRect bbox;
                    LatLonRect gsbox = geoSelection.getLatLonRect();
                    LatLonRect grbox = geoGrid.getCoordinateSystem().getLatLonBoundingBox();
                    if (!matchDisplayRegion) {
                        bbox = gsbox;
                    } else {
                        bbox = grbox.intersect(gsbox);
                        if (bbox == null) {
                            bbox = grbox;
                        }
                    }
                    filename.append("_rect_" + this.cleanBBoxName(bbox));
                    List<Range> yx_ranges = geoGrid.getCoordinateSystem().getRangesFromLatLonRect(bbox);
                    yRange = this.makeRange(geoGrid.getYDimension(), yx_ranges.get(0), geoSelection.getYStrideToUse());
                    xRange = this.makeRange(geoGrid.getXDimension(), yx_ranges.get(1), geoSelection.getYStrideToUse());
                } else if (geoSelection.getHasNonOneStride()) {
                    yRange = this.makeRange(geoGrid.getYDimension(), yRange, geoSelection.getYStrideToUse());
                    xRange = this.makeRange(geoGrid.getXDimension(), xRange, geoSelection.getYStrideToUse());
                }
                if (levelRange != null && geoSelection.hasZStride() && geoSelection.getZStrideToUse() > 1) {
                    levelRange = new Range(fromLevelIndex, toLevelIndex, geoSelection.getZStrideToUse());
                }
                geoGrid = (GeoGrid)geoGrid.makeSubset(null, ensRange, null, levelRange, yRange, xRange);
            } else if (levelRange != null) {
                extraCacheKey = levelRange;
                geoGrid = (GeoGrid)geoGrid.makeSubset(null, ensRange, null, levelRange, yRange, xRange);
            }
        }
        catch (InvalidRangeException ire) {
            throw new IllegalArgumentException("Invalid range:" + ire);
        }
        boolean warn = this.getIdv().getStore().get(PREF_LARGE_REMOTE_DATA_WARN, false);
        boolean fromBundle = this.haveBeenUnPersisted;
        if (readingFullGrid && !fromBundle && warn && this.getIdv().getInteractiveMode() && !this.isLocalFile()) {
            long total = 1L;
            List<Dimension> dims = geoGrid.getDimensions();
            List<Integer> geoDims = Arrays.asList(geoGrid.getXDimensionIndex(), geoGrid.getYDimensionIndex(), geoGrid.getZDimensionIndex());
            for (int d = 0; d < geoDims.size(); ++d) {
                if (geoDims.get(d) == -1) continue;
                Dimension dim = dims.get(geoDims.get(d));
                total *= (long)dim.getLength();
            }
            if (geoGrid.getTimeDimension() != null) {
                try {
                    total *= (long)givenDataSelection.getTimes().size();
                }
                catch (NullPointerException npe) {
                    total *= (long)geoGrid.getTimes().size();
                }
            }
            double mb = total * (long)geoGrid.getDataType().getSize();
            if ((mb /= 1048576.0) > 120.0) {
                JCheckBox askCbx = new JCheckBox("Don't show this again", !warn);
                JPanel msgContents = GuiUtils.vbox((Component)GuiUtils.inset((Component)new JLabel("<html>You are about to load " + (int)mb + " MB of data.<br>Are you sure you want to do this?<p><hr>" + "<br>Consider subsetting for better performance!<p></html>"), 5), GuiUtils.inset((Component)askCbx, new Insets(5, 0, 0, 0)));
                if (askCbx.isSelected()) {
                    this.getIdv().getStore().put(PREF_LARGE_REMOTE_DATA_WARN, false);
                }
                if (!GuiUtils.askOkCancel("Large Remote Data Request Warning", msgContents)) {
                    throw new HugeSizeException();
                }
            }
        }
        GeoGridAdapter adapter = new GeoGridAdapter(this, geoGrid, dataChoice.getName(), this.dataset.getNetcdfDataset(), extraCacheKey);
        adapter.cacheFile = filename.toString();
        return adapter;
    }

    public int calculateStrideFactor(int dataPoints, int displayPoints) {
        if (dataPoints <= displayPoints) {
            return 0;
        }
        int factor = (int)Math.floor(1.0 * (double)dataPoints / (1.0 * (double)displayPoints) + 0.8);
        return factor;
    }

    private Range makeRange(Dimension dim, Range range, int stride) throws InvalidRangeException {
        if (dim == null) {
            return null;
        }
        range = range == null ? new Range(0, dim.getLength() - 1, stride) : new Range(range.first(), range.last(), stride);
        return range;
    }

    private String cleanBBoxName(LatLonRect bbox) {
        String name = Util.cleanName(bbox.toString());
        name = name.replaceAll(":", "_");
        name = name.replaceAll("\\+", "_");
        return name;
    }

    private int indexOf(Object o, List levels) throws VisADException {
        if (o instanceof TwoFacedObject) {
            o = ((TwoFacedObject)o).getId();
        }
        if (o instanceof Integer) {
            return (Integer)o;
        }
        if (o instanceof String) {
            try {
                o = Util.toReal(o.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (o instanceof String) {
            String s = (String)o;
            if (s.startsWith("#")) {
                int index = new Integer(s.substring(1).trim());
                return index;
            }
            o = new Real(new Double(s));
        }
        if (o instanceof Real && levels.size() > 0 && levels.get(0) instanceof Real) {
            Real r = (Real)o;
            for (int i = 0; i < levels.size(); ++i) {
                Real lr = (Real)levels.get(i);
                if (r.getValue(lr.getUnit()) != lr.getValue()) continue;
                return i;
            }
            return -1;
        }
        return levels.indexOf(o);
    }

    private FieldImpl makeFieldImpl(DataChoice dataChoice, DataSelection givenDataSelection, Hashtable requestProperties) throws VisADException, RemoteException {
        long millis = System.currentTimeMillis();
        List allLevels = this.getAllLevels(dataChoice, new DataSelection(1));
        Trace.call1("GeoGridDataSource.makeField");
        Object fromLevel = givenDataSelection.getFromLevel();
        Object toLevel = givenDataSelection.getToLevel();
        int fromLevelIndex = -1;
        int toLevelIndex = -1;
        if (fromLevel != null && toLevel != null) {
            fromLevelIndex = this.indexOf(fromLevel, allLevels);
            toLevelIndex = this.indexOf(toLevel, allLevels);
            if (toLevelIndex < 0 || fromLevelIndex < 0) {
                System.err.println("Did not find level indices:   fromLevel:" + fromLevel + " index:" + fromLevelIndex + " toLevel:" + toLevel + " index:" + toLevelIndex + "\nLevels:" + allLevels);
                if (allLevels != null && !allLevels.isEmpty()) {
                    System.err.println("fromLevel is a " + fromLevel.getClass().getName() + ", toLevel is a " + toLevel.getClass().getName());
                    System.err.println("levels are " + allLevels.get(0).getClass().getName());
                }
            }
        }
        long starttime = System.currentTimeMillis();
        FieldImpl fieldImpl = null;
        Trace.call1("GeoGridDataSource.make GeoGridAdapter");
        GeoGridAdapter adapter = null;
        try {
            adapter = this.makeGeoGridAdapter(dataChoice, givenDataSelection, requestProperties, fromLevelIndex, toLevelIndex, false);
        }
        catch (HugeSizeException hse) {
            return null;
        }
        if (adapter == null) {
            throw new BadDataException("Could not find field:" + dataChoice.getStringId());
        }
        Trace.call2("GeoGridDataSource.make GeoGridAdapter");
        GeoGrid geoGrid = adapter.getGeoGrid();
        String paramName = dataChoice.getStringId();
        Trace.call1("GeoGridDataSource.make times");
        List times = this.getTimesFromDataSelection(givenDataSelection, dataChoice);
        List members = this.getEnsembleSelection();
        if (members == null) {
            members = (List)givenDataSelection.getProperty("prop.gridmembers");
        }
        int[] membersIndices = null;
        if (members != null) {
            int msize = members.size();
            membersIndices = new int[msize];
            for (int i = 0; i < msize; ++i) {
                membersIndices[i] = (Integer)members.get(i);
            }
        }
        int[] timeIndices = null;
        List allTimes = null;
        if (times != null) {
            timeIndices = new int[times.size()];
            allTimes = geoGrid.getCoordinateSystem().getTimeAxis1D() == null && geoGrid.getCoordinateSystem().getRunTimeAxis() != null ? this.getGeoGridTimes(geoGrid.getCoordinateSystem().getRunTimeAxis()) : this.getGeoGridTimes(geoGrid.getCoordinateSystem().getTimeAxis1D());
            int numTimes = allTimes.size();
            if (GeoGridDataSource.holdsIndices(times)) {
                for (int i = 0; i < times.size(); ++i) {
                    int index = (Integer)times.get(i);
                    if (this.getReverseTimes()) {
                        index = numTimes - index - 1;
                    }
                    timeIndices[i] = index;
                }
            } else {
                CoordinateAxis1DTime cca = geoGrid.getCoordinateSystem().getTimeAxis1D();
                for (int i = 0; i < times.size(); ++i) {
                    int index;
                    if (this.getReverseTimes()) {
                        index = allTimes.indexOf(times.get(i));
                        index = index < 0 ? numTimes - 1 : numTimes - index - 1;
                        DateTime dateTime = (DateTime)allTimes.get(index);
                        index = this.getTimeIndexWithBounds(dateTime, allTimes, cca);
                    } else {
                        index = this.getTimeIndexWithBounds((DateTime)times.get(i), allTimes, cca);
                    }
                    timeIndices[i] = index;
                }
            }
        }
        Trace.call2("GeoGridDataSource.make times");
        CoordinateAxis1DTime dd = geoGrid.getCoordinateSystem().getRunTimeAxis();
        CoordinateAxis1DTime dt = geoGrid.getCoordinateSystem().getTimeAxis1D();
        StringBuilder buf = new StringBuilder();
        if (dd != null && dt != null) {
            for (int i = 0; i < timeIndices.length; ++i) {
                CalendarDate cd = null;
                int dsize = dd.getCalendarDates().size();
                cd = dsize == 1 ? dd.getCalendarDate(0) : dd.getCalendarDate(timeIndices[i]);
                CalendarDate ct = dt.getCalendarDate(timeIndices[i]);
                long diff = ct.getDifferenceInMsecs(cd);
                float fh = (float)diff / 3600000.0f;
                buf.append(fh + ",");
            }
        } else if (dt != null) {
            CalendarDate ct0 = dt.getCalendarDate(0);
            if (allTimes.size() >= timeIndices.length) {
                for (int i = 0; i < timeIndices.length; ++i) {
                    CalendarDate ct = dt.getCalendarDate(timeIndices[i]);
                    long diff = ct.getDifferenceInMsecs(ct0);
                    float fh = (float)diff / 3600000.0f;
                    buf.append(fh + ",");
                }
            }
        }
        if (buf.length() > 1) {
            buf.deleteCharAt(buf.length() - 1);
            dataChoice.setProperty("RUNTIME", buf.toString());
        }
        Trace.call1("GeoGridDataSource.getSequence");
        Object loadId = JobManager.getManager().startLoad("GeoGrid");
        if (adapter != null) {
            fieldImpl = membersIndices != null && membersIndices.length > 0 ? adapter.getSequence(timeIndices, membersIndices, loadId) : adapter.getSequence(timeIndices, loadId);
        }
        if (fieldImpl == null) {
            // empty if block
        }
        boolean useDriverTime = false;
        if (givenDataSelection != null) {
            useDriverTime = givenDataSelection.getProperty("Use_Display_Driver_Times", false);
        }
        if (givenDataSelection != null && !times.isEmpty()) {
            CalendarDateTime t0 = new CalendarDateTime((DateTime)times.get(0));
            CalendarDate dt0 = t0.getCalendarDate();
            CalendarDateTime t1 = new CalendarDateTime((DateTime)times.get(times.size() - 1));
            CalendarDate dt1 = t1.getCalendarDate();
            this.dateRange = CalendarDateRange.of(dt0, dt1);
        } else {
            this.dateRange = null;
        }
        Trace.call2("GeoGridDataSource.getSequence");
        if (fieldImpl == null) {
            if (!JobManager.getManager().canContinue(loadId)) {
                return null;
            }
            LogUtil.userMessage(log_, "Unable to load field: " + paramName + " from:" + this.getFilePath(), true);
            return null;
        }
        JobManager.getManager().stopLoad(loadId);
        Trace.call2("GeoGridDataSource.makeField");
        LogUtil.message("");
        log_.debug("Read grid in " + (System.currentTimeMillis() - millis));
        return fieldImpl;
    }

    public int getTimeIndexWithBounds(DateTime dateTime, List<DateTime> allTimes, CoordinateAxis1DTime cca) {
        int index = allTimes.indexOf(dateTime);
        if (index < 0) {
            return 0;
        }
        int lastindex = allTimes.lastIndexOf(dateTime);
        if (index == lastindex) {
            return index;
        }
        double[] bounds = cca.getCoordBounds(index);
        int finalIndex0 = index;
        if (bounds != null && bounds[1] != bounds[0]) {
            double min = bounds[1] - bounds[0];
            for (int ii = index + 1; ii <= lastindex; ++ii) {
                bounds = cca.getCoordBounds(ii);
                double tmp = bounds[1] - bounds[0];
                if (!(tmp < min)) continue;
                finalIndex0 = ii;
            }
            index = finalIndex0;
        }
        return index;
    }

    public GeoGrid findGridForDataChoice(GridDataset ds, DataChoice dc) {
        if (ds == null) {
            return null;
        }
        String name = dc.getStringId();
        List<String> newName = gribRenamer.matchNcepNames(ds, name);
        List<String> userRemappedNames = DataManager.getNewVariableName(name);
        if (userRemappedNames != null && !userRemappedNames.isEmpty()) {
            for (String string : userRemappedNames) {
                GeoGrid tmpGeoGrid = ds.findGridByName(string);
                if (tmpGeoGrid == null) continue;
                name = string;
                dc.setId(name);
                dc.setName(name);
                return tmpGeoGrid;
            }
        }
        if (newName.size() == 1) {
            name = newName.get(0);
        } else if (newName.size() > 0) {
            LogUtil.printMessage("Multiple Matches Found for " + name);
            LogUtil.printMessage("Possible new variable names are:");
            ArrayList<String> newDescription = new ArrayList<String>();
            for (String possibleNewName : newName) {
                LogUtil.printMessage("    " + possibleNewName);
                newDescription.add(ds.getDataVariable(possibleNewName).getDescription());
            }
            LogUtil.printMessage("Please update your bundle.");
            if (this.getIdv().getInteractiveMode()) {
                String string = "The variable name has changed.  Please select a new match.<br><br>";
                String msg2 = "Possible new names for the variable <i>" + dc.getDescription() + "</i> are:<br><br>";
                String msg3 = StringUtil.join("<br>", newDescription);
                String label = "<html>" + string + msg2 + "<i>" + msg3 + "</i></html>";
                ArrayList<DataCategory> cats = new ArrayList<DataCategory>();
                for (String possibleNewName : newName) {
                    cats.add(new DataCategory("param:" + possibleNewName, false));
                }
                DataOperand operand = new DataOperand(name, label, cats, false);
                DataTreeDialog dataDialog = new DataTreeDialog(this.getIdv(), null, Misc.newList(operand), Misc.newList(this), Misc.newList(dc), false);
                List choices = dataDialog.getSelected();
                if (choices != null && choices.size() > 0) {
                    DataChoice dc_new = (DataChoice)((List)choices.get(0)).get(0);
                    name = dc_new.getStringId();
                    dc.setId(name);
                    dc.setName(name);
                    GeoGrid geoGrid = ds.findGridByName(name);
                    return geoGrid;
                }
            }
        } else {
            return null;
        }
        dc.setId(name);
        dc.setName(name);
        GeoGrid geoGrid = ds.findGridByName(name);
        return geoGrid;
    }

    protected boolean isZAxisOk(CoordinateAxis1D zaxis) {
        return GeoGridAdapter.isZAxisOk(zaxis);
    }

    @Override
    public List getAllDateTimes(DataChoice dataChoice) {
        return (List)this.timeMap.get(dataChoice.getId());
    }

    private DataChoice makeDataChoiceFromGeoGrid(GeoGrid cfield, List allTimes, Hashtable timeToIndex) {
        GridCoordSystem gcs = cfield.getCoordinateSystem();
        LatLonRect llr = gcs.getLatLonBoundingBox();
        LatLonPointImpl lleft = llr.getLowerLeftPoint();
        LatLonPointImpl uright = llr.getUpperRightPoint();
        double centerLat = lleft.getLatitude() + (uright.getLatitude() - lleft.getLatitude()) / 2.0;
        EarthLocationTuple elt = null;
        Hashtable<String, EarthLocationTuple> ht = new Hashtable<String, EarthLocationTuple>();
        try {
            elt = new EarthLocationTuple(centerLat, llr.getCenterLon(), 0.0);
            ht.put("INITIAL_PROBE_EARTHLOCATION", elt);
        }
        catch (Exception exception) {
            // empty catch block
        }
        CoordinateAxis xaxis = gcs.getXHorizAxis();
        CoordinateAxis yaxis = gcs.getYHorizAxis();
        CoordinateAxis1D zaxis = gcs.getVerticalAxis();
        long sizeZ = 0L;
        if (zaxis != null) {
            sizeZ = (int)zaxis.getSize();
        }
        Hashtable threeDProps = Misc.newHashtable("prop.icon", "/auxdata/ui/icons/3D.gif");
        Hashtable twoDProps = Misc.newHashtable("prop.icon", "/auxdata/ui/icons/2D.gif");
        if (ht != null) {
            threeDProps.putAll(ht);
            twoDProps.putAll(ht);
        }
        DirectDataChoice choice = null;
        if (sizeZ < 0L) {
            log_.error("    weird Geogrid -- it claims size Z<0; parm " + cfield.getName());
            return null;
        }
        if (this.isZAxisOk(zaxis)) {
            int yLength;
            int xLength;
            CoordinateAxis1DTime tAxis;
            String parmName;
            String pseudoName = parmName = cfield.getName();
            String description = cfield.getDescription();
            if (description == null || description.equals("")) {
                description = parmName;
            }
            if ((tAxis = gcs.getTimeAxis1D()) == null && gcs.getRunTimeAxis() != null) {
                tAxis = gcs.getRunTimeAxis();
            }
            List geoTimes = this.getGeoGridTimes(tAxis);
            this.timeMap.put(parmName, geoTimes);
            ArrayList<Integer> indexList = new ArrayList<Integer>();
            if (geoTimes != null && allTimes != null) {
                for (int i = 0; i < geoTimes.size(); ++i) {
                    Integer timeIndex = (Integer)timeToIndex.get(geoTimes.get(i));
                    indexList.add(timeIndex);
                }
            }
            DataSelection dataSelection = DataSelection.NULL;
            List<DataCategory> categories = null;
            Hashtable<String, Object> props = null;
            if (sizeZ == 0L || sizeZ == 1L) {
                xLength = cfield.getXDimension().getLength();
                yLength = cfield.getYDimension().getLength();
                Dimension ensDim = cfield.getEnsembleDimension();
                if (this.twoDDimensionsLabel == null) {
                    this.twoDDimensionsLabel = "Total grid size:  x: " + xLength + "  y: " + yLength + "    #points: " + xLength * yLength;
                }
                props = new Hashtable<String, Object>(twoDProps);
                props.put(PROP_GRIDSIZE, new ThreeDSize(xLength, yLength));
                if (geoTimes != null) {
                    props.put(PROP_TIMESIZE, new Integer(geoTimes.size()));
                }
                if (ensDim != null && ensDim.getLength() > 1) {
                    List<NamedObject> ensMembers = null;
                    CoordinateAxis1D eAxis = gcs.getEnsembleAxis();
                    int numEns = ensDim.getLength();
                    if (ensMembers == null && eAxis != null) {
                        ensMembers = eAxis.getNames();
                    }
                    int[] ids = new int[numEns];
                    String[] enames = new String[numEns];
                    for (int i = 0; i < numEns; ++i) {
                        ids[i] = i;
                        NamedAnything na = (NamedAnything)ensMembers.get(i);
                        enames[i] = GeoGridDataSource.isNumeric(na.toString()) ? "Member " + na.toString() : na.toString();
                    }
                    List ensSet = TwoFacedObject.createList(ids, enames);
                    props.put("prop.gridmembers", ensSet);
                }
                categories = ensDim != null && ensDim.getLength() > 1 ? (tAxis == null ? this.getTwoDCategories() : this.getTwoDEnsTimeSeriesCategories()) : (tAxis == null ? this.getTwoDCategories() : this.getTwoDTimeSeriesCategories());
            } else {
                xLength = cfield.getXDimension().getLength();
                yLength = cfield.getYDimension().getLength();
                int zLength = cfield.getZDimension().getLength();
                Dimension ensDim = cfield.getEnsembleDimension();
                if (xLength * yLength * zLength > this.max3D) {
                    this.max3D = xLength * yLength * zLength;
                    this.max3DX = xLength;
                    this.max3DY = yLength;
                    this.max3DZ = zLength;
                }
                ThreeDSize size = new ThreeDSize(xLength, yLength, zLength);
                props = new Hashtable(threeDProps);
                props.put(PROP_GRIDSIZE, size);
                if (geoTimes != null) {
                    props.put(PROP_TIMESIZE, new Integer(geoTimes.size()));
                }
                if (ensDim != null && ensDim.getLength() > 1) {
                    List<NamedObject> ensMembers = null;
                    CoordinateAxis1D eAxis = gcs.getEnsembleAxis();
                    int numEns = ensDim.getLength();
                    if (ensMembers == null && eAxis != null) {
                        ensMembers = eAxis.getNames();
                    }
                    int[] ids = new int[numEns];
                    String[] enames = new String[numEns];
                    for (int i = 0; i < numEns; ++i) {
                        ids[i] = i;
                        NamedAnything na = (NamedAnything)ensMembers.get(i);
                        enames[i] = na.toString();
                    }
                    List ensSet = TwoFacedObject.createList(ids, enames);
                    props.put("prop.gridmembers", ensSet);
                }
                categories = ensDim != null && ensDim.getLength() > 1 ? (tAxis == null ? this.getThreeDCategories() : this.getThreeDEnsTimeSeriesCategories()) : (tAxis == null ? this.getThreeDCategories() : this.getThreeDTimeSeriesCategories());
            }
            Attribute attr = null;
            for (int i = 0; i < categoryAttributes.length && attr == null; ++i) {
                attr = cfield.findAttributeIgnoreCase(categoryAttributes[i]);
            }
            if (attr != null) {
                String append = attr.getStringValue();
                if (append != null) {
                    append = append.replaceAll("-", "_");
                }
                DataCategory cat = (DataCategory)categories.get(0);
                cat = cat.copyAndAppend(append);
                ArrayList<DataCategory> newCategories = new ArrayList<DataCategory>();
                newCategories.add(cat);
                for (int i = 1; i < categories.size(); ++i) {
                    newCategories.add((DataCategory)categories.get(i));
                }
                categories = newCategories;
            }
            Group group = null;
            VariableDS variable = cfield.getVariable();
            if (variable != null && (group = variable.getParentGroup()) != null && !group.equals("")) {
                String append = group.getName();
                if (append != null) {
                    append = append.replaceAll("/", "");
                    append = append.replaceAll("-", "_");
                }
                DataCategory cat = (DataCategory)categories.get(0);
                cat = cat.copyAndAppend(append);
                ArrayList<DataCategory> newCategories = new ArrayList<DataCategory>();
                newCategories.add(cat);
                for (int i = 1; i < categories.size(); ++i) {
                    newCategories.add((DataCategory)categories.get(i));
                }
                categories = newCategories;
            }
            choice = new DirectDataChoice(this, parmName, pseudoName, description, categories, dataSelection, props);
        }
        return choice;
    }

    public static boolean isNumeric(String str) {
        try {
            double d = Double.parseDouble(str);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }

    private List getGeoGridTimes(CoordinateAxis1DTime timeAxis) {
        if (timeAxis == null || timeAxis.getSize() == 0L) {
            return new ArrayList(0);
        }
        List<CalendarDateTime> times = (List<CalendarDateTime>)this.gcsVsTime.get(timeAxis);
        if (times != null) {
            return times;
        }
        try {
            times = DataUtil.makeDateTimes(timeAxis);
            this.gcsVsTime.put(timeAxis, times);
        }
        catch (Exception e) {
            System.out.println("getGeoGridTimes() " + e);
        }
        return times;
    }

    public static void main(String[] args) throws Exception {
        String leadUrl = "dods://lead.unidata.ucar.edu:8080/thredds/dodsC/model/NCEP/NAM/CONUS_80km/NAM_CONUS_80km_20071002_1200.grib1";
        String mlodeUrl = "dods://motherlode.ucar.edu:8080/thredds/dodsC/model/NCEP/NAM/CONUS_80km/NAM_CONUS_80km_20071002_1200.grib1";
        String url = args.length == 0 ? leadUrl : mlodeUrl;
        String[] urls = new String[]{url};
        testMode = true;
        for (int i = 0; i < 10000; ++i) {
            for (int urlIdx = 0; urlIdx < urls.length; ++urlIdx) {
                System.err.println("Reading data:" + i + " " + urls[urlIdx]);
                GeoGridDataSource ggds = new GeoGridDataSource(null, urls[urlIdx], null);
                ggds.doMakeDataChoices();
                DataChoice dataChoice = ggds.findDataChoice("Temperature");
                if (dataChoice == null) {
                    dataChoice = ggds.findDataChoice("T");
                }
                ggds.makeFieldImpl(dataChoice, ggds.getDataSelection(), null);
            }
        }
    }

    private static String preText(String s) {
        s = StringUtil.replace(s, "<", "&lt;");
        s = StringUtil.replace(s, ">", "&gt;");
        s = StringUtil.replace(s, "\n", "<br>\n");
        s = StringUtil.replace(s, "\t", "    ");
        s = StringUtil.replace(s, " ", "&nbsp;");
        return "<div style=\"margin-left:20;border:solid 1px\">" + s + "</div>";
    }

    public void setFileNameOrUrl(String value) {
        this.oldSourceFromBundles = value;
    }

    @Override
    public boolean applyProperties() {
        if (!super.applyProperties()) {
            return false;
        }
        if (this.reverseTimesCheckbox != null) {
            this.reverseTimes = this.reverseTimesCheckbox.isSelected();
        }
        return true;
    }

    @Override
    protected JComponent getExtraTimesComponent() {
        this.reverseTimesCheckbox = new JCheckBox("Reverse Times", this.reverseTimes);
        this.reverseTimesCheckbox.setToolTipText("If you have selected the first time then really use the last time");
        return GuiUtils.right(this.reverseTimesCheckbox);
    }

    public void setReverseTimes(boolean value) {
        this.reverseTimes = value;
    }

    public boolean getReverseTimes() {
        return this.reverseTimes;
    }

    public static class HugeSizeException
    extends Exception {
    }
}

