/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.data.grid;

import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import ucar.ma2.Array;
import ucar.ma2.ArrayDouble;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dataset.CoordinateAxis1DTime;
import ucar.nc2.dataset.CoordinateAxis2D;
import ucar.nc2.dt.GridCoordSystem;
import ucar.nc2.dt.grid.GeoGrid;
import ucar.unidata.data.DataContext;
import ucar.unidata.data.DataUtil;
import ucar.unidata.data.grid.GeoGridDataSource;
import ucar.unidata.data.grid.GridUtil;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.vertical.VerticalTransform;
import ucar.unidata.util.JobManager;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.ObjectPair;
import ucar.unidata.util.Range;
import ucar.unidata.util.Trace;
import ucar.visad.ProjectionCoordinateSystem;
import ucar.visad.RadarGridCoordinateSystem;
import ucar.visad.data.CalendarDateTime;
import ucar.visad.data.CalendarDateTimeSet;
import ucar.visad.data.GeoGridFlatField;
import ucar.visad.quantities.CommonUnits;
import ucar.visad.quantities.GeopotentialAltitude;
import ucar.visad.quantities.Gravity;
import visad.CachingCoordinateSystem;
import visad.CartesianProductCoordinateSystem;
import visad.CommonUnit;
import visad.CoordinateSystem;
import visad.Data;
import visad.DateTime;
import visad.EmpiricalCoordinateSystem;
import visad.ErrorEstimate;
import visad.FieldImpl;
import visad.FunctionType;
import visad.Gridded1DSet;
import visad.Gridded3DSet;
import visad.GriddedSet;
import visad.IdentityCoordinateSystem;
import visad.Integer1DSet;
import visad.Linear1DSet;
import visad.Linear2DSet;
import visad.Linear3DSet;
import visad.LinearLatLonSet;
import visad.MathType;
import visad.Real;
import visad.RealTupleType;
import visad.RealType;
import visad.Set;
import visad.SetException;
import visad.SetType;
import visad.Unit;
import visad.VisADException;
import visad.data.CachedFlatField;
import visad.data.in.ArithProg;
import visad.data.in.LonArithProg;
import visad.util.ThreadManager;

public class GeoGridAdapter {
    static LogUtil.LogCategory log_ = LogUtil.getLogInstance(GeoGridAdapter.class.getName());
    public String cacheFile;
    private GeoGridDataSource dataSource;
    private Object extraCacheKey;
    private boolean lazyEvaluation = true;
    private GeoGrid geoGrid = null;
    private double fhgLevel = -999.9;
    private static int count = 0;
    private NetcdfFile ncFile;
    private String paramName;
    RealType paramType;
    private Object readLock;
    private String vertcs = "ucar.visad.quantities.AirPressure$StandardAtmosphereCoordinateSystem";
    static boolean makeGeoGridFlatField = true;

    public GeoGridAdapter(GeoGridDataSource dataSource, GeoGrid geoGrid) throws VisADException {
        this(dataSource, geoGrid, geoGrid.getName());
    }

    public GeoGridAdapter(GeoGridDataSource dataSource, GeoGrid geoGrid, String paramName) throws VisADException {
        this(dataSource, geoGrid, paramName, null);
    }

    public GeoGridAdapter(GeoGridDataSource dataSource, GeoGrid geoGrid, NetcdfFile ncFile) throws VisADException {
        this(dataSource, geoGrid, geoGrid.getName(), ncFile);
    }

    public GeoGridAdapter(GeoGridDataSource dataSource, GeoGrid geoGrid, String paramName, NetcdfFile ncFile) throws VisADException {
        this(dataSource, geoGrid, paramName, ncFile, null);
    }

    public GeoGridAdapter(GeoGridDataSource dataSource, GeoGrid geoGrid, String paramName, NetcdfFile ncFile, Object extraCacheKey) throws VisADException {
        String vcs;
        DataContext dataContext;
        this.dataSource = dataSource;
        if (dataSource != null && (dataContext = dataSource.getDataContext()) != null && (vcs = (String)dataContext.getPreference("Data.VerticalCS")) != null) {
            this.vertcs = vcs;
        }
        this.readLock = dataSource.readLock;
        if (geoGrid == null) {
            throw new IllegalArgumentException("GeoGridAdapter: geogrid cannot be null");
        }
        this.ncFile = ncFile;
        this.paramName = paramName;
        this.geoGrid = geoGrid;
        this.paramType = this.makeRealType(paramName, this.getUnit(geoGrid.getUnitsString()));
        this.extraCacheKey = extraCacheKey;
    }

    protected List getLevels() throws VisADException {
        ArrayList<Real> levels = new ArrayList<Real>();
        GridCoordSystem gcs = this.geoGrid.getCoordinateSystem();
        VerticalTransform vt = gcs.getVerticalTransform();
        CoordinateAxis1D zAxis = gcs.getVerticalAxis();
        if (zAxis == null) {
            return levels;
        }
        int sizeZ = (int)zAxis.getSize();
        if (sizeZ == 0) {
            return levels;
        }
        boolean isLinear = this.checkLinearity(zAxis, false);
        Unit zUnit = this.getUnit(zAxis.getUnitsString());
        boolean isLatLon = gcs.isLatLon();
        RealType zType = null;
        boolean is2D = this.is2D(sizeZ, zUnit, vt);
        if (is2D) {
            return levels;
        }
        if (Unit.canConvert(zUnit, CommonUnit.meter) && vt == null) {
            if (!gcs.isZPositive()) {
                zUnit = zUnit.scale(-1.0);
            }
            zType = RealType.Altitude;
        } else {
            zType = this.makeRealType(zAxis.getName(), zUnit);
        }
        for (int k = 0; k < sizeZ; ++k) {
            float kValue = (float)zAxis.getCoordValue(k);
            levels.add(new Real(zType, kValue, zUnit));
        }
        return levels;
    }

    protected GeoGrid getGeoGrid() {
        return this.geoGrid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GriddedSet getSpatialDomainSet(GeoGrid geogrid, int timeIndex) throws VisADException {
        Object object = this.dataSource.DOMAIN_SET_MUTEX;
        synchronized (object) {
            return this.getSpatialDomainSetInner(geogrid, timeIndex);
        }
    }

    private GriddedSet getSpatialDomainSetInner(GeoGrid geogrid, int timeIndex) throws VisADException {
        CoordinateSystem cs;
        GridCoordSystem gcs = geogrid.getCoordinateSystem();
        VerticalTransform vt = gcs.getVerticalTransform();
        boolean isTimeDependent = vt != null && vt.isTimeDependent();
        Trace.msg("GeoGridAdapter isTimeDependent = " + isTimeDependent);
        Object timeStepKey = !isTimeDependent ? gcs : new ObjectPair(gcs, new Integer(timeIndex));
        timeStepKey = Misc.newList(timeStepKey, this.extraCacheKey);
        GriddedSet domainSet = (GriddedSet)this.dataSource.getCache(timeStepKey, true);
        if (domainSet != null) {
            return domainSet;
        }
        List domainSetKey = Misc.newList(gcs, this.extraCacheKey);
        float[][] refVals = null;
        Object[] cachedPair = (Object[])this.dataSource.getCache(domainSetKey, true);
        if (cachedPair != null) {
            domainSet = (GriddedSet)cachedPair[0];
            refVals = (float[][])cachedPair[1];
        } else {
            Trace.call1("GeoGridAdapter.getInitialSpatialDomain");
            domainSet = this.getInitialSpatialDomain(geogrid);
            Trace.call2("GeoGridAdapter.getInitialSpatialDomain");
            cs = domainSet.getCoordinateSystem();
            if (vt != null && cs != null) {
                Trace.call1("GeoGridAdapter.transformCoordinates");
                RealTupleType setType = ((SetType)domainSet.getType()).getDomain();
                RealTupleType refType = cs.getReference();
                ErrorEstimate[] oldErrors = domainSet.getSetErrors();
                ErrorEstimate[] newErrors = new ErrorEstimate[oldErrors.length];
                float[][] setVals = domainSet.getSamples();
                refVals = CoordinateSystem.transformCoordinates(refType, refType.getCoordinateSystem(), refType.getDefaultUnits(), newErrors, setType, cs, domainSet.getSetUnits(), oldErrors, setVals, false);
                Trace.call2("GeoGridAdapter.transformCoordinates");
            }
            this.dataSource.putCache(domainSetKey, new Object[]{domainSet, refVals}, true);
        }
        cs = domainSet.getCoordinateSystem();
        if (vt != null && cs != null) {
            Trace.call1("GeoGridAdapter.spatial makeDomainWithVerticalTransform");
            domainSet = this.makeDomainWithVerticalTransform(vt, domainSet, refVals, timeIndex);
            Trace.call2("GeoGridAdapter.spatial makeDomainWithVerticalTransform");
        }
        this.dataSource.putCache(timeStepKey, domainSet, true);
        log_.debug("DomainSet = " + domainSet);
        return domainSet;
    }

    private GriddedSet getInitialSpatialDomain(GeoGrid geogrid) throws VisADException {
        List domainTemplateKey;
        RealTupleType cachedDomainTemplate;
        boolean yIsLinear;
        GriddedSet domainSet = null;
        GridCoordSystem gcs = geogrid.getCoordinateSystem();
        VerticalTransform vt = gcs.getVerticalTransform();
        CoordinateAxis xAxis = gcs.getXHorizAxis();
        CoordinateAxis yAxis = gcs.getYHorizAxis();
        CoordinateAxis1D zAxis = gcs.getVerticalAxis();
        boolean xIsLinear = false;
        boolean isLinear = yIsLinear = this.checkLinearity(yAxis, false);
        int sizeZ = zAxis == null ? 0 : (int)zAxis.getSize();
        boolean bl = isLinear = isLinear && sizeZ != 1;
        if (isLinear && sizeZ > 1) {
            isLinear = this.checkLinearity(zAxis, false);
        }
        Unit xUnit = this.getUnit(xAxis.getUnitsString());
        Unit yUnit = this.getUnit(yAxis.getUnitsString());
        Unit zUnit = null;
        if (zAxis != null) {
            zUnit = this.getUnit(zAxis.getUnitsString());
        }
        log_.debug("    x axis has units " + xAxis.getUnitsString() + " or " + xUnit);
        log_.debug("    y axis has units " + yAxis.getUnitsString() + " or " + yUnit);
        if (zAxis != null) {
            log_.debug("    z axis has units " + zAxis.getUnitsString() + " or " + zUnit);
        }
        log_.debug("  grid size: x = " + xAxis.getSize() + " y = " + yAxis.getSize() + " z = " + sizeZ);
        boolean isLatLon = gcs.isLatLon();
        Object domainCS = null;
        RealType xType = null;
        RealType yType = null;
        RealType zType = null;
        boolean needToWrapLon = false;
        if (isLatLon) {
            xIsLinear = this.checkLinearity(xAxis, true);
            if (xIsLinear) {
                needToWrapLon = this.checkNeedToWrapLon(xAxis);
            }
        } else {
            xIsLinear = this.checkLinearity(xAxis, false);
        }
        isLinear = isLinear && xIsLinear;
        RealTupleType domainTemplate = null;
        boolean is2D = this.is2D(sizeZ, zUnit, vt);
        if (isLatLon) {
            log_.debug("is lat/lon");
            if (is2D) {
                xType = RealType.Longitude;
                yType = RealType.Latitude;
                domainTemplate = RealTupleType.SpatialEarth2DTuple;
                if (xAxis.getUnitsString().equals("")) {
                    xUnit = CommonUnit.degree;
                }
                if (yAxis.getUnitsString().equals("")) {
                    yUnit = CommonUnit.degree;
                }
            } else if (Unit.canConvert(zUnit, CommonUnit.meter)) {
                if (!gcs.isZPositive()) {
                    zUnit = zUnit.scale(-1.0);
                }
                xType = RealType.Longitude;
                yType = RealType.Latitude;
                zType = RealType.Altitude;
                domainTemplate = RealTupleType.SpatialEarth3DTuple;
            } else {
                xType = this.makeRealType(xAxis.getName().equals("Longitude") ? "longi" : xAxis.getName(), xUnit);
                yType = this.makeRealType(yAxis.getName().equals("Latitude") ? "lati" : yAxis.getName(), yUnit);
                zType = this.makeRealType(zAxis.getName(), zUnit);
                CoordinateSystem compCS = null;
                if (vt != null) {
                    compCS = new CartesianProductCoordinateSystem(new IdentityCoordinateSystem(RealTupleType.SpatialEarth2DTuple), new IdentityCoordinateSystem(new RealTupleType(zType)));
                } else if (Unit.canConvert(zUnit, CommonUnits.MILLIBAR)) {
                    compCS = new CartesianProductCoordinateSystem(new IdentityCoordinateSystem(RealTupleType.SpatialEarth2DTuple), new CachingCoordinateSystem(DataUtil.getPressureToHeightCS(this.vertcs)));
                } else if (Unit.canConvert(zUnit, CommonUnit.degree) && !zUnit.getIdentifier().equals("")) {
                    zType = this.makeRealType("elev_angle", zUnit);
                    compCS = this.makeElevationCS();
                } else {
                    LogUtil.userMessage(log_, "Unknown vertical coordinate with Unit " + zUnit + ", using linear scale to Altitude", true);
                    compCS = new CartesianProductCoordinateSystem(new IdentityCoordinateSystem(RealTupleType.SpatialEarth2DTuple), new IdentityCoordinateSystem(new RealTupleType(RealType.Altitude), new Unit[]{zUnit}));
                }
                domainTemplate = new RealTupleType(xType, yType, zType, compCS, null);
            }
        } else {
            log_.debug("not lat/lon");
            ProjectionImpl project = gcs.getProjection();
            CachingCoordinateSystem pCS = new CachingCoordinateSystem(new ProjectionCoordinateSystem(project, new Unit[]{xUnit, yUnit}));
            xType = this.makeRealType(xAxis.getName(), xUnit);
            yType = this.makeRealType(yAxis.getName(), yUnit);
            if (is2D) {
                domainTemplate = new RealTupleType(xType, yType, pCS, null);
            } else {
                CartesianProductCoordinateSystem compCS = null;
                zType = this.makeRealType(zAxis.getName(), zUnit);
                log_.debug("non-lat/lon 3D grid zType=" + zType + "," + zUnit);
                if (vt != null) {
                    compCS = new CartesianProductCoordinateSystem(pCS, new IdentityCoordinateSystem(new RealTupleType(zType)));
                } else if (Unit.canConvert(zUnit, CommonUnit.meter)) {
                    zType = this.makeRealType("alti", zUnit);
                    compCS = new CartesianProductCoordinateSystem(pCS, new IdentityCoordinateSystem(new RealTupleType(RealType.Altitude)));
                } else if (Unit.canConvert(zUnit, CommonUnits.MILLIBAR)) {
                    compCS = new CartesianProductCoordinateSystem(pCS, new CachingCoordinateSystem(DataUtil.getPressureToHeightCS(this.vertcs)));
                } else {
                    LogUtil.userMessage(log_, "Unknown vertical coordinate with Unit " + zUnit + ", using linear scale to Altitude", true);
                    compCS = new CartesianProductCoordinateSystem(pCS, new CachingCoordinateSystem(new IdentityCoordinateSystem(new RealTupleType(RealType.Altitude), new Unit[]{zUnit})));
                }
                domainTemplate = new RealTupleType(xType, yType, zType, compCS, null);
            }
        }
        if ((cachedDomainTemplate = (RealTupleType)this.dataSource.getCache(domainTemplateKey = Misc.newList(gcs, "DomainType", this.extraCacheKey), true)) != null) {
            Trace.msg("GeoGridAdapter:using cached domain template:" + cachedDomainTemplate);
            domainTemplate = cachedDomainTemplate;
        } else {
            Trace.msg("GeoGridAdapter:using new domain template:" + domainTemplate);
            this.dataSource.putCache(domainTemplateKey, domainTemplate, true);
        }
        if (isLinear) {
            Linear1DSet xSet = this.makeLinear1DSet((CoordinateAxis1D)xAxis, xType, xUnit, needToWrapLon);
            Linear1DSet ySet = this.makeLinear1DSet((CoordinateAxis1D)yAxis, yType, yUnit);
            if (is2D) {
                if (isLatLon) {
                    try {
                        domainSet = new LinearLatLonSet((MathType)domainTemplate, new Linear1DSet[]{xSet, ySet}, (CoordinateSystem)null, new Unit[]{xUnit, yUnit}, (ErrorEstimate[])null, true);
                    }
                    catch (SetException se) {
                        domainSet = new Linear2DSet((MathType)domainTemplate, new Linear1DSet[]{xSet, ySet}, (CoordinateSystem)null, new Unit[]{xUnit, yUnit}, (ErrorEstimate[])null, true);
                    }
                } else {
                    domainSet = new Linear2DSet((MathType)domainTemplate, new Linear1DSet[]{xSet, ySet}, (CoordinateSystem)null, new Unit[]{xUnit, yUnit}, (ErrorEstimate[])null, true);
                }
            } else {
                Linear1DSet zSet = this.makeLinear1DSet(zAxis, zType, zUnit);
                domainSet = new Linear3DSet((MathType)domainTemplate, new Linear1DSet[]{xSet, ySet, zSet}, (CoordinateSystem)null, new Unit[]{xUnit, yUnit, zUnit}, (ErrorEstimate[])null, true);
            }
        } else {
            Unit[] units;
            int[] lengths;
            int idx;
            float[][] coordData;
            log_.debug("not linear set");
            int sizeX = (int)xAxis.getSize();
            log_.debug("x has " + sizeX + " elements");
            int sizeY = (int)yAxis.getSize();
            log_.debug("y has " + sizeY + " elements");
            boolean is1D = xAxis.getRank() == 1;
            log_.debug("x has rank " + xAxis.getRank());
            if (is2D) {
                if (needToWrapLon) {
                    ++sizeX;
                }
                log_.debug("sizeZ <= 1 (i.e., 2D)");
                coordData = new float[2][is1D ? sizeX * sizeY : sizeX];
                idx = 0;
                if (is1D) {
                    for (int j = 0; j < sizeY; ++j) {
                        for (int i = 0; i < sizeX; ++i) {
                            coordData[0][idx] = needToWrapLon && i == sizeX - 1 ? (float)(((CoordinateAxis1D)xAxis).getCoordValue(i - 1) + ((CoordinateAxis1D)xAxis).getIncrement()) : (float)((CoordinateAxis1D)xAxis).getCoordValue(i);
                            coordData[1][idx] = (float)((CoordinateAxis1D)yAxis).getCoordValue(j);
                            ++idx;
                        }
                    }
                    lengths = new int[]{sizeX, sizeY};
                } else {
                    int[] shape = xAxis.getShape();
                    int iBounds = shape[0];
                    int jBounds = shape[1];
                    CoordinateAxis2D xAxis2D = (CoordinateAxis2D)xAxis;
                    CoordinateAxis2D yAxis2D = (CoordinateAxis2D)yAxis;
                    Trace.call1("GeoGridAdapter.getCoordValues");
                    xAxis2D.getCoordValue(0, 0);
                    yAxis2D.getCoordValue(0, 0);
                    Trace.call2("GeoGridAdapter.getCoordValues");
                    float[] coordData0 = coordData[0];
                    float[] coordData1 = coordData[1];
                    for (int i = 0; i < iBounds; ++i) {
                        for (int j = 0; j < jBounds; ++j) {
                            coordData0[idx] = (float)xAxis2D.getCoordValue(i, j);
                            coordData1[idx] = (float)yAxis2D.getCoordValue(i, j);
                            ++idx;
                        }
                    }
                    lengths = new int[]{shape[1], shape[0]};
                }
                units = new Unit[]{xUnit, yUnit};
            } else {
                if (is1D && needToWrapLon) {
                    ++sizeX;
                }
                Trace.call1("GeoGridAdapter:making coordData array", " size:" + sizeX * sizeY * sizeZ);
                coordData = is1D ? new float[3][sizeX * sizeY * sizeZ] : new float[3][sizeX * sizeZ];
                Trace.call2("GeoGridAdapter:making coordData array");
                idx = 0;
                if (is1D) {
                    int[] nArray;
                    int i;
                    Trace.call1("GeoGridAdapter:getCoordValue");
                    float[] xValues = new float[sizeX];
                    float[] yValues = new float[sizeY];
                    for (i = 0; i < xValues.length; ++i) {
                        xValues[i] = needToWrapLon && i == sizeX - 1 ? (float)(((CoordinateAxis1D)xAxis).getCoordValue(i - 1) + ((CoordinateAxis1D)xAxis).getIncrement()) : (float)((CoordinateAxis1D)xAxis).getCoordValue(i);
                    }
                    for (i = 0; i < yValues.length; ++i) {
                        yValues[i] = (float)((CoordinateAxis1D)yAxis).getCoordValue(i);
                    }
                    float[] coordData0 = coordData[0];
                    float[] coordData1 = coordData[1];
                    float[] coordData2 = coordData[2];
                    for (int k = 0; k < sizeZ; ++k) {
                        float kValue = (float)zAxis.getCoordValue(k);
                        for (int j = 0; j < sizeY; ++j) {
                            float yValue = yValues[j];
                            for (int i2 = 0; i2 < sizeX; ++i2) {
                                coordData0[idx] = xValues[i2];
                                coordData1[idx] = yValue;
                                coordData2[idx] = kValue;
                                ++idx;
                            }
                        }
                    }
                    Trace.call2("GeoGridAdapter:getCoordValue", " cnt=" + idx);
                    if (sizeZ > 1) {
                        int[] nArray2 = new int[3];
                        nArray2[0] = sizeX;
                        nArray2[1] = sizeY;
                        nArray = nArray2;
                        nArray2[2] = sizeZ;
                    } else {
                        int[] nArray3 = new int[2];
                        nArray3[0] = sizeX;
                        nArray = nArray3;
                        nArray3[1] = sizeY;
                    }
                    lengths = nArray;
                } else {
                    int[] nArray;
                    int[] shape = xAxis.getShape();
                    int iBounds = shape[0];
                    int jBounds = shape[1];
                    CoordinateAxis2D xAxis2D = (CoordinateAxis2D)xAxis;
                    CoordinateAxis2D yAxis2D = (CoordinateAxis2D)yAxis;
                    Trace.call1("GeoGridAdapter.getCoordValues");
                    xAxis2D.getCoordValue(0, 0);
                    yAxis2D.getCoordValue(0, 0);
                    zAxis.getCoordValue(0);
                    Trace.call2("GeoGridAdapter.getCoordValues");
                    float[] coordData0 = coordData[0];
                    float[] coordData1 = coordData[1];
                    float[] coordData2 = coordData[2];
                    for (int k = 0; k < sizeZ; ++k) {
                        float kValue = (float)zAxis.getCoordValue(k);
                        for (int i = 0; i < iBounds; ++i) {
                            for (int j = 0; j < jBounds; ++j) {
                                coordData0[idx] = (float)xAxis2D.getCoordValue(i, j);
                                coordData1[idx] = (float)yAxis2D.getCoordValue(i, j);
                                coordData2[idx] = kValue;
                                ++idx;
                            }
                        }
                    }
                    if (sizeZ > 1) {
                        int[] nArray4 = new int[3];
                        nArray4[0] = shape[1];
                        nArray4[1] = shape[0];
                        nArray = nArray4;
                        nArray4[2] = sizeZ;
                    } else {
                        int[] nArray5 = new int[2];
                        nArray5[0] = shape[1];
                        nArray = nArray5;
                        nArray5[1] = shape[0];
                    }
                    lengths = nArray;
                }
                units = new Unit[]{xUnit, yUnit, zUnit};
            }
            Trace.call1("GeoGridAdapter.spatial GriddedSet.create");
            try {
                domainSet = GriddedSet.create(domainTemplate, coordData, lengths, null, units, null, false, true);
            }
            catch (SetException se) {
                String msg = se.getMessage();
                if (msg.indexOf("form a valid grid") >= 0 || msg.indexOf("may not be missing") >= 0) {
                    domainSet = GriddedSet.create(domainTemplate, coordData, lengths, null, units, null, false, false);
                }
                throw new VisADException(se);
            }
            Trace.call2("GeoGridAdapter.spatial GriddedSet.create");
        }
        log_.debug("Domain set = " + domainSet);
        return domainSet;
    }

    private boolean checkNeedToWrapLon(CoordinateAxis axis) {
        double newLast;
        double last;
        double first;
        if (axis.getRank() > 1) {
            return false;
        }
        CoordinateAxis1D axis1D = (CoordinateAxis1D)axis;
        return axis1D.isRegular() && (first = axis1D.getCoordValue(0)) + 360.0 != (last = axis1D.getCoordValue((int)axis1D.getSize() - 1)) && GridUtil.isLonCyclic(first, newLast = last + axis1D.getIncrement());
    }

    private GriddedSet makeDomainWithVerticalTransform(VerticalTransform vt, GriddedSet domainSet, float[][] refVals, int timeIndex) throws VisADException {
        Gridded3DSet newDSet = (Gridded3DSet)domainSet;
        try {
            CoordinateSystem cs = domainSet.getCoordinateSystem();
            if (cs == null) {
                return newDSet;
            }
            RealTupleType setType = ((SetType)domainSet.getType()).getDomain();
            RealTupleType refType = cs.getReference();
            ErrorEstimate[] oldErrors = domainSet.getSetErrors();
            ErrorEstimate[] newErrors = new ErrorEstimate[oldErrors.length];
            Unit vtu = this.getUnit(vt.getUnitString());
            log_.debug("vtu = " + vtu);
            RealType[] types = refType.getRealComponents();
            boolean isPressure = false;
            boolean isGeopotentialAltitude = false;
            if (!Unit.canConvert(vtu, CommonUnit.meter)) {
                if (Unit.canConvert(vtu, CommonUnits.MILLIBAR)) {
                    isPressure = true;
                } else if (Unit.canConvert(vtu, GeopotentialAltitude.getGeopotentialMeter())) {
                    isGeopotentialAltitude = true;
                } else {
                    throw new VisADException("unknown vertical coordinate");
                }
            }
            RealTupleType newDomainType = new RealTupleType(types[0], types[1], RealType.Altitude);
            Trace.call1("GeoGridAdapter.getCoordinateArray", " vt:" + vt.getClass().getName());
            ArrayDouble.D3 array = vt.getCoordinateArray(timeIndex);
            Trace.call2("GeoGridAdapter.getCoordinateArray");
            Trace.call1("GeoGridAdapter.get1DValues");
            float[] vals = DataUtil.toFloatArray(array);
            if (vals.length != domainSet.getLength()) {
                int[] dl = domainSet.getLengths();
                float[] valsT = new float[domainSet.getLength()];
                int ii = 0;
                int jj = 0;
                int xl = dl[0] - 1;
                if (dl.length == 2) {
                    for (int j = 0; j < dl[1]; ++j) {
                        for (int i = 0; i < xl; ++i) {
                            ii = i + j * xl;
                            jj = i + j * (xl + 1);
                            valsT[jj] = vals[ii];
                        }
                        valsT[jj + 1] = valsT[j * xl];
                    }
                } else if (dl.length == 3) {
                    int yl = dl[1];
                    for (int k = 0; k < dl[2]; ++k) {
                        for (int j = 0; j < dl[1]; ++j) {
                            for (int i = 0; i < xl; ++i) {
                                ii = i + j * xl + k * xl * yl;
                                jj = i + j * (xl + 1) + k * (xl + 1) * yl;
                                valsT[jj] = vals[ii];
                            }
                            valsT[jj + 1] = valsT[j * (xl + 1) + k * (xl + 1) * yl];
                        }
                    }
                }
                refVals[2] = valsT;
            } else {
                refVals[2] = vals;
            }
            Trace.call2("GeoGridAdapter.get1DValues");
            if (isPressure) {
                CoordinateSystem vcs = DataUtil.getPressureToHeightCS(this.vertcs);
                refVals[2] = vcs.toReference(new float[][]{refVals[2]}, new Unit[]{vtu})[0];
                vtu = vcs.getReferenceUnits()[0];
            } else if (isGeopotentialAltitude) {
                refVals[2] = GeopotentialAltitude.toAltitude(refVals[2], vtu, Gravity.newReal(), refVals[2], CommonUnit.meter, false);
                vtu = CommonUnit.meter;
            }
            int[] lengths = domainSet.getLengths();
            Unit[] newDomainUnits = newDomainType.getDefaultUnits();
            newDomainUnits[2] = vtu;
            Trace.call1("GeoGridAdapter.new GriddedSet");
            Gridded3DSet newDomain = (Gridded3DSet)GriddedSet.create(newDomainType, refVals, lengths, null, newDomainUnits, newErrors, false, false);
            if (domainSet.getManifoldDimension() == 2) {
                return newDomain;
            }
            Trace.call2("GeoGridAdapter.new GriddedSet");
            Trace.call1("GeoGridAdapter.new EmpiricalCoordinateSystem");
            EmpiricalCoordinateSystem ecs = new EmpiricalCoordinateSystem(domainSet, newDomain, false, false);
            Trace.call2("GeoGridAdapter.new EmpiricalCoordinateSystem");
            EmpiricalCoordinateSystem gcs = ecs;
            RealTupleType newSetType = new RealTupleType(setType.getRealComponents(), (CoordinateSystem)gcs, null);
            Trace.call1("GeoGridAdapter final GriddedSet");
            newDSet = (Gridded3DSet)GriddedSet.create(newSetType, domainSet.getSamples(false), lengths, null, domainSet.getSetUnits(), oldErrors, false, false);
            Trace.call2("GeoGridAdapter final GriddedSet");
        }
        catch (VisADException ve) {
            throw ve;
        }
        catch (Exception re) {
            re.printStackTrace();
            throw new VisADException(re.getMessage());
        }
        return newDSet;
    }

    public FieldImpl getSequence() {
        return this.makeSequence(null);
    }

    public FieldImpl getSequence(int[] timeIndices) {
        return this.makeSequence(timeIndices);
    }

    public FieldImpl getSequence(int[] timeIndices, Object loadId) {
        return this.makeSequence(timeIndices, null, loadId);
    }

    public FieldImpl getSequence(int[] timeIndices, int[] memberIndices, Object loadId) {
        return this.makeSequence(timeIndices, memberIndices, loadId);
    }

    public FieldImpl getData() throws VisADException {
        return (CoordinateAxis1D)this.geoGrid.getCoordinateSystem().getTimeAxis() != null ? this.getSequence() : (this.getBaseTime() == null ? this.getFlatField(0, "") : this.makeSequence(null));
    }

    private CachedFlatField getFlatField(int timeIndex, String readLabel) throws VisADException {
        return this.getFlatField(timeIndex, -1, readLabel);
    }

    private CachedFlatField getFlatField(int timeIndex, int ensIndex, String readLabel) throws VisADException {
        CachedFlatField retField;
        String baseCacheKey = "t_" + timeIndex;
        List cacheKey = Misc.newList(baseCacheKey);
        if (ensIndex >= 0) {
            String ensCacheKey = "e_" + ensIndex;
            cacheKey.add(ensCacheKey);
        } else {
            ensIndex = 0;
        }
        if (this.extraCacheKey != null) {
            cacheKey.add(this.extraCacheKey);
        }
        if ((retField = null) != null) {
            return retField;
        }
        Trace.call1("GeoGridAdapter.getFlatField:" + this.paramName + ":time=" + timeIndex);
        GridCoordSystem gcs = this.geoGrid.getCoordinateSystem();
        Trace.call1("GeoGridAdapter.getSpatialDomainSet");
        GriddedSet domainSet = this.getSpatialDomainSet(this.geoGrid, timeIndex);
        Trace.call2("GeoGridAdapter.getSpatialDomainSet");
        FunctionType ffType = new FunctionType(((SetType)domainSet.getType()).getDomain(), this.paramType);
        if (!makeGeoGridFlatField) {
            Array arr;
            block20: {
                System.err.println("making flat field");
                try {
                    LogUtil.message(readLabel);
                    Trace.call1("GeoGridAdapter.geogrid.readVolumeData");
                    System.err.println(System.currentTimeMillis() + " time:" + timeIndex + " start read");
                    arr = this.geoGrid.readDataSlice(0, ensIndex, timeIndex, -1, -1, -1);
                    System.err.println(System.currentTimeMillis() + " time:" + timeIndex + " end read");
                    Trace.call2("GeoGridAdapter.geogrid.readVolumeData");
                    if (arr.getRank() <= 2 || domainSet.getDimension() != 2) break block20;
                    int[] lengths = domainSet.getLengths();
                    int sizeX = lengths[0];
                    int sizeY = lengths[1];
                    int levelIndex = 0;
                    int[] shape = arr.getShape();
                    for (int i = 0; i <= arr.getRank(); ++i) {
                        if (shape[i] == sizeX || shape[i] == sizeY) continue;
                        arr = arr.slice(i, levelIndex);
                        break;
                    }
                }
                catch (RemoteException e) {
                    LogUtil.printException(log_, "getFlatField read got RemoteException", e);
                    return null;
                }
                catch (IOException e) {
                    LogUtil.printException(log_, "getFlatField read got IOException", e);
                    return null;
                }
            }
            float[][] fieldArray = new float[1][];
            float[] values = DataUtil.toFloatArray(arr);
            Class dataClass = arr.getElementType();
            if (!dataClass.equals(Float.TYPE) && !dataClass.equals(Double.TYPE)) {
                values = this.geoGrid.setMissingToNaN(values);
            }
            if (values.length < domainSet.getLength()) {
                float[] newValues = new float[domainSet.getLength()];
                int[] lengths = domainSet.getLengths();
                int l = 0;
                int sizeX = lengths[0];
                int sizeY = lengths[1];
                if (lengths.length == 2) {
                    for (int j = 0; j < sizeY; ++j) {
                        for (int i = 0; i < sizeX; ++i) {
                            int xpos = i < sizeX - 1 ? i : 0;
                            newValues[l++] = values[j * (sizeX - 1) + xpos];
                        }
                    }
                } else {
                    for (int k = 0; k < lengths[2]; ++k) {
                        for (int j = 0; j < sizeY; ++j) {
                            for (int i = 0; i < sizeX; ++i) {
                                int xpos = i < sizeX - 1 ? i : 0;
                                newValues[l++] = values[k * sizeY * (sizeX - 1) + j * (sizeX - 1) + xpos];
                            }
                        }
                    }
                }
                fieldArray[0] = newValues;
            } else {
                fieldArray[0] = values;
            }
            retField = new CachedFlatField(ffType, (Set)domainSet, fieldArray);
        } else {
            Object readLockToUse = this.dataSource.isLocalFile() ? this.readLock : new Object();
            GeoGridFlatField ggff = new GeoGridFlatField(this.geoGrid, readLockToUse, timeIndex, ensIndex, domainSet, ffType);
            ggff.setReadLabel(readLabel);
            retField = ggff;
        }
        this.dataSource.putCache(cacheKey, retField);
        Trace.call2("GeoGridAdapter.getFlatField:" + this.paramName + ":time=" + timeIndex);
        return retField;
    }

    private FieldImpl makeSequence(int[] timeIndices) {
        return this.makeSequence(timeIndices, null, null);
    }

    private FieldImpl makeSequence(int[] timeIndices, int[] memberIndices, Object loadId) {
        FieldImpl data = null;
        Trace.call1("GeoGridAdapter.makeSequence");
        try {
            int[] times;
            final TreeMap gridMap = new TreeMap();
            GridCoordSystem geoSys = this.geoGrid.getCoordinateSystem();
            CoordinateAxis1DTime timeAxis = geoSys.getTimeAxis1D();
            if (timeAxis == null && geoSys.getRunTimeAxis() != null) {
                timeAxis = geoSys.getRunTimeAxis();
            }
            List<CalendarDateTime> datetimes = null;
            if (timeAxis != null) {
                datetimes = DataUtil.makeDateTimes(timeAxis);
            }
            if (timeAxis == null) {
                times = new int[]{0};
            } else if (timeIndices == null) {
                int numTimes = (int)timeAxis.getSize();
                times = new int[numTimes];
                for (int i = 0; i < numTimes; ++i) {
                    times[i] = i;
                }
            } else {
                times = timeIndices;
            }
            final Range[][] sampleRanges = new Range[][]{null};
            StringBuffer testModeBuffer = null;
            ThreadManager threadManager = new ThreadManager("GeoGrid data reading");
            for (int i = 0; i < times.length; ++i) {
                CalendarDateTime time;
                if (!JobManager.getManager().canContinue(loadId)) {
                    return null;
                }
                if (times[i] < 0) continue;
                if (timeAxis != null) {
                    time = datetimes.get(times[i]);
                } else {
                    time = this.getBaseTime();
                    if (time == null) {
                        if (timeAxis == null) {
                            return this.getFlatField(0, "");
                        }
                        time = new CalendarDateTime();
                    }
                }
                log_.debug("  ...grid " + i);
                log_.debug("    data time " + time);
                final String readLabel = "Time: " + (i + 1) + "/" + times.length + " " + this.paramName + " From: " + this.dataSource.toString();
                final int theTimeIndex = times[i];
                final CalendarDateTime theTime = time;
                final int[] theMemberIndices = memberIndices;
                threadManager.addRunnable(new ThreadManager.MyRunnable(){

                    @Override
                    public void run() throws Exception {
                        GeoGridAdapter.this.readTimeStep(theTimeIndex, theTime, readLabel, gridMap, sampleRanges, GeoGridAdapter.this.lazyEvaluation, theMemberIndices);
                    }
                });
            }
            if (this.dataSource.getIdv() == null || this.dataSource.isLocalFile()) {
                threadManager.runSequentially();
            } else {
                threadManager.runInParallel(this.dataSource.getDataContext().getIdv().getMaxDataThreadCount());
            }
            log_.debug("    found " + gridMap.size() + " times");
            java.util.Set keySet = gridMap.keySet();
            if (gridMap.size() > 0) {
                CalendarDateTimeSet domain = CalendarDateTime.makeTimeSet(keySet.toArray(new CalendarDateTime[keySet.size()]));
                int i = 0;
                Iterator iter = keySet.iterator();
                while (iter.hasNext()) {
                    FieldImpl field = (FieldImpl)gridMap.get(iter.next());
                    if (i == 0) {
                        FunctionType fType = new FunctionType(RealType.Time, field.getType());
                        data = new FieldImpl(fType, domain);
                    }
                    data.setSample(i, (Data)field, false);
                    ++i;
                }
            } else if (testModeBuffer != null) {
                System.err.println(testModeBuffer.toString());
            }
        }
        catch (Exception e) {
            LogUtil.logException("Couldn't get data ", e);
        }
        Trace.call2("GeoGridAdapter.makeSequence");
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void readTimeStep(int timeIndex, CalendarDateTime time, String readLabel, TreeMap gridMap, Range[][] sampleRanges, boolean lazyEvaluation, int[] memberIndices) throws Exception {
        Dimension ensDim = this.geoGrid.getEnsembleDimension();
        Gridded1DSet ensSet = null;
        FieldImpl sample = null;
        int numEns = 1;
        if (memberIndices != null) {
            numEns = memberIndices.length;
            float[][] setVals = new float[1][numEns];
            for (int i = 0; i < numEns; ++i) {
                setVals[0][i] = memberIndices[i];
            }
            ensSet = new Gridded1DSet((MathType)GridUtil.ENSEMBLE_TYPE, setVals, numEns);
        } else if (ensDim != null && ensDim.getLength() > 1) {
            numEns = ensDim.getLength();
            ensSet = new Integer1DSet((MathType)GridUtil.ENSEMBLE_TYPE, numEns);
        }
        int i2 = 0;
        while (true) {
            CachedFlatField oneTime;
            block20: {
                block21: {
                    block19: {
                        if (i2 >= numEns) break block19;
                        int ii = i2;
                        if (memberIndices != null) {
                            ii = memberIndices[i2];
                        }
                        oneTime = this.getFlatField(timeIndex, ii, readLabel);
                        Range[][] rangeArray = sampleRanges;
                        // MONITORENTER : sampleRanges
                        if (sampleRanges[0] != null) break block20;
                        sampleRanges[0] = GridUtil.makeRanges(oneTime.getRanges(true));
                        if (sampleRanges[0] == null || sampleRanges[0].length <= 0) break block20;
                        break block21;
                    }
                    if (sample == null) return;
                    if (sample.isMissing()) return;
                    if (lazyEvaluation) {
                        TreeMap i2 = gridMap;
                        // MONITORENTER : i2
                        gridMap.put(time, sample);
                        // MONITOREXIT : i2
                        return;
                    }
                    Range range = GridUtil.getMinMax(sample)[0];
                    if (Double.isInfinite(range.getMin())) {
                        if (Double.isInfinite(range.getMax())) return;
                    }
                    TreeMap treeMap = gridMap;
                    // MONITORENTER : treeMap
                    gridMap.put(time, sample);
                    // MONITOREXIT : treeMap
                    return;
                }
                for (int rangeIdx = 0; rangeIdx < sampleRanges[0].length; ++rangeIdx) {
                    Range r = sampleRanges[0][rangeIdx];
                    if (r.getMin() != r.getMax() && !Double.isInfinite(r.getMin()) && !Double.isInfinite(r.getMax())) continue;
                    sampleRanges[0] = null;
                    break;
                }
            }
            // MONITOREXIT : rangeArray
            oneTime.setSampleRanges(GridUtil.makeDataRanges(sampleRanges[0]));
            if (numEns == 1) {
                sample = oneTime;
            } else {
                if (sample == null && oneTime != null) {
                    sample = new FieldImpl(new FunctionType(((SetType)ensSet.getType()).getDomain(), oneTime.getType()), ensSet);
                }
                if (oneTime != null) {
                    sample.setSample(i2, (Data)oneTime, false);
                }
            }
            ++i2;
        }
    }

    private RealType makeRealType(String name, Unit unit) throws VisADException {
        return DataUtil.makeRealType(name, unit);
    }

    private Unit getUnit(String uString) {
        Unit r = null;
        try {
            r = DataUtil.parseUnit(uString);
        }
        catch (Exception excp) {
            System.err.println("Unknown unit " + uString);
            r = null;
        }
        return r;
    }

    private Linear1DSet makeLinear1DSet(CoordinateAxis1D axis, RealType type) throws VisADException {
        return this.makeLinear1DSet(axis, type, null);
    }

    private Linear1DSet makeLinear1DSet(CoordinateAxis1D axis, RealType type, Unit u) throws VisADException {
        return this.makeLinear1DSet(axis, type, u, false);
    }

    private Linear1DSet makeLinear1DSet(CoordinateAxis1D axis, RealType type, Unit u, boolean extend) throws VisADException {
        Trace.call1("GeoGridAdapter.makeLinear1DSet");
        double start = axis.getCoordValue(0);
        double end = axis.getCoordValue((int)axis.getSize() - 1);
        if (extend) {
            end += axis.getIncrement();
        }
        int numPoints = (int)axis.getSize();
        if (extend) {
            ++numPoints;
        }
        Linear1DSet result = new Linear1DSet(type, start, end, numPoints, null, new Unit[]{u}, null, true);
        Trace.call2("GeoGridAdapter.makeLinear1DSet");
        return result;
    }

    private boolean checkLinearity(CoordinateAxis axis, boolean isLon) throws VisADException {
        if (axis.getRank() > 1) {
            return false;
        }
        if (axis.getSize() <= 1L) {
            return false;
        }
        if (!isLon && ((CoordinateAxis1D)axis).isRegular()) {
            return true;
        }
        ArithProg progChecker = isLon ? new LonArithProg() : new ArithProg();
        int i = 0;
        boolean linear = true;
        while ((long)i < axis.getSize() && linear) {
            linear = progChecker.accumulate(((CoordinateAxis1D)axis).getCoordValue(i));
            ++i;
        }
        return linear;
    }

    private CoordinateSystem makeElevationCS() throws VisADException {
        if (this.ncFile == null) {
            throw new VisADException("Unable to determine center point ");
        }
        Variable lat = this.ncFile.findVariable("sensor_latitude");
        Variable lon = this.ncFile.findVariable("sensor_longitude");
        Variable alt = this.ncFile.findVariable("sensor_altitude");
        if (lat == null || lon == null || alt == null) {
            throw new VisADException("Unable to find center point variables ");
        }
        Real latitude = this.makeReal(lat, RealType.Latitude);
        Real longitude = this.makeReal(lon, RealType.Longitude);
        Real altitude = this.makeReal(alt, RealType.Altitude);
        return new RadarGridCoordinateSystem(latitude.getValue(CommonUnit.degree), longitude.getValue(CommonUnit.degree), altitude.getValue(CommonUnit.meter));
    }

    private Real makeReal(Variable v, RealType rt) throws VisADException {
        double value;
        Unit unit;
        Attribute a = v.findAttribute("units");
        try {
            unit = a != null ? DataUtil.parseUnit(a.getStringValue()) : rt.getDefaultUnit();
            Array array = v.read();
            value = array.getDouble(array.getIndex());
        }
        catch (IOException ioe) {
            throw new VisADException("couldn't read varaible " + v);
        }
        catch (Exception pe) {
            throw new VisADException("couldn't parse unit " + a.getStringValue());
        }
        return new Real(rt, value, unit);
    }

    private CalendarDateTime getBaseTime() throws VisADException {
        Variable timeVar;
        CalendarDateTime time = null;
        if (this.ncFile != null && (timeVar = this.ncFile.findVariable("base_time")) != null) {
            try {
                time = new CalendarDateTime(new DateTime(this.makeReal(timeVar, RealType.Time)));
            }
            catch (VisADException visADException) {
                // empty catch block
            }
        }
        return time;
    }

    public static boolean isZAxisOk(CoordinateAxis1D zaxis) {
        return true;
    }

    public static boolean isZUnitOk(Unit zUnit, VerticalTransform vt) {
        return vt != null || zUnit != null && (Unit.canConvert(zUnit, CommonUnits.MILLIBAR) || Unit.canConvert(zUnit, CommonUnit.meter));
    }

    private boolean is2D(int sizeZ, Unit zUnit, VerticalTransform vt) {
        return sizeZ < 1 || sizeZ == 1 && !GeoGridAdapter.isZUnitOk(zUnit, vt);
    }
}

