/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.data.grid;

import java.rmi.RemoteException;
import java.util.List;
import ucar.unidata.data.DataUtil;
import ucar.unidata.data.grid.GridMath;
import ucar.unidata.data.grid.GridTrajectory;
import ucar.unidata.data.grid.GridUtil;
import ucar.unidata.data.point.PointObFactory;
import ucar.unidata.util.DateUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.Range;
import ucar.unidata.util.Trace;
import ucar.visad.UtcDate;
import ucar.visad.Util;
import ucar.visad.data.CalendarDateTime;
import ucar.visad.data.GeoGridFlatField;
import ucar.visad.data.GridCoverageFlatField;
import ucar.visad.quantities.AirPressure;
import ucar.visad.quantities.Altitude;
import ucar.visad.quantities.CommonUnits;
import ucar.visad.quantities.DewPoint;
import ucar.visad.quantities.Direction;
import ucar.visad.quantities.EquivalentPotentialTemperature;
import ucar.visad.quantities.GeopotentialAltitude;
import ucar.visad.quantities.Gravity;
import ucar.visad.quantities.GridRelativeHorizontalWind;
import ucar.visad.quantities.Length;
import ucar.visad.quantities.PotentialTemperature;
import ucar.visad.quantities.RelativeHumidity;
import ucar.visad.quantities.SaturationEquivalentPotentialTemperature;
import ucar.visad.quantities.SaturationMixingRatio;
import ucar.visad.quantities.SaturationVaporPressure;
import ucar.visad.quantities.WaterVaporMixingRatio;
import visad.CommonUnit;
import visad.CoordinateSystem;
import visad.Data;
import visad.DataImpl;
import visad.EarthVectorType;
import visad.Field;
import visad.FieldImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.Gridded1DDoubleSet;
import visad.Gridded1DSet;
import visad.Gridded2DSet;
import visad.Gridded3DSet;
import visad.GriddedSet;
import visad.Integer1DSet;
import visad.MathType;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.SI;
import visad.SampledSet;
import visad.ScaledUnit;
import visad.Set;
import visad.SetType;
import visad.SingletonSet;
import visad.TupleType;
import visad.Unit;
import visad.VisADException;
import visad.util.DataUtility;

public class DerivedGridFactory {
    public static final Real NEGATIVE_ONE = GridMath.NEGATIVE_ONE;
    public static final Real EARTH_RADIUS;
    public static final Real EARTH_TWO_OMEGA;
    public static final Real GRAVITY;
    public static final Unit CLIMATE_UNITS;
    private static final RealType ANOM_PERCENT_TYPE;

    public static FieldImpl ensembleAverage(FieldImpl grid) throws VisADException, RemoteException {
        return GridMath.applyFunctionOverMembers(grid, "average");
    }

    public static FieldImpl createThickness(FieldImpl grid) throws VisADException, RemoteException {
        return DerivedGridFactory.createLayerDifference(grid, 500.0, 1000.0, CommonUnits.HECTOPASCAL);
    }

    public static FieldImpl createLayerDifference(FieldImpl grid, String value1, String value2) throws VisADException, RemoteException {
        return DerivedGridFactory.createLayerDifference(grid, value1, value2, (String)null);
    }

    public static FieldImpl createLayerDifference(FieldImpl grid, String value1, String value2, String levelUnit) throws VisADException, RemoteException {
        return DerivedGridFactory.createLayerDifference(grid, Misc.parseNumber(value1), Misc.parseNumber(value2), levelUnit != null ? DataUtil.parseUnit(levelUnit) : (Unit)null);
    }

    public static FieldImpl createLayerDifference(FieldImpl grid, double value1, double value2) throws VisADException, RemoteException {
        return DerivedGridFactory.createLayerDifference(grid, value1, value2, null);
    }

    public static FieldImpl createLayerDifference(FieldImpl grid, double value1, double value2, Unit levelUnit) throws VisADException, RemoteException {
        RealType levelType = RealType.Generic;
        if (levelUnit != null) {
            if (Unit.canConvert(levelUnit, CommonUnits.HECTOPASCAL)) {
                levelType = AirPressure.getRealType();
            } else if (Unit.canConvert(levelUnit, CommonUnit.meter)) {
                levelType = RealType.Altitude;
            } else {
                levelUnit = null;
            }
        }
        Real level1 = levelUnit != null ? new Real(levelType, value1, levelUnit) : new Real(levelType, value1);
        Real level2 = levelUnit != null ? new Real(levelType, value2, levelUnit) : new Real(levelType, value2);
        FieldImpl first = GridUtil.make2DGridFromSlice(GridUtil.sliceAtLevel(grid, level1), false);
        FieldImpl second = GridUtil.make2DGridFromSlice(GridUtil.sliceAtLevel(grid, level2), false);
        TupleType paramType = GridUtil.getParamType(grid);
        FieldImpl result = (FieldImpl)first.subtract(second);
        if (paramType.getDimension() == 1) {
            RealType rt = (RealType)paramType.getComponent(0);
            String newName = rt.getName() + "_LDF_" + (int)value1 + "-" + (int)value2;
            RealTupleType rtt = new RealTupleType(DataUtil.makeRealType(newName, rt.getDefaultUnit()));
            result = GridUtil.setParamType(result, rtt, false);
        }
        return result;
    }

    public static FieldImpl createLayerAverage(FieldImpl grid, String value1, String value2) throws VisADException, RemoteException {
        return DerivedGridFactory.createLayerAverage(grid, value1, value2, (String)null);
    }

    public static FieldImpl createLayerAverage(FieldImpl grid, String value1, String value2, String levelUnit) throws VisADException, RemoteException {
        return DerivedGridFactory.createLayerAverage(grid, Misc.parseNumber(value1), Misc.parseNumber(value2), levelUnit != null ? DataUtil.parseUnit(levelUnit) : (Unit)null);
    }

    public static FieldImpl createLayerAverage(FieldImpl grid, double value1, double value2) throws VisADException, RemoteException {
        return DerivedGridFactory.createLayerAverage(grid, value1, value2, null);
    }

    public static FieldImpl createLayerAverage(FieldImpl grid, double value1, double value2, Unit levelUnit) throws VisADException, RemoteException {
        RealType levelType = RealType.Generic;
        if (levelUnit != null) {
            if (Unit.canConvert(levelUnit, CommonUnits.HECTOPASCAL)) {
                levelType = AirPressure.getRealType();
            } else if (Unit.canConvert(levelUnit, CommonUnit.meter)) {
                levelType = RealType.Altitude;
            } else {
                levelUnit = null;
            }
        }
        Real level1 = levelUnit != null ? new Real(levelType, value1, levelUnit) : new Real(levelType, value1);
        Real level2 = levelUnit != null ? new Real(levelType, value2, levelUnit) : new Real(levelType, value2);
        FieldImpl first = GridUtil.make2DGridFromSlice(GridUtil.sliceAtLevel(grid, level1), false);
        FieldImpl second = GridUtil.make2DGridFromSlice(GridUtil.sliceAtLevel(grid, level2), false);
        TupleType paramType = GridUtil.getParamType(grid);
        FieldImpl result = (FieldImpl)first.add(second).divide(new Real(2.0));
        if (paramType.getDimension() == 1) {
            RealType rt = (RealType)paramType.getComponent(0);
            String newName = rt.getName() + "_LAV_" + (int)value1 + "-" + (int)value2;
            RealTupleType rtt = new RealTupleType(DataUtil.makeRealType(newName, rt.getDefaultUnit()));
            result = GridUtil.setParamType(result, rtt, false);
        }
        return result;
    }

    public static FieldImpl createRelativeVorticity(FieldImpl uFI, FieldImpl vFI) throws VisADException, RemoteException {
        boolean UisSequence = GridUtil.isTimeSequence(uFI);
        boolean VisSequence = GridUtil.isTimeSequence(vFI);
        FieldImpl rvFI = null;
        FlatField dvdx = null;
        FlatField dudy = null;
        FlatField rvFF = null;
        FlatField uFF = null;
        FlatField vFF = null;
        Object rvFFType = null;
        if (UisSequence) {
            Set timeSet = uFI.getDomainSet();
            Boolean ensble = GridUtil.hasEnsemble(uFI);
            if (timeSet.getLength() > 1 && VisSequence) {
                vFI = (FieldImpl)vFI.resample(timeSet);
            }
            Object rvRT = null;
            TupleType rangeType = null;
            FunctionType innerType = null;
            for (int i = 0; i < timeSet.getLength(); ++i) {
                DataImpl funcFF = null;
                if (ensble.booleanValue()) {
                    FieldImpl sample1 = (FieldImpl)uFI.getSample(i);
                    FieldImpl sample2 = (FieldImpl)vFI.getSample(i);
                    Set ensDomain = sample1.getDomainSet();
                    for (int j = 0; j < ensDomain.getLength(); ++j) {
                        FlatField innerField1 = (FlatField)sample1.getSample(j, false);
                        FlatField innerField2 = (FlatField)sample2.getSample(j, false);
                        if (innerField1 == null || innerField2 == null) continue;
                        dudy = (FlatField)GridMath.ddy(innerField1);
                        dvdx = (FlatField)GridMath.ddx(innerField2);
                        FlatField innerrvFF = (FlatField)dvdx.subtract(dudy);
                        if (rangeType == null) {
                            rangeType = GridUtil.getParamType(innerrvFF);
                            innerType = new FunctionType(DataUtility.getDomainType(ensDomain), innerrvFF.getType());
                        }
                        if (j == 0) {
                            funcFF = new FieldImpl(innerType, ensDomain);
                        }
                        ((FieldImpl)funcFF).setSample(j, innerrvFF, false);
                    }
                    if (rvFI == null) {
                        FunctionType newFieldType = new FunctionType(((SetType)timeSet.getType()).getDomain(), funcFF.getType());
                        rvFI = new FieldImpl(newFieldType, timeSet);
                    }
                    rvFI.setSample(i, funcFF, false);
                    continue;
                }
                uFF = (FlatField)uFI.getSample(i);
                vFF = (FlatField)vFI.getSample(i);
                dudy = (FlatField)GridMath.ddy(uFF);
                dvdx = (FlatField)GridMath.ddx(vFF);
                rvFF = (FlatField)dvdx.subtract(dudy);
                if (i == 0) {
                    FunctionType functionType = new FunctionType(((FunctionType)uFI.getType()).getDomain(), rvFF.getType());
                    rvFI = new FieldImpl(functionType, timeSet);
                }
                rvFI.setSample(i, (Data)rvFF, false);
            }
        } else {
            rvFI = (FieldImpl)GridMath.ddx(vFF).subtract(GridMath.ddy(uFF));
        }
        Unit rvUnit = GridUtil.getParamUnits(rvFI)[0];
        RealType rvRT = DataUtil.makeRealType("relvorticity", rvUnit);
        return GridUtil.setParamType(rvFI, rvRT, false);
    }

    public static FieldImpl relativeVorticityFromTrueWind(FieldImpl uFI, FieldImpl vFI) throws VisADException, RemoteException {
        FieldImpl trueWind = DerivedGridFactory.createTrueFlowVectors(uFI, vFI);
        return DerivedGridFactory.createRelativeVorticity(DerivedGridFactory.getUComponent(trueWind), DerivedGridFactory.getVComponent(trueWind));
    }

    private static RealType findComponent(RealTupleType rtt, String prefix, RealType template) throws VisADException, RemoteException {
        int n = rtt.getDimension();
        for (int i = 0; i < n; ++i) {
            RealType rt = (RealType)rtt.getComponent(i);
            if (!rt.getName().toLowerCase().startsWith(prefix) || !rt.equalsExceptNameButUnits(template)) continue;
            return rt;
        }
        return null;
    }

    public static FieldImpl createAbsoluteVorticity(FieldImpl uFI, FieldImpl vFI) throws VisADException, RemoteException {
        FieldImpl relVor = DerivedGridFactory.createRelativeVorticity(uFI, vFI);
        FieldImpl corl = DerivedGridFactory.createCoriolisGrid(relVor);
        FieldImpl avFI = (FieldImpl)relVor.add(corl);
        Unit avUnit = GridUtil.getParamUnits(avFI)[0];
        RealType avRT = DataUtil.makeRealType("absvorticity", avUnit);
        return GridUtil.setParamType(avFI, avRT, false);
    }

    public static FieldImpl createTrueWindVectors(FieldImpl uGrid, FieldImpl vGrid) throws VisADException, RemoteException {
        return DerivedGridFactory.createTrueFlowVectors(uGrid, vGrid);
    }

    public static FieldImpl createTrueFlowVectors(FieldImpl uGrid, FieldImpl vGrid, FieldImpl wGrid) throws VisADException, RemoteException {
        FieldImpl w;
        Unit rgUnit = ((FlatField)wGrid.getSample(0)).getRangeUnits()[0][0];
        if (Unit.canConvert(rgUnit, CommonUnits.METERS_PER_SECOND)) {
            w = wGrid;
        } else {
            FlatField pFI = DerivedGridFactory.createPressureGridFromDomain((FlatField)wGrid.getSample(0));
            FieldImpl hPI = DerivedGridFactory.convertPressureToHeight(pFI);
            w = DerivedGridFactory.convertPressureVelocityToHeightVelocity(wGrid, hPI, null);
        }
        SampledSet wDomain = GridUtil.getSpatialDomain(w);
        if (!wDomain.equals(GridUtil.getSpatialDomain(uGrid))) {
            uGrid = GridUtil.resampleGrid(uGrid, wDomain);
            vGrid = GridUtil.resampleGrid(vGrid, wDomain);
        }
        FieldImpl uvg = DerivedGridFactory.createTrueFlowVectors(uGrid, vGrid);
        FieldImpl uuGrid = DerivedGridFactory.getUComponent(uvg);
        FieldImpl vvGrid = DerivedGridFactory.getVComponent(uvg);
        FieldImpl uvwGrid = DerivedGridFactory.combineGrids(new FieldImpl[]{uuGrid, vvGrid, w}, 101, 202, true);
        TupleType paramType = GridUtil.getParamType(uvwGrid);
        RealType[] reals = Util.ensureUnit(paramType.getRealComponents(), CommonUnit.meterPerSecond);
        EarthVectorType earthVectorType = new EarthVectorType(reals[0], reals[1], reals[2]);
        return GridUtil.setParamType(uvwGrid, earthVectorType, false);
    }

    public static FieldImpl createTrueFlowVectors(FieldImpl uGrid, FieldImpl vGrid) throws VisADException, RemoteException {
        FieldImpl uvGrid = DerivedGridFactory.createFlowVectors(uGrid, vGrid);
        return DerivedGridFactory.createTrueFlowVector(uvGrid);
    }

    public static FieldImpl createTrueFlowVector0(FieldImpl uvGrid) throws VisADException, RemoteException {
        if (!DerivedGridFactory.isVector(uvGrid)) {
            throw new VisADException("Not a vector grid " + GridUtil.getParamType(uvGrid));
        }
        Trace.call1("DGF:createTrueFlowVector");
        FieldImpl result = (FieldImpl)GridRelativeHorizontalWind.cartesianHorizontalWind(uvGrid);
        Trace.call2("DGF:createTrueFlowVector");
        return result;
    }

    public static FieldImpl createTrueFlowVector(FieldImpl uvGrid) throws VisADException, RemoteException {
        if (!DerivedGridFactory.isVector(uvGrid)) {
            throw new VisADException("Not a vector grid " + GridUtil.getParamType(uvGrid));
        }
        FieldImpl result = null;
        Trace.call1("DGF:createTrueFlowVector");
        Boolean ensble = GridUtil.hasEnsemble(uvGrid);
        if (ensble.booleanValue()) {
            FunctionType outerFuncType = (FunctionType)uvGrid.getType();
            Set timeSet = uvGrid.getDomainSet();
            TupleType rangeType = null;
            FunctionType innerType = null;
            FunctionType newinnerType = null;
            for (int i = 0; i < timeSet.getLength(); ++i) {
                DataImpl funcFF = null;
                FieldImpl funcFF0 = null;
                FieldImpl sample = (FieldImpl)uvGrid.getSample(i);
                Set ensDomain = sample.getDomainSet();
                for (int j = 0; j < ensDomain.getLength(); ++j) {
                    FieldImpl innerField = (FieldImpl)sample.getSample(j, false);
                    if (innerField == null) continue;
                    if (newinnerType == null) {
                        newinnerType = new FunctionType(((SetType)timeSet.getType()).getDomain(), innerField.getType());
                    }
                    RealType index = RealType.getRealType("index");
                    SingletonSet ss = new SingletonSet(new RealTuple(new Real[]{new Real(index, 0.0)}));
                    funcFF0 = new FieldImpl(newinnerType, ss);
                    funcFF0.setSample(0, (Data)innerField, false);
                    FieldImpl innerrvFF = (FieldImpl)GridRelativeHorizontalWind.cartesianHorizontalWind(funcFF0);
                    if (rangeType == null) {
                        rangeType = GridUtil.getParamType(innerrvFF);
                        innerType = new FunctionType(DataUtility.getDomainType(ensDomain), innerrvFF.getSample(0).getType());
                    }
                    if (funcFF == null) {
                        funcFF = new FieldImpl(innerType, ensDomain);
                    }
                    ((FieldImpl)funcFF).setSample(j, innerrvFF.getSample(0), false);
                }
                if (result == null) {
                    FunctionType newFieldType = new FunctionType(((SetType)timeSet.getType()).getDomain(), funcFF.getType());
                    result = new FieldImpl(newFieldType, timeSet);
                }
                result.setSample(i, funcFF, false);
            }
        } else {
            result = (FieldImpl)GridRelativeHorizontalWind.cartesianHorizontalWind(uvGrid);
        }
        Trace.call2("DGF:createTrueFlowVector");
        return result;
    }

    public static FieldImpl createWindVectors(FieldImpl uGrid, FieldImpl vGrid) throws VisADException, RemoteException {
        return DerivedGridFactory.createFlowVectors(uGrid, vGrid);
    }

    public static FieldImpl createGeostrophicWindVector(FieldImpl paramFI) throws VisADException, RemoteException {
        Unit u = GridUtil.getParamUnits(paramFI)[0];
        if (u.equals(GeopotentialAltitude.getGeopotentialMeter())) {
            paramFI = (FieldImpl)paramFI.divide(GRAVITY);
        }
        FieldImpl corl = DerivedGridFactory.createCoriolisGrid(paramFI);
        FieldImpl ug = (FieldImpl)GridMath.ddy(paramFI).multiply(GRAVITY);
        ug = (FieldImpl)ug.divide(corl).negate();
        ug = GridUtil.setParamType(ug, "ugeo");
        FieldImpl vg = (FieldImpl)GridMath.ddx(paramFI).multiply(GRAVITY);
        vg = (FieldImpl)vg.divide(corl);
        vg = GridUtil.setParamType(vg, "vgeo");
        return DerivedGridFactory.createFlowVectors(ug, vg);
    }

    public static FieldImpl create2DTopography(FieldImpl paramGrid, FieldImpl topoGrid) throws VisADException, RemoteException {
        return DerivedGridFactory.create2DTopography(paramGrid, topoGrid, false);
    }

    public static FieldImpl create2DTopography(FieldImpl paramGrid, FieldImpl topoGrid, boolean resampleToTopography) throws VisADException, RemoteException {
        FieldImpl grid = paramGrid;
        TupleType tt = GridUtil.getParamType(topoGrid);
        RealType rt = tt.getRealComponents()[0];
        Unit topoUnit = rt.getDefaultUnit();
        if (Unit.canConvert(topoUnit, CommonUnits.MILLIBAR) && tt.getDimension() == 1) {
            topoGrid = DerivedGridFactory.convertPressureToHeight(topoGrid);
        }
        if (!Unit.canConvert(topoUnit, GeopotentialAltitude.getGeopotentialMeter()) && !Unit.canConvert(topoUnit, CommonUnit.meter)) {
            throw new VisADException("topography units " + topoUnit + " must convertible with m or gpm");
        }
        if (MathType.findScalarType(GridUtil.getParamType(paramGrid), rt)) {
            return paramGrid;
        }
        SampledSet topoDomain = GridUtil.getSpatialDomain(topoGrid);
        SampledSet paramDomain = GridUtil.getSpatialDomain(paramGrid);
        if (topoDomain.getDimension() == 2 && paramDomain.getDimension() == 3 && ((Set)paramDomain).getManifoldDimension() == 2) {
            grid = GridUtil.make2DGridFromSlice(paramGrid, true);
            paramDomain = GridUtil.getSpatialDomain(grid);
        } else if (paramDomain.getDimension() == 2 && topoDomain.getDimension() == 3 && ((Set)topoDomain).getManifoldDimension() == 2) {
            topoGrid = GridUtil.make2DGridFromSlice(topoGrid, true);
            topoDomain = GridUtil.getSpatialDomain(topoGrid);
        } else if (paramDomain.getDimension() == 3 && ((Set)paramDomain).getManifoldDimension() == 2 && topoDomain.getDimension() == 3 && ((Set)topoDomain).getManifoldDimension() == 2 && !topoDomain.equals(paramDomain)) {
            grid = GridUtil.make2DGridFromSlice(paramGrid, true);
            paramDomain = GridUtil.getSpatialDomain(grid);
            topoGrid = GridUtil.make2DGridFromSlice(topoGrid, true);
            topoDomain = GridUtil.getSpatialDomain(topoGrid);
        }
        RealTupleType paramRef = null;
        RealTupleType topoRef = null;
        paramRef = paramDomain.getCoordinateSystem() != null ? paramDomain.getCoordinateSystem().getReference() : ((SetType)paramDomain.getType()).getDomain();
        topoRef = topoDomain.getCoordinateSystem() != null ? topoDomain.getCoordinateSystem().getReference() : ((SetType)topoDomain.getType()).getDomain();
        if (!paramRef.equals(topoRef) && topoDomain.getCoordinateSystem() == null && (topoRef.equals(RealTupleType.SpatialEarth2DTuple) || topoRef.equals(RealTupleType.LatitudeLongitudeTuple))) {
            topoGrid = GridUtil.swapLatLon(topoGrid);
        }
        if (resampleToTopography) {
            grid = GridUtil.resampleGrid(grid, GridUtil.getSpatialDomain(topoGrid));
        }
        return DerivedGridFactory.combineGrids(grid, topoGrid);
    }

    public static FieldImpl convertPressureToHeight(FieldImpl pressureField) throws VisADException, RemoteException {
        return DerivedGridFactory.convertPressureToHeight(pressureField, DataUtil.getPressureToHeightCS("ucar.visad.quantities.AirPressure$StandardAtmosphereCoordinateSystem"));
    }

    public static FieldImpl convertPressureToHeight(FieldImpl pressureField, CoordinateSystem pressToHeightCS) throws VisADException, RemoteException {
        FieldImpl heightGrid;
        TupleType tt = GridUtil.getParamType(pressureField);
        RealType rt = tt.getRealComponents()[0];
        Unit pressUnit = rt.getDefaultUnit();
        if (!Unit.canConvert(pressUnit, CommonUnits.MILLIBAR) || tt.getDimension() != 1) {
            throw new VisADException("Pressure field must have units convertible with hPa and have only one range type");
        }
        if (pressToHeightCS == null) {
            pressToHeightCS = DataUtil.getPressureToHeightCS("ucar.visad.quantities.AirPressure$StandardAtmosphereCoordinateSystem");
        }
        if (GridUtil.isSequence(heightGrid = GridUtil.setParamType(pressureField, RealType.getRealType("topo", CommonUnit.meter)))) {
            Set seqSet = heightGrid.getDomainSet();
            for (int i = 0; i < seqSet.getLength(); ++i) {
                FlatField ff = (FlatField)heightGrid.getSample(i, false);
                float[][] pressVals = ff.getFloats();
                float[][] heightVals = pressToHeightCS.toReference(pressVals, new Unit[]{pressUnit});
                ff.setSamples(heightVals, false);
            }
        } else {
            float[][] pressVals = heightGrid.getFloats();
            float[][] heightVals = pressToHeightCS.toReference(pressVals, new Unit[]{pressUnit});
            ((FlatField)heightGrid).setSamples(heightVals, false);
        }
        return heightGrid;
    }

    public static FieldImpl convertPressureVelocityToHeightVelocity(FieldImpl wGrid) throws VisADException, RemoteException {
        FieldImpl w;
        Unit rgUnit = ((FlatField)wGrid.getSample(0)).getRangeUnits()[0][0];
        if (Unit.canConvert(rgUnit, CommonUnits.METERS_PER_SECOND)) {
            w = wGrid;
        } else {
            FlatField pFI = DerivedGridFactory.createPressureGridFromDomain((FlatField)wGrid.getSample(0));
            FieldImpl hPI = DerivedGridFactory.convertPressureToHeight(pFI);
            w = DerivedGridFactory.convertPressureVelocityToHeightVelocity(wGrid, hPI, null);
        }
        return w;
    }

    public static FieldImpl convertPressureVelocityToHeightVelocity2(FieldImpl wGrid, FieldImpl tGrid) throws VisADException, RemoteException {
        Unit wUnit = GridUtil.getParamUnits(wGrid)[0];
        Unit tempUnit = GridUtil.getParamUnits(tGrid)[0];
        FieldImpl pFI = DerivedGridFactory.createPressureGridFromDomain((FlatField)tGrid.getSample(0));
        Unit pUnit = GridUtil.getParamUnits(pFI)[0];
        if (!wUnit.getIdentifier().equals("Pa/s")) {
            Unit newWUnit = Util.parseUnit("Pa/s");
            RealType newType = Util.makeRealType("newVerticalVelocity", newWUnit);
            wGrid = GridUtil.setParamType(wGrid, newType, true);
        }
        if (!tempUnit.equals(SI.kelvin)) {
            RealType newType1 = Util.makeRealType("newTemperature", SI.kelvin);
            tGrid = GridUtil.setParamType(tGrid, newType1, true);
        }
        if (!pUnit.equals(CommonUnits.PASCAL)) {
            RealType newType2 = Util.makeRealType("newPressure", CommonUnits.PASCAL);
            pFI = GridUtil.setParamType(pFI, newType2, true);
        }
        FieldImpl w = (FieldImpl)GridMath.divide(GridMath.multiply(tGrid, wGrid), pFI).multiply(new Real(-29.28));
        RealType newType2 = Util.makeRealType("newW", CommonUnits.METERS_PER_SECOND);
        return GridUtil.setParamType(w, newType2, true);
    }

    public static FieldImpl convertPressureVelocityToHeightVelocity(FieldImpl pressureVelField, FieldImpl hField, CoordinateSystem pressToHeightCS) throws VisADException, RemoteException {
        Unit zUnit;
        FieldImpl dhdt;
        FieldImpl heightGrid;
        FieldImpl dhdp;
        Unit dunit;
        TupleType tt = GridUtil.getParamType(pressureVelField);
        RealType rt = tt.getRealComponents()[0];
        Unit pressUnit = rt.getDefaultUnit().multiply(CommonUnit.second);
        if (Unit.canConvert(pressUnit, CommonUnit.meter)) {
            return pressureVelField;
        }
        if (!Unit.canConvert(pressUnit, CommonUnits.MILLIBAR) || tt.getDimension() != 1) {
            throw new VisADException("Pressure velocity field must have units convertible with hPa and have only one range type");
        }
        if (pressToHeightCS == null) {
            pressToHeightCS = DataUtil.getPressureToHeightCS("ucar.visad.quantities.AirPressure$StandardAtmosphereCoordinateSystem");
        }
        if ((dunit = (dhdp = GridMath.partial(hField, 2)).getDefaultRangeUnits()[0]) instanceof ScaledUnit) {
            ScaledUnit scaledUnit = (ScaledUnit)dunit;
            Unit rUnit = scaledUnit.getUnit();
            dhdp = GridUtil.setParamType(dhdp, RealType.getRealType("ddp", rUnit));
        }
        if (GridUtil.isSequence(heightGrid = GridUtil.setParamType(dhdt = GridMath.multiply(pressureVelField, dhdp), RealType.getRealType("zVel", zUnit = CommonUnits.METERS_PER_SECOND)))) {
            Set seqSet = heightGrid.getDomainSet();
            for (int i = 0; i < seqSet.getLength(); ++i) {
                FlatField ff = (FlatField)heightGrid.getSample(i, false);
                FlatField fd = (FlatField)GridUtil.setParamType((FieldImpl)ff, RealType.getRealType("zVel", zUnit));
                float[][] pressVals = fd.getFloats();
                fd.setSamples(pressVals, false);
            }
        } else {
            float[][] pressVals = heightGrid.getFloats();
            ((FlatField)heightGrid).setSamples(pressVals, false);
        }
        return heightGrid;
    }

    public static FieldImpl createFlowVectors(FieldImpl uGrid, FieldImpl vGrid) throws VisADException, RemoteException {
        FieldImpl uvGrid;
        FieldImpl retGrid = uvGrid = DerivedGridFactory.combineGrids(uGrid, vGrid, true);
        Unit[] units = GridUtil.getParamUnits(uvGrid);
        boolean isFlowUnits = true;
        for (int i = 0; i < units.length; ++i) {
            Unit u = units[i];
            boolean bl = isFlowUnits = u == null || Unit.canConvert(u, CommonUnit.meterPerSecond);
            if (!isFlowUnits) break;
        }
        if (isFlowUnits) {
            TupleType paramType = GridUtil.getParamType(uvGrid);
            RealType[] reals = Util.ensureUnit(paramType.getRealComponents(), CommonUnit.meterPerSecond);
            EarthVectorType earthVectorType = new EarthVectorType(reals[0], reals[1]);
            retGrid = GridUtil.setParamType(uvGrid, earthVectorType, false);
        }
        return retGrid;
    }

    public static FieldImpl createFlowVectors(FieldImpl uGrid, FieldImpl vGrid, FieldImpl wGrid) throws VisADException, RemoteException {
        FieldImpl uvwGrid = DerivedGridFactory.combineGrids(new FieldImpl[]{uGrid, vGrid, wGrid}, true);
        TupleType paramType = GridUtil.getParamType(uvwGrid);
        RealType[] reals = Util.ensureUnit(paramType.getRealComponents(), CommonUnit.meterPerSecond);
        EarthVectorType earthVectorType = new EarthVectorType(reals[0], reals[1], reals[2]);
        return GridUtil.setParamType(uvwGrid, earthVectorType, false);
    }

    public static FieldImpl createFlowVectorsN(FieldImpl uGrid, FieldImpl vGrid, FieldImpl wGrid) throws VisADException, RemoteException {
        FieldImpl w;
        Unit rgUnit = ((FlatField)wGrid.getSample(0)).getRangeUnits()[0][0];
        if (Unit.canConvert(rgUnit, CommonUnits.METERS_PER_SECOND)) {
            w = wGrid;
        } else {
            FlatField pFI = DerivedGridFactory.createPressureGridFromDomain((FlatField)wGrid.getSample(0));
            FieldImpl hPI = DerivedGridFactory.convertPressureToHeight(pFI);
            w = DerivedGridFactory.convertPressureVelocityToHeightVelocity(wGrid, hPI, null);
        }
        SampledSet wDomain = GridUtil.getSpatialDomain(w);
        if (!wDomain.equals(GridUtil.getSpatialDomain(uGrid))) {
            uGrid = GridUtil.resampleGrid(uGrid, wDomain);
            vGrid = GridUtil.resampleGrid(vGrid, wDomain);
        }
        FieldImpl uvwGrid = DerivedGridFactory.combineGrids(new FieldImpl[]{uGrid, vGrid, w}, 101, 202, true);
        TupleType paramType = GridUtil.getParamType(uvwGrid);
        RealType[] reals = Util.ensureUnit(paramType.getRealComponents(), CommonUnit.meterPerSecond);
        EarthVectorType earthVectorType = new EarthVectorType(reals[0], reals[1], reals[2]);
        return GridUtil.setParamType(uvwGrid, earthVectorType, false);
    }

    public static List<FieldImpl> createFlowVectorsNA(FieldImpl uGrid, FieldImpl vGrid, FieldImpl wGrid, FieldImpl topo) throws VisADException, RemoteException, Exception {
        FieldImpl w = DerivedGridFactory.createFlowVectorsN(uGrid, vGrid, wGrid);
        return GridTrajectory.combineGridsArray(w, topo);
    }

    public static FieldImpl createFlowVectorsN(FieldImpl uGrid, FieldImpl vGrid) throws VisADException, RemoteException {
        FieldImpl uvGrid = DerivedGridFactory.combineGrids(new FieldImpl[]{uGrid, vGrid}, 101, 202, true);
        TupleType paramType = GridUtil.getParamType(uvGrid);
        RealType[] reals = Util.ensureUnit(paramType.getRealComponents(), CommonUnit.meterPerSecond);
        EarthVectorType earthVectorType = new EarthVectorType(reals[0], reals[1]);
        return GridUtil.setParamType(uvGrid, earthVectorType, false);
    }

    public static FieldImpl createFlowVectorsN1(FieldImpl wGrid) throws VisADException, RemoteException {
        FieldImpl w;
        Unit rgUnit = ((FlatField)wGrid.getSample(0)).getRangeUnits()[0][0];
        if (Unit.canConvert(rgUnit, CommonUnits.METERS_PER_SECOND)) {
            w = wGrid;
        } else {
            FlatField pFI = DerivedGridFactory.createPressureGridFromDomain((FlatField)wGrid.getSample(0));
            FieldImpl hPI = DerivedGridFactory.convertPressureToHeight(pFI);
            w = DerivedGridFactory.convertPressureVelocityToHeightVelocity(wGrid, hPI, null);
        }
        return w;
    }

    public static FieldImpl combineGrids(FieldImpl[] grids) throws VisADException, RemoteException {
        return DerivedGridFactory.combineGrids(grids, false);
    }

    public static FieldImpl combineGrids(FieldImpl[] grids, boolean flatten) throws VisADException, RemoteException {
        return DerivedGridFactory.combineGrids(grids, 101, 202, flatten);
    }

    public static FieldImpl combineGrids(FieldImpl[] grids, int samplingMode, int errorMode, boolean flatten) throws VisADException, RemoteException {
        if (grids.length < 2) {
            throw new IllegalArgumentException("must have at least 2 grids for this method");
        }
        FieldImpl outGrid = grids[0];
        for (int i = 1; i < grids.length; ++i) {
            outGrid = DerivedGridFactory.combineGrids(outGrid, grids[i], samplingMode, errorMode, flatten);
        }
        return outGrid;
    }

    public static FieldImpl combineGridsR(FieldImpl[] grids, int samplingMode, int errorMode, boolean flatten) throws VisADException, RemoteException {
        if (grids.length < 2) {
            throw new IllegalArgumentException("must have at least 2 grids for this method");
        }
        FieldImpl outGrid = grids[grids.length - 1];
        for (int i = grids.length - 2; i >= 0; --i) {
            outGrid = DerivedGridFactory.combineGrids(outGrid, grids[i], samplingMode, errorMode, flatten);
        }
        return outGrid;
    }

    public static FieldImpl combineGrids(FieldImpl grid1, FieldImpl grid2, FieldImpl grid3) throws VisADException, RemoteException {
        return DerivedGridFactory.combineGrids(new FieldImpl[]{grid1, grid2, grid3});
    }

    public static FieldImpl combineGrids(FieldImpl grid1, FieldImpl grid2) throws VisADException, RemoteException {
        return DerivedGridFactory.combineGrids(grid1, grid2, false);
    }

    public static FieldImpl combineGridsN(FieldImpl grid1, FieldImpl grid2) throws VisADException, RemoteException {
        SampledSet grid1Domain = GridUtil.getSpatialDomain(grid1);
        if (!grid1Domain.equals(GridUtil.getSpatialDomain(grid2))) {
            grid2 = GridUtil.resampleGrid(grid2, grid1Domain);
        }
        return DerivedGridFactory.combineGrids(grid1, grid2, false);
    }

    public static FieldImpl combineGrids(FieldImpl grid1, FieldImpl grid2, boolean flatten) throws VisADException, RemoteException {
        return DerivedGridFactory.combineGrids(grid1, grid2, 101, 202, flatten);
    }

    public static FieldImpl combineGrids(FieldImpl grid1, FieldImpl grid2, int samplingMode, int errorMode, boolean flatten) throws VisADException, RemoteException {
        return DerivedGridFactory.combineGrids(grid1, grid2, samplingMode, errorMode, flatten, false);
    }

    public static FieldImpl combineGrids(FieldImpl grid1, FieldImpl grid2, int samplingMode, int errorMode, boolean flatten, boolean copy) throws VisADException, RemoteException {
        boolean isGrid1Sequence = GridUtil.isTimeSequence(grid1);
        boolean isGrid2Sequence = GridUtil.isTimeSequence(grid2);
        boolean isBothSequence = isGrid2Sequence && isGrid1Sequence;
        boolean isOnlyOneSequence = isGrid2Sequence || isGrid1Sequence;
        FieldImpl wvFI = null;
        if (isBothSequence) {
            Set timeSet = grid1.getDomainSet();
            Boolean ensble = GridUtil.hasEnsemble(grid1);
            if (timeSet.getLength() > 1) {
                grid2 = (FieldImpl)grid2.resample(timeSet);
            }
            TupleType rangeType = null;
            FunctionType innerType = null;
            for (int i = 0; i < timeSet.getLength(); ++i) {
                DataImpl funcFF = null;
                if (ensble.booleanValue()) {
                    FieldImpl sample1 = (FieldImpl)grid1.getSample(i);
                    FieldImpl sample2 = (FieldImpl)grid2.getSample(i);
                    Set ensDomain = sample1.getDomainSet();
                    for (int j = 0; j < ensDomain.getLength(); ++j) {
                        FlatField innerField1 = (FlatField)sample1.getSample(j, false);
                        FlatField innerField2 = (FlatField)sample2.getSample(j, false);
                        if (innerField1 == null || innerField2 == null) continue;
                        FlatField innerwvFF = (FlatField)FieldImpl.combine(new Field[]{innerField1, innerField2}, samplingMode, errorMode, flatten, copy);
                        if (rangeType == null) {
                            rangeType = GridUtil.getParamType(innerwvFF);
                            innerType = new FunctionType(DataUtility.getDomainType(ensDomain), innerwvFF.getType());
                        }
                        if (j == 0) {
                            funcFF = new FieldImpl(innerType, ensDomain);
                        }
                        ((FieldImpl)funcFF).setSample(j, innerwvFF, false);
                    }
                    if (wvFI == null) {
                        FunctionType newFieldType = new FunctionType(((SetType)timeSet.getType()).getDomain(), funcFF.getType());
                        wvFI = new FieldImpl(newFieldType, timeSet);
                    }
                    wvFI.setSample(i, funcFF, false);
                    continue;
                }
                FlatField wvFF = (FlatField)FieldImpl.combine(new Field[]{(FlatField)grid1.getSample(i), (FlatField)grid2.getSample(i)}, samplingMode, errorMode, flatten, copy);
                if (i == 0) {
                    FunctionType functionType = new FunctionType(((FunctionType)grid1.getType()).getDomain(), wvFF.getType());
                    wvFI = new FieldImpl(functionType, timeSet);
                }
                wvFI.setSample(i, (Data)wvFF, false);
            }
        } else if (isOnlyOneSequence) {
            FieldImpl sequenceGrid = isGrid1Sequence ? grid1 : grid2;
            FieldImpl otherGrid = sequenceGrid == grid1 ? grid2 : grid1;
            Set timeSet = sequenceGrid.getDomainSet();
            for (int i = 0; i < timeSet.getLength(); ++i) {
                Field[] fieldArray;
                if (grid1 == sequenceGrid) {
                    Field[] fieldArray2 = new Field[2];
                    fieldArray2[0] = (FlatField)grid1.getSample(i);
                    fieldArray = fieldArray2;
                    fieldArray2[1] = (FlatField)otherGrid;
                } else {
                    Field[] fieldArray3 = new Field[2];
                    fieldArray3[0] = (FlatField)otherGrid;
                    fieldArray = fieldArray3;
                    fieldArray3[1] = (FlatField)grid2.getSample(i);
                }
                FlatField wvFF = (FlatField)FieldImpl.combine(fieldArray, samplingMode, errorMode, flatten, copy);
                if (i == 0) {
                    FunctionType functionType = new FunctionType(((FunctionType)sequenceGrid.getType()).getDomain(), wvFF.getType());
                    wvFI = new FieldImpl(functionType, timeSet);
                }
                wvFI.setSample(i, (Data)wvFF, false);
            }
        } else {
            wvFI = (FieldImpl)FieldImpl.combine(new Field[]{grid1, grid2}, samplingMode, errorMode, flatten, copy);
        }
        return wvFI;
    }

    public static FieldImpl createWindSpeed(FieldImpl uFI, FieldImpl vFI) throws VisADException, RemoteException {
        return DerivedGridFactory.createVectorMagnitude(uFI, vFI, "WindSpeed");
    }

    public static FieldImpl createVectorMagnitude(FieldImpl uFI, FieldImpl vFI) throws VisADException, RemoteException {
        return DerivedGridFactory.createVectorMagnitude(uFI, vFI, "vector_mag");
    }

    public static FieldImpl createVectorMagnitude(FieldImpl vector) throws VisADException, RemoteException {
        if (!DerivedGridFactory.isVector(vector)) {
            throw new VisADException("Not a vector grid " + GridUtil.getParamType(vector));
        }
        return DerivedGridFactory.createVectorMagnitude(DerivedGridFactory.getUComponent(vector), DerivedGridFactory.getVComponent(vector), "vector_mag");
    }

    public static FieldImpl createVectorMagnitude(FieldImpl uFI, FieldImpl vFI, String name) throws VisADException, RemoteException {
        Unit spdUnit;
        FieldImpl wsgridFI;
        Boolean ensble;
        if (uFI == null || vFI == null) {
            return null;
        }
        if (name == null) {
            name = "mag";
        }
        if ((ensble = Boolean.valueOf(GridUtil.hasEnsemble(wsgridFI = (FieldImpl)uFI.multiply(uFI).add(vFI.multiply(vFI)).sqrt()))).booleanValue()) {
            FieldImpl sample = (FieldImpl)uFI.getSample(0);
            FlatField innerField = (FlatField)sample.getSample(0, false);
            spdUnit = innerField.getRangeUnits()[0][0];
        } else {
            spdUnit = ((FlatField)uFI.getSample(0)).getRangeUnits()[0][0];
        }
        RealType spdRT = DataUtil.makeRealType(name, spdUnit);
        return GridUtil.setParamType(wsgridFI, spdRT, false);
    }

    public static FieldImpl createVectorDirection(FieldImpl vector) throws VisADException, RemoteException {
        if (!DerivedGridFactory.isVector(vector)) {
            throw new VisADException("Not a vector grid " + GridUtil.getParamType(vector));
        }
        FieldImpl dirFI = null;
        if (GridUtil.isTimeSequence(vector)) {
            Set timeSet = vector.getDomainSet();
            for (int i = 0; i < timeSet.getLength(); ++i) {
                FlatField dirFF = DerivedGridFactory.createVectorDirectionFF((FlatField)vector.getSample(i, false));
                if (dirFI == null && dirFF != null) {
                    FunctionType dirFT = new FunctionType(((SetType)timeSet.getType()).getDomain(), dirFF.getType());
                    dirFI = new FieldImpl(dirFT, timeSet);
                }
                if (dirFF == null) continue;
                dirFI.setSample(i, dirFF, false, false);
            }
        } else {
            dirFI = DerivedGridFactory.createVectorDirectionFF((FlatField)vector);
        }
        return dirFI;
    }

    private static FlatField createVectorDirectionFF(FlatField vector) throws VisADException, RemoteException {
        if (!DerivedGridFactory.isVector(vector)) {
            throw new VisADException("Not a vector grid " + GridUtil.getParamType(vector));
        }
        FunctionType dirFT = new FunctionType(((SetType)vector.getDomainSet().getType()).getDomain(), Direction.getRealTupleType());
        FlatField dirFF = new FlatField(dirFT, vector.getDomainSet());
        float[][] samples = vector.getFloats(false);
        float[][] dirs = new float[1][samples[0].length];
        for (int i = 0; i < samples[0].length; ++i) {
            float dir;
            float u = samples[0][i];
            float v = samples[1][i];
            if (Float.isNaN(u) || Float.isNaN(v)) {
                dir = Float.NaN;
            } else if (u == 0.0f && v == 0.0f) {
                dir = 0.0f;
            } else {
                dir = (float)Math.toDegrees(Math.atan2(-u, -v));
                if (dir < 0.0f) {
                    dir += 360.0f;
                }
            }
            dirs[0][i] = dir;
        }
        dirFF.setSamples(dirs, false);
        return dirFF;
    }

    public static FieldImpl createVectorDirection(FieldImpl uFI, FieldImpl vFI) throws VisADException, RemoteException {
        return DerivedGridFactory.createVectorDirection(DerivedGridFactory.createFlowVectors(uFI, vFI));
    }

    public static FieldImpl createHorizontalDivergence(FieldImpl uGrid, FieldImpl vGrid) throws VisADException, RemoteException {
        boolean isSequence = GridUtil.isTimeSequence(uGrid) && GridUtil.isTimeSequence(vGrid);
        FieldImpl divFI = null;
        if (isSequence) {
            Set timeSet = uGrid.getDomainSet();
            if (timeSet.getLength() > 1) {
                vGrid = (FieldImpl)vGrid.resample(timeSet);
            }
            Boolean ensble = GridUtil.hasEnsemble(uGrid);
            TupleType rangeType = null;
            FunctionType innerType = null;
            for (int i = 0; i < timeSet.getLength(); ++i) {
                DataImpl funcFF = null;
                if (ensble.booleanValue()) {
                    FieldImpl sample1 = (FieldImpl)uGrid.getSample(i);
                    FieldImpl sample2 = (FieldImpl)uGrid.getSample(i);
                    Set ensDomain = sample1.getDomainSet();
                    for (int j = 0; j < ensDomain.getLength(); ++j) {
                        FlatField innerField1 = (FlatField)sample1.getSample(j, false);
                        FlatField innerField2 = (FlatField)sample2.getSample(j, false);
                        if (innerField1 == null || innerField2 == null) continue;
                        FlatField innerdivFF = DerivedGridFactory.makeHorizontalDivergence(innerField1, innerField2);
                        if (rangeType == null) {
                            rangeType = GridUtil.getParamType(innerdivFF);
                            innerType = new FunctionType(DataUtility.getDomainType(ensDomain), innerdivFF.getType());
                        }
                        if (j == 0) {
                            funcFF = new FieldImpl(innerType, ensDomain);
                        }
                        ((FieldImpl)funcFF).setSample(j, innerdivFF, false);
                    }
                    if (divFI == null) {
                        FunctionType newFieldType = new FunctionType(((SetType)timeSet.getType()).getDomain(), funcFF.getType());
                        divFI = new FieldImpl(newFieldType, timeSet);
                    }
                    ((FieldImpl)divFI).setSample(i, funcFF, false);
                    continue;
                }
                FlatField divFF = DerivedGridFactory.makeHorizontalDivergence((FlatField)uGrid.getSample(i), (FlatField)vGrid.getSample(i));
                if (i == 0) {
                    FunctionType functionType = new FunctionType(((FunctionType)uGrid.getType()).getDomain(), divFF.getType());
                    divFI = new FieldImpl(functionType, timeSet);
                }
                ((FieldImpl)divFI).setSample(i, (Data)divFF, false);
            }
        } else {
            divFI = DerivedGridFactory.makeHorizontalDivergence((FlatField)uGrid, (FlatField)vGrid);
        }
        return divFI;
    }

    private static FlatField makeHorizontalDivergence(FlatField uFF, FlatField vFF) throws VisADException, RemoteException {
        return (FlatField)GridMath.add(GridMath.ddx(uFF), GridMath.ddy(vFF));
    }

    public static FieldImpl createHorizontalFluxDivergence(FieldImpl paramGrid, FieldImpl uGrid, FieldImpl vGrid) throws VisADException, RemoteException {
        FieldImpl div = DerivedGridFactory.createHorizontalDivergence(uGrid, vGrid);
        FieldImpl adv = DerivedGridFactory.createHorizontalAdvection(paramGrid, uGrid, vGrid);
        FieldImpl pdiv = GridMath.multiply(paramGrid, div);
        return GridMath.subtract(pdiv, adv);
    }

    public static FieldImpl createHorizontalAdvection(FieldImpl paramGrid, FieldImpl flowVector) throws VisADException, RemoteException {
        FieldImpl uGrid = DerivedGridFactory.getUComponent(flowVector);
        FieldImpl vGrid = DerivedGridFactory.getVComponent(flowVector);
        return DerivedGridFactory.createHorizontalAdvection(paramGrid, uGrid, vGrid);
    }

    public static FieldImpl createHorizontalAdvection(FieldImpl paramGrid, FieldImpl uGrid, FieldImpl vGrid) throws VisADException, RemoteException {
        boolean isSequence = GridUtil.isTimeSequence(uGrid) && GridUtil.isTimeSequence(vGrid) && GridUtil.isTimeSequence(paramGrid);
        FieldImpl divFI = null;
        if (isSequence) {
            Set timeSet = uGrid.getDomainSet();
            Boolean ensble = GridUtil.hasEnsemble(uGrid) && GridUtil.hasEnsemble(vGrid) && GridUtil.hasEnsemble(paramGrid);
            if (timeSet.getLength() > 1) {
                vGrid = (FieldImpl)vGrid.resample(timeSet);
            }
            TupleType rangeType = null;
            FunctionType innerType = null;
            for (int i = 0; i < timeSet.getLength(); ++i) {
                DataImpl funcFF = null;
                if (ensble.booleanValue()) {
                    FieldImpl sample1 = (FieldImpl)uGrid.getSample(i);
                    FieldImpl sample2 = (FieldImpl)vGrid.getSample(i);
                    FieldImpl sample3 = (FieldImpl)paramGrid.getSample(i);
                    Set ensDomain = sample1.getDomainSet();
                    for (int j = 0; j < ensDomain.getLength(); ++j) {
                        FlatField innerField1 = (FlatField)sample1.getSample(j, false);
                        FlatField innerField2 = (FlatField)sample2.getSample(j, false);
                        FlatField innerField3 = (FlatField)sample3.getSample(j, false);
                        if (innerField1 == null || innerField2 == null) continue;
                        FlatField innerdivFF = DerivedGridFactory.makeHorizontalAdvection(innerField3, innerField1, innerField2);
                        if (rangeType == null) {
                            rangeType = GridUtil.getParamType(innerdivFF);
                            innerType = new FunctionType(DataUtility.getDomainType(ensDomain), innerdivFF.getType());
                        }
                        if (j == 0) {
                            funcFF = new FieldImpl(innerType, ensDomain);
                        }
                        ((FieldImpl)funcFF).setSample(j, innerdivFF, false);
                    }
                    if (divFI == null) {
                        FunctionType newFieldType = new FunctionType(((SetType)timeSet.getType()).getDomain(), funcFF.getType());
                        divFI = new FieldImpl(newFieldType, timeSet);
                    }
                    ((FieldImpl)divFI).setSample(i, funcFF, false);
                    continue;
                }
                FlatField divFF = DerivedGridFactory.makeHorizontalAdvection((FlatField)paramGrid.getSample(i), (FlatField)uGrid.getSample(i), (FlatField)vGrid.getSample(i));
                if (i == 0) {
                    FunctionType functionType = new FunctionType(((FunctionType)paramGrid.getType()).getDomain(), divFF.getType());
                    divFI = new FieldImpl(functionType, timeSet);
                }
                ((FieldImpl)divFI).setSample(i, (Data)divFF, false);
            }
        } else {
            divFI = DerivedGridFactory.makeHorizontalAdvection((FlatField)paramGrid, (FlatField)uGrid, (FlatField)vGrid);
        }
        return divFI;
    }

    private static FlatField makeHorizontalAdvection(FlatField aFF, FlatField uFF, FlatField vFF) throws VisADException, RemoteException {
        FlatField udadx = (FlatField)GridMath.multiply(GridMath.ddx(aFF), uFF);
        FlatField vdady = (FlatField)GridMath.multiply(GridMath.ddy(aFF), vFF);
        FlatField advgrid = (FlatField)GridMath.add(udadx, vdady);
        return (FlatField)advgrid.negate();
    }

    public static FieldImpl createConservedSounding(FieldImpl temperFI, FieldImpl rhFI) throws VisADException, RemoteException {
        Object soundingFI = null;
        FieldImpl theta = null;
        FieldImpl thetae = null;
        FieldImpl thetaesat = null;
        Object ffi = null;
        try {
            theta = DerivedGridFactory.createPotentialTemperature(temperFI);
            thetae = DerivedGridFactory.createEquivalentPotentialTemperature(temperFI, rhFI);
            thetaesat = DerivedGridFactory.createSatEquivalentPotentialTemperature(temperFI);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return DerivedGridFactory.combineGrids(theta, thetae, thetaesat);
    }

    public static FieldImpl createDewpoint(FieldImpl temperFI, FieldImpl rhFI) throws VisADException, RemoteException {
        boolean isSequence = GridUtil.isTimeSequence(temperFI) && GridUtil.isTimeSequence(rhFI);
        FieldImpl dewpointFI = null;
        if (isSequence) {
            Set timeSet = temperFI.getDomainSet();
            if (timeSet.getLength() > 1) {
                rhFI = (FieldImpl)rhFI.resample(timeSet);
            }
            Boolean ensble = GridUtil.hasEnsemble(temperFI) && GridUtil.hasEnsemble(rhFI);
            TupleType rangeType = null;
            FunctionType innerType = null;
            for (int i = 0; i < timeSet.getLength(); ++i) {
                if (ensble.booleanValue()) {
                    FieldImpl sample1 = (FieldImpl)temperFI.getSample(i);
                    FieldImpl sample2 = (FieldImpl)rhFI.getSample(i);
                    Set ensDomain = sample1.getDomainSet();
                    DataImpl funcFF = null;
                    for (int j = 0; j < ensDomain.getLength(); ++j) {
                        FlatField innerField1 = (FlatField)sample1.getSample(j, false);
                        FlatField innerField2 = (FlatField)sample2.getSample(j, false);
                        if (innerField1 == null || innerField2 == null) continue;
                        FlatField innerdivFF = DerivedGridFactory.makeDewpointFromTAndRH(innerField1, innerField2);
                        if (rangeType == null) {
                            rangeType = GridUtil.getParamType(innerdivFF);
                            innerType = new FunctionType(DataUtility.getDomainType(ensDomain), innerdivFF.getType());
                        }
                        if (j == 0) {
                            funcFF = new FieldImpl(innerType, ensDomain);
                        }
                        ((FieldImpl)funcFF).setSample(j, innerdivFF, false);
                    }
                    if (dewpointFI == null) {
                        FunctionType newFieldType = new FunctionType(((SetType)timeSet.getType()).getDomain(), funcFF.getType());
                        dewpointFI = new FieldImpl(newFieldType, timeSet);
                    }
                    ((FieldImpl)dewpointFI).setSample(i, funcFF, false);
                    continue;
                }
                FlatField dewptFF = DerivedGridFactory.makeDewpointFromTAndRH((FlatField)temperFI.getSample(i), (FlatField)rhFI.getSample(i));
                if (i == 0) {
                    FunctionType functionType = new FunctionType(((FunctionType)temperFI.getType()).getDomain(), dewptFF.getType());
                    dewpointFI = new FieldImpl(functionType, timeSet);
                }
                ((FieldImpl)dewpointFI).setSample(i, (Data)dewptFF, false);
            }
        } else {
            dewpointFI = DerivedGridFactory.makeDewpointFromTAndRH((FlatField)temperFI, (FlatField)rhFI);
        }
        return dewpointFI;
    }

    public static FieldImpl createHeatIndex(FieldImpl temperFI, FieldImpl rhFI) throws VisADException, RemoteException {
        Unit newunit = Util.parseUnit("Fahrenheit");
        RealType newType = Util.makeRealType("tempFahren", newunit);
        FieldImpl temperFI0 = GridUtil.setParamType(temperFI, newType, false);
        boolean isSequence = GridUtil.isTimeSequence(temperFI0) && GridUtil.isTimeSequence(rhFI);
        FieldImpl heatIndexFI = null;
        if (isSequence) {
            Set timeSet = temperFI0.getDomainSet();
            if (timeSet.getLength() > 1) {
                rhFI = (FieldImpl)rhFI.resample(timeSet);
            }
            Boolean ensble = GridUtil.hasEnsemble(temperFI0) && GridUtil.hasEnsemble(rhFI);
            TupleType rangeType = null;
            FunctionType innerType = null;
            for (int i = 0; i < timeSet.getLength(); ++i) {
                if (ensble.booleanValue()) {
                    FieldImpl sample1 = (FieldImpl)temperFI0.getSample(i);
                    FieldImpl sample2 = (FieldImpl)rhFI.getSample(i);
                    Set ensDomain = sample1.getDomainSet();
                    DataImpl funcFF = null;
                    for (int j = 0; j < ensDomain.getLength(); ++j) {
                        FlatField innerField1 = (FlatField)sample1.getSample(j, false);
                        FlatField innerField2 = (FlatField)sample2.getSample(j, false);
                        if (innerField1 == null || innerField2 == null) continue;
                        FlatField innerdivFF = DerivedGridFactory.makeHeatindexFromTAndRH(innerField1, innerField2);
                        if (rangeType == null) {
                            rangeType = GridUtil.getParamType(innerdivFF);
                            innerType = new FunctionType(DataUtility.getDomainType(ensDomain), innerdivFF.getType());
                        }
                        if (j == 0) {
                            funcFF = new FieldImpl(innerType, ensDomain);
                        }
                        ((FieldImpl)funcFF).setSample(j, innerdivFF, false);
                    }
                    if (heatIndexFI == null) {
                        FunctionType newFieldType = new FunctionType(((SetType)timeSet.getType()).getDomain(), funcFF.getType());
                        heatIndexFI = new FieldImpl(newFieldType, timeSet);
                    }
                    ((FieldImpl)heatIndexFI).setSample(i, funcFF, false);
                    continue;
                }
                FlatField dewptFF = DerivedGridFactory.makeHeatindexFromTAndRH((FlatField)temperFI0.getSample(i), (FlatField)rhFI.getSample(i));
                if (i == 0) {
                    FunctionType functionType = new FunctionType(((FunctionType)temperFI0.getType()).getDomain(), dewptFF.getType());
                    heatIndexFI = new FieldImpl(functionType, timeSet);
                }
                ((FieldImpl)heatIndexFI).setSample(i, (Data)dewptFF, false);
            }
        } else {
            heatIndexFI = DerivedGridFactory.makeHeatindexFromTAndRH((FlatField)temperFI0, (FlatField)rhFI);
        }
        return heatIndexFI;
    }

    private static FlatField makeHeatindexFromTAndRH(FlatField temp, FlatField rh) throws VisADException, RemoteException {
        Unit percentUnit = CommonUnits.PERCENT;
        TupleType rangeType = GridUtil.makeNewParamType(GridUtil.getParamType(temp), "_mask");
        FunctionType newType = new FunctionType(DataUtility.getDomainType(temp), rangeType);
        FlatField esFF = new FlatField(newType, temp.getDomainSet());
        Unit rUnit = rh.getRangeUnits()[0][0];
        if (rUnit == null || !rUnit.isConvertible(percentUnit)) {
            Range[] range = GridUtil.fieldMinMax(rh);
            if (range[0].max <= 1.1 && range[0].min > 0.0) {
                rh = (FlatField)rh.__mul__(100.0);
            }
            RealType rt = GridUtil.getParamType(rh).getRealComponents()[0];
            RealType newType1 = Util.makeRealType(rt.getName(), percentUnit);
            rh = (FlatField)GridUtil.setParamType((FieldImpl)rh, newType1);
        }
        float[][] tempValues = temp.getFloats(false);
        float[][] rhValues = rh.getFloats(false);
        float[][] heatIdxValues = new float[tempValues.length][tempValues[0].length];
        for (int i = 0; i < tempValues.length; ++i) {
            for (int j = 0; j < tempValues[0].length; ++j) {
                heatIdxValues[i][j] = (float)PointObFactory.heatIndex(tempValues[i][j], rhValues[i][j]);
            }
        }
        esFF.setSamples(heatIdxValues, false);
        return esFF;
    }

    private static FlatField makeDewpointFromTAndRH(FlatField temp, FlatField rh) throws VisADException, RemoteException {
        FlatField esFF = (FlatField)SaturationVaporPressure.create(temp);
        Unit percentUnit = CommonUnits.PERCENT;
        Unit rUnit = rh.getRangeUnits()[0][0];
        if (rUnit == null || !rUnit.isConvertible(percentUnit)) {
            Range[] range = GridUtil.fieldMinMax(rh);
            if (range[0].max <= 1.1 && range[0].min > 0.0) {
                rh = (FlatField)rh.__mul__(100.0);
            }
            RealType rt = GridUtil.getParamType(rh).getRealComponents()[0];
            RealType newType = Util.makeRealType(rt.getName(), percentUnit);
            rh = (FlatField)GridUtil.setParamType((FieldImpl)rh, newType);
        }
        FlatField eFF = (FlatField)GridMath.multiply(esFF, rh);
        return (FlatField)SaturationVaporPressure.createTemperature(eFF, DewPoint.getRealType());
    }

    public static FieldImpl createEquivalentPotentialTemperature(FieldImpl temperFI, FieldImpl rhFI) throws VisADException, RemoteException {
        FieldImpl mixingRatioFI = DerivedGridFactory.createMixingRatio(temperFI, rhFI);
        Object ept = null;
        FieldImpl eptFI = null;
        boolean isSequence = GridUtil.isTimeSequence(temperFI) && GridUtil.isTimeSequence(rhFI);
        Boolean ensble = GridUtil.hasEnsemble(temperFI) && GridUtil.hasEnsemble(rhFI);
        TupleType rangeType = null;
        FunctionType innerType = null;
        FlatField press = null;
        if (isSequence) {
            if (ensble.booleanValue()) {
                FieldImpl sample1 = (FieldImpl)temperFI.getSample(0);
                press = DerivedGridFactory.createPressureGridFromDomain((FlatField)sample1.getSample(0, false));
            } else {
                press = DerivedGridFactory.createPressureGridFromDomain((FlatField)temperFI.getSample(0));
            }
            Set timeSet = temperFI.getDomainSet();
            if (timeSet.getLength() > 1) {
                rhFI = (FieldImpl)rhFI.resample(timeSet);
            }
            for (int i = 0; i < timeSet.getLength(); ++i) {
                if (ensble.booleanValue()) {
                    FieldImpl sample1 = (FieldImpl)temperFI.getSample(i);
                    FieldImpl sample2 = (FieldImpl)rhFI.getSample(i);
                    Set ensDomain = sample1.getDomainSet();
                    DataImpl funcFF = null;
                    for (int j = 0; j < ensDomain.getLength(); ++j) {
                        FlatField innerField1 = (FlatField)sample1.getSample(j, false);
                        FlatField innerField2 = (FlatField)sample2.getSample(j, false);
                        if (innerField1 == null || innerField2 == null) continue;
                        FlatField innerdivFF = DerivedGridFactory.makeDewpointFromTAndRH(innerField1, innerField2);
                        if (rangeType == null) {
                            rangeType = GridUtil.getParamType(innerdivFF);
                            innerType = new FunctionType(DataUtility.getDomainType(ensDomain), innerdivFF.getType());
                        }
                        if (j == 0) {
                            funcFF = new FieldImpl(innerType, ensDomain);
                        }
                        ((FieldImpl)funcFF).setSample(j, innerdivFF, false);
                    }
                    if (eptFI == null) {
                        FunctionType newFieldType = new FunctionType(((SetType)timeSet.getType()).getDomain(), funcFF.getType());
                        eptFI = new FieldImpl(newFieldType, timeSet);
                    }
                    eptFI.setSample(i, funcFF, false);
                    continue;
                }
                FlatField eptFF = (FlatField)EquivalentPotentialTemperature.create(press, (FlatField)temperFI.getSample(i), (FlatField)mixingRatioFI.getSample(i));
                if (i == 0) {
                    FunctionType functionType = new FunctionType(((FunctionType)temperFI.getType()).getDomain(), eptFF.getType());
                    eptFI = new FieldImpl(functionType, timeSet);
                }
                eptFI.setSample(i, (Data)eptFF, false);
            }
        } else {
            mixingRatioFI = DerivedGridFactory.makeMixFromTAndRHAndP((FlatField)temperFI, (FlatField)rhFI, DerivedGridFactory.createPressureGridFromDomain((FlatField)temperFI));
            eptFI = (FieldImpl)EquivalentPotentialTemperature.create(DerivedGridFactory.createPressureGridFromDomain((FlatField)temperFI), temperFI, mixingRatioFI);
        }
        return eptFI;
    }

    public static FieldImpl createEquivalentPotentialTemperature(FieldImpl temperFI, FieldImpl pressFI, FieldImpl rhFI) throws VisADException, RemoteException {
        FieldImpl airpressFI = GridUtil.getParamType(pressFI).equals(AirPressure.getRealTupleType()) ? pressFI : DerivedGridFactory.convertToAirPressure(pressFI);
        FieldImpl mixingRatioFI = DerivedGridFactory.createMixingRatio(temperFI, airpressFI, rhFI);
        Object ept = null;
        FieldImpl eptFI = null;
        boolean isSequence = GridUtil.isTimeSequence(temperFI) && GridUtil.isTimeSequence(rhFI);
        Boolean ensble = GridUtil.hasEnsemble(temperFI) && GridUtil.hasEnsemble(rhFI);
        TupleType rangeType = null;
        FunctionType innerType = null;
        Object press1 = null;
        if (isSequence) {
            Set timeSet = temperFI.getDomainSet();
            if (timeSet.getLength() > 1) {
                rhFI = (FieldImpl)rhFI.resample(timeSet);
            }
            for (int i = 0; i < timeSet.getLength(); ++i) {
                if (ensble.booleanValue()) {
                    FieldImpl sample1 = (FieldImpl)temperFI.getSample(i);
                    FieldImpl sample2 = (FieldImpl)rhFI.getSample(i);
                    FieldImpl samplep = (FieldImpl)airpressFI.getSample(i);
                    Set ensDomain = sample1.getDomainSet();
                    DataImpl funcFF = null;
                    for (int j = 0; j < ensDomain.getLength(); ++j) {
                        FlatField innerField1 = (FlatField)sample1.getSample(j, false);
                        FlatField innerField2 = (FlatField)sample2.getSample(j, false);
                        if (innerField1 == null || innerField2 == null) continue;
                        FlatField innerdivFF = DerivedGridFactory.makeDewpointFromTAndRH(innerField1, innerField2);
                        if (rangeType == null) {
                            rangeType = GridUtil.getParamType(innerdivFF);
                            innerType = new FunctionType(DataUtility.getDomainType(ensDomain), innerdivFF.getType());
                        }
                        if (j == 0) {
                            funcFF = new FieldImpl(innerType, ensDomain);
                        }
                        ((FieldImpl)funcFF).setSample(j, innerdivFF, false);
                    }
                    if (eptFI == null) {
                        FunctionType newFieldType = new FunctionType(((SetType)timeSet.getType()).getDomain(), funcFF.getType());
                        eptFI = new FieldImpl(newFieldType, timeSet);
                    }
                    eptFI.setSample(i, funcFF, false);
                    continue;
                }
                FlatField eptFF = (FlatField)EquivalentPotentialTemperature.create((FlatField)airpressFI.getSample(i), (FlatField)temperFI.getSample(i), (FlatField)mixingRatioFI.getSample(i));
                if (i == 0) {
                    FunctionType functionType = new FunctionType(((FunctionType)temperFI.getType()).getDomain(), eptFF.getType());
                    eptFI = new FieldImpl(functionType, timeSet);
                }
                eptFI.setSample(i, (Data)eptFF, false);
            }
        } else {
            FlatField press = (FlatField)airpressFI;
            mixingRatioFI = DerivedGridFactory.makeMixFromTAndRHAndP((FlatField)temperFI, (FlatField)rhFI, press);
            eptFI = (FieldImpl)EquivalentPotentialTemperature.create(press, temperFI, mixingRatioFI);
        }
        return eptFI;
    }

    public static FieldImpl removeUnit(String varname, FieldImpl field) throws VisADException {
        RealType newType = Util.makeRealType(varname, null);
        return GridUtil.setParamType(field, newType, false);
    }

    public static FieldImpl createRelativeHumidity(FieldImpl temperFI, FieldImpl mixingRatioFI) throws VisADException, RemoteException {
        return DerivedGridFactory.createRelativeHumidity(temperFI, mixingRatioFI, false);
    }

    public static FieldImpl createRelativeHumidityFromSpecificHumidity(FieldImpl temperFI, FieldImpl specificFI) throws VisADException, RemoteException {
        return DerivedGridFactory.createRelativeHumidity(temperFI, specificFI, true);
    }

    public static FieldImpl createRelativeHumidityFromSpecificHumidity(FieldImpl temperFI, FieldImpl pressFI, FieldImpl specificFI) throws VisADException, RemoteException {
        FieldImpl airpressFI = GridUtil.getParamType(pressFI).equals(AirPressure.getRealTupleType()) ? pressFI : DerivedGridFactory.convertToAirPressure(pressFI);
        return DerivedGridFactory.createRelativeHumidity(temperFI, airpressFI, specificFI, true);
    }

    public static FieldImpl createEPTFromSpecificHumidity(FieldImpl temperFI, FieldImpl specificFI) throws VisADException, RemoteException {
        FieldImpl rhFI = DerivedGridFactory.createRelativeHumidityFromSpecificHumidity(temperFI, specificFI);
        return DerivedGridFactory.createEquivalentPotentialTemperature(temperFI, rhFI);
    }

    public static FieldImpl createEPTFromSpecificHumidity(FieldImpl temperFI, FieldImpl pressFI, FieldImpl specificFI) throws VisADException, RemoteException {
        FieldImpl airpressFI = GridUtil.getParamType(pressFI).equals(AirPressure.getRealTupleType()) ? pressFI : DerivedGridFactory.convertToAirPressure(pressFI);
        FieldImpl rhFI = DerivedGridFactory.createRelativeHumidityFromSpecificHumidity(temperFI, airpressFI, specificFI);
        return DerivedGridFactory.createEquivalentPotentialTemperature(temperFI, airpressFI, rhFI);
    }

    public static FieldImpl createRelativeHumidity(FieldImpl temperFI, FieldImpl mixingRatioFI, boolean isSpecificHumidity) throws VisADException, RemoteException {
        FieldImpl rhFI = null;
        FlatField mixingRatioFF = null;
        FlatField press = null;
        boolean isSequence = GridUtil.isTimeSequence(temperFI) && GridUtil.isTimeSequence(mixingRatioFI);
        Boolean ensble = GridUtil.hasEnsemble(temperFI) && GridUtil.hasEnsemble(mixingRatioFI);
        TupleType rangeType = null;
        FunctionType innerType = null;
        if (isSequence) {
            if (ensble.booleanValue()) {
                FieldImpl sample1 = (FieldImpl)temperFI.getSample(0);
                press = DerivedGridFactory.createPressureGridFromDomain((FlatField)sample1.getSample(0, false));
            } else {
                press = DerivedGridFactory.createPressureGridFromDomain((FlatField)temperFI.getSample(0));
            }
            Set timeSet = temperFI.getDomainSet();
            if (timeSet.getLength() > 1) {
                mixingRatioFI = (FieldImpl)mixingRatioFI.resample(timeSet);
            }
            for (int i = 0; i < timeSet.getLength(); ++i) {
                if (ensble.booleanValue()) {
                    FieldImpl sample1 = (FieldImpl)temperFI.getSample(i);
                    FieldImpl sample2 = (FieldImpl)mixingRatioFI.getSample(i);
                    Set ensDomain = sample1.getDomainSet();
                    DataImpl funcFF = null;
                    for (int j = 0; j < ensDomain.getLength(); ++j) {
                        FlatField innerField1 = (FlatField)sample1.getSample(j, false);
                        FlatField innerField2 = (FlatField)sample2.getSample(j, false);
                        if (innerField1 == null || innerField2 == null) continue;
                        FlatField innerdivFF = (FlatField)RelativeHumidity.create(innerField2, press, innerField1);
                        if (rangeType == null) {
                            rangeType = GridUtil.getParamType(innerdivFF);
                            innerType = new FunctionType(DataUtility.getDomainType(ensDomain), innerdivFF.getType());
                        }
                        if (j == 0) {
                            funcFF = new FieldImpl(innerType, ensDomain);
                        }
                        ((FieldImpl)funcFF).setSample(j, innerdivFF, false);
                    }
                    if (rhFI == null) {
                        FunctionType newFieldType = new FunctionType(((SetType)timeSet.getType()).getDomain(), funcFF.getType());
                        rhFI = new FieldImpl(newFieldType, timeSet);
                    }
                    rhFI.setSample(i, funcFF, false);
                    continue;
                }
                mixingRatioFF = (FlatField)mixingRatioFI.getSample(i);
                if (isSpecificHumidity) {
                    mixingRatioFF = (FlatField)WaterVaporMixingRatio.create(mixingRatioFF);
                }
                FlatField rhFF = (FlatField)RelativeHumidity.create(mixingRatioFF, press, temperFI.getSample(i));
                if (i == 0) {
                    FunctionType functionType = new FunctionType(((FunctionType)temperFI.getType()).getDomain(), rhFF.getType());
                    rhFI = new FieldImpl(functionType, timeSet);
                }
                rhFI.setSample(i, (Data)rhFF, false);
            }
        } else {
            press = DerivedGridFactory.createPressureGridFromDomain((FlatField)temperFI);
            mixingRatioFF = (FlatField)mixingRatioFI;
            if (isSpecificHumidity) {
                mixingRatioFF = (FlatField)WaterVaporMixingRatio.create(mixingRatioFI);
            }
            rhFI = (FieldImpl)RelativeHumidity.create(mixingRatioFF, press, temperFI);
        }
        return rhFI;
    }

    public static FieldImpl createRelativeHumidity(FieldImpl temperFI, FieldImpl pressFI, FieldImpl mixingRatioFI, boolean isSpecificHumidity) throws VisADException, RemoteException {
        FieldImpl rhFI = null;
        FlatField mixingRatioFF = null;
        Object press1 = null;
        boolean isSequence = GridUtil.isTimeSequence(temperFI) && GridUtil.isTimeSequence(mixingRatioFI);
        Boolean ensble = GridUtil.hasEnsemble(temperFI) && GridUtil.hasEnsemble(mixingRatioFI);
        FieldImpl airpressFI = GridUtil.getParamType(pressFI).equals(AirPressure.getRealTupleType()) ? pressFI : DerivedGridFactory.convertToAirPressure(pressFI);
        TupleType rangeType = null;
        FunctionType innerType = null;
        if (isSequence) {
            Set timeSet = temperFI.getDomainSet();
            if (timeSet.getLength() > 1) {
                mixingRatioFI = (FieldImpl)mixingRatioFI.resample(timeSet);
            }
            for (int i = 0; i < timeSet.getLength(); ++i) {
                if (ensble.booleanValue()) {
                    FieldImpl sample1 = (FieldImpl)temperFI.getSample(i);
                    FieldImpl sample2 = (FieldImpl)mixingRatioFI.getSample(i);
                    FieldImpl samplep = (FieldImpl)airpressFI.getSample(i);
                    Set ensDomain = sample1.getDomainSet();
                    DataImpl funcFF = null;
                    for (int j = 0; j < ensDomain.getLength(); ++j) {
                        FlatField innerField1 = (FlatField)sample1.getSample(j, false);
                        FlatField innerField2 = (FlatField)sample2.getSample(j, false);
                        FlatField press = (FlatField)samplep.getSample(j, false);
                        if (innerField1 == null || innerField2 == null) continue;
                        FlatField innerdivFF = (FlatField)RelativeHumidity.create(innerField2, press, innerField1);
                        if (rangeType == null) {
                            rangeType = GridUtil.getParamType(innerdivFF);
                            innerType = new FunctionType(DataUtility.getDomainType(ensDomain), innerdivFF.getType());
                        }
                        if (j == 0) {
                            funcFF = new FieldImpl(innerType, ensDomain);
                        }
                        ((FieldImpl)funcFF).setSample(j, innerdivFF, false);
                    }
                    if (rhFI == null) {
                        FunctionType newFieldType = new FunctionType(((SetType)timeSet.getType()).getDomain(), funcFF.getType());
                        rhFI = new FieldImpl(newFieldType, timeSet);
                    }
                    rhFI.setSample(i, funcFF, false);
                    continue;
                }
                mixingRatioFF = (FlatField)mixingRatioFI.getSample(i);
                FlatField press = (FlatField)airpressFI.getSample(i);
                if (isSpecificHumidity) {
                    mixingRatioFF = (FlatField)WaterVaporMixingRatio.create(mixingRatioFF);
                }
                FlatField rhFF = (FlatField)RelativeHumidity.create(mixingRatioFF, press, temperFI.getSample(i));
                if (i == 0) {
                    FunctionType functionType = new FunctionType(((FunctionType)temperFI.getType()).getDomain(), rhFF.getType());
                    rhFI = new FieldImpl(functionType, timeSet);
                }
                rhFI.setSample(i, (Data)rhFF, false);
            }
        } else {
            FlatField press = (FlatField)airpressFI;
            mixingRatioFF = (FlatField)mixingRatioFI;
            if (isSpecificHumidity) {
                mixingRatioFF = (FlatField)WaterVaporMixingRatio.create(mixingRatioFI);
            }
            rhFI = (FieldImpl)RelativeHumidity.create(mixingRatioFF, press, temperFI);
        }
        return rhFI;
    }

    public static FieldImpl createMixingRatio(FieldImpl temperFI, FieldImpl rhFI) throws VisADException, RemoteException {
        boolean isSequence = GridUtil.isTimeSequence(temperFI) && GridUtil.isTimeSequence(rhFI);
        FieldImpl mixFI = null;
        if (isSequence) {
            Set timeSet = temperFI.getDomainSet();
            if (timeSet.getLength() > 1) {
                rhFI = (FieldImpl)rhFI.resample(timeSet);
            }
            Boolean ensble = GridUtil.hasEnsemble(temperFI) && GridUtil.hasEnsemble(rhFI);
            TupleType rangeType = null;
            FunctionType innerType = null;
            FlatField press = null;
            if (ensble.booleanValue()) {
                FieldImpl sample1 = (FieldImpl)temperFI.getSample(0);
                press = DerivedGridFactory.createPressureGridFromDomain((FlatField)sample1.getSample(0, false));
            } else {
                press = DerivedGridFactory.createPressureGridFromDomain((FlatField)temperFI.getSample(0));
            }
            for (int i = 0; i < timeSet.getLength(); ++i) {
                if (ensble.booleanValue()) {
                    FieldImpl sample1 = (FieldImpl)temperFI.getSample(i);
                    FieldImpl sample2 = (FieldImpl)rhFI.getSample(i);
                    Set ensDomain = sample1.getDomainSet();
                    DataImpl funcFF = null;
                    for (int j = 0; j < ensDomain.getLength(); ++j) {
                        FlatField innerField1 = (FlatField)sample1.getSample(j, false);
                        FlatField innerField2 = (FlatField)sample2.getSample(j, false);
                        if (innerField1 == null || innerField2 == null) continue;
                        FlatField innerdivFF = DerivedGridFactory.makeMixFromTAndRHAndP(innerField1, innerField2, press);
                        if (rangeType == null) {
                            rangeType = GridUtil.getParamType(innerdivFF);
                            innerType = new FunctionType(DataUtility.getDomainType(ensDomain), innerdivFF.getType());
                        }
                        if (j == 0) {
                            funcFF = new FieldImpl(innerType, ensDomain);
                        }
                        ((FieldImpl)funcFF).setSample(j, innerdivFF, false);
                    }
                    if (mixFI == null) {
                        FunctionType newFieldType = new FunctionType(((SetType)timeSet.getType()).getDomain(), funcFF.getType());
                        mixFI = new FieldImpl(newFieldType, timeSet);
                    }
                    ((FieldImpl)mixFI).setSample(i, funcFF, false);
                    continue;
                }
                FlatField mixFF = DerivedGridFactory.makeMixFromTAndRHAndP((FlatField)temperFI.getSample(i), (FlatField)rhFI.getSample(i), press);
                if (i == 0) {
                    FunctionType functionType = new FunctionType(((FunctionType)temperFI.getType()).getDomain(), mixFF.getType());
                    mixFI = new FieldImpl(functionType, timeSet);
                }
                ((FieldImpl)mixFI).setSample(i, (Data)mixFF, false);
            }
        } else {
            mixFI = DerivedGridFactory.makeMixFromTAndRHAndP((FlatField)temperFI, (FlatField)rhFI, DerivedGridFactory.createPressureGridFromDomain((FlatField)temperFI));
        }
        return mixFI;
    }

    public static FieldImpl createMixingRatio(FieldImpl temperFI, FieldImpl pressFI, FieldImpl rhFI) throws VisADException, RemoteException {
        boolean isSequence = GridUtil.isTimeSequence(temperFI) && GridUtil.isTimeSequence(rhFI);
        FieldImpl airpressFI = GridUtil.getParamType(pressFI).equals(AirPressure.getRealTupleType()) ? pressFI : DerivedGridFactory.convertToAirPressure(pressFI);
        FieldImpl mixFI = null;
        if (isSequence) {
            Set timeSet = temperFI.getDomainSet();
            if (timeSet.getLength() > 1) {
                rhFI = (FieldImpl)rhFI.resample(timeSet);
            }
            Boolean ensble = GridUtil.hasEnsemble(temperFI) && GridUtil.hasEnsemble(rhFI);
            TupleType rangeType = null;
            FunctionType innerType = null;
            for (int i = 0; i < timeSet.getLength(); ++i) {
                if (ensble.booleanValue()) {
                    FieldImpl sample1 = (FieldImpl)temperFI.getSample(i);
                    FieldImpl sample2 = (FieldImpl)rhFI.getSample(i);
                    FieldImpl samplep = (FieldImpl)airpressFI.getSample(i);
                    Set ensDomain = sample1.getDomainSet();
                    DataImpl funcFF = null;
                    for (int j = 0; j < ensDomain.getLength(); ++j) {
                        FlatField innerField1 = (FlatField)sample1.getSample(j, false);
                        FlatField innerField2 = (FlatField)sample2.getSample(j, false);
                        FlatField press = (FlatField)samplep.getSample(j, false);
                        if (innerField1 == null || innerField2 == null) continue;
                        FlatField innerdivFF = DerivedGridFactory.makeMixFromTAndRHAndP(innerField1, innerField2, press);
                        if (rangeType == null) {
                            rangeType = GridUtil.getParamType(innerdivFF);
                            innerType = new FunctionType(DataUtility.getDomainType(ensDomain), innerdivFF.getType());
                        }
                        if (j == 0) {
                            funcFF = new FieldImpl(innerType, ensDomain);
                        }
                        ((FieldImpl)funcFF).setSample(j, innerdivFF, false);
                    }
                    if (mixFI == null) {
                        FunctionType newFieldType = new FunctionType(((SetType)timeSet.getType()).getDomain(), funcFF.getType());
                        mixFI = new FieldImpl(newFieldType, timeSet);
                    }
                    ((FieldImpl)mixFI).setSample(i, funcFF, false);
                    continue;
                }
                FlatField mixFF = DerivedGridFactory.makeMixFromTAndRHAndP((FlatField)temperFI.getSample(i), (FlatField)rhFI.getSample(i), (FlatField)airpressFI.getSample(i));
                if (i == 0) {
                    FunctionType functionType = new FunctionType(((FunctionType)temperFI.getType()).getDomain(), mixFF.getType());
                    mixFI = new FieldImpl(functionType, timeSet);
                }
                ((FieldImpl)mixFI).setSample(i, (Data)mixFF, false);
            }
        } else {
            mixFI = DerivedGridFactory.makeMixFromTAndRHAndP((FlatField)temperFI, (FlatField)rhFI, (FlatField)airpressFI);
        }
        return mixFI;
    }

    public static FieldImpl createWRFMixingRatio(FieldImpl pFI, FieldImpl pbFI, FieldImpl temperFI, FieldImpl rhFI) throws VisADException, RemoteException {
        boolean isSequence = GridUtil.isTimeSequence(temperFI) && GridUtil.isTimeSequence(rhFI);
        FieldImpl mixFI = null;
        FieldImpl pressFI = GridMath.add(pFI, pbFI);
        if (isSequence) {
            Set timeSet = temperFI.getDomainSet();
            if (timeSet.getLength() > 1) {
                rhFI = (FieldImpl)rhFI.resample(timeSet);
            }
            Boolean ensble = GridUtil.hasEnsemble(temperFI) && GridUtil.hasEnsemble(rhFI);
            Object rangeType = null;
            Object innerType = null;
            FlatField press = null;
            press = (FlatField)pressFI.getSample(0);
            for (int i = 0; i < timeSet.getLength(); ++i) {
                FlatField mixFF = DerivedGridFactory.makeMixFromTAndRHAndP((FlatField)temperFI.getSample(i), (FlatField)rhFI.getSample(i), press);
                if (i == 0) {
                    FunctionType functionType = new FunctionType(((FunctionType)temperFI.getType()).getDomain(), mixFF.getType());
                    mixFI = new FieldImpl(functionType, timeSet);
                }
                ((FieldImpl)mixFI).setSample(i, (Data)mixFF, false);
            }
        } else {
            mixFI = DerivedGridFactory.makeMixFromTAndRHAndP((FlatField)temperFI, (FlatField)rhFI, DerivedGridFactory.createPressureGridFromDomain((FlatField)temperFI));
        }
        return mixFI;
    }

    private static FlatField makeMixFromTAndRHAndP(FlatField temp, FlatField rh, FlatField press) throws VisADException, RemoteException {
        FlatField satMR = (FlatField)SaturationMixingRatio.create(press, temp);
        RealType rhRT = (RealType)DataUtility.getFlatRangeType(rh).getComponent(0);
        Unit percentUnit = CommonUnits.PERCENT;
        Unit rUnit = rh.getRangeUnits()[0][0];
        if (rUnit == null || !rUnit.isConvertible(percentUnit) || rUnit.toString().equals("1")) {
            Range[] range = GridUtil.fieldMinMax(rh);
            FlatField mr = range[0].max <= 1.1 && range[0].min > 0.0 ? (FlatField)satMR.multiply(rh) : (FlatField)satMR.multiply(rh.divide(new Real(rhRT, 100.0)));
            return mr;
        }
        FlatField mr = (FlatField)satMR.multiply(rh.divide(new Real(rhRT, 100.0)));
        return mr;
    }

    public static FieldImpl createPotentialTemperature(FieldImpl temperFI) throws VisADException, RemoteException {
        Boolean ensble = GridUtil.hasEnsemble(temperFI);
        FlatField press = null;
        if (ensble.booleanValue()) {
            FieldImpl sample1 = (FieldImpl)temperFI.getSample(0);
            press = DerivedGridFactory.createPressureGridFromDomain((FlatField)sample1.getSample(0, false));
        } else {
            press = GridUtil.isTimeSequence(temperFI) ? DerivedGridFactory.createPressureGridFromDomain((FlatField)temperFI.getSample(0)) : DerivedGridFactory.createPressureGridFromDomain((FlatField)temperFI);
        }
        return DerivedGridFactory.createPotentialTemperature(temperFI, press);
    }

    public static FieldImpl createSatEquivalentPotentialTemperature(FieldImpl temperFI) throws VisADException, RemoteException {
        Boolean ensble = GridUtil.hasEnsemble(temperFI);
        FlatField press = null;
        if (ensble.booleanValue()) {
            FieldImpl sample1 = (FieldImpl)temperFI.getSample(0);
            press = DerivedGridFactory.createPressureGridFromDomain((FlatField)sample1.getSample(0, false));
        } else {
            press = GridUtil.isTimeSequence(temperFI) ? DerivedGridFactory.createPressureGridFromDomain((FlatField)temperFI.getSample(0)) : DerivedGridFactory.createPressureGridFromDomain((FlatField)temperFI);
        }
        return DerivedGridFactory.createSatEquivalentPotentialTemperature(temperFI, press);
    }

    public static FieldImpl createPressureField(FieldImpl geoPH) throws VisADException, RemoteException {
        Boolean ensble = GridUtil.hasEnsemble(geoPH);
        boolean isSequence = GridUtil.isTimeSequence(geoPH);
        FlatField sample = (FlatField)(isSequence ? geoPH.getSample(0) : geoPH);
        FunctionType newFFType = new FunctionType(((FunctionType)sample.getType()).getDomain(), AirPressure.getRealType());
        Object press = null;
        FieldImpl newPress = null;
        if (ensble.booleanValue()) {
            FieldImpl sample1 = (FieldImpl)geoPH.getSample(0);
            newPress = DerivedGridFactory.createPressureGrid(sample1);
        } else {
            newPress = GridUtil.isTimeSequence(geoPH) ? DerivedGridFactory.createPressureGrid(geoPH) : DerivedGridFactory.createPressureGrid(geoPH);
        }
        return newPress;
    }

    public static FieldImpl convertToAirPressure(FieldImpl press) throws VisADException, RemoteException {
        FieldImpl newPress = null;
        boolean isSequence = GridUtil.isTimeSequence(press);
        FlatField sample = (FlatField)(isSequence ? press.getSample(0) : press);
        Unit[] oldUnits = Util.getRangeUnits(sample);
        Unit[] newUnits = AirPressure.getRealTupleType().getDefaultUnits();
        FunctionType newFFType = new FunctionType(((FunctionType)sample.getType()).getDomain(), AirPressure.getRealType());
        if (isSequence) {
            SampledSet ss = (SampledSet)press.getDomainSet();
            FunctionType newFIType = new FunctionType(((FunctionType)press.getType()).getDomain(), newFFType);
            newPress = new FieldImpl(newFIType, ss);
            for (int i = 0; i < ss.getLength(); ++i) {
                FlatField timeSample = (FlatField)press.getSample(i, false);
                if (timeSample == null) continue;
                FlatField newSample = new FlatField(newFFType, timeSample.getDomainSet());
                float[][] values = timeSample.getFloats(false);
                float[][] newvals = Unit.convertTuple(values, oldUnits, newUnits);
                newSample.setSamples(newvals, false);
                newPress.setSample(i, (Data)newSample, false);
            }
        } else {
            newPress = new FlatField(newFFType, press.getDomainSet());
            float[][] values = sample.getFloats(false);
            float[][] newvals = Unit.convertTuple(values, oldUnits, newUnits);
            ((FlatField)newPress).setSamples(newvals, false);
        }
        return newPress;
    }

    public static FieldImpl createPotentialTemperature(FieldImpl temperFI, FieldImpl pressFI) throws VisADException, RemoteException {
        boolean TisSequence = GridUtil.isTimeSequence(temperFI);
        boolean PisSequence = GridUtil.isTimeSequence(pressFI);
        if (!GridUtil.getParamType(pressFI).equals(AirPressure.getRealTupleType())) {
            pressFI = DerivedGridFactory.convertToAirPressure(pressFI);
        }
        FieldImpl thetaFI = null;
        if (TisSequence) {
            Set timeSet = temperFI.getDomainSet();
            if (timeSet.getLength() > 1 && PisSequence) {
                pressFI = (FieldImpl)pressFI.resample(timeSet);
            }
            Boolean ensble = GridUtil.hasEnsemble(temperFI);
            TupleType rangeType = null;
            FunctionType innerType = null;
            for (int i = 0; i < timeSet.getLength(); ++i) {
                if (ensble.booleanValue()) {
                    FieldImpl sample1 = (FieldImpl)temperFI.getSample(i);
                    FieldImpl sample2 = PisSequence ? pressFI.getSample(i) : pressFI;
                    Set ensDomain = sample1.getDomainSet();
                    DataImpl funcFF = null;
                    for (int j = 0; j < ensDomain.getLength(); ++j) {
                        FlatField innerField1 = (FlatField)sample1.getSample(j, false);
                        FlatField innerField2 = (FlatField)(PisSequence ? (FlatField)sample2.getSample(j, false) : sample2);
                        if (innerField1 == null || innerField2 == null) continue;
                        FlatField innerdivFF = (FlatField)PotentialTemperature.create(innerField2, innerField1);
                        if (rangeType == null) {
                            rangeType = GridUtil.getParamType(innerdivFF);
                            innerType = new FunctionType(DataUtility.getDomainType(ensDomain), innerdivFF.getType());
                        }
                        if (j == 0) {
                            funcFF = new FieldImpl(innerType, ensDomain);
                        }
                        ((FieldImpl)funcFF).setSample(j, innerdivFF, false);
                    }
                    if (thetaFI == null) {
                        FunctionType newFieldType = new FunctionType(((SetType)timeSet.getType()).getDomain(), funcFF.getType());
                        thetaFI = new FieldImpl(newFieldType, timeSet);
                    }
                    ((FieldImpl)thetaFI).setSample(i, funcFF, false);
                    continue;
                }
                FlatField thetaFF = (FlatField)PotentialTemperature.create(PisSequence ? pressFI.getSample(i) : pressFI, (FlatField)temperFI.getSample(i));
                if (i == 0) {
                    FunctionType functionType = new FunctionType(((FunctionType)temperFI.getType()).getDomain(), thetaFF.getType());
                    thetaFI = new FieldImpl(functionType, timeSet);
                }
                ((FieldImpl)thetaFI).setSample(i, (Data)thetaFF, false);
            }
        } else {
            thetaFI = (FlatField)PotentialTemperature.create(temperFI, PisSequence ? pressFI.getSample(0) : pressFI);
        }
        return thetaFI;
    }

    public static FieldImpl createSatEquivalentPotentialTemperature(FieldImpl temperFI, FieldImpl pressFI) throws VisADException, RemoteException {
        boolean TisSequence = GridUtil.isTimeSequence(temperFI);
        boolean PisSequence = GridUtil.isTimeSequence(pressFI);
        if (!GridUtil.getParamType(pressFI).equals(AirPressure.getRealTupleType())) {
            pressFI = DerivedGridFactory.convertToAirPressure(pressFI);
        }
        FieldImpl thetaFI = null;
        if (TisSequence) {
            Set timeSet = temperFI.getDomainSet();
            if (timeSet.getLength() > 1 && PisSequence) {
                pressFI = (FieldImpl)pressFI.resample(timeSet);
            }
            Boolean ensble = GridUtil.hasEnsemble(temperFI);
            TupleType rangeType = null;
            FunctionType innerType = null;
            for (int i = 0; i < timeSet.getLength(); ++i) {
                if (ensble.booleanValue()) {
                    FieldImpl sample1 = (FieldImpl)temperFI.getSample(i);
                    FieldImpl sample2 = PisSequence ? pressFI.getSample(i) : pressFI;
                    Set ensDomain = sample1.getDomainSet();
                    DataImpl funcFF = null;
                    for (int j = 0; j < ensDomain.getLength(); ++j) {
                        FlatField innerField1 = (FlatField)sample1.getSample(j, false);
                        FlatField innerField2 = (FlatField)(PisSequence ? (FlatField)sample2.getSample(j, false) : sample2);
                        if (innerField1 == null || innerField2 == null) continue;
                        FlatField innerdivFF = (FlatField)SaturationEquivalentPotentialTemperature.create(innerField2, innerField1);
                        if (rangeType == null) {
                            rangeType = GridUtil.getParamType(innerdivFF);
                            innerType = new FunctionType(DataUtility.getDomainType(ensDomain), innerdivFF.getType());
                        }
                        if (j == 0) {
                            funcFF = new FieldImpl(innerType, ensDomain);
                        }
                        ((FieldImpl)funcFF).setSample(j, innerdivFF, false);
                    }
                    if (thetaFI == null) {
                        FunctionType newFieldType = new FunctionType(((SetType)timeSet.getType()).getDomain(), funcFF.getType());
                        thetaFI = new FieldImpl(newFieldType, timeSet);
                    }
                    ((FieldImpl)thetaFI).setSample(i, funcFF, false);
                    continue;
                }
                FlatField thetaFF = (FlatField)SaturationEquivalentPotentialTemperature.create(PisSequence ? pressFI.getSample(i) : pressFI, (FlatField)temperFI.getSample(i));
                if (i == 0) {
                    FunctionType functionType = new FunctionType(((FunctionType)temperFI.getType()).getDomain(), thetaFF.getType());
                    thetaFI = new FieldImpl(functionType, timeSet);
                }
                ((FieldImpl)thetaFI).setSample(i, (Data)thetaFF, false);
            }
        } else {
            thetaFI = (FlatField)SaturationEquivalentPotentialTemperature.create(temperFI, PisSequence ? pressFI.getSample(0) : pressFI);
        }
        return thetaFI;
    }

    public static FieldImpl createIPV(FieldImpl temperFI, FieldImpl absvor) throws VisADException, RemoteException {
        Boolean ensble = GridUtil.hasEnsemble(temperFI);
        FlatField press = null;
        if (ensble.booleanValue()) {
            FieldImpl sample1 = (FieldImpl)temperFI.getSample(0);
            press = DerivedGridFactory.createPressureGridFromDomain((FlatField)sample1.getSample(0, false));
        } else {
            press = GridUtil.isTimeSequence(temperFI) ? DerivedGridFactory.createPressureGridFromDomain((FlatField)temperFI.getSample(0)) : DerivedGridFactory.createPressureGridFromDomain((FlatField)temperFI);
        }
        return DerivedGridFactory.createIPV(temperFI, press, absvor);
    }

    public static FieldImpl createIPV(FieldImpl temperFI, FieldImpl pressFI, FieldImpl absvor) throws VisADException, RemoteException {
        boolean TisSequence = GridUtil.isTimeSequence(temperFI);
        boolean PisSequence = GridUtil.isTimeSequence(pressFI);
        FieldImpl ipvFI = null;
        FlatField dtdp = null;
        RealType pressure = null;
        Object dthdp = null;
        FunctionType ipvFFType = null;
        if (TisSequence) {
            Set timeSet = temperFI.getDomainSet();
            if (timeSet.getLength() > 1 && PisSequence) {
                pressFI = (FieldImpl)pressFI.resample(timeSet);
            }
            Real g = Gravity.newReal();
            Boolean ensble = GridUtil.hasEnsemble(temperFI) && GridUtil.hasEnsemble(absvor);
            TupleType rangeType = null;
            FunctionType innerType = null;
            for (int i = 0; i < timeSet.getLength(); ++i) {
                if (ensble.booleanValue()) {
                    FieldImpl sample1 = (FieldImpl)temperFI.getSample(i);
                    FieldImpl sample2 = PisSequence ? pressFI.getSample(0) : pressFI;
                    FieldImpl sample3 = (FieldImpl)absvor.getSample(i);
                    Set ensDomain = sample1.getDomainSet();
                    DataImpl funcFF = null;
                    for (int j = 0; j < ensDomain.getLength(); ++j) {
                        FlatField innerField1 = (FlatField)sample1.getSample(j, false);
                        FlatField innerField2 = (FlatField)(PisSequence ? (FlatField)sample2.getSample(j, false) : sample2);
                        FlatField innerField3 = (FlatField)sample3.getSample(j, false);
                        if (innerField1 == null || innerField2 == null) continue;
                        FlatField innerdivFF = (FlatField)PotentialTemperature.create(innerField2, innerField1);
                        if (pressure == null) {
                            pressure = (RealType)((FunctionType)innerdivFF.getType()).getDomain().getComponent(2);
                        }
                        if (!Unit.canConvert(pressure.getDefaultUnit(), CommonUnits.HECTOPASCAL)) {
                            throw new VisADException("Need a pressure vertical coordinate");
                        }
                        dtdp = (FlatField)GridMath.partial((FieldImpl)innerdivFF, 2);
                        dtdp = (FlatField)dtdp.multiply(g).negate();
                        dtdp = (FlatField)dtdp.multiply(innerField3);
                        if (rangeType == null) {
                            Unit ipvUnit = dtdp.getRangeUnits()[0][0];
                            RealType ipvRT = DataUtil.makeRealType("ipv", ipvUnit);
                            ipvFFType = new FunctionType(((FunctionType)dtdp.getType()).getDomain(), ipvRT);
                            rangeType = GridUtil.getParamType(innerdivFF);
                            innerType = new FunctionType(DataUtility.getDomainType(ensDomain), ipvFFType);
                        }
                        if (j == 0) {
                            funcFF = new FieldImpl(innerType, ensDomain);
                        }
                        dtdp = (FlatField)dtdp.changeMathType(ipvFFType);
                        ((FieldImpl)funcFF).setSample(j, dtdp, false);
                    }
                    if (ipvFI == null) {
                        FunctionType newFieldType = new FunctionType(((SetType)timeSet.getType()).getDomain(), funcFF.getType());
                        ipvFI = new FieldImpl(newFieldType, timeSet);
                    }
                    ipvFI.setSample(i, funcFF, false);
                    continue;
                }
                FlatField thetaFF = (FlatField)PotentialTemperature.create(PisSequence ? pressFI.getSample(0) : pressFI, (FlatField)temperFI.getSample(i));
                if (i == 0) {
                    pressure = (RealType)((FunctionType)thetaFF.getType()).getDomain().getComponent(2);
                }
                if (!Unit.canConvert(pressure.getDefaultUnit(), CommonUnits.HECTOPASCAL)) {
                    throw new VisADException("Need a pressure vertical coordinate");
                }
                dtdp = (FlatField)GridMath.partial((FieldImpl)thetaFF, 2);
                dtdp = (FlatField)dtdp.multiply(g).negate();
                dtdp = (FlatField)dtdp.multiply((FlatField)absvor.getSample(i));
                if (i == 0) {
                    Unit ipvUnit = dtdp.getRangeUnits()[0][0];
                    RealType ipvRT = DataUtil.makeRealType("ipv", ipvUnit);
                    ipvFFType = new FunctionType(((FunctionType)dtdp.getType()).getDomain(), ipvRT);
                    FunctionType functionType = new FunctionType(((FunctionType)temperFI.getType()).getDomain(), ipvFFType);
                    ipvFI = new FieldImpl(functionType, timeSet);
                }
                dtdp = (FlatField)dtdp.changeMathType(ipvFFType);
                ipvFI.setSample(i, (Data)dtdp, false);
            }
        } else {
            System.out.println("   not GridUtil.isTimeSequence(temperFI) ");
        }
        return ipvFI;
    }

    public static FieldImpl createPotentialVorticity(FieldImpl thetaFI, FieldImpl vectorFI) throws VisADException, RemoteException {
        FieldImpl absvorFI = DerivedGridFactory.createAbsoluteVorticity(DerivedGridFactory.getUComponent(vectorFI), DerivedGridFactory.getVComponent(vectorFI));
        boolean TisSequence = GridUtil.isTimeSequence(thetaFI);
        boolean AisSequence = GridUtil.isTimeSequence(absvorFI);
        FieldImpl pvorFI = null;
        Object dthdp = null;
        FunctionType pvorFIType = null;
        if (TisSequence) {
            Set timeSet = thetaFI.getDomainSet();
            if (timeSet.getLength() > 1 && AisSequence) {
                absvorFI = (FieldImpl)absvorFI.resample(timeSet);
            }
            Boolean ensble = GridUtil.hasEnsemble(thetaFI) && GridUtil.hasEnsemble(vectorFI);
            TupleType rangeType = null;
            FunctionType innerType = null;
            for (int i = 0; i < timeSet.getLength(); ++i) {
                if (ensble.booleanValue()) {
                    FieldImpl sample1 = (FieldImpl)thetaFI.getSample(i);
                    FieldImpl sample2 = (FieldImpl)absvorFI.getSample(i);
                    Set ensDomain = sample1.getDomainSet();
                    DataImpl funcFF = null;
                    for (int j = 0; j < ensDomain.getLength(); ++j) {
                        FlatField innerField1 = (FlatField)sample1.getSample(j, false);
                        FlatField innerField2 = (FlatField)sample2.getSample(j, false);
                        if (innerField1 == null || innerField2 == null) continue;
                        FlatField innerdivFF = DerivedGridFactory.createPVOR(innerField1, innerField2);
                        if (rangeType == null) {
                            rangeType = GridUtil.getParamType(innerdivFF);
                            innerType = new FunctionType(DataUtility.getDomainType(ensDomain), innerdivFF.getType());
                        }
                        if (funcFF == null) {
                            funcFF = new FieldImpl(innerType, ensDomain);
                        }
                        ((FieldImpl)funcFF).setSample(j, innerdivFF, false);
                    }
                    if (pvorFI == null) {
                        FunctionType newFieldType = new FunctionType(((SetType)timeSet.getType()).getDomain(), funcFF.getType());
                        pvorFI = new FieldImpl(newFieldType, timeSet);
                    }
                    ((FieldImpl)pvorFI).setSample(i, funcFF, false);
                    continue;
                }
                FlatField pvorFF = DerivedGridFactory.createPVOR((FlatField)thetaFI.getSample(i), (FlatField)absvorFI.getSample(i));
                if (pvorFIType == null && pvorFF != null) {
                    pvorFIType = new FunctionType(((SetType)timeSet.getType()).getDomain(), pvorFF.getType());
                    pvorFI = new FieldImpl(pvorFIType, timeSet);
                }
                if (pvorFF == null) continue;
                ((FieldImpl)pvorFI).setSample(i, (Data)pvorFF, false);
            }
        } else {
            pvorFI = DerivedGridFactory.createPVOR((FlatField)thetaFI, (FlatField)absvorFI);
        }
        return pvorFI;
    }

    private static FlatField createPVOR(FlatField tempFF, FlatField absvor) throws VisADException, RemoteException {
        Real g = Gravity.newReal();
        RealType pressure = (RealType)((FunctionType)tempFF.getType()).getDomain().getComponent(2);
        if (!Unit.canConvert(pressure.getDefaultUnit(), CommonUnits.HECTOPASCAL)) {
            throw new VisADException("Need a pressure vertical coordinate");
        }
        FlatField dtdp = (FlatField)GridMath.partial((FieldImpl)tempFF, 2);
        dtdp = (FlatField)dtdp.multiply(g).negate();
        FlatField pvor = (FlatField)dtdp.multiply(absvor);
        Unit pvUnit = pvor.getRangeUnits()[0][0];
        RealType pvRT = DataUtil.makeRealType("pvor", pvUnit);
        pvor = (FlatField)GridUtil.setParamType((FieldImpl)pvor, pvRT, false);
        return pvor;
    }

    public static FlatField createPressureGridFromDomain(FlatField ff) throws VisADException, RemoteException {
        Gridded3DSet domainSet3D = (Gridded3DSet)ff.getDomainSet();
        int[] lengths = domainSet3D.getLengths();
        Unit[] rangeUnits = null;
        RealType presRT = AirPressure.getRealType();
        Object pressures = new float[][]{(float[])domainSet3D.getSamples()[2].clone()};
        RealTupleType RTT = ((FunctionType)ff.getType()).getDomain();
        Unit zUnit = RTT.getDefaultUnits()[2];
        if (Unit.canConvert(zUnit, CommonUnits.MILLIBAR)) {
            pressures = new float[][]{presRT.getDefaultUnit().toThis(pressures[0], domainSet3D.getSetUnits()[2])};
            rangeUnits = new Unit[]{presRT.getDefaultUnit()};
        } else if (Unit.canConvert(zUnit, CommonUnit.meter)) {
            pressures = AirPressure.getStandardAtmosphereCS().fromReference((float[][])pressures, new Unit[]{domainSet3D.getSetUnits()[2]});
            rangeUnits = new Unit[]{presRT.getDefaultUnit()};
        } else {
            throw new VisADException("can't create pressure from grid domain");
        }
        FunctionType funct = new FunctionType(RTT, presRT);
        FlatField pressureFF = new FlatField(funct, (Set)domainSet3D, (CoordinateSystem[])null, (Set[])null, rangeUnits);
        pressureFF.setSamples((float[][])pressures, false);
        return pressureFF;
    }

    public static FieldImpl createPressureGrid(FieldImpl ff) throws VisADException, RemoteException {
        Gridded3DSet domainSet3D = (Gridded3DSet)GridUtil.getSpatialDomain(ff);
        Set timeSet = ff.getDomainSet();
        int[] lengths = domainSet3D.getLengths();
        Unit[] rangeUnits = null;
        RealType presRT = AirPressure.getRealType();
        Object pressures = new float[][]{(float[])domainSet3D.getSamples()[2].clone()};
        RealTupleType RTT = ((FunctionType)ff.getType()).getDomain();
        Unit[] setUnit = domainSet3D.getSetUnits();
        Unit zUnit = setUnit[2];
        if (Unit.canConvert(zUnit, CommonUnits.MILLIBAR)) {
            pressures = new float[][]{presRT.getDefaultUnit().toThis(pressures[0], domainSet3D.getSetUnits()[2])};
            rangeUnits = new Unit[]{presRT.getDefaultUnit()};
        } else if (Unit.canConvert(zUnit, CommonUnit.meter)) {
            pressures = AirPressure.getStandardAtmosphereCS().fromReference((float[][])pressures, new Unit[]{domainSet3D.getSetUnits()[2]});
            rangeUnits = new Unit[]{presRT.getDefaultUnit()};
        } else {
            throw new VisADException("can't create pressure from grid domain");
        }
        FunctionType rangeFT = new FunctionType(((SetType)domainSet3D.getType()).getDomain(), presRT);
        FunctionType funct = new FunctionType(RTT, rangeFT);
        FieldImpl pressureFI = null;
        for (int i = 0; i < timeSet.getLength(); ++i) {
            FlatField pressureFF = new FlatField(rangeFT, domainSet3D);
            pressureFF.setSamples((float[][])pressures, false);
            if (i == 0) {
                pressureFI = new FieldImpl(funct, timeSet);
            }
            pressureFI.setSample(i, (Data)pressureFF, false);
        }
        return pressureFI;
    }

    public static FieldImpl combineGrids1(FieldImpl grid1, FieldImpl grid2) throws VisADException, RemoteException {
        FieldImpl uv = DerivedGridFactory.getComponent(grid1, 0, true);
        FieldImpl alt = DerivedGridFactory.getComponent(grid1, 1, true);
        boolean copy = true;
        FlatField pFI = DerivedGridFactory.createPressureGridFromDomain((FlatField)grid2.getSample(0));
        FieldImpl hPI = DerivedGridFactory.convertPressureToHeight(pFI);
        float[][][] dataAP = DerivedGridFactory.convert3Darray((FlatField)hPI, 0);
        boolean isDecrese = dataAP[1][1][0] > dataAP[1][1][1];
        GriddedSet domainSet = (GriddedSet)GridUtil.getSpatialDomain(alt);
        TupleType paramType = GridUtil.getParamType(grid2);
        FunctionType rangeFT = new FunctionType(((SetType)domainSet.getType()).getDomain(), paramType);
        FieldImpl newFieldImpl = null;
        if (GridUtil.isSequence(grid2)) {
            try {
                FunctionType newFieldType;
                Set sequenceSet = Util.getDomainSet(grid2);
                int numSteps = sequenceSet.getLength();
                RealTupleType sequenceType = ((SetType)sequenceSet.getType()).getDomain();
                FieldImpl firstSample = (FieldImpl)grid2.getSample(0, false);
                boolean hasInnerSteps = GridUtil.isSequence(firstSample);
                FunctionType innerFieldType = null;
                if (!GridUtil.isSequence(firstSample)) {
                    newFieldType = new FunctionType(sequenceType, rangeFT);
                } else {
                    hasInnerSteps = true;
                    innerFieldType = new FunctionType(((FunctionType)firstSample.getType()).getDomain(), rangeFT);
                    newFieldType = new FunctionType(sequenceType, innerFieldType);
                }
                newFieldImpl = new FieldImpl(newFieldType, sequenceSet);
                for (int i = 0; i < numSteps; ++i) {
                    FieldImpl fi;
                    FieldImpl data = (FieldImpl)grid2.getSample(i, false);
                    float[][] dataAlt = DerivedGridFactory.convert2Darray((FlatField)alt.getSample(0), 0);
                    if (data.isMissing()) {
                        fi = data;
                    } else {
                        float[][][] dataA = DerivedGridFactory.convert3Darray((FlatField)data, 0);
                        int sizeX = domainSet.getLengths()[0];
                        int sizeY = domainSet.getLengths()[1];
                        float[][] newdata = new float[1][sizeX * sizeY];
                        for (int jj = 0; jj < sizeY; ++jj) {
                            for (int ii = 0; ii < sizeX; ++ii) {
                                newdata[0][jj * sizeX + ii] = DerivedGridFactory.linearInterpolateHeight(dataAP[jj][ii], dataA[jj][ii], dataAlt[jj][ii], isDecrese);
                            }
                        }
                        fi = new FlatField(rangeFT, domainSet);
                        ((FlatField)fi).setSamples(newdata, false);
                    }
                    newFieldImpl.setSample(i, (Data)fi);
                }
            }
            catch (RemoteException remoteException) {}
        } else if (!grid2.isMissing()) {
            newFieldImpl = new FlatField(rangeFT, domainSet);
            try {
                ((FlatField)newFieldImpl).setSamples(grid2.getFloats(copy), false);
            }
            catch (RemoteException remoteException) {}
        } else {
            newFieldImpl = grid2;
        }
        return DerivedGridFactory.combineGrids(uv, newFieldImpl, alt);
    }

    public static FieldImpl extractGridOverThetaTopoSurface(FieldImpl theta, float theta0) throws VisADException, RemoteException {
        boolean copy = true;
        FlatField pFI = DerivedGridFactory.createPressureGridFromDomain((FlatField)theta.getSample(0));
        FieldImpl hPI = DerivedGridFactory.convertPressureToHeight(pFI);
        float[][][] dataAA = DerivedGridFactory.convert3Darray((FlatField)theta.getSample(0), 0);
        float[][][] dataAP = DerivedGridFactory.convert3Darray((FlatField)hPI, 0);
        boolean isDecrese = dataAA[1][1][0] > dataAA[1][1][1];
        GriddedSet domainSet = (GriddedSet)GridUtil.getSpatialDomain(theta);
        if (domainSet.getDimension() != 3) {
            throw new VisADException("slice is not 3D ");
        }
        Gridded2DSet new2DDomainSet = GridUtil.makeDomain2D(domainSet);
        TupleType paramType = GridUtil.getParamType(theta);
        FunctionType rangeFT = new FunctionType(((SetType)new2DDomainSet.getType()).getDomain(), Altitude.getRealTupleType());
        FieldImpl newFieldImpl = null;
        if (GridUtil.isSequence(theta)) {
            try {
                FunctionType newFieldType;
                Set sequenceSet = Util.getDomainSet(theta);
                int numSteps = sequenceSet.getLength();
                RealTupleType sequenceType = ((SetType)sequenceSet.getType()).getDomain();
                FieldImpl firstSample = (FieldImpl)theta.getSample(0, false);
                boolean hasInnerSteps = GridUtil.isSequence(firstSample);
                FunctionType innerFieldType = null;
                if (!GridUtil.isSequence(firstSample)) {
                    newFieldType = new FunctionType(sequenceType, rangeFT);
                } else {
                    hasInnerSteps = true;
                    innerFieldType = new FunctionType(((FunctionType)firstSample.getType()).getDomain(), rangeFT);
                    newFieldType = new FunctionType(sequenceType, innerFieldType);
                }
                newFieldImpl = new FieldImpl(newFieldType, sequenceSet);
                for (int i = 0; i < numSteps; ++i) {
                    FieldImpl fi;
                    FieldImpl data = (FieldImpl)theta.getSample(i, false);
                    if (data.isMissing()) {
                        fi = data;
                    } else {
                        float[][][] dataA = DerivedGridFactory.convert3Darray((FlatField)data, 0);
                        int sizeX = ((Gridded3DSet)domainSet).getLengths()[0];
                        int sizeY = ((Gridded3DSet)domainSet).getLengths()[1];
                        float[][] newdata = new float[1][sizeX * sizeY];
                        for (int jj = 0; jj < sizeY; ++jj) {
                            for (int ii = 0; ii < sizeX; ++ii) {
                                newdata[0][jj * sizeX + ii] = DerivedGridFactory.linearInterpolateHeight(dataA[jj][ii], dataAP[jj][ii], theta0, isDecrese);
                            }
                        }
                        fi = new FlatField(rangeFT, new2DDomainSet);
                        ((FlatField)fi).setSamples(newdata, false);
                    }
                    newFieldImpl.setSample(i, (Data)fi);
                }
            }
            catch (RemoteException remoteException) {}
        } else if (!theta.isMissing()) {
            newFieldImpl = new FlatField(rangeFT, new2DDomainSet);
            try {
                ((FlatField)newFieldImpl).setSamples(theta.getFloats(copy), false);
            }
            catch (RemoteException remoteException) {}
        } else {
            newFieldImpl = theta;
        }
        return newFieldImpl;
    }

    public static FieldImpl extractVectorGridOverThetaTopoSurface(FieldImpl theta, FieldImpl vector, float theta0) throws VisADException, RemoteException {
        return DerivedGridFactory.extractUVGridOverThetaTopoSurface(theta, DerivedGridFactory.getUComponent(vector), DerivedGridFactory.getVComponent(vector), theta0);
    }

    public static FieldImpl extractGridADVOverThetaTopoSurface(FieldImpl theta, FieldImpl vector, FieldImpl other, float theta0) throws VisADException, RemoteException {
        boolean copy = true;
        FieldImpl uField = DerivedGridFactory.getUComponent(vector);
        FieldImpl vField = DerivedGridFactory.getVComponent(vector);
        FlatField pFI = DerivedGridFactory.createPressureGridFromDomain((FlatField)theta.getSample(0));
        FieldImpl hPI = DerivedGridFactory.convertPressureToHeight(pFI);
        float[][][] dataAA = DerivedGridFactory.convert3Darray((FlatField)theta.getSample(0), 0);
        float[][][] dataAP = DerivedGridFactory.convert3Darray((FlatField)hPI, 0);
        boolean isDecrese = dataAA[1][1][0] > dataAA[1][1][1];
        GriddedSet domainSet = (GriddedSet)GridUtil.getSpatialDomain(theta);
        if (domainSet.getDimension() != 3) {
            throw new VisADException("slice is not 3D ");
        }
        Gridded2DSet new2DDomainSet = GridUtil.makeDomain2D(domainSet);
        TupleType paramType1 = GridUtil.getParamType(uField);
        TupleType paramType2 = GridUtil.getParamType(vField);
        TupleType paramTypeo = GridUtil.getParamType(other);
        FunctionType rangeFT = new FunctionType(((SetType)new2DDomainSet.getType()).getDomain(), Altitude.getRealTupleType());
        FunctionType rangeFT1 = new FunctionType(((SetType)new2DDomainSet.getType()).getDomain(), paramType1);
        FunctionType rangeFT2 = new FunctionType(((SetType)new2DDomainSet.getType()).getDomain(), paramType2);
        FunctionType rangeFTo = new FunctionType(((SetType)new2DDomainSet.getType()).getDomain(), paramTypeo);
        FieldImpl newFieldImpl = null;
        FieldImpl newFieldImpl1 = null;
        FieldImpl newFieldImpl2 = null;
        FieldImpl newFieldImplo = null;
        FieldImpl advFieldImpl = null;
        if (GridUtil.isSequence(theta)) {
            try {
                FunctionType newFieldTypeo;
                FunctionType newFieldType2;
                FunctionType newFieldType1;
                FunctionType newFieldType;
                Set sequenceSet = Util.getDomainSet(theta);
                int numSteps = sequenceSet.getLength();
                RealTupleType sequenceType = ((SetType)sequenceSet.getType()).getDomain();
                FieldImpl firstSample = (FieldImpl)theta.getSample(0, false);
                boolean hasInnerSteps = GridUtil.isSequence(firstSample);
                FunctionType innerFieldType = null;
                FunctionType innerFieldType1 = null;
                FunctionType innerFieldType2 = null;
                FunctionType innerFieldTypeo = null;
                if (!GridUtil.isSequence(firstSample)) {
                    newFieldType = new FunctionType(sequenceType, rangeFT);
                    newFieldType1 = new FunctionType(sequenceType, rangeFT1);
                    newFieldType2 = new FunctionType(sequenceType, rangeFT2);
                    newFieldTypeo = new FunctionType(sequenceType, rangeFTo);
                } else {
                    hasInnerSteps = true;
                    innerFieldType = new FunctionType(((FunctionType)firstSample.getType()).getDomain(), rangeFT);
                    newFieldType = new FunctionType(sequenceType, innerFieldType);
                    innerFieldType1 = new FunctionType(((FunctionType)firstSample.getType()).getDomain(), rangeFT1);
                    newFieldType1 = new FunctionType(sequenceType, innerFieldType1);
                    innerFieldType2 = new FunctionType(((FunctionType)firstSample.getType()).getDomain(), rangeFT2);
                    newFieldType2 = new FunctionType(sequenceType, innerFieldType2);
                    innerFieldTypeo = new FunctionType(((FunctionType)firstSample.getType()).getDomain(), rangeFTo);
                    newFieldTypeo = new FunctionType(sequenceType, innerFieldTypeo);
                }
                newFieldImpl = new FieldImpl(newFieldType, sequenceSet);
                newFieldImpl1 = new FieldImpl(newFieldType1, sequenceSet);
                newFieldImpl2 = new FieldImpl(newFieldType2, sequenceSet);
                newFieldImplo = new FieldImpl(newFieldTypeo, sequenceSet);
                for (int i = 0; i < numSteps; ++i) {
                    FieldImpl fio;
                    FieldImpl fi2;
                    FieldImpl fi1;
                    FieldImpl fi;
                    FieldImpl data = (FieldImpl)theta.getSample(i, false);
                    FieldImpl dataU = (FieldImpl)uField.getSample(i, false);
                    FieldImpl dataV = (FieldImpl)vField.getSample(i, false);
                    FieldImpl dataO = (FieldImpl)other.getSample(i, false);
                    if (data.isMissing()) {
                        fi = data;
                        fi1 = dataU;
                        fi2 = dataV;
                        fio = dataO;
                    } else {
                        float[][][] dataA = DerivedGridFactory.convert3Darray((FlatField)data, 0);
                        float[][][] dataAU = DerivedGridFactory.convert3Darray((FlatField)dataU, 0);
                        float[][][] dataAV = DerivedGridFactory.convert3Darray((FlatField)dataV, 0);
                        float[][][] dataAO = DerivedGridFactory.convert3Darray((FlatField)dataO, 0);
                        int sizeX = ((Gridded3DSet)domainSet).getLengths()[0];
                        int sizeY = ((Gridded3DSet)domainSet).getLengths()[1];
                        float[][] newdata = new float[1][sizeX * sizeY];
                        float[][] newdataU = new float[1][sizeX * sizeY];
                        float[][] newdataV = new float[1][sizeX * sizeY];
                        float[][] newdataO = new float[1][sizeX * sizeY];
                        for (int jj = 0; jj < sizeY; ++jj) {
                            for (int ii = 0; ii < sizeX; ++ii) {
                                newdata[0][jj * sizeX + ii] = DerivedGridFactory.linearInterpolateHeight(dataA[jj][ii], dataAP[jj][ii], theta0, isDecrese);
                                newdataU[0][jj * sizeX + ii] = DerivedGridFactory.linearInterpolateHeight(dataA[jj][ii], dataAU[jj][ii], dataAP[jj][ii], theta0, isDecrese);
                                newdataV[0][jj * sizeX + ii] = DerivedGridFactory.linearInterpolateHeight(dataA[jj][ii], dataAV[jj][ii], dataAP[jj][ii], theta0, isDecrese);
                                newdataO[0][jj * sizeX + ii] = DerivedGridFactory.linearInterpolateHeight(dataA[jj][ii], dataAO[jj][ii], dataAP[jj][ii], theta0, isDecrese);
                            }
                        }
                        fi = new FlatField(rangeFT, new2DDomainSet);
                        fi1 = new FlatField(rangeFT1, new2DDomainSet);
                        fi2 = new FlatField(rangeFT2, new2DDomainSet);
                        fio = new FlatField(rangeFTo, new2DDomainSet);
                        ((FlatField)fi).setSamples(newdata, false);
                        ((FlatField)fi1).setSamples(newdataU, false);
                        ((FlatField)fi2).setSamples(newdataV, false);
                        ((FlatField)fio).setSamples(newdataO, false);
                    }
                    newFieldImpl.setSample(i, (Data)fi);
                    newFieldImpl1.setSample(i, (Data)fi1);
                    newFieldImpl2.setSample(i, (Data)fi2);
                    newFieldImplo.setSample(i, (Data)fio);
                }
                advFieldImpl = DerivedGridFactory.createHorizontalAdvection(newFieldImplo, newFieldImpl1, newFieldImpl2);
            }
            catch (RemoteException remoteException) {}
        } else if (!theta.isMissing()) {
            newFieldImpl = new FlatField(rangeFT, new2DDomainSet);
            try {
                ((FlatField)newFieldImpl).setSamples(theta.getFloats(copy), false);
            }
            catch (RemoteException remoteException) {}
        } else {
            newFieldImpl = theta;
        }
        return DerivedGridFactory.create2DTopography(advFieldImpl, newFieldImpl);
    }

    public static FieldImpl extractUVGridOverThetaTopoSurface(FieldImpl theta, FieldImpl other1, FieldImpl other2, float theta0) throws VisADException, RemoteException {
        boolean copy = true;
        FlatField pFI = DerivedGridFactory.createPressureGridFromDomain((FlatField)theta.getSample(0));
        FieldImpl hPI = DerivedGridFactory.convertPressureToHeight(pFI);
        float[][][] dataAA = DerivedGridFactory.convert3Darray((FlatField)theta.getSample(0), 0);
        float[][][] dataAP = DerivedGridFactory.convert3Darray((FlatField)hPI, 0);
        boolean isDecrese = dataAA[1][1][0] > dataAA[1][1][1];
        GriddedSet domainSet = (GriddedSet)GridUtil.getSpatialDomain(theta);
        if (domainSet.getDimension() != 3) {
            throw new VisADException("slice is not 3D ");
        }
        Gridded2DSet new2DDomainSet = GridUtil.makeDomain2D(domainSet);
        TupleType paramType1 = GridUtil.getParamType(other1);
        TupleType paramType2 = GridUtil.getParamType(other2);
        FunctionType rangeFT = new FunctionType(((SetType)new2DDomainSet.getType()).getDomain(), Altitude.getRealTupleType());
        FunctionType rangeFT1 = new FunctionType(((SetType)new2DDomainSet.getType()).getDomain(), paramType1);
        FunctionType rangeFT2 = new FunctionType(((SetType)new2DDomainSet.getType()).getDomain(), paramType2);
        FieldImpl newFieldImpl = null;
        FieldImpl newFieldImpl1 = null;
        FieldImpl newFieldImpl2 = null;
        if (GridUtil.isSequence(theta)) {
            try {
                FunctionType newFieldType2;
                FunctionType newFieldType1;
                FunctionType newFieldType;
                Set sequenceSet = Util.getDomainSet(theta);
                int numSteps = sequenceSet.getLength();
                RealTupleType sequenceType = ((SetType)sequenceSet.getType()).getDomain();
                FieldImpl firstSample = (FieldImpl)theta.getSample(0, false);
                boolean hasInnerSteps = GridUtil.isSequence(firstSample);
                FunctionType innerFieldType = null;
                FunctionType innerFieldType1 = null;
                FunctionType innerFieldType2 = null;
                if (!GridUtil.isSequence(firstSample)) {
                    newFieldType = new FunctionType(sequenceType, rangeFT);
                    newFieldType1 = new FunctionType(sequenceType, rangeFT1);
                    newFieldType2 = new FunctionType(sequenceType, rangeFT2);
                } else {
                    hasInnerSteps = true;
                    innerFieldType = new FunctionType(((FunctionType)firstSample.getType()).getDomain(), rangeFT);
                    newFieldType = new FunctionType(sequenceType, innerFieldType);
                    innerFieldType1 = new FunctionType(((FunctionType)firstSample.getType()).getDomain(), rangeFT1);
                    newFieldType1 = new FunctionType(sequenceType, innerFieldType1);
                    innerFieldType2 = new FunctionType(((FunctionType)firstSample.getType()).getDomain(), rangeFT2);
                    newFieldType2 = new FunctionType(sequenceType, innerFieldType2);
                }
                newFieldImpl = new FieldImpl(newFieldType, sequenceSet);
                newFieldImpl1 = new FieldImpl(newFieldType1, sequenceSet);
                newFieldImpl2 = new FieldImpl(newFieldType2, sequenceSet);
                for (int i = 0; i < numSteps; ++i) {
                    FieldImpl fi2;
                    FieldImpl fi1;
                    FieldImpl fi;
                    FieldImpl data = (FieldImpl)theta.getSample(i, false);
                    FieldImpl data1 = (FieldImpl)other1.getSample(i, false);
                    FieldImpl data2 = (FieldImpl)other2.getSample(i, false);
                    if (data.isMissing()) {
                        fi = data;
                        fi1 = data1;
                        fi2 = data2;
                    } else {
                        float[][][] dataA = DerivedGridFactory.convert3Darray((FlatField)data, 0);
                        float[][][] dataA1 = DerivedGridFactory.convert3Darray((FlatField)data1, 0);
                        float[][][] dataA2 = DerivedGridFactory.convert3Darray((FlatField)data2, 0);
                        int sizeX = ((Gridded3DSet)domainSet).getLengths()[0];
                        int sizeY = ((Gridded3DSet)domainSet).getLengths()[1];
                        float[][] newdata = new float[1][sizeX * sizeY];
                        float[][] newdata1 = new float[1][sizeX * sizeY];
                        float[][] newdata2 = new float[1][sizeX * sizeY];
                        for (int jj = 0; jj < sizeY; ++jj) {
                            for (int ii = 0; ii < sizeX; ++ii) {
                                newdata[0][jj * sizeX + ii] = DerivedGridFactory.linearInterpolateHeight(dataA[jj][ii], dataAP[jj][ii], theta0, isDecrese);
                                newdata1[0][jj * sizeX + ii] = DerivedGridFactory.linearInterpolateHeight(dataA[jj][ii], dataA1[jj][ii], dataAP[jj][ii], theta0, isDecrese);
                                newdata2[0][jj * sizeX + ii] = DerivedGridFactory.linearInterpolateHeight(dataA[jj][ii], dataA2[jj][ii], dataAP[jj][ii], theta0, isDecrese);
                            }
                        }
                        fi = new FlatField(rangeFT, new2DDomainSet);
                        fi1 = new FlatField(rangeFT1, new2DDomainSet);
                        fi2 = new FlatField(rangeFT2, new2DDomainSet);
                        ((FlatField)fi).setSamples(newdata, false);
                        ((FlatField)fi1).setSamples(newdata1, false);
                        ((FlatField)fi2).setSamples(newdata2, false);
                    }
                    newFieldImpl.setSample(i, (Data)fi);
                    newFieldImpl1.setSample(i, (Data)fi1);
                    newFieldImpl2.setSample(i, (Data)fi2);
                }
            }
            catch (RemoteException remoteException) {}
        } else if (!theta.isMissing()) {
            newFieldImpl = new FlatField(rangeFT, new2DDomainSet);
            try {
                ((FlatField)newFieldImpl).setSamples(theta.getFloats(copy), false);
            }
            catch (RemoteException remoteException) {}
        } else {
            newFieldImpl = theta;
        }
        return DerivedGridFactory.create2DTopography(DerivedGridFactory.createFlowVectors(newFieldImpl1, newFieldImpl2), newFieldImpl);
    }

    public static FieldImpl extractGridOverThetaTopoSurface(FieldImpl theta, FieldImpl other, float theta0) throws VisADException, RemoteException {
        boolean copy = true;
        FlatField pFI = DerivedGridFactory.createPressureGridFromDomain((FlatField)theta.getSample(0));
        FieldImpl hPI = DerivedGridFactory.convertPressureToHeight(pFI);
        float[][][] dataAP = DerivedGridFactory.convert3Darray((FlatField)hPI, 0);
        float[][][] dataAA = DerivedGridFactory.convert3Darray((FlatField)theta.getSample(0), 0);
        boolean isDecrese = dataAA[1][1][1] > dataAA[1][1][3];
        GriddedSet domainSet = (GriddedSet)GridUtil.getSpatialDomain(theta);
        if (domainSet.getDimension() != 3) {
            throw new VisADException("slice is not 3D ");
        }
        Gridded2DSet new2DDomainSet = GridUtil.makeDomain2D(domainSet);
        TupleType paramType = GridUtil.getParamType(other);
        FunctionType rangeFT = new FunctionType(((SetType)new2DDomainSet.getType()).getDomain(), Altitude.getRealTupleType());
        FunctionType rangeFT0 = new FunctionType(((SetType)new2DDomainSet.getType()).getDomain(), paramType);
        FieldImpl newFieldImpl = null;
        FieldImpl newFieldImpl0 = null;
        if (GridUtil.isSequence(theta)) {
            try {
                FunctionType newFieldType0;
                FunctionType newFieldType;
                Set sequenceSet = Util.getDomainSet(theta);
                int numSteps = sequenceSet.getLength();
                RealTupleType sequenceType = ((SetType)sequenceSet.getType()).getDomain();
                FieldImpl firstSample = (FieldImpl)theta.getSample(0, false);
                boolean hasInnerSteps = GridUtil.isSequence(firstSample);
                FunctionType innerFieldType = null;
                FunctionType innerFieldType0 = null;
                if (!GridUtil.isSequence(firstSample)) {
                    newFieldType = new FunctionType(sequenceType, rangeFT);
                    newFieldType0 = new FunctionType(sequenceType, rangeFT0);
                } else {
                    hasInnerSteps = true;
                    innerFieldType = new FunctionType(((FunctionType)firstSample.getType()).getDomain(), rangeFT);
                    newFieldType = new FunctionType(sequenceType, innerFieldType);
                    innerFieldType0 = new FunctionType(((FunctionType)firstSample.getType()).getDomain(), rangeFT0);
                    newFieldType0 = new FunctionType(sequenceType, innerFieldType0);
                }
                newFieldImpl = new FieldImpl(newFieldType, sequenceSet);
                newFieldImpl0 = new FieldImpl(newFieldType0, sequenceSet);
                for (int i = 0; i < numSteps; ++i) {
                    FieldImpl fi0;
                    FieldImpl fi;
                    FieldImpl data = (FieldImpl)theta.getSample(i, false);
                    FieldImpl data0 = (FieldImpl)other.getSample(i, false);
                    if (data.isMissing()) {
                        fi = data;
                        fi0 = data0;
                    } else {
                        int ii;
                        int jj;
                        float[][][] dataA = DerivedGridFactory.convert3Darray((FlatField)data, 0);
                        float[][][] dataA0 = DerivedGridFactory.convert3Darray((FlatField)data0, 0);
                        float[][][] dataA1 = null;
                        if (rangeFT0.getRealComponents().length == 2) {
                            dataA1 = DerivedGridFactory.convert3Darray((FlatField)data0, 1);
                        }
                        int sizeX = ((Gridded3DSet)domainSet).getLengths()[0];
                        int sizeY = ((Gridded3DSet)domainSet).getLengths()[1];
                        float[][] newdata = new float[1][sizeX * sizeY];
                        float[][] newdata0 = new float[1][sizeX * sizeY];
                        if (rangeFT0.getRealComponents().length == 2) {
                            newdata0 = new float[2][sizeX * sizeY];
                        }
                        float[][] newdata1 = new float[sizeY][sizeX];
                        for (jj = 0; jj < sizeY; ++jj) {
                            for (ii = 0; ii < sizeX; ++ii) {
                                newdata[0][jj * sizeX + ii] = DerivedGridFactory.linearInterpolateHeight(dataA[jj][ii], dataAP[jj][ii], theta0, isDecrese);
                                newdata0[0][jj * sizeX + ii] = DerivedGridFactory.linearInterpolateHeight(dataA[jj][ii], dataA0[jj][ii], dataAP[jj][ii], theta0, isDecrese);
                            }
                        }
                        if (rangeFT0.getRealComponents().length == 2) {
                            for (jj = 0; jj < sizeY; ++jj) {
                                for (ii = 0; ii < sizeX; ++ii) {
                                    newdata0[1][jj * sizeX + ii] = DerivedGridFactory.linearInterpolateHeight(dataA[jj][ii], dataA1[jj][ii], dataAP[jj][ii], theta0, isDecrese);
                                }
                            }
                        }
                        fi = new FlatField(rangeFT, new2DDomainSet);
                        fi0 = new FlatField(rangeFT0, new2DDomainSet);
                        ((FlatField)fi).setSamples(newdata, false);
                        ((FlatField)fi0).setSamples(newdata0, false);
                    }
                    newFieldImpl.setSample(i, (Data)fi);
                    newFieldImpl0.setSample(i, (Data)fi0);
                }
            }
            catch (RemoteException remoteException) {}
        } else if (!theta.isMissing()) {
            newFieldImpl = new FlatField(rangeFT, new2DDomainSet);
            try {
                ((FlatField)newFieldImpl).setSamples(theta.getFloats(copy), false);
            }
            catch (RemoteException remoteException) {}
        } else {
            newFieldImpl = theta;
        }
        return DerivedGridFactory.create2DTopography(newFieldImpl0, newFieldImpl);
    }

    public static float linearInterpolateHeight(float[] theta, float[] z, float theta0, boolean isDec) {
        int len = theta.length;
        int idx = 0;
        boolean jdx = false;
        if (isDec) {
            if (theta0 < theta[len - 1] || theta0 > theta[0]) {
                idx = 999;
                return Float.NaN;
            }
            idx = DerivedGridFactory.binaryIndexDec(theta, theta0);
        } else {
            if (theta0 > theta[len - 1] || theta0 < theta[0]) {
                idx = 999;
                return Float.NaN;
            }
            idx = DerivedGridFactory.binaryIndexInc(theta, theta0);
        }
        float delthata = theta[idx + 1] - theta[idx];
        float delz = z[idx + 1] - z[idx];
        float h = z[idx] + (theta0 - theta[idx]) * (delz / delthata);
        return h;
    }

    public static int binaryIndexDec(float[] a, float theta0) {
        int lowerBound = 0;
        int nElems = a.length;
        int upperBound = nElems - 1;
        while (true) {
            int curIn = (upperBound + lowerBound) / 2;
            if (nElems == 0) {
                curIn = 0;
                return 0;
            }
            if (lowerBound == curIn && a[curIn] < theta0) {
                return --curIn;
            }
            if (a[curIn] > theta0) {
                lowerBound = curIn + 1;
                if (lowerBound <= upperBound) continue;
                return curIn;
            }
            if (lowerBound > upperBound) {
                return curIn;
            }
            upperBound = curIn - 1;
        }
    }

    public static int binaryIndexInc(float[] a, float theta0) {
        int lowerBound = 0;
        int nElems = a.length;
        int upperBound = nElems - 1;
        while (true) {
            int curIn = (upperBound + lowerBound) / 2;
            if (nElems == 0) {
                curIn = 0;
                return 0;
            }
            if (lowerBound == curIn && a[curIn] > theta0) {
                return --curIn;
            }
            if (a[curIn] < theta0) {
                lowerBound = curIn + 1;
                if (lowerBound <= upperBound) continue;
                return curIn;
            }
            if (lowerBound > upperBound) {
                return curIn;
            }
            upperBound = curIn - 1;
        }
    }

    public static float linearInterpolateHeight(float[] theta, float[] other, float[] z, float theta0, boolean isDec) {
        int len = theta.length;
        int idx = 0;
        if (other.length == 1) {
            return other[0];
        }
        if (isDec) {
            if (theta0 < theta[len - 1] || theta0 > theta[0]) {
                idx = 999;
                return Float.NaN;
            }
            idx = DerivedGridFactory.binaryIndexDec(theta, theta0);
        } else {
            if (theta0 > theta[len - 1] || theta0 < theta[0]) {
                idx = 999;
                return Float.NaN;
            }
            idx = DerivedGridFactory.binaryIndexInc(theta, theta0);
        }
        float deltheta = theta[idx + 1] - theta[idx];
        float delother = other[idx + 1] - other[idx];
        float delz = z[idx + 1] - z[idx];
        float delh = (theta0 - theta[idx]) * (delz / deltheta);
        float o = other[idx] + delother / delz * delh;
        return o;
    }

    public static float[][][] convert3Darray(FlatField grid, int ii) throws VisADException, RemoteException {
        float[][] samples = grid.getFloats(false);
        GriddedSet domain = (GriddedSet)GridUtil.getSpatialDomain(grid);
        int[] lengths = domain.getLengths();
        int sizeX = 1;
        int sizeY = 1;
        int sizeZ = 1;
        if (lengths.length == 3) {
            sizeX = lengths[0];
            sizeY = lengths[1];
            sizeZ = lengths[2];
        } else {
            sizeX = lengths[0];
            sizeY = lengths[1];
        }
        float[][][] newgrid = new float[sizeY][sizeX][sizeZ];
        for (int k = 0; k < sizeZ; ++k) {
            for (int j = 0; j < lengths[1]; ++j) {
                for (int i = 0; i < lengths[0]; ++i) {
                    newgrid[j][i][k] = samples[ii][k * sizeY * sizeX + j * sizeX + i];
                }
            }
        }
        return newgrid;
    }

    public static float[][] convert2Darray(FlatField grid, int ii) throws VisADException, RemoteException {
        float[][] samples = grid.getFloats(false);
        GriddedSet domain = (GriddedSet)GridUtil.getSpatialDomain(grid);
        int[] lengths = domain.getLengths();
        int sizeX = lengths[0];
        int sizeY = lengths[1];
        float[][] newgrid = new float[sizeY][sizeX];
        for (int j = 0; j < lengths[1]; ++j) {
            for (int i = 0; i < lengths[0]; ++i) {
                newgrid[j][i] = samples[ii][j * sizeX + i];
            }
        }
        return newgrid;
    }

    public static FieldImpl mask(FieldImpl gridToMask, FieldImpl mask, float maskValue) throws VisADException {
        return DerivedGridFactory.mask(gridToMask, mask, maskValue, false);
    }

    public static FieldImpl mask(FieldImpl gridToMask, FieldImpl mask, float maskValue, boolean resampleToMask) throws VisADException {
        FieldImpl newField = null;
        FunctionType maskType = null;
        try {
            FlatField oneMask;
            FlatField flatField = oneMask = mask instanceof FlatField ? (FlatField)mask : (FlatField)mask.getSample(0);
            if (GridUtil.isTimeSequence(gridToMask)) {
                Set timeDomain = gridToMask.getDomainSet();
                for (int timeStepIdx = 0; timeStepIdx < timeDomain.getLength(); ++timeStepIdx) {
                    FieldImpl sample = (FieldImpl)gridToMask.getSample(timeStepIdx);
                    if (sample == null) continue;
                    FieldImpl maskFF = null;
                    if (!GridUtil.isSequence(sample)) {
                        maskFF = DerivedGridFactory.maskField((FlatField)sample, oneMask, maskValue, maskType, resampleToMask);
                    } else {
                        Set ensDomain = sample.getDomainSet();
                        for (int j = 0; j < ensDomain.getLength(); ++j) {
                            FlatField innerMaskedFF;
                            FlatField innerField = (FlatField)sample.getSample(j, false);
                            if (innerField == null || (innerMaskedFF = DerivedGridFactory.maskField(innerField, oneMask, maskValue, maskType, resampleToMask)) == null) continue;
                            if (maskType == null) {
                                maskType = (FunctionType)innerMaskedFF.getType();
                                FunctionType innerType = new FunctionType(DataUtility.getDomainType(ensDomain), maskType);
                                maskFF = new FieldImpl(innerType, ensDomain);
                            }
                            ((FieldImpl)maskFF).setSample(j, (Data)innerMaskedFF, false);
                        }
                    }
                    if (maskFF == null) continue;
                    if (maskType == null) {
                        maskType = (FunctionType)maskFF.getType();
                    }
                    if (newField == null) {
                        FunctionType newFieldType = new FunctionType(DataUtility.getDomainType(gridToMask), maskFF.getType());
                        newField = new FieldImpl(newFieldType, timeDomain);
                    }
                    ((FieldImpl)newField).setSample(timeStepIdx, (Data)maskFF, false);
                }
            } else {
                newField = DerivedGridFactory.maskField((FlatField)gridToMask, oneMask, maskValue, null, resampleToMask);
            }
            return newField;
        }
        catch (RemoteException re) {
            throw new VisADException("RemoteException in mask");
        }
    }

    private static FlatField maskField(FlatField gridToMask, FlatField mask, float maskValue, FunctionType newType, boolean resampleToMask) throws VisADException, RemoteException {
        FlatField newField = null;
        if (newType == null) {
            TupleType rangeType = GridUtil.makeNewParamType(GridUtil.getParamType(gridToMask), "_mask");
            newType = new FunctionType(DataUtility.getDomainType(gridToMask), rangeType);
        }
        if (resampleToMask) {
            gridToMask = (FlatField)gridToMask.resample(mask.getDomainSet());
        } else {
            mask = (FlatField)mask.resample(gridToMask.getDomainSet());
        }
        newField = new FlatField(newType, gridToMask.getDomainSet());
        float[][] maskValues = mask.getFloats(false);
        float[][] gridValues = gridToMask.getFloats(false);
        float[][] maskedValues = new float[gridValues.length][gridValues[0].length];
        for (int i = 0; i < gridValues.length; ++i) {
            for (int j = 0; j < gridValues[0].length; ++j) {
                float value = maskValues[i][j];
                maskedValues[i][j] = value == maskValue || Float.isNaN(value) ? Float.NaN : gridValues[i][j];
            }
        }
        newField.setSamples(maskedValues, false);
        return newField;
    }

    public static FieldImpl createCoriolisGrid(FieldImpl input) throws VisADException, RemoteException {
        return DerivedGridFactory.createLatitudeGrid(input, true);
    }

    public static FieldImpl getLatitudeGrid(FieldImpl fi) throws VisADException, RemoteException {
        return DerivedGridFactory.createLatitudeGrid(fi);
    }

    public static FieldImpl createLatitudeGrid(FieldImpl fi) throws VisADException, RemoteException {
        return DerivedGridFactory.createLatitudeGrid(fi, false);
    }

    private static FieldImpl createLatitudeGrid(FieldImpl fi, boolean makeCoriolis) throws VisADException, RemoteException {
        SampledSet ss = GridUtil.getSpatialDomain(fi);
        RealTupleType spatialDomType = ((SetType)ss.getType()).getDomain();
        RealType latType = DerivedGridFactory.findComponent(spatialDomType, "lat", RealType.Latitude);
        RealType lonType = DerivedGridFactory.findComponent(spatialDomType, "lon", RealType.Longitude);
        boolean domIsLatLon = true;
        if (latType == null || lonType == null) {
            domIsLatLon = false;
            CoordinateSystem cs = spatialDomType.getCoordinateSystem();
            if (cs == null) {
                throw new IllegalArgumentException("Not lat/lon domain " + spatialDomType.toString());
            }
            RealTupleType spatialDomRefType = cs.getReference();
            latType = DerivedGridFactory.findComponent(spatialDomRefType, "lat", RealType.Latitude);
            lonType = DerivedGridFactory.findComponent(spatialDomRefType, "lon", RealType.Longitude);
            if (latType == null || lonType == null) {
                throw new IllegalArgumentException("Not lat/lon domain " + spatialDomRefType.toString());
            }
        }
        FieldImpl latField = null;
        if (GridUtil.isTimeSequence(fi)) {
            Set timeSet = fi.getDomainSet();
            boolean isConstantDomain = GridUtil.isConstantSpatialDomain(fi);
            DataImpl latFF = null;
            Boolean ensble = GridUtil.hasEnsemble(fi);
            TupleType rangeType = null;
            FunctionType innerType = null;
            for (int i = 0; i < timeSet.getLength(); ++i) {
                DataImpl funcFF = null;
                if (ensble.booleanValue()) {
                    FieldImpl sample1 = (FieldImpl)fi.getSample(i);
                    Set ensDomain = sample1.getDomainSet();
                    for (int j = 0; j < ensDomain.getLength(); ++j) {
                        FlatField innerField1 = (FlatField)sample1.getSample(j, false);
                        if (innerField1 == null) continue;
                        FlatField innerlatFF = null;
                        if (!isConstantDomain || latFF == null) {
                            innerlatFF = DerivedGridFactory.createLatitudeBasedGrid(innerField1, latType, domIsLatLon, makeCoriolis);
                        }
                        if (rangeType == null) {
                            rangeType = GridUtil.getParamType(innerlatFF);
                            innerType = new FunctionType(DataUtility.getDomainType(ensDomain), innerlatFF.getType());
                        }
                        if (j == 0) {
                            funcFF = new FieldImpl(innerType, ensDomain);
                        }
                        ((FieldImpl)funcFF).setSample(j, innerlatFF, false);
                    }
                    if (latField == null) {
                        FunctionType newFieldType = new FunctionType(((SetType)timeSet.getType()).getDomain(), funcFF.getType());
                        latField = new FieldImpl(newFieldType, timeSet);
                    }
                    ((FieldImpl)latField).setSample(i, funcFF, false);
                    continue;
                }
                if (!isConstantDomain || latFF == null) {
                    latFF = DerivedGridFactory.createLatitudeBasedGrid((FlatField)fi.getSample(i, false), latType, domIsLatLon, makeCoriolis);
                }
                if (i == 0) {
                    FunctionType latFIType = new FunctionType(DataUtility.getDomainType(timeSet), (FunctionType)latFF.getType());
                    latField = new FieldImpl(latFIType, timeSet);
                }
                ((FieldImpl)latField).setSample(i, latFF);
            }
        } else {
            latField = DerivedGridFactory.createLatitudeBasedGrid((FlatField)fi, latType, domIsLatLon, makeCoriolis);
        }
        return latField;
    }

    public static FieldImpl createLongitudeGrid(FieldImpl fi) throws VisADException, RemoteException {
        SampledSet ss = GridUtil.getSpatialDomain(fi);
        RealTupleType spatialDomType = ((SetType)ss.getType()).getDomain();
        RealType latType = DerivedGridFactory.findComponent(spatialDomType, "lat", RealType.Latitude);
        RealType lonType = DerivedGridFactory.findComponent(spatialDomType, "lon", RealType.Longitude);
        boolean domIsLatLon = true;
        if (latType == null || lonType == null) {
            domIsLatLon = false;
            CoordinateSystem cs = spatialDomType.getCoordinateSystem();
            if (cs == null) {
                throw new IllegalArgumentException("Not lat/lon domain " + spatialDomType.toString());
            }
            RealTupleType spatialDomRefType = cs.getReference();
            latType = DerivedGridFactory.findComponent(spatialDomRefType, "lat", RealType.Latitude);
            lonType = DerivedGridFactory.findComponent(spatialDomRefType, "lon", RealType.Longitude);
            if (latType == null || lonType == null) {
                throw new IllegalArgumentException("Not lat/lon domain " + spatialDomRefType.toString());
            }
        }
        FieldImpl lonField = null;
        if (GridUtil.isTimeSequence(fi)) {
            Set timeSet = fi.getDomainSet();
            boolean isConstantDomain = GridUtil.isConstantSpatialDomain(fi);
            FlatField lonFF = null;
            for (int i = 0; i < timeSet.getLength(); ++i) {
                if (!isConstantDomain || lonFF == null) {
                    lonFF = DerivedGridFactory.createLongitudeBasedGrid((FlatField)fi.getSample(i, false), lonType, domIsLatLon);
                }
                if (i == 0) {
                    FunctionType lonFIType = new FunctionType(DataUtility.getDomainType(timeSet), (FunctionType)lonFF.getType());
                    lonField = new FieldImpl(lonFIType, timeSet);
                }
                ((FieldImpl)lonField).setSample(i, lonFF);
            }
        } else {
            lonField = DerivedGridFactory.createLongitudeBasedGrid((FlatField)fi, lonType, domIsLatLon);
        }
        return lonField;
    }

    private static FlatField createLatitudeBasedGrid(FlatField ff, RealType latType, boolean domIsLatLon, boolean makeCoriolis) throws VisADException, RemoteException {
        SampledSet g3dset = GridUtil.getSpatialDomain(ff);
        RealTupleType rTT = ((FunctionType)ff.getType()).getDomain();
        FunctionType FT = null;
        FT = makeCoriolis ? new FunctionType(rTT, (RealType)EARTH_TWO_OMEGA.getType()) : new FunctionType(rTT, RealType.Latitude);
        FlatField latff = new FlatField(FT, g3dset);
        float[] lats = null;
        if (domIsLatLon) {
            int latI = rTT.getIndex(latType);
            if (latI == -1) {
                throw new IllegalArgumentException(rTT.toString());
            }
            lats = (float[])g3dset.getSamples(false)[latI].clone();
        } else {
            CoordinateSystem cs = g3dset.getCoordinateSystem();
            RealTupleType refType = cs.getReference();
            int latI = refType.getIndex(latType);
            if (latI == -1) {
                throw new IllegalArgumentException(refType.toString());
            }
            float[][] flatlon = cs.toReference(g3dset.getSamples(), g3dset.getSetUnits());
            lats = flatlon[latI];
        }
        if (makeCoriolis) {
            double twoOmega = EARTH_TWO_OMEGA.getValue();
            for (int i = 0; i < lats.length; ++i) {
                lats[i] = (float)(Math.sin(Math.toRadians(lats[i])) * twoOmega);
                if (!((double)Math.abs(lats[i]) < 1.25E-5)) continue;
                lats[i] = Float.NaN;
            }
        }
        latff.setSamples(new float[][]{lats}, false);
        return latff;
    }

    public static FlatField mergeTracks(List datas) throws VisADException {
        if (datas.isEmpty()) {
            return null;
        }
        if (datas.size() == 1) {
            return (FlatField)datas.get(0);
        }
        FlatField retField = null;
        try {
            int numObs = 0;
            GriddedSet domainSet = null;
            FlatField ff = null;
            for (int i = 0; i < datas.size(); ++i) {
                ff = (FlatField)datas.get(i);
                domainSet = (GriddedSet)ff.getDomainSet();
                numObs += domainSet.getLength();
            }
            FunctionType retType = (FunctionType)ff.getType();
            Set[] rset = ff.getRangeSets();
            Unit[][] uset = ff.getRangeUnits();
            RealTupleType rtt = DataUtility.getFlatRangeType(ff);
            double[][] domainVals = new double[domainSet.getDimension()][numObs += datas.size()];
            double[][] values = new double[rtt.getDimension()][numObs];
            int curPos = 0;
            for (int i = 0; i < datas.size(); ++i) {
                int j;
                FlatField data = (FlatField)datas.get(i);
                GriddedSet dset = (GriddedSet)data.getDomainSet();
                double[][] samples = dset.getDoubles(false);
                int length = dset.getLength();
                double[][] vals = data.getValues(false);
                for (j = 0; j < samples.length; ++j) {
                    System.arraycopy(samples[j], 0, domainVals[j], curPos, length);
                    domainVals[j][length + curPos] = Double.NaN;
                }
                for (j = 0; j < vals.length; ++j) {
                    System.arraycopy(vals[j], 0, values[j], curPos, length);
                    values[j][length + curPos] = values[j][length + curPos - 1];
                }
                curPos += length + 1;
            }
            GriddedSet newDomain = null;
            newDomain = domainSet instanceof Gridded1DDoubleSet ? new Gridded1DDoubleSet(domainSet.getType(), domainVals, numObs, domainSet.getCoordinateSystem(), domainSet.getSetUnits(), domainSet.getSetErrors()) : GriddedSet.create(domainSet.getType(), Set.doubleToFloat(domainVals), new int[]{numObs}, domainSet.getCoordinateSystem(), domainSet.getSetUnits(), domainSet.getSetErrors());
            retField = new FlatField(retType, (Set)newDomain, domainSet.getCoordinateSystem(), rset, new Unit[]{uset[0][0], uset[1][0]});
            retField.setSamples(values, false);
        }
        catch (RemoteException re) {
            throw new VisADException("got RemoteException " + re);
        }
        return retField;
    }

    public static float[] subArray(float[] a, int start, int count, int strike) {
        float[] b = new float[count];
        for (int i = 0; i < count; ++i) {
            b[i] = a[i + start];
        }
        return b;
    }

    public static double[] subArray(double[] a, int start, int count, int strike) {
        double[] b = new double[count];
        for (int i = 0; i < count; ++i) {
            b[i] = a[i + start];
        }
        return b;
    }

    private static FlatField createLongitudeBasedGrid(FlatField ff, RealType lonType, boolean domIsLatLon) throws VisADException, RemoteException {
        SampledSet g3dset = GridUtil.getSpatialDomain(ff);
        RealTupleType rTT = ((FunctionType)ff.getType()).getDomain();
        FunctionType FT = null;
        FT = new FunctionType(rTT, RealType.Longitude);
        FlatField lonff = new FlatField(FT, g3dset);
        float[] lons = null;
        if (domIsLatLon) {
            int lonI = rTT.getIndex(lonType);
            if (lonI == -1) {
                throw new IllegalArgumentException(rTT.toString());
            }
            lons = (float[])g3dset.getSamples(false)[lonI].clone();
        } else {
            CoordinateSystem cs = g3dset.getCoordinateSystem();
            RealTupleType refType = cs.getReference();
            int lonI = refType.getIndex(lonType);
            if (lonI == -1) {
                throw new IllegalArgumentException(refType.toString());
            }
            float[][] flatlon = cs.toReference(g3dset.getSamples(), g3dset.getSetUnits());
            lons = flatlon[lonI];
        }
        lonff.setSamples(new float[][]{lons}, false);
        return lonff;
    }

    public static FieldImpl ddx(FieldImpl grid) throws VisADException, RemoteException {
        return GridMath.ddx(grid);
    }

    public static FieldImpl ddy(FieldImpl grid) throws VisADException, RemoteException {
        return GridMath.ddy(grid);
    }

    public static FieldImpl partial(FieldImpl grid, int domainIndex) throws VisADException, RemoteException {
        return GridMath.partial(grid, domainIndex);
    }

    public static boolean isVector(FieldImpl grid) throws VisADException {
        TupleType tt = GridUtil.getParamType(grid);
        boolean isVector = false;
        isVector = tt instanceof EarthVectorType ? true : tt.getDimension() > 1;
        return isVector;
    }

    public static boolean isScalar(FieldImpl grid) throws VisADException {
        return !DerivedGridFactory.isVector(grid);
    }

    public static FieldImpl getUComponent(FieldImpl vector) throws VisADException {
        return DerivedGridFactory.getUComponent(vector, false);
    }

    public static FieldImpl getUComponent(FieldImpl vector, boolean copy) throws VisADException {
        return DerivedGridFactory.getComponent(vector, 0, copy);
    }

    public static FieldImpl getVComponent(FieldImpl vector) throws VisADException {
        return DerivedGridFactory.getVComponent(vector, false);
    }

    public static FieldImpl getVComponent(FieldImpl vector, boolean copy) throws VisADException {
        return DerivedGridFactory.getComponent(vector, 1, copy);
    }

    public static FieldImpl getComponent(FieldImpl vector, int index, boolean copy) throws VisADException {
        if (!DerivedGridFactory.isVector(vector)) {
            return vector;
        }
        return GridUtil.getParam(vector, index, copy);
    }

    public static FieldImpl createDailyClimatology(FieldImpl dailyData, boolean use366) throws VisADException {
        FieldImpl dailyClim = null;
        Set timeSet = GridUtil.getTimeSet(dailyData);
        int[] jdays = UtcDate.convertDateTimeToJulianDay((Gridded1DSet)timeSet);
        int day1 = jdays[0];
        int day2 = jdays[1];
        int daydiff = day2 - day1;
        if (day1 == day2 || daydiff < 1 || daydiff > 366) {
            throw new VisADException("createDailyClimatology: Input field must be daily data");
        }
        int numDays = use366 ? 366 : 365;
        Integer1DSet climTimes = new Integer1DSet(RealTupleType.Time1DTuple, numDays, null, new Unit[]{CLIMATE_UNITS}, null);
        try {
            for (int i = 0; i < numDays; ++i) {
                int[] indexes = Misc.find(i + 1, jdays);
                if (indexes.length == 0) continue;
                FlatField[] grids = new FlatField[indexes.length];
                for (int g = 0; g < indexes.length; ++g) {
                    grids[g] = (FlatField)dailyData.getSample(indexes[g], false);
                }
                FlatField avgGrid = GridMath.applyFunctionOverGrids(grids, "average");
                if (avgGrid == null) continue;
                if (dailyClim == null) {
                    FunctionType ftype = new FunctionType(RealTupleType.Time1DTuple, avgGrid.getType());
                    dailyClim = new FieldImpl(ftype, climTimes);
                }
                dailyClim.setSample(i, avgGrid, false, false);
            }
            if (use366) {
                FlatField firstDay = (FlatField)dailyClim.getSample(0, false);
                FlatField lastDay = (FlatField)dailyClim.getSample(364, false);
                dailyClim.setSample(365, GridMath.applyFunctionOverGrids(new FlatField[]{firstDay, lastDay}, "average"), false, false);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return dailyClim;
    }

    public static FieldImpl calculateDailyAnomaly(FieldImpl dailyData, FieldImpl dailyClim) throws VisADException {
        return DerivedGridFactory.calculateDailyAnomaly(dailyData, dailyClim, false);
    }

    public static FieldImpl calculateDailyAnomaly(FieldImpl dailyData, FieldImpl dailyClim, boolean asPercent) throws VisADException {
        Gridded1DSet dailyTimes = (Gridded1DSet)GridUtil.getTimeSet(dailyData);
        Gridded1DSet climTimes = (Gridded1DSet)GridUtil.getTimeSet(dailyClim);
        int[] jdays = UtcDate.convertDateTimeToJulianDay(dailyTimes);
        int[] climdays = UtcDate.convertDateTimeToJulianDay(climTimes);
        boolean leapClim = climdays.length == 366;
        int[] leaps = Misc.find(366, climdays);
        FieldImpl dailyAnom = null;
        try {
            for (int i = 0; i < jdays.length; ++i) {
                FlatField dayAnom;
                int climDay = jdays[i] - 1;
                boolean isLeapDay = false;
                if (leaps.length > 0) {
                    for (int l = 0; l < leaps.length; ++l) {
                        if (i != leaps[l] - 306) continue;
                        isLeapDay = true;
                    }
                }
                FlatField dayData = (FlatField)dailyData.getSample(i, false);
                FlatField climData = null;
                if (isLeapDay) {
                    FlatField climData2;
                    FlatField climData1;
                    if (!leapClim) {
                        if (climDay == 60) {
                            climData1 = (FlatField)dailyClim.getSample(59, false);
                            climData2 = (FlatField)dailyClim.getSample(59, false);
                            climData = (FlatField)GridMath.add(climData1, climData2).subtract(new Real(2.0));
                            climData = (FlatField)GridUtil.setParamType((FieldImpl)climData, GridUtil.getParamType(climData1), false);
                        } else {
                            climData = (FlatField)dailyClim.getSample(climDay - 1, false);
                        }
                    } else if (!leapClim && climDay == 365) {
                        climData1 = (FlatField)dailyClim.getSample(364, false);
                        climData2 = (FlatField)dailyClim.getSample(0, false);
                        climData = (FlatField)GridMath.add(climData1, climData2).subtract(new Real(2.0));
                        climData = (FlatField)GridUtil.setParamType((FieldImpl)climData, GridUtil.getParamType(climData1), false);
                    } else {
                        climData = (FlatField)dailyClim.getSample(climDay, false);
                    }
                } else {
                    climData = (FlatField)dailyClim.getSample(climDay, false);
                }
                if (asPercent) {
                    dayAnom = (FlatField)GridMath.divide(dayData, climData);
                    dayAnom = (FlatField)GridUtil.setParamType((FieldImpl)dayAnom, ANOM_PERCENT_TYPE, false);
                    dayAnom = (FlatField)dayAnom.subtract(new Real(ANOM_PERCENT_TYPE, 100.0));
                } else {
                    dayAnom = (FlatField)GridMath.subtract(dayData, climData);
                }
                if (dailyAnom == null) {
                    FunctionType ft = new FunctionType(((SetType)dailyTimes.getType()).getDomain(), dayAnom.getType());
                    dailyAnom = new FieldImpl(ft, dailyTimes);
                }
                dailyAnom.setSample(i, dayAnom, false, false);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return dailyAnom;
    }

    public static FieldImpl createSurfaceWindAngle(FieldImpl gridu, FieldImpl gridv, FieldImpl gridw, double value1, String lUnit) throws VisADException, RemoteException {
        RealType levelType = RealType.Generic;
        Unit levelUnit = Util.parseUnit(lUnit);
        if (levelUnit != null) {
            if (Unit.canConvert(levelUnit, CommonUnits.HECTOPASCAL)) {
                levelType = AirPressure.getRealType();
            } else if (Unit.canConvert(levelUnit, CommonUnit.meter)) {
                levelType = RealType.Altitude;
            } else {
                levelUnit = null;
            }
        }
        FieldImpl gridwz = DerivedGridFactory.convertPressureVelocityToHeightVelocity(gridw);
        Real level1 = levelUnit != null ? new Real(levelType, value1, levelUnit) : new Real(levelType, value1);
        FieldImpl first = GridUtil.make2DGridFromSlice(GridUtil.sliceAtLevel(gridu, level1), false);
        FieldImpl second = GridUtil.make2DGridFromSlice(GridUtil.sliceAtLevel(gridv, level1), false);
        FieldImpl horizontalSpeed = DerivedGridFactory.createWindSpeed(first, second);
        FieldImpl verticalSpeed = GridUtil.make2DGridFromSlice(GridUtil.sliceAtLevel(gridwz, level1), false);
        FieldImpl result = DerivedGridFactory.createVectorDirection(verticalSpeed, horizontalSpeed);
        return GridUtil.addLevelToGrid(result, value1, lUnit);
    }

    public static FieldImpl timeStepAccumulatedPrecip(FieldImpl grid) throws VisADException {
        try {
            if (!GridUtil.isTimeSequence(grid)) {
                return grid;
            }
            FieldImpl newGrid = (FieldImpl)grid.clone();
            Set timeDomain = Util.getDomainSet(newGrid);
            Set timeSet = GridUtil.getTimeSet(grid);
            CalendarDateTime[] timeArray = CalendarDateTime.timeSetToArray(timeSet);
            double accumulateHours = DateUtil.getDateTimeRangeInHours(timeArray[0], timeArray[1]);
            double accumuhoursP = 0.0;
            for (int timeStepIdx = 0; timeStepIdx < timeDomain.getLength(); ++timeStepIdx) {
                FlatField sample = (FlatField)newGrid.getSample(timeStepIdx);
                CalendarDateTime rtime = null;
                double[] bounds = null;
                if (sample instanceof GeoGridFlatField) {
                    rtime = ((GeoGridFlatField)sample).getRuntime();
                    bounds = ((GeoGridFlatField)sample).getCoordBounds();
                } else if (sample instanceof GridCoverageFlatField) {
                    rtime = ((GridCoverageFlatField)sample).getRuntime();
                    bounds = ((GridCoverageFlatField)sample).getCoordBounds();
                }
                CalendarDateTime ftime = timeArray[timeStepIdx];
                double accumhours = bounds[1] - bounds[0];
                float[][] value = sample.getFloats(true);
                if (timeStepIdx > 0) {
                    FlatField preSample = (FlatField)grid.getSample(timeStepIdx - 1);
                    CalendarDateTime preRuntime = null;
                    double[] prebounds = null;
                    if (preSample instanceof GeoGridFlatField) {
                        preRuntime = ((GeoGridFlatField)sample).getRuntime();
                        prebounds = ((GeoGridFlatField)sample).getCoordBounds();
                    } else if (preSample instanceof GridCoverageFlatField) {
                        preRuntime = ((GridCoverageFlatField)sample).getRuntime();
                        prebounds = ((GridCoverageFlatField)sample).getCoordBounds();
                    }
                    float[][] preValue = preSample.getFloats(true);
                    double preAccumhours = prebounds[1] - prebounds[0];
                    if (accumhours == accumulateHours) {
                        sample.setSamples(value, false);
                    } else if (rtime.equals(preRuntime)) {
                        value = Misc.subtractArray(value, preValue, value);
                        sample.setSamples(value, false);
                    } else if (accumhours > preAccumhours) {
                        value = Misc.subtractArray(value, preValue, value);
                        sample.setSamples(value, false);
                    } else if (accumhours < preAccumhours) {
                        preSample = (FlatField)newGrid.getSample(timeStepIdx - 1);
                        float[][] valueP = preSample.getFloats();
                        value = Misc.subtractArray(value, valueP, value);
                        sample.setSamples(value, false);
                    }
                } else {
                    double factor = accumulateHours / accumhours;
                    for (int j = 0; j < value.length; ++j) {
                        for (int i = 0; i < value[j].length; ++i) {
                            value[j][i] = value[j][i] * (float)factor;
                        }
                    }
                    sample.setSamples(value, false);
                }
                newGrid.setSample(timeStepIdx, (Data)sample, false);
            }
            return newGrid;
        }
        catch (CloneNotSupportedException cnse) {
            throw new VisADException("Cannot clone field");
        }
        catch (RemoteException re) {
            throw new VisADException("RemoteException in timeStepFunc");
        }
    }

    static {
        try {
            EARTH_RADIUS = new Real(Length.getRealType(), 6371000.0, SI.meter);
            EARTH_TWO_OMEGA = new Real(DataUtil.makeRealType("frequency", SI.second.pow(-1)), 1.4584E-4, SI.second.pow(-1));
            GRAVITY = Gravity.newReal();
            CLIMATE_UNITS = Util.parseUnit("days since 0001-01-01 00:00:00");
            ANOM_PERCENT_TYPE = RealType.getRealType("percent_of_normal", CommonUnits.PERCENT);
        }
        catch (Exception ex) {
            throw new ExceptionInInitializerError(ex.toString());
        }
    }
}

