/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.data.gis;

import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import ucar.unidata.data.GeoLocationInfo;
import ucar.unidata.util.HtmlUtil;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.xml.XmlResourceCollection;
import ucar.unidata.xml.XmlUtil;

public class WmsSelection {
    static LogUtil.LogCategory log_ = LogUtil.getLogInstance(WmsSelection.class.getName());
    public static final String TAG_BACKGROUNDWMS = "backgroundwms";
    public static final String TAG_WMS = "wms";
    public static final String TAG_IMAGE = "image";
    public static final String ATTR_SERVER = "server";
    public static final String ATTR_LEGENDURL = "legendurl";
    public static final String ATTR_LAYER = "layer";
    public static final String ATTR_TITLE = "title";
    public static final String ATTR_SRS = "srs";
    public static final String ATTR_CRS = "crs";
    public static final String ATTR_FORMAT = "format";
    public static final String ATTR_VERSION = "version";
    public static final String ATTR_BBOX = "bbox";
    public static final String ATTR_OPAQUE = "opaque";
    private String legendIcon;
    private List timeList;
    private boolean allowSubsets = true;
    private int fixedHeight = -1;
    private int fixedWidth = -1;
    private int opaque = 0;
    private String description;
    private String title;
    private String server;
    private String layer;
    private String srs;
    private GeoLocationInfo bounds;
    private String format;
    private String version;
    private String imageFile;

    public WmsSelection() {
    }

    public WmsSelection(String layer, String title, String imageFile) {
        this.imageFile = imageFile;
        this.layer = layer;
        this.title = title;
        this.bounds = new GeoLocationInfo(90.0, -180.0, -90.0, 180.0);
    }

    public WmsSelection(String server, String layer, String title, String srs, String format, String version, GeoLocationInfo bounds) {
        this.server = server;
        this.layer = layer;
        this.title = title;
        this.srs = srs;
        this.bounds = bounds;
        this.format = format;
        this.version = version;
    }

    public void appendLayer(String layerName, GeoLocationInfo thatBounds) {
        this.layer = this.layer + "," + layerName;
        this.bounds = this.bounds.union(thatBounds);
    }

    public boolean isFixedImage() {
        return this.imageFile != null;
    }

    public String assembleRequest(GeoLocationInfo boundsToUse, int imageWidth, int imageHeight) {
        String url = this.server;
        url = url.indexOf("?") < 0 ? url + "?" : url + "&";
        String bbox = boundsToUse.getMinLon() + "," + boundsToUse.getMinLat() + "," + boundsToUse.getMaxLon() + "," + boundsToUse.getMaxLat();
        url = url + "version=" + this.version + "&request=GetMap" + "&service=WMS" + "&Styles=" + "" + "&format=" + HtmlUtil.urlEncode(this.format) + "&SRS=" + this.srs + "&CRS=" + this.srs + "&Layers=" + this.layer + "&BBOX=" + bbox + "&width=" + imageWidth + "&height=" + imageHeight + "&reaspect=false";
        url = this.opaque == 0 ? url + "&transparent=TRUE" : url + "&transparent=FALSE";
        log_.debug("WMS URL: " + url);
        return url;
    }

    public void setServer(String value) {
        this.server = value;
    }

    public String getServer() {
        return this.server;
    }

    public void setSRS(String value) {
        this.srs = value;
    }

    public String getSRS() {
        return this.srs;
    }

    public void setLayer(String value) {
        this.layer = value;
    }

    public String getLayer() {
        return this.layer;
    }

    public void setBounds(GeoLocationInfo value) {
        this.bounds = value;
    }

    public GeoLocationInfo getBounds() {
        return this.bounds;
    }

    public void setFormat(String value) {
        this.format = value;
    }

    public String getFormat() {
        return this.format;
    }

    public void setTitle(String value) {
        this.title = value;
    }

    public String getTitle() {
        return this.title;
    }

    public void setVersion(String value) {
        this.version = value;
    }

    public String getVersion() {
        return this.version;
    }

    public String toString() {
        return this.title;
    }

    public static List parseWmsResources(XmlResourceCollection xrc) {
        ArrayList<WmsSelection> infos = new ArrayList<WmsSelection>();
        for (int i = 0; i < xrc.size(); ++i) {
            Element root = xrc.getRoot(i);
            if (root == null) continue;
            NodeList children = XmlUtil.getElements(root);
            for (int childIdx = 0; childIdx < children.getLength(); ++childIdx) {
                Element wmsNode = (Element)children.item(childIdx);
                String layer = XmlUtil.getAttribute(wmsNode, ATTR_LAYER);
                if (wmsNode.getTagName().equals(TAG_IMAGE)) {
                    infos.add(new WmsSelection(layer, XmlUtil.getAttribute((Node)wmsNode, ATTR_TITLE, layer), XmlUtil.getAttribute(wmsNode, "file")));
                    continue;
                }
                double[] bbox = Misc.parseDoubles(XmlUtil.getAttribute(wmsNode, ATTR_BBOX));
                GeoLocationInfo bounds = new GeoLocationInfo(bbox[0], bbox[1], bbox[2], bbox[3]);
                WmsSelection wmsSelection = new WmsSelection(XmlUtil.getAttribute(wmsNode, ATTR_SERVER), layer, XmlUtil.getAttribute((Node)wmsNode, ATTR_TITLE, layer), XmlUtil.getAttribute(wmsNode, ATTR_SRS), XmlUtil.getAttribute((Node)wmsNode, ATTR_FORMAT, "image/jpeg"), XmlUtil.getAttribute((Node)wmsNode, ATTR_VERSION, "1.1.1"), bounds);
                infos.add(wmsSelection);
                if (!XmlUtil.hasAttribute(wmsNode, ATTR_LEGENDURL)) continue;
                wmsSelection.setLegendIcon(XmlUtil.getAttribute(wmsNode, ATTR_LEGENDURL));
            }
        }
        return infos;
    }

    public void setFixedWidth(int value) {
        this.fixedWidth = value;
    }

    public int getFixedWidth() {
        return this.fixedWidth;
    }

    public void setOpaque(int value) {
        this.opaque = value;
    }

    public int getOpaque() {
        return this.opaque;
    }

    public void setFixedHeight(int value) {
        this.fixedHeight = value;
    }

    public int getFixedHeight() {
        return this.fixedHeight;
    }

    public void setAllowSubsets(boolean value) {
        this.allowSubsets = value;
    }

    public boolean getAllowSubsets() {
        if (this.isFixedImage()) {
            return false;
        }
        return this.allowSubsets;
    }

    public void setDescription(String value) {
        this.description = value;
    }

    public String getDescription() {
        return this.description;
    }

    public void setLegendIcon(String value) {
        this.legendIcon = value;
    }

    public String getLegendIcon() {
        return this.legendIcon;
    }

    public void setTimeList(List value) {
        this.timeList = value;
    }

    public List getTimeList() {
        return this.timeList;
    }

    public int hashCode() {
        return new Object[]{this.server, this.layer, this.title, this.srs, this.bounds, this.format, this.version}.hashCode();
    }

    public void setImageFile(String value) {
        this.imageFile = value;
    }

    public String getImageFile() {
        return this.imageFile;
    }

    public boolean equals(Object o) {
        if (!(o instanceof WmsSelection)) {
            return false;
        }
        WmsSelection that = (WmsSelection)o;
        return Misc.equals(this.server, that.server) && Misc.equals(this.layer, that.layer) && Misc.equals(this.title, that.title) && Misc.equals(this.srs, that.srs) && Misc.equals(this.bounds, that.bounds) && Misc.equals(this.format, that.format) && Misc.equals(this.version, that.version);
    }
}

