/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.data.gis;

import java.awt.Image;
import java.awt.Toolkit;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.swing.JCheckBox;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ucar.unidata.data.DataCategory;
import ucar.unidata.data.DataChoice;
import ucar.unidata.data.DataSelection;
import ucar.unidata.data.DataSource;
import ucar.unidata.data.DataSourceDescriptor;
import ucar.unidata.data.DataSourceImpl;
import ucar.unidata.data.DirectDataChoice;
import ucar.unidata.data.GeoLocationInfo;
import ucar.unidata.data.gis.WmsSelection;
import ucar.unidata.data.grid.GridUtil;
import ucar.unidata.data.imagery.ImageXmlDataSource;
import ucar.unidata.ui.ImageUtils;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.IOUtil;
import ucar.unidata.util.JobManager;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.StringUtil;
import ucar.unidata.util.Trace;
import ucar.unidata.util.TwoFacedObject;
import ucar.unidata.xml.XmlUtil;
import ucar.visad.Util;
import visad.Data;
import visad.FieldImpl;
import visad.FlatField;
import visad.Linear2DSet;
import visad.MathType;
import visad.RealTupleType;
import visad.VisADException;
import visad.util.ImageHelper;

public class WmsDataSource
extends DataSourceImpl {
    public static final String PROP_BOUNDS = "prop.wms.bounds";
    public static final String PROP_ICONPATH = "prop.wms.iconpath";
    public static final String PROP_WRITEFILE = "prop.wms.writefile";
    public static final String PROP_RESOLUTION = "prop.wms.resolution";
    public static final String PROP_IMAGEWIDTH = "prop.wms.imagewidth";
    public static final String PROP_IMAGEHEIGHT = "prop.wms.imageheight";
    public static final String PROP_LAYER = "prop.wms.layer";
    public static final String PROP_LAYERS = "prop.wms.layers";
    private List categories = DataCategory.parseCategories("GIS-WMS", false);
    private Object loadId;
    private List wmsSelections;
    private boolean maintainRatio = false;
    private JCheckBox maintainRatioCbx;
    byte[] lastImageContent;
    String lastUrl;
    private List layerList = new ArrayList();
    List cachedData = new ArrayList();
    List cachedUrls = new ArrayList();

    public WmsDataSource() {
    }

    public WmsDataSource(DataSourceDescriptor descriptor, List selections, Hashtable properties) throws VisADException {
        super(descriptor, "WMS data source", "WMS data source", properties);
        this.wmsSelections = new ArrayList(selections);
        this.initWmsDataSource();
    }

    public List getLayerList() {
        return this.layerList;
    }

    @Override
    public void initAfterUnpersistence() {
        super.initAfterUnpersistence();
        if (this.wmsSelections != null) {
            List backgroundImages = this.getDataContext().getIdv().getBackgroundImages();
            for (Object o : this.wmsSelections) {
                if (!backgroundImages.contains(o)) continue;
                this.wmsSelections = backgroundImages;
                break;
            }
        }
        this.initWmsDataSource();
    }

    private void initWmsDataSource() {
    }

    @Override
    protected void doMakeDataChoices() {
        int i;
        this.layerList = new ArrayList();
        for (i = 0; i < this.wmsSelections.size(); ++i) {
            WmsSelection selection = (WmsSelection)this.wmsSelections.get(i);
            this.layerList.add(new TwoFacedObject((Object)selection.getTitle(), selection.getTitle() + "-layer=" + selection.getLayer()));
        }
        for (i = 0; i < this.wmsSelections.size(); ++i) {
            Hashtable<String, Object> properties = new Hashtable<String, Object>();
            properties.put(PROP_LAYERS, this.layerList);
            properties.put(PROP_LAYER, this.layerList.get(i));
            properties.put("prop.icon", "/auxdata/ui/icons/Earth16.gif");
            WmsSelection selection = (WmsSelection)this.wmsSelections.get(i);
            this.addDataChoice(new DirectDataChoice((DataSource)this, (Object)selection, selection.toString(), selection.toString(), this.categories, properties));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Data getDataInner(DataChoice dataChoice, DataCategory category, DataSelection dataSelection, Hashtable requestProperties) throws VisADException, RemoteException {
        Object myLoadId = this.loadId = JobManager.getManager().stopAndRestart(this.loadId, "WMSControl");
        if (requestProperties == null) {
            requestProperties = new Hashtable<String, String>();
        }
        WmsSelection wmsInfo = (WmsSelection)dataChoice.getId();
        Object tfoLayer = requestProperties.get(PROP_LAYER);
        Object tfoTitle = requestProperties.get("TITLE");
        if (tfoLayer != null) {
            String layer = tfoLayer.toString();
            String title = tfoTitle.toString();
            for (int i = 0; i < this.wmsSelections.size(); ++i) {
                WmsSelection tmpSelection = (WmsSelection)this.wmsSelections.get(i);
                if (!Misc.equals(tmpSelection.getTitle(), title) || !Misc.equals(tmpSelection.getLayer(), layer)) continue;
                wmsInfo = tmpSelection;
                break;
            }
        }
        GeoLocationInfo boundsToUse = (GeoLocationInfo)requestProperties.get(PROP_BOUNDS);
        Image image = null;
        FlatField xyData = null;
        byte[] imageContent = null;
        if (wmsInfo.getImageFile() != null) {
            try {
                boundsToUse = new GeoLocationInfo(90.0, -180.0, -90.0, 180.0);
                InputStream is = IOUtil.getInputStream(wmsInfo.getImageFile());
                imageContent = IOUtil.readBytes(is, myLoadId);
                image = Toolkit.getDefaultToolkit().createImage(imageContent);
                xyData = Util.makeField(image, 0.0f, false, true);
            }
            catch (Exception iexc) {
                this.logException("There was an error accessing the image:\n" + wmsInfo.getImageFile(), iexc);
                return null;
            }
        }
        String writeFile = (String)requestProperties.get(PROP_WRITEFILE);
        int imageWidth = Misc.getProperty(requestProperties, PROP_IMAGEWIDTH, 800);
        int imageHeight = Misc.getProperty(requestProperties, PROP_IMAGEHEIGHT, -1);
        double resolution = Misc.getProperty(requestProperties, PROP_RESOLUTION, 1.0f);
        if (wmsInfo.getLegendIcon() != null) {
            requestProperties.put(PROP_ICONPATH, wmsInfo.getLegendIcon());
        }
        if (!wmsInfo.getAllowSubsets() || boundsToUse == null) {
            boundsToUse = wmsInfo.getBounds();
        } else {
            boundsToUse.rectify(wmsInfo.getBounds(), 0.0);
            boundsToUse.snapToGrid();
            boundsToUse.rectify(wmsInfo.getBounds(), 0.0);
        }
        double widthDegrees = boundsToUse.getMaxLon() - boundsToUse.getMinLon();
        double heightDegrees = boundsToUse.getMaxLat() - boundsToUse.getMinLat();
        if (widthDegrees == 0.0 || heightDegrees == 0.0) {
            return null;
        }
        if (wmsInfo.getFixedWidth() > -1) {
            imageWidth = wmsInfo.getFixedWidth();
        }
        if (wmsInfo.getFixedHeight() > -1) {
            imageHeight = wmsInfo.getFixedHeight();
        } else if (imageHeight < 0) {
            imageHeight = Math.abs((int)((double)imageWidth * boundsToUse.getDegreesY() / boundsToUse.getDegreesX()));
        }
        imageWidth = Math.min(Math.max(imageWidth, 50), 2056);
        imageHeight = Math.min(Math.max(imageHeight, 50), 2056);
        if (this.maintainRatio) {
            imageHeight = (int)((double)imageWidth * (heightDegrees / widthDegrees));
        }
        double diff = Math.abs(boundsToUse.getMinLon() - boundsToUse.getMaxLon());
        String url = wmsInfo.assembleRequest(boundsToUse, (int)((double)imageWidth / resolution), (int)((double)imageHeight / resolution));
        String cacheGroup = "WMS";
        List list = this.cachedUrls;
        synchronized (list) {
            if (writeFile == null) {
                for (int i = 0; i < this.cachedUrls.size(); ++i) {
                    if (!url.equals(this.cachedUrls.get(i))) continue;
                    image = (Image)this.cachedData.get(i);
                    break;
                }
            }
        }
        try {
            if (image == null) {
                if (Misc.equals(url, this.lastUrl) && this.lastImageContent != null) {
                    imageContent = this.lastImageContent;
                }
                if (imageContent == null) {
                    long t1 = System.currentTimeMillis();
                    LogUtil.message("Reading WMS image: " + wmsInfo);
                    InputStream is = IOUtil.getInputStream(url);
                    long t2 = System.currentTimeMillis();
                    imageContent = IOUtil.readBytes(is, myLoadId);
                    long t3 = System.currentTimeMillis();
                    LogUtil.message("");
                }
                this.lastImageContent = null;
                if (imageContent == null) {
                    return null;
                }
                Trace.call2("Getting image");
                Trace.call1("Making image");
                image = Toolkit.getDefaultToolkit().createImage(imageContent);
                image = ImageUtils.waitOnImage(image);
                if (image == null) {
                    throw new IllegalStateException();
                }
                Trace.call2("Making image");
                this.lastImageContent = imageContent;
                this.lastUrl = url;
                this.updateDetailsText();
                if (!JobManager.getManager().canContinue(myLoadId)) {
                    Trace.call2("WMSControl.loadImage");
                    return null;
                }
                List t1 = this.cachedUrls;
                synchronized (t1) {
                    if (this.cachedUrls.size() > 5) {
                        this.cachedUrls.remove(this.cachedUrls.size() - 1);
                        this.cachedData.remove(this.cachedData.size() - 1);
                    }
                }
            }
            ImageHelper ih = new ImageHelper();
            int width = image.getWidth(ih);
            if (ih.badImage) {
                throw new IllegalStateException();
            }
            long tt1 = System.currentTimeMillis();
            xyData = Util.makeField(image, 0.0f, false, true);
            long l = System.currentTimeMillis();
        }
        catch (Exception iexc) {
            if (imageContent != null) {
                String msg = new String(imageContent);
                if (msg.indexOf("<ServiceExceptionReport") >= 0) {
                    try {
                        StringBuffer errors = new StringBuffer();
                        errors.append("\n");
                        Element root = XmlUtil.getRoot(msg);
                        List children = XmlUtil.findChildren(root, "ServiceException");
                        for (int i = 0; i < children.size(); ++i) {
                            Element node = (Element)children.get(i);
                            String code = XmlUtil.getAttribute((Node)node, "code", (String)null);
                            String body = XmlUtil.getChildText(node);
                            if (code != null) {
                                errors.append(code + "\n");
                            }
                            errors.append(body.trim() + "\n");
                        }
                        LogUtil.userErrorMessage("Error accessing image with the url:\n" + url + "\nError:\n" + errors);
                    }
                    catch (Exception exc) {
                        LogUtil.userErrorMessage("Error accessing image with the url:\n" + url + "\nError:\n" + StringUtil.stripTags(msg));
                    }
                    return null;
                }
                if (StringUtil.stringMatch(msg = StringUtil.replace(msg, "\n", " ").toLowerCase(), "service\\s*exception") && StringUtil.stringMatch(msg, "cannot\\s*be\\s*less\\s*than")) {
                    return null;
                }
                if (msg.indexOf("error") >= 0) {
                    LogUtil.userErrorMessage("There was an error accessing the image with the url:\n" + url + "\nError:\n" + new String(imageContent));
                    return null;
                }
            }
            this.logException("There was an error accessing the image with the url:\n" + url, iexc);
            return null;
        }
        if (writeFile != null) {
            try {
                ImageXmlDataSource.writeToFile(writeFile, boundsToUse, imageContent, wmsInfo.getFormat());
            }
            catch (Exception exc) {
                throw new IllegalArgumentException("Error writing image xml file:" + writeFile + " " + exc);
            }
        }
        Linear2DSet domain = (Linear2DSet)xyData.getDomainSet();
        Linear2DSet imageDomain = new Linear2DSet((MathType)RealTupleType.SpatialEarth2DTuple, boundsToUse.getMinLon(), boundsToUse.getMaxLon(), domain.getX().getLength(), boundsToUse.getMaxLat(), boundsToUse.getMinLat(), domain.getY().getLength());
        FieldImpl field = GridUtil.setSpatialDomain(xyData, imageDomain, true);
        return field;
    }

    @Override
    public void getPropertiesComponents(List comps) {
        super.getPropertiesComponents(comps);
        this.maintainRatioCbx = new JCheckBox("Match Ration", this.maintainRatio);
        comps.add(GuiUtils.filler());
        comps.add(GuiUtils.left(this.maintainRatioCbx));
    }

    @Override
    public boolean applyProperties() {
        if (!super.applyProperties()) {
            return false;
        }
        this.maintainRatio = this.maintainRatioCbx.isSelected();
        return true;
    }

    @Override
    public String getFullDescription() {
        StringBuffer sb = new StringBuffer(super.getFullDescription());
        if (this.lastUrl != null) {
            sb.append("<p><b>Last request:</b> " + this.lastUrl);
        }
        sb.append("Images<p><table><tr><td><b>Name</b></td><td><b>Layer</b></td><td><b>Server</b></td></tr>\n");
        for (int i = 0; i < this.wmsSelections.size(); ++i) {
            WmsSelection selection = (WmsSelection)this.wmsSelections.get(i);
            sb.append("<tr><td>");
            sb.append(selection.getTitle());
            sb.append("</td><td>");
            sb.append(selection.getLayer());
            sb.append("</td><td>");
            sb.append(selection.getServer());
            sb.append("</td></tr>");
        }
        sb.append("</table>");
        return sb.toString();
    }

    @Override
    protected boolean shouldCache(Data data) {
        return false;
    }

    @Override
    protected List doMakeDateTimes() {
        return new ArrayList();
    }

    public void setWmsSelections(List value) {
        this.wmsSelections = value;
    }

    public List getWmsSelections() {
        return this.wmsSelections;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        WmsDataSource that = (WmsDataSource)o;
        return Misc.equals(this.wmsSelections, that.wmsSelections);
    }

    public void setMaintainRatio(boolean value) {
        this.maintainRatio = value;
    }

    public boolean getMaintainRatio() {
        return this.maintainRatio;
    }
}

