/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.data.gis;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.util.Misc;
import ucar.unidata.util.StringUtil;
import ucar.unidata.xml.XmlUtil;

public class Transect {
    private boolean editable = true;
    private static final String TAG_TRANSECTS = "transects";
    private static final String TAG_TRANSECT = "transect";
    private static final String ATTR_COLOR = "color";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_POINTS = "points";
    private static final String ATTR_STARTTEXT = "starttext";
    private static final String ATTR_ENDTEXT = "endtext";
    private static final String ATTR_WAYPOINTTEXT = "waypointtext";
    private String name = "";
    private String startText = "";
    private String endText = "";
    private String waypointText = "";
    private Color color;
    private List points = new ArrayList();

    public Transect() {
    }

    public Transect(Transect that) {
        this.name = that.name;
        this.points = new ArrayList(that.points);
    }

    public Transect(String name, List points) {
        this.name = name;
        this.points = points;
    }

    public Transect(String name, LatLonPoint p1, LatLonPoint p2) {
        this.name = name;
        this.points = Misc.newList(p1, p2);
    }

    public static List parseXml(Element root) {
        ArrayList<Transect> transects = new ArrayList<Transect>();
        List nodes = XmlUtil.findChildren(root, TAG_TRANSECT);
        for (int i = 0; i < nodes.size(); ++i) {
            Element node = (Element)nodes.get(i);
            double[] latLons = Misc.parseLatLons(XmlUtil.getAttribute(node, ATTR_POINTS));
            ArrayList<LatLonPointImpl> points = new ArrayList<LatLonPointImpl>();
            for (int ptIdx = 0; ptIdx < latLons.length; ptIdx += 2) {
                points.add(new LatLonPointImpl(latLons[ptIdx], latLons[ptIdx + 1]));
            }
            Transect transect = new Transect(XmlUtil.getAttribute((Node)node, ATTR_NAME, ""), points);
            transect.setColor(XmlUtil.getAttribute((Node)node, ATTR_COLOR, (Color)null));
            transect.setStartText(XmlUtil.getAttribute((Node)node, ATTR_STARTTEXT, ""));
            transect.setEndText(XmlUtil.getAttribute((Node)node, ATTR_ENDTEXT, ""));
            if (points.size() > 2) {
                transect.setWaypointText(XmlUtil.getAttribute((Node)node, ATTR_WAYPOINTTEXT, ""));
            }
            transects.add(transect);
        }
        return transects;
    }

    public static String toXml(List transects) {
        Document doc = XmlUtil.makeDocument();
        Element root = doc.createElement(TAG_TRANSECTS);
        List nodes = XmlUtil.findChildren(root, TAG_TRANSECT);
        for (int i = 0; i < transects.size(); ++i) {
            Transect transect = (Transect)transects.get(i);
            Element node = doc.createElement(TAG_TRANSECT);
            root.appendChild(node);
            String name = transect.getName();
            if (transect.getStartText() != null && transect.getStartText().length() > 0) {
                node.setAttribute(ATTR_STARTTEXT, transect.getStartText());
            }
            if (transect.getEndText() != null && transect.getEndText().length() > 0) {
                node.setAttribute(ATTR_ENDTEXT, transect.getEndText());
            }
            if (transect.getWaypointText() != null && transect.getWaypointText().length() > 0) {
                node.setAttribute(ATTR_WAYPOINTTEXT, transect.getWaypointText());
            }
            if (transect.getColor() != null) {
                XmlUtil.setAttribute(node, ATTR_COLOR, transect.getColor());
            }
            node.setAttribute(ATTR_NAME, name == null ? "" : name);
            ArrayList<String> points = new ArrayList<String>();
            for (int ptIdx = 0; ptIdx < transect.points.size(); ++ptIdx) {
                Object obj = transect.points.get(ptIdx);
                LatLonPoint llp = (LatLonPoint)transect.points.get(ptIdx);
                points.add("" + llp.getLatitude());
                points.add("" + llp.getLongitude());
            }
            node.setAttribute(ATTR_POINTS, StringUtil.join(",", points));
        }
        return XmlUtil.toString(root);
    }

    public void shiftPercent(double latPercent, double lonPercent, boolean doPoint1, boolean doPoint2) {
        ArrayList<LatLonPoint> newPoints = new ArrayList<LatLonPoint>();
        LatLonPoint llp1 = (LatLonPoint)this.points.get(0);
        LatLonPoint llp2 = (LatLonPoint)this.points.get(1);
        double latDelta = latPercent * Math.abs(llp1.getLatitude() - llp2.getLatitude());
        double lonDelta = lonPercent * Math.abs(llp1.getLongitude() - llp2.getLongitude());
        newPoints.add(doPoint1 ? new LatLonPointImpl(llp1.getLatitude() + latDelta, llp1.getLongitude() + lonDelta) : llp1);
        newPoints.add(doPoint2 ? new LatLonPointImpl(llp2.getLatitude() + latDelta, llp2.getLongitude() + lonDelta) : llp2);
        this.points = newPoints;
    }

    public void setName(String value) {
        this.name = value;
    }

    public String getName() {
        return this.name;
    }

    public void setPoints(List value) {
        this.points = value;
    }

    public List getPoints() {
        return this.points;
    }

    public String toString() {
        String result = this.name;
        if (this.points.size() >= 1) {
            result = result + ": " + this.points.get(0);
        }
        if (this.points.size() >= 2) {
            result = result + " - " + this.points.get(1);
        }
        return result;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Transect)) {
            return false;
        }
        Transect that = (Transect)o;
        return Misc.equals(this.name, that.name) && Misc.equals(this.points, that.points);
    }

    public void setEditable(boolean value) {
        this.editable = value;
    }

    public boolean getEditable() {
        return this.editable;
    }

    public void setStartText(String value) {
        this.startText = value;
    }

    public String getStartText() {
        return this.startText;
    }

    public void setEndText(String value) {
        this.endText = value;
    }

    public String getEndText() {
        return this.endText;
    }

    public void setWaypointText(String value) {
        this.waypointText = value;
    }

    public String getWaypointText() {
        return this.waypointText;
    }

    public void setColor(Color value) {
        this.color = value;
    }

    public Color getColor() {
        return this.color;
    }
}

