/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.data.gis;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JFrame;
import ucar.unidata.data.gis.GeotiffAdapter;
import visad.DataReferenceImpl;
import visad.Display;
import visad.FlatField;
import visad.FunctionType;
import visad.RealTupleType;
import visad.RealType;
import visad.ScalarMap;
import visad.data.netcdf.Plain;
import visad.java3d.DisplayImplJ3D;

public class Test {
    public Test(String source) {
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            System.out.println("Must supply a filename");
            System.exit(1);
        }
        GeotiffAdapter adapter = new GeotiffAdapter(args[0]);
        final FlatField data = adapter.getData();
        RealTupleType rangeType = ((FunctionType)data.getType()).getFlatRange();
        DisplayImplJ3D display = new DisplayImplJ3D("display");
        boolean flat = true;
        if (flat) {
            display.addMap(new ScalarMap(RealType.Latitude, Display.YAxis));
            display.addMap(new ScalarMap(RealType.Longitude, Display.XAxis));
        } else {
            display.addMap(new ScalarMap(RealType.Latitude, Display.Latitude));
            display.addMap(new ScalarMap(RealType.Longitude, Display.Longitude));
        }
        display.addMap(new ScalarMap((RealType)rangeType.getComponent(0), Display.Red));
        display.addMap(new ScalarMap((RealType)rangeType.getComponent(1), Display.Green));
        display.addMap(new ScalarMap((RealType)rangeType.getComponent(2), Display.Blue));
        DataReferenceImpl ref = new DataReferenceImpl("ref");
        ref.setData(data);
        display.addReference(ref);
        JFrame frame = new JFrame("adapter test");
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        frame.getContentPane().add(display.getComponent());
        JButton save = new JButton("Save");
        save.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    new Plain().save("world.nc", data, true);
                }
                catch (Exception exp) {
                    System.out.println("couldn't save image");
                }
            }
        });
        frame.getContentPane().add("South", save);
        frame.pack();
        frame.setVisible(true);
    }
}

