/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.data.gis;

import java.awt.Component;
import java.awt.geom.Rectangle2D;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import ucar.unidata.data.CompositeDataChoice;
import ucar.unidata.data.DataCategory;
import ucar.unidata.data.DataChoice;
import ucar.unidata.data.DataSelection;
import ucar.unidata.data.DataSource;
import ucar.unidata.data.DataSourceDescriptor;
import ucar.unidata.data.DirectDataChoice;
import ucar.unidata.data.FilesDataSource;
import ucar.unidata.data.GeoLocationInfo;
import ucar.unidata.data.GeoSelection;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.gis.shapefile.DbaseData;
import ucar.unidata.gis.shapefile.DbaseFile;
import ucar.unidata.util.CacheManager;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.IOUtil;
import ucar.unidata.util.JobManager;
import ucar.unidata.util.Misc;
import ucar.unidata.util.TwoFacedObject;
import ucar.visad.MapFamily;
import ucar.visad.ShapefileAdapter;
import ucar.visad.data.MapSet;
import visad.Data;
import visad.SampledSet;
import visad.UnionSet;
import visad.VisADException;

public class ShapeFileDataSource
extends FilesDataSource {
    private static MapFamily mapFamily = new MapFamily("IDV maps");
    public static final String PROP_DBFILE = "PROP_DBFILE";
    private DbaseFile dbFile;
    private Data shapefileData;
    double coarseness = 0.0;
    double lastCoarseness = 0.0;
    private JComboBox coarsenessCbx;
    private List categories = DataCategory.parseCategories("GIS-SHAPEFILE", false);

    public ShapeFileDataSource() {
    }

    public ShapeFileDataSource(DataSourceDescriptor descriptor, String source, Hashtable properties) throws VisADException {
        super(descriptor, source, "Shapefile data source", properties);
        this.initShapeFileDataSource();
    }

    @Override
    public void reloadData() {
        this.shapefileData = null;
        this.dbFile = null;
        super.reloadData();
    }

    @Override
    public boolean canDoGeoSelection() {
        return true;
    }

    @Override
    protected boolean canDoGeoSelectionStride() {
        return false;
    }

    @Override
    protected JComponent doMakeGeoSubsetPropertiesComponent() {
        JComponent comp = super.doMakeGeoSubsetPropertiesComponent();
        if (this.coarsenessCbx == null) {
            TwoFacedObject selected = null;
            Vector<TwoFacedObject> items = new Vector<TwoFacedObject>();
            double[] values = new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0};
            String[] names = new String[]{"Full resolution", "........", ".......", "......", ".....", "....", "...", "..", ".", "Really coarse"};
            for (int i = 0; i < values.length; ++i) {
                TwoFacedObject tfo = new TwoFacedObject((Object)names[i], new Double(values[i]));
                if (values[i] == this.coarseness) {
                    selected = tfo;
                }
                items.add(tfo);
            }
            this.coarsenessCbx = new JComboBox(items);
            if (selected != null) {
                this.coarsenessCbx.setSelectedItem(selected);
            }
        }
        return GuiUtils.topCenter(GuiUtils.inset((Component)GuiUtils.left(GuiUtils.label("Resolution: ", this.coarsenessCbx)), 5), comp);
    }

    @Override
    public boolean applyProperties() {
        if (this.coarsenessCbx != null) {
            TwoFacedObject tfo = (TwoFacedObject)this.coarsenessCbx.getSelectedItem();
            this.coarseness = (Double)tfo.getId();
        }
        return super.applyProperties();
    }

    @Override
    public boolean canSaveDataToLocalDisk() {
        return !this.isFileBased();
    }

    @Override
    public void initAfterUnpersistence() {
        if (this.sources == null) {
            this.sources = Misc.newList(this.getName());
        }
        super.initAfterUnpersistence();
        this.initShapeFileDataSource();
    }

    private void initShapeFileDataSource() {
    }

    @Override
    protected void doMakeDataChoices() {
        File file = new File(this.getSource());
        if (file.isDirectory()) {
            CompositeDataChoice composite = new CompositeDataChoice(this, (Object)"", this.getSource(), this.getSource(), null);
            this.walkTree(file, composite);
            this.addDataChoice(composite);
        } else {
            String name = this.getProperty("TITLE", null);
            if (name == null) {
                name = this.getProperty("name", null);
            }
            if (name == null) {
                name = IOUtil.getFileTail(this.getSource());
            }
            Hashtable props = Misc.newHashtable("prop.icon", "/auxdata/ui/icons/Map16.gif");
            this.addDataChoice(new DirectDataChoice((DataSource)this, (Object)this.getSource(), name, name, this.categories, props));
        }
    }

    private void walkTree(File directory, CompositeDataChoice parent) {
        File[] subfiles = directory.listFiles();
        for (int i = 0; i < subfiles.length; ++i) {
            if (subfiles[i].isDirectory()) {
                String dirName = IOUtil.getFileTail(subfiles[i].toString());
                CompositeDataChoice composite = new CompositeDataChoice(this, (Object)"", dirName, dirName, null);
                parent.addDataChoice(composite);
                this.walkTree(subfiles[i], composite);
                continue;
            }
            if (!subfiles[i].toString().toLowerCase().endsWith(".shp")) continue;
            String name = subfiles[i].toString();
            String shortName = IOUtil.stripExtension(IOUtil.getFileTail(name));
            parent.addDataChoice(new DirectDataChoice(this, (Object)name, shortName, shortName, this.categories));
        }
    }

    @Override
    protected Data getDataInner(DataChoice dataChoice, DataCategory category, DataSelection dataSelection, Hashtable requestProperties) throws VisADException, RemoteException {
        GeoSelection geoSelection = dataSelection != null ? dataSelection.getGeoSelection() : null;
        GeoLocationInfo bbox = geoSelection == null ? null : geoSelection.getBoundingBox();
        LatLonRect llr = bbox != null ? bbox.getLatLonRect() : null;
        boolean useDbFile = true;
        boolean amSubsetting = false;
        Rectangle2D.Double box = null;
        if (llr != null) {
            LatLonPointImpl ul = llr.getUpperLeftPoint();
            LatLonPointImpl lr = llr.getLowerRightPoint();
            box = new Rectangle2D.Double(ul.getLongitude(), ul.getLatitude() - llr.getHeight(), llr.getWidth(), llr.getHeight());
            this.shapefileData = null;
            amSubsetting = true;
            useDbFile = false;
        }
        if (this.coarseness != this.lastCoarseness) {
            this.shapefileData = null;
            amSubsetting = true;
            useDbFile = false;
        }
        this.lastCoarseness = this.coarseness;
        String filename = (String)dataChoice.getId();
        byte[] bytes = null;
        try {
            if (this.shapefileData == null) {
                if (!(IOUtil.hasSuffix(filename, ".shp") || IOUtil.hasSuffix(filename, ".zip") || IOUtil.hasSuffix(filename, ".tcl"))) {
                    try {
                        URL url = IOUtil.getURL(filename, this.getClass());
                        this.shapefileData = url == null ? (SampledSet)mapFamily.open(filename) : (SampledSet)mapFamily.open(url);
                        return this.shapefileData;
                    }
                    catch (Exception exc) {
                        exc.printStackTrace();
                    }
                }
                if (this.getProperty("DataSource.Cacheable", false)) {
                    bytes = CacheManager.getCachedFile("ShapeFileDataSource", filename);
                }
                if (bytes == null) {
                    Object loadId = JobManager.getManager().startLoad("Map File");
                    bytes = IOUtil.readBytes(IOUtil.getInputStream(filename, this.getClass()), loadId);
                    JobManager.getManager().stopLoad(loadId);
                }
                if (bytes == null) {
                    return null;
                }
                ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes, 0, bytes.length);
                ShapefileAdapter sfa = new ShapefileAdapter(inputStream, filename, box, this.coarseness);
                this.dbFile = sfa.getDbFile();
                if (useDbFile && this.dbFile == null && IOUtil.hasSuffix(filename, ".shp")) {
                    InputStream dbfInputStream = null;
                    try {
                        String dbFilename = IOUtil.stripExtension(filename) + ".dbf";
                        dbfInputStream = IOUtil.getInputStream(dbFilename, this.getClass());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (dbfInputStream != null) {
                        this.dbFile = new DbaseFile(dbfInputStream);
                        this.dbFile.loadHeader();
                        this.dbFile.loadData();
                    }
                }
                this.shapefileData = sfa.getData();
                if (useDbFile) {
                    this.setProperties(this.shapefileData, this.dbFile);
                }
            }
            if (useDbFile && requestProperties != null && this.dbFile != null) {
                requestProperties.put(PROP_DBFILE, this.dbFile);
            }
            Data result = this.shapefileData;
            if (amSubsetting) {
                this.shapefileData = null;
            }
            return result;
        }
        catch (Exception exc) {
            this.logException("Reading shapefile: " + filename, exc, bytes);
            return null;
        }
    }

    public static Data readMap(String filename) throws Exception {
        byte[] bytes;
        if (!IOUtil.hasSuffix(filename, ".shp") && !IOUtil.hasSuffix(filename, ".zip")) {
            try {
                URL url = IOUtil.getURL(filename, ShapeFileDataSource.class);
                SampledSet data = url == null ? (SampledSet)mapFamily.open(filename) : (SampledSet)mapFamily.open(url);
                return data;
            }
            catch (Exception url) {
                // empty catch block
            }
        }
        if ((bytes = IOUtil.readBytes(IOUtil.getInputStream(filename, ShapeFileDataSource.class))) == null) {
            return null;
        }
        ShapefileAdapter sfa = new ShapefileAdapter((InputStream)new ByteArrayInputStream(bytes, 0, bytes.length), filename);
        UnionSet data = sfa.getData();
        return data;
    }

    private void setProperties(Data shapefileData, DbaseFile dbFile) {
        String fieldName;
        int fieldIdx;
        if (dbFile == null || shapefileData == null || !(shapefileData instanceof UnionSet)) {
            return;
        }
        SampledSet[] sets = ((UnionSet)shapefileData).getSets();
        if (sets.length == 0 || !(sets[0] instanceof MapSet)) {
            return;
        }
        int numFields = dbFile.getNumFields();
        ArrayList<String> propertyNames = new ArrayList<String>();
        for (fieldIdx = 0; fieldIdx < numFields; ++fieldIdx) {
            fieldName = dbFile.getFieldName(fieldIdx);
            DbaseData dbData = dbFile.getField(fieldIdx);
            List values = dbData.asList();
            if (values.size() != sets.length) {
                System.err.println(" WARNING:DBfile size:" + values.size() + " != number of map lines:" + sets.length);
                return;
            }
            for (int i = 0; i < sets.length; ++i) {
                if (!(sets[i] instanceof MapSet)) continue;
                MapSet mapSet = (MapSet)sets[i];
                mapSet.setProperty(fieldName, values.get(i));
            }
        }
        for (fieldIdx = 0; fieldIdx < numFields; ++fieldIdx) {
            fieldName = dbFile.getFieldName(fieldIdx);
            propertyNames.add(fieldName);
        }
        for (int i = 0; i < sets.length; ++i) {
            if (!(sets[i] instanceof MapSet)) continue;
            MapSet mapSet = (MapSet)sets[i];
            mapSet.setPropertyNames(propertyNames);
        }
    }

    @Override
    protected boolean shouldCache(Data data) {
        return false;
    }

    @Override
    protected List doMakeDateTimes() {
        return new ArrayList();
    }

    public void setCoarseness(double value) {
        this.coarseness = value;
    }

    public double getCoarseness() {
        return this.coarseness;
    }
}

