/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.data.gis;

import java.awt.Color;
import java.awt.Font;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ucar.unidata.data.DataCategory;
import ucar.unidata.data.DataChoice;
import ucar.unidata.data.DataSelection;
import ucar.unidata.data.DataSourceDescriptor;
import ucar.unidata.data.DirectDataChoice;
import ucar.unidata.data.FilesDataSource;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.IOUtil;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.StringUtil;
import ucar.unidata.xml.XmlUtil;
import visad.Data;
import visad.Text;
import visad.VisADException;

public class PlaceFileDataSource
extends FilesDataSource {
    private static final String SHAPE_TITLE = "Title";
    private static final String SHAPE_LINE = "Line";
    private static final String SHAPE_PLACE = "Place";
    private static final String SHAPE_END = "End";
    private static final String SHAPE_TEXT = "Text";
    private static final String SHAPE_COLOR = "Color";
    private static final String SHAPE_FONT = "Font";
    private static final String SHAPE_OBJECT = "Object";

    public PlaceFileDataSource() {
    }

    public PlaceFileDataSource(DataSourceDescriptor descriptor, String filename, Hashtable properties) {
        this(descriptor, Misc.newList(filename), properties);
    }

    public PlaceFileDataSource(DataSourceDescriptor descriptor, List files, Hashtable properties) {
        super(descriptor, files, (String)files.get(0), "Place files data source", properties);
    }

    @Override
    protected void doMakeDataChoices() {
        String category = "xgrf";
        String docName = this.getName();
        this.addDataChoice(new DirectDataChoice(this, (Object)docName, docName, docName, DataCategory.parseCategories(category, false)));
    }

    @Override
    protected Data getDataInner(DataChoice dataChoice, DataCategory category, DataSelection dataSelection, Hashtable requestProperties) throws VisADException, RemoteException {
        try {
            String xml = this.processContents();
            if (xml == null) {
                return null;
            }
            return new Text(xml);
        }
        catch (Exception exc) {
            this.logException("Could not process front file contents: " + this.sources, exc);
            return null;
        }
    }

    private String processContents() throws Exception {
        Document doc = XmlUtil.makeDocument();
        Element root = doc.createElement("shapes");
        Element editorNode = XmlUtil.create("editor", root);
        editorNode.setAttribute("editable", "false");
        ArrayList contentsList = new ArrayList();
        boolean anyOk = false;
        for (int i = 0; i < this.sources.size(); ++i) {
            String filename = (String)this.sources.get(i);
            LogUtil.message("Reading place file: " + filename);
            String contents = IOUtil.readContents(filename);
            this.processContents(contents, root, editorNode);
        }
        String xgrf = XmlUtil.toString(root);
        System.err.println(xgrf);
        return xgrf;
    }

    private void processContents(String contents, Element root, Element editorNode) throws Exception {
        Color color = Color.magenta;
        Font font = GuiUtils.buttonFont;
        List<String> lines = StringUtil.split(contents, "\n", true, true);
        Hashtable<String, Font> fonts = new Hashtable<String, Font>();
        for (int lineIdx = 0; lineIdx < lines.size(); ++lineIdx) {
            Object subtoks;
            String[] toks;
            String line = lines.get(lineIdx);
            if (line.length() == 0 || line.startsWith(";") || (toks = StringUtil.split(line, ":", 2)) == null || toks.length != 2) continue;
            if (toks[0].equals(SHAPE_COLOR)) {
                color = GuiUtils.decodeColor(toks[1], color);
                continue;
            }
            if (toks[0].equals(SHAPE_FONT)) {
                subtoks = StringUtil.split(toks[1], ",", 3);
                if (subtoks == null) continue;
                int fontStyle = 0;
                int flags = new Integer(toks[2]);
                if ((flags & 1) != 0) {
                    fontStyle |= 1;
                }
                if ((flags & 2) != 0) {
                    fontStyle |= 2;
                }
                Font f = new Font(toks[3], fontStyle, new Integer(toks[1]));
                fonts.put(toks[0], f);
                continue;
            }
            if (toks[0].equals(SHAPE_TITLE)) {
                editorNode.setAttribute("title", toks[1]);
                continue;
            }
            if (toks[0].equals(SHAPE_PLACE)) {
                subtoks = StringUtil.split(toks[1], ",", 3);
                if (subtoks == null) continue;
                Element child = this.create("text", root, color);
                child.setAttribute("points", subtoks[0] + "," + (String)subtoks[1]);
                child.setAttribute("text", (String)subtoks[2]);
                continue;
            }
            if (toks[0].equals(SHAPE_TEXT)) {
                subtoks = StringUtil.split(toks[1], ",", true, true);
                Element child = this.create("text", root, color);
                child.setAttribute("points", (String)subtoks.get(0) + "," + (String)subtoks.get(1));
                child.setAttribute("text", (String)subtoks.get(2));
                continue;
            }
            if (toks[0].equals(SHAPE_LINE)) {
                subtoks = StringUtil.split(toks[1], ",", true, true);
                Element child = this.create("polygon", root, color);
                child.setAttribute("linewidth", (String)subtoks.get(0));
                if (subtoks.size() >= 3) {
                    child.setAttribute("name", (String)subtoks.get(2));
                }
                StringBuffer points = null;
                ++lineIdx;
                while (lineIdx < lines.size()) {
                    line = lines.get(lineIdx);
                    if (!line.startsWith(";") && line.length() != 0) {
                        if (line.equals("End:")) break;
                        if (points == null) {
                            points = new StringBuffer();
                        } else {
                            points.append(",");
                        }
                        points.append(line);
                    }
                    ++lineIdx;
                }
                if (points == null) continue;
                child.setAttribute("points", points.toString());
                continue;
            }
            System.err.println("Unknown  placefile tag:" + toks[0]);
        }
    }

    private void setFont(Element node, Hashtable fonts, String id) {
        Font f = (Font)fonts.get(id);
        if (f != null) {
            node.setAttribute("fontface", f.getFamily());
            node.setAttribute("fontsize", "" + f.getSize());
        }
    }

    private Element create(String tag, Element root, Color color) throws Exception {
        Element child = XmlUtil.create(tag, root);
        XmlUtil.setAttribute(child, "color", color);
        child.setAttribute("coordtype", "LATLON");
        return child;
    }

    public static void main(String[] args) throws Exception {
        for (int i = 0; i < 20; ++i) {
        }
    }
}

