/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.data.gis;

import java.util.ArrayList;
import java.util.List;
import ucar.unidata.util.Misc;
import ucar.visad.data.MapSet;
import visad.CoordinateSystem;
import visad.ErrorEstimate;
import visad.Gridded2DSet;
import visad.RealTupleType;
import visad.RealType;
import visad.SampledSet;
import visad.UnionSet;
import visad.Unit;
import visad.VisADException;

public class MapMaker {
    List<MapSet> mapSets = new ArrayList<MapSet>();

    public void addMap(double[][] latLons) throws VisADException {
        this.addMap(Misc.toFloat(latLons));
    }

    public void addMap(double[] latLons) throws VisADException {
        this.addMap(Misc.toFloat(latLons));
    }

    public void addMap(float[] latLons) throws VisADException {
        float[][] tmp = new float[2][latLons.length / 2];
        int cnt = 0;
        for (int i = 0; i < latLons.length; i += 2) {
            tmp[0][cnt] = latLons[i];
            tmp[1][cnt] = latLons[i + 1];
            ++cnt;
        }
        this.addMap(tmp);
    }

    public void addMap(float[][] latLons) throws VisADException {
        float[][] lonLats = new float[][]{latLons[1], latLons[0]};
        RealTupleType coordMathType = new RealTupleType(RealType.Longitude, RealType.Latitude);
        this.mapSets.add(new MapSet(coordMathType, (float[][])lonLats, lonLats[0].length, (CoordinateSystem)null, (Unit[])null, (ErrorEstimate[])null, false));
    }

    public UnionSet getMaps() throws VisADException {
        SampledSet[] latLonLines = new Gridded2DSet[this.mapSets.size()];
        int cnt = 0;
        for (MapSet mapSet : this.mapSets) {
            latLonLines[cnt++] = mapSet;
        }
        RealTupleType coordMathType = new RealTupleType(RealType.Longitude, RealType.Latitude);
        UnionSet mapLines = new UnionSet(coordMathType, latLonLines, null, null, null, false);
        return mapLines;
    }
}

