/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.data.gis;

import java.awt.Color;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;
import ucar.unidata.util.DateUtil;
import ucar.unidata.util.StringUtil;
import ucar.unidata.xml.XmlUtil;

public class KmlUtil {
    public static final String TAG_ALTITUDE = "altitude";
    public static final String TAG_ALTITUDEMODE = "altitudeMode";
    public static final String TAG_BALLOONSTYLE = "BalloonStyle";
    public static final String TAG_BOTTOMFOV = "bottomFov";
    public static final String TAG_CAMERA = "Camera";
    public static final String TAG_COLOR = "color";
    public static final String TAG_COLORMODE = "colorMode";
    public static final String TAG_COORDINATES = "coordinates";
    public static final String TAG_DESCRIPTION = "description";
    public static final String TAG_DOCUMENT = "Document";
    public static final String TAG_EAST = "east";
    public static final String TAG_EXTRUDE = "extrude";
    public static final String TAG_FOLDER = "Folder";
    public static final String TAG_GROUNDOVERLAY = "GroundOverlay";
    public static final String TAG_HEADING = "heading";
    public static final String TAG_HREF = "href";
    public static final String TAG_ICON = "Icon";
    public static final String TAG_ICONSTYLE = "IconStyle";
    public static final String TAG_KEY = "key";
    public static final String TAG_KML = "kml";
    public static final String TAG_LABELSTYLE = "LabelStyle";
    public static final String TAG_LATITUDE = "latitude";
    public static final String TAG_LATLONBOX = "LatLonBox";
    public static final String TAG_LEFTFOV = "leftFov";
    public static final String TAG_LINESTRING = "LineString";
    public static final String TAG_LINESTYLE = "LineStyle";
    public static final String TAG_LINK = "Link";
    public static final String TAG_LONGITUDE = "longitude";
    public static final String TAG_LOOKAT = "LookAt";
    public static final String TAG_MULTIGEOMETRY = "MultiGeometry";
    public static final String TAG_NAME = "name";
    public static final String TAG_NEAR = "near";
    public static final String TAG_NETWORKLINK = "NetworkLink";
    public static final String TAG_NORTH = "north";
    public static final String TAG_PHOTOOVERLAY = "PhotoOverlay";
    public static final String TAG_OPEN = "open";
    public static final String TAG_OVERLAYXY = "overlayXY";
    public static final String TAG_PAIR = "Pair";
    public static final String TAG_PLACEMARK = "Placemark";
    public static final String TAG_POINT = "Point";
    public static final String TAG_RIGHTFOV = "rightFov";
    public static final String TAG_ROLL = "roll";
    public static final String TAG_ROTATION = "rotation";
    public static final String TAG_SCHEMA = "Schema";
    public static final String TAG_SCREENOVERLAY = "ScreenOverlay";
    public static final String TAG_SCREENXY = "screenXY";
    private static final String TAG_SIZE = "size";
    public static final String TAG_SNIPPET = "Snippet";
    public static final String TAG_SOUTH = "south";
    public static final String TAG_STYLE = "Style";
    public static final String TAG_STYLEMAP = "StyleMap";
    public static final String TAG_STYLEURL = "styleUrl";
    public static final String TAG_TESSELATE = "tesselate";
    public static final String TAG_TEXT = "text";
    public static final String TAG_TILT = "tilt";
    public static final String TAG_TIMESTAMP = "TimeStamp";
    public static final String TAG_TOPFOV = "topFov";
    public static final String TAG_URL = "Url";
    public static final String TAG_VIEWVOLUME = "ViewVolume";
    public static final String TAG_SCALE = "scale";
    public static final String TAG_VIEWBOUNDSCALE = "viewBoundScale";
    public static final String TAG_VISIBILITY = "visibility";
    public static final String TAG_WEST = "west";
    public static final String TAG_WHEN = "when";
    public static final String TAG_WIDTH = "width";
    public static final String TAG_TOUR = "gx:Tour";
    public static final String TAG_PLAYLIST = "gx:Playlist";
    public static final String TAG_FLYTO = "gx:FlyTo";
    public static final String TAG_WAIT = "gx:Wait";
    public static final String ATTR_ID = "id";
    public static final String ATTR_NAME = "name";
    public static final String ATTR_X = "x";
    public static final String ATTR_Y = "y";
    public static final String ATTR_XUNITS = "xunits";
    public static final String ATTR_YUNITS = "yunits";
    public static final String XMLNS_KML2_2 = "http://www.opengis.net/kml/2.2";
    private static SimpleDateFormat sdf1;
    private static SimpleDateFormat sdf2;

    public static Element makeElement(Element parent, String tag) {
        Element child = parent.getOwnerDocument().createElement(tag);
        parent.appendChild(child);
        return child;
    }

    public static Element kml(String name) {
        Document doc = XmlUtil.makeDocument();
        Element child = doc.createElement(TAG_KML);
        child.setAttribute("xmlns", XMLNS_KML2_2);
        return child;
    }

    public static Element document(Element parent, String name) {
        return KmlUtil.document(parent, name, false);
    }

    public static Element document(Element parent, String name, boolean visible) {
        Element node = KmlUtil.makeElement(parent, TAG_DOCUMENT);
        KmlUtil.name(node, name);
        KmlUtil.visible(node, visible);
        return node;
    }

    public static Element networkLink(Element parent, String name, String url) {
        Element networkLink = KmlUtil.makeElement(parent, TAG_NETWORKLINK);
        KmlUtil.makeText(networkLink, "name", name);
        Element link = KmlUtil.makeElement(networkLink, TAG_LINK);
        KmlUtil.makeText(link, TAG_HREF, url);
        return networkLink;
    }

    public static Element makeText(Element parent, String tag, String text) {
        Element node = KmlUtil.makeElement(parent, tag);
        Text textNode = parent.getOwnerDocument().createTextNode(text);
        node.appendChild(textNode);
        return node;
    }

    public static Element visible(Element parent, boolean visible) {
        return KmlUtil.makeText(parent, TAG_VISIBILITY, visible ? "1" : "0");
    }

    public static Element snippet(Element parent, String snippet) {
        return KmlUtil.makeText(parent, TAG_SNIPPET, snippet);
    }

    public static Element open(Element parent, boolean open) {
        return KmlUtil.makeText(parent, TAG_OPEN, open ? "1" : "0");
    }

    public static Element timestamp(Element parent, Date dttm) {
        if (sdf1 == null) {
            sdf1 = new SimpleDateFormat("yyyy-MM-dd");
            sdf2 = new SimpleDateFormat("HH:mm:ss");
            sdf1.setTimeZone(DateUtil.TIMEZONE_GMT);
            sdf2.setTimeZone(DateUtil.TIMEZONE_GMT);
        }
        String when = sdf1.format(dttm) + "T" + sdf2.format(dttm) + "Z";
        Element timestamp = KmlUtil.makeElement(parent, TAG_TIMESTAMP);
        KmlUtil.makeText(timestamp, TAG_WHEN, when);
        return timestamp;
    }

    public static Element pair(Element parent, String key, String styleUrl) {
        Element pair = KmlUtil.makeElement(parent, TAG_PAIR);
        KmlUtil.makeText(pair, TAG_KEY, key);
        KmlUtil.makeText(pair, TAG_STYLEURL, styleUrl);
        return pair;
    }

    public static Element stylemap(Element parent, String id, String normalStyleUrl, String highlightStyleUrl) {
        Element stylemap = KmlUtil.makeElement(parent, TAG_STYLEMAP);
        stylemap.setAttribute(ATTR_ID, id);
        KmlUtil.pair(stylemap, "normal", normalStyleUrl);
        KmlUtil.pair(stylemap, "highlight", highlightStyleUrl);
        return stylemap;
    }

    public static Element styleurl(Element parent, String url) {
        return KmlUtil.makeText(parent, TAG_STYLEURL, url);
    }

    public static Element style(Element parent, String id) {
        Element style = KmlUtil.makeElement(parent, TAG_STYLE);
        style.setAttribute(ATTR_ID, id);
        return style;
    }

    public static Element iconstyle(Element parent, String id, String url) {
        return KmlUtil.iconstyle(parent, id, url, -1.0);
    }

    public static Element iconstyle(Element parent, String id, String url, double scale) {
        return KmlUtil.iconstyle(parent, id, url, scale, null);
    }

    public static Element iconstyle(Element parent, String id, String url, double scale, Color color) {
        Element style = KmlUtil.style(parent, id);
        Element iconstyle = KmlUtil.iconstyle(style, url, scale, color);
        return iconstyle;
    }

    public static Element iconstyle(Element parent, String url, double scale, Color color) {
        Element iconstyle = KmlUtil.makeElement(parent, TAG_ICONSTYLE);
        if (color != null) {
            KmlUtil.makeText(iconstyle, TAG_COLOR, "ff" + KmlUtil.toBGRHexString(color).substring(1));
            KmlUtil.makeText(iconstyle, TAG_COLORMODE, "normal");
        }
        Element icon = KmlUtil.makeElement(iconstyle, TAG_ICON);
        KmlUtil.makeText(icon, TAG_HREF, url);
        if (scale >= 0.0) {
            KmlUtil.makeText(iconstyle, TAG_SCALE, "" + scale);
        }
        return iconstyle;
    }

    public static Element balloonstyle(Element parent, String text, Color bgColor) {
        Element bstyle = KmlUtil.makeElement(parent, TAG_BALLOONSTYLE);
        if (bgColor != null) {
            KmlUtil.makeText(bstyle, TAG_COLOR, "ff" + KmlUtil.toBGRHexString(bgColor).substring(1));
        }
        KmlUtil.makeText(bstyle, TAG_TEXT, text);
        return bstyle;
    }

    public static Element balloonstyle(Element parent, String id, String text, Color bgColor) {
        Element style = KmlUtil.style(parent, id);
        Element bstyle = KmlUtil.balloonstyle(style, text, bgColor);
        return bstyle;
    }

    public static Element labelstyle(Element parent, String id, Color color, int scale) {
        Element style = KmlUtil.style(parent, id);
        Element labelstyle = KmlUtil.labelstyle(style, color, scale);
        return labelstyle;
    }

    public static Element labelstyle(Element parent, Color color, int scale) {
        Element labelstyle = KmlUtil.makeElement(parent, TAG_LABELSTYLE);
        if (color != null) {
            KmlUtil.makeText(labelstyle, TAG_COLOR, "ff" + KmlUtil.toBGRHexString(color).substring(1));
            KmlUtil.makeText(labelstyle, TAG_COLORMODE, "normal");
        }
        if (scale >= 0) {
            KmlUtil.makeText(labelstyle, TAG_SCALE, "" + scale);
        }
        return labelstyle;
    }

    public static Element linestyle(Element parent, String id, Color color, int width) {
        Element style = KmlUtil.style(parent, id);
        Element linestyle = KmlUtil.makeElement(style, TAG_LINESTYLE);
        if (color != null) {
            KmlUtil.makeText(linestyle, TAG_COLOR, "ff" + KmlUtil.toBGRHexString(color).substring(1));
            KmlUtil.makeText(linestyle, TAG_COLORMODE, "normal");
        }
        if (width > 0) {
            KmlUtil.makeText(linestyle, TAG_WIDTH, "" + width);
        }
        return linestyle;
    }

    public static Element linestring(Element parent, boolean extrude, boolean tesselate, String coordinates) {
        Element node = KmlUtil.makeElement(parent, TAG_LINESTRING);
        KmlUtil.makeText(node, TAG_EXTRUDE, extrude ? "1" : "0");
        KmlUtil.makeText(node, TAG_TESSELATE, tesselate ? "1" : "0");
        KmlUtil.coordinates(node, coordinates);
        return node;
    }

    public static Element linestring(Element parent, boolean extrude, boolean tesselate, float[][] coords) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < coords[0].length; ++i) {
            sb.append(coords[1][i]);
            sb.append(",");
            sb.append(coords[0][i]);
            if (coords.length > 2) {
                sb.append(",");
                sb.append(coords[2][i]);
            }
            sb.append(" ");
        }
        return KmlUtil.linestring(parent, extrude, tesselate, sb.toString());
    }

    public static Element coordinates(Element parent, String coordinates) {
        Element node = KmlUtil.makeElement(parent, TAG_COORDINATES);
        Text textNode = parent.getOwnerDocument().createTextNode(coordinates);
        node.appendChild(textNode);
        return node;
    }

    public static Element name(Element parent, String name) {
        Element node = KmlUtil.makeElement(parent, "name");
        CDATASection cdata = parent.getOwnerDocument().createCDATASection(name);
        node.appendChild(cdata);
        return node;
    }

    public static Element description(Element parent, String description) {
        Element node = KmlUtil.makeElement(parent, TAG_DESCRIPTION);
        CDATASection cdata = parent.getOwnerDocument().createCDATASection(description);
        node.appendChild(cdata);
        return node;
    }

    public static Element folder(Element parent, String name) {
        return KmlUtil.folder(parent, name, false);
    }

    public static Element folder(Element parent, String name, boolean visible) {
        Element node = KmlUtil.makeElement(parent, TAG_FOLDER);
        KmlUtil.name(node, name);
        KmlUtil.visible(node, visible);
        return node;
    }

    public static Element placemark(Element parent, String name, String description) {
        Element node = KmlUtil.makeElement(parent, TAG_PLACEMARK);
        KmlUtil.name(node, name);
        KmlUtil.description(node, description);
        return node;
    }

    public static String point(double lat, double lon, double alt, String style) {
        return "<Placemark><Point><coordinates>" + lon + "," + lat + "," + alt + "</coordinates></Point></Placemark>";
    }

    public static Element placemark(Element parent, String name, String description, double lat, double lon, double alt, String styleUrl) {
        return KmlUtil.placemark(parent, name, description, lat, lon, alt, new String[]{styleUrl}, true);
    }

    public static Element placemark(Element parent, String name, String description, double lat, double lon, double alt, String[] styleUrls, boolean visible) {
        Element placemark = KmlUtil.placemark(parent, name, description);
        if (styleUrls != null) {
            for (int i = 0; i < styleUrls.length; ++i) {
                KmlUtil.makeText(placemark, TAG_STYLEURL, styleUrls[i]);
            }
        }
        KmlUtil.visible(placemark, visible);
        Element point = KmlUtil.makeElement(placemark, TAG_POINT);
        KmlUtil.makeText(point, TAG_COORDINATES, lon + "," + lat + "," + alt + " ");
        return placemark;
    }

    public static Element groundOverlay(Element parent, String name, String description, String url, double north, double south, double east, double west) {
        return KmlUtil.groundOverlay(parent, name, description, url, north, south, east, west, false);
    }

    public static Element groundOverlay(Element parent, String name, String description, String url, double north, double south, double east, double west, boolean visible) {
        Element node = KmlUtil.makeElement(parent, TAG_GROUNDOVERLAY);
        KmlUtil.name(node, name);
        KmlUtil.description(node, description);
        KmlUtil.visible(node, false);
        Element icon = KmlUtil.makeElement(node, TAG_ICON);
        Element href = KmlUtil.makeText(icon, TAG_HREF, url);
        Element llb = KmlUtil.makeElement(node, TAG_LATLONBOX);
        KmlUtil.makeText(llb, TAG_NORTH, "" + north);
        KmlUtil.makeText(llb, TAG_SOUTH, "" + south);
        KmlUtil.makeText(llb, TAG_EAST, "" + east);
        KmlUtil.makeText(llb, TAG_WEST, "" + west);
        return node;
    }

    public static Element placemark(Element parent, String name, String description, float[][] coords, Color color, int width) {
        Element placemark = KmlUtil.placemark(parent, name, description);
        Element linestring = KmlUtil.linestring(placemark, false, false, coords);
        String randomStyle = System.currentTimeMillis() + "_" + (int)(Math.random() * 1000.0);
        KmlUtil.linestyle(placemark, randomStyle, color, width);
        return placemark;
    }

    public static double[][] parseCoordinates(String coords) {
        String newCoords;
        coords = StringUtil.replace(coords, "\n", " ");
        while (!(newCoords = StringUtil.replace(coords, " ,", ",")).equals(coords)) {
            coords = newCoords;
        }
        while (!(newCoords = StringUtil.replace(coords, ", ", ",")).equals(coords)) {
            coords = newCoords;
        }
        List<String> tokens = StringUtil.split(coords, " ", true, true);
        double[][] result = null;
        for (int pointIdx = 0; pointIdx < tokens.size(); ++pointIdx) {
            String tok = tokens.get(pointIdx);
            List<String> numbers = StringUtil.split(tok, ",");
            if (numbers.size() != 2 && numbers.size() != 3) {
                if (numbers.size() > 3 && tokens.size() == 1 && numbers.size() / 3 * 3 == numbers.size()) {
                    result = new double[3][numbers.size() / 3];
                    int cnt = 0;
                    for (int i = 0; i < numbers.size(); i += 3) {
                        result[0][cnt] = new Double(numbers.get(i).toString());
                        result[1][cnt] = new Double(numbers.get(i + 1).toString());
                        result[2][cnt] = new Double(numbers.get(i + 2).toString());
                        ++cnt;
                    }
                    return result;
                }
                throw new IllegalStateException("Bad number of coordinate values:" + numbers);
            }
            if (result == null) {
                result = new double[numbers.size()][tokens.size()];
            }
            for (int coordIdx = 0; coordIdx < numbers.size(); ++coordIdx) {
                result[coordIdx][pointIdx] = new Double(numbers.get(coordIdx).toString());
            }
        }
        return result;
    }

    public static String toBGRHexString(Color c) {
        return "#" + StringUtil.padRight(Integer.toHexString(c.getBlue()), 2, "0") + StringUtil.padRight(Integer.toHexString(c.getGreen()), 2, "0") + StringUtil.padRight(Integer.toHexString(c.getRed()), 2, "0");
    }

    public static Element screenoverlay(Element parent, String name, String iconURL, double overlayX, double overlayY, String overlayXunits, String overlayYunits, double screenX, double screenY, String screenXunits, String screenYunits) {
        return KmlUtil.screenoverlay(parent, name, iconURL, overlayX, overlayY, overlayXunits, overlayYunits, screenX, screenY, screenXunits, screenYunits, -1.0, -1.0, "fraction", "fraction");
    }

    public static Element screenoverlay(Element parent, String name, String iconURL, double overlayX, double overlayY, String overlayXunits, String overlayYunits, double screenX, double screenY, String screenXunits, String screenYunits, double sizeX, double sizeY, String sizeXunits, String sizeYunits) {
        Element screenOlay = KmlUtil.makeElement(parent, TAG_SCREENOVERLAY);
        KmlUtil.makeText(screenOlay, "name", name);
        KmlUtil.olayElement(screenOlay, TAG_OVERLAYXY, overlayX, overlayY, overlayXunits, overlayYunits);
        KmlUtil.olayElement(screenOlay, TAG_SCREENXY, screenX, screenY, screenXunits, screenYunits);
        KmlUtil.olayElement(screenOlay, TAG_SIZE, sizeX, sizeY, sizeXunits, sizeYunits);
        Element icon = KmlUtil.makeElement(screenOlay, TAG_ICON);
        KmlUtil.makeText(icon, TAG_HREF, iconURL);
        return screenOlay;
    }

    private static Element olayElement(Element parent, String tag, double x, double y, String xunits, String yunits) {
        Element olayElement = KmlUtil.makeElement(parent, tag);
        olayElement.setAttribute(ATTR_X, "" + x);
        olayElement.setAttribute(ATTR_Y, "" + y);
        olayElement.setAttribute(ATTR_XUNITS, xunits);
        olayElement.setAttribute(ATTR_YUNITS, yunits);
        return olayElement;
    }
}

