/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.data.gis;

import java.rmi.RemoteException;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import ucar.unidata.data.gis.KmlDataSource;
import ucar.unidata.data.gis.KmlInfo;
import ucar.unidata.data.gis.KmlUtil;
import ucar.unidata.xml.XmlUtil;
import visad.Data;
import visad.DateTime;
import visad.Text;
import visad.VisADException;

public class KmlPolygons
extends KmlInfo {
    public static final String TAG_POLYGON = "Polygon";
    public static final String TAG_OUTERBOUNDARYIS = "outerBoundaryIs";
    public static final String TAG_LINEARRING = "LinearRing";
    public String color = "";
    public DateTime dateTime = null;

    public KmlPolygons() {
    }

    public KmlPolygons(Element node, String displayCategory, String color) {
        super(node, displayCategory, "xgrf");
        this.color = color;
        if (this.color == null || this.color == "") {
            this.color = "255,0,0";
        }
    }

    public KmlPolygons(Element node, String displayCategory, String color, DateTime dateTime) {
        super(node, displayCategory, "xgrf");
        this.color = color;
        this.dateTime = dateTime;
        if (this.color == null || this.color == "") {
            this.color = "255,0,0";
        }
    }

    @Override
    public Data getData(KmlDataSource dataSource, Object loadId) throws VisADException, RemoteException {
        StringBuffer sb = new StringBuffer("<shapes>\n");
        Element multiGeometryNode = XmlUtil.findChild(this.node, "MultiGeometry");
        Element linestringNode = XmlUtil.findChild(this.node, "LineString");
        if (linestringNode != null) {
            this.processPolygonNode(linestringNode, sb, this.color);
        } else if (multiGeometryNode != null) {
            NodeList children = XmlUtil.getElements(multiGeometryNode);
            for (int childIdx = 0; childIdx < children.getLength(); ++childIdx) {
                Element child = (Element)children.item(childIdx);
                if (!child.getTagName().equals(TAG_POLYGON)) continue;
                this.processPolygonNode(child, sb, this.color);
            }
        } else {
            Element polygonNode = XmlUtil.findChild(this.node, TAG_POLYGON);
            if (polygonNode != null) {
                this.processPolygonNode(polygonNode, sb, this.color);
            } else {
                this.processPolygonNode(this.node, sb, this.color);
            }
        }
        sb.append("</shapes>");
        return new Text(sb.toString());
    }

    private void processPolygonNode(Element node, StringBuffer sb, String color) {
        String altitudeMode = XmlUtil.getChildText(XmlUtil.findChild(node, "altitudeMode"));
        String attrs = altitudeMode.contentEquals("clampToGround") ? XmlUtil.attrs("smooth", "false", "filled", "false", "color", color, "coordtype", "LATLON") : XmlUtil.attrs("smooth", "false", "filled", "false", "color", color, "coordtype", "LATLONALT");
        if (this.dateTime != null) {
            sb.append("<polygon timeformat=\"yyyy-MM-dd HH:mm:ss\" times=\"" + this.dateTime.toString() + "\"" + attrs);
        } else {
            sb.append("<polygon " + attrs);
        }
        sb.append("points=\"");
        Element coordNode = XmlUtil.findDescendantFromPath(node, "outerBoundaryIs.LinearRing.coordinates");
        if (coordNode == null) {
            coordNode = XmlUtil.findDescendantFromPath(node, "LineString.coordinates");
        }
        if (coordNode == null) {
            coordNode = XmlUtil.findDescendantFromPath(node, "coordinates");
        }
        if (coordNode == null) {
            System.err.println("Could not find coord node: " + XmlUtil.toString(node));
        } else {
            String coordText = XmlUtil.getChildText(coordNode);
            double[][] coords = KmlUtil.parseCoordinates(coordText);
            for (int coordIdx = 0; coordIdx < coords[0].length; ++coordIdx) {
                if (coordIdx != 0) {
                    sb.append(",");
                }
                if (coords.length == 3) {
                    sb.append(coords[1][coordIdx] + "," + coords[0][coordIdx] + "," + 0.3048 * coords[2][coordIdx]);
                    continue;
                }
                sb.append(coords[1][coordIdx] + "," + coords[0][coordIdx]);
            }
        }
        sb.append("\" ");
        sb.append("/>");
    }
}

