/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.data.gis;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import ucar.unidata.data.gis.KmlDataSource;
import ucar.unidata.data.gis.KmlInfo;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.StringUtil;
import ucar.unidata.util.Trace;
import ucar.unidata.xml.XmlUtil;
import ucar.visad.GeoUtils;
import visad.Data;
import visad.Text;
import visad.VisADException;
import visad.georef.LatLonPoint;

public class KmlPoints
extends KmlInfo {
    public static final String TAG_NAME = "name";
    public static final String TAG_POINT = "Point";
    public static final String TAG_COORDINATES = "coordinates";
    List names = new ArrayList();
    List descriptions = new ArrayList();
    List coordinates = new ArrayList();

    public KmlPoints() {
    }

    public KmlPoints(List nodes, String displayCategory) {
        super(displayCategory, displayCategory, "locations");
        for (int i = 0; i < nodes.size(); ++i) {
            Element node = (Element)nodes.get(i);
            Element pointNode = XmlUtil.findChild(node, TAG_POINT);
            String name = XmlUtil.getChildText(XmlUtil.findChild(node, TAG_NAME));
            if (name == null) {
                name = "";
            }
            if (pointNode == null) {
                pointNode = XmlUtil.findChild(node, "LineString");
            }
            if (pointNode == null) {
                pointNode = XmlUtil.findDescendantFromPath(node, "Polygon.outerBoundaryIs.LinearRing");
            }
            if (pointNode == null) {
                pointNode = XmlUtil.findDescendant(node, TAG_POINT);
            }
            Object coords = null;
            if (pointNode == null) {
                Element addressNode = XmlUtil.findChild(node, "address");
                if (addressNode == null) {
                    System.err.println("Could not  find point node:" + XmlUtil.toString(node));
                    continue;
                }
                String address = XmlUtil.getChildText(addressNode);
                LogUtil.message("KML: Fetching address: " + address);
                LatLonPoint llp = GeoUtils.getLocationFromAddress(address, null);
                LogUtil.message("");
                if (llp == null) {
                    System.err.println("Could not  find address:" + address);
                    continue;
                }
                coords = new double[][]{{llp.getLongitude().getValue()}, {llp.getLatitude().getValue()}, {0.0}};
            }
            if (coords == null) {
                Element coordNode = XmlUtil.findChild(pointNode, TAG_COORDINATES);
                if (coordNode == null) continue;
                try {
                    coords = StringUtil.parseCoordinates(XmlUtil.getChildText(coordNode));
                }
                catch (Exception exc) {
                    System.err.println("Error parsing coordinates:" + exc);
                    System.err.println(XmlUtil.toString(node));
                    continue;
                }
            }
            this.descriptions.add(XmlUtil.getChildText(XmlUtil.findChild(node, "description")));
            this.names.add(name);
            this.coordinates.add(coords);
        }
    }

    @Override
    public Data getData(KmlDataSource dataSource, Object loadId) throws VisADException, RemoteException {
        Trace.call1("KmlPoints.getData", " #placemarks:" + this.names.size());
        StringBuffer sb = new StringBuffer("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n<stationtable name=\"" + this.getName() + "\">\n");
        int size = this.names.size();
        for (int i = 0; i < size; ++i) {
            double[][] coords = (double[][])this.coordinates.get(i);
            String desc = (String)this.descriptions.get(i);
            sb.append("<station ");
            this.attr(sb, TAG_NAME, (String)this.names.get(i));
            if (coords[0].length == 1) {
                this.attr(sb, "lon", "" + coords[0][0]);
                this.attr(sb, "lat", "" + coords[1][0]);
                if (coords.length > 2) {
                    this.attr(sb, "elev", "" + coords[2][0]);
                }
                sb.append(">");
            } else {
                sb.append(">");
                sb.append("<coordinates>");
                for (int coordIdx = 0; coordIdx < coords[0].length; ++coordIdx) {
                    sb.append(coords[0][coordIdx]);
                    sb.append(",");
                    sb.append(coords[1][coordIdx]);
                    if (coords.length > 2) {
                        sb.append(",");
                        sb.append(coords[2][coordIdx]);
                    }
                    sb.append(" ");
                }
                sb.append("</coordinates>");
            }
            if (desc != null) {
                sb.append("<![CDATA[");
                sb.append(desc);
                sb.append("]]>");
            }
            sb.append("</station>");
        }
        sb.append("</stationtable>");
        Trace.call2("KmlPoints.getData");
        return new Text(sb.toString());
    }

    private void attr(StringBuffer sb, String name, String value) {
        sb.append(name);
        sb.append("=");
        sb.append(XmlUtil.quote(XmlUtil.encodeString(value)));
        sb.append(" ");
    }

    public void setNames(List value) {
        this.names = value;
    }

    public List getNames() {
        return this.names;
    }

    public void setCoordinates(List value) {
        this.coordinates = value;
    }

    public List getCoordinates() {
        return this.coordinates;
    }
}

