/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.data.gis;

import java.awt.Image;
import java.rmi.RemoteException;
import org.w3c.dom.Element;
import ucar.unidata.data.gis.KmlDataSource;
import ucar.unidata.data.gis.KmlImageElement;
import ucar.unidata.geoloc.Bearing;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.xml.XmlUtil;
import visad.Data;
import visad.VisADException;

public class KmlPhotoOverlay
extends KmlImageElement {
    public static final String TAG_NEAR = "near";
    public static final String TAG_CAMERA = "Camera";
    public static final String TAG_LONGITUDE = "longitude";
    public static final String TAG_LATITUDE = "latitude";
    public static final String TAG_ALTITUDE = "altitude";
    public static final String TAG_HEADING = "heading";
    public static final String TAG_TILT = "tilt";
    public static final String TAG_ROLL = "roll";
    public static final String TAG_VIEWVOLUME = "ViewVolume";
    public static final String TAG_LEFTFOV = "leftFov";
    public static final String TAG_RIGHTFOV = "rightFov";
    public static final String TAG_BOTTOMFOV = "bottomFov";
    public static final String TAG_TOPFOV = "topFov";
    public static final String TAG_ROTATION = "rotation";
    private double rotation;
    private double longitude;
    private double latitude;
    private double altitude;
    private double tilt;
    private double roll;
    private double heading;
    private double near;
    private double leftFov;
    private double rightFov;
    private double bottomFov;
    private double topFov;

    public KmlPhotoOverlay() {
    }

    public KmlPhotoOverlay(Element node, String displayCategory, String baseUrl) {
        super(node, displayCategory, baseUrl);
        Element viewNode = XmlUtil.findChild(node, TAG_VIEWVOLUME);
        this.near = this.getValue(viewNode, TAG_NEAR);
        this.leftFov = this.getValue(viewNode, TAG_LEFTFOV);
        this.rightFov = this.getValue(viewNode, TAG_RIGHTFOV);
        this.bottomFov = this.getValue(viewNode, TAG_BOTTOMFOV);
        this.topFov = this.getValue(viewNode, TAG_TOPFOV);
        Element cameraNode = XmlUtil.findChild(node, TAG_CAMERA);
        this.longitude = this.getValue(cameraNode, TAG_LONGITUDE);
        this.latitude = this.getValue(cameraNode, TAG_LATITUDE);
        this.altitude = this.getValue(cameraNode, TAG_ALTITUDE);
        this.heading = this.getValue(cameraNode, TAG_HEADING);
        this.tilt = this.getValue(cameraNode, TAG_TILT);
        this.roll = this.getValue(cameraNode, TAG_ROLL);
    }

    private double getValue(Element node, String childTag) {
        Element child = XmlUtil.findChild(node, childTag);
        if (child != null) {
            return new Double(XmlUtil.getChildText(child));
        }
        return 0.0;
    }

    private double squared(double d) {
        return d * d;
    }

    @Override
    public Data getData(KmlDataSource dataSource, Object loadId) throws VisADException, RemoteException {
        System.err.println(this.latitude + " " + this.longitude + " " + this.near + " " + Math.cos(Math.toRadians(this.leftFov)));
        System.err.println("h=" + this.near / Math.cos(Math.toRadians(this.leftFov)));
        LatLonPointImpl llp2 = Bearing.findPoint(this.latitude, this.longitude, this.rotation, this.near / 1000.0, null);
        System.err.println("llp:" + llp2.getLatitude() + " " + llp2.getLongitude());
        double lat2 = this.latitude;
        double lon2 = this.longitude;
        double left = this.longitude + Math.sqrt(this.near * this.near * (1.0 / this.squared(Math.cos(Math.toRadians(this.leftFov))) - 1.0));
        double right = this.longitude - Math.sqrt(this.near * this.near * (1.0 / this.squared(Math.cos(Math.toRadians(this.rightFov))) - 1.0));
        double top = 0.0 + Math.sqrt(this.near * this.near * (1.0 / this.squared(Math.cos(Math.toRadians(this.topFov))) - 1.0));
        double bottom = 0.0 - Math.sqrt(this.near * this.near * (1.0 / this.squared(Math.cos(Math.toRadians(this.bottomFov))) - 1.0));
        System.err.println("b:" + left + " " + right + " " + top + " " + bottom);
        Image image = this.getImage(dataSource);
        if (image == null) {
            return null;
        }
        return null;
    }

    public void setRotation(double value) {
        this.rotation = value;
    }

    public double getRotation() {
        return this.rotation;
    }

    public void setLongitude(double value) {
        this.longitude = value;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public void setLatitude(double value) {
        this.latitude = value;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public void setAltitude(double value) {
        this.altitude = value;
    }

    public double getAltitude() {
        return this.altitude;
    }

    public void setTilt(double value) {
        this.tilt = value;
    }

    public double getTilt() {
        return this.tilt;
    }

    public void setRoll(double value) {
        this.roll = value;
    }

    public double getRoll() {
        return this.roll;
    }

    public void setHeading(double value) {
        this.heading = value;
    }

    public double getHeading() {
        return this.heading;
    }

    public void setNear(double value) {
        this.near = value;
    }

    public double getNear() {
        return this.near;
    }

    public void setLeftFov(double value) {
        this.leftFov = value;
    }

    public double getLeftFov() {
        return this.leftFov;
    }

    public void setRightFov(double value) {
        this.rightFov = value;
    }

    public double getRightFov() {
        return this.rightFov;
    }

    public void setBottomFov(double value) {
        this.bottomFov = value;
    }

    public double getBottomFov() {
        return this.bottomFov;
    }

    public void setTopFov(double value) {
        this.topFov = value;
    }

    public double getTopFov() {
        return this.topFov;
    }
}

