/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.data.gis;

import java.awt.Image;
import java.rmi.RemoteException;
import org.w3c.dom.Element;
import ucar.unidata.data.gis.KmlDataSource;
import ucar.unidata.data.gis.KmlInfo;
import ucar.unidata.xml.XmlUtil;
import visad.VisADException;

public abstract class KmlImageElement
extends KmlInfo {
    public static final String TAG_ICON = "Icon";
    public static final String TAG_NAME = "name";
    public static final String TAG_HREF = "href";
    private String baseUrl;
    private String name;
    private String href;

    public KmlImageElement() {
    }

    public KmlImageElement(Element node, String displayCategory, String baseUrl) {
        super(node, displayCategory, "RGBIMAGE");
        this.baseUrl = baseUrl;
        Element iconNode = XmlUtil.findChild(node, TAG_ICON);
        this.href = XmlUtil.getChildText(XmlUtil.findChild(iconNode, TAG_HREF));
    }

    public static String getHref(Element node) {
        Element iconNode = XmlUtil.findChild(node, TAG_ICON);
        return XmlUtil.getChildText(XmlUtil.findChild(iconNode, TAG_HREF));
    }

    public Image getImage(KmlDataSource dataSource) throws VisADException, RemoteException {
        return dataSource.readImage(this.getHref(), this.baseUrl);
    }

    public void setHref(String value) {
        this.href = value;
    }

    public String getHref() {
        return this.href;
    }

    public void setBaseUrl(String value) {
        this.baseUrl = value;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }
}

