/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.data.gis;

import java.awt.Image;
import java.rmi.RemoteException;
import org.w3c.dom.Element;
import ucar.unidata.data.gis.KmlDataSource;
import ucar.unidata.data.gis.KmlImageElement;
import ucar.unidata.data.grid.GridUtil;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Trace;
import ucar.unidata.xml.XmlUtil;
import ucar.visad.Util;
import visad.Data;
import visad.FieldImpl;
import visad.FlatField;
import visad.Linear2DSet;
import visad.MathType;
import visad.RealTupleType;
import visad.VisADException;

public class KmlGroundOverlay
extends KmlImageElement {
    public static final String TAG_VIEWBOUNDSCALE = "viewBoundScale";
    public static final String TAG_LATLONBOX = "LatLonBox";
    public static final String TAG_NORTH = "north";
    public static final String TAG_SOUTH = "south";
    public static final String TAG_EAST = "east";
    public static final String TAG_WEST = "west";
    public static final String TAG_ROTATION = "rotation";
    private double viewBoundScale = 1.0;
    private double rotation;
    private double north;
    private double south;
    private double east;
    private double west;

    public KmlGroundOverlay() {
    }

    public KmlGroundOverlay(Element node, String displayCategory, String baseUrl) {
        super(node, displayCategory, baseUrl);
        Element iconNode = XmlUtil.findChild(node, "Icon");
        Element tmpNode = XmlUtil.findChild(iconNode, TAG_VIEWBOUNDSCALE);
        if (tmpNode != null) {
            this.viewBoundScale = new Double(XmlUtil.getChildText(tmpNode));
        }
        Element latLonNode = XmlUtil.findChild(node, TAG_LATLONBOX);
        this.north = new Double(XmlUtil.getChildText(XmlUtil.findChild(latLonNode, TAG_NORTH)));
        this.south = new Double(XmlUtil.getChildText(XmlUtil.findChild(latLonNode, TAG_SOUTH)));
        this.east = new Double(XmlUtil.getChildText(XmlUtil.findChild(latLonNode, TAG_EAST)));
        this.west = new Double(XmlUtil.getChildText(XmlUtil.findChild(latLonNode, TAG_WEST)));
    }

    @Override
    public Data getData(KmlDataSource dataSource, Object loadId) throws VisADException, RemoteException {
        Image image = this.getImage(dataSource);
        if (image == null) {
            return null;
        }
        Trace.call1("makeField");
        try {
            FlatField xyData = Util.makeField(image, 127.0f);
            Trace.call2("makeField");
            Linear2DSet domain = (Linear2DSet)xyData.getDomainSet();
            Linear2DSet imageDomain = new Linear2DSet((MathType)RealTupleType.SpatialEarth2DTuple, this.getWest(), this.getEast(), domain.getX().getLength(), this.getNorth(), this.getSouth(), domain.getY().getLength());
            FieldImpl field = GridUtil.setSpatialDomain(xyData, imageDomain, true);
            return field;
        }
        catch (Exception iexc) {
            LogUtil.logException("Error making image data", iexc);
            return null;
        }
    }

    public void setViewBoundScale(double value) {
        this.viewBoundScale = value;
    }

    public double getViewBoundScale() {
        return this.viewBoundScale;
    }

    public void setRotation(double value) {
        this.rotation = value;
    }

    public double getRotation() {
        return this.rotation;
    }

    public void setNorth(double value) {
        this.north = value;
    }

    public double getNorth() {
        return this.north;
    }

    public void setSouth(double value) {
        this.south = value;
    }

    public double getSouth() {
        return this.south;
    }

    public void setEast(double value) {
        this.east = value;
    }

    public double getEast() {
        return this.east;
    }

    public void setWest(double value) {
        this.west = value;
    }

    public double getWest() {
        return this.west;
    }
}

