/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.data.gis;

import java.awt.Image;
import java.awt.Toolkit;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import ucar.unidata.data.BadDataException;
import ucar.unidata.data.CompositeDataChoice;
import ucar.unidata.data.DataCategory;
import ucar.unidata.data.DataChoice;
import ucar.unidata.data.DataSelection;
import ucar.unidata.data.DataSource;
import ucar.unidata.data.DataSourceDescriptor;
import ucar.unidata.data.DirectDataChoice;
import ucar.unidata.data.FilesDataSource;
import ucar.unidata.data.GeoLocationInfo;
import ucar.unidata.data.gis.KmlGroundOverlay;
import ucar.unidata.data.gis.KmlId;
import ucar.unidata.data.gis.KmlInfo;
import ucar.unidata.data.gis.KmlPhotoOverlay;
import ucar.unidata.data.gis.KmlPoints;
import ucar.unidata.data.gis.KmlPolygons;
import ucar.unidata.util.DatePattern;
import ucar.unidata.util.IOUtil;
import ucar.unidata.util.JobManager;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.PatternFileFilter;
import ucar.unidata.util.StringUtil;
import ucar.unidata.util.Trace;
import ucar.unidata.view.geoloc.CoordinateFormat;
import ucar.unidata.xml.XmlUtil;
import visad.Data;
import visad.DateTime;
import visad.Text;
import visad.VisADException;

public class KmlDataSource
extends FilesDataSource {
    private static final String PROP_HREF = "prop.href";
    private static final String PROP_BASEURL = "prop.baseurl";
    private static final String PROP_DISPLAYCATEGORIES = "prop.displaycategories";
    public static final PatternFileFilter FILTER_KML = new PatternFileFilter("(.+\\.kml|.+\\.kmz)", "Google Earth File (*.kml, *.kmz)", ".kmz");
    private static final String ID_NETWORKLINK = "KmlDataSource.networklink";
    private static final String ID_DUMMY = "KmlDataSource.dummy";
    public static final String EXT_KML = ".kml";
    public static final String SUFFIX_KML = ".kml";
    public static final String ATTR_PARENT = "parent";
    public static final String ATTR_NAME = "name";
    public static final String TAG_GROUNDOVERLAY = "GroundOverlay";
    public static final String TAG_PHOTOOVERLAY = "PhotoOverlay";
    public static final String TAG_URL = "Url";
    public static final String TAG_HREF = "href";
    public static final String TAG_LINK = "Link";
    public static final String TAG_LINESTRING = "LineString";
    public static final String TAG_SCHEMA = "Schema";
    public static final String TAG_NETWORKLINK = "NetworkLink";
    public static final String TAG_MULTIGEOMETRY = "MultiGeometry";
    public static final String TAG_DOCUMENT = "Document";
    public static final String TAG_FOLDER = "Folder";
    public static final String TAG_KML = "kml";
    public static final String TAG_PLACEMARK = "Placemark";
    public static final String TAG_NAME = "name";
    public static final String TAG_STYLEURL = "styleUrl";
    private Hashtable idToNode = new Hashtable();
    protected List cachedData = new ArrayList();
    protected List cachedUrls = new ArrayList();
    private boolean isZip;
    private String legacyKmlUrl;
    private Object loadId;
    private Element root;
    private Hashtable pathToFile = new Hashtable();
    private String topName = null;
    private Hashtable schemas;
    private DataSourceDescriptor descriptor = null;
    private static String DEFAULT_PATH = "https://www.weather.gov/source/crh/shapefiles/warnings.kml";

    public KmlDataSource() {
    }

    public KmlDataSource(DataSourceDescriptor descriptor, String kmlUrl, Hashtable properties) throws VisADException {
        super(descriptor, Misc.newList(kmlUrl), "KML data source", kmlUrl, properties);
        this.descriptor = descriptor;
        this.setName("KML: " + IOUtil.stripExtension(IOUtil.getFileTail(kmlUrl)));
        this.initKmlDataSource();
    }

    @Override
    public void reloadData() {
        this.root = null;
        super.reloadData();
        this.dataChoices = null;
        this.initKmlDataSource();
        this.getDataChoices();
    }

    @Override
    public void initAfterUnpersistence() {
        if (this.legacyKmlUrl != null) {
            this.sources = Misc.newList(this.legacyKmlUrl);
        }
        super.initAfterUnpersistence();
        this.initKmlDataSource();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Image readImage(String url, String baseUrl) {
        Image image = null;
        List list = this.cachedUrls;
        synchronized (list) {
            for (int i = 0; i < this.cachedUrls.size(); ++i) {
                if (!url.equals(this.cachedUrls.get(i))) continue;
                image = (Image)this.cachedData.get(i);
                break;
            }
        }
        if (image != null) {
            return image;
        }
        byte[] imageContent = null;
        try {
            imageContent = this.readBytes(url);
            if (imageContent == null && !url.startsWith("http")) {
                url = IOUtil.getFileRoot(baseUrl) + "/" + url;
                imageContent = this.readBytes(url);
            }
            if (imageContent == null) {
                return null;
            }
            Trace.call1("createImage");
            image = Toolkit.getDefaultToolkit().createImage(imageContent);
            Trace.call2("createImage");
            List i = this.cachedUrls;
            synchronized (i) {
                if (this.cachedUrls.size() > 5) {
                    this.cachedUrls.remove(this.cachedUrls.size() - 1);
                    this.cachedData.remove(this.cachedData.size() - 1);
                }
            }
            return image;
        }
        catch (Exception iexc) {
            LogUtil.logException("There was an error accessing the image with the url:\n" + url, iexc);
            return null;
        }
    }

    protected byte[] readBytes(String path) throws Exception {
        InputStream is = this.getInputStream(path);
        if (is == null) {
            return null;
        }
        byte[] bytes = IOUtil.readBytes(is, this.loadId);
        try {
            is.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bytes;
    }

    protected InputStream getInputStream(String path) throws Exception {
        if (new File(path).exists()) {
            return new FileInputStream(path);
        }
        try {
            URL url = new URL(path);
            URLConnection connection = url.openConnection();
            return connection.getInputStream();
        }
        catch (Exception url) {
            String kmlUrl = (String)this.pathToFile.get(path);
            if (kmlUrl == null) {
                kmlUrl = this.getFilePath();
            }
            if (kmlUrl == null) {
                return null;
            }
            if (kmlUrl.toLowerCase().endsWith(".kmz")) {
                BufferedInputStream bin = new BufferedInputStream(IOUtil.getInputStream(kmlUrl));
                ZipInputStream zin = new ZipInputStream(bin);
                ZipEntry ze = null;
                while ((ze = zin.getNextEntry()) != null) {
                    String name = ze.getName().toLowerCase();
                    if (name.equals(path) || name.equalsIgnoreCase(path)) {
                        return zin;
                    }
                    name = "./" + name;
                    if (!name.equals(path) && !name.equalsIgnoreCase(path)) continue;
                    return zin;
                }
                return null;
            }
            if (IOUtil.isRelativePath(path)) {
                path = IOUtil.getFileRoot(kmlUrl) + "/" + path;
            }
            return IOUtil.getInputStream(path);
        }
    }

    private void initKmlDataSource() {
        Trace.call1("KmlDataSource.initKml");
        this.initKmlDataSourceInner();
        Trace.call2("KmlDataSource.initKml");
    }

    private void initKmlDataSourceInner() {
        if (this.root != null) {
            return;
        }
        if (this.getFilePath() == null) {
            return;
        }
        try {
            this.root = this.getFilePath().length() == 0 && this.descriptor != null && this.descriptor.getId().equals("weather.warning") ? this.parseKml(DEFAULT_PATH) : this.parseKml(this.getFilePath());
            if (this.root == null) {
                this.setInError(true, "Could not find kml file");
            }
        }
        catch (Exception iexc) {
            LogUtil.logException("There was an error parsing the xml file:\n " + this.getFilePath(), iexc);
            this.setInError(true, false, "");
        }
    }

    private Element parseKml(String kmlUrl) throws Exception {
        if (kmlUrl == null) {
            return null;
        }
        Element root = null;
        InputStream is = IOUtil.getInputStream(kmlUrl);
        BufferedInputStream bin = new BufferedInputStream(is);
        ZipInputStream zin = null;
        try {
            Trace.call1("zin");
            zin = new ZipInputStream(bin);
            Trace.call2("zin");
        }
        catch (Exception exception) {
            // empty catch block
        }
        boolean anyEntries = false;
        if (zin != null && zin.available() > 0) {
            Trace.call1("getInputStream");
            Trace.call2("getInputStream");
            ZipEntry ze = null;
            while ((ze = zin.getNextEntry()) != null) {
                anyEntries = true;
                String name = ze.getName().toLowerCase();
                if (name.endsWith(".kml") && root == null) {
                    int idx;
                    this.isZip = true;
                    Trace.call1("readBytes");
                    String xml = new String(IOUtil.readBytes(zin, null, false));
                    if (!xml.startsWith("<") && (idx = xml.indexOf("<")) >= 0) {
                        xml = xml.substring(idx);
                    }
                    Trace.call2("readBytes", " size=" + xml.length());
                    String newName = IOUtil.getFileTail(name);
                    if (IOUtil.getFileRoot(name).length() == 1) {
                        newName = IOUtil.joinDir(this.getDataContext().getObjectStore().getUserTmpDirectory(), newName);
                    }
                    xml = this.cleanupXml(xml);
                    IOUtil.writeFile(newName, xml);
                    Trace.call1("KmlDataSource.getRoot");
                    root = XmlUtil.getRoot(xml);
                    Trace.call2("KmlDataSource.getRoot");
                    continue;
                }
                this.pathToFile.put(ze.getName(), kmlUrl);
                zin.closeEntry();
            }
            zin.close();
        }
        if (root == null && !anyEntries) {
            Trace.call1("KmlDataSource.readContents");
            String xml = IOUtil.readContents(kmlUrl);
            Trace.call2("KmlDataSource.readContents");
            xml = this.cleanupXml(xml);
            this.isZip = false;
            Trace.call1("KmlDataSource.getRoot");
            root = XmlUtil.getRoot(xml);
            Trace.call2("KmlDataSource.getRoot");
        }
        return root;
    }

    private String cleanupXml(String xml) {
        if (!(xml = xml.trim()).startsWith("<?xml")) {
            return "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n" + xml;
        }
        return xml;
    }

    private void addDataChoice(DataChoice newDataChoice, CompositeDataChoice parentDataChoice) {
        if (parentDataChoice != null) {
            parentDataChoice.addDataChoice(newDataChoice);
        } else {
            this.addDataChoice(newDataChoice);
        }
    }

    private void mergeChildren(CompositeDataChoice parent) {
        List children = parent.getDataChoices();
        if (parent.getId().equals(ID_NETWORKLINK) && children.size() == 1 && ((DataChoice)children.get(0)).getId().equals(ID_DUMMY)) {
            return;
        }
        for (int i = 0; i < children.size(); ++i) {
            DataChoice dc = (DataChoice)children.get(i);
            if (!(dc instanceof CompositeDataChoice)) continue;
            this.mergeChildren((CompositeDataChoice)dc);
        }
        children = parent.getDataChoices();
        CompositeDataChoice grandParent = (CompositeDataChoice)parent.getParent();
        if (children.size() == 0) {
            if (grandParent != null) {
                grandParent.removeDataChoice(parent);
            } else {
                this.removeDataChoice(parent);
            }
            return;
        }
        if (children.size() != 1) {
            return;
        }
        DataChoice child = (DataChoice)children.get(0);
        if (child.getName().equals("Placemarks") || child.getName().equals("Image")) {
            child.setName(parent.getName());
            child.setDescription(parent.getDescription());
        }
        if (grandParent != null) {
            grandParent.replaceDataChoice(parent, child);
        } else {
            this.replaceDataChoice(parent, child);
        }
    }

    @Override
    protected void doMakeDataChoices() {
        this.idToNode = new Hashtable();
        if (this.root == null) {
            this.initKmlDataSource();
        }
        if (this.root == null) {
            throw new IllegalStateException("No KML root element");
        }
        this.schemas = new Hashtable();
        this.processRootNode(this.root, null, this.getFilePath(), new ArrayList());
        Trace.call1("KmlDataSource.processing kml");
        Trace.call2("KmlDataSource.processing kml");
        List dataChoices = this.getDataChoices();
        for (int i = 0; i < dataChoices.size(); ++i) {
            DataChoice dc = (DataChoice)dataChoices.get(i);
            if (!(dc instanceof CompositeDataChoice)) continue;
            this.mergeChildren((CompositeDataChoice)dc);
        }
    }

    private void processRootNode(Element root, CompositeDataChoice parent, String filepath, List categories) {
        NodeList children = XmlUtil.getElements(root);
        for (int i = 0; i < children.getLength(); ++i) {
            Element child = (Element)children.item(i);
            if (this.topName == null) {
                this.topName = XmlUtil.getChildText(XmlUtil.findChild(child, "name"));
                if (this.topName != null) {
                    this.setName("KML: " + this.topName);
                }
            }
            this.processNode(parent, child, categories, filepath);
        }
    }

    @Override
    public void expandIfNeeded(CompositeDataChoice parent) {
        super.expandIfNeeded(parent);
        List childrenChoices = parent.getDataChoices();
        if (!parent.getId().equals(ID_NETWORKLINK) || childrenChoices.size() != 1 || !((DataChoice)childrenChoices.get(0)).getId().equals(ID_DUMMY)) {
            return;
        }
        parent.removeAllDataChoices();
        String href = (String)parent.getProperty(PROP_HREF);
        String baseUrl = (String)parent.getProperty(PROP_BASEURL);
        List currentDisplayCategories = (List)parent.getProperty(PROP_DISPLAYCATEGORIES);
        if (!href.startsWith("http")) {
            href = IOUtil.getFileRoot(baseUrl) + "/" + href;
        }
        try {
            KmlDataSource.incrOutstandingGetDataCalls();
            LogUtil.message("Fetching Network Link:" + href);
            Element networkRoot = this.parseKml(href);
            if (networkRoot == null) {
                throw new IllegalStateException("Error fetching network link file:" + href);
            }
            currentDisplayCategories.add(parent.getName());
            this.processRootNode(networkRoot, parent, href, currentDisplayCategories);
            List newChildren = parent.getDataChoices();
            for (int i = 0; i < newChildren.size(); ++i) {
                DataChoice dc = (DataChoice)newChildren.get(i);
                if (!(dc instanceof CompositeDataChoice)) continue;
                this.mergeChildren((CompositeDataChoice)dc);
            }
            LogUtil.message("");
        }
        catch (Exception exc) {
            parent.setName("Error: " + parent.getName());
            LogUtil.logException("There was an error parsing the network link file:\n " + href, exc);
        }
        KmlDataSource.decrOutstandingGetDataCalls();
    }

    private void processNode(CompositeDataChoice parentDataChoice, Element node, List displayCategories, String baseUrl) {
        String tagName = node.getTagName();
        if (tagName.equals(TAG_SCHEMA)) {
            String name = XmlUtil.getAttribute((Node)node, "name", (String)null);
            String parent = XmlUtil.getAttribute((Node)node, ATTR_PARENT, (String)null);
            if (name != null && parent != null) {
                this.schemas.put(name, parent);
            }
            return;
        }
        String tmp = (String)this.schemas.get(tagName);
        if (tmp != null) {
            tagName = tmp;
        }
        ArrayList<String> currentDisplayCategories = new ArrayList<String>(displayCategories);
        if (tagName.equals(TAG_NETWORKLINK)) {
            Element urlNode = XmlUtil.findChild(node, TAG_URL);
            if (urlNode == null) {
                urlNode = XmlUtil.findChild(node, TAG_LINK);
            }
            if (urlNode == null) {
                throw new IllegalStateException("No Url or Link node found");
            }
            Element hrefNode = XmlUtil.findChild(urlNode, TAG_HREF);
            String name = XmlUtil.getChildText(XmlUtil.findChild(node, "name"));
            String href = XmlUtil.getChildText(hrefNode);
            Hashtable props = Misc.newHashtable(PROP_DISPLAYCATEGORIES, new ArrayList(currentDisplayCategories), PROP_HREF, href, PROP_BASEURL, baseUrl);
            if (name == null) {
                name = "Network Link";
            }
            CompositeDataChoice newParentDataChoice = new CompositeDataChoice((DataSource)this, (Object)ID_NETWORKLINK, "Network Link:" + href, name, Misc.newList(DataCategory.NONE_CATEGORY), props);
            newParentDataChoice.addDataChoice(new DirectDataChoice(this, (Object)ID_DUMMY, "", "", new ArrayList()));
            this.addDataChoice(newParentDataChoice, parentDataChoice);
        } else if (tagName.equals(TAG_DOCUMENT) || tagName.equals(TAG_FOLDER) || tagName.equals(TAG_KML)) {
            Object dts;
            ArrayList<Element> pointNodes = null;
            String folderName = XmlUtil.getChildText(XmlUtil.findChild(node, "name"));
            if (folderName == null) {
                folderName = TAG_FOLDER;
            }
            CompositeDataChoice newParentDataChoice = new CompositeDataChoice(this, (Object)"All Warning", folderName, folderName, Misc.newList(DataCategory.XGRF_CATEGORY));
            newParentDataChoice.setProperty("KMLWARNING", folderName);
            this.addDataChoice(newParentDataChoice, parentDataChoice);
            if (folderName != null) {
                currentDisplayCategories.add(folderName);
            }
            NodeList children = XmlUtil.getElements(node);
            for (int i = 0; i < children.getLength(); ++i) {
                DatePattern dp;
                Element child = (Element)children.item(i);
                String childTagName = child.getTagName();
                String dateTimePattern = "yyyy/MM/dd hh:nn:ss";
                dts = null;
                String descrip = XmlUtil.getChildText(XmlUtil.findChild(node, "description"));
                if (descrip != null && (dp = new DatePattern(dateTimePattern)).match(descrip)) {
                    dts = dp.getDateTime();
                }
                if ((tmp = (String)this.schemas.get(childTagName)) != null) {
                    childTagName = tmp;
                }
                if (childTagName.equals(TAG_PLACEMARK)) {
                    Element multiGeometryNode = XmlUtil.findChild(child, TAG_MULTIGEOMETRY);
                    Element linestringNode = XmlUtil.findChild(child, TAG_LINESTRING);
                    if (multiGeometryNode != null || linestringNode != null) {
                        String name = XmlUtil.getChildText(XmlUtil.findChild(child, "name"));
                        String displayCategory = StringUtil.join("-", currentDisplayCategories);
                        if (name != null) {
                            displayCategory = displayCategory.length() > 0 ? displayCategory + "-" + name : name;
                        } else {
                            name = "Shapes";
                        }
                        KmlId id = new KmlId("Shapes", name, displayCategory, baseUrl);
                        this.idToNode.put(id, child);
                        List xcategories = DataCategory.parseCategories(displayCategory + ";" + "xgrf", true);
                        List categories = Misc.newList(DataCategory.XGRF_CATEGORY);
                        Hashtable<String, Object> properties = new Hashtable<String, Object>();
                        if (dts != null) {
                            properties.put("timeObj", dts);
                        }
                        newParentDataChoice.addDataChoice(new DirectDataChoice((DataSource)this, (Object)id, name, name, categories, properties));
                        continue;
                    }
                    if (pointNodes == null) {
                        pointNodes = new ArrayList<Element>();
                    }
                    pointNodes.add(child);
                    continue;
                }
                this.processNode(newParentDataChoice, child, currentDisplayCategories, baseUrl);
            }
            if (pointNodes != null) {
                for (Element n : pointNodes) {
                    String name = XmlUtil.getGrandChildText(n, "name");
                    Element ptnode = XmlUtil.findChild(n, "Point");
                    if (ptnode == null) continue;
                    dts = XmlUtil.getGrandChildText(ptnode, "coordinates");
                }
                String dataChoiceName = "Placemarks";
                String displayCategory = StringUtil.join("-", currentDisplayCategories);
                KmlId id = new KmlId("Placemarks", dataChoiceName, displayCategory, baseUrl);
                this.idToNode.put(id, pointNodes);
                List categories = DataCategory.parseCategories(displayCategory, true);
                categories = Misc.newList(DataCategory.LOCATIONS_CATEGORY);
                Hashtable props = Misc.newHashtable("prop.icon", "/auxdata/ui/icons/Placemark16.gif");
                newParentDataChoice.addDataChoice(new DirectDataChoice((DataSource)this, (Object)id, dataChoiceName, dataChoiceName, categories, props));
            }
        } else if (tagName.equals(TAG_GROUNDOVERLAY) || tagName.equals(TAG_PHOTOOVERLAY)) {
            String name = XmlUtil.getChildText(XmlUtil.findChild(node, "name"));
            if (name == null) {
                name = "Image";
            }
            String displayCategory = StringUtil.join("-", currentDisplayCategories);
            String href = KmlGroundOverlay.getHref(node);
            KmlId id = new KmlId(tagName.equals(TAG_GROUNDOVERLAY) ? TAG_GROUNDOVERLAY : TAG_PHOTOOVERLAY, name, displayCategory, baseUrl, href);
            int ucnt = 0;
            while (this.idToNode.get(id) != null) {
                id.setExtra("id" + ucnt++);
            }
            this.idToNode.put(id, node);
            List categories = DataCategory.parseCategories(displayCategory, true);
            categories.add(new DataCategory("RGBIMAGE", false));
            Hashtable props = Misc.newHashtable("prop.icon", "/auxdata/ui/icons/Earth16.gif");
            this.addDataChoice(new DirectDataChoice((DataSource)this, (Object)id, name, name, categories, props), parentDataChoice);
        } else if (tagName.equals(TAG_PLACEMARK)) {
            Element multiGeometryNode = XmlUtil.findChild(node, TAG_MULTIGEOMETRY);
            if (multiGeometryNode != null) {
                String displayCategory = StringUtil.join("-", currentDisplayCategories);
                NodeList children = XmlUtil.getElements(node);
                String type = XmlUtil.getChildText(XmlUtil.findChild(node, TAG_STYLEURL));
                String color = "";
                if (type.equals("#TO")) {
                    color = "255,0,0";
                } else if (type.equals("#SV")) {
                    color = "255,255,0";
                } else if (type.equals("#FF")) {
                    color = "0,255,0";
                }
                this.addDataChoice(new KmlPolygons(node, displayCategory, color));
                for (int i = 0; i < children.getLength(); ++i) {
                    Element child = (Element)children.item(i);
                    String name = XmlUtil.getChildText(XmlUtil.findChild(child, "name"));
                    System.out.println("\t\tText: " + name);
                    if (name != null) {
                        displayCategory = displayCategory.length() > 0 ? displayCategory + "-" + name : name;
                    }
                    type = XmlUtil.getChildText(XmlUtil.findChild(child, TAG_STYLEURL));
                    color = "";
                    if (type.equals("#TO")) {
                        color = "255,0,0";
                    } else if (type.equals("#SV")) {
                        color = "255,255,0";
                    } else if (type.equals("#FF")) {
                        color = "0,255,0";
                    }
                    this.addDataChoice(new KmlPolygons(child, displayCategory, color));
                }
            } else {
                System.err.println("MultiGeometry must include Polygon");
            }
        }
    }

    @Override
    protected Data getDataInner(DataChoice dataChoice, DataCategory category, DataSelection dataSelection, Hashtable requestProperties) throws VisADException, RemoteException {
        this.loadId = JobManager.getManager().stopAndRestart(this.loadId, "KMLControl");
        if (requestProperties == null) {
            requestProperties = new Hashtable();
        }
        Object tmp = dataChoice.getId();
        DateTime dt = null;
        Hashtable dcproperties = dataChoice.getProperties();
        dt = (DateTime)dcproperties.get("timeObj");
        KmlInfo kmlInfo = null;
        if (tmp instanceof KmlInfo) {
            kmlInfo = (KmlInfo)tmp;
        } else {
            if (dataChoice instanceof CompositeDataChoice && tmp instanceof String && ((String)tmp).contains("All Warning")) {
                CompositeDataChoice cdc = (CompositeDataChoice)dataChoice;
                List ddcs = cdc.getDataChoices();
                ArrayList<Data> pdata = new ArrayList<Data>();
                for (int i = 0; i < ddcs.size(); ++i) {
                    DataChoice dc = (DataChoice)ddcs.get(i);
                    pdata.add(this.getDataInner(dc, category, dataSelection, requestProperties));
                }
                StringBuffer sb = new StringBuffer("<shapes>\n");
                for (int j = 0; j < pdata.size(); ++j) {
                    Text vt = (Text)pdata.get(j);
                    String ttt = vt.toString();
                    ttt = ttt.replace("<shapes>\n", "");
                    ttt = ttt.replace("</shapes>", "");
                    sb = sb.append(ttt);
                }
                sb.append("</shapes>");
                return new Text(sb.toString());
            }
            KmlId id = (KmlId)tmp;
            Object node = this.idToNode.get(id);
            if (node == null) {
                throw new BadDataException("Could not find kml data " + id);
            }
            if (id.isPlacemarks()) {
                kmlInfo = new KmlPoints((List)node, "");
            } else if (id.isGroundOverlay()) {
                kmlInfo = new KmlGroundOverlay((Element)node, "", id.getDocUrl());
            } else if (id.isPhotoOverlay()) {
                kmlInfo = new KmlPhotoOverlay((Element)node, "", id.getDocUrl());
            } else if (id.isShapes()) {
                String type = XmlUtil.getChildText(XmlUtil.findChild((Element)node, TAG_STYLEURL));
                String color = "";
                if (type.equals("#TO")) {
                    color = "255,0,0";
                } else if (type.equals("#SV")) {
                    color = "255,255,0";
                } else if (type.equals("#FF")) {
                    color = "0,255,0";
                }
                kmlInfo = dt != null ? new KmlPolygons((Element)node, "", color, dt) : new KmlPolygons((Element)node, "", color);
            } else {
                throw new BadDataException("Unknown KML node type " + id.getType());
            }
        }
        return kmlInfo.getData(this, this.loadId);
    }

    @Override
    protected boolean shouldCache(Data data) {
        return false;
    }

    @Override
    protected List doMakeDateTimes() {
        return new ArrayList();
    }

    public void setKmlUrl(String value) {
        this.legacyKmlUrl = value;
    }

    public static boolean isKmlFile(String filename) {
        return filename.endsWith(".kml") || filename.endsWith(".kmz");
    }

    public static void writeToFile(String kmlFilename, GeoLocationInfo bounds, String imageFileName) throws FileNotFoundException, IOException {
        if (kmlFilename.endsWith(".kmz")) {
            String tail = IOUtil.stripExtension(IOUtil.getFileTail(kmlFilename));
            ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(kmlFilename));
            zos.putNextEntry(new ZipEntry(tail + ".kml"));
            String kml = KmlDataSource.createKml(bounds, IOUtil.getFileTail(imageFileName));
            byte[] kmlBytes = kml.getBytes();
            zos.write(kmlBytes, 0, kmlBytes.length);
            byte[] imageBytes = IOUtil.readBytes(new FileInputStream(imageFileName));
            zos.putNextEntry(new ZipEntry(IOUtil.getFileTail(imageFileName)));
            zos.write(imageBytes, 0, imageBytes.length);
            zos.close();
        } else {
            String kml = KmlDataSource.createKml(bounds, imageFileName);
            IOUtil.writeFile(kmlFilename, kml);
        }
    }

    public static String createKml(GeoLocationInfo bounds, String imageFileName) throws FileNotFoundException, IOException {
        StringBuffer sb = new StringBuffer();
        String name = IOUtil.getFileTail(IOUtil.stripExtension(imageFileName));
        String imageName = IOUtil.getFileTail(IOUtil.stripExtension(imageFileName));
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        sb.append("<kml xmlns=\"http://earth.google.com/kml/2.0\">\n");
        sb.append("<GroundOverlay>\n");
        sb.append("<name>" + name + "</name>\n");
        sb.append("<Icon>\n");
        sb.append("<href>" + imageFileName + "</href>\n");
        sb.append("</Icon>");
        KmlDataSource.createLatLonBox(bounds, sb);
        sb.append("</GroundOverlay>\n</kml>\n");
        return sb.toString();
    }

    public static void createLatLonBox(GeoLocationInfo bounds, StringBuffer sb) {
        sb.append("<LatLonBox>\n");
        sb.append("<north>" + bounds.getMaxLat() + "</north>\n");
        sb.append("<south>" + bounds.getMinLat() + "</south>\n");
        sb.append("<east>" + CoordinateFormat.formatLongitude(bounds.getMaxLon(), "DD.dddddd", false) + "</east>\n");
        sb.append("<west>" + CoordinateFormat.formatLongitude(bounds.getMinLon(), "DD.dddddd", false) + "</west>\n");
        sb.append("</LatLonBox>\n");
    }

    public static void main(String[] args) {
        Hashtable<String, String> sts = new Hashtable<String, String>();
        sts.put("AK", "Alaska");
        sts.put("AL", "Alabama");
        sts.put("AR", "Arkansas");
        sts.put("AZ", "Arizona");
        sts.put("CA", "California");
        sts.put("CO", "Colorado");
        sts.put("DE", "Delaware");
        sts.put("FL", "Florida");
        sts.put("GA", "Georgia");
        sts.put("GU", "Guam");
        sts.put("HI", "Hawaii");
        sts.put("IA", "Idaho");
        sts.put("ID", "Indiana");
        sts.put("IL", "Illinois");
        sts.put("IN", "Indiana");
        sts.put("KS", "Kansas");
        sts.put("KY", "Kentucky");
        sts.put("LA", "Louisiana");
        sts.put("MA", "Massachusetts");
        sts.put("MD", "Maryland");
        sts.put("ME", "Maine");
        sts.put("MI", "Michigan");
        sts.put("MN", "Minnesota");
        sts.put("MO", "Missouri");
        sts.put("MS", "Misisspippi");
        sts.put("MT", "Montana");
        sts.put("NC", "North Carolina");
        sts.put("ND", "North Dakota");
        sts.put("NE", "Nebraska");
        sts.put("NJ", "New Jersey");
        sts.put("NM", "New Mexico");
        sts.put("NV", "Nevada");
        sts.put("NY", "New York");
        sts.put("OH", "Ohio");
        sts.put("OK", "Oklahoma");
        sts.put("OR", "Oregon");
        sts.put("PA", "Pennsylvania");
        sts.put("PR", "Puerto Rico");
        sts.put("SC", "South Carolina");
        sts.put("SD", "South Dakota");
        sts.put("TN", "Tennessee");
        sts.put("TX", "Texas");
        sts.put("UT", "Utah");
        sts.put("VA", "Virginia");
        sts.put("VT", "Vermont");
        sts.put("WA", "Washington");
        sts.put("WI", "Wisconsin");
        sts.put("WV", "West Virginia");
        sts.put("WY", "Wyoming");
        try {
            int i;
            StringBuffer sb = new StringBuffer();
            sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            sb.append("<kml xmlns=\"http://earth.google.com/kml/2.0\">\n");
            sb.append(XmlUtil.tag("name", "", "Nexrad Stations"));
            sb.append(XmlUtil.tag("description", "", "Nexrad Stations"));
            sb.append("<Document>\n");
            sb.append("<LookAt>\n");
            sb.append("<longitude>-100.0</longitude>\n");
            sb.append("<latitude>40</latitude>\n");
            sb.append("<range>5000000</range>\n");
            sb.append("<tilt>0</tilt>\n");
            sb.append("<heading>0</heading>\n");
            sb.append("</LookAt>\n");
            sb.append(XmlUtil.tag("visibility", "", "0"));
            sb.append(XmlUtil.tag("visible", "", "0"));
            sb.append("<Style id=\"radarLocation\">\n");
            sb.append("<IconStyle>\n");
            sb.append("<Icon>\n");
            sb.append(XmlUtil.tag(TAG_HREF, "", "http://www.unidata.ucar.edu/software/idv/logo.gif"));
            sb.append("</Icon>\n");
            sb.append("</IconStyle>\n");
            sb.append("</Style>\n");
            sb.append("<ScreenOverlay>  <name>Unidata Nexrad Radar</name>  <Icon>   <href>http://www.unidata.ucar.edu/img/unidata_logo.gif</href>  </Icon>  <overlayXY x=\"0\" y=\"1\" xunits=\"fraction\" yunits=\"fraction\"/>  <screenXY x=\"0\" y=\"1\" xunits=\"fraction\" yunits=\"fraction\"/>  <size x=\"0\" y=\"0\" xunits=\"fraction\" yunits=\"fraction\"/></ScreenOverlay>");
            Element root = XmlUtil.getRoot("nexradstns.xml", KmlDataSource.class);
            NodeList elements = XmlUtil.getElements(root);
            double h = 4.237409999999997;
            double w = 5.361629999999991;
            double h2 = h / 2.0;
            double w2 = w / 2.0;
            Hashtable<String, StringBuffer> stateMap = new Hashtable<String, StringBuffer>();
            ArrayList<String> states = new ArrayList<String>();
            String alt = "800000";
            int year = 1900;
            for (i = 0; i < elements.getLength(); ++i) {
                Element child = (Element)elements.item(i);
                String st = XmlUtil.encodeString(XmlUtil.getAttribute(child, "st"));
                StringBuffer buff = (StringBuffer)stateMap.get(st);
                if (buff == null) {
                    buff = new StringBuffer("<Folder>\n");
                    String name = (String)sts.get(st);
                    buff.append(XmlUtil.tag("name", "", name));
                    stateMap.put(st, buff);
                    states.add(st);
                }
                String id = XmlUtil.getAttribute(child, "id");
                String name = XmlUtil.encodeString(XmlUtil.getAttribute(child, "name"));
                double lat = XmlUtil.getAttribute((Node)child, "lat", 0.0);
                double lon = XmlUtil.getAttribute((Node)child, "lon", 0.0);
                String desc = "<![CDATA[<a href=\"http://www.unidata.ucar.edu/software/idv/radar.jnlp\">View in the IDV</a>]]>";
                StringBuffer lookAt = new StringBuffer();
                lookAt.append("<LookAt>\n");
                lookAt.append(XmlUtil.tag("longitude", "", "" + lon));
                lookAt.append(XmlUtil.tag("latitude", "", "" + lat));
                lookAt.append(XmlUtil.tag("range", "", alt));
                lookAt.append(XmlUtil.tag("tilt", "", "0"));
                lookAt.append(XmlUtil.tag("heading", "", "0"));
                lookAt.append("</LookAt>\n");
                buff.append("<Folder>\n");
                buff.append(lookAt);
                buff.append(XmlUtil.tag("visibility", "", "0"));
                buff.append(XmlUtil.tag("visible", "", "0"));
                buff.append(XmlUtil.tag("name", "", XmlUtil.encodeString(name)));
                buff.append("<GroundOverlay>\n");
                buff.append(XmlUtil.tag("visibility", "", "0"));
                buff.append(XmlUtil.tag("visible", "", "0"));
                buff.append(lookAt);
                buff.append(XmlUtil.tag("description", "", desc));
                buff.append(XmlUtil.tag("name", "", "Image"));
                buff.append("<Icon>\n");
                buff.append(XmlUtil.tag(TAG_HREF, "", "http://motherlode.ucar.edu/cgi-bin/ldm/radargif?" + id));
                buff.append("</Icon>\n");
                buff.append("<LatLonBox id=\"latlonbox\">\n");
                buff.append("<north>" + (lat + h2) + "</north>\n");
                buff.append("<south>" + (lat - h2) + "</south>\n");
                buff.append("<east>" + (lon + w2) + "</east>\n");
                buff.append("<west>" + (lon - w2) + "</west>\n");
                buff.append("<rotation>0</rotation>\n");
                buff.append("</LatLonBox>\n");
                buff.append("</GroundOverlay>\n");
                buff.append("<Placemark>\n");
                buff.append(XmlUtil.tag("name", "", name));
                buff.append(lookAt);
                buff.append(XmlUtil.tag(TAG_STYLEURL, "", "#radarLocation"));
                buff.append(XmlUtil.tag("visibility", "", "0"));
                buff.append(XmlUtil.tag("visible", "", "0"));
                buff.append(XmlUtil.tag("description", "", desc));
                buff.append("<Point>\n");
                buff.append(XmlUtil.tag("coordinates", "", "" + lon + "," + (lat + h2) + "," + alt));
                buff.append("</Point>\n");
                buff.append("</Placemark>\n");
                buff.append("</Folder>\n");
            }
            for (i = 0; i < states.size(); ++i) {
                StringBuffer b = (StringBuffer)stateMap.get(states.get(i));
                b.append("</Folder>\n");
                sb.append(b);
            }
            sb.append("</Document>\n");
            sb.append("</kml>\n");
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        System.exit(0);
    }
}

