/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.data.gis;

import java.awt.Image;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import ucar.unidata.data.CompositeDataChoice;
import ucar.unidata.data.DataCategory;
import ucar.unidata.data.DataChoice;
import ucar.unidata.data.DataSelection;
import ucar.unidata.data.DataSource;
import ucar.unidata.data.DataSourceDescriptor;
import ucar.unidata.data.DirectDataChoice;
import ucar.unidata.data.FilesDataSource;
import ucar.unidata.data.GeoLocationInfo;
import ucar.unidata.data.gis.KmlId;
import ucar.unidata.data.gis.KmlInfo;
import ucar.unidata.util.DatePattern;
import ucar.unidata.util.IOUtil;
import ucar.unidata.util.JobManager;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.PatternFileFilter;
import ucar.unidata.util.StringUtil;
import ucar.unidata.util.Trace;
import ucar.unidata.view.geoloc.CoordinateFormat;
import ucar.unidata.xml.XmlResourceCollection;
import ucar.unidata.xml.XmlUtil;
import visad.Data;
import visad.DateTime;
import visad.Text;
import visad.VisADException;

public class JsonDataSource
extends FilesDataSource {
    public static final PatternFileFilter FILTER_KML = new PatternFileFilter("(.+\\.json)", "Geo JSON File (*.json)", ".json");
    public static final String EXT_KML = ".json";
    public static final String SUFFIX_KML = ".json";
    public static final String ATTR_PARENT = "parent";
    public static final String ATTR_NAME = "name";
    public static final String TAG_GROUNDOVERLAY = "GroundOverlay";
    public static final String TAG_PHOTOOVERLAY = "PhotoOverlay";
    public static final String TAG_URL = "Url";
    public static final String TAG_HREF = "href";
    public static final String TAG_LINK = "Link";
    public static final String TAG_LINESTRING = "LineString";
    public static final String TAG_SCHEMA = "Schema";
    public static final String TAG_NETWORKLINK = "NetworkLink";
    public static final String TAG_MULTIGEOMETRY = "MultiGeometry";
    public static final String TAG_DOCUMENT = "Document";
    public static final String TAG_FOLDER = "Folder";
    public static final String TAG_KML = "json";
    public static final String TAG_PLACEMARK = "Placemark";
    public static final String TAG_NAME = "name";
    public static final String TAG_STYLEURL = "styleUrl";
    private static final String PROP_HREF = "prop.href";
    private static final String PROP_BASEURL = "prop.baseurl";
    private static final String PROP_DISPLAYCATEGORIES = "prop.displaycategories";
    private static final String ID_NETWORKLINK = "JsonDataSource.networklink";
    private static final String ID_DUMMY = "JsonDataSource.dummy";
    protected List cachedData = new ArrayList();
    protected List cachedUrls = new ArrayList();
    protected HashMap jsonInfo = new HashMap();
    protected List colorMap;
    protected List timeList = new ArrayList();
    private Hashtable idToNode = new Hashtable();
    private String legacyKmlUrl;
    private Object loadId;
    private Element root;
    private Hashtable pathToFile = new Hashtable();
    private String topName = null;
    private Hashtable schemas;
    private DataSourceDescriptor descriptor = null;

    public JsonDataSource() {
    }

    public JsonDataSource(DataSourceDescriptor descriptor, List newSources, Hashtable properties) {
        super(descriptor, newSources, "JSON data source", properties);
        String name = "ddd";
        int idx = name.indexOf("?");
        if (idx >= 0) {
            name = name.substring(0, idx);
            this.setName(name);
        }
        if (this.getName().length() == 0 && newSources.size() > 0) {
            String s = newSources.get(0).toString();
            idx = s.indexOf("?");
            if (idx >= 0) {
                s = s.substring(0, idx);
            }
            this.setName(s);
        }
        this.sources = newSources;
        this.descriptor = descriptor;
        this.initPolygonColorMap();
        this.initGeoJsonDataSource();
    }

    public JsonDataSource(DataSourceDescriptor descriptor, String kmlUrl, Hashtable properties) throws VisADException, Exception {
        super(descriptor, Misc.newList(kmlUrl), "JSON data source", properties);
        this.sources = Misc.newList(kmlUrl);
        this.descriptor = descriptor;
        this.setName("PROBSEVERE: " + IOUtil.stripExtension(IOUtil.getFileTail(kmlUrl)));
        this.initPolygonColorMap();
        this.initGeoJsonDataSource();
    }

    public static void writeToFile(String kmlFilename, GeoLocationInfo bounds, String imageFileName) throws FileNotFoundException, IOException {
        if (kmlFilename.endsWith(".kmz")) {
            String tail = IOUtil.stripExtension(IOUtil.getFileTail(kmlFilename));
            ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(kmlFilename));
            zos.putNextEntry(new ZipEntry(tail + ".kml"));
            String kml = JsonDataSource.createKml(bounds, IOUtil.getFileTail(imageFileName));
            byte[] kmlBytes = kml.getBytes();
            zos.write(kmlBytes, 0, kmlBytes.length);
            byte[] imageBytes = IOUtil.readBytes(new FileInputStream(imageFileName));
            zos.putNextEntry(new ZipEntry(IOUtil.getFileTail(imageFileName)));
            zos.write(imageBytes, 0, imageBytes.length);
            zos.close();
        } else {
            String kml = JsonDataSource.createKml(bounds, imageFileName);
            IOUtil.writeFile(kmlFilename, kml);
        }
    }

    public static String createKml(GeoLocationInfo bounds, String imageFileName) throws FileNotFoundException, IOException {
        StringBuffer sb = new StringBuffer();
        String name = IOUtil.getFileTail(IOUtil.stripExtension(imageFileName));
        String imageName = IOUtil.getFileTail(IOUtil.stripExtension(imageFileName));
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        sb.append("<kml xmlns=\"http://earth.google.com/kml/2.0\">\n");
        sb.append("<GroundOverlay>\n");
        sb.append("<name>" + name + "</name>\n");
        sb.append("<Icon>\n");
        sb.append("<href>" + imageFileName + "</href>\n");
        sb.append("</Icon>");
        JsonDataSource.createLatLonBox(bounds, sb);
        sb.append("</GroundOverlay>\n</kml>\n");
        return sb.toString();
    }

    public static void createLatLonBox(GeoLocationInfo bounds, StringBuffer sb) {
        sb.append("<LatLonBox>\n");
        sb.append("<north>" + bounds.getMaxLat() + "</north>\n");
        sb.append("<south>" + bounds.getMinLat() + "</south>\n");
        sb.append("<east>" + CoordinateFormat.formatLongitude(bounds.getMaxLon(), "DD.dddddd", false) + "</east>\n");
        sb.append("<west>" + CoordinateFormat.formatLongitude(bounds.getMinLon(), "DD.dddddd", false) + "</west>\n");
        sb.append("</LatLonBox>\n");
    }

    public static void main(String[] args) {
        Hashtable sts = new Hashtable();
        System.exit(0);
    }

    protected void initPolygonColorMap() {
        if (this.colorMap == null) {
            List colors = new ArrayList();
            List resources = Misc.newList("/ucar/unidata/idv/resources/probsevere_cmap.xml");
            XmlResourceCollection colorMapResources = new XmlResourceCollection("", resources);
            Element root = colorMapResources.getRoot(0);
            this.colorMap = colors = this.processXml(root);
        }
    }

    public List processXml(Element root) {
        ArrayList<float[]> colors = new ArrayList<float[]>();
        List colorNodes = XmlUtil.findChildren(root, "color");
        for (int i = 0; i < colorNodes.size(); ++i) {
            Element serverNode = (Element)colorNodes.get(i);
            String aval = XmlUtil.getAttribute(serverNode, "a");
            String bval = XmlUtil.getAttribute(serverNode, "b");
            String gval = XmlUtil.getAttribute(serverNode, "g");
            String rval = XmlUtil.getAttribute(serverNode, "r");
            float[] values = new float[]{Float.parseFloat(aval), Float.parseFloat(bval), Float.parseFloat(gval), Float.parseFloat(rval)};
            colors.add(values);
        }
        return colors;
    }

    protected Document readColorMapXml(String href) throws Exception {
        String xml = IOUtil.readContents(href, this.getClass());
        if (xml == null) {
            return null;
        }
        return XmlUtil.getDocument(xml);
    }

    @Override
    public void reloadData() {
        this.root = null;
        super.reloadData();
        this.dataChoices = null;
        this.initGeoJsonDataSource();
        this.getDataChoices();
    }

    @Override
    public void initAfterUnpersistence() {
        if (this.legacyKmlUrl != null) {
            this.sources = Misc.newList(this.legacyKmlUrl);
        }
        super.initAfterUnpersistence();
        this.initPolygonColorMap();
        this.initGeoJsonDataSource();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Image readImage(String url, String baseUrl) {
        Image image = null;
        List list = this.cachedUrls;
        synchronized (list) {
            for (int i = 0; i < this.cachedUrls.size(); ++i) {
                if (!url.equals(this.cachedUrls.get(i))) continue;
                image = (Image)this.cachedData.get(i);
                break;
            }
        }
        if (image != null) {
            return image;
        }
        byte[] imageContent = null;
        try {
            imageContent = this.readBytes(url);
            if (imageContent == null && !url.startsWith("http")) {
                url = IOUtil.getFileRoot(baseUrl) + "/" + url;
                imageContent = this.readBytes(url);
            }
            if (imageContent == null) {
                return null;
            }
            Trace.call1("createImage");
            image = Toolkit.getDefaultToolkit().createImage(imageContent);
            Trace.call2("createImage");
            List i = this.cachedUrls;
            synchronized (i) {
                if (this.cachedUrls.size() > 5) {
                    this.cachedUrls.remove(this.cachedUrls.size() - 1);
                    this.cachedData.remove(this.cachedData.size() - 1);
                }
            }
            return image;
        }
        catch (Exception iexc) {
            LogUtil.logException("There was an error accessing the image with the url:\n" + url, iexc);
            return null;
        }
    }

    protected byte[] readBytes(String path) throws Exception {
        InputStream is = this.getInputStream(path);
        if (is == null) {
            return null;
        }
        byte[] bytes = IOUtil.readBytes(is, this.loadId);
        try {
            is.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bytes;
    }

    protected InputStream getInputStream(String path) throws Exception {
        if (new File(path).exists()) {
            return new FileInputStream(path);
        }
        try {
            URL url = new URL(path);
            URLConnection connection = url.openConnection();
            return connection.getInputStream();
        }
        catch (Exception url) {
            String kmlUrl = (String)this.pathToFile.get(path);
            if (kmlUrl == null) {
                kmlUrl = this.getFilePath();
            }
            if (kmlUrl == null) {
                return null;
            }
            if (IOUtil.isRelativePath(path)) {
                path = IOUtil.getFileRoot(kmlUrl) + "/" + path;
            }
            return IOUtil.getInputStream(path);
        }
    }

    private void initGeoJsonDataSource() {
        Trace.call1("JsonDataSource.initJson");
        this.initGeoJsonDataSourceInner();
        Trace.call2("JsonDataSource.initJson");
    }

    private void initGeoJsonDataSourceInner() {
        if (this.root != null) {
            return;
        }
        if (this.getFilePath() == null) {
            return;
        }
        try {
            int size = this.sources.size();
            for (int i = 0; i < size; ++i) {
                String fPath = (String)this.sources.get(i);
                this.parseJSON(fPath);
            }
            this.timeList = Misc.sort(this.timeList);
        }
        catch (Exception iexc) {
            LogUtil.logException("There was an error parsing the xml file:\n " + this.getFilePath(), iexc);
            this.setInError(true, false, "");
        }
    }

    private void parseJSON(String jsonUrl) throws Exception {
        JSONParser jsonParser = new JSONParser();
        try (FileReader reader = new FileReader(jsonUrl);){
            Object obj = jsonParser.parse((Reader)reader);
            JSONObject feature = (JSONObject)obj;
            JSONArray features = (JSONArray)feature.get((Object)"features");
            String dateTimePattern = "yyyyMMdd_hhnnss UTC";
            DateTime dts = null;
            String descrip = (String)feature.get((Object)"validTime");
            if (descrip != null) {
                DatePattern dp = new DatePattern(dateTimePattern);
                if (dp.match(descrip)) {
                    dts = dp.getDateTime();
                }
                if (dts != null) {
                    this.timeList.add(dts);
                    this.jsonInfo.put("timeObj", dts);
                }
            }
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.newDocument();
            Element kmlTag = document.createElement("kml");
            kmlTag.setAttribute("xmlns", "http://www.opengis.net/kml/2.2");
            document.appendChild(kmlTag);
            Element documentTag = document.createElement(TAG_DOCUMENT);
            kmlTag.appendChild(documentTag);
            Element styleTag = document.createElement("Style");
            styleTag.setAttribute("id", "style1");
            documentTag.appendChild(styleTag);
            Element polyStyleTag = document.createElement("PolyStyle");
            styleTag.appendChild(polyStyleTag);
            Element fillTag = document.createElement("fill");
            fillTag.appendChild(document.createTextNode("0"));
            polyStyleTag.appendChild(fillTag);
            Element outlineTag = document.createElement("outline");
            outlineTag.appendChild(document.createTextNode("1"));
            polyStyleTag.appendChild(outlineTag);
            HashMap<String, String> ploygoncoords = new HashMap<String, String>();
            for (Object feat : features) {
                Element placeMark = document.createElement(TAG_PLACEMARK);
                documentTag.appendChild(placeMark);
                Element styleURLTag = document.createElement(TAG_STYLEURL);
                styleURLTag.appendChild(document.createTextNode("#style1"));
                placeMark.appendChild(styleURLTag);
                JSONObject featJ = (JSONObject)feat;
                JSONObject featJSON = (JSONObject)featJ.get((Object)"properties");
                String name = (String)featJSON.get((Object)"ID");
                JSONObject coordJSON = (JSONObject)featJ.get((Object)"geometry");
                String type = (String)coordJSON.get((Object)"type");
                JSONArray coords = (JSONArray)coordJSON.get((Object)"coordinates");
                JSONObject modelsJSON = (JSONObject)featJ.get((Object)"models");
                JSONObject probsevereJSON = (JSONObject)modelsJSON.get((Object)"probsevere");
                String prob = (String)probsevereJSON.get((Object)"PROB");
                if (type.equals("Polygon") || type.equals("MultiPolygon")) {
                    ploygoncoords.put(name, this.getCoordinates(coords, prob));
                    continue;
                }
                throw new Error("Type mal forme !");
            }
            if (dts != null) {
                this.jsonInfo.put(dts, ploygoncoords);
            } else {
                this.jsonInfo.put("polygon", ploygoncoords);
            }
        }
        catch (IOException | ParserConfigurationException | ParseException e) {
            e.printStackTrace();
        }
    }

    private String getCoordinates(JSONArray coords, String prob) {
        String outStr = coords.toJSONString();
        float probability = Float.parseFloat(prob);
        int idx = (int)(256.0 * ((double)probability / 100.0)) - 1;
        String colorStr = "255,0,0";
        if (this.colorMap != null && idx > 0) {
            float[] values = (float[])this.colorMap.get(idx);
            int blue = (int)(values[1] * 255.0f);
            int green = (int)(values[2] * 255.0f);
            int red = (int)(values[3] * 255.0f);
            colorStr = red + "," + green + "," + blue;
        }
        outStr = outStr.replaceAll("\\[", "");
        outStr = outStr.replaceAll("\\]", "");
        outStr = "<polygon smooth=\"false\" filled=\"false\" coordtype=\"LONLAT\" points=\"" + outStr + "\"" + " color=" + "\"" + colorStr + "\"" + "/>";
        return outStr;
    }

    private String cleanupXml(String xml) {
        if (!(xml = xml.trim()).startsWith("<?xml")) {
            return "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n" + xml;
        }
        return xml;
    }

    private void addDataChoice(DataChoice newDataChoice, CompositeDataChoice parentDataChoice) {
        if (parentDataChoice != null) {
            parentDataChoice.addDataChoice(newDataChoice);
        } else {
            this.addDataChoice(newDataChoice);
        }
    }

    @Override
    public List getAllDateTimes(DataChoice dataChoice) {
        if (dataChoice instanceof CompositeDataChoice) {
            return this.timeList;
        }
        Object dttmObject = this.getDateTime(dataChoice);
        if (dttmObject != null) {
            return Misc.newList(dttmObject);
        }
        return new ArrayList();
    }

    @Override
    public List getAllDateTimes() {
        return Misc.sort(this.timeList);
    }

    private Object getDateTime(DataChoice dataChoice) {
        DataSelection dataSelection = dataChoice.getDataSelection();
        List timeList = dataSelection.getTimes();
        return timeList.get(0);
    }

    private void mergeChildren(CompositeDataChoice parent) {
        List children = parent.getDataChoices();
        if (parent.getId().equals(ID_NETWORKLINK) && children.size() == 1 && ((DataChoice)children.get(0)).getId().equals(ID_DUMMY)) {
            return;
        }
        for (int i = 0; i < children.size(); ++i) {
            DataChoice dc = (DataChoice)children.get(i);
            if (!(dc instanceof CompositeDataChoice)) continue;
            this.mergeChildren((CompositeDataChoice)dc);
        }
        children = parent.getDataChoices();
        CompositeDataChoice grandParent = (CompositeDataChoice)parent.getParent();
        if (children.size() == 0) {
            if (grandParent != null) {
                grandParent.removeDataChoice(parent);
            } else {
                this.removeDataChoice(parent);
            }
            return;
        }
        if (children.size() != 1) {
            return;
        }
        DataChoice child = (DataChoice)children.get(0);
        if (child.getName().equals("Placemarks") || child.getName().equals("Image")) {
            child.setName(parent.getName());
            child.setDescription(parent.getDescription());
        }
        if (grandParent != null) {
            grandParent.replaceDataChoice(parent, child);
        } else {
            this.replaceDataChoice(parent, child);
        }
    }

    @Override
    protected void doMakeDataChoices() {
        this.idToNode = new Hashtable();
        this.schemas = new Hashtable();
        if (this.timeList.size() >= 1) {
            this.processNode(null, null, new ArrayList(), null);
        }
        Trace.call1("JsonDataSource.processing kml");
        List dataChoices = this.getDataChoices();
        for (int i = 0; i < dataChoices.size(); ++i) {
            DataChoice dc = (DataChoice)dataChoices.get(i);
            DataSelection dataSelection = dc.getDataSelection();
            if (dataSelection == null) {
                dataSelection = new DataSelection();
            }
            if (!(dc instanceof CompositeDataChoice)) continue;
        }
    }

    private void processRootNode1(Element root, CompositeDataChoice parent, String filepath, List categories) {
        NodeList children = XmlUtil.getElements(root);
        for (int i = 0; i < children.getLength(); ++i) {
            Element child = (Element)children.item(i);
            if (this.topName != null) continue;
            this.topName = XmlUtil.getChildText(XmlUtil.findChild(child, "name"));
            if (this.topName == null) continue;
            this.setName("KML: " + this.topName);
        }
    }

    @Override
    public void expandIfNeeded(CompositeDataChoice parent) {
        super.expandIfNeeded(parent);
        List childrenChoices = parent.getDataChoices();
        if (!parent.getId().equals(ID_NETWORKLINK) || childrenChoices.size() != 1 || !((DataChoice)childrenChoices.get(0)).getId().equals(ID_DUMMY)) {
            return;
        }
        parent.removeAllDataChoices();
        String href = (String)parent.getProperty(PROP_HREF);
        String baseUrl = (String)parent.getProperty(PROP_BASEURL);
        List currentDisplayCategories = (List)parent.getProperty(PROP_DISPLAYCATEGORIES);
        if (!href.startsWith("http")) {
            href = IOUtil.getFileRoot(baseUrl) + "/" + href;
        }
        try {
            JsonDataSource.incrOutstandingGetDataCalls();
            LogUtil.message("Fetching Network Link:" + href);
            Element networkRoot = null;
            if (networkRoot == null) {
                throw new IllegalStateException("Error fetching network link file:" + href);
            }
            currentDisplayCategories.add(parent.getName());
            this.processRootNode1(networkRoot, parent, href, currentDisplayCategories);
            List newChildren = parent.getDataChoices();
            for (int i = 0; i < newChildren.size(); ++i) {
                DataChoice dc = (DataChoice)newChildren.get(i);
                if (!(dc instanceof CompositeDataChoice)) continue;
                this.mergeChildren((CompositeDataChoice)dc);
            }
            LogUtil.message("");
        }
        catch (Exception exc) {
            parent.setName("Error: " + parent.getName());
            LogUtil.logException("There was an error parsing the network link file:\n " + href, exc);
        }
        JsonDataSource.decrOutstandingGetDataCalls();
    }

    private void processNode(CompositeDataChoice parentDataChoice, HashMap polygonHMap1, List displayCategories, DateTime dts1) {
        String tagName = "polygon";
        String tmp = (String)this.schemas.get(tagName);
        if (tmp != null) {
            tagName = tmp;
        }
        ArrayList currentDisplayCategories = new ArrayList(displayCategories);
        CompositeDataChoice newParentDataChoice = new CompositeDataChoice(this, (Object)"All Warning", "Probsevere", "Probsevere", Misc.newList(DataCategory.XGRF_CATEGORY));
        newParentDataChoice.setProperty("JsonWARNING", "folderName");
        newParentDataChoice.setUseDataSourceToFindTimes(true);
        this.addDataChoice(newParentDataChoice, parentDataChoice);
        List categories = Misc.newList(DataCategory.XGRF_CATEGORY);
        for (int i = 0; i < this.timeList.size(); ++i) {
            DateTime dt = (DateTime)this.timeList.get(i);
            HashMap plyCoords = (HashMap)this.jsonInfo.get(dt);
            Set keys = plyCoords.keySet();
            for (Object k : keys) {
                String name = (String)k;
                Hashtable<String, Object> newProperties = new Hashtable<String, Object>();
                String coordStr = (String)plyCoords.get(k);
                newProperties.put("coordStr", coordStr);
                newProperties.put("timeObj", dt);
                String displayCategory = StringUtil.join("-", currentDisplayCategories);
                if (name != null) {
                    displayCategory = displayCategory.length() > 0 ? displayCategory + "-" + name : name;
                } else {
                    name = "Shapes";
                }
                KmlId id = new KmlId("Shapes", name, displayCategory, dt.dateString());
                DirectDataChoice dc = new DirectDataChoice((DataSource)this, (Object)id, name, name, categories, newProperties);
                DataSelection dataSelection = dc.getDataSelection();
                if (dataSelection == null) {
                    dataSelection = new DataSelection();
                }
                dataSelection.setTimes(Misc.newList(dt));
                dc.setDataSelection(dataSelection);
                newParentDataChoice.addDataChoice(dc);
            }
        }
    }

    @Override
    protected Data getDataInner(DataChoice dataChoice, DataCategory category, DataSelection dataSelection, Hashtable requestProperties) throws VisADException, RemoteException {
        this.loadId = JobManager.getManager().stopAndRestart(this.loadId, "KMLControl");
        if (requestProperties == null) {
            requestProperties = new Hashtable();
        }
        Object tmp = dataChoice.getId();
        KmlInfo kmlInfo = null;
        if (!(tmp instanceof KmlInfo)) {
            if (dataChoice instanceof CompositeDataChoice && tmp instanceof String && ((String)tmp).contains("All Warning")) {
                CompositeDataChoice cdc = (CompositeDataChoice)dataChoice;
                List ddcs = cdc.getDataChoices();
                ArrayList<Data> pdata = new ArrayList<Data>();
                for (int i = 0; i < ddcs.size(); ++i) {
                    DataChoice dc = (DataChoice)ddcs.get(i);
                    pdata.add(this.getDataInner(dc, category, dataSelection, requestProperties));
                }
                StringBuffer sb = new StringBuffer("<shapes>\n");
                for (int j = 0; j < pdata.size(); ++j) {
                    Text vt = (Text)pdata.get(j);
                    if (vt == null) continue;
                    String ttt = vt.toString();
                    ttt = ttt.replace("<shapes>\n", "");
                    ttt = ttt.replace("</shapes>", "");
                    sb = sb.append(ttt);
                }
                sb.append("</shapes>");
                return new Text(sb.toString());
            }
            KmlId id = (KmlId)tmp;
            Hashtable dcproperties = dataChoice.getProperties();
            DateTime dt = (DateTime)dcproperties.get("timeObj");
            List subTimeList = this.getJsonTimes(dataSelection);
            HashMap polygonInfo = (HashMap)this.jsonInfo.get(dt);
            DateTime polygonTime = dt;
            if (subTimeList.contains(dt)) {
                String timeStr = null;
                if (polygonTime != null) {
                    timeStr = polygonTime.toString();
                    polygonInfo.put("time", timeStr);
                }
                String coordsStr = (String)dcproperties.get("coordStr");
                StringBuffer sb = new StringBuffer("<shapes>\n");
                sb = sb.append(coordsStr);
                int idx = sb.indexOf("polygon");
                sb.insert(idx + 8, "times=\"" + timeStr + "\" ");
                sb.append("</shapes>");
                return new Text(sb.toString());
            }
            return null;
        }
        kmlInfo = (KmlInfo)tmp;
        return null;
    }

    private List getJsonTimes(DataSelection dataSelection) {
        List timeSL = dataSelection.getTimes();
        ArrayList subTimeList = new ArrayList();
        if (timeSL != null && this.timeList != null) {
            for (int i = 0; i < timeSL.size(); ++i) {
                int ii = (Integer)timeSL.get(i);
                subTimeList.add(this.timeList.get(ii));
            }
            return subTimeList;
        }
        return this.timeList;
    }

    @Override
    protected boolean shouldCache(Data data) {
        return false;
    }

    @Override
    protected List doMakeDateTimes() {
        return this.timeList;
    }
}

