/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.data.gis;

import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.swing.JTextField;
import ucar.unidata.data.DataCategory;
import ucar.unidata.data.DataChoice;
import ucar.unidata.data.DataSelection;
import ucar.unidata.data.DataSource;
import ucar.unidata.data.DataSourceDescriptor;
import ucar.unidata.data.DirectDataChoice;
import ucar.unidata.data.FilesDataSource;
import ucar.unidata.data.gis.GeotiffAdapter;
import ucar.unidata.data.grid.GridUtil;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.IOUtil;
import ucar.unidata.util.Misc;
import ucar.visad.Util;
import visad.Data;
import visad.FieldImpl;
import visad.RealType;
import visad.Unit;
import visad.VisADException;

public class GeotiffDataSource
extends FilesDataSource {
    private GeotiffAdapter adapter;
    private String paramName = "";
    private String unit = "";
    private JTextField nameFld;
    private JTextField unitFld;

    public GeotiffDataSource() {
    }

    public GeotiffDataSource(DataSourceDescriptor descriptor, String filename, Hashtable properties) throws VisADException {
        super(descriptor, filename, "Tiff data source", properties);
        this.openData();
    }

    @Override
    public boolean canSaveDataToLocalDisk() {
        return !this.isFileBased();
    }

    @Override
    public void initAfterUnpersistence() {
        if (this.sources == null) {
            this.sources = Misc.newList(this.getName());
        }
        super.initAfterUnpersistence();
        this.openData();
    }

    @Override
    public boolean applyProperties() {
        this.paramName = this.nameFld.getText().trim();
        this.unit = this.unitFld.getText().trim();
        return super.applyProperties();
    }

    @Override
    public void getPropertiesComponents(List comps) {
        super.getPropertiesComponents(comps);
        this.nameFld = new JTextField(this.paramName, 20);
        this.unitFld = new JTextField(this.unit, 10);
        comps.add(GuiUtils.filler());
        comps.add(this.getPropertiesHeader("Parameter"));
        comps.add(GuiUtils.rLabel("Name:"));
        comps.add(GuiUtils.left(this.nameFld));
        comps.add(GuiUtils.rLabel("Unit:"));
        comps.add(GuiUtils.left(this.unitFld));
    }

    private void openData() {
        try {
            if (this.adapter == null) {
                this.adapter = new GeotiffAdapter(this.getSource());
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
            this.setInError(true, "Failed to open " + this.getSource() + " " + exc.getMessage());
        }
    }

    @Override
    protected void doMakeDataChoices() {
        String description = this.getSource();
        String desc = IOUtil.getFileTail(this.getSource());
        this.openData();
        if (this.adapter == null) {
            return;
        }
        try {
            if (this.adapter.getHasProjection()) {
                List categories = DataCategory.parseCategories("RGBIMAGE", false);
                this.addDataChoice(new DirectDataChoice((DataSource)this, (Object)new Object[]{"image"}, desc + " -  3 Color RGB", desc + " -  3 Color RGB", categories, DataChoice.NULL_PROPERTIES));
                categories = DataCategory.parseCategories("IMAGE-2D;GRID-2D", false);
                String name = this.paramName;
                if (name == null || name.length() == 0) {
                    name = desc + " -  Grid data";
                }
                this.addDataChoice(new DirectDataChoice((DataSource)this, (Object)new Object[]{"grid"}, name, desc + " -  Grid data", categories, DataChoice.NULL_PROPERTIES));
            } else {
                List categories = DataCategory.parseCategories("TIFFIMAGE;" + desc, false);
                this.addDataChoice(new DirectDataChoice((DataSource)this, (Object)"Image", desc, desc, categories, DataChoice.NULL_PROPERTIES));
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
            this.setInError(true, "Failed to make data choices " + this.getSource() + " " + exc.getMessage());
        }
    }

    @Override
    public String getFullDescription() {
        String desc = super.getFullDescription();
        if (this.adapter != null) {
            desc = desc + "<p><b>Keys:</b> <pre>" + this.adapter.getKeyString() + "</pre>";
        }
        return desc;
    }

    @Override
    protected Data getDataInner(DataChoice dataChoice, DataCategory category, DataSelection dataSelection, Hashtable requestProperties) throws VisADException, RemoteException {
        try {
            this.openData();
            if (this.adapter == null) {
                return null;
            }
            Object id = dataChoice.getId();
            if (id instanceof String) {
                return this.adapter.getData();
            }
            Object[] idArray = (Object[])id;
            if (idArray[0].equals("grid")) {
                FieldImpl field = this.adapter.getDataAsGrid();
                if (this.unit != null && this.unit.length() > 0) {
                    Unit newunit = Util.parseUnit(this.unit);
                    RealType newType = Util.makeRealType(this.paramName, newunit);
                    field = GridUtil.setParamType(field, newType);
                }
                return field;
            }
            return this.adapter.getDataAsRgb();
        }
        catch (IOException ioe) {
            throw new VisADException("Failed to get tiff data:" + ioe);
        }
    }

    @Override
    protected List doMakeDateTimes() {
        return new ArrayList();
    }

    public void setParamName(String value) {
        this.paramName = value;
    }

    public String getParamName() {
        return this.paramName;
    }

    public void setUnit(String value) {
        this.unit = value;
    }

    public String getUnit() {
        return this.unit;
    }
}

