/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.data.gis;

import com.sun.media.jai.codec.ImageCodec;
import com.sun.media.jai.codec.ImageDecoder;
import com.sun.media.jai.codec.SeekableStream;
import com.sun.media.jai.codec.TIFFDirectory;
import com.sun.media.jai.codec.TIFFField;
import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import ucar.unidata.data.grid.GridUtil;
import ucar.unidata.geoloc.projection.TransverseMercator;
import ucar.unidata.gis.epsg.CoordinateOperationMethod;
import ucar.unidata.gis.epsg.CoordinateOperationParameter;
import ucar.unidata.gis.epsg.Pcs;
import ucar.unidata.gis.geotiff.GeneratedKeys;
import ucar.unidata.gis.geotiff.GeoKeys;
import ucar.unidata.util.Misc;
import visad.CoordinateSystem;
import visad.FlatField;
import visad.Linear1DSet;
import visad.Linear2DSet;
import visad.MathType;
import visad.RealTupleType;
import visad.SetType;
import visad.VisADException;
import visad.data.Form;
import visad.data.tiff.LegacyTiffForm;
import visad.data.tiff.TiffForm;
import visad.georef.MapProjection;
import visad.jmet.GRIBCoordinateSystem;

public class GeotiffAdapter {
    private static final int NOVALUE = -1;
    private static final String PROJ_TRANSVERSEMERCATOR = "transverse mercator";
    private static final int USER_DEFINED = Short.MAX_VALUE;
    private static final CoordinateOperationParameter COM = null;
    private int angularUnits = 9102;
    private String filename;
    private TIFFDirectory dir;
    private TIFFField dirField;
    private TIFFField tiePointField;
    private TIFFField scaleField;
    private boolean isGeotiff = false;
    private int cols;
    private int rows;
    private Hashtable paramCodeMap = new Hashtable();
    private Hashtable keys = new Hashtable();
    private static final double FT_TO_METERS = 0.3048;

    public GeotiffAdapter(String filename) throws IOException {
        this.filename = filename;
        this.dir = this.getDirectory();
        this.init();
    }

    public FlatField getData() throws VisADException, IOException {
        return this.getDataAsRgb();
    }

    public FlatField getDataAsRgb() throws VisADException, IOException {
        return this.createData(true);
    }

    public FlatField getDataAsGrid() throws VisADException, IOException {
        return this.createData(false);
    }

    public boolean getIsGeotiff() {
        return this.isGeotiff;
    }

    public boolean getHasProjection() throws VisADException, IOException {
        return this.getMapProjection() != null;
    }

    private FlatField createData(boolean asRGB) throws VisADException, IOException {
        Form form = asRGB ? new LegacyTiffForm() : new TiffForm();
        FlatField field = (FlatField)form.open(this.filename);
        Linear2DSet domain = (Linear2DSet)field.getDomainSet();
        this.cols = domain.getX().getLength();
        this.rows = domain.getY().getLength();
        MapProjection projection = this.getMapProjection();
        if (projection != null) {
            RealTupleType rtt = new RealTupleType(((SetType)domain.getType()).getDomain().getRealComponents(), (CoordinateSystem)projection, null);
            Linear2DSet newDomain = new Linear2DSet((MathType)rtt, new Linear1DSet[]{domain.getX(), domain.getY()}, null, null, null, false);
            field = (FlatField)GridUtil.setSpatialDomain(field, newDomain);
        }
        return field;
    }

    private TIFFDirectory getDirectory() throws IOException {
        if (this.dir == null) {
            ImageDecoder imageDecoder = ImageCodec.createImageDecoder((String)"tiff", (File)new File(this.filename), null);
            SeekableStream stream = imageDecoder.getInputStream();
            this.dir = new TIFFDirectory(stream, 0);
        }
        return this.dir;
    }

    private double toDegrees(double v) {
        switch (this.angularUnits) {
            case 9102: {
                return v;
            }
        }
        return v;
    }

    private void init() throws IOException {
        this.tiePointField = this.dir.getField(33922);
        this.scaleField = this.dir.getField(33550);
        this.dirField = this.dir.getField(34735);
        if (this.dirField == null) {
            this.isGeotiff = false;
            return;
        }
        this.isGeotiff = true;
        for (int tagIdx = 4; tagIdx < this.dirField.getCount(); tagIdx += 4) {
            double[] value;
            int geoKeyId = (int)this.dirField.getAsLong(tagIdx);
            long location = this.dirField.getAsLong(tagIdx + 1);
            int count = (int)this.dirField.getAsLong(tagIdx + 2);
            int offset = (int)this.dirField.getAsLong(tagIdx + 3);
            String keyName = GeneratedKeys.Geokey.getName(geoKeyId);
            if (location == 0L) {
                value = new double[]{offset};
            } else {
                TIFFField subField = this.dir.getField((int)location);
                if (subField == null || subField.getType() == 2) continue;
                if (subField.getType() == 4) {
                    value = this.toDouble(subField.getAsLongs());
                } else if (subField.getType() == 12) {
                    value = subField.getAsDoubles();
                } else {
                    if (subField.getType() != 11) continue;
                    value = this.toDouble(subField.getAsFloats());
                }
                double[] subset = new double[count];
                for (int i = 0; i < subset.length; ++i) {
                    subset[i] = value[i + offset];
                }
                value = subset;
            }
            this.processKey(geoKeyId, value);
        }
    }

    private String toString(double[] a) {
        if (a.length == 1) {
            return "" + a[0];
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < a.length; ++i) {
            buf.append("[");
            buf.append(i);
            buf.append("]: ");
            buf.append(a[i]);
            buf.append(" ");
        }
        return buf.toString();
    }

    private double[] toDouble(long[] from) {
        double[] to = new double[from.length];
        for (int i = 0; i < from.length; ++i) {
            to[i] = from[i];
        }
        return to;
    }

    private double[] toDouble(float[] from) {
        double[] to = new double[from.length];
        for (int i = 0; i < from.length; ++i) {
            to[i] = from[i];
        }
        return to;
    }

    private int getGeoKey(int key, int dflt) {
        double[] v = (double[])this.keys.get(new Integer(key));
        if (v == null) {
            return dflt;
        }
        return (int)v[0];
    }

    private double[] getGeoKey(int key, double[] dflt) {
        double[] v = (double[])this.keys.get(new Integer(key));
        if (v == null) {
            return dflt;
        }
        return v;
    }

    private int getModelType() {
        return this.getGeoKey(1024, 1);
    }

    private int getProjectedCSType() {
        return this.getGeoKey(3072, -1);
    }

    private void processKey(int geoKeyId, double[] value) {
        this.keys.put(new Integer(geoKeyId), value);
    }

    private MapProjection getMapProjection() throws VisADException, IOException {
        MapProjection projection = null;
        if (!this.isGeotiff) {
            return null;
        }
        switch (this.getModelType()) {
            case 1: {
                break;
            }
            case 2: {
                projection = this.getGeographicMapProjection();
                break;
            }
        }
        return projection;
    }

    private MapProjection getProjectedMapProjection() {
        if (this.tiePointField == null) {
            throw new IllegalStateException("No tie point field found");
        }
        if (this.scaleField == null) {
            throw new IllegalStateException("No scale field found");
        }
        int projectedCSType = this.getProjectedCSType();
        if (projectedCSType == -1) {
            System.err.println("No CS type given in keys");
            this.printKeys();
            return null;
        }
        this.printKeys();
        Pcs pcs = Pcs.findCoordRefSysCode(projectedCSType);
        if (pcs == null) {
            if (projectedCSType == Short.MAX_VALUE) {
                return this.createUserDefined();
            }
            System.err.println("Unable to find projected CS type = " + projectedCSType);
            return null;
        }
        this.initParamCodeMap(pcs);
        CoordinateOperationMethod com = pcs.findCoordinateOperationMethod();
        if (com == null) {
            System.err.println("Unable to find coordinate operation method = " + pcs.getCoordOpMethodCode());
            return null;
        }
        System.err.println("com:" + com);
        if (com.getCoordOpMethodName().toLowerCase().equals(PROJ_TRANSVERSEMERCATOR)) {
            return this.createFromTransverseMercator(pcs);
        }
        return null;
    }

    private MapProjection createUserDefined() {
        return null;
    }

    private MapProjection createProjectionFromBox(double[][] points) {
        return null;
    }

    private void initParamCodeMap(Pcs pcs) {
        int num = 1;
        while (true) {
            try {
                int code = pcs.findIntByName("parameterCode" + num);
                int uom = pcs.findIntByName("parameterUom" + num);
                double value = pcs.findDoubleByName("parameterValue" + num);
                this.paramCodeMap.put(new Integer(code), new double[]{value, uom});
            }
            catch (Exception exc) {
                break;
            }
            ++num;
        }
    }

    private boolean hasParamCode(int code) {
        double[] valueAndUom = (double[])this.paramCodeMap.get(new Integer(code));
        return valueAndUom != null;
    }

    private double getParamCodeValue(int code, double dflt) {
        double[] valueAndUom = (double[])this.paramCodeMap.get(new Integer(code));
        if (valueAndUom != null) {
            return valueAndUom[0];
        }
        return dflt;
    }

    private double ftToM(double v) {
        return 0.3048 * v;
    }

    private double ftToKm(double v) {
        return this.ftToM(v) / 1000.0;
    }

    private MapProjection createFromTransverseMercator(Pcs pcs) {
        int i;
        double lat0 = 40.0;
        double tangentLon = -80.0;
        double scale = this.scaleField.getAsDouble(0);
        if (!this.hasParamCode(8801)) {
            throw new IllegalStateException("No LATITUDE_OF_NATURAL_ORIGIN found in geotiff");
        }
        if (!this.hasParamCode(8802)) {
            throw new IllegalStateException("No LONGITUDE_OF_NATURAL_ORIGIN found in geotiff");
        }
        double natLat = this.getParamCodeValue(8801, 0.0);
        double natLon = this.getParamCodeValue(8802, 0.0);
        double naturalOriginScale = this.getParamCodeValue(8805, 1.0);
        double falseNorthing = this.getParamCodeValue(8807, 0.0);
        double falseEasting = this.getParamCodeValue(8806, 0.0);
        int indexX = (int)this.tiePointField.getAsDouble(0);
        int indexY = (int)this.tiePointField.getAsDouble(1);
        double scaleX = this.scaleField.getAsDouble(0);
        double scaleY = this.scaleField.getAsDouble(1);
        int x = (int)this.tiePointField.getAsDouble(0);
        int y = (int)this.tiePointField.getAsDouble(1);
        double p1x = this.toDegrees(this.tiePointField.getAsDouble(3));
        double p1y = this.toDegrees(this.tiePointField.getAsDouble(4));
        if (x != 0) {
            p1x += (double)(-x) * scaleX;
        }
        if (y != 0) {
            p1y += (double)(-y) * scaleY;
        }
        double p2x = p1x + (double)(this.cols - 1) * scaleX;
        double p2y = p1y - (double)(this.rows - 1) * scaleY;
        natLat = 36.666667;
        natLon = -88.333333;
        System.err.println("TransverseMercator:\nnatLat/lon: " + natLat + " " + natLon + "\nnorthing/easting: " + falseNorthing + "  " + falseEasting + "\nimage: (" + (p1x -= falseEasting) + "," + (p1y -= falseNorthing) + ") (" + (p2x -= falseEasting) + "," + (p2y -= falseNorthing) + ")");
        System.err.println("pcs=" + pcs);
        TransverseMercator tm = new TransverseMercator(natLat, natLon, naturalOriginScale);
        double[][] from = new double[][]{{this.ftToKm(p1x), this.ftToKm(p2x), this.ftToKm(p2x), this.ftToKm(p1x)}, {this.ftToKm(p1y), this.ftToKm(p1y), this.ftToKm(p2y), this.ftToKm(p2y)}};
        double[][] to = tm.projToLatLon(from, new double[2][4]);
        System.err.println("from:");
        for (i = 0; i < from.length; ++i) {
            Misc.printArray("", from[i]);
        }
        System.err.println("to:");
        for (i = 0; i < to.length; ++i) {
            Misc.printArray("", to[i]);
        }
        return this.createProjectionFromBox(to);
    }

    private MapProjection getGeographicMapProjection() throws VisADException, IOException {
        if (this.tiePointField == null) {
            throw new IllegalStateException("No tie point field found");
        }
        if (this.scaleField == null) {
            throw new IllegalStateException("No scale field found");
        }
        double scaleX = this.scaleField.getAsDouble(0);
        double scaleY = this.scaleField.getAsDouble(1);
        int x = (int)this.tiePointField.getAsDouble(0);
        int y = (int)this.tiePointField.getAsDouble(1);
        double lat1 = this.toDegrees(this.tiePointField.getAsDouble(4));
        double lon1 = this.toDegrees(this.tiePointField.getAsDouble(3));
        if (y != 0) {
            lat1 += (double)(-y) * scaleY;
        }
        if (x != 0) {
            lat1 += (double)(-x) * scaleX;
        }
        double lat2 = lat1 - (double)(this.rows - 1) * scaleY;
        double lon2 = lon1 + (double)(this.cols - 1) * scaleX;
        return new GRIBCoordinateSystem(0, this.cols, this.rows, lat2, lon1, lat1, lon2, scaleX, scaleY);
    }

    public static void print(String name, TIFFField field, StringBuffer sb) {
        if (field == null) {
            sb.append(name + ": null field\n");
            return;
        }
        sb.append(name + "=");
        int type = field.getType();
        block3: for (int i = 0; i < field.getCount(); ++i) {
            switch (type) {
                case 12: {
                    double v = field.getAsDouble(i);
                    sb.append((i == 0 ? "" : ",") + v);
                    continue block3;
                }
            }
        }
        sb.append("");
    }

    public void printKeys() {
        System.err.println(this.getKeyString());
    }

    public String getKeyString() {
        if (this.dirField == null) {
            return "Not a geotiff";
        }
        StringBuffer sb = new StringBuffer();
        GeotiffAdapter.print("\ttie point", this.tiePointField, sb);
        sb.append("\n");
        GeotiffAdapter.print("\tscale", this.scaleField, sb);
        sb.append("\n");
        for (int tagIdx = 4; tagIdx < this.dirField.getCount(); tagIdx += 4) {
            long geoKeyId = this.dirField.getAsLong(tagIdx);
            long location = this.dirField.getAsLong(tagIdx + 1);
            long count = this.dirField.getAsLong(tagIdx + 2);
            long offset = this.dirField.getAsLong(tagIdx + 3);
            String keyName = GeneratedKeys.Geokey.getName((int)geoKeyId);
            long value = 0L;
            if (location == 0L) {
                sb.append("\tgeokey: " + keyName + "(" + geoKeyId + ")  = " + offset);
                value = offset;
            } else {
                TIFFField subField = this.dir.getField((int)location);
                if (subField == null) {
                    sb.append("\tgeokey: " + keyName + "(" + geoKeyId + ")  could not be found\n");
                    continue;
                }
                String typeName = GeoKeys.Tiff.getFieldType(subField.getType());
                if (count == 1L) {
                    if (subField.getType() != 2) {
                        sb.append("\tgeokey: " + keyName + "(" + geoKeyId + ")  = " + subField.getAsDouble((int)offset));
                    }
                } else {
                    GeotiffAdapter.print("\tgeokey: " + keyName + "(" + geoKeyId + ") offset: " + offset, subField, sb);
                }
            }
            if (geoKeyId == 3072L) {
                sb.append("  projectedCS:" + GeneratedKeys.EpsgPcs.getName((int)value) + "\n");
                continue;
            }
            if (geoKeyId == 2048L) {
                sb.append(" geographic type:" + GeneratedKeys.EpsgGcs.getName((int)value) + "\n");
                continue;
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            System.err.print("\nFile: " + args[i] + "  ");
            try {
                new GeotiffAdapter(args[i]).printKeys();
                continue;
            }
            catch (Exception exc) {
                System.err.println("oops:" + args[i]);
                exc.printStackTrace();
            }
        }
    }
}

