/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.data.gis;

import HTTPClient.CookieModule;
import HTTPClient.HTTPConnection;
import HTTPClient.HTTPResponse;
import HTTPClient.NVPair;
import java.io.File;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import ucar.unidata.data.DataCategory;
import ucar.unidata.data.DataChoice;
import ucar.unidata.data.DataSelection;
import ucar.unidata.data.DataSourceDescriptor;
import ucar.unidata.data.DataSourceImpl;
import ucar.unidata.data.DirectDataChoice;
import ucar.unidata.util.IOUtil;
import ucar.unidata.util.StringUtil;
import visad.Data;
import visad.RealTupleType;
import visad.VisADException;
import visad.data.gis.DemFamily;

public class GeodasDataSource
extends DataSourceImpl {
    DemFamily dem;
    private List categories = DataCategory.parseCategories("DEM;GRID-2D;");

    public GeodasDataSource() {
    }

    public GeodasDataSource(DataSourceDescriptor descriptor, String source, Hashtable properties) throws VisADException {
        super(descriptor, source, "Geodas DEM data source", properties);
    }

    @Override
    protected void doMakeDataChoices() {
        this.addDataChoice(new DirectDataChoice(this, (Object)"Elevation", "Elevation", "Elevation", this.categories));
    }

    @Override
    protected Data getDataInner(DataChoice dataChoice, DataCategory category, DataSelection dataSelection, Hashtable requestProperties) throws VisADException, RemoteException {
        if (this.dem == null) {
            this.dem = new DemFamily("dem", RealTupleType.SpatialEarth2DTuple);
        }
        return null;
    }

    @Override
    protected List doMakeDateTimes() {
        return new ArrayList();
    }

    public void testit() throws Exception {
        boolean ok;
        String key = new String("" + Math.random() + "" + Math.random()).substring(0, 8);
        key = StringUtil.replace(key, ".", "");
        System.err.println("key:" + key);
        int left = 120;
        int right = 100;
        int top = 45;
        int bottom = 30;
        int cellSize = 0;
        int[] minutes = new int[]{2, 4, 6, 8, 10, 12, 14, 16, 18, 20};
        int lonNum = 0;
        int latNum = 0;
        for (int i = 0; i < minutes.length; ++i) {
            cellSize = minutes[i] * 60;
            lonNum = (left - right) * 60 / minutes[i];
            latNum = (top - bottom) * 60 / minutes[i];
            if (lonNum * latNum < 200000) break;
        }
        String[] args = new String[]{"KEY", key, "LATCELLSIZE", "" + cellSize, "LONCELLSIZE", "" + cellSize, "LATNUMCELLS", "" + latNum, "LONNUMCELLS", "" + lonNum, "TOPDEG", "" + top, "TOPMIN", "0", "TOPHEM", "N", "BOTTOMDEG", "" + bottom, "BOTTOMMIN", "0", "BOTTOMHEM", "N", "LEFTDEG", "" + left, "LEFTMIN", "0", "LEFTHEM", "W", "RIGHTDEG", "" + right, "RIGHTMIN", "0", "RIGHTHEM", "W", "DATA_BASE", "grdet2", "PATH_INV", "/net/prod/www/mgg/data/gdas", "PATH_CD", "/net/prod/www/mgg/data/cdroms/grddas00", "PATH_WRK", "/net/prod/www/mgg/dat/tmp/1/gtran", "FORMAT", "dfARCASCIIGRID", "BYTEORDER", "boLITTLEENDIAN", "XYZEMPTYCELLS", "ecINCLUDE", "XYZDELIM", "rdNONE", "PRECISION", "1", "NUMBERTYPE", "2", "NAN", "-32768", "GRIDRADIUS", "-1", "EXTENT", "deALL", "GRIDAREA", "TRUE", "OPSYSTEM", "Windows"};
        NVPair[] opts = new NVPair[args.length / 2];
        for (int i = 0; i < args.length; i += 2) {
            opts[i / 2] = new NVPair(args[i], args[i + 1]);
        }
        URL url = new URL("http://www.ngdc.noaa.gov/cgi-bin/mgg/gd_gtran");
        CookieModule.setCookiePolicyHandler(null);
        HTTPConnection conn = new HTTPConnection(url.getHost(), url.getPort());
        HTTPResponse res = conn.Post(url.getFile(), opts);
        String html = new String(res.getData());
        boolean bl = ok = res.getStatusCode() < 300;
        if (ok) {
            boolean bl2 = ok = html.indexOf("Success") >= 0;
        }
        if (!ok) {
            System.err.println("bad:" + html);
            return;
        }
        url = new URL("http://www.ngdc.noaa.gov/mgg/tmp/1/gtran/" + key + "_data/" + key + "/" + key + ".asc");
        byte[] ascBytes = IOUtil.readBytes(url.openConnection().getInputStream());
        System.err.println("read:" + ascBytes.length);
        IOUtil.writeBytes(new File("test.asc"), ascBytes);
    }
}

