/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.data.gis;

import java.io.FileOutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import ucar.unidata.data.DataCategory;
import ucar.unidata.data.DataChoice;
import ucar.unidata.data.DataSelection;
import ucar.unidata.data.DataSourceDescriptor;
import ucar.unidata.data.DirectDataChoice;
import ucar.unidata.data.FilesDataSource;
import ucar.unidata.util.DatePattern;
import ucar.unidata.util.IOUtil;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.visad.Util;
import visad.Data;
import visad.DateTime;
import visad.FieldImpl;
import visad.RealTupleType;
import visad.VisADException;
import visad.data.FunctionFormFamily;
import visad.data.gis.ArcAsciiGridForm;
import visad.data.gis.UsgsDemForm;

public class DemDataSource
extends FilesDataSource {
    boolean useFilenameForTime = false;
    private List categories = DataCategory.parseCategories("DEM;GRID-2D;");
    private String dateTimePattern;
    MyDemFamily dem;

    public DemDataSource() {
    }

    public DemDataSource(DataSourceDescriptor descriptor, String source, Hashtable properties) throws VisADException {
        super(descriptor, Misc.newList(source), source, "DEM data source", properties);
        Object oj = properties.get("useFilenameForTime");
        if (oj != null) {
            this.useFilenameForTime = Boolean.parseBoolean(oj.toString());
        }
        if ((oj = properties.get("pattern")) != null) {
            this.dateTimePattern = oj.toString();
        }
        this.initDemDataSource();
    }

    public String getDateTimePattern() {
        return this.dateTimePattern;
    }

    public void setDateTimePattern(String dateTimePattern) {
        this.dateTimePattern = dateTimePattern;
    }

    public boolean getUseFilenameForTime() {
        return this.useFilenameForTime;
    }

    public void setUseFilenameForTime(boolean useFilenameForTime) {
        this.useFilenameForTime = useFilenameForTime;
    }

    @Override
    public boolean canSaveDataToLocalDisk() {
        return !this.isFileBased();
    }

    @Override
    public void initAfterUnpersistence() {
        super.initAfterUnpersistence();
        this.initDemDataSource();
    }

    private void initDemDataSource() {
        this.dem = new MyDemFamily();
    }

    @Override
    protected void doMakeDataChoices() {
        this.addDataChoice(new DirectDataChoice(this, this.sources.get(0), "Elevation", "Elevation", this.categories));
    }

    @Override
    protected Data getDataInner(DataChoice dataChoice, DataCategory category, DataSelection dataSelection, Hashtable requestProperties) throws VisADException, RemoteException {
        String filename = (String)dataChoice.getId();
        try {
            return this.makeDemData(filename);
        }
        catch (Exception exc) {
            this.logException("Reading DEM: " + filename, exc);
            return null;
        }
    }

    @Override
    protected List doMakeDateTimes() {
        if (this.useFilenameForTime) {
            DatePattern dp = new DatePattern(this.dateTimePattern);
            ArrayList<DateTime> dts = new ArrayList<DateTime>();
            for (int i = 0; i < this.sources.size(); ++i) {
                String fname = IOUtil.getFileTail((String)this.sources.get(i));
                if (!dp.match(fname)) continue;
                dts.add(dp.getDateTime());
            }
            return dts;
        }
        return new ArrayList();
    }

    private FieldImpl makeDemData(String filename) throws Exception {
        FieldImpl fi = (FieldImpl)this.getCache(filename);
        Object fii = null;
        if (fi == null) {
            String dataFile = filename;
            try {
                LogUtil.message("Copying DEM file to local disk");
                URL url = new URL(filename);
                String tail = Misc.getUniqueId() + IOUtil.getFileTail(filename);
                String tmpFile = this.getDataContext().getIdv().getStore().getTmpFile(tail);
                FileOutputStream fos = new FileOutputStream(tmpFile);
                IOUtil.writeTo(IOUtil.getInputStream(filename, this.getClass()), fos);
                fos.close();
                dataFile = tmpFile;
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            LogUtil.message("Reading DEM file: " + IOUtil.getFileTail(filename));
            fi = (FieldImpl)this.dem.open(dataFile);
            if (this.useFilenameForTime) {
                fi = (FieldImpl)Util.makeTimeField(fi, this.doMakeDateTimes());
            }
            this.putCache(filename, fi);
        }
        return fi;
    }

    private static class MyDemFamily
    extends FunctionFormFamily {
        public MyDemFamily() {
            super("dem");
            this.forms.add(new UsgsDemForm());
            this.forms.add(new ArcAsciiGridForm(RealTupleType.SpatialEarth2DTuple));
        }

        public boolean isThisType(String name) {
            return false;
        }

        public boolean isThisType(byte[] block) {
            return false;
        }

        public String[] getDefaultSuffixes() {
            String[] suff = new String[]{".dem", ".asc"};
            return suff;
        }
    }
}

