/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.data;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import ucar.unidata.data.CompositeDataChoice;
import ucar.unidata.data.DataCategory;
import ucar.unidata.data.DataChoice;
import ucar.unidata.data.DataSelection;
import ucar.unidata.data.DataSource;
import ucar.unidata.data.DataSourceDescriptor;
import ucar.unidata.data.DirectDataChoice;
import ucar.unidata.data.FilesDataSource;
import ucar.unidata.util.Misc;
import visad.Data;
import visad.MathType;
import visad.Tuple;
import visad.TupleType;
import visad.VisADException;
import visad.data.DefaultFamily;

public class VisadDataSource
extends FilesDataSource {
    DefaultFamily family = new DefaultFamily("VisADDataSource");
    Data myData = null;

    public VisadDataSource() {
    }

    public VisadDataSource(DataSourceDescriptor descriptor, String filename, Hashtable properties) throws VisADException {
        super(descriptor, Misc.newList(filename), filename, "Visad data source", properties);
        this.openData();
    }

    @Override
    public boolean canSaveDataToLocalDisk() {
        return !this.isFileBased();
    }

    @Override
    public void initAfterUnpersistence() {
        if (this.sources == null) {
            this.sources = Misc.newList(this.getName());
        }
        super.initAfterUnpersistence();
        this.openData();
    }

    private void openData() {
        try {
            this.myData = this.family.open(this.sources.get(0).toString());
        }
        catch (Exception exc) {
            this.setInError(true, "Failed to open " + this.getName() + " " + exc.getMessage());
        }
    }

    @Override
    protected void doMakeDataChoices() {
        String name = "VisAD Data";
        String description = (String)this.getProperty("datachoicename");
        if (description != null) {
            name = description;
        } else {
            description = "Generic VisAD Data Object";
            try {
                description = this.myData.getType().toString();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        List categories = DataCategory.parseCategories("VISAD;" + description, false);
        CompositeDataChoice main = new CompositeDataChoice(this, (Object)description, name, description, categories);
        if (this.myData instanceof Tuple) {
            try {
                TupleType tt = (TupleType)this.myData.getType();
                for (int i = 0; i < tt.getDimension(); ++i) {
                    MathType mt = tt.getComponent(i);
                    DirectDataChoice cc = new DirectDataChoice((DataSource)this, (Object)mt, "Tuple Component " + i, mt.toString(), categories, DataChoice.NULL_PROPERTIES);
                    main.addDataChoice(cc);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.addDataChoice(main);
    }

    @Override
    protected Data getDataInner(DataChoice dataChoice, DataCategory category, DataSelection dataSelection, Hashtable requestProperties) throws VisADException, RemoteException {
        Data data = dataChoice instanceof CompositeDataChoice ? this.myData : ((Tuple)this.myData).getComponent(((TupleType)this.myData.getType()).getIndex((MathType)dataChoice.getId()));
        return data;
    }

    @Override
    protected List doMakeDateTimes() {
        return new ArrayList();
    }
}

