/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.data;

import java.util.List;
import ucar.unidata.data.DataUtil;
import visad.RealType;
import visad.Unit;

public class VarInfo {
    private String name;
    private String description;
    private String category;
    private Unit unit;
    private boolean isNumeric = true;
    private RealType realType;
    private double missingValue;

    public VarInfo(String name, String desc, Unit unit) {
        this(name, desc, null, unit);
    }

    public VarInfo(String name, String desc, String category, Unit unit) {
        this(name, desc, category, unit, Double.NaN);
    }

    public VarInfo(String name, String desc, String category, Unit unit, double missingValue) {
        this.name = name;
        this.description = desc;
        this.category = category;
        if (this.description == null || this.description.trim().length() == 0) {
            this.description = name;
        }
        this.unit = unit;
        this.missingValue = missingValue;
        this.realType = DataUtil.makeRealType(this.getShortName(), unit);
        if (this.realType == null) {
            System.out.println("can't create realtype for " + this.getShortName() + " with unit " + unit);
        }
    }

    public VarInfo(String name, Unit unit) {
        this(name, name, unit);
    }

    public VarInfo(String name, String units) {
        this(name, DataUtil.parseUnit(units));
    }

    public VarInfo(String name, String desc, String units) {
        this(name, desc, DataUtil.parseUnit(units));
    }

    public static VarInfo getVarInfo(String variableName, List<VarInfo> variables) {
        String[] vars = new String[]{variableName, variableName.toLowerCase()};
        for (int dummyIdx = 0; dummyIdx < vars.length; ++dummyIdx) {
            VarInfo theVar;
            int varIdx;
            for (varIdx = 0; varIdx < variables.size(); ++varIdx) {
                theVar = variables.get(varIdx);
                if (!vars[dummyIdx].equals(theVar.getName())) continue;
                return theVar;
            }
            for (varIdx = 0; varIdx < variables.size(); ++varIdx) {
                theVar = variables.get(varIdx);
                if (!vars[dummyIdx].equals(theVar.getDescription())) continue;
                return theVar;
            }
        }
        throw new IllegalArgumentException("Unknown variable: " + variableName);
    }

    public String getName() {
        return this.name;
    }

    public String getShortName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setCategory(String value) {
        this.category = value;
    }

    public String getCategory() {
        return this.category;
    }

    public String toString() {
        return this.name;
    }

    public void setIsNumeric(boolean value) {
        this.isNumeric = value;
    }

    public boolean getIsNumeric() {
        return this.isNumeric;
    }

    public void setRealType(RealType value) {
        this.realType = value;
    }

    public RealType getRealType() {
        return this.realType;
    }

    public void setUnit(Unit value) {
        this.unit = value;
    }

    public Unit getUnit() {
        return this.unit;
    }

    public void setMissingValue(double value) {
        this.missingValue = value;
    }

    public double getMissingValue() {
        return this.missingValue;
    }
}

