/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.data;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.Hashtable;
import ucar.unidata.data.DataCancelException;
import ucar.unidata.data.DataCategory;
import ucar.unidata.data.DataChangeListener;
import ucar.unidata.data.DataChoice;
import ucar.unidata.data.DataSelection;
import ucar.unidata.util.IOUtil;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import visad.Data;
import visad.Text;
import visad.VisADException;

public class UrlDataChoice
extends DataChoice {
    String url;

    public UrlDataChoice() {
    }

    public UrlDataChoice(String url) {
        this(url, url);
    }

    public UrlDataChoice(String url, String desc) {
        super(url, desc, desc, Misc.newList(new DataCategory("Documentation", true), new DataCategory("html", false)));
        this.url = url;
    }

    public UrlDataChoice(UrlDataChoice other) {
        super(other);
        this.url = other.url;
    }

    @Override
    public DataChoice cloneMe() {
        return new UrlDataChoice(this);
    }

    public void setUrl(String value) {
        this.url = value;
    }

    public String getUrl() {
        return this.url;
    }

    @Override
    protected Data getData(DataCategory category, DataSelection dataSelection, Hashtable requestProperties) throws VisADException, RemoteException, DataCancelException {
        try {
            if (!this.url.startsWith("http:")) {
                return new Text(this.url);
            }
            return new Text(IOUtil.readContents(this.url));
        }
        catch (FileNotFoundException fnfe) {
            LogUtil.printException(log_, "getData", fnfe);
        }
        catch (IOException ioe) {
            LogUtil.printException(log_, "getData", ioe);
        }
        return null;
    }

    @Override
    public int hashCode() {
        return this.url.hashCode() ^ super.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof UrlDataChoice)) {
            return false;
        }
        return super.equals(o) && ((UrlDataChoice)o).url.equals(this.url);
    }

    @Override
    public void addDataChangeListener(DataChangeListener listener) {
    }

    @Override
    public void removeDataChangeListener(DataChangeListener listener) {
    }
}

