/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.data;

import java.io.BufferedInputStream;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.w3c.dom.Element;
import ucar.unidata.data.DataCategory;
import ucar.unidata.data.DataChoice;
import ucar.unidata.data.DataSelection;
import ucar.unidata.data.DataSource;
import ucar.unidata.data.DataSourceDescriptor;
import ucar.unidata.data.DirectDataChoice;
import ucar.unidata.data.FilesDataSource;
import ucar.unidata.util.IOUtil;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.xml.XmlUtil;
import visad.Data;
import visad.VisADException;

public class SerializedDataSource
extends FilesDataSource {
    public static final String TAG_SERIALIZEDDATA = "serializeddata";
    public static final String TAG_DATA = "data";
    public static final String ATTR_NAME = "name";
    public static final String ATTR_FILE = "file";
    public static final String ATTR_ICON = "icon";
    public static final String ATTR_CATEGORIES = "categories";
    private List dataChoices = new ArrayList();

    public SerializedDataSource() {
    }

    public SerializedDataSource(DataSourceDescriptor descriptor, String source, Hashtable properties) throws VisADException {
        super(descriptor, source, "Serialized data source", properties);
    }

    @Override
    public void initAfterCreation() {
        this.loadFile();
    }

    private void loadFile() {
        try {
            BufferedInputStream bin = new BufferedInputStream(IOUtil.getInputStream(this.getFilePath()));
            ZipInputStream zin = new ZipInputStream(bin);
            ZipEntry ze = null;
            while ((ze = zin.getNextEntry()) != null) {
                String name = ze.getName().toLowerCase();
                if (!name.endsWith(".xser")) continue;
                String xml = new String(IOUtil.readBytes(zin, null, false));
                this.processToc(XmlUtil.getRoot(xml));
            }
            zin.close();
        }
        catch (Exception iexc) {
            LogUtil.logException("There was an error processing the serialized data file:\n " + this.getFilePath(), iexc);
            this.setInError(true);
        }
    }

    private void processToc(Element root) {
        List children = XmlUtil.findChildren(root, TAG_DATA);
        for (int i = 0; i < children.size(); ++i) {
            Element child = (Element)children.get(i);
            Hashtable<String, String> props = new Hashtable<String, String>();
            if (XmlUtil.hasAttribute(child, ATTR_ICON)) {
                props.put("prop.icon", XmlUtil.getAttribute(child, ATTR_ICON));
            }
            List categories = DataCategory.parseCategories(XmlUtil.getAttribute(child, ATTR_CATEGORIES), false);
            this.dataChoices.add(new DirectDataChoice((DataSource)this, (Object)XmlUtil.getAttribute(child, ATTR_FILE), XmlUtil.getAttribute(child, ATTR_NAME), XmlUtil.getAttribute(child, ATTR_NAME), categories, props));
        }
    }

    @Override
    protected void doMakeDataChoices() {
        if (this.dataChoices.size() == 0) {
            this.loadFile();
        }
        for (int i = 0; i < this.dataChoices.size(); ++i) {
            this.addDataChoice((DataChoice)this.dataChoices.get(i));
        }
    }

    @Override
    protected Data getDataInner(DataChoice dataChoice, DataCategory category, DataSelection dataSelection, Hashtable requestProperties) throws VisADException, RemoteException {
        String file = dataChoice.getId().toString();
        try {
            BufferedInputStream bin = new BufferedInputStream(IOUtil.getInputStream(this.getFilePath()));
            ZipInputStream zin = new ZipInputStream(bin);
            ZipEntry ze = null;
            while ((ze = zin.getNextEntry()) != null) {
                String name = ze.getName().toLowerCase();
                if (!name.equals(file)) continue;
                byte[] bytes = IOUtil.readBytes(zin, null, false);
                zin.close();
                return (Data)Misc.deserialize(bytes);
            }
            zin.close();
            LogUtil.userErrorMessage("Could not find the serialized data:" + file);
        }
        catch (Exception iexc) {
            LogUtil.logException("There was an error reading the data for:\n " + file, iexc);
        }
        return null;
    }

    @Override
    protected List doMakeDateTimes() {
        return new ArrayList();
    }
}

