/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.data;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import ucar.unidata.data.DataCancelException;
import ucar.unidata.data.DataCategory;
import ucar.unidata.data.DataChangeListener;
import ucar.unidata.data.DataChoice;
import ucar.unidata.data.DataSelection;
import ucar.unidata.util.CacheManager;
import ucar.unidata.util.Misc;
import ucar.unidata.util.StringUtil;
import visad.Data;
import visad.VisADException;

public class ListDataChoice
extends DataChoice {
    private List listeners = new ArrayList();
    List childrenChoices;

    public ListDataChoice() {
    }

    public ListDataChoice(ListDataChoice other) {
        super(other);
        this.childrenChoices = ListDataChoice.cloneDataChoices(other.childrenChoices);
    }

    public ListDataChoice(Object id, String name, String description, List categories) {
        super(id, name, description, categories);
        this.childrenChoices = new ArrayList();
    }

    public ListDataChoice(String name, List children) {
        super(name, name, name, null);
        this.childrenChoices = children;
    }

    public void setChildrenDataChoices(List dataChoices) {
        this.childrenChoices = dataChoices;
        this.setDescription(this.convertLabel(this.getDescription(), this.childrenChoices));
    }

    @Override
    protected Data getData(DataCategory category, DataSelection dataSelection, Hashtable requestProperties) throws VisADException, RemoteException, DataCancelException {
        return null;
    }

    protected Object[] getDataList(DataCategory category, DataSelection dataSelection, Hashtable requestProperties) throws VisADException, RemoteException, DataCancelException {
        ArrayList<Data> data = new ArrayList<Data>();
        for (int i = 0; i < this.childrenChoices.size(); ++i) {
            DataChoice child = (DataChoice)this.childrenChoices.get(i);
            data.add(child.getData(category, dataSelection, requestProperties));
        }
        return data.toArray(new Object[data.size()]);
    }

    @Override
    public DataChoice cloneMe() {
        return new ListDataChoice(this);
    }

    @Override
    public String getIndexedName(int index) {
        if (this.childrenChoices != null && index < this.childrenChoices.size()) {
            return ((DataChoice)this.childrenChoices.get(index)).getName();
        }
        return super.getName();
    }

    protected void checkCategories() {
        ArrayList tmpCategories = new ArrayList(this.categories);
        for (int i = 0; i < tmpCategories.size(); ++i) {
            DataCategory dataCategory = (DataCategory)tmpCategories.get(i);
            if (!dataCategory.isInherited()) continue;
            this.inherit(dataCategory);
        }
    }

    @Override
    public void initAfterUnPersistence(Hashtable properties) {
        super.initAfterUnPersistence(properties);
        for (int i = 0; i < this.childrenChoices.size(); ++i) {
            ((DataChoice)this.childrenChoices.get(i)).initAfterUnPersistence(properties);
        }
    }

    @Override
    public void getFinalDataChoices(List finalDataChoices) {
        super.getFinalDataChoices(finalDataChoices);
        for (int i = 0; i < this.childrenChoices.size(); ++i) {
            ((DataChoice)this.childrenChoices.get(i)).getFinalDataChoices(finalDataChoices);
        }
    }

    @Override
    public void getDataSources(List dataSources) {
        for (int i = 0; i < this.childrenChoices.size(); ++i) {
            ((DataChoice)this.childrenChoices.get(i)).getDataSources(dataSources);
        }
    }

    protected void inherit(DataCategory src) {
        if (src == null) {
            return;
        }
        List children = this.childrenChoices;
        if (src.getChildIndex() >= 0) {
            children = Misc.newList(this.childrenChoices.get(src.getChildIndex()));
        }
        int categoryIndex = src.getCategoryIndex();
        ArrayList<DataCategory> newCategories = new ArrayList<DataCategory>();
        for (int childIdx = 0; childIdx < children.size(); ++childIdx) {
            DataChoice child = (DataChoice)children.get(childIdx);
            List childCategories = child.getCategories();
            if (categoryIndex >= 0) {
                childCategories = Misc.newList(childCategories.get(categoryIndex));
            }
            for (int i = 0; i < childCategories.size(); ++i) {
                DataCategory childsDataCategory = (DataCategory)childCategories.get(i);
                if (newCategories.contains(childsDataCategory)) continue;
                newCategories.add(childsDataCategory);
            }
        }
        int srcIndex = this.categories.indexOf(src);
        for (int i = 0; i < newCategories.size(); ++i) {
            String newSuffix;
            String newCategoryString;
            DataCategory newCategory = (DataCategory)newCategories.get(i);
            if (src.getAppend() != null && !(newCategoryString = newCategory.toString()).endsWith(newSuffix = "-" + src.getAppend())) {
                newCategory = DataCategory.parseCategory(newCategoryString + newSuffix, newCategory.getForDisplay());
            }
            if (src.getReplace() != null) {
                String catString = newCategory.toString() + "-" + src.getAppend();
                for (String pair : StringUtil.split(src.getReplace(), ";", true, true)) {
                    List<String> tuple = StringUtil.split(pair, ":", true, true);
                    catString = catString.replaceAll(tuple.get(0), tuple.get(1));
                }
                newCategory = DataCategory.parseCategory(catString, newCategory.getForDisplay());
            }
            if (i == 0) {
                this.categories.set(srcIndex, newCategory);
                continue;
            }
            this.categories.add(srcIndex + 1, newCategory);
        }
    }

    protected String convertLabel(String label, List dataChoices) {
        for (int i = 0; i < dataChoices.size(); ++i) {
            DataChoice choice = (DataChoice)dataChoices.get(i);
            label = StringUtil.replace(label, "%N" + (i + 1) + "%", choice.getName());
            label = StringUtil.replace(label, "%D" + (i + 1) + "%", choice.getDescription());
        }
        return label;
    }

    @Override
    public String getFullDescription() {
        StringBuffer sb = new StringBuffer(super.getFullDescription() + "<br>from: <ul>");
        for (int i = 0; i < this.childrenChoices.size(); ++i) {
            DataChoice child = (DataChoice)this.childrenChoices.get(i);
            sb.append("<li>" + child.getFullDescription());
        }
        sb.append("</ul>");
        return sb.toString();
    }

    @Override
    public List getAllLevels(DataSelection dataSelection) {
        String levelsProp = (String)this.getProperty("levels");
        if (Misc.equals(levelsProp, "false")) {
            return new ArrayList();
        }
        ArrayList mine = new ArrayList();
        Hashtable seen = new Hashtable();
        dataSelection = DataSelection.merge(dataSelection, this.myDataSelection);
        for (int i = 0; i < this.childrenChoices.size(); ++i) {
            DataChoice child = (DataChoice)this.childrenChoices.get(i);
            if (child == null) continue;
            Misc.addUnique(mine, child.getAllLevels(dataSelection), seen);
        }
        return mine;
    }

    @Override
    public List getAllDateTimes() {
        ArrayList mine = new ArrayList();
        Hashtable seen = new Hashtable();
        for (int i = 0; i < this.childrenChoices.size(); ++i) {
            DataChoice child = (DataChoice)this.childrenChoices.get(i);
            if (child == null) continue;
            Misc.addUnique(mine, child.getAllDateTimes(), seen);
        }
        return mine;
    }

    @Override
    public List getSelectedDateTimes() {
        ArrayList mine = new ArrayList();
        Hashtable seen = new Hashtable();
        for (int i = 0; i < this.childrenChoices.size(); ++i) {
            DataChoice child = (DataChoice)this.childrenChoices.get(i);
            if (child == null) continue;
            Misc.addUnique(mine, child.getSelectedDateTimes(), seen);
        }
        return mine;
    }

    protected void findDataCategories() {
        ArrayList<DataCategory> dataCategories = new ArrayList<DataCategory>();
        Hashtable<DataCategory, DataCategory> seenCategories = new Hashtable<DataCategory, DataCategory>();
        for (int i = 0; i < this.childrenChoices.size(); ++i) {
            List subCategories = ((DataChoice)this.childrenChoices.get((int)i)).categories;
            for (int j = 0; j < subCategories.size(); ++j) {
                DataCategory subCategory = (DataCategory)subCategories.get(i);
                if (seenCategories.get(subCategory) != null) continue;
                seenCategories.put(subCategory, subCategory);
                dataCategories.add(subCategory);
            }
        }
        this.setCategories(dataCategories);
    }

    void printChildren() {
        for (int i = 0; i < this.childrenChoices.size(); ++i) {
            DataChoice dc = (DataChoice)this.childrenChoices.get(i);
            System.err.println("child:" + dc.getClass().getName() + " " + dc);
        }
    }

    public void setChoices(List l) {
        this.childrenChoices = l;
    }

    public List getChoices() {
        return this.childrenChoices;
    }

    protected void flushCache() {
        CacheManager.remove(this);
    }

    protected void addDataChangeListeners(DataChoice dataChoice) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            dataChoice.addDataChangeListener((DataChangeListener)this.listeners.get(i));
        }
    }

    @Override
    public void addDataChangeListener(DataChangeListener listener) {
        this.listeners.add(listener);
        for (int i = 0; i < this.childrenChoices.size(); ++i) {
            DataChoice child = (DataChoice)this.childrenChoices.get(i);
            if (child == null) continue;
            child.addDataChangeListener(listener);
        }
    }

    @Override
    public void removeDataChangeListener(DataChangeListener listener) {
        this.flushCache();
        this.listeners.remove(listener);
        for (int i = 0; i < this.childrenChoices.size(); ++i) {
            DataChoice child = (DataChoice)this.childrenChoices.get(i);
            if (child == null) continue;
            child.removeDataChangeListener(listener);
        }
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ Misc.hashcode(this.childrenChoices) ^ Misc.hashcode(this.properties);
    }

    @Override
    public boolean basicallyEquals(DataChoice that) {
        return this.equals(that);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (!(o instanceof ListDataChoice)) {
            return false;
        }
        ListDataChoice that = (ListDataChoice)o;
        return Misc.equals(this.properties, that.properties) && Misc.equals(this.childrenChoices, that.childrenChoices);
    }
}

