/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.data;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.geom.GeneralPath;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;
import ucar.unidata.data.GeoLocationInfo;
import ucar.unidata.data.GeoSelection;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.ProjectionPoint;
import ucar.unidata.geoloc.ProjectionPointImpl;
import ucar.unidata.geoloc.ProjectionRect;
import ucar.unidata.idv.DisplayConventions;
import ucar.unidata.ui.LatLonWidget;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.view.geoloc.NavigatedMapPanel;
import ucar.unidata.view.geoloc.NavigatedPanel;

public class GeoSelectionPanel
extends JPanel {
    private JComponent extraComponent;
    private JComponent strideComponent;
    private JComponent areaComponent;
    private static final int[] STRIDE_VALUES = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 15, 20, 50, 100};
    private static final String[] PT_STRIDE_LABELS = new String[]{"Undefined", "All points", "Every other point", "Every third point", "Every fourth point", "Every fifth point", "Every sixth point", "Every seventh point", "Every eighth point", "Every ninth point", "Every tenth point", "Every fifteenth point", "Every twentieth point", "Every fiftieth point", "Every hundredth "};
    private static final String[] PT_STRIDE_LABELS_SHORT = new String[]{"Undefined", "All", "2nd", "3rd", "4th", "5th", "6th", "7th", "8th", "9th", "10th", "15th", "20th", "50th", "100th"};
    private static final String[] LEVEL_STRIDE_LABELS = new String[]{"Undefined", "All levels", "Every other level", "Every third level", "Every fourth level", "Every fifth level", "Every sixth level", "Every seventh level", "Every eighth level", "Every ninth level", "Every tenth level", "Every fifteenth level", "Every twentieth level", "Every fiftieth level", "Every hundredth "};
    private GeoSelection geoSelection;
    private JComboBox xStrideBox;
    private JComboBox yStrideBox;
    private JComboBox zStrideBox;
    private NavigatedMapPanel mapPanel;
    private LatLonWidget ulLatLon;
    private LatLonWidget lrLatLon;
    private JCheckBox indexCbx;
    private JComponent latLonPanel;
    private boolean ignoreBoxChanges = false;
    private boolean enabled = false;
    private JToggleButton lockBtn;
    private JCheckBox enabledCbx;
    private JCheckBox useDisplayAreaCbx;

    public GeoSelectionPanel(GeoSelection geoSelection, boolean fullVersion, boolean enabled, boolean doStride, boolean doBoundingBox, ProjectionImpl sampleProjection, JComponent extraComponent) {
        this.geoSelection = geoSelection;
        this.extraComponent = extraComponent;
        this.enabled = enabled;
        this.setLayout(new BorderLayout());
        this.add("Center", this.makePanel(fullVersion, doStride, doBoundingBox, sampleProjection));
        if (this.enabledCbx != null) {
            GuiUtils.enableTree(this, enabled);
            GuiUtils.enableTree(this.enabledCbx, true);
        }
    }

    private JComboBox makeBox(int stride, String[] labels) {
        final JComboBox box = GuiUtils.makeComboBox(STRIDE_VALUES, labels, stride);
        box.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (GeoSelectionPanel.this.ignoreBoxChanges || !GeoSelectionPanel.this.lockBtn.isSelected()) {
                    return;
                }
                if (GeoSelectionPanel.this.zStrideBox == box) {
                    return;
                }
                GeoSelectionPanel.this.ignoreBoxChanges = true;
                Object obj = box.getSelectedItem();
                GeoSelectionPanel.this.xStrideBox.setSelectedItem(obj);
                GeoSelectionPanel.this.yStrideBox.setSelectedItem(obj);
                GeoSelectionPanel.this.ignoreBoxChanges = false;
            }
        });
        return box;
    }

    public void initWith(GeoSelectionPanel p) {
        if (this.xStrideBox != null && p.xStrideBox != null) {
            this.xStrideBox.setSelectedItem(p.xStrideBox.getSelectedItem());
        }
        if (this.yStrideBox != null && p.yStrideBox != null) {
            this.yStrideBox.setSelectedItem(p.yStrideBox.getSelectedItem());
        }
        if (this.zStrideBox != null && p.zStrideBox != null) {
            this.zStrideBox.setSelectedItem(p.zStrideBox.getSelectedItem());
        }
        if (this.lockBtn != null && p.lockBtn != null) {
            this.lockBtn.setSelected(p.lockBtn.isSelected());
        }
        if (this.mapPanel != null && p.mapPanel != null && this.mapPanel.getProjectionImpl().equals(p.mapPanel.getProjectionImpl())) {
            NavigatedPanel np = this.mapPanel.getNavigatedPanel();
            if (p.mapPanel.getNavigatedPanel().getSelectedRegion() != null) {
                np.setSelectedRegion(p.mapPanel.getNavigatedPanel().getSelectedRegion());
            }
            this.mapPanel.repaint();
        }
    }

    private JComponent makePanel(boolean fullVersion, boolean doStride, boolean doBoundingBox, ProjectionImpl sampleProjection) {
        ArrayList<JPanel> boxComps = new ArrayList<JPanel>();
        ArrayList<JComponent> strideComps = new ArrayList<JComponent>();
        ArrayList<JComponent> useDisplayAreaComps = new ArrayList<JComponent>();
        if (doStride) {
            this.lockBtn = GuiUtils.getToggleButton("/auxdata/ui/icons/link_break.png", 0, 0);
            this.lockBtn.setContentAreaFilled(false);
            this.lockBtn.setSelectedIcon(GuiUtils.getImageIcon("/auxdata/ui/icons/link.png", this.getClass()));
            this.lockBtn.setSelected(this.geoSelection.getXStride() == this.geoSelection.getYStride());
            this.lockBtn.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.lockBtn.setToolTipText("Link stride changes between x & y");
            this.xStrideBox = this.makeBox(this.geoSelection.getXStride(), fullVersion ? PT_STRIDE_LABELS : PT_STRIDE_LABELS);
            strideComps.add(GuiUtils.rLabel(fullVersion ? "X Sampling:" : "X:"));
            strideComps.add(GuiUtils.left(GuiUtils.hbox((Component)this.xStrideBox, (Component)new JLabel("      "), this.lockBtn)));
            this.yStrideBox = this.makeBox(this.geoSelection.getYStride(), fullVersion ? PT_STRIDE_LABELS : PT_STRIDE_LABELS);
            strideComps.add(GuiUtils.rLabel(fullVersion ? "Y Sampling:" : "Y:"));
            strideComps.add(GuiUtils.left(this.yStrideBox));
            this.zStrideBox = this.makeBox(this.geoSelection.getZStride(), fullVersion ? LEVEL_STRIDE_LABELS : PT_STRIDE_LABELS);
            strideComps.add(GuiUtils.rLabel(fullVersion ? "Level Sampling:" : "Level:"));
            strideComps.add(GuiUtils.left(this.zStrideBox));
        }
        this.useDisplayAreaCbx = new JCheckBox("", this.geoSelection.getUseViewBounds());
        this.useDisplayAreaCbx.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean showMap = !((JCheckBox)e.getSource()).isSelected();
                GuiUtils.enablePanel(GeoSelectionPanel.this.mapPanel, showMap);
            }
        });
        useDisplayAreaComps.add(GuiUtils.rLabel("Match Display Region:"));
        useDisplayAreaComps.add(GuiUtils.left(this.useDisplayAreaCbx));
        if (doBoundingBox) {
            ActionListener actionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    GeoSelectionPanel.this.setBoundsFromFields();
                }
            };
            this.indexCbx = new JCheckBox("Use indices");
            this.ulLatLon = new LatLonWidget("Lat:", "Lon:", actionListener);
            this.lrLatLon = new LatLonWidget("Lat:", "Lon:", actionListener);
            this.ulLatLon.setDoFormat(false);
            this.lrLatLon.setDoFormat(false);
            JComponent leftPanel = this.latLonPanel = GuiUtils.doLayout(new Component[]{GuiUtils.inset((Component)GuiUtils.wrap(this.ulLatLon.getLatField()), 5), GuiUtils.hbox((Component)this.ulLatLon.getLonField(), (Component)this.lrLatLon.getLonField(), 5), GuiUtils.inset((Component)GuiUtils.wrap(this.lrLatLon.getLatField()), 5)}, 1, GuiUtils.WT_N, GuiUtils.WT_N);
            this.mapPanel = new MyNavigatedMapPanel(this, sampleProjection, fullVersion);
            if (fullVersion) {
                this.mapPanel.setPreferredSize(new Dimension(400, 300));
            }
            if (this.geoSelection.getBoundingBox() != null) {
                GeoLocationInfo bb = this.geoSelection.getBoundingBox();
                this.selectedRegionChanged(bb.getLatLonRect());
            } else {
                this.selectedRegionChanged(null);
            }
            boxComps.add(GuiUtils.topCenter(GuiUtils.inset((Component)GuiUtils.rLabel("Bounding Box:"), new Insets(10, 0, 0, 0)), GuiUtils.inset((Component)leftPanel, new Insets(0, 0, 60, 0))));
            boxComps.add(this.mapPanel);
        }
        if (fullVersion) {
            ArrayList<JComponent> comps = new ArrayList<JComponent>(strideComps);
            comps.addAll(useDisplayAreaComps);
            comps.addAll(boxComps);
            GuiUtils.tmpInsets = new Insets(5, 5, 5, 5);
            return GuiUtils.doLayout(comps, 2, GuiUtils.WT_NY, GuiUtils.WT_NNNY);
        }
        JTabbedPane tab = GuiUtils.getNestedTabbedPane();
        this.enabledCbx = new JCheckBox("Enabled", this.enabled);
        this.enabledCbx.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                GuiUtils.enableTree(GeoSelectionPanel.this, GeoSelectionPanel.this.enabledCbx.isSelected());
                GuiUtils.enableTree(GeoSelectionPanel.this.enabledCbx, true);
            }
        });
        if (strideComps.size() > 0) {
            GuiUtils.tmpInsets = new Insets(5, 5, 5, 5);
            this.strideComponent = GuiUtils.topLeft(GuiUtils.doLayout(strideComps, 2, GuiUtils.WT_N, GuiUtils.WT_N));
            tab.addTab("Data Sampling", this.strideComponent);
        }
        if (doBoundingBox) {
            if (strideComps.size() == 0) {
                tab.add("Area", GuiUtils.topCenter(GuiUtils.left(this.enabledCbx), this.mapPanel));
            } else {
                tab.add("Area", this.mapPanel);
            }
        }
        return tab;
    }

    public JComponent getStrideComponent() {
        if (this.strideComponent != null && this.extraComponent != null) {
            return GuiUtils.vbox(this.extraComponent, this.strideComponent);
        }
        return this.strideComponent;
    }

    public JComponent getAreaComponent() {
        if (this.areaComponent == null && this.mapPanel != null) {
            JLabel tmp = new JLabel(" ");
            Font font = tmp.getFont();
            font = font.deriveFont((float)font.getSize() - 2.0f);
            this.mapPanel.setPreferredSize(new Dimension(100, 100));
            this.ulLatLon.getLatField().setColumns(4);
            this.ulLatLon.getLonField().setColumns(4);
            this.lrLatLon.getLonField().setColumns(4);
            this.lrLatLon.getLatField().setColumns(4);
            GuiUtils.setFontOnTree(this.latLonPanel, font);
            GuiUtils.tmpInsets = new Insets(3, 0, 0, 0);
            this.latLonPanel = GuiUtils.vbox(GuiUtils.wrap(this.ulLatLon.getLatField()), GuiUtils.hbox((Component)this.ulLatLon.getLonField(), (Component)this.lrLatLon.getLonField(), 3), GuiUtils.wrap(this.lrLatLon.getLatField()));
            JPanel leftPanel = GuiUtils.vbox(this.latLonPanel, this.indexCbx);
            this.areaComponent = this.mapPanel;
        }
        return this.areaComponent;
    }

    private LatLonRect getLatLonRect() {
        if (this.ulLatLon != null && this.ulLatLon.isLatLonDefined() && this.lrLatLon.isLatLonDefined()) {
            LatLonPointImpl ul = new LatLonPointImpl(this.ulLatLon.getLat(), this.ulLatLon.getLon());
            LatLonPointImpl lr = new LatLonPointImpl(this.lrLatLon.getLat(), this.lrLatLon.getLon());
            return new LatLonRect(ul, lr);
        }
        return this.mapPanel.getNavigatedPanel().getSelectedEarthRegion();
    }

    private void setBoundsFromFields() {
        NavigatedPanel np = this.mapPanel.getNavigatedPanel();
        np.setSelectedRegion(this.getLatLonRect());
        this.mapPanel.repaint();
    }

    public void reSetBoundsFromFields() {
        NavigatedPanel np = this.mapPanel.getNavigatedPanel();
        np.setSelectedRegion((LatLonRect)null);
        np.repaint();
        this.mapPanel.repaint();
    }

    public boolean getEnabled() {
        if (this.enabledCbx == null) {
            return true;
        }
        return this.enabledCbx.isSelected();
    }

    public GeoSelection getGeoSelection() {
        this.applyProperties(this.geoSelection);
        return new GeoSelection(this.geoSelection);
    }

    public boolean applyProperties(GeoSelection geoSelection) {
        if (this.xStrideBox != null) {
            geoSelection.setXStride(GuiUtils.getValueFromBox(this.xStrideBox));
            if (geoSelection.getXStride() == 1) {
                // empty if block
            }
        }
        if (this.yStrideBox != null) {
            geoSelection.setYStride(GuiUtils.getValueFromBox(this.yStrideBox));
            if (geoSelection.getYStride() == 1) {
                // empty if block
            }
        }
        if (this.zStrideBox != null) {
            geoSelection.setZStride(GuiUtils.getValueFromBox(this.zStrideBox));
            if (geoSelection.getZStride() == 1) {
                // empty if block
            }
        }
        if (this.useDisplayAreaCbx != null) {
            geoSelection.setUseViewBounds(this.useDisplayAreaCbx.isSelected());
        }
        if (this.mapPanel != null) {
            LatLonRect llr = this.getLatLonRect();
            if (llr == null) {
                geoSelection.setBoundingBox(null);
                if (this.enabledCbx != null && this.enabledCbx.isSelected()) {
                    geoSelection.setUseFullBounds(true);
                }
            } else {
                geoSelection.setBoundingBox(new GeoLocationInfo(llr));
            }
        }
        return true;
    }

    public boolean getUseDisplayArea() {
        if (this.useDisplayAreaCbx != null) {
            return this.useDisplayAreaCbx.isSelected();
        }
        return false;
    }

    public void enableZComponents(boolean enable) {
        GuiUtils.enableTree(this.strideComponent, enable);
        this.xStrideBox.setEnabled(!enable);
        this.yStrideBox.setEnabled(!enable);
    }

    protected void selectedRegionChanged(LatLonRect llr) {
        if (this.ulLatLon == null) {
            return;
        }
        GuiUtils.enableTree(this.latLonPanel, llr != null);
        if (llr == null) {
            return;
        }
        LatLonPointImpl ul = llr.getUpperLeftPoint();
        LatLonPointImpl lr = llr.getLowerRightPoint();
        DisplayConventions dc = DisplayConventions.getDisplayConventions();
        this.ulLatLon.setLatLon(ul.getLatitude(), ul.getLongitude());
        this.lrLatLon.setLatLon(lr.getLatitude(), lr.getLongitude());
    }

    public static class MyNavigatedMapPanel
    extends NavigatedMapPanel {
        GeoSelectionPanel geoPanel;
        private List points = new ArrayList();

        public MyNavigatedMapPanel(GeoSelectionPanel geoPanel, ProjectionImpl sampleProjection, boolean fullVersion) {
            super(true, fullVersion);
            this.geoPanel = geoPanel;
            NavigatedPanel np = this.getNavigatedPanel();
            if (sampleProjection != null) {
                this.setProjectionImpl(sampleProjection);
                ProjectionRect r = np.normalizeRectangle(sampleProjection.getDefaultMapArea());
                np.setSelectedRegionBounds(r);
                this.points.add(new ProjectionPointImpl(r.getX(), r.getY()));
                this.points.add(new ProjectionPointImpl(r.getX() + r.getWidth(), r.getY()));
                this.points.add(new ProjectionPointImpl(r.getX() + r.getWidth(), r.getY() + r.getHeight()));
                this.points.add(new ProjectionPointImpl(r.getX(), r.getY() + r.getHeight()));
            }
            np.setSelectRegionMode(true);
            if (geoPanel.geoSelection.getBoundingBox() != null) {
                np.setSelectedRegion(geoPanel.geoSelection.getBoundingBox().getLatLonRect());
            }
            np.zoom(0.6);
        }

        @Override
        public void resetBounds(ProjectionRect r) {
            NavigatedPanel np = this.getNavigatedPanel();
            if (r != null) {
                this.points = new ArrayList();
                np.setSelectedRegionBounds(r);
                this.points.add(new ProjectionPointImpl(r.getX(), r.getY()));
                this.points.add(new ProjectionPointImpl(r.getX() + r.getWidth(), r.getY()));
                this.points.add(new ProjectionPointImpl(r.getX() + r.getWidth(), r.getY() + r.getHeight()));
                this.points.add(new ProjectionPointImpl(r.getX(), r.getY() + r.getHeight()));
            }
            np.setSelectRegionMode(true);
            if (this.geoPanel.geoSelection.getBoundingBox() != null) {
                np.setSelectedRegion(this.geoPanel.geoSelection.getBoundingBox().getLatLonRect());
            }
            np.zoom(0.6);
        }

        protected void _selectedRegionChanged(LatLonRect llr) {
            this.geoPanel.selectedRegionChanged(llr);
        }

        @Override
        protected NavigatedPanel doMakeMapPanel() {
            return new NavigatedPanel(){

                @Override
                protected void selectedRegionChanged() {
                    super.selectedRegionChanged();
                    LatLonRect llr = this.getSelectedEarthRegion();
                    this._selectedRegionChanged(llr);
                }
            };
        }

        @Override
        protected void annotateMap(Graphics2D gNP) {
            super.annotateMap(gNP);
            NavigatedPanel np = this.getNavigatedPanel();
            if (this.points.size() == 0) {
                return;
            }
            GeneralPath path = new GeneralPath(0, this.points.size());
            for (int i = 0; i <= this.points.size(); ++i) {
                ProjectionPoint ppi = i >= this.points.size() ? (ProjectionPoint)this.points.get(0) : (ProjectionPoint)this.points.get(i);
                if (i == 0) {
                    path.moveTo((float)ppi.getX(), (float)ppi.getY());
                    continue;
                }
                path.lineTo((float)ppi.getX(), (float)ppi.getY());
            }
            gNP.draw(path);
        }
    }
}

