/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.data;

import java.awt.geom.Rectangle2D;
import ucar.unidata.data.GeoLocationInfo;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.util.HashCodeUtils;
import ucar.unidata.util.Misc;
import visad.Real;

public class GeoSelection {
    private static GeoLocationInfo defaultBoundingBox = null;
    public static final int STRIDE_NONE = 0;
    public static final int STRIDE_BASE = 1;
    private GeoLocationInfo boundingBox;
    private boolean useFullBounds = false;
    private boolean useViewBounds = false;
    private int xStride = 0;
    private int yStride = 0;
    private int zStride = 0;
    private Real level;
    Rectangle2D screenBoundRect;

    public GeoSelection() {
    }

    public GeoSelection(Real level) {
        this();
        this.level = level;
    }

    public GeoSelection(GeoSelection that) {
        this();
        this.useFullBounds = that.useFullBounds;
        if (that.boundingBox != null) {
            this.boundingBox = that.boundingBox;
        }
        this.xStride = that.xStride;
        this.yStride = that.yStride;
        this.zStride = that.zStride;
        this.level = that.level;
        if (that.screenBoundRect != null) {
            this.screenBoundRect = that.screenBoundRect;
        }
        this.useViewBounds = that.useViewBounds;
    }

    public GeoSelection(GeoLocationInfo boundingBox) {
        this(boundingBox, 0);
    }

    public GeoSelection(GeoLocationInfo boundingBox, int stride) {
        this(boundingBox, stride, stride, stride);
    }

    public GeoSelection(GeoLocationInfo boundingBox, int xStride, int yStride, int zStride) {
        this(boundingBox, xStride, yStride, zStride, null);
    }

    public GeoSelection(GeoLocationInfo boundingBox, int xStride, int yStride, int zStride, Real level) {
        this(boundingBox, false, xStride, yStride, zStride, level);
    }

    public GeoSelection(GeoLocationInfo boundingBox, boolean useFullBounds, int xStride, int yStride, int zStride, Real level) {
        this(boundingBox, useFullBounds, xStride, yStride, zStride, level, null);
    }

    public GeoSelection(GeoLocationInfo boundingBox, boolean useFullBounds, int xStride, int yStride, int zStride, Real level, Rectangle2D screenBoundRect) {
        this(boundingBox, useFullBounds, xStride, yStride, zStride, level, screenBoundRect, false);
    }

    public GeoSelection(GeoLocationInfo boundingBox, boolean useFullBounds, int xStride, int yStride, int zStride, Real level, Rectangle2D screenBoundRect, boolean useViewBounds) {
        this.boundingBox = boundingBox;
        this.useFullBounds = useFullBounds;
        this.xStride = xStride;
        this.yStride = yStride;
        this.zStride = zStride;
        this.level = level;
        this.screenBoundRect = screenBoundRect;
        this.useViewBounds = useViewBounds;
    }

    public static GeoLocationInfo getDefaultBoundingBox() {
        if (defaultBoundingBox != null) {
            return new GeoLocationInfo(defaultBoundingBox);
        }
        return null;
    }

    public static void setDefaultBoundingBox(GeoLocationInfo defaultBox) {
        defaultBoundingBox = defaultBox;
    }

    public void setLatLonRect(Rectangle2D rect) {
        this.boundingBox = new GeoLocationInfo(rect);
    }

    public LatLonRect getLatLonRect() {
        if (this.boundingBox == null) {
            return null;
        }
        LatLonPointImpl ul = new LatLonPointImpl(this.boundingBox.getMaxLat(), this.boundingBox.getMinLon());
        LatLonPointImpl lr = new LatLonPointImpl(this.boundingBox.getMinLat(), this.boundingBox.getMaxLon());
        return new LatLonRect(ul, lr);
    }

    public boolean getHasValidState() {
        return this.hasSpatialSubset() || this.hasStride();
    }

    public boolean hasSpatialSubset() {
        return this.useFullBounds || this.boundingBox != null;
    }

    public boolean getHasNonOneStride() {
        return this.hasStride() && (this.xStride != 0 && this.xStride != 1 || this.yStride != 0 && this.yStride != 1 || this.zStride != 0 && this.zStride != 1);
    }

    public static GeoSelection merge(GeoSelection highPriority, GeoSelection lowPriority) {
        if (highPriority == null && lowPriority == null) {
            return null;
        }
        if (highPriority == null) {
            return new GeoSelection(lowPriority);
        }
        if (lowPriority == null) {
            return new GeoSelection(highPriority);
        }
        int xStride = highPriority.hasXStride() ? highPriority.xStride : lowPriority.xStride;
        int yStride = highPriority.hasYStride() ? highPriority.yStride : lowPriority.yStride;
        int zStride = highPriority.hasZStride() ? highPriority.zStride : lowPriority.zStride;
        GeoLocationInfo bbox = highPriority.boundingBox != null ? highPriority.boundingBox : lowPriority.boundingBox;
        Rectangle2D screenBoundRect = highPriority.screenBoundRect;
        if (highPriority.getUseFullBounds() && highPriority.boundingBox == null) {
            bbox = null;
        }
        Real level = highPriority.level != null ? highPriority.level : lowPriority.level;
        GeoSelection newOne = new GeoSelection(bbox, highPriority.getUseFullBounds(), xStride, yStride, zStride, level, screenBoundRect);
        return newOne;
    }

    public void setStride(int value) {
        this.xStride = value;
        this.yStride = value;
        this.zStride = value;
    }

    public void clearStride() {
        this.xStride = 0;
        this.yStride = 0;
        this.zStride = 0;
    }

    public boolean hasXStride() {
        return this.xStride != 0;
    }

    public boolean hasYStride() {
        return this.yStride != 0;
    }

    public boolean hasZStride() {
        return this.zStride != 0;
    }

    public boolean hasStride() {
        return this.hasXStride() || this.hasYStride() || this.hasZStride();
    }

    public void setXStride(int value) {
        this.xStride = value;
    }

    public int getXStride() {
        return this.xStride;
    }

    public int getXStrideToUse() {
        return this.hasXStride() ? this.xStride : 1;
    }

    public void setYStride(int value) {
        this.yStride = value;
    }

    public int getYStride() {
        return this.yStride;
    }

    public int getYStrideToUse() {
        return this.hasYStride() ? this.yStride : 1;
    }

    public void setZStride(int value) {
        this.zStride = value;
    }

    public int getZStride() {
        return this.zStride;
    }

    public int getZStrideToUse() {
        return this.hasZStride() ? this.zStride : 1;
    }

    public void setBoundingBox(GeoLocationInfo value) {
        this.boundingBox = value;
    }

    public GeoLocationInfo getBoundingBox() {
        return this.boundingBox;
    }

    public String toString() {
        return "x:" + this.xStride + " " + "y:" + this.yStride + " " + "z:" + this.zStride + " bbox:" + this.boundingBox;
    }

    public void setLevel(Real value) {
        this.level = value;
    }

    public Real getLevel() {
        return this.level;
    }

    public int hashCode() {
        int seed = this.boundingBox != null ? this.boundingBox.hashCode() : 23;
        return HashCodeUtils.hash(HashCodeUtils.hash(HashCodeUtils.hash(seed, this.xStride), this.yStride), this.zStride);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof GeoSelection)) {
            return false;
        }
        GeoSelection that = (GeoSelection)obj;
        return this.xStride == that.xStride && this.yStride == that.yStride && this.zStride == that.zStride && this.useViewBounds == that.useViewBounds && this.useFullBounds == that.useFullBounds && Misc.equals(this.boundingBox, that.boundingBox) && Misc.equals(this.level, that.level) && Misc.equals(this.screenBoundRect, that.screenBoundRect);
    }

    public void setUseFullBounds(boolean value) {
        this.useFullBounds = value;
    }

    public boolean getUseFullBounds() {
        return this.useFullBounds;
    }

    public void setUseViewBounds(boolean value) {
        this.useViewBounds = value;
    }

    public boolean getUseViewBounds() {
        return this.useViewBounds;
    }

    public void setScreenBound(Rectangle2D screenBoundRect) {
        this.screenBoundRect = screenBoundRect;
    }

    public Rectangle2D getScreenBound() {
        return this.screenBoundRect;
    }
}

