/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.data;

import java.awt.geom.Rectangle2D;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.LatLonRect;

public class GeoLocationInfo {
    private double maxLat;
    private double minLon;
    private double minLat;
    private double maxLon;

    public GeoLocationInfo() {
    }

    public GeoLocationInfo(GeoLocationInfo that) {
        this.maxLat = that.maxLat;
        this.minLat = that.minLat;
        this.minLon = that.minLon;
        this.maxLon = that.maxLon;
    }

    public GeoLocationInfo(Rectangle2D rect) {
        this(rect.getY() + rect.getHeight(), rect.getX(), rect.getY(), rect.getX() + rect.getWidth());
    }

    public GeoLocationInfo(double maxLat, double minLon, double minLat, double maxLon) {
        this.maxLat = Math.max(maxLat, minLat);
        this.minLat = Math.min(maxLat, minLat);
        if (minLon >= 0.0 && maxLon >= 0.0 || minLon <= 0.0 && maxLon <= 0.0) {
            this.minLon = Math.min(minLon, maxLon);
            this.maxLon = Math.max(minLon, maxLon);
        } else {
            this.minLon = minLon;
            this.maxLon = maxLon;
        }
    }

    public GeoLocationInfo(LatLonRect llr) {
        LatLonPointImpl ul = llr.getUpperLeftPoint();
        LatLonPointImpl lr = llr.getLowerRightPoint();
        this.maxLat = ul.getLatitude();
        this.minLat = lr.getLatitude();
        this.maxLon = lr.getLongitude();
        this.minLon = ul.getLongitude();
    }

    public GeoLocationInfo union(GeoLocationInfo that) {
        return new GeoLocationInfo(Math.max(this.maxLat, that.maxLat), Math.min(this.minLon, that.minLon), Math.min(this.minLat, that.minLat), Math.max(this.maxLon, that.maxLon));
    }

    public LatLonRect getLatLonRect() {
        return new LatLonRect(this.getUpperLeft(), this.getLowerRight());
    }

    public LatLonPoint getUpperLeft() {
        return new LatLonPointImpl(this.maxLat, this.minLon);
    }

    public LatLonPoint getLowerRight() {
        return new LatLonPointImpl(this.minLat, this.maxLon);
    }

    private double inRange(double v, double min, double max) {
        return Math.min(Math.max(v, min), max);
    }

    private void ensureOrder() {
        double tmp;
        if (this.minLat > this.maxLat) {
            tmp = this.minLat;
            this.minLat = this.maxLat;
            this.maxLat = tmp;
        }
        if (this.minLon > this.maxLon) {
            tmp = this.minLon;
            this.minLon = this.maxLon;
            this.maxLon = tmp;
        }
    }

    public void snapToGrid() {
        double diffx = this.getDegreesX();
        double diffy = this.getDegreesY();
        double factorX = 0.0;
        double factorY = 0.0;
        if (diffx > 10.0) {
            factorX = 1.0;
        } else if (diffx > 1.0) {
            factorX = 10.0;
        } else if (diffx > 0.1) {
            factorX = 100.0;
        } else if (diffx > 0.01) {
            factorX = 1000.0;
        }
        if (diffy > 10.0) {
            factorY = 1.0;
        } else if (diffy > 1.0) {
            factorY = 10.0;
        } else if (diffy > 0.1) {
            factorY = 100.0;
        } else if (diffy > 0.01) {
            factorY = 1000.0;
        }
        if (factorX != 0.0) {
            this.minLon = Math.floor(factorX * this.minLon) / factorX;
            this.maxLon = Math.ceil(factorX * this.maxLon) / factorX;
        }
        if (factorY != 0.0) {
            this.minLat = Math.floor(factorY * this.minLat) / factorY;
            this.maxLat = Math.ceil(factorY * this.maxLat) / factorY;
        }
    }

    public void rectify(GeoLocationInfo that, double minResolution) {
        this.minLon = this.inRange(this.minLon, that.minLon, that.maxLon);
        this.maxLon = this.inRange(this.maxLon, that.minLon, that.maxLon);
        this.minLat = this.inRange(this.minLat, that.minLat, that.maxLat);
        this.maxLat = this.inRange(this.maxLat, that.minLat, that.maxLat);
        this.ensureOrder();
        if (this.maxLat - this.minLat < minResolution) {
            this.maxLat = this.minLat + minResolution;
            this.maxLon = this.minLon + minResolution;
        }
        if (this.maxLon - this.minLon < minResolution) {
            this.maxLon = this.minLon + minResolution;
            this.maxLat = this.minLat + minResolution;
        }
    }

    public double getDegreesX() {
        return this.maxLon - this.minLon;
    }

    public double getDegreesY() {
        return this.maxLat - this.minLat;
    }

    public void setMaxLat(double value) {
        this.maxLat = value;
    }

    public double getMaxLat() {
        return this.maxLat;
    }

    public void setMinLon(double value) {
        this.minLon = value;
    }

    public double getMinLon() {
        return this.minLon;
    }

    public void setMinLat(double value) {
        this.minLat = value;
    }

    public double getMinLat() {
        return this.minLat;
    }

    public void setMaxLon(double value) {
        this.maxLon = value;
    }

    public double getMaxLon() {
        return this.maxLon;
    }

    public String toString() {
        return " lat: (" + this.maxLat + " - " + this.minLat + ") lon: (" + this.minLon + " - " + this.maxLon + ")";
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof GeoLocationInfo)) {
            return false;
        }
        GeoLocationInfo that = (GeoLocationInfo)obj;
        return this.maxLat == that.maxLat && this.minLat == that.minLat && this.maxLon == that.maxLon && this.minLon == that.minLon;
    }
}

