/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.data;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import ucar.unidata.data.DataSourceDescriptor;
import ucar.unidata.data.DataSourceImpl;
import ucar.unidata.util.IOUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.PollingInfo;

public abstract class FilesDataSource
extends DataSourceImpl {
    protected List sources;
    protected List adapters;
    protected String oldSourceFromBundles;

    public FilesDataSource() {
    }

    public FilesDataSource(DataSourceDescriptor descriptor) {
        super(descriptor);
    }

    public FilesDataSource(DataSourceDescriptor descriptor, String name, String description, Hashtable properties) {
        this(descriptor, Misc.newList(name), name, description, properties);
    }

    public FilesDataSource(DataSourceDescriptor descriptor, List newSources, String description, Hashtable properties) {
        this(descriptor, newSources, newSources.get(0).toString(), description, properties);
    }

    public FilesDataSource(DataSourceDescriptor descriptor, List newSources, String name, String description, Hashtable properties) {
        super(descriptor, name, description, properties);
        int idx = name.indexOf("?");
        if (idx >= 0) {
            name = name.substring(0, idx);
            this.setName(name);
        }
        if (this.getName().length() == 0) {
            if (newSources.size() > 0) {
                String s = newSources.get(0).toString();
                idx = s.indexOf("?");
                if (idx >= 0) {
                    s = s.substring(0, idx);
                }
                this.setName(s);
            } else {
                this.setName(description);
            }
        }
        this.sources = newSources;
    }

    @Override
    public List getDataPaths() {
        return this.sources;
    }

    protected boolean isFileBased() {
        if (this.sources.size() == 0) {
            return false;
        }
        return new File(this.sources.get(0).toString()).exists();
    }

    protected String getDataFileExtension(String file) {
        return IOUtil.getFileExtension(file).trim();
    }

    protected String processDataFilename(String filename, int index) {
        int idx = filename.indexOf("?");
        if (idx >= 0) {
            // empty if block
        }
        return filename;
    }

    @Override
    protected List saveDataToLocalDisk(String prefix, Object loadId, boolean changeLinks) throws Exception {
        ArrayList<String> processedSources = new ArrayList<String>();
        for (int i = 0; i < this.sources.size(); ++i) {
            String source = this.sources.get(i).toString();
            String file = this.processDataFilename(source, i);
            if (file == null) continue;
            processedSources.add(file);
        }
        String extension = this.getDataFileExtension(this.sources.get(0).toString());
        List newFiles = IOUtil.writeTo(this.getInputStreams(processedSources), prefix, extension, loadId);
        if (newFiles != null && changeLinks) {
            this.setNewFiles(newFiles);
        }
        return newFiles;
    }

    protected List getInputStreams(List processedSources) throws Exception {
        ArrayList<InputStream> is = new ArrayList<InputStream>();
        for (int i = 0; i < processedSources.size(); ++i) {
            is.add(IOUtil.getInputStream(processedSources.get(i).toString(), this.getClass()));
        }
        return is;
    }

    @Override
    public void initAfterCreation() {
        this.initWithPollingInfo();
        super.initAfterCreation();
    }

    @Override
    public String getPartialDescription() {
        String desc = super.getFullDescription();
        if (this.sources != null && this.sources.size() > 0) {
            desc = desc + "<p><b>Files:</b><ul>";
            for (int i = 0; i < this.sources.size(); ++i) {
                desc = desc + "<li>" + this.sources.get(i) + "\n";
            }
            desc = desc + "</ul>";
        }
        return desc;
    }

    @Override
    public String getFullDescription() {
        return this.getPartialDescription();
    }

    public boolean haveSources() {
        return this.sources != null && this.sources.size() > 0;
    }

    @Override
    public void initAfterUnpersistence() {
        List tmpPaths;
        if (this.oldSourceFromBundles != null) {
            this.sources = Misc.newList(this.oldSourceFromBundles);
            this.oldSourceFromBundles = null;
        }
        if ((tmpPaths = this.getTmpPaths()) != null) {
            this.sources = new ArrayList(tmpPaths);
            this.setTmpPaths(null);
        }
        super.initAfterUnpersistence();
        this.initWithPollingInfo();
    }

    @Override
    public void updateState(Object newObject, Hashtable newProperties) {
        super.updateState(newObject, newProperties);
        if (newObject instanceof List) {
            List newSources = (List)newObject;
            if (newSources.size() > 0 && newSources.get(0) instanceof String) {
                this.sources = new ArrayList(newSources);
            }
        } else if (newObject instanceof String) {
            this.sources = Misc.newList(newObject);
        }
    }

    protected void initWithPollingInfo() {
        PollingInfo pollingInfo = this.getPollingInfo();
        if (pollingInfo.doILookForNewFiles()) {
            this.adapters = null;
            this.sources = pollingInfo.getFiles();
            this.sourcesChanged();
        }
    }

    @Override
    protected void propertiesChanged() {
        List newSources;
        PollingInfo pollingInfo = this.getPollingInfo();
        if (pollingInfo.doILookForNewFiles() && !Misc.equals(this.sources, newSources = pollingInfo.getFiles())) {
            this.adapters = null;
            this.sources = newSources;
            this.sourcesChanged();
        }
        super.propertiesChanged();
    }

    @Override
    public void setNewFiles(List files) {
        this.setTmpPaths(null);
        this.sources = new ArrayList();
        for (int i = 0; i < files.size(); ++i) {
            this.sources.add(files.get(i).toString());
        }
        this.adapters = null;
        this.sourcesChanged();
    }

    protected void sourcesChanged() {
        this.clearTimes();
        this.dataChoices = null;
        this.getDataChoices();
        this.getDataContext().dataSourceChanged(this);
        this.reloadData();
    }

    @Override
    public void reloadData(Object object, Hashtable properties) {
        if (object instanceof String) {
            this.sources = Misc.newList(object);
        } else if (object instanceof List) {
            this.sources = (List)object;
        } else {
            throw new IllegalArgumentException("Unkown data:" + object);
        }
        this.reloadProperties(properties);
        this.sourcesChanged();
    }

    @Override
    protected List getLocationsForPolling() {
        if (this.sources == null) {
            return null;
        }
        return new ArrayList(this.sources);
    }

    @Override
    public void newFilesFromPolling(List files) {
        this.adapters = null;
        this.initWithPollingInfo();
        this.notifyDataChange();
    }

    @Override
    public void doRemove() {
        super.doRemove();
        this.adapters = null;
    }

    @Override
    public void reloadData() {
        this.adapters = null;
        super.reloadData();
    }

    protected String getFilePath() {
        if (this.sources != null && this.sources.size() > 0) {
            return (String)this.sources.get(0);
        }
        return null;
    }

    public void setSources(List value) {
        this.sources = value;
    }

    public List getSources() {
        return this.sources;
    }

    protected String getSource() {
        if (this.sources != null && this.sources.size() > 0) {
            return this.sources.get(0).toString();
        }
        return null;
    }

    public void setSource(String value) {
        this.sources = Misc.newList(value);
    }

    @Override
    public boolean equals(Object that) {
        if (!super.equals(that)) {
            return false;
        }
        return Misc.equals(this.sources, ((FilesDataSource)that).sources);
    }
}

