/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.data;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import ucar.unidata.data.DataCancelException;
import ucar.unidata.data.DataCategory;
import ucar.unidata.data.DataChangeListener;
import ucar.unidata.data.DataChoice;
import ucar.unidata.data.DataSelection;
import ucar.unidata.data.DataSource;
import ucar.unidata.data.DataSourceImpl;
import ucar.unidata.util.TwoFacedObject;
import visad.Data;
import visad.VisADException;

public class DirectDataChoice
extends DataChoice {
    public static final String PROP_WRITEDATASOURCE = "prop.writedatasource";
    protected DataSource dataSource;

    public DirectDataChoice() {
    }

    public DirectDataChoice(DataSource dataSource, Object id, String name, String description, List categories, Hashtable properties) {
        this(dataSource, id, name, description, categories, NULL_DATASELECTION, properties);
    }

    public DirectDataChoice(DataSource dataSource, Object id, String name, String description, List categories) {
        this(dataSource, id, name, description, categories, NULL_DATASELECTION, NULL_PROPERTIES);
    }

    public DirectDataChoice(DataSource dataSource, Object id, String name, String description, List categories, DataSelection dataSelection) {
        this(dataSource, id, name, description, categories, dataSelection, NULL_PROPERTIES);
    }

    public DirectDataChoice(DataSource dataSource, Object id, String name, String description, List categories, DataSelection dataSelection, Hashtable properties) {
        super(id, name, description, categories, properties);
        if (dataSource.canAddCurrentName(this)) {
            DirectDataChoice.addCurrentName(new TwoFacedObject((Object)(DataSourceImpl.getNameForDataSource(dataSource, 30, true) + ">" + name), name));
        }
        this.myDataSelection = dataSelection;
        this.dataSource = dataSource;
    }

    public DirectDataChoice(DirectDataChoice other) {
        super(other);
        this.dataSource = other.dataSource;
    }

    @Override
    public DataChoice cloneMe() {
        return new DirectDataChoice(this);
    }

    @Override
    public void getFinalDataChoices(List finalDataChoices) {
        super.getFinalDataChoices(finalDataChoices);
        finalDataChoices.add(this);
    }

    @Override
    public String getFullDescription() {
        return super.getFullDescription() + " from: <br>" + this.dataSource.getPartialDescription();
    }

    @Override
    public void getDataSources(List dataSources) {
        dataSources.add(this.dataSource);
    }

    @Override
    public List getAllLevels(DataSelection dataSelection) {
        return this.dataSource.getAllLevels(this, DataSelection.merge(dataSelection, this.myDataSelection));
    }

    @Override
    public List getAllDateTimes() {
        return this.dataSource.getAllDateTimes(this);
    }

    @Override
    public List getSelectedDateTimes() {
        List mine = super.getSelectedDateTimes();
        List theDataSources = this.dataSource.getSelectedDateTimes();
        if (theDataSources == null) {
            return mine;
        }
        if (mine == null) {
            mine = this.getAllDateTimes();
        }
        mine = DataSourceImpl.getDateTimes(mine, this.getAllDateTimes());
        theDataSources = DataSourceImpl.getDateTimes(theDataSources, this.dataSource.getAllDateTimes());
        SortedSet uniqueTimes = Collections.synchronizedSortedSet(new TreeSet());
        ArrayList finalResult = new ArrayList();
        for (int i = 0; i < theDataSources.size(); ++i) {
            Object tmp = theDataSources.get(i);
            if (!mine.contains(tmp)) continue;
            uniqueTimes.add(tmp);
        }
        return new ArrayList(uniqueTimes);
    }

    @Override
    public void initAfterUnPersistence(Hashtable properties) {
        super.initAfterUnPersistence(properties);
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource s) {
        this.dataSource = s;
    }

    @Override
    protected Data getData(DataCategory category, DataSelection dataSelection, Hashtable requestProperties) throws VisADException, RemoteException, DataCancelException {
        Data data = this.dataSource.getData(this, category, DataSelection.merge(dataSelection, this.myDataSelection), requestProperties);
        return data;
    }

    @Override
    public int hashCode() {
        DataSource myDataSource = this.dataSource;
        if (myDataSource == null) {
            return super.hashCode();
        }
        return myDataSource.hashCode() ^ super.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof DirectDataChoice)) {
            return false;
        }
        return super.equals(o) && ((DirectDataChoice)o).dataSource.equals(this.dataSource);
    }

    @Override
    public boolean basicallyEquals(DataChoice that) {
        if (!super.basicallyEquals(that)) {
            return false;
        }
        return ((DirectDataChoice)that).dataSource.equals(this.dataSource);
    }

    @Override
    public void addDataChangeListener(DataChangeListener listener) {
        DataSource tmpDataSource = this.dataSource;
        if (tmpDataSource != null) {
            tmpDataSource.addDataChangeListener(listener);
        }
    }

    @Override
    public void removeDataChangeListener(DataChangeListener listener) {
        DataSource tmpDataSource = this.dataSource;
        if (tmpDataSource != null) {
            tmpDataSource.removeDataChangeListener(listener);
        }
    }
}

