/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.data;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import ucar.unidata.data.DataAlias;
import ucar.unidata.data.DataCategory;
import ucar.unidata.data.DataChoice;
import ucar.unidata.data.DataGroup;
import ucar.unidata.data.DerivedDataDescriptor;
import ucar.unidata.data.UnboundDataChoice;
import ucar.unidata.data.UserDataChoice;
import ucar.unidata.util.Misc;
import ucar.unidata.util.StringUtil;

public class DerivedNeed {
    private List paramSets = new ArrayList();
    private Hashtable usedThemBefore;
    protected String categories;
    private List categoryList;
    private String groupName;
    private DerivedDataDescriptor ddd;

    public DerivedNeed(DerivedDataDescriptor ddd, String categories) {
        this.ddd = ddd;
        this.categories = categories;
    }

    public DerivedNeed(DerivedDataDescriptor ddd, String groupName, String categories) {
        this(ddd, categories);
        this.groupName = groupName;
        this.reInitialize();
    }

    public DerivedNeed(DerivedDataDescriptor ddd, List params, String categories) {
        this(ddd, categories);
        this.paramSets = Misc.newList(params);
    }

    protected void reInitialize() {
        if (this.groupName != null) {
            DataGroup group = DataGroup.getDataGroup(this.groupName);
            this.paramSets = group != null ? group.getParamSets() : new ArrayList();
        }
    }

    public String getGroupName() {
        return this.groupName;
    }

    public List getParamSets() {
        return this.paramSets;
    }

    public boolean equals(Object other) {
        if (!(other instanceof DerivedNeed)) {
            return false;
        }
        DerivedNeed that = (DerivedNeed)other;
        return this.paramSets.equals(that.paramSets) && Misc.equals(this.groupName, that.groupName) && Misc.equals(this.categories, that.categories);
    }

    public List getDataChoices(Hashtable choicesSoFar) {
        for (int i = 0; i < this.paramSets.size(); ++i) {
            List[] result = this.getDataChoicesFromParams(choicesSoFar, (List)this.paramSets.get(i));
            if (result == null) continue;
            List dataChoices = result[0];
            List paramNames = result[1];
            for (int dataChoiceIdx = 0; dataChoiceIdx < dataChoices.size(); ++dataChoiceIdx) {
                DataChoice dataChoice = (DataChoice)dataChoices.get(dataChoiceIdx);
                Hashtable<DataChoice, DataChoice> usedChoices = (Hashtable<DataChoice, DataChoice>)this.usedThemBefore.get(dataChoiceIdx + "");
                if (usedChoices == null) {
                    usedChoices = new Hashtable<DataChoice, DataChoice>();
                    this.usedThemBefore.put(dataChoiceIdx + "", usedChoices);
                }
                usedChoices.put(dataChoice, dataChoice);
            }
            return dataChoices;
        }
        return null;
    }

    public void initForSearch() {
        this.usedThemBefore = new Hashtable();
    }

    public void clearAfterSearch() {
        this.usedThemBefore = null;
    }

    private List[] getDataChoicesFromParams(Hashtable choicesSoFar, List params) {
        boolean allMatched = true;
        ArrayList<DataChoice> dataChoices = null;
        ArrayList<String> paramNames = null;
        for (int paramIdx = 0; paramIdx < params.size(); ++paramIdx) {
            String param = (String)params.get(paramIdx);
            DataChoice dataChoice = this.getDataChoice(param, choicesSoFar, paramIdx);
            if (dataChoice == null) {
                allMatched = false;
                break;
            }
            if (dataChoices == null) {
                dataChoices = new ArrayList<DataChoice>();
                paramNames = new ArrayList<String>();
            }
            dataChoices.add(dataChoice);
            paramNames.add(param);
        }
        if (!allMatched) {
            return null;
        }
        return new List[]{dataChoices, paramNames};
    }

    private DataChoice getDataChoice(String paramName, Hashtable choicesSoFar, int paramIdx) {
        if (paramName.startsWith("*")) {
            return new UnboundDataChoice(paramName.substring(1));
        }
        if (paramName.startsWith("user:")) {
            return new UserDataChoice(paramName.substring(5).trim());
        }
        DataChoice choice = this.findDataChoice(paramName, choicesSoFar, paramIdx);
        if (choice != null) {
            return choice;
        }
        List aliasList = DataAlias.getAliasesOf(paramName);
        if (aliasList == null) {
            return null;
        }
        for (int i = 0; i < aliasList.size(); ++i) {
            choice = this.findDataChoice((String)aliasList.get(i), choicesSoFar, paramIdx);
            if (choice == null) continue;
            return choice;
        }
        return null;
    }

    private DataChoice findDataChoice(String paramName, Hashtable choicesSoFar, int paramIdx) {
        DataChoice dataChoice = null;
        String key = paramIdx + "";
        List choiceList = (List)choicesSoFar.get(paramName);
        if (choiceList == null && StringUtil.containsRegExp(paramName)) {
            Enumeration keys = choicesSoFar.keys();
            while (keys.hasMoreElements()) {
                String tmp = (String)keys.nextElement();
                if (!StringUtil.regexpMatch(tmp, paramName)) continue;
                choiceList = (List)choicesSoFar.get(tmp);
                break;
            }
        }
        if (choiceList == null) {
            return null;
        }
        for (int i = 0; i < choiceList.size(); ++i) {
            List cats;
            dataChoice = (DataChoice)choiceList.get(i);
            Hashtable usedChoices = (Hashtable)this.usedThemBefore.get(key);
            if (usedChoices != null && usedChoices.get(dataChoice) != null || (cats = this.getCategoryList()) != null && cats.size() > 0 && !DataCategory.applicableTo(cats, dataChoice.getCategories())) continue;
            return dataChoice;
        }
        return null;
    }

    public void setCategories(String value) {
        this.categories = value;
        this.categoryList = null;
    }

    public String getCategories() {
        return this.categories;
    }

    private List getCategoryList() {
        if (this.categoryList == null && this.categories != null) {
            this.categoryList = DataCategory.parseCategories(this.categories);
        }
        if (this.categoryList != null) {
            return this.categoryList;
        }
        return this.ddd.getOperandsCategoryList();
    }
}

