/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.data;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import ucar.unidata.data.DataCategory;
import ucar.unidata.data.DataChoice;
import ucar.unidata.data.DataContext;
import ucar.unidata.data.DerivedDataChoice;
import ucar.unidata.data.DerivedNeed;
import ucar.unidata.util.IOUtil;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.NamedList;
import ucar.unidata.util.StringUtil;
import ucar.unidata.xml.XmlResourceCollection;
import ucar.unidata.xml.XmlUtil;

public class DerivedDataDescriptor {
    public static final String NULL_STRING = null;
    static LogUtil.LogCategory log_ = LogUtil.getLogInstance(DerivedDataDescriptor.class.getName());
    public static List classes = new ArrayList();
    private static final String TAG_CATEGORIES = "categories";
    private static final String TAG_CATEGORY = "category";
    private static final String TAG_CLASS = "class";
    private static final String TAG_DERIVED = "derived";
    private static final String TAG_DERIVEDTOP = "derived_parameters";
    private static final String TAG_OPERANDS = "operands";
    private static final String TAG_PARAMS = "params";
    private static final String TAG_PARAMGROUP = "paramgroup";
    private static final String TAG_PROPERTIES = "properties";
    private static final String ATTR_APPEND = "append";
    private static final String ATTR_REPLACE = "replace";
    private static final String ATTR_CATEGORYIDX = "categoryidx";
    private static final String ATTR_CATEGORIES = "categories";
    private static final String ATTR_CHILDIDX = "childidx";
    private static final String ATTR_CODE = "code";
    private static final String ATTR_DESCRIPTION = "description";
    private static final String ATTR_FORMULA = "formula";
    private static final String ATTR_ID = "id";
    private static final String ATTR_INHERIT = "inherit";
    private static final String ATTR_ISDEFAULT = "isdefault";
    private static final String ATTR_ISENDUSER = "isenduser";
    private static final String ATTR_LABEL = "label";
    private static final String ATTR_METHOD = "method";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_PARAMPREFIX = "p";
    private static final String ATTR_VALUE = "value";
    private static final String ATTR_DISPLAY = "display";
    private List myNeeds = new ArrayList();
    private String operandsCategories;
    private List operandsCategoryList;
    String id;
    String description;
    String label;
    String method;
    String formula;
    String code;
    ArrayList categories;
    Properties properties;
    private boolean isLocalUsers = false;
    private boolean isEndUser = false;
    private boolean isDefault = false;
    private DataContext dataContext;
    StringBuffer sb = new StringBuffer();

    public DerivedDataDescriptor() {
    }

    public DerivedDataDescriptor(DataContext dataContext, String id, String desc, String formula, List categories) {
        this.dataContext = dataContext;
        this.categories = categories != null ? new ArrayList(categories) : new ArrayList();
        this.id = id;
        this.description = desc;
        this.label = desc;
        this.formula = formula;
        this.isEndUser = true;
    }

    public DerivedDataDescriptor(DataContext dataContext) {
        this.dataContext = dataContext;
        this.categories = new ArrayList();
    }

    private DerivedDataDescriptor(DataContext dataContext, Element derivedNode) {
        this.dataContext = dataContext;
        this.id = XmlUtil.getAttribute(derivedNode, ATTR_ID);
        this.description = XmlUtil.getAttribute((Node)derivedNode, ATTR_DESCRIPTION, "");
        this.label = XmlUtil.getAttribute((Node)derivedNode, ATTR_LABEL, NULL_STRING);
        this.method = XmlUtil.getAttribute((Node)derivedNode, ATTR_METHOD, NULL_STRING);
        this.code = XmlUtil.getAttribute((Node)derivedNode, ATTR_CODE, NULL_STRING);
        this.formula = XmlUtil.getAttribute((Node)derivedNode, ATTR_FORMULA, NULL_STRING);
        Element operandsNode = XmlUtil.findChild(derivedNode, TAG_OPERANDS);
        if (operandsNode != null) {
            this.processOperands(operandsNode);
        }
        this.categories = new ArrayList();
        Element categoriesNode = XmlUtil.findChild(derivedNode, "categories");
        if (categoriesNode != null) {
            List categoryNodes = XmlUtil.findChildren(categoriesNode, TAG_CATEGORY);
            for (int i = 0; i < categoryNodes.size(); ++i) {
                Element child = (Element)categoryNodes.get(i);
                DataCategory dataCategory = DataCategory.parseCategory(XmlUtil.getAttribute(child, ATTR_VALUE), XmlUtil.getAttribute((Node)child, ATTR_DISPLAY, false));
                int childIdx = XmlUtil.getAttribute((Node)child, ATTR_CHILDIDX, -1);
                int categoryIdx = XmlUtil.getAttribute((Node)child, ATTR_CATEGORYIDX, -1);
                String append = XmlUtil.getAttribute((Node)child, ATTR_APPEND, NULL_STRING);
                String replace = XmlUtil.getAttribute((Node)child, ATTR_REPLACE, NULL_STRING);
                dataCategory.setChildIndex(childIdx);
                dataCategory.setCategoryIndex(categoryIdx);
                dataCategory.setAppend(append);
                dataCategory.setReplace(replace);
                this.categories.add(dataCategory);
            }
        }
        this.properties = Misc.parseProperties(XmlUtil.getAttribute((Node)derivedNode, TAG_PROPERTIES, NULL_STRING));
        if (this.method == null && this.formula == null && this.code == null) {
            log_.error("processDerivedDataChoice: Unable to find method, formula or code for:" + this.id);
        }
        this.setIsEndUser(XmlUtil.getAttribute((Node)derivedNode, ATTR_ISENDUSER, false));
        this.setIsDefault(XmlUtil.getAttribute((Node)derivedNode, ATTR_ISDEFAULT, true));
    }

    public DerivedDataDescriptor(ArrayList needs, String id, String description, ArrayList categories, String method, String formula, String code, Properties properties) {
        this.setNeeds(needs);
        this.id = id;
        this.description = description;
        this.categories = categories;
        this.method = method;
        this.formula = formula;
        this.code = code;
        this.properties = properties;
    }

    public DerivedDataDescriptor(DerivedDataDescriptor other) {
        this.isEndUser = other.isEndUser;
        this.isLocalUsers = other.isLocalUsers;
        this.isDefault = other.isDefault;
        this.dataContext = other.dataContext;
        this.setNeeds(other.myNeeds);
        this.id = other.id;
        this.description = other.description;
        this.categories = (ArrayList)other.categories.clone();
        this.method = other.method;
        this.formula = other.formula;
        this.code = other.code;
        this.properties = other.properties == null ? null : (Properties)other.properties.clone();
    }

    protected List getOperandsCategoryList() {
        return this.operandsCategoryList;
    }

    private void processOperands(Element operandsNode) {
        NodeList children = operandsNode.getChildNodes();
        this.operandsCategories = XmlUtil.getAttribute((Node)operandsNode, "categories", NULL_STRING);
        if (this.operandsCategories != null) {
            if (this.operandsCategories.trim().length() == 0) {
                this.operandsCategories = null;
            } else {
                this.operandsCategoryList = DataCategory.parseCategories(this.operandsCategories);
            }
        }
        for (int operandsIdx = 0; operandsIdx < children.getLength(); ++operandsIdx) {
            Node child = children.item(operandsIdx);
            String needCategory = XmlUtil.getAttribute(child, "categories", "");
            if (needCategory.trim().length() == 0) {
                needCategory = null;
            }
            DerivedNeed derivedNeed = null;
            if (child.getNodeName().equals(TAG_PARAMS)) {
                String param;
                int paramIdx = 1;
                ArrayList<String> needList = new ArrayList<String>();
                while ((param = XmlUtil.getAttribute(child, ATTR_PARAMPREFIX + paramIdx++, NULL_STRING)) != null) {
                    needList.add(param);
                }
                derivedNeed = new DerivedNeed(this, needList, needCategory);
            } else if (child.getNodeName().equals(TAG_PARAMGROUP)) {
                String paramGroupName = XmlUtil.getAttribute(child, ATTR_NAME);
                derivedNeed = new DerivedNeed(this, paramGroupName, needCategory);
            }
            if (derivedNeed == null) continue;
            this.myNeeds.add(derivedNeed);
        }
        this.checkNeeds();
    }

    public List getNeeds() {
        if (this.myNeeds != null) {
            return new ArrayList(this.myNeeds);
        }
        return null;
    }

    public void setNeeds(List<DerivedNeed> needs) {
        this.myNeeds = needs != null ? new ArrayList<DerivedNeed>(needs) : null;
        this.checkNeeds();
    }

    private void checkNeeds() {
        if (this.myNeeds != null) {
            ArrayList tmp = new ArrayList();
            for (int i = 0; i < this.myNeeds.size(); ++i) {
                Object obj = this.myNeeds.get(i);
                if (!(obj instanceof DerivedNeed)) continue;
                tmp.add(obj);
            }
            this.myNeeds = tmp;
        }
    }

    public void setDataCategories(List categories) {
        this.categories = new ArrayList(categories);
    }

    public List getDataCategories() {
        return this.categories;
    }

    public void initForSearch() {
        if (this.myNeeds == null) {
            return;
        }
        for (int i = 0; i < this.myNeeds.size(); ++i) {
            DerivedNeed need = (DerivedNeed)this.myNeeds.get(i);
            need.initForSearch();
        }
    }

    public void clearAfterSearch() {
        for (int i = 0; i < this.myNeeds.size(); ++i) {
            DerivedNeed need = (DerivedNeed)this.myNeeds.get(i);
            need.clearAfterSearch();
        }
    }

    public DerivedDataChoice getDataChoice() {
        DerivedDataChoice ddc = new DerivedDataChoice(this.dataContext, this);
        if (this.properties != null) {
            ddc.setProperties(this.properties);
        }
        return ddc;
    }

    public NamedList getDataChoices(Hashtable choicesSoFar) {
        for (int i = 0; i < this.myNeeds.size(); ++i) {
            DerivedNeed need = (DerivedNeed)this.myNeeds.get(i);
            List dataChoices = need.getDataChoices(choicesSoFar);
            if (dataChoices == null) continue;
            return new NamedList(this.getDescription(), dataChoices);
        }
        return null;
    }

    public Element toXml(Document doc) {
        Element node = doc.createElement(TAG_DERIVED);
        node.setAttribute(ATTR_ID, this.id);
        node.setAttribute(ATTR_DESCRIPTION, this.description);
        if (this.method != null) {
            node.setAttribute(ATTR_METHOD, this.method);
        }
        if (this.formula != null) {
            node.setAttribute(ATTR_FORMULA, this.formula);
        }
        if (this.code != null) {
            node.setAttribute(ATTR_CODE, this.code);
        }
        node.setAttribute(ATTR_ISENDUSER, "" + this.getIsEndUser());
        node.setAttribute(ATTR_ISDEFAULT, "" + this.getIsDefault());
        Element categoriesNode = doc.createElement("categories");
        node.appendChild(categoriesNode);
        for (int i = 0; i < this.categories.size(); ++i) {
            DataCategory cat = (DataCategory)this.categories.get(i);
            Element categoryNode = doc.createElement(TAG_CATEGORY);
            categoriesNode.appendChild(categoryNode);
            categoryNode.setAttribute(ATTR_VALUE, cat.toString());
            if (cat.getForDisplay()) {
                categoryNode.setAttribute(ATTR_DISPLAY, "true");
            }
            if (cat.getAppend() != null) {
                categoryNode.setAttribute(ATTR_APPEND, cat.getAppend());
            }
            if (cat.getReplace() != null) {
                categoryNode.setAttribute(ATTR_REPLACE, cat.getReplace());
            }
            if (cat.getChildIndex() >= 0) {
                categoryNode.setAttribute(ATTR_CHILDIDX, "" + cat.getChildIndex());
            }
            if (cat.getCategoryIndex() < 0) continue;
            categoryNode.setAttribute(ATTR_CATEGORYIDX, "" + cat.getCategoryIndex());
        }
        Element opNode = doc.createElement(TAG_OPERANDS);
        if (this.operandsCategories != null) {
            opNode.setAttribute("categories", this.operandsCategories);
        }
        node.appendChild(opNode);
        for (int needIdx = 0; needIdx < this.myNeeds.size(); ++needIdx) {
            Element needNode;
            DerivedNeed need = (DerivedNeed)this.myNeeds.get(needIdx);
            String groupName = need.getGroupName();
            if (groupName != null) {
                needNode = doc.createElement(TAG_PARAMGROUP);
                needNode.setAttribute(ATTR_NAME, groupName);
            } else {
                needNode = doc.createElement(TAG_PARAMS);
                List params = (List)need.getParamSets().get(0);
                for (int i = 0; i < params.size(); ++i) {
                    needNode.setAttribute(ATTR_PARAMPREFIX + (i + 1), params.get(i).toString());
                }
            }
            if (need.categories != null) {
                needNode.setAttribute("categories", need.categories);
            }
            opNode.appendChild(needNode);
        }
        return node;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this.categories.size(); ++i) {
            DataCategory cat = (DataCategory)this.categories.get(i);
            if (!cat.getForDisplay()) continue;
            buf.append(cat.toString());
            buf.append(">");
            break;
        }
        if (this.description != null && this.description.trim().length() > 0) {
            buf.append(this.description);
        } else if (this.label != null && this.label.trim().length() > 0) {
            buf.append(this.label);
        } else {
            buf.append(this.id);
        }
        return buf.toString();
    }

    public boolean equals(Object other) {
        if (!(other instanceof DerivedDataDescriptor)) {
            return false;
        }
        DerivedDataDescriptor that = (DerivedDataDescriptor)other;
        return this == that || Misc.equals(this.formula, that.formula) && Misc.equals(this.method, that.method) && Misc.equals(this.code, that.code) && Misc.equals(this.description, that.description) && Misc.equals(this.myNeeds, that.myNeeds) && Misc.equals(this.categories, that.categories) && Misc.equals(this.id, that.id) && this.isDefault == that.isDefault && this.isEndUser == that.isEndUser;
    }

    public DataCategory getDisplayCategory() {
        if (this.categories == null || this.categories.size() == 0) {
            return null;
        }
        for (int i = 0; i < this.categories.size(); ++i) {
            DataCategory dataCategory = (DataCategory)this.categories.get(i);
            if (!dataCategory.getForDisplay()) continue;
            return dataCategory;
        }
        return null;
    }

    public String getJythonProcedure() {
        String def = this.getJythonProcedure(this.getId());
        return def;
    }

    public String getJythonProcedure(String procname) {
        String code = this.getFormula();
        if (code == null) {
            return null;
        }
        List operands = DerivedDataChoice.parseOperands(code);
        return "def " + procname + " (" + StringUtil.join(", ", operands) + "):\n" + "    return " + code + "\n\n";
    }

    public void setIsEndUser(boolean value) {
        this.isEndUser = value;
    }

    public boolean getIsEndUser() {
        return this.isEndUser;
    }

    public void setIsLocalUsers(boolean value) {
        this.isLocalUsers = value;
    }

    public boolean getIsLocalUsers() {
        return this.isLocalUsers;
    }

    public void setIsDefault(boolean value) {
        this.isDefault = value;
    }

    public boolean getIsDefault() {
        return this.isDefault;
    }

    public void setFormula(String value) {
        this.formula = value;
    }

    public String getFormula() {
        return this.formula;
    }

    public void setId(String value) {
        this.id = value;
    }

    public String getId() {
        return this.id;
    }

    public void setDescription(String value) {
        this.description = value;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDataContext(DataContext value) {
        this.dataContext = value;
    }

    public DataContext getDataContext() {
        return this.dataContext;
    }

    public static List readDescriptors(DataContext dataContext, Element root, boolean isLocal) {
        ArrayList<DerivedDataDescriptor> descriptors;
        block4: {
            block2: {
                Object obj;
                block3: {
                    descriptors = new ArrayList<DerivedDataDescriptor>();
                    if (root.getTagName().equals(TAG_DERIVEDTOP)) break block2;
                    obj = dataContext.getIdv().getEncoderForRead().toObject(root);
                    if (!(obj instanceof List)) break block3;
                    List l = (List)obj;
                    for (int i = 0; i < l.size(); ++i) {
                        DerivedDataDescriptor ddd = (DerivedDataDescriptor)l.get(i);
                        ddd.setIsLocalUsers(isLocal);
                        ddd.dataContext = dataContext;
                        descriptors.add(ddd);
                    }
                    break block4;
                }
                if (!(obj instanceof DerivedDataDescriptor)) break block4;
                DerivedDataDescriptor ddd = (DerivedDataDescriptor)obj;
                ddd.setIsLocalUsers(isLocal);
                ddd.dataContext = dataContext;
                descriptors.add(ddd);
                break block4;
            }
            List children = XmlUtil.findChildren(root, TAG_DERIVED);
            for (int i = 0; i < children.size(); ++i) {
                DerivedDataDescriptor ddd = new DerivedDataDescriptor(dataContext, (Element)children.get(i));
                ddd.setIsLocalUsers(isLocal);
                descriptors.add(ddd);
            }
        }
        return descriptors;
    }

    public static List readClasses(Element root) {
        ArrayList<String> classes = new ArrayList<String>();
        List children = XmlUtil.findChildren(root, TAG_CLASS);
        for (int i = 0; i < children.size(); ++i) {
            Element child = (Element)children.get(i);
            classes.add(XmlUtil.getAttribute(child, ATTR_NAME));
        }
        return classes;
    }

    public static String toXml(List descriptors) {
        Document doc = XmlUtil.makeDocument();
        Element top = doc.createElement(TAG_DERIVEDTOP);
        for (int i = 0; i < descriptors.size(); ++i) {
            DerivedDataDescriptor ddd = (DerivedDataDescriptor)descriptors.get(i);
            top.appendChild(ddd.toXml(doc));
        }
        return XmlUtil.toStringWithHeader(top);
    }

    public void updateDataGroups() {
        for (int i = 0; i < this.myNeeds.size(); ++i) {
            DerivedNeed need = (DerivedNeed)this.myNeeds.get(i);
            need.reInitialize();
        }
    }

    public static List init(DataContext dataContext, XmlResourceCollection xrc) {
        ArrayList descriptors = new ArrayList();
        try {
            for (int i = 0; i < xrc.size(); ++i) {
                Element root = xrc.getRoot(i);
                if (root == null) continue;
                descriptors.addAll(DerivedDataDescriptor.readDescriptors(dataContext, root, xrc.isWritableResource(i)));
                classes.addAll(DerivedDataDescriptor.readClasses(root));
            }
        }
        catch (Exception exc) {
            LogUtil.printException(log_, "Initializing DerivedDataChoices", exc);
        }
        return descriptors;
    }

    public static void addToChoicesSoFar(Hashtable choicesSoFar, DataChoice dataChoice) {
        String key = dataChoice.getName();
        ArrayList<DataChoice> l = (ArrayList<DataChoice>)choicesSoFar.get(key);
        if (l == null) {
            l = new ArrayList<DataChoice>();
            choicesSoFar.put(key, l);
        }
        l.add(dataChoice);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getDerivedDataChoices(DataContext context, List sourceChoices, List descriptors) {
        if (descriptors == null) {
            return null;
        }
        List list = descriptors;
        synchronized (list) {
            return DerivedDataDescriptor.getDerivedDataChoicesInner(context, sourceChoices, descriptors);
        }
    }

    private static List getDerivedDataChoicesInner(DataContext context, List sourceChoices, List descriptors) {
        DerivedDataDescriptor ddd;
        int dddIdx;
        ArrayList<DerivedDataChoice> newChoices = new ArrayList<DerivedDataChoice>();
        Hashtable choicesSoFar = new Hashtable();
        for (int dddIdx2 = 0; dddIdx2 < descriptors.size(); ++dddIdx2) {
            DerivedDataDescriptor ddd2 = (DerivedDataDescriptor)descriptors.get(dddIdx2);
            if (!ddd2.getIsDefault()) continue;
            ddd2.initForSearch();
        }
        for (int i = 0; i < sourceChoices.size(); ++i) {
            DerivedDataDescriptor.addToChoicesSoFar(choicesSoFar, (DataChoice)sourceChoices.get(i));
        }
        boolean addedNewChoice = true;
        while (addedNewChoice) {
            addedNewChoice = false;
            for (dddIdx = 0; dddIdx < descriptors.size(); ++dddIdx) {
                NamedList result;
                ddd = (DerivedDataDescriptor)descriptors.get(dddIdx);
                if (!ddd.getIsDefault() || (result = ddd.getDataChoices(choicesSoFar)) == null) continue;
                try {
                    DerivedDataChoice ddc = new DerivedDataChoice(context, result.getList(), result.getName(), ddd);
                    newChoices.add(ddc);
                    DerivedDataDescriptor.addToChoicesSoFar(choicesSoFar, ddc);
                    addedNewChoice = true;
                    continue;
                }
                catch (Exception exc) {
                    LogUtil.logException("Error making derived data choice", exc);
                }
            }
        }
        for (dddIdx = 0; dddIdx < descriptors.size(); ++dddIdx) {
            ddd = (DerivedDataDescriptor)descriptors.get(dddIdx);
            if (!ddd.getIsDefault()) continue;
            ddd.clearAfterSearch();
        }
        return newChoices;
    }

    public static void main(String[] args) {
        try {
            Element root = XmlUtil.getRoot(IOUtil.readContents("derived.xml", DerivedDataDescriptor.class));
            System.out.println(XmlUtil.toString(root));
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    public void setOperandsCategories(String value) {
        this.operandsCategories = value;
        this.operandsCategoryList = this.operandsCategories != null && this.operandsCategories.trim().length() > 0 ? DataCategory.parseCategories(this.operandsCategories) : null;
    }

    public String getOperandsCategories() {
        return this.operandsCategories;
    }
}

