/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.data;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import org.python.core.PyObject;
import org.python.util.PythonInterpreter;
import ucar.unidata.data.DataCancelException;
import ucar.unidata.data.DataCategory;
import ucar.unidata.data.DataChoice;
import ucar.unidata.data.DataContext;
import ucar.unidata.data.DataOperand;
import ucar.unidata.data.DataSelection;
import ucar.unidata.data.DerivedDataDescriptor;
import ucar.unidata.data.ListDataChoice;
import ucar.unidata.data.UnboundDataChoice;
import ucar.unidata.data.UserDataChoice;
import ucar.unidata.data.UserOperandValue;
import ucar.unidata.util.Misc;
import ucar.unidata.util.StringUtil;
import ucar.unidata.util.Trace;
import ucar.visad.Util;
import visad.Data;
import visad.Real;
import visad.VisADException;

public class DerivedDataChoice
extends ListDataChoice {
    public static String PROP_FROMDERIVED = "fromderived";
    private DerivedDataDescriptor descriptor;
    private String constructedCode;
    private Hashtable userSelectedChoices = new Hashtable();
    String methodName;
    String code;
    String formula;
    DataContext dataContext;
    private static Hashtable jythonKeywords;

    public DerivedDataChoice() {
    }

    public DerivedDataChoice(DerivedDataChoice that) {
        super(that);
        this.dataContext = that.dataContext;
        this.methodName = that.methodName;
        this.code = that.code;
        this.formula = that.formula;
        if (that.userSelectedChoices != null) {
            Enumeration keys = that.userSelectedChoices.keys();
            while (keys.hasMoreElements()) {
                Object key = keys.nextElement();
                DataChoice dataChoice = (DataChoice)that.userSelectedChoices.get(key);
                int idx = this.childrenChoices.indexOf(dataChoice);
                if (idx >= 0) {
                    this.userSelectedChoices.put(key, this.childrenChoices.get(idx));
                    continue;
                }
                System.err.println("Couldn't find the cloned data choice");
                this.userSelectedChoices.put(key, dataChoice);
            }
        }
    }

    public DerivedDataChoice(DataContext dataContext, List dataChoices, String desc, DerivedDataDescriptor ddd) {
        super(ddd.id, ddd.getId(), desc, ddd.categories);
        this.dataContext = dataContext;
        this.properties = ddd.properties;
        this.childrenChoices = dataChoices;
        if (this.childrenChoices != null) {
            for (int i = 0; i < this.childrenChoices.size(); ++i) {
                DataChoice dc = (DataChoice)this.childrenChoices.get(i);
                String alias = "D" + (i + 1);
                this.userSelectedChoices.put(alias, dc);
            }
        }
        this.methodName = ddd.method;
        this.code = ddd.code;
        this.formula = ddd.formula;
        this.setDescription(this.convertLabel(this.getDescription(), this.childrenChoices));
        this.checkCategories();
    }

    public DerivedDataChoice(DataContext dataContext, DerivedDataDescriptor ddd) {
        super(ddd.id, ddd.getId(), ddd.getDescription(), ddd.categories);
        this.descriptor = ddd;
        this.dataContext = dataContext;
        this.properties = ddd.properties;
        this.methodName = ddd.method;
        this.code = ddd.code;
        this.formula = ddd.formula;
    }

    public DerivedDataChoice(DataContext dataContext, List dataChoices, String name, String description, String categories, String method, String formula, String code) {
        super(name, name, description, DataCategory.parseCategories(categories));
        this.dataContext = dataContext;
        this.childrenChoices = dataChoices;
        this.properties = new Properties();
        this.methodName = method;
        this.code = code;
        this.formula = formula;
        if (this.categories.size() == 0) {
            this.findDataCategories();
        }
    }

    public DerivedDataChoice(DataContext dataContext, String formula) {
        super("", "", "", new ArrayList());
        this.dataContext = dataContext;
        this.properties = new Properties();
        this.formula = formula;
    }

    @Override
    public DataChoice cloneMe() {
        return new DerivedDataChoice(this);
    }

    @Override
    public String getFullDescription() {
        String extra = "";
        if (this.formula != null) {
            extra = extra + "<br>Formula: <i>" + this.formula + "</i><br>";
        }
        StringBuffer sb = new StringBuffer("Derived quantity: " + extra + super.getFullDescription());
        return sb.toString();
    }

    private static DataOperand addOperand(String opName, Object data, List operands, Hashtable opsSoFar) {
        DataOperand dataOperand = (DataOperand)opsSoFar.get(opName);
        if (dataOperand != null) {
            if (!dataOperand.isBound()) {
                dataOperand.setData(data);
            }
            return dataOperand;
        }
        dataOperand = new DataOperand(opName, data);
        opsSoFar.put(opName, dataOperand);
        operands.add(dataOperand);
        return dataOperand;
    }

    private static void addOperand(String operand, Hashtable seen, List ops) {
        if (jythonKeywords == null) {
            jythonKeywords = new Hashtable();
            jythonKeywords.put("if", "");
            jythonKeywords.put("def", "");
            jythonKeywords.put("for", "");
            jythonKeywords.put("while", "");
        }
        if (jythonKeywords.get(operand) != null) {
            return;
        }
        DataOperand dataOperand = (DataOperand)seen.get(operand);
        if (dataOperand != null) {
            return;
        }
        dataOperand = new DataOperand(operand);
        seen.put(operand, dataOperand);
        ops.add(dataOperand);
    }

    private List collectOperands(DataCategory category, DataSelection dataSelection, Hashtable requestProperties) throws VisADException, RemoteException {
        DataOperand operand;
        int i;
        ArrayList operands = new ArrayList();
        Hashtable operandsSoFar = new Hashtable();
        if (this.methodName != null) {
            StringBuffer paramString = new StringBuffer();
            for (int i2 = 0; i2 < operands.size(); ++i2) {
                if (i2 != 0) {
                    paramString.append(",");
                }
                DataOperand op = (DataOperand)operands.get(i2);
                paramString.append(op.getName());
            }
            this.constructedCode = Misc.getClassMethod(this.methodName) + "(" + paramString.toString() + ")";
        } else if (this.code != null) {
            this.constructedCode = this.code;
        } else if (this.formula != null) {
            this.constructedCode = this.formula;
        } else {
            throw new IllegalArgumentException("DerivedDataChoice: no operation defined");
        }
        DerivedDataChoice.parseOperands(this.constructedCode, operands, operandsSoFar);
        ArrayList<DataOperand> nonUserOperands = new ArrayList<DataOperand>();
        ArrayList tmpList = new ArrayList(operands);
        for (int i3 = 0; i3 < tmpList.size(); ++i3) {
            DataOperand operand2 = (DataOperand)tmpList.get(i3);
            if (operand2.isUser()) {
                UserDataChoice udc = new UserDataChoice(operand2.getName(), operand2.getUserDefault());
                if (!this.childrenChoices.contains(udc)) {
                    this.childrenChoices.add(udc);
                }
                operands.remove(operand2);
                continue;
            }
            nonUserOperands.add(operand2);
        }
        ArrayList<DataChoice> unboundUserChoices = new ArrayList<DataChoice>();
        ArrayList<DataOperand> unboundUserOperands = new ArrayList<DataOperand>();
        ArrayList<DataOperand> allUserOperands = new ArrayList<DataOperand>();
        for (i = 0; i < this.childrenChoices.size(); ++i) {
            DataChoice dc = (DataChoice)this.childrenChoices.get(i);
            if (!(dc instanceof UserDataChoice)) continue;
            operand = new DataOperand(dc.getName(), ((UserDataChoice)dc).getValue());
            allUserOperands.add(operand);
            if (operand.isBound()) continue;
            unboundUserChoices.add(dc);
            unboundUserOperands.add(operand);
        }
        if (unboundUserOperands.size() > 0) {
            List userValues = this.dataContext.selectUserChoices(this.getProperty("usermsg", ""), unboundUserOperands);
            if (userValues == null) {
                return null;
            }
            for (int i4 = 0; i4 < unboundUserOperands.size(); ++i4) {
                operand = (DataOperand)unboundUserOperands.get(i4);
                UserOperandValue userOperandValue = (UserOperandValue)userValues.get(i4);
                Object value = userOperandValue.getValue();
                operand.setData(value);
                UserDataChoice udc = (UserDataChoice)unboundUserChoices.get(i4);
                udc.persistent = userOperandValue.getPersistent();
                udc.setValue(value);
                if (this.childrenChoices.contains(udc)) continue;
                this.childrenChoices.add(udc);
            }
        }
        for (i = 0; i < this.childrenChoices.size(); ++i) {
            DataChoice dc = (DataChoice)this.childrenChoices.get(i);
            String alias = "D" + (i + 1);
            String opName = dc.getName();
            if (dc instanceof UnboundDataChoice) {
                DerivedDataChoice.addOperand(opName, null, operands, operandsSoFar);
                continue;
            }
            if (dc instanceof UserDataChoice) {
                UserDataChoice userChoice = (UserDataChoice)dc;
                DerivedDataChoice.addOperand(alias, userChoice.getValue(), operands, operandsSoFar);
                if (userChoice.persistent) continue;
                userChoice.setValue(null);
                continue;
            }
            DerivedDataChoice.addOperand(opName, dc, operands, operandsSoFar);
            if (this.userSelectedChoices.get(alias) != null) continue;
            DerivedDataChoice.addOperand(alias, dc, operands, operandsSoFar);
        }
        Hashtable dataChoiceToData = new Hashtable();
        for (int i5 = 0; i5 < nonUserOperands.size(); ++i5) {
            operand = (DataOperand)nonUserOperands.get(i5);
            DerivedDataChoice.addOperand(operand.getName(), null, operands, operandsSoFar);
        }
        ArrayList<DataOperand> unboundOperands = new ArrayList<DataOperand>();
        for (int i6 = 0; i6 < operands.size(); ++i6) {
            DataOperand op = (DataOperand)operands.get(i6);
            if (op.isBound()) continue;
            DataChoice boundChoice = (DataChoice)this.userSelectedChoices.get(op.getParamName());
            if (boundChoice == null) {
                boundChoice = (DataChoice)this.userSelectedChoices.get(op.getName());
            }
            if (boundChoice == null) {
                unboundOperands.add(op);
                continue;
            }
            DataSelection ds0 = boundChoice.getDataSelection();
            if (ds0 != null) {
                Object ud = ds0.getProperty("Use_Display_Driver_Times");
                Object udd = dataSelection.getProperty("Use_Display_Driver_Times");
                if (ud != null && udd != null && udd.toString().equals("false")) {
                    dataSelection.putProperty("Use_Display_Driver_Times", (boolean)((Boolean)ud));
                }
            }
            this.setData(boundChoice, op, dataChoiceToData, dataSelection, requestProperties);
        }
        if (unboundOperands.size() > 0) {
            List selected = this.dataContext.selectDataChoices(unboundOperands);
            if (selected == null) {
                return null;
            }
            for (int i7 = 0; i7 < unboundOperands.size(); ++i7) {
                DataOperand op = (DataOperand)unboundOperands.get(i7);
                DataChoice selectedChoice = (DataChoice)selected.get(i7);
                DataSelection ds0 = selectedChoice.getDataSelection();
                if (ds0 != null) {
                    boolean usePR;
                    boolean useDA;
                    boolean useTD = ds0.getProperty("Use_Display_Driver_Times", false);
                    if (useTD) {
                        dataSelection.putProperty("Use_Display_Driver_Times", true);
                    }
                    if (useDA = Misc.equals(ds0.getProperty("Region_Selection_Option"), "Match_Display_Area")) {
                        dataSelection.putProperty("Region_Selection_Option", "Match_Display_Area");
                    }
                    if (usePR = ds0.getProperty("Use_Progressive_Resolution", false)) {
                        dataSelection.putProperty("Use_Progressive_Resolution", true);
                    }
                }
                this.childrenChoices.add(selectedChoice);
                this.addDataChangeListeners(selectedChoice);
                this.userSelectedChoices.put(op.getParamName(), selectedChoice);
                this.setData(selectedChoice, op, dataChoiceToData, dataSelection, requestProperties);
            }
        }
        for (int i8 = 0; i8 < operands.size(); ++i8) {
            DataOperand op = (DataOperand)operands.get(i8);
            Object data = op.getData();
            if (!(data instanceof DataChoice)) continue;
            DataChoice dataChoice = (DataChoice)data;
            this.setData(dataChoice, op, dataChoiceToData, dataSelection, requestProperties);
        }
        operands.addAll(allUserOperands);
        return operands;
    }

    private void setData(DataChoice dataChoice, DataOperand dataOperand, Hashtable dataChoiceToData, DataSelection dataSelection, Hashtable requestProperties) throws VisADException, RemoteException {
        Object data = dataChoiceToData.get(dataOperand.getName());
        if (data == null) {
            if (dataChoice.getClass().equals(ListDataChoice.class)) {
                ListDataChoice ldc = (ListDataChoice)dataChoice;
                data = ldc.getDataList(DataCategory.NULL, dataSelection, requestProperties);
            } else {
                this.checkLevel(dataChoice, dataOperand, dataSelection);
                data = dataChoice.getData(DataCategory.NULL, dataSelection, requestProperties);
            }
            dataChoiceToData.put(dataOperand.getName(), data);
        }
        dataOperand.setData(data);
    }

    private void checkLevel(DataChoice dataChoice, DataOperand op, DataSelection incomingSelection) throws VisADException, RemoteException {
        DataSelection dataSelection = dataChoice.getDataSelection();
        if (op.getProperty("level") != null) {
            List<String> levels = StringUtil.split(op.getProperty("level"), ":", true, true);
            Real fromLevel = null;
            Real toLevel = null;
            if (levels.size() == 0) {
                throw new IllegalArgumentException("Incorrect levels format:" + op.getProperty("level") + "  for operand:" + op);
            }
            try {
                fromLevel = Util.toReal(levels.get(0).toString(), "(", ")");
                toLevel = levels.size() >= 2 ? Util.toReal(levels.get(1).toString(), "(", ")") : fromLevel;
                incomingSelection.setLevelRange(toLevel, fromLevel);
            }
            catch (Exception exc) {
                throw new VisADException("Error parsing levels:" + exc);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected Data getData(DataCategory category, DataSelection incomingDataSelection, Hashtable requestProperties) throws VisADException, RemoteException, DataCancelException {
        PythonInterpreter interp;
        DataSelection dataSelection = DataSelection.merge(incomingDataSelection, this.myDataSelection);
        if (requestProperties == null) {
            requestProperties = new Hashtable();
        }
        Boolean tmpProperty = requestProperties.get(PROP_FROMDERIVED);
        requestProperties.put(PROP_FROMDERIVED, new Boolean(true));
        Trace.call1("DerivedData.getData");
        List ops = this.collectOperands(category, dataSelection, requestProperties);
        if (tmpProperty != null) {
            requestProperties.put(PROP_FROMDERIVED, tmpProperty);
        } else {
            requestProperties.remove(PROP_FROMDERIVED);
        }
        if (ops == null) {
            throw new DataCancelException();
        }
        Data result = null;
        PythonInterpreter pythonInterpreter = interp = this.dataContext.getJythonManager().getDerivedDataInterpreter(this.methodName);
        synchronized (pythonInterpreter) {
            ArrayList<String> setVariables = new ArrayList<String>();
            Hashtable<String, PyObject> setVariables1 = new Hashtable<String, PyObject>();
            try {
                for (int i = 0; i < ops.size(); ++i) {
                    DataOperand op = (DataOperand)ops.get(i);
                    String cleanOperandName = op.makeLegalJython();
                    this.constructedCode = StringUtil.replace(this.constructedCode, op.getName(), cleanOperandName);
                    if (interp.get(cleanOperandName) == null) {
                        setVariables.add(cleanOperandName);
                    } else if (cleanOperandName.charAt(0) == 'D' && Character.isDigit(cleanOperandName.charAt(1))) {
                        setVariables.add(cleanOperandName);
                    } else {
                        setVariables1.put(cleanOperandName, interp.get(cleanOperandName));
                    }
                    interp.set(cleanOperandName, op.getData());
                }
                interp.set("derivedDataChoice", this);
                if (result == null) {
                    PyObject pyResult = interp.eval(this.constructedCode);
                    Object resultObject = null;
                    resultObject = pyResult.getType().toString().contains("ArrayList") ? pyResult.__tojava__(List.class) : pyResult.__tojava__(Data.class);
                    if (pyResult.getType().toString().contains("ArrayList")) {
                        result = (Data)((List)resultObject).get(0);
                    } else if (resultObject != null && !(resultObject instanceof Data)) {
                        resultObject = pyResult.__tojava__(DataChoice.class);
                        if (!(resultObject instanceof DataChoice)) throw new IllegalArgumentException("Unknown return value type:" + resultObject.getClass().getName() + "\n Value=" + resultObject + "\nCode:" + this.constructedCode);
                        DataChoice dataChoice = (DataChoice)resultObject;
                        result = dataChoice.getData(incomingDataSelection);
                        this.code = "bounddatachoice";
                        this.userSelectedChoices = new Hashtable();
                        this.userSelectedChoices.put(this.code, dataChoice);
                        this.childrenChoices = new ArrayList();
                        this.childrenChoices.add(dataChoice);
                    } else {
                        result = (Data)resultObject;
                    }
                }
            }
            finally {
                try {
                    interp.set("derivedDataChoice", null);
                }
                catch (Exception pyResult) {}
                try {
                    for (String varName : setVariables) {
                        interp.set(varName, null);
                    }
                }
                catch (Exception pyResult) {}
                if (setVariables1.size() > 0) {
                    Enumeration keys = setVariables1.keys();
                    while (keys.hasMoreElements()) {
                        Object key = keys.nextElement();
                        String varName = (String)key;
                        interp.set(varName, null);
                        interp.set(varName, setVariables1.get(varName));
                    }
                }
            }
        }
        Trace.call2("DerivedData.getData");
        return result;
    }

    public void setFormula(String formula) {
        this.formula = formula;
    }

    public String getFormula() {
        return this.formula;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public void setClassName(String m) {
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String m) {
        this.code = m;
    }

    public void setUserSelectedChoices(Hashtable value) {
        this.userSelectedChoices = value;
    }

    public Hashtable getUserSelectedChoices() {
        return this.userSelectedChoices;
    }

    public void setDescriptor(DerivedDataDescriptor value) {
        this.descriptor = value;
    }

    public DerivedDataDescriptor getDataDescriptor() {
        return this.descriptor;
    }

    public void setExtraArgs(String foo) {
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ Misc.hashcode(this.userSelectedChoices);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (!(o instanceof DerivedDataChoice)) {
            return false;
        }
        DerivedDataChoice that = (DerivedDataChoice)o;
        return Misc.equals(this.methodName, that.methodName) && Misc.equals(this.formula, that.formula) && Misc.equals(this.code, that.code) && Misc.equals(this.userSelectedChoices, that.userSelectedChoices);
    }

    @Override
    public boolean isEndUserFormula() {
        return this.descriptor != null;
    }

    public static List parseOperands(String jythonCode) {
        Hashtable seen = new Hashtable();
        ArrayList operands = new ArrayList();
        return DerivedDataChoice.parseOperands(jythonCode, operands, seen);
    }

    public static List parseOperands(String jythonCode, List operands, Hashtable seen) {
        StringBuffer current = null;
        char[] chars = jythonCode.toCharArray();
        boolean STATE_LOOKINGFORTOKEN = false;
        boolean STATE_HAVEIDENTIFIER = true;
        int STATE_HAVENONIDENTIFIER = 2;
        int STATE_HAVEBRACKETEDID = 3;
        int STATE_INDOUBLEQUOTE = 4;
        int STATE_INSINGLEQUOTE = 5;
        int state = 0;
        char CHAR_DQUOTE = '\"';
        char CHAR_SQUOTE = '\'';
        char CHAR_HASH = '#';
        String extraSpaces = null;
        block7: for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            switch (state) {
                case 0: {
                    if (c == CHAR_DQUOTE) {
                        state = 4;
                        continue block7;
                    }
                    if (c == CHAR_SQUOTE) {
                        state = 5;
                        continue block7;
                    }
                    if (!Character.isJavaIdentifierStart(c) && c != CHAR_HASH) continue block7;
                    current = new StringBuffer();
                    current.append(c);
                    state = 1;
                    continue block7;
                }
                case 4: {
                    if (c != '\"') continue block7;
                    state = 0;
                    continue block7;
                }
                case 5: {
                    if (c != '\'') continue block7;
                    state = 0;
                    continue block7;
                }
                case 3: {
                    current.append(c);
                    if (c != ']') continue block7;
                    DerivedDataChoice.addOperand(current.toString(), seen, operands);
                    state = 0;
                    continue block7;
                }
                case 1: {
                    if (Character.isJavaIdentifierPart(c) || c == '.' || c == ':' || c == '#') {
                        current.append(c);
                        continue block7;
                    }
                    if (c == '[') {
                        state = 3;
                        if (extraSpaces != null) {
                            current.append(extraSpaces);
                        }
                        extraSpaces = null;
                        current.append(c);
                        continue block7;
                    }
                    if (c == ' ' || c == '\t') {
                        if (extraSpaces == null) {
                            extraSpaces = "";
                        }
                        extraSpaces = extraSpaces + c;
                        continue block7;
                    }
                    if (c == '=') {
                        while (i < chars.length && (c = chars[i]) != ',' && c != ' ' && c != ')') {
                            ++i;
                        }
                        extraSpaces = null;
                        current = null;
                        state = 0;
                        continue block7;
                    }
                    if (c != '(') {
                        DerivedDataChoice.addOperand(current.toString(), seen, operands);
                    }
                    extraSpaces = null;
                    current = null;
                    state = 0;
                    continue block7;
                }
            }
        }
        if (state == 1 && current != null && current.length() > 0) {
            DerivedDataChoice.addOperand(current.toString(), seen, operands);
        }
        return operands;
    }

    public static String cleanupJythonCode(String code) {
        List ops = DerivedDataChoice.parseOperands(code);
        for (int i = 0; i < ops.size(); ++i) {
            DataOperand operand = (DataOperand)ops.get(i);
            code = StringUtil.replace(code, operand.getName(), operand.makeLegalJython());
        }
        return code;
    }

    public DataContext getDataContext() {
        return this.dataContext;
    }

    public void setDataContext(DataContext c) {
        this.dataContext = c;
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.err.println("No args");
            System.exit(0);
        }
        System.err.println("ops:" + DerivedDataChoice.parseOperands(args[0]));
        System.err.println("code:" + DerivedDataChoice.cleanupJythonCode(args[0]));
    }
}

