/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.data;

import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.rmi.RemoteException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import ucar.ma2.Array;
import ucar.nc2.dataset.CoordinateAxis1DTime;
import ucar.nc2.ft2.coverage.CoordInterval;
import ucar.nc2.ft2.coverage.CoverageCoordAxis1D;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.util.NamedAnything;
import ucar.nc2.util.NamedObject;
import ucar.unidata.util.DatedObject;
import ucar.unidata.util.IOUtil;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.StringUtil;
import ucar.unidata.util.TwoFacedObject;
import ucar.visad.Util;
import ucar.visad.data.CalendarDateTime;
import visad.CoordinateSystem;
import visad.Data;
import visad.DateTime;
import visad.FieldImpl;
import visad.FlatField;
import visad.Real;
import visad.RealType;
import visad.TextType;
import visad.Tuple;
import visad.Unit;
import visad.VisADException;

public class DataUtil {
    public static final String STD_ATMOSPHERE = "ucar.visad.quantities.AirPressure$StandardAtmosphereCoordinateSystem";
    public static final String VIS5D_VERTICALCS = "visad.data.vis5d.Vis5DVerticalSystem$Vis5DVerticalCoordinateSystem";

    public static float[] toFloatArray(Array arr) {
        Class fromClass = arr.getElementType();
        if (fromClass.equals(Float.TYPE)) {
            return (float[])arr.get1DJavaArray(Float.TYPE);
        }
        float[] values = new float[(int)arr.getSize()];
        boolean isUnsigned = arr.isUnsigned();
        if (fromClass.equals(Byte.TYPE)) {
            byte[] fromArray = (byte[])arr.get1DJavaArray(Byte.TYPE);
            for (int i = 0; i < fromArray.length; ++i) {
                values[i] = isUnsigned ? (float)(fromArray[i] & 0xFF) : (float)fromArray[i];
            }
        } else if (fromClass.equals(Short.TYPE)) {
            short[] fromArray = (short[])arr.get1DJavaArray(Short.TYPE);
            for (int i = 0; i < fromArray.length; ++i) {
                values[i] = isUnsigned ? (float)(fromArray[i] & 0xFFFF) : (float)fromArray[i];
            }
        } else if (fromClass.equals(Integer.TYPE)) {
            int[] fromArray = (int[])arr.get1DJavaArray(Integer.TYPE);
            for (int i = 0; i < fromArray.length; ++i) {
                values[i] = isUnsigned ? (float)((long)fromArray[i] & 0xFFFFFFFFFFFFFFFFL) : (float)fromArray[i];
            }
        } else if (fromClass.equals(Double.TYPE)) {
            double[] fromArray = (double[])arr.get1DJavaArray(Double.TYPE);
            for (int i = 0; i < fromArray.length; ++i) {
                values[i] = (float)fromArray[i];
            }
        } else {
            throw new IllegalArgumentException("Unknown array type:" + fromClass.getName());
        }
        return values;
    }

    public static float[] toFloatArray(Array[] arr) {
        float[] values0 = DataUtil.toFloatArray(arr[0]);
        if (arr.length == 1) {
            return values0;
        }
        int size0 = values0.length;
        int size = size0 * arr.length;
        float[] values = new float[size];
        System.arraycopy(values0, 0, values, 0, size0);
        for (int i = 1; i < arr.length; ++i) {
            float[] valuesi = DataUtil.toFloatArray(arr[i]);
            System.arraycopy(valuesi, 0, values, i * size0, size0);
        }
        return values;
    }

    public static double[] toDoubleArray(Array arr) {
        double[] values;
        block6: {
            Class fromClass;
            block8: {
                boolean isUnsigned;
                block7: {
                    block5: {
                        fromClass = arr.getElementType();
                        if (fromClass.equals(Double.TYPE)) {
                            return (double[])arr.get1DJavaArray(Double.TYPE);
                        }
                        values = new double[(int)arr.getSize()];
                        isUnsigned = arr.isUnsigned();
                        if (!fromClass.equals(Byte.TYPE)) break block5;
                        byte[] fromArray = (byte[])arr.get1DJavaArray(Byte.TYPE);
                        for (int i = 0; i < fromArray.length; ++i) {
                            values[i] = isUnsigned ? (double)(fromArray[i] & 0xFF) : (double)fromArray[i];
                        }
                        break block6;
                    }
                    if (!fromClass.equals(Short.TYPE)) break block7;
                    short[] fromArray = (short[])arr.get1DJavaArray(Short.TYPE);
                    for (int i = 0; i < fromArray.length; ++i) {
                        values[i] = isUnsigned ? (double)(fromArray[i] & 0xFFFF) : (double)fromArray[i];
                    }
                    break block6;
                }
                if (!fromClass.equals(Integer.TYPE)) break block8;
                int[] fromArray = (int[])arr.get1DJavaArray(Integer.TYPE);
                for (int i = 0; i < fromArray.length; ++i) {
                    values[i] = isUnsigned ? (double)((long)fromArray[i] & 0xFFFFFFFFFFFFFFFFL) : (double)fromArray[i];
                }
                break block6;
            }
            if (!fromClass.equals(Float.TYPE)) break block6;
            float[] fromArray = (float[])arr.get1DJavaArray(Float.TYPE);
            for (int i = 0; i < fromArray.length; ++i) {
                values[i] = fromArray[i];
            }
        }
        return values;
    }

    public static String[] toStringArray(Array arr) {
        return (String[])arr.get1DJavaArray(String.class);
    }

    public static char[] toCharArray(Array arr) {
        char[] values;
        block7: {
            Class fromClass;
            block10: {
                block9: {
                    block8: {
                        block6: {
                            fromClass = arr.getElementType();
                            if (fromClass.equals(Character.TYPE)) {
                                return (char[])arr.get1DJavaArray(Character.TYPE);
                            }
                            values = new char[(int)arr.getSize()];
                            boolean isUnsigned = arr.isUnsigned();
                            if (!fromClass.equals(Byte.TYPE)) break block6;
                            byte[] fromArray = (byte[])arr.get1DJavaArray(Byte.TYPE);
                            for (int i = 0; i < fromArray.length; ++i) {
                                values[i] = isUnsigned ? (char)(fromArray[i] & 0xFF) : (char)fromArray[i];
                            }
                            break block7;
                        }
                        if (!fromClass.equals(Short.TYPE)) break block8;
                        short[] fromArray = (short[])arr.get1DJavaArray(Short.TYPE);
                        for (int i = 0; i < fromArray.length; ++i) {
                            values[i] = (char)fromArray[i];
                        }
                        break block7;
                    }
                    if (!fromClass.equals(Integer.TYPE)) break block9;
                    int[] fromArray = (int[])arr.get1DJavaArray(Integer.TYPE);
                    for (int i = 0; i < fromArray.length; ++i) {
                        values[i] = (char)fromArray[i];
                    }
                    break block7;
                }
                if (!fromClass.equals(Float.TYPE)) break block10;
                float[] fromArray = (float[])arr.get1DJavaArray(Float.TYPE);
                for (int i = 0; i < fromArray.length; ++i) {
                    values[i] = (char)fromArray[i];
                }
                break block7;
            }
            if (!fromClass.equals(Double.TYPE)) break block7;
            double[] fromArray = (double[])arr.get1DJavaArray(Double.TYPE);
            for (int i = 0; i < fromArray.length; ++i) {
                values[i] = (char)fromArray[i];
            }
        }
        return values;
    }

    public static Unit parseUnit(String unitString) {
        try {
            return Util.parseUnit(unitString);
        }
        catch (Exception exc) {
            return null;
        }
    }

    public static TextType makeTextType(String name) {
        return TextType.getTextType(Util.cleanName(name));
    }

    public static RealType makeRealType(String name, Unit unit) {
        try {
            return Util.makeRealType(name, unit);
        }
        catch (Exception exc) {
            System.err.println(exc.toString());
            return null;
        }
    }

    public static String cleanName(String name) {
        return Util.cleanName(name);
    }

    public static CoordinateSystem getPressureToHeightCS(String type) throws VisADException {
        CoordinateSystem cs = null;
        try {
            Class<?> c = Class.forName(type);
            cs = (CoordinateSystem)c.newInstance();
        }
        catch (Exception excp) {
            throw new VisADException("Unable to create vertical transform " + type);
        }
        return cs;
    }

    public static float[][] makeFloatArray(int rows, int cols, float value) {
        float[][] values = new float[rows][cols];
        for (int i = 0; i < values.length; ++i) {
            Arrays.fill(values[i], value);
        }
        return values;
    }

    public static float[][] cloneArray(float[][] a) {
        float[][] values = new float[a.length][a[0].length];
        for (int i = 0; i < a.length; ++i) {
            System.arraycopy(a[i], 0, values[i], 0, a[0].length);
        }
        return values;
    }

    public static void absoluteValue(float[][] originalValues, float[][] newValues, int[] indexArray) {
        for (int j = 0; j < indexArray.length; ++j) {
            if (!(originalValues[0][indexArray[j]] < 0.0f)) continue;
            newValues[0][indexArray[j]] = -originalValues[0][indexArray[j]];
        }
    }

    public static void max(float[][] originalValues, float[][] newValues, int[] indexArray, float value) {
        for (int j = 0; j < indexArray.length; ++j) {
            if (!(originalValues[0][indexArray[j]] > value)) continue;
            newValues[0][indexArray[j]] = value;
        }
    }

    public static void setValue(float[][] originalValues, float[][] newValues, int[] indexArray, float value) {
        for (int j = 0; j < indexArray.length; ++j) {
            newValues[0][indexArray[j]] = value;
        }
    }

    public static void min(float[][] originalValues, float[][] newValues, int[] indexArray, float value) {
        for (int j = 0; j < indexArray.length; ++j) {
            if (!(originalValues[0][indexArray[j]] < value)) continue;
            newValues[0][indexArray[j]] = value;
        }
    }

    public static void average(float[][] originalValues, float[][] newValues, int[] indexArray) {
        int j;
        if (indexArray.length == 0) {
            return;
        }
        float total = 0.0f;
        for (j = 0; j < indexArray.length; ++j) {
            total += originalValues[0][indexArray[j]];
        }
        for (j = 0; j < indexArray.length; ++j) {
            newValues[0][indexArray[j]] = total / (float)indexArray.length;
        }
    }

    public static FlatField getFlatField(Data field) throws VisADException, RemoteException {
        if (field == null) {
            return null;
        }
        if (field instanceof FlatField) {
            return (FlatField)field;
        }
        if (field instanceof Tuple) {
            Tuple t = (Tuple)field;
            for (int i = 0; i < t.getLength(); ++i) {
                FlatField f = DataUtil.getFlatField(t.getComponent(i));
                if (f == null) continue;
                return f;
            }
        }
        if (!(field instanceof FieldImpl)) {
            return null;
        }
        return DataUtil.getFlatField(((FieldImpl)field).getSample(0, false));
    }

    public static void writeCsv(String filename, List rows) {
        try {
            if (filename.toLowerCase().endsWith(".xls")) {
                DataUtil.writeXls(filename, rows);
                return;
            }
            StringBuffer sb = new StringBuffer();
            for (int rowIdx = 0; rowIdx < rows.size(); ++rowIdx) {
                sb.append(StringUtil.join(",", (List)rows.get(rowIdx)));
                sb.append("\n");
            }
            IOUtil.writeFile(filename, sb.toString());
        }
        catch (Exception exc) {
            LogUtil.logException("Writing CSV", exc);
        }
    }

    public static void writeXls(String filename, List rows) throws Exception {
        DataUtil.writeXls(filename, Misc.newList(rows), null);
    }

    public static void writeXls(String filename, List<List> rowsList, List<String> names) throws Exception {
        HSSFWorkbook wb = new HSSFWorkbook();
        FileOutputStream fileOut = new FileOutputStream(filename);
        for (int sheetIdx = 0; sheetIdx < rowsList.size(); ++sheetIdx) {
            String sheetName = names != null ? names.get(sheetIdx) : null;
            HSSFSheet sheet = sheetName != null ? wb.createSheet(sheetName) : wb.createSheet();
            List rows = rowsList.get(sheetIdx);
            for (int i = 0; i < rows.size(); ++i) {
                HSSFRow row = sheet.createRow((int)((short)i));
                List cols = (List)rows.get(i);
                for (int colIdx = 0; colIdx < cols.size(); ++colIdx) {
                    Object o = cols.get(colIdx);
                    HSSFCell cell = row.createCell((short)colIdx);
                    if (o instanceof Double) {
                        cell.setCellValue(((Double)o).doubleValue());
                        continue;
                    }
                    if (o instanceof Real) {
                        cell.setCellValue(((Real)o).getValue());
                        continue;
                    }
                    if (o instanceof Integer) {
                        cell.setCellValue((double)((Integer)o).intValue());
                        continue;
                    }
                    cell.setCellValue(o.toString());
                }
            }
        }
        wb.write((OutputStream)fileOut);
        fileOut.close();
    }

    public static String xlsToCsv(String filename) throws Exception {
        return DataUtil.xlsToCsv(filename, false, null);
    }

    public static String xlsToCsv(String filename, boolean skipToFirstNumeric, SimpleDateFormat sdf) throws Exception {
        StringBuffer sb = new StringBuffer();
        InputStream myxls = IOUtil.getInputStream(filename, DataUtil.class);
        HSSFWorkbook wb = new HSSFWorkbook(myxls);
        HSSFSheet sheet = wb.getSheetAt(0);
        boolean seenNumber = false;
        for (int rowIdx = sheet.getFirstRowNum(); rowIdx <= sheet.getLastRowNum(); ++rowIdx) {
            HSSFRow row = sheet.getRow(rowIdx);
            if (row == null) {
                sb.append("\n");
                continue;
            }
            boolean rowOk = true;
            for (short colIdx = row.getFirstCellNum(); colIdx < row.getPhysicalNumberOfCells(); colIdx = (short)(colIdx + 1)) {
                HSSFCell cell = row.getCell(colIdx);
                if (cell == null) continue;
                if (skipToFirstNumeric && !seenNumber) {
                    if (cell.getCellType() != 0) {
                        rowOk = false;
                        break;
                    }
                    seenNumber = true;
                }
                String cellValue = null;
                if (sdf != null && cell.getCellType() == 0 && HSSFDateUtil.isCellDateFormatted((Cell)cell)) {
                    Date date = cell.getDateCellValue();
                    cellValue = sdf.format(date);
                }
                if (cellValue == null) {
                    cellValue = cell.toString();
                }
                if (colIdx > 0) {
                    sb.append(",");
                }
                sb.append(cellValue);
            }
            if (!rowOk) continue;
            sb.append("\n");
        }
        return sb.toString();
    }

    public static boolean pointInside(float[][] pts, float x, float y) {
        boolean isPointInside = false;
        int numPoints = pts[0].length;
        float[] vertx = pts[0];
        float[] verty = pts[1];
        int i = 0;
        int j = numPoints - 1;
        while (i < numPoints) {
            if (verty[i] > y != verty[j] > y && x < (vertx[j] - vertx[i]) * (y - verty[i]) / (verty[j] - verty[i]) + vertx[i]) {
                isPointInside = !isPointInside;
            }
            j = i++;
        }
        return isPointInside;
    }

    public static List<Date> selectDatesFromList(List sourceTimes, List<DateTime> driverTimes) throws Exception {
        List<DateTime> dts = DataUtil.selectTimesFromList(sourceTimes, driverTimes);
        ArrayList<Date> dates = new ArrayList<Date>();
        for (DateTime dt : dts) {
            dates.add(new Date((long)dt.getValue() * 1000L));
        }
        return dates;
    }

    public static List<DateTime> selectTimesFromList(List sourceTimes, List<DateTime> selectionTimes) throws Exception {
        ArrayList<DateTime> results = new ArrayList<DateTime>();
        ArrayList<Date> sourceDates = new ArrayList<Date>();
        for (int i = 0; i < sourceTimes.size(); ++i) {
            Object object = sourceTimes.get(i);
            if (object instanceof DateTime) {
                sourceDates.add(Util.makeDate((DateTime)object));
                continue;
            }
            if (object instanceof Date) {
                sourceDates.add((Date)object);
                continue;
            }
            if (object instanceof DatedObject) {
                sourceDates.add(((DatedObject)object).getDate());
                continue;
            }
            if (object instanceof TwoFacedObject) {
                return null;
            }
            System.err.println("Unknown time type: " + object.getClass().getName());
            return null;
        }
        HashSet<Date> seenTimes = new HashSet<Date>();
        for (DateTime dateTime : selectionTimes) {
            Date dttm = Util.makeDate(dateTime);
            long minTimeDiff = -1L;
            Date minDate = null;
            for (int i = 0; i < sourceDates.size(); ++i) {
                Date sourceDate = (Date)sourceDates.get(i);
                long timeDiff = Math.abs(sourceDate.getTime() - dttm.getTime());
                if (minTimeDiff >= 0L && timeDiff >= minTimeDiff) continue;
                minTimeDiff = timeDiff;
                minDate = sourceDate;
            }
            if (minDate == null || seenTimes.contains(minDate)) continue;
            results.add(new DateTime(minDate));
            seenTimes.add(minDate);
        }
        return results;
    }

    public static CalendarDateTime makeDateTime(CalendarDate cdate) throws VisADException {
        CalendarDateTime d = new CalendarDateTime(cdate);
        return d;
    }

    public static List<CalendarDateTime> makeDateTimes(CoordinateAxis1DTime timeAxis) throws VisADException {
        List<CalendarDate> cdates = timeAxis.getCalendarDates();
        ArrayList<CalendarDateTime> times = new ArrayList<CalendarDateTime>(cdates.size());
        for (CalendarDate cdate : cdates) {
            times.add(DataUtil.makeDateTime(cdate));
        }
        return times;
    }

    public static List<CalendarDateTime> makeDateTimes(CoverageCoordAxis1D timeAxis) throws VisADException {
        List<NamedObject> ttt = timeAxis.getCoordValueNames();
        ArrayList<CalendarDateTime> times = new ArrayList<CalendarDateTime>(ttt.size());
        double[] t = timeAxis.getValues();
        int i = 0;
        for (NamedObject oj : ttt) {
            NamedAnything anything = (NamedAnything)oj;
            if (anything.getValue() instanceof CoordInterval) {
                double[] od = (double[])timeAxis.getCoordObject(i++);
                CalendarDate cdate = timeAxis.makeDate(od[1]);
                times.add(DataUtil.makeDateTime(cdate));
                continue;
            }
            CalendarDate cdate = (CalendarDate)anything.getValue();
            times.add(DataUtil.makeDateTime(cdate));
        }
        return times;
    }

    public static Date makeDate(CalendarDate cdate) throws VisADException {
        CalendarDateTime dt = DataUtil.makeDateTime(cdate);
        return new Date((long)dt.getValue() * 1000L);
    }

    public static String makeSamplingLabel(int xStride, int yStride, String pointType) {
        StringBuilder buf = new StringBuilder();
        if (xStride > 1 && yStride > 1) {
            buf.append("Data Sampling: every ");
            buf.append(DataUtil.getStrideLabel(xStride));
            if (xStride != yStride) {
                buf.append(" by ");
                buf.append(DataUtil.getStrideLabel(yStride));
            }
            buf.append(" ");
            buf.append(pointType);
        }
        return buf.toString();
    }

    private static String getStrideLabel(int strideValue) {
        int remainder = strideValue % 10;
        if (strideValue == 2) {
            return "2nd";
        }
        if (remainder == 1 && strideValue != 11) {
            return strideValue + "st";
        }
        if (remainder == 2 && strideValue != 12) {
            return strideValue + "nd";
        }
        if (remainder == 3 && strideValue != 13) {
            return strideValue + "rd";
        }
        return strideValue + "th";
    }
}

