/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.data;

import java.awt.Component;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ucar.unidata.ui.DateTimePicker;
import ucar.unidata.ui.TimeLengthField;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.LogUtil;
import visad.CommonUnit;
import visad.Real;
import visad.RealType;
import visad.VisADException;

public class DataTimeRange {
    public static final int MODE_DATA = 0;
    public static final int MODE_ANIMATION = 1;
    public static final int MODE_FIXED = 2;
    public static final int MODE_RELATIVE = 3;
    public static int[] MODES = new int[]{0, 1, 3, 2};
    public static String[] STARTMODELABELS = new String[]{"Use First Time from Data", "From Animation Time", "Relative to End Time", "Fixed:"};
    public static String[] ENDMODELABELS = new String[]{"Use Last Time from Data", "From Animation Time", "Relative to Start Time", "Fixed:"};
    private JDialog timeDialog;
    private long startFixedTime = Long.MAX_VALUE;
    private long endFixedTime = Long.MAX_VALUE;
    private double startOffsetMinutes = 0.0;
    private double endOffsetMinutes = 0.0;
    private int startMode = 0;
    private int endMode = 0;
    private JComboBox startTimeBox;
    private JComboBox endTimeBox;
    private DateTimePicker startTimePicker;
    private DateTimePicker endTimePicker;
    private TimeLengthField startOffsetField;
    private TimeLengthField endOffsetField;
    private RealType dataTimeRealType;
    private JLabel timeModeLabel;
    private boolean oneLineLabel = false;
    private boolean dialogOk = false;

    public Real[] getTimeRange(Real dataStartTime, Real dataEndTime, Real aniValue) throws VisADException, RemoteException {
        double startDate = dataStartTime.getValue(CommonUnit.secondsSinceTheEpoch);
        double endDate = dataEndTime.getValue(CommonUnit.secondsSinceTheEpoch);
        double startOffsetTime = this.startOffsetMinutes * 60.0;
        double endOffsetTime = this.endOffsetMinutes * 60.0;
        double animationTime = endDate;
        if (aniValue != null && !aniValue.isMissing()) {
            animationTime = aniValue.getValue(CommonUnit.secondsSinceTheEpoch);
        }
        if (this.startMode == 0) {
            startDate += startOffsetTime;
        } else if (this.startMode == 1) {
            startDate = animationTime + startOffsetTime;
        } else if (this.startMode == 2) {
            startDate = (double)(this.startFixedTime / 1000L) + startOffsetTime;
        }
        if (this.endMode == 0) {
            endDate += endOffsetTime;
        } else if (this.endMode == 1) {
            endDate = animationTime + endOffsetTime;
        } else if (this.endMode == 2) {
            endDate = (double)(this.endFixedTime / 1000L) + endOffsetTime;
        }
        if (this.startMode == 3) {
            startDate = endDate + startOffsetTime;
        }
        if (this.endMode == 3) {
            endDate = startDate + endOffsetTime;
        }
        return new Real[]{new Real(RealType.Time, startDate, CommonUnit.secondsSinceTheEpoch), new Real(RealType.Time, endDate, CommonUnit.secondsSinceTheEpoch)};
    }

    public JLabel getTimeModeLabel() {
        if (this.timeModeLabel == null) {
            this.timeModeLabel = new JLabel("");
        }
        this.setTimeModeLabel();
        return this.timeModeLabel;
    }

    private void setTimeModeLabel() {
        if (this.timeModeLabel != null) {
            this.timeModeLabel.setText(this.getLabelText());
        }
    }

    public void setTimeModeLabel(JLabel label) {
        this.timeModeLabel = label;
    }

    public boolean showDialog() {
        this.timeDialog = new JDialog((Frame)null, "Time Settings", true);
        ArrayList<JPanel> comps = new ArrayList<JPanel>();
        ActionListener boxListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                DataTimeRange.this.checkTimeEnabled();
            }
        };
        this.startTimeBox = GuiUtils.makeComboBox(MODES, STARTMODELABELS, 0);
        GuiUtils.setValueOfBox(this.startTimeBox, this.getStartMode(), MODES, STARTMODELABELS);
        this.startTimeBox.addActionListener(boxListener);
        this.endTimeBox = GuiUtils.makeComboBox(MODES, ENDMODELABELS, 0);
        GuiUtils.setValueOfBox(this.endTimeBox, this.getEndMode(), MODES, ENDMODELABELS);
        this.endTimeBox.addActionListener(boxListener);
        this.startOffsetField = new TimeLengthField("Start Offset");
        this.endOffsetField = new TimeLengthField("End Offset");
        this.startTimePicker = new DateTimePicker();
        this.endTimePicker = new DateTimePicker();
        JPanel startOffsetPanel = GuiUtils.hbox(new JLabel(" Offset: "), this.startOffsetField.getContents());
        JPanel endOffsetPanel = GuiUtils.hbox(new JLabel(" Offset: "), this.endOffsetField.getContents());
        JPanel startDetails = GuiUtils.hbox(this.startTimeBox, startOffsetPanel);
        JPanel endDetails = GuiUtils.hbox(this.endTimeBox, endOffsetPanel);
        JPanel startPickerPanel = GuiUtils.inset((Component)GuiUtils.left(this.startTimePicker), new Insets(5, 0, 0, 0));
        JPanel endPickerPanel = GuiUtils.inset((Component)GuiUtils.left(this.endTimePicker), new Insets(5, 0, 0, 0));
        comps.add(GuiUtils.top(GuiUtils.rLabel("Start Time:")));
        comps.add(GuiUtils.left(GuiUtils.vbox((Component)startDetails, startPickerPanel)));
        comps.add(GuiUtils.top(GuiUtils.rLabel("End Time:")));
        comps.add(GuiUtils.left(GuiUtils.vbox((Component)endDetails, endPickerPanel)));
        GuiUtils.tmpInsets = new Insets(10, 5, 10, 5);
        JPanel contents = GuiUtils.doLayout(comps, 2, GuiUtils.WT_NY, GuiUtils.WT_N);
        this.dialogOk = false;
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                String cmd = ae.getActionCommand();
                if (cmd.equals(GuiUtils.CMD_OK) || cmd.equals(GuiUtils.CMD_APPLY)) {
                    if (!DataTimeRange.this.applyTimeProperties()) {
                        return;
                    }
                    DataTimeRange.this.dialogOk = true;
                    DataTimeRange.this.setTimeModeLabel();
                }
                if (cmd.equals(GuiUtils.CMD_OK) || cmd.equals(GuiUtils.CMD_CANCEL)) {
                    DataTimeRange.this.timeDialog.setVisible(false);
                    DataTimeRange.this.timeDialog.dispose();
                }
            }
        };
        this.startOffsetField.setTime(this.getStartOffsetMinutes());
        this.endOffsetField.setTime(this.getEndOffsetMinutes());
        this.startTimePicker.setDate(this.getStartFixedDate());
        this.endTimePicker.setDate(this.getEndFixedDate());
        this.timeDialog.getContentPane().add(GuiUtils.inset((Component)GuiUtils.centerBottom(contents, GuiUtils.makeApplyOkCancelButtons(listener)), 5));
        this.checkTimeEnabled();
        this.timeDialog.pack();
        this.timeDialog.setVisible(true);
        return this.dialogOk;
    }

    public boolean applyTimeProperties() {
        int endMode;
        double startOffset = this.startOffsetField.getTime();
        double endOffset = this.endOffsetField.getTime();
        int startMode = GuiUtils.getValueFromBox(this.startTimeBox);
        if (startMode == (endMode = GuiUtils.getValueFromBox(this.endTimeBox)) && startMode == 3) {
            LogUtil.userErrorMessage("You cannot set both times to be relative");
            return false;
        }
        if (startMode == 3 && startOffset >= 0.0) {
            LogUtil.userErrorMessage("The start offset is " + (startOffset == 0.0 ? "0" : "negative") + " which will result in\na start time " + (startOffset == 0.0 ? "equal to" : "after") + " the end time.");
            return false;
        }
        if (endMode == 3 && endOffset <= 0.0) {
            LogUtil.userErrorMessage("The end offset is " + (endOffset == 0.0 ? "0" : "negative") + " which will result in\nan end time " + (endOffset == 0.0 ? "equal to" : "before") + " the start time.");
            return false;
        }
        this.setStartFixedTime(this.startTimePicker.getDate());
        this.setEndFixedTime(this.endTimePicker.getDate());
        this.setStartMode(startMode);
        this.setEndMode(endMode);
        this.setStartOffsetMinutes(startOffset);
        this.setEndOffsetMinutes(endOffset);
        return true;
    }

    private void checkTimeEnabled() {
        int startMode = GuiUtils.getValueFromBox(this.startTimeBox);
        int endMode = GuiUtils.getValueFromBox(this.endTimeBox);
        GuiUtils.enableTree(this.startTimePicker, startMode == 2);
        GuiUtils.enableTree(this.endTimePicker, endMode == 2);
    }

    public void setOneLineLabel(boolean v) {
        this.oneLineLabel = v;
    }

    public String getLabelText() {
        String lbl = "<html>Start: ";
        lbl = this.startMode == 0 ? lbl + "from data " : (this.startMode == 1 ? lbl + "from animation " : (this.startMode == 2 ? lbl + "" + this.getStartFixedDate() : lbl + Math.abs(this.startOffsetMinutes) + " minutes before end"));
        if (this.startOffsetMinutes != 0.0 && this.startMode != 3) {
            lbl = lbl + (this.startOffsetMinutes > 0.0 ? "+" : "") + this.startOffsetMinutes + " minutes ";
        }
        lbl = !this.oneLineLabel ? lbl + "<br>" : lbl + "&nbsp;&nbsp;&nbsp;";
        lbl = lbl + " End: ";
        lbl = this.endMode == 0 ? lbl + "from data " : (this.endMode == 1 ? lbl + "from animation " : (this.endMode == 2 ? lbl + "" + this.getEndFixedDate() : lbl + this.endOffsetMinutes + " minutes after start"));
        if (this.endOffsetMinutes != 0.0 && this.endMode != 3) {
            lbl = lbl + (this.endOffsetMinutes > 0.0 ? "+" : "") + this.endOffsetMinutes + " minutes ";
        }
        lbl = lbl + "</html>";
        return lbl;
    }

    public String toString() {
        return this.getLabelText();
    }

    public void setStartMode(int value) {
        this.startMode = value;
    }

    public int getStartMode() {
        return this.startMode;
    }

    public void setEndMode(int value) {
        this.endMode = value;
    }

    public int getEndMode() {
        return this.endMode;
    }

    public void setStartOffsetMinutes(double value) {
        this.startOffsetMinutes = value;
    }

    public double getStartOffsetMinutes() {
        return this.startOffsetMinutes;
    }

    public void setEndOffsetMinutes(double value) {
        this.endOffsetMinutes = value;
    }

    public double getEndOffsetMinutes() {
        return this.endOffsetMinutes;
    }

    public void setStartFixedTime(long value) {
        this.startFixedTime = value;
    }

    public void setStartFixedTime(Date d) {
        this.startFixedTime = d.getTime();
    }

    public void setEndFixedTime(Date d) {
        this.endFixedTime = d.getTime();
    }

    public Date getStartFixedDate() {
        return new Date(this.getStartFixedTime());
    }

    public Date getEndFixedDate() {
        return new Date(this.getEndFixedTime());
    }

    public long getStartFixedTime() {
        if (this.startFixedTime == Long.MAX_VALUE) {
            this.startFixedTime = System.currentTimeMillis();
        }
        return this.startFixedTime;
    }

    public void setEndFixedTime(long value) {
        this.endFixedTime = value;
    }

    public long getEndFixedTime() {
        if (this.endFixedTime == Long.MAX_VALUE) {
            this.endFixedTime = System.currentTimeMillis();
        }
        return this.endFixedTime;
    }
}

