/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.data;

import java.util.ArrayList;
import java.util.List;
import ucar.unidata.data.DataSource;

public class DataSourceResults {
    private List successDataSources = new ArrayList();
    private List successDefiningObjects = new ArrayList();
    private List failedExceptions = new ArrayList();
    private List failedDefiningObjects = new ArrayList();

    public DataSourceResults() {
    }

    public DataSourceResults(DataSource dataSource, Object definingObject) {
        this.addSuccess(dataSource, definingObject);
    }

    public DataSourceResults(Object failedDefiningObject, Throwable exc) {
        this.addFailed(failedDefiningObject, exc);
    }

    public void merge(DataSourceResults results) {
        this.successDataSources.addAll(results.successDataSources);
        this.successDefiningObjects.addAll(results.successDefiningObjects);
        this.failedExceptions.addAll(results.failedExceptions);
        this.failedDefiningObjects.addAll(results.failedDefiningObjects);
    }

    public List getDataSources() {
        return this.successDataSources;
    }

    public List getSuccessData() {
        return this.successDefiningObjects;
    }

    public List getExceptions() {
        return this.failedExceptions;
    }

    public List getFailedData() {
        return this.failedDefiningObjects;
    }

    public boolean anyFailed() {
        return this.failedDefiningObjects.size() > 0;
    }

    public boolean anyOk() {
        return this.successDefiningObjects.size() > 0;
    }

    public boolean allFailed() {
        return this.failedDefiningObjects.size() > 0 && this.successDataSources.size() == 0;
    }

    public boolean allOk() {
        return this.failedDefiningObjects.size() == 0;
    }

    public void addSuccess(DataSource dataSource, Object definingObject) {
        this.successDataSources.add(dataSource);
        this.successDefiningObjects.add(definingObject);
    }

    public void addFailed(Object definingObject, Throwable exception) {
        this.failedDefiningObjects.add(definingObject);
        this.failedExceptions.add(exception);
    }

    public String toString() {
        return "Failed: " + this.failedDefiningObjects + "\nSuccess:" + this.successDataSources;
    }
}

